/* -*- Mode: C; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 8 -*- */

/*
 *  Medusa
 *
 *  Copyright (C) 2000 Eazel, Inc.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Author: Rebecca Schulman <rebecka@eazel.com>
 */

#ifndef MEDUSA_SEARCH_URI_H
#define MEDUSA_SEARCH_URI_H

#include <glib.h>

#include "medusa-master-db.h"
#include "medusa-file-index.h"
#include "medusa-uri-list.h"
#include "medusa-query-clauses.h"

typedef struct MedusaClauseClosure MedusaClauseClosure;

/* FIXME:  Should we use get and set functions here instead of the
   definition in the header? */
struct MedusaClauseClosure {
	MedusaQueryFunc query_func;
        MedusaFileSystemDB *file_system_db;
        MedusaURIList *uri_list;


        MedusaArgumentType argument_type;
        gpointer argument;
        gboolean is_content_request;
        char *content_request;
        gboolean inclusion_query;
};





gboolean              medusa_uri_is_search_uri                        (char *uri);

GList *               medusa_search_uri_to_clause_closures            (char *search_uri,
                                                                       MedusaMasterDB *master_db);

gboolean              medusa_clause_closure_is_content_search         (gpointer data,
                                                                       gpointer use_data);

/* Add a criteria to the search uri to only return files a user can read,
   if one does not exist */
char *                medusa_search_uri_add_user_can_read             (char *search_uri,
                                                                       int uid);

gboolean              medusa_search_uri_contains_content_requests     (char *search_uri);

void                  medusa_clause_closure_free                      (MedusaClauseClosure *closure);
#endif /* MEDUSA_SEARCH_URI_H */
