/* -*- Mode: C; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 8 -*- */

/*
 *  Medusa
 *
 *  Copyright (C) 2000 Eazel, Inc.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Author: Rebecca Schulman <rebecka@eazel.com>
 *
 *  medusa-text-index-queries.c  Builds and performs queries on a medusa
 *  text index
 *
 */

#include <glib.h>
#include <string.h>

#include "medusa-query-clauses.h"
#include "medusa-text-index.h"
#include "medusa-text-index-private.h"
#include "medusa-text-index-queries.h"


gint32 *           
medusa_text_index_word_to_uri_numbers  (MedusaTextIndex *text_index,
                                        char *word,
                                        int *number_of_results)
{
        MedusaToken word_token;
        int begin_cell, end_cell;
        gint32 *result_array;
        char* location_data;

        /* If the word is not in the text index, just return nothing: */
        if (!medusa_string_has_token (text_index->semantic_units,
                                       word)) {
                *number_of_results = 0;
                return NULL;
        }

        /* Translate the word to a word number */
        word_token = medusa_string_to_token (text_index->semantic_units,
                                             word);
        /* Next look up the address of where locations for the word are stored,
         using the word number */
        begin_cell = medusa_text_index_read_start_location_from_location_file (text_index,
                                                                               word_token);
        printf ("Begin location for word %s is %d\n", word, begin_cell);
        end_cell = medusa_text_index_read_end_location_from_location_file (text_index,
                                                                           word_token);
        printf ("End location for word %s is %d\n", word, end_cell);
        g_assert (end_cell > begin_cell);

        result_array = g_new0 (gint32, end_cell - begin_cell);

        location_data = medusa_io_handler_get_data_region (text_index->locations_index);
        memcpy (result_array, location_data + begin_cell * sizeof (gint32), 
                (end_cell - begin_cell) * sizeof (gint32));

        *number_of_results = end_cell - begin_cell;

        return result_array;
}


 
