/* Mergeant
 *
 * Copyright (C) 1999 - 2004 Vivien Malerba
 * Copyright (C) 2002 - 2004 Rodrigo Moya
 *
 * Authors:
 *       Vivien Malerba <malerba@gnome-db.org>
 *       Rodrigo Moya <rodrigo@gnome-db.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include <libgnomedb/libgnomedb.h>
#include "workspace-window.h"
#include "component-factory.h"
#include "session.h"

static void
open_workspace_cb (gpointer user_data)
{
	GtkWidget *window;

	window = workspace_window_new ();
	if (!window)
		gnome_db_main_quit ();
}

int
main (int argc, char *argv[])
{
	/* initialize i18n */
#ifdef ENABLE_NLS
        setlocale (LC_ALL, "");
        bindtextdomain (GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
        bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
        textdomain (GETTEXT_PACKAGE);
#endif

	/* initialize libraries */
	gnome_db_init (PACKAGE, VERSION, argc, argv);

	/* initialize application modules */
	session_setup ();
	component_factory_init ();

	/* run application */
	gnome_db_main_run ((GdaInitFunc) open_workspace_cb, NULL);

	/* cleanup */
	component_factory_finalize ();

	return 0;
}
