/* data-handler.h
 *
 * Copyright (C) 2002 Vivien Malerba
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef __DATA_HANDLER__
#define __DATA_HANDLER__

#include <gnome.h>
#include <libgda/libgda.h>
#include <gmodule.h>


G_BEGIN_DECLS

#define DATA_HANDLER_TYPE          (data_handler_get_type())
#define DATA_HANDLER(obj)          G_TYPE_CHECK_INSTANCE_CAST (obj, data_handler_get_type(), DataHandler)
#define DATA_HANDLER_CLASS(klass)  G_TYPE_CHECK_CLASS_CAST (klass, data_handler_get_type (), DataHandlerClass)
#define IS_DATA_HANDLER(obj)       G_TYPE_CHECK_INSTANCE_TYPE (obj, data_handler_get_type ())


typedef struct _DataHandler      DataHandler;
typedef struct _DataHandlerClass DataHandlerClass;
typedef struct _DataHandlerPriv  DataHandlerPriv;

/* struct for the object's data */
struct _DataHandler
{
	GObject          object;

	DataHandlerPriv   *priv;
};

/* struct for the object's class */
struct _DataHandlerClass
{
	GObjectClass       parent_class;
};

/* 
 * basic object methods
 */
guint             data_handler_get_type               (void);
GObject          *data_handler_new                    ();
void              data_handler_init_plugin            (DataHandler *dh, GModule *lib, const gchar * plugin_file);

/*
 * Handler's main functionnalities
 */
GtkWidget        *data_handler_get_widget_from_value  (DataHandler * dh, const GdaValue * value);
GdaValue         *data_handler_get_value_from_widget  (DataHandler * dh, GtkWidget *widget);
void              data_handler_widget_update          (DataHandler * dh, GtkWidget * wid, 
						       const GdaValue * value, gboolean value_as_init);
gchar            *data_handler_get_sql_from_value     (DataHandler * dh, const GdaValue * value);
gchar            *data_handler_get_str_from_value     (DataHandler * dh, const GdaValue * value);

/*
 * Getting information 
 */
guint             data_handler_get_nb_gda_type        (DataHandler * dh);
GdaValueType      data_handler_get_gda_type           (DataHandler * dh, guint index);

const gchar      *data_handler_get_descr              (DataHandler * dh);
const gchar      *data_handler_get_descr_detail       (DataHandler * dh);
const gchar      *data_handler_get_version            (DataHandler * dh);
gboolean          data_handler_is_plugin              (DataHandler * dh);
const gchar      *data_handler_get_plugin_name        (DataHandler * dh);
const gchar      *data_handler_get_plugin_file        (DataHandler * dh);
gboolean          data_handler_get_expand             (DataHandler * dh);

gchar            *data_handler_get_key                (DataHandler * dh);

G_END_DECLS

#endif
