/*
 *
 * mtm-ext-selector.c :
 *
 * Copyright (C) 2000-2001 Ximian, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 *
 * Authors: Richard Hestilow <hestgray@ionet.net>
 *
 */

#include "mtm-view-extensions-selector.h"
#include <gal/e-table/e-table-simple.h>
#include <gtk/gtkclist.h>
#include <config.h>
#include <gnome.h>

#define CHECK_WIDTH 20
#define FILENAME_WIDTH 100
#define TYPE_WIDTH FILENAME_WIDTH

static ETableClass *mtm_ext_selector_parent_class;

struct _MtmExtSelectorPrivate
{
	GList *exts;
	int len;
	MtmExtSelectorOptions options;
	ETableModel *etm;
};

enum
{
	ARG_0,
	ARG_OPTIONS
};

static void mtm_ext_selector_set_arg (GtkObject *object, GtkArg *arg, guint arg_id);
static void mtm_ext_selector_get_arg (GtkObject *object, GtkArg *arg, guint arg_id);

/* Model callbacks */
static int model_col_count (ETableModel *etc, void *data);
static int model_row_count (ETableModel *etc, void *data);
static void* model_value_at (ETableModel *etc, int col, int row, void *data);
static void model_set_value_at (ETableModel *etc, int col, int row,
	const void *val, void *data);
static gboolean model_is_cell_editable (ETableModel *etc, int col, int row,
	void *data);
static void* model_duplicate_value (ETableModel *etc, int col,
	const void *value, void *data);
static void model_free_value (ETableModel *etc, int col, void *value,
	void *data);
static void* model_initialize_value (ETableModel *etc, int col, void *data);
static gboolean model_value_is_empty (ETableModel *etc, int col,
	const void *value, void *data);
static char* model_value_to_string (ETableModel *etc, int col,
	const void *value, void *data);


static void
mtm_ext_selector_destroy (GtkObject *object)
{
	MtmExtSelector *sel = MTM_EXT_SELECTOR (object);

	g_list_free (sel->priv->exts);

	g_free (sel->priv);

	if (GTK_OBJECT_CLASS(mtm_ext_selector_parent_class)->destroy)
		(*GTK_OBJECT_CLASS(mtm_ext_selector_parent_class)->destroy)(object);
}

static void
mtm_ext_selector_class_init (GtkObjectClass *object_class)
{
	mtm_ext_selector_parent_class = gtk_type_class (e_table_get_type ());
	
	object_class->set_arg = mtm_ext_selector_set_arg;
	object_class->get_arg = mtm_ext_selector_get_arg;

	gtk_object_add_arg_type ("MtmExtSelector::options", GTK_TYPE_ENUM,
		GTK_ARG_READWRITE, ARG_OPTIONS);

	object_class->destroy = mtm_ext_selector_destroy;
}

static void
mtm_ext_selector_init (GtkObject *object)
{
	MtmExtSelector *sel = MTM_EXT_SELECTOR (object);
	//int widths[] = { CHECK_WIDTH, FILENAME_WIDTH, TYPE_WIDTH, URL_WIDTH, -1};

//	gtk_scrolled_window_set_hadjustment (GTK_SCROLLED_WINDOW (sel),
//		NULL);
//	gtk_scrolled_window_set_vadjustment (GTK_SCROLLED_WINDOW (sel),
//		NULL);

	sel->priv = g_new0 (MtmExtSelectorPrivate, 1);
	sel->priv->exts = NULL;
	sel->priv->len = 0;
	sel->priv->options = MTM_EXT_SELECTOR_FILENAME | MTM_EXT_SELECTOR_TYPE;
		
	sel->priv->etm = e_table_simple_new (model_col_count,
		model_row_count, model_value_at, model_set_value_at,
		model_is_cell_editable, model_duplicate_value,
		model_free_value, model_initialize_value,
		model_value_is_empty, model_value_to_string,
		sel);
	
//	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (sel),
//		GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
/*	
	for (i = 0; widths[i] != -1; i++)
		gtk_clist_set_column_width (sel->priv->clist, i, widths[i]);

	gtk_clist_set_selection_mode (sel->priv->clist, GTK_SELECTION_BROWSE);

	gtk_signal_connect (GTK_OBJECT (sel->priv->clist), "select-row",
		row_selected, sel);
	gtk_signal_connect (GTK_OBJECT (sel->priv->clist), "click-column",
		column_clicked, sel);*/
}

GtkType
mtm_ext_selector_get_type (void)
{
	static GtkType type = 0;

	if (!type)
	{
		GtkTypeInfo info =
		{
			"MtmExtSelector",
			sizeof (MtmExtSelector),
			sizeof (MtmExtSelectorClass),
			(GtkClassInitFunc) mtm_ext_selector_class_init,
			(GtkObjectInitFunc) mtm_ext_selector_init,
			NULL,
			NULL
		};

		type = gtk_type_unique (
			e_table_get_type (), &info);
	}

	return type;
}

GtkWidget*
mtm_ext_selector_new (void)
{
	MtmExtSelector *sel = gtk_type_new (mtm_ext_selector_get_type ());
	gchar *titles[] = { NULL, N_("File"), N_("Type"), NULL};
	int i;
	gchar *skel, *spec;

	for (i = 1; titles[i] != NULL; i++)
		titles[i] = gettext (titles[i]);

/* should be done in a loop, bite me */
	skel =
"<ETableSpecification cursor-mode=\"line\" selection-mode=\"browse\" draw-focus=\"true\"> 
  <ETableColumn model_col=\"0\" draw_grid=\"true\" _title=\"%s\" expansion=\"1.0\" resizable=\"true\" cell=\"string\" compare=\"string\"/>
  <ETableColumn model_col=\"1\" draw_grid=\"true\" _title=\"%s\" expansion=\"1.0\" resizable=\"true\" cell=\"string\" compare=\"string\"/>
  <ETableColumn model_col=\"2\" draw_grid=\"true\" _title=\"%s\" expansion=\"0.0\" minimum_width=\"20\" resizable=\"false\" cell=\"checkbox\" compare=\"integer\"/>
  <ETableState>
    <column source=\"2\"/>
    <column source=\"0\"/>
    <column source=\"1\"/>
    <grouping>
    </grouping>
  </ETableState>
</ETableSpecification>";

	spec = g_strdup_printf (skel,
		titles[1], 
		titles[2],
		"Use");
	g_assert (e_table_construct (E_TABLE (sel), sel->priv->etm, 
		NULL, spec, NULL) != NULL);
	
	g_free (spec);
	g_assert (E_IS_TABLE_MODEL (sel->priv->etm));
	return GTK_WIDGET (sel);
}

static void
mtm_ext_selector_set_arg (GtkObject *object, GtkArg *arg, guint arg_id)
{
	MtmExtSelector *sel = MTM_EXT_SELECTOR (object);

	switch (arg_id)
	{
		case ARG_OPTIONS:
			mtm_ext_selector_set_options (sel, 
				GTK_VALUE_ENUM (*arg));
			break;
	}
}

static void
mtm_ext_selector_get_arg (GtkObject *object, GtkArg *arg, guint arg_id)
{
	MtmExtSelector *sel = MTM_EXT_SELECTOR (object);

	switch (arg_id)
	{
		case ARG_OPTIONS:
			GTK_VALUE_ENUM (*arg) = mtm_ext_selector_get_options (sel);
	}
}

void
mtm_ext_selector_add_ext (MtmExtSelector *sel, MtmExt *ext, gboolean enabled)	
{
	g_return_if_fail (MTM_IS_EXT_SELECTOR (sel));
	g_return_if_fail (MTM_IS_EXT (ext));

	sel->priv->exts = g_list_append (sel->priv->exts, ext);
	sel->priv->len++;

	e_table_model_row_inserted (E_TABLE_MODEL (sel->priv->etm), sel->priv->len - 1);
}

void
mtm_ext_selector_remove_ext (MtmExtSelector *sel, MtmExt *ext)	
{
	GList *l, *l2;
	int n = 0;
	
	g_return_if_fail (MTM_IS_EXT_SELECTOR (sel));
	g_return_if_fail (MTM_IS_EXT (ext));

	l = sel->priv->exts;
	
	while (l)
	{
		l2 = l->next;
		if (l->data == ext)
		{
			g_list_remove_link (sel->priv->exts, l);
			e_table_model_row_deleted (E_TABLE_MODEL (sel->priv->etm), n);
		}
		l = l2;
		n++;
	}
}

void
mtm_ext_selector_ext_toggled (MtmExtSelector *sel, MtmExt *ext)
{
	int retval = -1;
	int n = 0;
	GList *l;
	
	g_return_if_fail (MTM_IS_EXT_SELECTOR (sel));
	g_return_if_fail (MTM_IS_EXT (ext));
	
	l = g_list_find (sel->priv->exts, ext);
	g_return_if_fail (l != NULL);
	
	if (retval == -1)
		return;
	
	l = sel->priv->exts;
	while (l)
	{
	//	if (l->data == ext)
	//		clist_toggle_state (sel, n, retval);
	//		FIXME
		n++;
		l = l->next;
	}
}	

MtmExtSelectorOptions mtm_ext_selector_get_options (MtmExtSelector *sel)
{
	g_return_val_if_fail (MTM_IS_EXT_SELECTOR (sel), 0);
	
	return sel->priv->options;
}

void mtm_ext_selector_set_options (MtmExtSelector *sel, MtmExtSelectorOptions options)
{
	gchar *statev[5] = { NULL, NULL, NULL, NULL, NULL };
	gchar *statestr;
	int i = 0;
	/*gboolean cols[3] = { FALSE, FALSE, FALSE };
	gchar *colspec[6];
	int i;
	gchar *spec;*/

	g_return_if_fail (MTM_IS_EXT_SELECTOR (sel));
	sel->priv->options = options;

	statev[i++] = "<ETableState> <column source=\"2\"/>";
	if (options & MTM_EXT_SELECTOR_FILENAME)
		statev[i++] = "<column source=\"0\"/>";
	if (options & MTM_EXT_SELECTOR_EXT_TYPE)
		statev[i++] = "<column source=\"1\"/>";
	statev[i++] = "<grouping/></ETableState>";

	statestr = g_strjoinv ("", statev);
	e_table_set_state (E_TABLE (sel), statestr);
	g_free (statestr);
#if 0
	if (options & MTM_EXT_SELECTOR_FILENAME)
		cols[0] = TRUE;
	if (options & MTM_EXT_SELECTOR_EXT_TYPE)
		cols[1] = TRUE;
	if (options & MTM_EXT_SELECTOR_URL)
		cols[2] = TRUE;
	
	for (i = 0; i < 6; i++) colspec[i] = NULL;

	colspec[0] = g_strdup ("<ETableSpecification> <columns-shown> ");
	for (i = 0; i < 3; i++)
	{
		if (cols[i])
			colspec[i+1] = g_strdup_printf ("<column> %i </column> ", i+1);
		else
			colspec[i+1] = g_strdup ("");
	}
	colspec = g_strjoinv ("", colspec);
#endif	
}

void
mtm_ext_selector_clear (MtmExtSelector *sel)
{
	g_return_if_fail (MTM_IS_EXT_SELECTOR (sel));

	if (sel->priv->exts)
	{
		g_list_free (sel->priv->exts);
		sel->priv->exts = NULL;
		sel->priv->len = 0;
	}
	
	e_table_model_changed (E_TABLE_MODEL (sel->priv->etm));
}

static int
model_col_count (ETableModel *etc, void *data)
{
	return 3;
}

static int
model_row_count (ETableModel *etc, void *data)
{
	MtmExtSelector *sel = MTM_EXT_SELECTOR (data);
	
	return sel->priv->len;
}

static void *
model_value_at (ETableModel *etc, int col, int row, void *data)
{
	MtmExtSelector *sel = MTM_EXT_SELECTOR (data);
	MtmExt *ext;
	gchar *val = NULL;

	ext = g_list_nth_data (sel->priv->exts, row);
	g_return_val_if_fail (ext != NULL, NULL);

	switch (col) {
		case 0:
			val = ext->file;
			break;
		case 1: 
			if (ext->handler && MTM_HANDLER (ext->handler)->desc)
				val = MTM_HANDLER (ext->handler)->desc;
			else
				val = ext->type;
			break;
		case 2:
			val = GINT_TO_POINTER (ext->activate);
			break;
	}
	return val;
}

static void
model_set_value_at (ETableModel *etc, int col, int row, const void *val,
	void *data)
{
	MtmExtSelector *sel;
	MtmExt *ext;
	
	g_assert (col == 2);
	
	sel = MTM_EXT_SELECTOR (data);
	ext = g_list_nth_data (sel->priv->exts, row);
	g_return_if_fail (ext != NULL);

	mtm_ext_set_activate (ext, GPOINTER_TO_INT (val));
}

static gboolean
model_is_cell_editable (ETableModel *etc, int col, int row, void *data)
{
	return (col == 2);
}

static void *
model_duplicate_value (ETableModel *etc, int col, const void *value,
	void *data)
{
	if (col == 2)
	{
		int tmp = GPOINTER_TO_INT (value);
		return GINT_TO_POINTER (tmp);
	}
	else
		return g_strdup (value);
}

static void
model_free_value (ETableModel *etc, int col, void *value, void *data)
{
	g_free (value);
}

static void *
model_initialize_value (ETableModel *etc, int col, void *data)
{
	if (col == 2)
		return GINT_TO_POINTER (0);
	else
		return g_strdup ("");
}

static gboolean
model_value_is_empty (ETableModel *etc, int col, const void *value,
	void *data)
{
	return !(value && ((gchar*)value) != "");
}

static char *
model_value_to_string (ETableModel *etc, int col, const void *value,
	void *data)
{
	return g_strdup (value);
}
