
#include <src/SerialConnection.h>
#include <termios.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/ioctl.h>
#include <glib/gi18n-lib.h>




struct _moserialSerialConnectionPrivate {
	gboolean connected;
	struct termios newtio;
	struct termios restoretio;
	gint m_fd;
	GIOChannel* IOChannelFd;
	gint flags;
	guint* sourceId;
	gboolean localEcho;
};

#define MOSERIAL_SERIAL_CONNECTION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), MOSERIAL_TYPE_SERIAL_CONNECTION, moserialSerialConnectionPrivate))
enum  {
	MOSERIAL_SERIAL_CONNECTION_DUMMY_PROPERTY
};
static gboolean _moserial_serial_connection_readBytes_gio_func (GIOChannel* source, GIOCondition condition, gpointer self);
static guint* _uint_dup (guint* self);
static gboolean moserial_serial_connection_readBytes (moserialSerialConnection* self, GIOChannel* source, GIOCondition condition);
static void moserial_serial_connection_applySettings (moserialSerialConnection* self, Settings* settings);
static gpointer moserial_serial_connection_parent_class = NULL;
static void moserial_serial_connection_finalize (GObject* obj);


static void g_cclosure_user_marshal_VOID__POINTER_INT_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);


GType moserial_serial_connection_line_end_get_type (void) {
	static GType moserial_serial_connection_line_end_type_id = 0;
	if (G_UNLIKELY (moserial_serial_connection_line_end_type_id == 0)) {
		static const GEnumValue values[] = {{MOSERIAL_SERIAL_CONNECTION_LINE_END_CRLF, "MOSERIAL_SERIAL_CONNECTION_LINE_END_CRLF", "crlf"}, {MOSERIAL_SERIAL_CONNECTION_LINE_END_CR, "MOSERIAL_SERIAL_CONNECTION_LINE_END_CR", "cr"}, {MOSERIAL_SERIAL_CONNECTION_LINE_END_LF, "MOSERIAL_SERIAL_CONNECTION_LINE_END_LF", "lf"}, {MOSERIAL_SERIAL_CONNECTION_LINE_END_TAB, "MOSERIAL_SERIAL_CONNECTION_LINE_END_TAB", "tab"}, {MOSERIAL_SERIAL_CONNECTION_LINE_END_NONE, "MOSERIAL_SERIAL_CONNECTION_LINE_END_NONE", "none"}, {0, NULL, NULL}};
		moserial_serial_connection_line_end_type_id = g_enum_register_static ("moserialSerialConnectionLineEnd", values);
	}
	return moserial_serial_connection_line_end_type_id;
}


static gboolean _moserial_serial_connection_readBytes_gio_func (GIOChannel* source, GIOCondition condition, gpointer self) {
	return moserial_serial_connection_readBytes (self, source, condition);
}


static guint* _uint_dup (guint* self) {
	guint* dup;
	dup = g_new0 (guint, 1);
	memcpy (dup, self, sizeof (guint));
	return dup;
}


gboolean moserial_serial_connection_doConnect (moserialSerialConnection* self, Settings* settings) {
	gint n;
	GIOChannel* _tmp1;
	guint* _tmp4;
	guint* _tmp3;
	guint _tmp2;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (settings != NULL, FALSE);
	if (settings_get_accessMode (settings) == SETTINGS_ACCESS_MODE_READWRITE) {
		self->priv->flags = O_RDWR;
	} else {
		if (settings_get_accessMode (settings) == SETTINGS_ACCESS_MODE_READONLY) {
			self->priv->flags = O_RDONLY;
		} else {
			self->priv->flags = O_WRONLY;
		}
	}
	self->priv->m_fd = open (settings_get_device (settings), (self->priv->flags | O_NDELAY) | O_NONBLOCK, 0);
	if (self->priv->m_fd < 0) {
		self->priv->m_fd = -1;
		/* TODO display error in gui*/
		return FALSE;
	}
	tcflush (self->priv->m_fd, TCIOFLUSH);
	n = fcntl (self->priv->m_fd, F_GETFL);
	fcntl (self->priv->m_fd, F_SETFL, (gulong) (n & (~O_NDELAY)));
	tcgetattr (self->priv->m_fd, &self->priv->restoretio);
	moserial_serial_connection_applySettings (self, settings);
	tcsetattr (self->priv->m_fd, TCSANOW, &self->priv->newtio);
	self->priv->connected = TRUE;
	_tmp1 = NULL;
	self->priv->IOChannelFd = (_tmp1 = g_io_channel_unix_new (self->priv->m_fd), (self->priv->IOChannelFd == NULL) ? NULL : (self->priv->IOChannelFd = (g_io_channel_unref (self->priv->IOChannelFd), NULL)), _tmp1);
	self->priv->sourceId = (_tmp4 = (_tmp3 = (_tmp2 = g_io_add_watch (self->priv->IOChannelFd, G_IO_IN, _moserial_serial_connection_readBytes_gio_func, self), &_tmp2), (_tmp3 == NULL) ? NULL : _uint_dup (_tmp3)), (self->priv->sourceId == NULL) ? NULL : (self->priv->sourceId = (g_free (self->priv->sourceId), NULL)), _tmp4);
	self->priv->localEcho = settings_get_localEcho (settings);
	return TRUE;
}


void moserial_serial_connection_sendByte (moserialSerialConnection* self, guchar byte) {
	g_return_if_fail (self != NULL);
	if (self->priv->connected) {
		guchar* _tmp0;
		gint b_size;
		gint b_length1;
		guchar* b;
		gsize x;
		_tmp0 = NULL;
		b = (_tmp0 = g_new0 (guchar, 1), b_length1 = 1, b_size = b_length1, _tmp0);
		b[0] = byte;
		x = (gsize) write (self->priv->m_fd, b, (gsize) 1);
		/*POSIX.Termios.drain(m_fd);*/
		self->tx = self->tx + x;
		b = (g_free (b), NULL);
	}
}


void moserial_serial_connection_sendBytes (moserialSerialConnection* self, gchar* bytes, int bytes_length1, gsize size) {
	g_return_if_fail (self != NULL);
	if (self->priv->connected) {
		gsize x;
		x = (gsize) write (self->priv->m_fd, bytes, size);
		tcdrain (self->priv->m_fd);
		self->tx = self->tx + x;
	}
}


char* moserial_serial_connection_getLineEnd (moserialSerialConnection* self, gint e) {
	char* s;
	g_return_val_if_fail (self != NULL, NULL);
	s = NULL;
	switch (e) {
		case MOSERIAL_SERIAL_CONNECTION_LINE_END_CR:
		{
			{
				char* _tmp0;
				_tmp0 = NULL;
				s = (_tmp0 = g_strdup ("\r"), s = (g_free (s), NULL), _tmp0);
				break;
			}
		}
		case MOSERIAL_SERIAL_CONNECTION_LINE_END_LF:
		{
			{
				char* _tmp1;
				_tmp1 = NULL;
				s = (_tmp1 = g_strdup ("\n"), s = (g_free (s), NULL), _tmp1);
				break;
			}
		}
		case MOSERIAL_SERIAL_CONNECTION_LINE_END_CRLF:
		{
			{
				char* _tmp2;
				_tmp2 = NULL;
				s = (_tmp2 = g_strdup ("\r\n"), s = (g_free (s), NULL), _tmp2);
				break;
			}
		}
		case MOSERIAL_SERIAL_CONNECTION_LINE_END_TAB:
		{
			{
				char* _tmp3;
				_tmp3 = NULL;
				s = (_tmp3 = g_strdup ("\t"), s = (g_free (s), NULL), _tmp3);
				break;
			}
		}
		default:
		{
			{
				char* _tmp4;
				_tmp4 = NULL;
				s = (_tmp4 = g_strdup (""), s = (g_free (s), NULL), _tmp4);
				break;
			}
		}
	}
	return s;
}


void moserial_serial_connection_doDisconnect (moserialSerialConnection* self) {
	GError * inner_error;
	g_return_if_fail (self != NULL);
	inner_error = NULL;
	if (self->priv->connected) {
		guint* _tmp0;
		GIOChannel* _tmp1;
		char* _tmp2;
		char* _tmp3;
		g_source_remove (*self->priv->sourceId);
		self->priv->sourceId = (_tmp0 = NULL, (self->priv->sourceId == NULL) ? NULL : (self->priv->sourceId = (g_free (self->priv->sourceId), NULL)), _tmp0);
		{
			g_io_channel_shutdown (self->priv->IOChannelFd, TRUE, &inner_error);
			if (inner_error != NULL) {
				if (inner_error->domain == G_IO_CHANNEL_ERROR) {
					goto __catch6_g_io_channel_error;
				}
				goto __finally6;
			}
		}
		goto __finally6;
		__catch6_g_io_channel_error:
		{
			GError * e;
			e = inner_error;
			inner_error = NULL;
			{
				g_warning ("SerialConnection.vala:112: %s", e->message);
				(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
			}
		}
		__finally6:
		if (inner_error != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
			g_clear_error (&inner_error);
			return;
		}
		_tmp1 = NULL;
		self->priv->IOChannelFd = (_tmp1 = NULL, (self->priv->IOChannelFd == NULL) ? NULL : (self->priv->IOChannelFd = (g_io_channel_unref (self->priv->IOChannelFd), NULL)), _tmp1);
		self->priv->connected = FALSE;
		self->forced_hex_view = FALSE;
		self->lastRxCharWasCR = FALSE;
		self->tx = self->rx = self->nonprintable = (gulong) 0;
		_tmp2 = NULL;
		self->echoReference = (_tmp2 = g_strdup (""), self->echoReference = (g_free (self->echoReference), NULL), _tmp2);
		_tmp3 = NULL;
		self->echoCompare = (_tmp3 = g_strdup (""), self->echoCompare = (g_free (self->echoCompare), NULL), _tmp3);
		tcsetattr (self->priv->m_fd, TCSANOW, &self->priv->newtio);
		close (self->priv->m_fd);
	}
}


static gboolean moserial_serial_connection_readBytes (moserialSerialConnection* self, GIOChannel* source, GIOCondition condition) {
	guchar* _tmp0;
	gint m_buf_size;
	gint m_buf_length1;
	guchar* m_buf;
	gint bytesRead;
	gboolean _tmp2;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (source != NULL, FALSE);
	_tmp0 = NULL;
	m_buf = (_tmp0 = g_new0 (guchar, 1000), m_buf_length1 = 1000, m_buf_size = m_buf_length1, _tmp0);
	bytesRead = (gint) read (self->priv->m_fd, m_buf, (gsize) 1000);
	self->rx = self->rx + ((gulong) bytesRead);
	if (bytesRead < 0) {
		gboolean _tmp1;
		return (_tmp1 = FALSE, m_buf = (g_free (m_buf), NULL), _tmp1);
	}
	g_signal_emit_by_name (self, "new-data", m_buf, m_buf_length1, bytesRead);
	if (self->priv->localEcho) {
		moserial_serial_connection_sendBytes (self, (gchar*) m_buf, -1, (gsize) bytesRead);
	}
	return (_tmp2 = self->priv->connected, m_buf = (g_free (m_buf), NULL), _tmp2);
}


static void moserial_serial_connection_applySettings (moserialSerialConnection* self, Settings* settings) {
	guint baudRate;
	gint dataBits;
	gboolean _tmp0;
	gboolean _tmp2;
	gint mcs;
	gboolean _tmp3;
	g_return_if_fail (self != NULL);
	g_return_if_fail (settings != NULL);
	/*BaudRate*/
	baudRate = (guint) 0;
	switch (settings_get_baudRate (settings)) {
		case 300:
		{
			baudRate = B300;
			break;
		}
		case 600:
		{
			baudRate = B600;
			break;
		}
		case 1200:
		{
			baudRate = B1200;
			break;
		}
		case 2400:
		{
			baudRate = B2400;
			break;
		}
		case 4800:
		{
			baudRate = B4800;
			break;
		}
		case 9600:
		{
			baudRate = B9600;
			break;
		}
		case 19200:
		{
			baudRate = B19200;
			break;
		}
		case 38400:
		{
			baudRate = B38400;
			break;
		}
		case 57600:
		{
			baudRate = B57600;
			break;
		}
		case 115200:
		{
			baudRate = B115200;
			break;
		}
		case 230400:
		{
			baudRate = B230400;
			break;
		}
		case 460800:
		{
			baudRate = B460800;
			break;
		}
		case 576000:
		{
			baudRate = B576000;
			break;
		}
		case 921600:
		{
			baudRate = B921600;
			break;
		}
	}
	cfsetospeed (&self->priv->newtio, baudRate);
	cfsetispeed (&self->priv->newtio, baudRate);
	/*DataBits*/
	dataBits = 0;
	dataBits = settings_get_dataBits (settings);
	_tmp0 = FALSE;
	if (settings_get_dataBits (settings) == 7) {
		gboolean _tmp1;
		_tmp1 = FALSE;
		if (settings_get_parity (settings) == SETTINGS_PARITY_MARK) {
			_tmp1 = TRUE;
		} else {
			_tmp1 = settings_get_parity (settings) == SETTINGS_PARITY_SPACE;
		}
		_tmp0 = _tmp1;
	} else {
		_tmp0 = FALSE;
	}
	/* We generate mark and space parity*/
	if (_tmp0) {
		dataBits = 8;
	}
	switch (dataBits) {
		case 5:
		{
			self->priv->newtio.c_cflag = (self->priv->newtio.c_cflag & (~CSIZE)) | CS5;
			break;
		}
		case 6:
		{
			self->priv->newtio.c_cflag = (self->priv->newtio.c_cflag & (~CSIZE)) | CS6;
			break;
		}
		case 7:
		{
			self->priv->newtio.c_cflag = (self->priv->newtio.c_cflag & (~CSIZE)) | CS7;
			break;
		}
		default:
		{
			self->priv->newtio.c_cflag = (self->priv->newtio.c_cflag & (~CSIZE)) | CS8;
			break;
		}
	}
	self->priv->newtio.c_cflag = self->priv->newtio.c_cflag | (CLOCAL | CREAD);
	/*Parity*/
	self->priv->newtio.c_cflag = self->priv->newtio.c_cflag & (~(PARENB | PARODD));
	if (settings_get_parity (settings) == SETTINGS_PARITY_EVEN) {
		self->priv->newtio.c_cflag = self->priv->newtio.c_cflag | PARENB;
	} else {
		if (settings_get_parity (settings) == SETTINGS_PARITY_ODD) {
			self->priv->newtio.c_cflag = self->priv->newtio.c_cflag | (PARENB | PARODD);
		}
	}
	self->priv->newtio.c_cflag = self->priv->newtio.c_cflag & (~CRTSCTS);
	/*Stop Bits*/
	if (settings_get_stopBits (settings) == 2) {
		self->priv->newtio.c_cflag = self->priv->newtio.c_cflag | CSTOPB;
	} else {
		self->priv->newtio.c_cflag = self->priv->newtio.c_cflag & (~CSTOPB);
	}
	/*Input Settings*/
	self->priv->newtio.c_iflag = IGNBRK;
	_tmp2 = FALSE;
	if (settings_get_handshake (settings) == SETTINGS_HANDSHAKE_SOFTWARE) {
		_tmp2 = TRUE;
	} else {
		_tmp2 = settings_get_handshake (settings) == SETTINGS_HANDSHAKE_BOTH;
	}
	/*Handshake*/
	if (_tmp2) {
		self->priv->newtio.c_iflag = self->priv->newtio.c_iflag | (IXON | IXOFF);
	} else {
		self->priv->newtio.c_iflag = self->priv->newtio.c_iflag & (~((IXON | IXOFF) | IXANY));
	}
	self->priv->newtio.c_lflag = (guint) 0;
	self->priv->newtio.c_oflag = (guint) 0;
	self->priv->newtio.c_cc[VTIME] = (guchar) 1;
	self->priv->newtio.c_cc[VMIN] = (guchar) 1;
	/*Some other port settings from minicom.
	newtio.c_iflag &= ~(IGNBRK | IGNCR | INLCR | ICRNL | IUCLC | IXANY | IXON | IXOFF | INPCK | ISTRIP);
	newtio.c_iflag &= ~(POSIX.InputMode.IGNBRK | POSIX.InputMode.IGNCR | POSIX.InputMode.INLCR | POSIX.InputMode.ICRNL | POSIX.InputMode.IXANY | POSIX.InputMode.IXON | POSIX.InputMode.IXOFF | POSIX.InputMode.INPCK | POSIX.InputMode.ISTRIP);
	newtio.c_iflag |= (POSIX.InputMode.BRKINT | POSIX.InputMode.IGNPAR);
	newtio.c_oflag &= ~POSIX.OutputMode.OPOST;
	newtio.c_lflag &= ~(XCASE|ECHONL|NOFLSH);*/
	self->priv->newtio.c_lflag = self->priv->newtio.c_lflag & (~(ECHONL | NOFLSH));
	/*newtio.c_lflag &= ~(POSIX.LocalMode.ICANON | POSIX.LocalMode.ISIG | POSIX.LocalMode.ECHO);
	newtio.c_cflag |= CREAD;
	newtio.c_cc[VTIME] = 5;*/
	mcs = 0;
	ioctl (self->priv->m_fd, TIOCMGET, &mcs);
	mcs = mcs | TIOCM_RTS;
	ioctl (self->priv->m_fd, TIOCMSET, &mcs);
	_tmp3 = FALSE;
	if (settings_get_handshake (settings) == SETTINGS_HANDSHAKE_HARDWARE) {
		_tmp3 = TRUE;
	} else {
		_tmp3 = settings_get_handshake (settings) == SETTINGS_HANDSHAKE_BOTH;
	}
	if (_tmp3) {
		self->priv->newtio.c_cflag = self->priv->newtio.c_cflag | CRTSCTS;
	} else {
		self->priv->newtio.c_cflag = self->priv->newtio.c_cflag & (~CRTSCTS);
	}
}


char* moserial_serial_connection_getBytecountbarString (moserialSerialConnection* self) {
	char* r;
	g_return_val_if_fail (self != NULL, NULL);
	r = NULL;
	if (self->nonprintable > 0) {
		char* _tmp0;
		_tmp0 = NULL;
		r = (_tmp0 = g_strdup_printf (_ ("TX: %lu, RX: %lu (%lu unprintable)"), self->tx, self->rx, self->nonprintable), r = (g_free (r), NULL), _tmp0);
	} else {
		char* _tmp1;
		_tmp1 = NULL;
		r = (_tmp1 = g_strdup_printf (_ ("TX: %lu, RX: %lu"), self->tx, self->rx), r = (g_free (r), NULL), _tmp1);
	}
	return r;
}


moserialSerialConnection* moserial_serial_connection_construct (GType object_type) {
	moserialSerialConnection * self;
	self = g_object_newv (object_type, 0, NULL);
	return self;
}


moserialSerialConnection* moserial_serial_connection_new (void) {
	return moserial_serial_connection_construct (MOSERIAL_TYPE_SERIAL_CONNECTION);
}


static void moserial_serial_connection_class_init (moserialSerialConnectionClass * klass) {
	moserial_serial_connection_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (moserialSerialConnectionPrivate));
	G_OBJECT_CLASS (klass)->finalize = moserial_serial_connection_finalize;
	g_signal_new ("new_data", MOSERIAL_TYPE_SERIAL_CONNECTION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__POINTER_INT_INT, G_TYPE_NONE, 3, G_TYPE_POINTER, G_TYPE_INT, G_TYPE_INT);
}


static void moserial_serial_connection_instance_init (moserialSerialConnection * self) {
	self->priv = MOSERIAL_SERIAL_CONNECTION_GET_PRIVATE (self);
	self->tx = (gulong) 0;
	self->rx = (gulong) 0;
	self->nonprintable = (gulong) 0;
	self->forced_hex_view = FALSE;
	self->lastRxCharWasCR = FALSE;
	self->echoReference = g_strdup ("");
	self->echoCompare = g_strdup ("");
	self->priv->m_fd = -1;
	self->priv->flags = 0;
}


static void moserial_serial_connection_finalize (GObject* obj) {
	moserialSerialConnection * self;
	self = MOSERIAL_SERIAL_CONNECTION (obj);
	self->echoReference = (g_free (self->echoReference), NULL);
	self->echoCompare = (g_free (self->echoCompare), NULL);
	(self->priv->IOChannelFd == NULL) ? NULL : (self->priv->IOChannelFd = (g_io_channel_unref (self->priv->IOChannelFd), NULL));
	(self->priv->sourceId == NULL) ? NULL : (self->priv->sourceId = (g_free (self->priv->sourceId), NULL));
	G_OBJECT_CLASS (moserial_serial_connection_parent_class)->finalize (obj);
}


GType moserial_serial_connection_get_type (void) {
	static GType moserial_serial_connection_type_id = 0;
	if (moserial_serial_connection_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (moserialSerialConnectionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) moserial_serial_connection_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (moserialSerialConnection), 0, (GInstanceInitFunc) moserial_serial_connection_instance_init, NULL };
		moserial_serial_connection_type_id = g_type_register_static (G_TYPE_OBJECT, "moserialSerialConnection", &g_define_type_info, 0);
	}
	return moserial_serial_connection_type_id;
}



static void g_cclosure_user_marshal_VOID__POINTER_INT_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__POINTER_INT_INT) (gpointer data1, gpointer arg_1, gint arg_2, gint arg_3, gpointer data2);
	register GMarshalFunc_VOID__POINTER_INT_INT callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__POINTER_INT_INT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_pointer (param_values + 1), g_value_get_int (param_values + 2), g_value_get_int (param_values + 3), data2);
}



