
#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>


#define MOSERIAL_TYPE_HEX_TEXT_BUFFER (moserial_hex_text_buffer_get_type ())
#define MOSERIAL_HEX_TEXT_BUFFER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MOSERIAL_TYPE_HEX_TEXT_BUFFER, moserialHexTextBuffer))
#define MOSERIAL_HEX_TEXT_BUFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MOSERIAL_TYPE_HEX_TEXT_BUFFER, moserialHexTextBufferClass))
#define MOSERIAL_IS_HEX_TEXT_BUFFER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MOSERIAL_TYPE_HEX_TEXT_BUFFER))
#define MOSERIAL_IS_HEX_TEXT_BUFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MOSERIAL_TYPE_HEX_TEXT_BUFFER))
#define MOSERIAL_HEX_TEXT_BUFFER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MOSERIAL_TYPE_HEX_TEXT_BUFFER, moserialHexTextBufferClass))

typedef struct _moserialHexTextBuffer moserialHexTextBuffer;
typedef struct _moserialHexTextBufferClass moserialHexTextBufferClass;
typedef struct _moserialHexTextBufferPrivate moserialHexTextBufferPrivate;

#define TYPE_PREFERENCES (preferences_get_type ())
#define PREFERENCES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PREFERENCES, Preferences))
#define PREFERENCES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PREFERENCES, PreferencesClass))
#define IS_PREFERENCES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PREFERENCES))
#define IS_PREFERENCES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PREFERENCES))
#define PREFERENCES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PREFERENCES, PreferencesClass))

typedef struct _Preferences Preferences;
typedef struct _PreferencesClass PreferencesClass;

struct _moserialHexTextBuffer {
	GtkTextBuffer parent_instance;
	moserialHexTextBufferPrivate * priv;
};

struct _moserialHexTextBufferClass {
	GtkTextBufferClass parent_class;
};

struct _moserialHexTextBufferPrivate {
	GtkTextMark* nextHexMark;
	GtkTextMark* nextCharMark;
	GtkTextTag* addressTag;
	GtkTextTag* oddTag;
	gint hexBytes;
};


static gpointer moserial_hex_text_buffer_parent_class = NULL;

GType moserial_hex_text_buffer_get_type (void);
#define MOSERIAL_HEX_TEXT_BUFFER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), MOSERIAL_TYPE_HEX_TEXT_BUFFER, moserialHexTextBufferPrivate))
enum  {
	MOSERIAL_HEX_TEXT_BUFFER_DUMMY_PROPERTY
};
GType preferences_get_type (void);
const char* preferences_get_highlightColor (Preferences* self);
void moserial_hex_text_buffer_applyPreferences (moserialHexTextBuffer* self, Preferences* preferences);
static void moserial_hex_text_buffer_setup (moserialHexTextBuffer* self);
void moserial_hex_text_buffer_clear (moserialHexTextBuffer* self);
void moserial_hex_text_buffer_add (moserialHexTextBuffer* self, guchar data);
moserialHexTextBuffer* moserial_hex_text_buffer_new (void);
moserialHexTextBuffer* moserial_hex_text_buffer_construct (GType object_type);
static GObject * moserial_hex_text_buffer_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void moserial_hex_text_buffer_finalize (GObject* obj);



void moserial_hex_text_buffer_applyPreferences (moserialHexTextBuffer* self, Preferences* preferences) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (preferences != NULL);
	g_object_set (self->priv->addressTag, "foreground", preferences_get_highlightColor (preferences), NULL);
	g_object_set (self->priv->oddTag, "foreground", preferences_get_highlightColor (preferences), NULL);
}


void moserial_hex_text_buffer_clear (moserialHexTextBuffer* self) {
	g_return_if_fail (self != NULL);
	gtk_text_buffer_delete_mark ((GtkTextBuffer*) self, self->priv->nextHexMark);
	gtk_text_buffer_delete_mark ((GtkTextBuffer*) self, self->priv->nextCharMark);
	gtk_text_buffer_set_text ((GtkTextBuffer*) self, "", 0);
	moserial_hex_text_buffer_setup (self);
}


static void moserial_hex_text_buffer_setup (moserialHexTextBuffer* self) {
	GtkTextIter nextHexIter = {0};
	GtkTextIter nextCharIter = {0};
	GtkTextMark* _tmp0_;
	GtkTextMark* _tmp1_;
	g_return_if_fail (self != NULL);
	gtk_text_buffer_get_end_iter ((GtkTextBuffer*) self, &nextHexIter);
	_tmp0_ = NULL;
	self->priv->nextHexMark = (_tmp0_ = gtk_text_mark_new ("nextHex", TRUE), (self->priv->nextHexMark == NULL) ? NULL : (self->priv->nextHexMark = (g_object_unref (self->priv->nextHexMark), NULL)), _tmp0_);
	gtk_text_buffer_add_mark ((GtkTextBuffer*) self, self->priv->nextHexMark, &nextHexIter);
	nextCharIter = nextHexIter;
	_tmp1_ = NULL;
	self->priv->nextCharMark = (_tmp1_ = gtk_text_mark_new ("nextChar", TRUE), (self->priv->nextCharMark == NULL) ? NULL : (self->priv->nextCharMark = (g_object_unref (self->priv->nextCharMark), NULL)), _tmp1_);
	gtk_text_buffer_add_mark ((GtkTextBuffer*) self, self->priv->nextCharMark, &nextCharIter);
	self->priv->hexBytes = 0;
}


static glong string_get_length (const char* self) {
	glong result;
	g_return_val_if_fail (self != NULL, 0L);
	result = g_utf8_strlen (self, -1);
	return result;
}


void moserial_hex_text_buffer_add (moserialHexTextBuffer* self, guchar data) {
	GtkTextIter nextHexIter = {0};
	GtkTextIter nextCharIter = {0};
	char* incomingHexBuffer;
	char* _tmp5_;
	char* _tmp4_;
	GtkTextIter tempIter = {0};
	char* _tmp6_;
	GtkTextMark* _tmp7_;
	char* _tmp8_;
	gunichar _tmp9_;
	gunichar c;
	char* s;
	gboolean _tmp10_;
	GtkTextMark* _tmp11_;
	g_return_if_fail (self != NULL);
	incomingHexBuffer = g_strdup ("");
	if ((self->priv->hexBytes % 16) == 0) {
		GtkTextIter startIter = {0};
		GtkTextMark* startMark;
		char* _tmp0_;
		GtkTextMark* _tmp1_;
		GtkTextMark* _tmp2_;
		gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &nextCharIter, self->priv->nextCharMark);
		startMark = gtk_text_mark_new ("startMark", TRUE);
		gtk_text_buffer_add_mark ((GtkTextBuffer*) self, startMark, &nextCharIter);
		_tmp0_ = NULL;
		gtk_text_buffer_insert ((GtkTextBuffer*) self, &nextCharIter, _tmp0_ = g_strdup_printf ("\n%08x", (guint) self->priv->hexBytes), 9);
		_tmp0_ = (g_free (_tmp0_), NULL);
		gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &startIter, startMark);
		gtk_text_buffer_apply_tag_by_name ((GtkTextBuffer*) self, "hex_address", &startIter, &nextCharIter);
		gtk_text_buffer_delete_mark ((GtkTextBuffer*) self, startMark);
		gtk_text_buffer_insert ((GtkTextBuffer*) self, &nextCharIter, " ", 1);
		gtk_text_buffer_delete_mark ((GtkTextBuffer*) self, self->priv->nextHexMark);
		nextHexIter = nextCharIter;
		_tmp1_ = NULL;
		self->priv->nextHexMark = (_tmp1_ = gtk_text_mark_new ("nextHex", TRUE), (self->priv->nextHexMark == NULL) ? NULL : (self->priv->nextHexMark = (g_object_unref (self->priv->nextHexMark), NULL)), _tmp1_);
		gtk_text_buffer_add_mark ((GtkTextBuffer*) self, self->priv->nextHexMark, &nextHexIter);
		gtk_text_buffer_insert ((GtkTextBuffer*) self, &nextCharIter, "                                                   ", 51);
		gtk_text_buffer_delete_mark ((GtkTextBuffer*) self, self->priv->nextCharMark);
		_tmp2_ = NULL;
		self->priv->nextCharMark = (_tmp2_ = gtk_text_mark_new ("nextChar", TRUE), (self->priv->nextCharMark == NULL) ? NULL : (self->priv->nextCharMark = (g_object_unref (self->priv->nextCharMark), NULL)), _tmp2_);
		gtk_text_buffer_add_mark ((GtkTextBuffer*) self, self->priv->nextCharMark, &nextCharIter);
		(startMark == NULL) ? NULL : (startMark = (g_object_unref (startMark), NULL));
	} else {
		if ((self->priv->hexBytes % 8) == 0) {
			GtkTextIter tempIter = {0};
			GtkTextMark* _tmp3_;
			gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &nextHexIter, self->priv->nextHexMark);
			gtk_text_buffer_insert ((GtkTextBuffer*) self, &nextHexIter, "  ", 2);
			/*remove space to align chars*/
			tempIter = nextHexIter;
			gtk_text_iter_forward_chars (&tempIter, 2);
			gtk_text_buffer_delete ((GtkTextBuffer*) self, &nextHexIter, &tempIter);
			gtk_text_buffer_delete_mark ((GtkTextBuffer*) self, self->priv->nextHexMark);
			_tmp3_ = NULL;
			self->priv->nextHexMark = (_tmp3_ = gtk_text_mark_new ("nextHex", TRUE), (self->priv->nextHexMark == NULL) ? NULL : (self->priv->nextHexMark = (g_object_unref (self->priv->nextHexMark), NULL)), _tmp3_);
			gtk_text_buffer_add_mark ((GtkTextBuffer*) self, self->priv->nextHexMark, &nextHexIter);
		}
	}
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &nextHexIter, self->priv->nextHexMark);
	_tmp5_ = NULL;
	_tmp4_ = NULL;
	incomingHexBuffer = (_tmp5_ = g_strconcat (incomingHexBuffer, _tmp4_ = g_strdup_printf ("%02X ", (guint) data), NULL), incomingHexBuffer = (g_free (incomingHexBuffer), NULL), _tmp5_);
	_tmp4_ = (g_free (_tmp4_), NULL);
	gtk_text_buffer_insert ((GtkTextBuffer*) self, &nextHexIter, incomingHexBuffer, (gint) string_get_length (incomingHexBuffer));
	/*remove space to align chars*/
	tempIter = nextHexIter;
	gtk_text_iter_forward_chars (&tempIter, 3);
	gtk_text_buffer_delete ((GtkTextBuffer*) self, &nextHexIter, &tempIter);
	/*add odd coloring
	if(((hexBytes+1)%2)==0) {
	                      tempIter.backward_chars(3);
	                      this.apply_tag_by_name("hex_odd", tempIter, nextHexIter);
	                      }*/
	_tmp6_ = NULL;
	incomingHexBuffer = (_tmp6_ = g_strdup (""), incomingHexBuffer = (g_free (incomingHexBuffer), NULL), _tmp6_);
	self->priv->hexBytes++;
	gtk_text_buffer_delete_mark ((GtkTextBuffer*) self, self->priv->nextHexMark);
	_tmp7_ = NULL;
	self->priv->nextHexMark = (_tmp7_ = gtk_text_mark_new ("nextHex", TRUE), (self->priv->nextHexMark == NULL) ? NULL : (self->priv->nextHexMark = (g_object_unref (self->priv->nextHexMark), NULL)), _tmp7_);
	gtk_text_buffer_add_mark ((GtkTextBuffer*) self, self->priv->nextHexMark, &nextHexIter);
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &nextCharIter, self->priv->nextCharMark);
	_tmp8_ = NULL;
	c = (_tmp9_ = g_utf8_get_char (_tmp8_ = g_strdup_printf ("%c", (gint) data)), _tmp8_ = (g_free (_tmp8_), NULL), _tmp9_);
	s = g_strdup_printf ("%c", (gint) data);
	_tmp10_ = FALSE;
	if (g_utf8_validate (s, -1, NULL)) {
		_tmp10_ = g_unichar_isprint (c);
	} else {
		_tmp10_ = FALSE;
	}
	if (_tmp10_) {
		gtk_text_buffer_insert ((GtkTextBuffer*) self, &nextCharIter, s, (gint) string_get_length (s));
	} else {
		gtk_text_buffer_insert ((GtkTextBuffer*) self, &nextCharIter, ".", 1);
	}
	gtk_text_buffer_delete_mark ((GtkTextBuffer*) self, self->priv->nextCharMark);
	_tmp11_ = NULL;
	self->priv->nextCharMark = (_tmp11_ = gtk_text_mark_new ("nextChar", TRUE), (self->priv->nextCharMark == NULL) ? NULL : (self->priv->nextCharMark = (g_object_unref (self->priv->nextCharMark), NULL)), _tmp11_);
	gtk_text_buffer_add_mark ((GtkTextBuffer*) self, self->priv->nextCharMark, &nextCharIter);
	incomingHexBuffer = (g_free (incomingHexBuffer), NULL);
	s = (g_free (s), NULL);
}


moserialHexTextBuffer* moserial_hex_text_buffer_construct (GType object_type) {
	moserialHexTextBuffer * self;
	self = g_object_newv (object_type, 0, NULL);
	return self;
}


moserialHexTextBuffer* moserial_hex_text_buffer_new (void) {
	return moserial_hex_text_buffer_construct (MOSERIAL_TYPE_HEX_TEXT_BUFFER);
}


static GObject * moserial_hex_text_buffer_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	moserialHexTextBufferClass * klass;
	GObjectClass * parent_class;
	moserialHexTextBuffer * self;
	klass = MOSERIAL_HEX_TEXT_BUFFER_CLASS (g_type_class_peek (MOSERIAL_TYPE_HEX_TEXT_BUFFER));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = MOSERIAL_HEX_TEXT_BUFFER (obj);
	{
		GtkTextTag* _tmp1_;
		GtkTextTag* _tmp0_;
		GtkTextTag* _tmp3_;
		GtkTextTag* _tmp2_;
		moserial_hex_text_buffer_setup (self);
		_tmp1_ = NULL;
		_tmp0_ = NULL;
		self->priv->addressTag = (_tmp1_ = (_tmp0_ = gtk_text_buffer_create_tag ((GtkTextBuffer*) self, "hex_address", "foreground", "#2020ff", NULL, NULL), (_tmp0_ == NULL) ? NULL : g_object_ref (_tmp0_)), (self->priv->addressTag == NULL) ? NULL : (self->priv->addressTag = (g_object_unref (self->priv->addressTag), NULL)), _tmp1_);
		_tmp3_ = NULL;
		_tmp2_ = NULL;
		self->priv->oddTag = (_tmp3_ = (_tmp2_ = gtk_text_buffer_create_tag ((GtkTextBuffer*) self, "hex_odd", "foreground", "#2020ff", NULL, NULL), (_tmp2_ == NULL) ? NULL : g_object_ref (_tmp2_)), (self->priv->oddTag == NULL) ? NULL : (self->priv->oddTag = (g_object_unref (self->priv->oddTag), NULL)), _tmp3_);
	}
	return obj;
}


static void moserial_hex_text_buffer_class_init (moserialHexTextBufferClass * klass) {
	moserial_hex_text_buffer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (moserialHexTextBufferPrivate));
	G_OBJECT_CLASS (klass)->constructor = moserial_hex_text_buffer_constructor;
	G_OBJECT_CLASS (klass)->finalize = moserial_hex_text_buffer_finalize;
}


static void moserial_hex_text_buffer_instance_init (moserialHexTextBuffer * self) {
	self->priv = MOSERIAL_HEX_TEXT_BUFFER_GET_PRIVATE (self);
}


static void moserial_hex_text_buffer_finalize (GObject* obj) {
	moserialHexTextBuffer * self;
	self = MOSERIAL_HEX_TEXT_BUFFER (obj);
	(self->priv->nextHexMark == NULL) ? NULL : (self->priv->nextHexMark = (g_object_unref (self->priv->nextHexMark), NULL));
	(self->priv->nextCharMark == NULL) ? NULL : (self->priv->nextCharMark = (g_object_unref (self->priv->nextCharMark), NULL));
	(self->priv->addressTag == NULL) ? NULL : (self->priv->addressTag = (g_object_unref (self->priv->addressTag), NULL));
	(self->priv->oddTag == NULL) ? NULL : (self->priv->oddTag = (g_object_unref (self->priv->oddTag), NULL));
	G_OBJECT_CLASS (moserial_hex_text_buffer_parent_class)->finalize (obj);
}


GType moserial_hex_text_buffer_get_type (void) {
	static GType moserial_hex_text_buffer_type_id = 0;
	if (moserial_hex_text_buffer_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (moserialHexTextBufferClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) moserial_hex_text_buffer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (moserialHexTextBuffer), 0, (GInstanceInitFunc) moserial_hex_text_buffer_instance_init, NULL };
		moserial_hex_text_buffer_type_id = g_type_register_static (GTK_TYPE_TEXT_BUFFER, "moserialHexTextBuffer", &g_define_type_info, 0);
	}
	return moserial_hex_text_buffer_type_id;
}




