
#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gtk/gtk.h>
#include <config.h>
#include <stdio.h>


#define MOSERIAL_TYPE_MAIN (moserial_main_get_type ())
#define MOSERIAL_MAIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MOSERIAL_TYPE_MAIN, moserialMain))
#define MOSERIAL_MAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MOSERIAL_TYPE_MAIN, moserialMainClass))
#define MOSERIAL_IS_MAIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MOSERIAL_TYPE_MAIN))
#define MOSERIAL_IS_MAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MOSERIAL_TYPE_MAIN))
#define MOSERIAL_MAIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MOSERIAL_TYPE_MAIN, moserialMainClass))

typedef struct _moserialMain moserialMain;
typedef struct _moserialMainClass moserialMainClass;
typedef struct _moserialMainPrivate moserialMainPrivate;

#define MOSERIAL_TYPE_MAIN_WINDOW (moserial_main_window_get_type ())
#define MOSERIAL_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MOSERIAL_TYPE_MAIN_WINDOW, moserialMainWindow))
#define MOSERIAL_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MOSERIAL_TYPE_MAIN_WINDOW, moserialMainWindowClass))
#define MOSERIAL_IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MOSERIAL_TYPE_MAIN_WINDOW))
#define MOSERIAL_IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MOSERIAL_TYPE_MAIN_WINDOW))
#define MOSERIAL_MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MOSERIAL_TYPE_MAIN_WINDOW, moserialMainWindowClass))

typedef struct _moserialMainWindow moserialMainWindow;
typedef struct _moserialMainWindowClass moserialMainWindowClass;

struct _moserialMain {
	GObject parent_instance;
	moserialMainPrivate * priv;
};

struct _moserialMainClass {
	GObjectClass parent_class;
};


static char* moserial_main_profileFilename;
static char* moserial_main_profileFilename = NULL;
static gpointer moserial_main_parent_class = NULL;

GType moserial_main_get_type (void);
enum  {
	MOSERIAL_MAIN_DUMMY_PROPERTY
};
GType moserial_main_window_get_type (void);
moserialMainWindow* moserial_main_window_new (GtkBuilder* builder, const char* profileFilename);
moserialMainWindow* moserial_main_window_construct (GType object_type, GtkBuilder* builder, const char* profileFilename);
void moserial_main_window_showWindow (moserialMainWindow* self);
void moserial_main_run (moserialMain* self);
moserialMain* moserial_main_new (void);
moserialMain* moserial_main_construct (GType object_type);
gint moserial_main_main (char** args, int args_length1);
static void moserial_main_finalize (GObject* obj);

static const GOptionEntry MOSERIAL_MAIN_options[] = {{"profile", 'p', 0, G_OPTION_ARG_FILENAME, &moserial_main_profileFilename, N_ ("Profile file to load"), "foo.conf"}, {NULL}};


void moserial_main_run (moserialMain* self) {
	GError * _inner_error_;
	moserialMainWindow* mainWindow;
	GtkBuilder* builder;
	gboolean _tmp0_;
	moserialMainWindow* _tmp3_;
	g_return_if_fail (self != NULL);
	_inner_error_ = NULL;
	mainWindow = NULL;
	builder = gtk_builder_new ();
	{
		gtk_builder_add_from_file (builder, MOSERIAL_GLADEDIR "/moserial.ui", &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch4_g_error;
			goto __finally4;
		}
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			GtkMessageDialog* msg;
			msg = g_object_ref_sink ((GtkMessageDialog*) gtk_message_dialog_new (NULL, GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_CANCEL, _ ("Failed to load UI\n%s"), e->message, NULL));
			gtk_dialog_run ((GtkDialog*) msg);
			(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
			(msg == NULL) ? NULL : (msg = (g_object_unref (msg), NULL));
		}
	}
	__finally4:
	if (_inner_error_ != NULL) {
		(mainWindow == NULL) ? NULL : (mainWindow = (g_object_unref (mainWindow), NULL));
		(builder == NULL) ? NULL : (builder = (g_object_unref (builder), NULL));
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp0_ = FALSE;
	if (!(moserial_main_profileFilename == NULL)) {
		_tmp0_ = !g_path_is_absolute (moserial_main_profileFilename);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		char* _tmp2_;
		char* _tmp1_;
		_tmp2_ = NULL;
		_tmp1_ = NULL;
		moserial_main_profileFilename = (_tmp2_ = g_build_filename (_tmp1_ = g_get_current_dir (), moserial_main_profileFilename, NULL), moserial_main_profileFilename = (g_free (moserial_main_profileFilename), NULL), _tmp2_);
		_tmp1_ = (g_free (_tmp1_), NULL);
	}
	_tmp3_ = NULL;
	mainWindow = (_tmp3_ = g_object_ref_sink (moserial_main_window_new (builder, moserial_main_profileFilename)), (mainWindow == NULL) ? NULL : (mainWindow = (g_object_unref (mainWindow), NULL)), _tmp3_);
	moserial_main_window_showWindow (mainWindow);
	(mainWindow == NULL) ? NULL : (mainWindow = (g_object_unref (mainWindow), NULL));
	(builder == NULL) ? NULL : (builder = (g_object_unref (builder), NULL));
}


gint moserial_main_main (char** args, int args_length1) {
	gint result;
	GError * _inner_error_;
	GOptionContext* context;
	GOptionContext* _tmp0_;
	_inner_error_ = NULL;
	context = NULL;
	gtk_init (&args_length1, &args);
	bindtextdomain (GETTEXT_PACKAGE, PACKAGE_LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
	_tmp0_ = NULL;
	context = (_tmp0_ = g_option_context_new (_ ("- moserial serial terminal")), (context == NULL) ? NULL : (context = (g_option_context_free (context), NULL)), _tmp0_);
	g_option_context_add_main_entries (context, MOSERIAL_MAIN_options, NULL);
	g_option_context_add_group (context, gtk_get_option_group (TRUE));
	{
		gboolean _tmp1_;
		_tmp1_ = g_option_context_parse (context, &args_length1, &args, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_OPTION_ERROR) {
				goto __catch5_g_option_error;
			}
			goto __finally5;
		}
		if (!_tmp1_) {
			fprintf (stdout, _ ("Run '%s --help' to see a full list of available command line options.\n"), args[0]);
		} else {
			moserialMain* app;
			app = moserial_main_new ();
			moserial_main_run (app);
			gtk_main ();
			(app == NULL) ? NULL : (app = (g_object_unref (app), NULL));
		}
	}
	goto __finally5;
	__catch5_g_option_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			fprintf (stdout, "%s\n", e->message);
			fprintf (stdout, _ ("Run '%s --help' to see a full list of available command line options.\n"), args[0]);
			(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
		}
	}
	__finally5:
	if (_inner_error_ != NULL) {
		(context == NULL) ? NULL : (context = (g_option_context_free (context), NULL));
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
		g_clear_error (&_inner_error_);
		return 0;
	}
	result = 0;
	(context == NULL) ? NULL : (context = (g_option_context_free (context), NULL));
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return moserial_main_main (argv, argc);
}


moserialMain* moserial_main_construct (GType object_type) {
	moserialMain * self;
	self = g_object_newv (object_type, 0, NULL);
	return self;
}


moserialMain* moserial_main_new (void) {
	return moserial_main_construct (MOSERIAL_TYPE_MAIN);
}


static void moserial_main_class_init (moserialMainClass * klass) {
	moserial_main_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = moserial_main_finalize;
}


static void moserial_main_instance_init (moserialMain * self) {
}


static void moserial_main_finalize (GObject* obj) {
	moserialMain * self;
	self = MOSERIAL_MAIN (obj);
	G_OBJECT_CLASS (moserial_main_parent_class)->finalize (obj);
}


GType moserial_main_get_type (void) {
	static GType moserial_main_type_id = 0;
	if (moserial_main_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (moserialMainClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) moserial_main_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (moserialMain), 0, (GInstanceInitFunc) moserial_main_instance_init, NULL };
		moserial_main_type_id = g_type_register_static (G_TYPE_OBJECT, "moserialMain", &g_define_type_info, 0);
	}
	return moserial_main_type_id;
}




