
#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>


#define MOSERIAL_TYPE_PREFERENCES_DIALOG (moserial_preferences_dialog_get_type ())
#define MOSERIAL_PREFERENCES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MOSERIAL_TYPE_PREFERENCES_DIALOG, moserialPreferencesDialog))
#define MOSERIAL_PREFERENCES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MOSERIAL_TYPE_PREFERENCES_DIALOG, moserialPreferencesDialogClass))
#define MOSERIAL_IS_PREFERENCES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MOSERIAL_TYPE_PREFERENCES_DIALOG))
#define MOSERIAL_IS_PREFERENCES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MOSERIAL_TYPE_PREFERENCES_DIALOG))
#define MOSERIAL_PREFERENCES_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MOSERIAL_TYPE_PREFERENCES_DIALOG, moserialPreferencesDialogClass))

typedef struct _moserialPreferencesDialog moserialPreferencesDialog;
typedef struct _moserialPreferencesDialogClass moserialPreferencesDialogClass;
typedef struct _moserialPreferencesDialogPrivate moserialPreferencesDialogPrivate;

#define TYPE_PREFERENCES (preferences_get_type ())
#define PREFERENCES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PREFERENCES, Preferences))
#define PREFERENCES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PREFERENCES, PreferencesClass))
#define IS_PREFERENCES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PREFERENCES))
#define IS_PREFERENCES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PREFERENCES))
#define PREFERENCES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PREFERENCES, PreferencesClass))

typedef struct _Preferences Preferences;
typedef struct _PreferencesClass PreferencesClass;

struct _moserialPreferencesDialog {
	GObject parent_instance;
	moserialPreferencesDialogPrivate * priv;
};

struct _moserialPreferencesDialogClass {
	GObjectClass parent_class;
};

struct _moserialPreferencesDialogPrivate {
	GtkBuilder* _builder;
	GtkDialog* dialog;
	GtkButton* cancelButton;
	GtkButton* okButton;
	GtkCheckButton* systemFont;
	GtkFontButton* fontButton;
	GtkColorButton* fontColorButton;
	GtkColorButton* backgroundColorButton;
	GtkColorButton* highlightColorButton;
	GtkCheckButton* recordLaunch;
	GtkCheckButton* enableTimeout;
	GtkSpinButton* timeout;
};


static gpointer moserial_preferences_dialog_parent_class = NULL;

GType moserial_preferences_dialog_get_type (void);
#define MOSERIAL_PREFERENCES_DIALOG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), MOSERIAL_TYPE_PREFERENCES_DIALOG, moserialPreferencesDialogPrivate))
enum  {
	MOSERIAL_PREFERENCES_DIALOG_DUMMY_PROPERTY,
	MOSERIAL_PREFERENCES_DIALOG_BUILDER
};
static void moserial_preferences_dialog_set_builder (moserialPreferencesDialog* self, GtkBuilder* value);
moserialPreferencesDialog* moserial_preferences_dialog_new (GtkBuilder* builder);
moserialPreferencesDialog* moserial_preferences_dialog_construct (GType object_type, GtkBuilder* builder);
gboolean moserial_preferences_dialog_hide (moserialPreferencesDialog* self);
Preferences* preferences_new (gboolean useSystemMonospaceFont, const char* font, const char* fontColor, const char* backgroundColor, const char* highlightColor, gboolean recordLaunch, gboolean enableTimeout, gint timeout);
Preferences* preferences_construct (GType object_type, gboolean useSystemMonospaceFont, const char* font, const char* fontColor, const char* backgroundColor, const char* highlightColor, gboolean recordLaunch, gboolean enableTimeout, gint timeout);
GType preferences_get_type (void);
void moserial_preferences_dialog_ok (moserialPreferencesDialog* self, GtkButton* button);
gboolean preferences_get_useSystemMonospaceFont (Preferences* self);
const char* preferences_get_font (Preferences* self);
GdkColor preferences_getGdkColor (const char* color);
const char* preferences_get_fontColor (Preferences* self);
const char* preferences_get_backgroundColor (Preferences* self);
const char* preferences_get_highlightColor (Preferences* self);
gboolean preferences_get_recordLaunch (Preferences* self);
gboolean preferences_get_enableTimeout (Preferences* self);
gint preferences_get_timeout (Preferences* self);
void moserial_preferences_dialog_show (moserialPreferencesDialog* self, Preferences* preferences, gboolean recording);
void moserial_preferences_dialog_cancel (moserialPreferencesDialog* self, GtkWidget* w);
void moserial_preferences_dialog_systemFontToggled (moserialPreferencesDialog* self, GtkCheckButton* button);
void moserial_preferences_dialog_enableTimeoutToggled (moserialPreferencesDialog* self, GtkCheckButton* button);
GtkBuilder* moserial_preferences_dialog_get_builder (moserialPreferencesDialog* self);
static void _moserial_preferences_dialog_systemFontToggled_gtk_toggle_button_toggled (GtkCheckButton* _sender, gpointer self);
static void _moserial_preferences_dialog_enableTimeoutToggled_gtk_toggle_button_toggled (GtkCheckButton* _sender, gpointer self);
static void _moserial_preferences_dialog_ok_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _moserial_preferences_dialog_cancel_gtk_button_clicked (GtkButton* _sender, gpointer self);
static gboolean _moserial_preferences_dialog_hide_gtk_widget_delete_event (GtkDialog* _sender, GdkEvent* event, gpointer self);
static GObject * moserial_preferences_dialog_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void moserial_preferences_dialog_finalize (GObject* obj);
static void moserial_preferences_dialog_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void moserial_preferences_dialog_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);



moserialPreferencesDialog* moserial_preferences_dialog_construct (GType object_type, GtkBuilder* builder) {
	GParameter * __params;
	GParameter * __params_it;
	moserialPreferencesDialog * self;
	g_return_val_if_fail (builder != NULL, NULL);
	__params = g_new0 (GParameter, 1);
	__params_it = __params;
	__params_it->name = "builder";
	g_value_init (&__params_it->value, GTK_TYPE_BUILDER);
	g_value_set_object (&__params_it->value, builder);
	__params_it++;
	self = g_object_newv (object_type, __params_it - __params, __params);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


moserialPreferencesDialog* moserial_preferences_dialog_new (GtkBuilder* builder) {
	return moserial_preferences_dialog_construct (MOSERIAL_TYPE_PREFERENCES_DIALOG, builder);
}


void moserial_preferences_dialog_ok (moserialPreferencesDialog* self, GtkButton* button) {
	gboolean pSystemFont;
	char* pFont;
	char* pFontColor;
	char* pBackgroundColor;
	char* pHighlightColor;
	gboolean pRecordLaunch;
	gboolean pEnableTimeout;
	gint pTimeout;
	char* _tmp1_;
	const char* _tmp0_;
	GdkColor c = {0};
	char* _tmp2_;
	char* _tmp3_;
	char* _tmp4_;
	Preferences* preferences;
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	moserial_preferences_dialog_hide (self);
	pSystemFont = FALSE;
	pFont = NULL;
	pFontColor = NULL;
	pBackgroundColor = NULL;
	pHighlightColor = NULL;
	pRecordLaunch = FALSE;
	pEnableTimeout = FALSE;
	pTimeout = 0;
	if (gtk_toggle_button_get_active ((GtkToggleButton*) self->priv->systemFont)) {
		pSystemFont = TRUE;
	} else {
		pSystemFont = FALSE;
	}
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	pFont = (_tmp1_ = (_tmp0_ = gtk_font_button_get_font_name (self->priv->fontButton), (_tmp0_ == NULL) ? NULL : g_strdup (_tmp0_)), pFont = (g_free (pFont), NULL), _tmp1_);
	gtk_color_button_get_color (self->priv->fontColorButton, &c);
	_tmp2_ = NULL;
	pFontColor = (_tmp2_ = gdk_color_to_string (&c), pFontColor = (g_free (pFontColor), NULL), _tmp2_);
	gtk_color_button_get_color (self->priv->backgroundColorButton, &c);
	_tmp3_ = NULL;
	pBackgroundColor = (_tmp3_ = gdk_color_to_string (&c), pBackgroundColor = (g_free (pBackgroundColor), NULL), _tmp3_);
	gtk_color_button_get_color (self->priv->highlightColorButton, &c);
	_tmp4_ = NULL;
	pHighlightColor = (_tmp4_ = gdk_color_to_string (&c), pHighlightColor = (g_free (pHighlightColor), NULL), _tmp4_);
	if (gtk_toggle_button_get_active ((GtkToggleButton*) self->priv->recordLaunch)) {
		pRecordLaunch = TRUE;
	} else {
		pRecordLaunch = FALSE;
	}
	if (gtk_toggle_button_get_active ((GtkToggleButton*) self->priv->enableTimeout)) {
		pEnableTimeout = TRUE;
	} else {
		pEnableTimeout = FALSE;
	}
	pTimeout = (gint) gtk_spin_button_get_value (self->priv->timeout);
	preferences = preferences_new (pSystemFont, pFont, pFontColor, pBackgroundColor, pHighlightColor, pRecordLaunch, pEnableTimeout, pTimeout);
	g_signal_emit_by_name (self, "update-preferences", preferences);
	pFont = (g_free (pFont), NULL);
	pFontColor = (g_free (pFontColor), NULL);
	pBackgroundColor = (g_free (pBackgroundColor), NULL);
	pHighlightColor = (g_free (pHighlightColor), NULL);
	(preferences == NULL) ? NULL : (preferences = (g_object_unref (preferences), NULL));
}


void moserial_preferences_dialog_show (moserialPreferencesDialog* self, Preferences* preferences, gboolean recording) {
	GdkColor _tmp0_ = {0};
	GdkColor _tmp1_ = {0};
	GdkColor _tmp2_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (preferences != NULL);
	if (preferences_get_useSystemMonospaceFont (preferences)) {
		gtk_widget_set_sensitive ((GtkWidget*) self->priv->fontButton, FALSE);
		gtk_toggle_button_set_active ((GtkToggleButton*) self->priv->systemFont, TRUE);
	} else {
		gtk_widget_set_sensitive ((GtkWidget*) self->priv->fontButton, TRUE);
		gtk_toggle_button_set_active ((GtkToggleButton*) self->priv->systemFont, FALSE);
	}
	gtk_font_button_set_font_name (self->priv->fontButton, preferences_get_font (preferences));
	gtk_color_button_set_color (self->priv->fontColorButton, (_tmp0_ = preferences_getGdkColor (preferences_get_fontColor (preferences)), &_tmp0_));
	gtk_color_button_set_color (self->priv->backgroundColorButton, (_tmp1_ = preferences_getGdkColor (preferences_get_backgroundColor (preferences)), &_tmp1_));
	gtk_color_button_set_color (self->priv->highlightColorButton, (_tmp2_ = preferences_getGdkColor (preferences_get_highlightColor (preferences)), &_tmp2_));
	if (preferences_get_recordLaunch (preferences)) {
		gtk_toggle_button_set_active ((GtkToggleButton*) self->priv->recordLaunch, TRUE);
	} else {
		gtk_toggle_button_set_active ((GtkToggleButton*) self->priv->recordLaunch, FALSE);
	}
	if (preferences_get_enableTimeout (preferences)) {
		gtk_toggle_button_set_active ((GtkToggleButton*) self->priv->enableTimeout, TRUE);
		gtk_widget_set_sensitive ((GtkWidget*) self->priv->timeout, TRUE);
	} else {
		gtk_toggle_button_set_active ((GtkToggleButton*) self->priv->enableTimeout, FALSE);
		gtk_widget_set_sensitive ((GtkWidget*) self->priv->timeout, FALSE);
	}
	if (recording) {
		gtk_widget_set_sensitive ((GtkWidget*) self->priv->enableTimeout, FALSE);
		gtk_widget_set_sensitive ((GtkWidget*) self->priv->timeout, FALSE);
	} else {
		gtk_widget_set_sensitive ((GtkWidget*) self->priv->enableTimeout, TRUE);
	}
	gtk_spin_button_set_value (self->priv->timeout, (double) preferences_get_timeout (preferences));
	gtk_widget_show_all ((GtkWidget*) self->priv->dialog);
}


void moserial_preferences_dialog_cancel (moserialPreferencesDialog* self, GtkWidget* w) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (w != NULL);
	/*currentPreferences=null;*/
	moserial_preferences_dialog_hide (self);
}


gboolean moserial_preferences_dialog_hide (moserialPreferencesDialog* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	gtk_widget_hide_all ((GtkWidget*) self->priv->dialog);
	result = TRUE;
	return result;
}


void moserial_preferences_dialog_systemFontToggled (moserialPreferencesDialog* self, GtkCheckButton* button) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	if (gtk_toggle_button_get_active ((GtkToggleButton*) button)) {
		gtk_widget_set_sensitive ((GtkWidget*) self->priv->fontButton, FALSE);
	} else {
		gtk_widget_set_sensitive ((GtkWidget*) self->priv->fontButton, TRUE);
	}
}


void moserial_preferences_dialog_enableTimeoutToggled (moserialPreferencesDialog* self, GtkCheckButton* button) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	if (gtk_toggle_button_get_active ((GtkToggleButton*) button)) {
		gtk_widget_set_sensitive ((GtkWidget*) self->priv->timeout, TRUE);
	} else {
		gtk_widget_set_sensitive ((GtkWidget*) self->priv->timeout, FALSE);
	}
}


GtkBuilder* moserial_preferences_dialog_get_builder (moserialPreferencesDialog* self) {
	GtkBuilder* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_builder;
	return result;
}


static void moserial_preferences_dialog_set_builder (moserialPreferencesDialog* self, GtkBuilder* value) {
	GtkBuilder* _tmp1_;
	GtkBuilder* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	self->priv->_builder = (_tmp1_ = (_tmp0_ = value, (_tmp0_ == NULL) ? NULL : g_object_ref (_tmp0_)), (self->priv->_builder == NULL) ? NULL : (self->priv->_builder = (g_object_unref (self->priv->_builder), NULL)), _tmp1_);
	g_object_notify ((GObject *) self, "builder");
}


static void _moserial_preferences_dialog_systemFontToggled_gtk_toggle_button_toggled (GtkCheckButton* _sender, gpointer self) {
	moserial_preferences_dialog_systemFontToggled (self, _sender);
}


static void _moserial_preferences_dialog_enableTimeoutToggled_gtk_toggle_button_toggled (GtkCheckButton* _sender, gpointer self) {
	moserial_preferences_dialog_enableTimeoutToggled (self, _sender);
}


static void _moserial_preferences_dialog_ok_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	moserial_preferences_dialog_ok (self, _sender);
}


static void _moserial_preferences_dialog_cancel_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	moserial_preferences_dialog_cancel (self, _sender);
}


static gboolean _moserial_preferences_dialog_hide_gtk_widget_delete_event (GtkDialog* _sender, GdkEvent* event, gpointer self) {
	return moserial_preferences_dialog_hide (self);
}


static GObject * moserial_preferences_dialog_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	moserialPreferencesDialogClass * klass;
	GObjectClass * parent_class;
	moserialPreferencesDialog * self;
	klass = MOSERIAL_PREFERENCES_DIALOG_CLASS (g_type_class_peek (MOSERIAL_TYPE_PREFERENCES_DIALOG));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = MOSERIAL_PREFERENCES_DIALOG (obj);
	{
		GtkDialog* _tmp1_;
		GtkDialog* _tmp0_;
		GtkButton* _tmp3_;
		GtkButton* _tmp2_;
		GtkButton* _tmp5_;
		GtkButton* _tmp4_;
		GtkCheckButton* _tmp7_;
		GtkCheckButton* _tmp6_;
		GtkFontButton* _tmp9_;
		GtkFontButton* _tmp8_;
		GtkColorButton* _tmp11_;
		GtkColorButton* _tmp10_;
		GtkColorButton* _tmp13_;
		GtkColorButton* _tmp12_;
		GtkColorButton* _tmp15_;
		GtkColorButton* _tmp14_;
		GtkCheckButton* _tmp17_;
		GtkCheckButton* _tmp16_;
		GtkCheckButton* _tmp19_;
		GtkCheckButton* _tmp18_;
		GtkSpinButton* _tmp21_;
		GtkSpinButton* _tmp20_;
		_tmp1_ = NULL;
		_tmp0_ = NULL;
		self->priv->dialog = (_tmp1_ = (_tmp0_ = GTK_DIALOG (gtk_builder_get_object (self->priv->_builder, "preferences_dialog")), (_tmp0_ == NULL) ? NULL : g_object_ref (_tmp0_)), (self->priv->dialog == NULL) ? NULL : (self->priv->dialog = (g_object_unref (self->priv->dialog), NULL)), _tmp1_);
		_tmp3_ = NULL;
		_tmp2_ = NULL;
		self->priv->okButton = (_tmp3_ = (_tmp2_ = GTK_BUTTON (gtk_builder_get_object (self->priv->_builder, "preferences_ok")), (_tmp2_ == NULL) ? NULL : g_object_ref (_tmp2_)), (self->priv->okButton == NULL) ? NULL : (self->priv->okButton = (g_object_unref (self->priv->okButton), NULL)), _tmp3_);
		_tmp5_ = NULL;
		_tmp4_ = NULL;
		self->priv->cancelButton = (_tmp5_ = (_tmp4_ = GTK_BUTTON (gtk_builder_get_object (self->priv->_builder, "preferences_cancel")), (_tmp4_ == NULL) ? NULL : g_object_ref (_tmp4_)), (self->priv->cancelButton == NULL) ? NULL : (self->priv->cancelButton = (g_object_unref (self->priv->cancelButton), NULL)), _tmp5_);
		_tmp7_ = NULL;
		_tmp6_ = NULL;
		self->priv->systemFont = (_tmp7_ = (_tmp6_ = GTK_CHECK_BUTTON (gtk_builder_get_object (self->priv->_builder, "preferences_use_system_font")), (_tmp6_ == NULL) ? NULL : g_object_ref (_tmp6_)), (self->priv->systemFont == NULL) ? NULL : (self->priv->systemFont = (g_object_unref (self->priv->systemFont), NULL)), _tmp7_);
		_tmp9_ = NULL;
		_tmp8_ = NULL;
		self->priv->fontButton = (_tmp9_ = (_tmp8_ = GTK_FONT_BUTTON (gtk_builder_get_object (self->priv->_builder, "preferences_font_button")), (_tmp8_ == NULL) ? NULL : g_object_ref (_tmp8_)), (self->priv->fontButton == NULL) ? NULL : (self->priv->fontButton = (g_object_unref (self->priv->fontButton), NULL)), _tmp9_);
		_tmp11_ = NULL;
		_tmp10_ = NULL;
		self->priv->fontColorButton = (_tmp11_ = (_tmp10_ = GTK_COLOR_BUTTON (gtk_builder_get_object (self->priv->_builder, "preferences_font_color_button")), (_tmp10_ == NULL) ? NULL : g_object_ref (_tmp10_)), (self->priv->fontColorButton == NULL) ? NULL : (self->priv->fontColorButton = (g_object_unref (self->priv->fontColorButton), NULL)), _tmp11_);
		_tmp13_ = NULL;
		_tmp12_ = NULL;
		self->priv->backgroundColorButton = (_tmp13_ = (_tmp12_ = GTK_COLOR_BUTTON (gtk_builder_get_object (self->priv->_builder, "preferences_background_color_button")), (_tmp12_ == NULL) ? NULL : g_object_ref (_tmp12_)), (self->priv->backgroundColorButton == NULL) ? NULL : (self->priv->backgroundColorButton = (g_object_unref (self->priv->backgroundColorButton), NULL)), _tmp13_);
		_tmp15_ = NULL;
		_tmp14_ = NULL;
		self->priv->highlightColorButton = (_tmp15_ = (_tmp14_ = GTK_COLOR_BUTTON (gtk_builder_get_object (self->priv->_builder, "preferences_highlight_color_button")), (_tmp14_ == NULL) ? NULL : g_object_ref (_tmp14_)), (self->priv->highlightColorButton == NULL) ? NULL : (self->priv->highlightColorButton = (g_object_unref (self->priv->highlightColorButton), NULL)), _tmp15_);
		_tmp17_ = NULL;
		_tmp16_ = NULL;
		self->priv->recordLaunch = (_tmp17_ = (_tmp16_ = GTK_CHECK_BUTTON (gtk_builder_get_object (self->priv->_builder, "preferences_record_launch")), (_tmp16_ == NULL) ? NULL : g_object_ref (_tmp16_)), (self->priv->recordLaunch == NULL) ? NULL : (self->priv->recordLaunch = (g_object_unref (self->priv->recordLaunch), NULL)), _tmp17_);
		_tmp19_ = NULL;
		_tmp18_ = NULL;
		self->priv->enableTimeout = (_tmp19_ = (_tmp18_ = GTK_CHECK_BUTTON (gtk_builder_get_object (self->priv->_builder, "preferences_record_enable_timeout")), (_tmp18_ == NULL) ? NULL : g_object_ref (_tmp18_)), (self->priv->enableTimeout == NULL) ? NULL : (self->priv->enableTimeout = (g_object_unref (self->priv->enableTimeout), NULL)), _tmp19_);
		_tmp21_ = NULL;
		_tmp20_ = NULL;
		self->priv->timeout = (_tmp21_ = (_tmp20_ = GTK_SPIN_BUTTON (gtk_builder_get_object (self->priv->_builder, "preferences_record_timeout")), (_tmp20_ == NULL) ? NULL : g_object_ref (_tmp20_)), (self->priv->timeout == NULL) ? NULL : (self->priv->timeout = (g_object_unref (self->priv->timeout), NULL)), _tmp21_);
		g_signal_connect_object ((GtkToggleButton*) self->priv->systemFont, "toggled", (GCallback) _moserial_preferences_dialog_systemFontToggled_gtk_toggle_button_toggled, self, 0);
		g_signal_connect_object ((GtkToggleButton*) self->priv->enableTimeout, "toggled", (GCallback) _moserial_preferences_dialog_enableTimeoutToggled_gtk_toggle_button_toggled, self, 0);
		g_signal_connect_object (self->priv->okButton, "clicked", (GCallback) _moserial_preferences_dialog_ok_gtk_button_clicked, self, 0);
		g_signal_connect_object (self->priv->cancelButton, "clicked", (GCallback) _moserial_preferences_dialog_cancel_gtk_button_clicked, self, 0);
		g_signal_connect_object ((GtkWidget*) self->priv->dialog, "delete-event", (GCallback) _moserial_preferences_dialog_hide_gtk_widget_delete_event, self, 0);
	}
	return obj;
}


static void moserial_preferences_dialog_class_init (moserialPreferencesDialogClass * klass) {
	moserial_preferences_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (moserialPreferencesDialogPrivate));
	G_OBJECT_CLASS (klass)->get_property = moserial_preferences_dialog_get_property;
	G_OBJECT_CLASS (klass)->set_property = moserial_preferences_dialog_set_property;
	G_OBJECT_CLASS (klass)->constructor = moserial_preferences_dialog_constructor;
	G_OBJECT_CLASS (klass)->finalize = moserial_preferences_dialog_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MOSERIAL_PREFERENCES_DIALOG_BUILDER, g_param_spec_object ("builder", "builder", "builder", GTK_TYPE_BUILDER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_signal_new ("update_preferences", MOSERIAL_TYPE_PREFERENCES_DIALOG, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, TYPE_PREFERENCES);
}


static void moserial_preferences_dialog_instance_init (moserialPreferencesDialog * self) {
	self->priv = MOSERIAL_PREFERENCES_DIALOG_GET_PRIVATE (self);
}


static void moserial_preferences_dialog_finalize (GObject* obj) {
	moserialPreferencesDialog * self;
	self = MOSERIAL_PREFERENCES_DIALOG (obj);
	(self->priv->_builder == NULL) ? NULL : (self->priv->_builder = (g_object_unref (self->priv->_builder), NULL));
	(self->priv->dialog == NULL) ? NULL : (self->priv->dialog = (g_object_unref (self->priv->dialog), NULL));
	(self->priv->cancelButton == NULL) ? NULL : (self->priv->cancelButton = (g_object_unref (self->priv->cancelButton), NULL));
	(self->priv->okButton == NULL) ? NULL : (self->priv->okButton = (g_object_unref (self->priv->okButton), NULL));
	(self->priv->systemFont == NULL) ? NULL : (self->priv->systemFont = (g_object_unref (self->priv->systemFont), NULL));
	(self->priv->fontButton == NULL) ? NULL : (self->priv->fontButton = (g_object_unref (self->priv->fontButton), NULL));
	(self->priv->fontColorButton == NULL) ? NULL : (self->priv->fontColorButton = (g_object_unref (self->priv->fontColorButton), NULL));
	(self->priv->backgroundColorButton == NULL) ? NULL : (self->priv->backgroundColorButton = (g_object_unref (self->priv->backgroundColorButton), NULL));
	(self->priv->highlightColorButton == NULL) ? NULL : (self->priv->highlightColorButton = (g_object_unref (self->priv->highlightColorButton), NULL));
	(self->priv->recordLaunch == NULL) ? NULL : (self->priv->recordLaunch = (g_object_unref (self->priv->recordLaunch), NULL));
	(self->priv->enableTimeout == NULL) ? NULL : (self->priv->enableTimeout = (g_object_unref (self->priv->enableTimeout), NULL));
	(self->priv->timeout == NULL) ? NULL : (self->priv->timeout = (g_object_unref (self->priv->timeout), NULL));
	G_OBJECT_CLASS (moserial_preferences_dialog_parent_class)->finalize (obj);
}


GType moserial_preferences_dialog_get_type (void) {
	static GType moserial_preferences_dialog_type_id = 0;
	if (moserial_preferences_dialog_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (moserialPreferencesDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) moserial_preferences_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (moserialPreferencesDialog), 0, (GInstanceInitFunc) moserial_preferences_dialog_instance_init, NULL };
		moserial_preferences_dialog_type_id = g_type_register_static (G_TYPE_OBJECT, "moserialPreferencesDialog", &g_define_type_info, 0);
	}
	return moserial_preferences_dialog_type_id;
}


static void moserial_preferences_dialog_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	moserialPreferencesDialog * self;
	gpointer boxed;
	self = MOSERIAL_PREFERENCES_DIALOG (object);
	switch (property_id) {
		case MOSERIAL_PREFERENCES_DIALOG_BUILDER:
		g_value_set_object (value, moserial_preferences_dialog_get_builder (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void moserial_preferences_dialog_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	moserialPreferencesDialog * self;
	self = MOSERIAL_PREFERENCES_DIALOG (object);
	switch (property_id) {
		case MOSERIAL_PREFERENCES_DIALOG_BUILDER:
		moserial_preferences_dialog_set_builder (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}




