
#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>


#define MOSERIAL_TYPE_SEND_PROGRESS_DIALOG (moserial_send_progress_dialog_get_type ())
#define MOSERIAL_SEND_PROGRESS_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MOSERIAL_TYPE_SEND_PROGRESS_DIALOG, moserialSendProgressDialog))
#define MOSERIAL_SEND_PROGRESS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MOSERIAL_TYPE_SEND_PROGRESS_DIALOG, moserialSendProgressDialogClass))
#define MOSERIAL_IS_SEND_PROGRESS_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MOSERIAL_TYPE_SEND_PROGRESS_DIALOG))
#define MOSERIAL_IS_SEND_PROGRESS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MOSERIAL_TYPE_SEND_PROGRESS_DIALOG))
#define MOSERIAL_SEND_PROGRESS_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MOSERIAL_TYPE_SEND_PROGRESS_DIALOG, moserialSendProgressDialogClass))

typedef struct _moserialSendProgressDialog moserialSendProgressDialog;
typedef struct _moserialSendProgressDialogClass moserialSendProgressDialogClass;
typedef struct _moserialSendProgressDialogPrivate moserialSendProgressDialogPrivate;

struct _moserialSendProgressDialog {
	GObject parent_instance;
	moserialSendProgressDialogPrivate * priv;
};

struct _moserialSendProgressDialogClass {
	GObjectClass parent_class;
};

struct _moserialSendProgressDialogPrivate {
	GtkBuilder* _builder;
	GtkDialog* dialog;
	GtkButton* cancelButton;
	GtkLabel* status;
	GtkProgressBar* progressBar;
};


static gpointer moserial_send_progress_dialog_parent_class = NULL;

GType moserial_send_progress_dialog_get_type (void);
#define MOSERIAL_SEND_PROGRESS_DIALOG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), MOSERIAL_TYPE_SEND_PROGRESS_DIALOG, moserialSendProgressDialogPrivate))
enum  {
	MOSERIAL_SEND_PROGRESS_DIALOG_DUMMY_PROPERTY,
	MOSERIAL_SEND_PROGRESS_DIALOG_BUILDER
};
static void moserial_send_progress_dialog_set_builder (moserialSendProgressDialog* self, GtkBuilder* value);
moserialSendProgressDialog* moserial_send_progress_dialog_new (GtkBuilder* builder);
moserialSendProgressDialog* moserial_send_progress_dialog_construct (GType object_type, GtkBuilder* builder);
void moserial_send_progress_dialog_show (moserialSendProgressDialog* self);
gboolean moserial_send_progress_dialog_hide (moserialSendProgressDialog* self);
void moserial_send_progress_dialog_updateStatus (moserialSendProgressDialog* self, GObject* o, const char* newStatus);
void moserial_send_progress_dialog_cancel (moserialSendProgressDialog* self, GObject* o);
GtkBuilder* moserial_send_progress_dialog_get_builder (moserialSendProgressDialog* self);
static void _moserial_send_progress_dialog_cancel_gtk_button_clicked (GtkButton* _sender, gpointer self);
static gboolean _moserial_send_progress_dialog_hide_gtk_widget_delete_event (GtkDialog* _sender, GdkEvent* event, gpointer self);
static GObject * moserial_send_progress_dialog_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void moserial_send_progress_dialog_finalize (GObject* obj);
static void moserial_send_progress_dialog_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void moserial_send_progress_dialog_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);



moserialSendProgressDialog* moserial_send_progress_dialog_construct (GType object_type, GtkBuilder* builder) {
	GParameter * __params;
	GParameter * __params_it;
	moserialSendProgressDialog * self;
	g_return_val_if_fail (builder != NULL, NULL);
	__params = g_new0 (GParameter, 1);
	__params_it = __params;
	__params_it->name = "builder";
	g_value_init (&__params_it->value, GTK_TYPE_BUILDER);
	g_value_set_object (&__params_it->value, builder);
	__params_it++;
	self = g_object_newv (object_type, __params_it - __params, __params);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


moserialSendProgressDialog* moserial_send_progress_dialog_new (GtkBuilder* builder) {
	return moserial_send_progress_dialog_construct (MOSERIAL_TYPE_SEND_PROGRESS_DIALOG, builder);
}


void moserial_send_progress_dialog_show (moserialSendProgressDialog* self) {
	g_return_if_fail (self != NULL);
	gtk_widget_show_all ((GtkWidget*) self->priv->dialog);
	gtk_label_set_text (self->priv->status, _ ("Waiting for remote host"));
}


gboolean moserial_send_progress_dialog_hide (moserialSendProgressDialog* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	gtk_widget_hide_all ((GtkWidget*) self->priv->dialog);
	result = TRUE;
	return result;
}


void moserial_send_progress_dialog_updateStatus (moserialSendProgressDialog* self, GObject* o, const char* newStatus) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (o != NULL);
	g_return_if_fail (newStatus != NULL);
	gtk_label_set_text (self->priv->status, newStatus);
	gtk_progress_bar_pulse (self->priv->progressBar);
}


void moserial_send_progress_dialog_cancel (moserialSendProgressDialog* self, GObject* o) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (o != NULL);
	/*TODO: make canceling transfers actually work*/
	g_signal_emit_by_name (self, "transfer-canceled");
}


GtkBuilder* moserial_send_progress_dialog_get_builder (moserialSendProgressDialog* self) {
	GtkBuilder* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_builder;
	return result;
}


static void moserial_send_progress_dialog_set_builder (moserialSendProgressDialog* self, GtkBuilder* value) {
	GtkBuilder* _tmp1_;
	GtkBuilder* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	self->priv->_builder = (_tmp1_ = (_tmp0_ = value, (_tmp0_ == NULL) ? NULL : g_object_ref (_tmp0_)), (self->priv->_builder == NULL) ? NULL : (self->priv->_builder = (g_object_unref (self->priv->_builder), NULL)), _tmp1_);
	g_object_notify ((GObject *) self, "builder");
}


static void _moserial_send_progress_dialog_cancel_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	moserial_send_progress_dialog_cancel (self, _sender);
}


static gboolean _moserial_send_progress_dialog_hide_gtk_widget_delete_event (GtkDialog* _sender, GdkEvent* event, gpointer self) {
	return moserial_send_progress_dialog_hide (self);
}


static GObject * moserial_send_progress_dialog_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	moserialSendProgressDialogClass * klass;
	GObjectClass * parent_class;
	moserialSendProgressDialog * self;
	klass = MOSERIAL_SEND_PROGRESS_DIALOG_CLASS (g_type_class_peek (MOSERIAL_TYPE_SEND_PROGRESS_DIALOG));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = MOSERIAL_SEND_PROGRESS_DIALOG (obj);
	{
		GtkDialog* _tmp1_;
		GtkDialog* _tmp0_;
		GtkButton* _tmp3_;
		GtkButton* _tmp2_;
		GtkLabel* _tmp5_;
		GtkLabel* _tmp4_;
		GtkProgressBar* _tmp7_;
		GtkProgressBar* _tmp6_;
		_tmp1_ = NULL;
		_tmp0_ = NULL;
		self->priv->dialog = (_tmp1_ = (_tmp0_ = GTK_DIALOG (gtk_builder_get_object (self->priv->_builder, "send_progress_dialog")), (_tmp0_ == NULL) ? NULL : g_object_ref (_tmp0_)), (self->priv->dialog == NULL) ? NULL : (self->priv->dialog = (g_object_unref (self->priv->dialog), NULL)), _tmp1_);
		_tmp3_ = NULL;
		_tmp2_ = NULL;
		self->priv->cancelButton = (_tmp3_ = (_tmp2_ = GTK_BUTTON (gtk_builder_get_object (self->priv->_builder, "send_progress_cancel")), (_tmp2_ == NULL) ? NULL : g_object_ref (_tmp2_)), (self->priv->cancelButton == NULL) ? NULL : (self->priv->cancelButton = (g_object_unref (self->priv->cancelButton), NULL)), _tmp3_);
		g_signal_connect_object (self->priv->cancelButton, "clicked", (GCallback) _moserial_send_progress_dialog_cancel_gtk_button_clicked, self, 0);
		_tmp5_ = NULL;
		_tmp4_ = NULL;
		self->priv->status = (_tmp5_ = (_tmp4_ = GTK_LABEL (gtk_builder_get_object (self->priv->_builder, "send_statusbox")), (_tmp4_ == NULL) ? NULL : g_object_ref (_tmp4_)), (self->priv->status == NULL) ? NULL : (self->priv->status = (g_object_unref (self->priv->status), NULL)), _tmp5_);
		_tmp7_ = NULL;
		_tmp6_ = NULL;
		self->priv->progressBar = (_tmp7_ = (_tmp6_ = GTK_PROGRESS_BAR (gtk_builder_get_object (self->priv->_builder, "send_progressbar")), (_tmp6_ == NULL) ? NULL : g_object_ref (_tmp6_)), (self->priv->progressBar == NULL) ? NULL : (self->priv->progressBar = (g_object_unref (self->priv->progressBar), NULL)), _tmp7_);
		g_signal_connect_object ((GtkWidget*) self->priv->dialog, "delete-event", (GCallback) _moserial_send_progress_dialog_hide_gtk_widget_delete_event, self, 0);
	}
	return obj;
}


static void moserial_send_progress_dialog_class_init (moserialSendProgressDialogClass * klass) {
	moserial_send_progress_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (moserialSendProgressDialogPrivate));
	G_OBJECT_CLASS (klass)->get_property = moserial_send_progress_dialog_get_property;
	G_OBJECT_CLASS (klass)->set_property = moserial_send_progress_dialog_set_property;
	G_OBJECT_CLASS (klass)->constructor = moserial_send_progress_dialog_constructor;
	G_OBJECT_CLASS (klass)->finalize = moserial_send_progress_dialog_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MOSERIAL_SEND_PROGRESS_DIALOG_BUILDER, g_param_spec_object ("builder", "builder", "builder", GTK_TYPE_BUILDER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_signal_new ("transfer_canceled", MOSERIAL_TYPE_SEND_PROGRESS_DIALOG, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void moserial_send_progress_dialog_instance_init (moserialSendProgressDialog * self) {
	self->priv = MOSERIAL_SEND_PROGRESS_DIALOG_GET_PRIVATE (self);
}


static void moserial_send_progress_dialog_finalize (GObject* obj) {
	moserialSendProgressDialog * self;
	self = MOSERIAL_SEND_PROGRESS_DIALOG (obj);
	(self->priv->_builder == NULL) ? NULL : (self->priv->_builder = (g_object_unref (self->priv->_builder), NULL));
	(self->priv->dialog == NULL) ? NULL : (self->priv->dialog = (g_object_unref (self->priv->dialog), NULL));
	(self->priv->cancelButton == NULL) ? NULL : (self->priv->cancelButton = (g_object_unref (self->priv->cancelButton), NULL));
	(self->priv->status == NULL) ? NULL : (self->priv->status = (g_object_unref (self->priv->status), NULL));
	(self->priv->progressBar == NULL) ? NULL : (self->priv->progressBar = (g_object_unref (self->priv->progressBar), NULL));
	G_OBJECT_CLASS (moserial_send_progress_dialog_parent_class)->finalize (obj);
}


GType moserial_send_progress_dialog_get_type (void) {
	static GType moserial_send_progress_dialog_type_id = 0;
	if (moserial_send_progress_dialog_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (moserialSendProgressDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) moserial_send_progress_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (moserialSendProgressDialog), 0, (GInstanceInitFunc) moserial_send_progress_dialog_instance_init, NULL };
		moserial_send_progress_dialog_type_id = g_type_register_static (G_TYPE_OBJECT, "moserialSendProgressDialog", &g_define_type_info, 0);
	}
	return moserial_send_progress_dialog_type_id;
}


static void moserial_send_progress_dialog_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	moserialSendProgressDialog * self;
	gpointer boxed;
	self = MOSERIAL_SEND_PROGRESS_DIALOG (object);
	switch (property_id) {
		case MOSERIAL_SEND_PROGRESS_DIALOG_BUILDER:
		g_value_set_object (value, moserial_send_progress_dialog_get_builder (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void moserial_send_progress_dialog_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	moserialSendProgressDialog * self;
	self = MOSERIAL_SEND_PROGRESS_DIALOG (object);
	switch (property_id) {
		case MOSERIAL_SEND_PROGRESS_DIALOG_BUILDER:
		moserial_send_progress_dialog_set_builder (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}




