
#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <glib/gi18n-lib.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <gobject/gvaluecollector.h>


#define MOSERIAL_TYPE_SERIAL_STREAM_RECORDER (moserial_serial_stream_recorder_get_type ())
#define MOSERIAL_SERIAL_STREAM_RECORDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MOSERIAL_TYPE_SERIAL_STREAM_RECORDER, moserialSerialStreamRecorder))
#define MOSERIAL_SERIAL_STREAM_RECORDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MOSERIAL_TYPE_SERIAL_STREAM_RECORDER, moserialSerialStreamRecorderClass))
#define MOSERIAL_IS_SERIAL_STREAM_RECORDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MOSERIAL_TYPE_SERIAL_STREAM_RECORDER))
#define MOSERIAL_IS_SERIAL_STREAM_RECORDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MOSERIAL_TYPE_SERIAL_STREAM_RECORDER))
#define MOSERIAL_SERIAL_STREAM_RECORDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MOSERIAL_TYPE_SERIAL_STREAM_RECORDER, moserialSerialStreamRecorderClass))

typedef struct _moserialSerialStreamRecorder moserialSerialStreamRecorder;
typedef struct _moserialSerialStreamRecorderClass moserialSerialStreamRecorderClass;
typedef struct _moserialSerialStreamRecorderPrivate moserialSerialStreamRecorderPrivate;

#define MOSERIAL_SERIAL_STREAM_RECORDER_TYPE_DIRECTION (moserial_serial_stream_recorder_direction_get_type ())
typedef struct _moserialParamSpecSerialStreamRecorder moserialParamSpecSerialStreamRecorder;

struct _moserialSerialStreamRecorder {
	GTypeInstance parent_instance;
	volatile int ref_count;
	moserialSerialStreamRecorderPrivate * priv;
};

struct _moserialSerialStreamRecorderClass {
	GTypeClass parent_class;
	void (*finalize) (moserialSerialStreamRecorder *self);
};

typedef enum  {
	MOSERIAL_SERIAL_STREAM_RECORDER_DIRECTION_INCOMING,
	MOSERIAL_SERIAL_STREAM_RECORDER_DIRECTION_OUTGOING,
	MOSERIAL_SERIAL_STREAM_RECORDER_DIRECTION_BOTH,
	MOSERIAL_SERIAL_STREAM_RECORDER_DIRECTION_NULL
} moserialSerialStreamRecorderDirection;

struct _moserialSerialStreamRecorderPrivate {
	GFile* file;
	char* uri;
	gboolean isOpen;
	GFileOutputStream* fos;
	moserialSerialStreamRecorderDirection direction;
};

struct _moserialParamSpecSerialStreamRecorder {
	GParamSpec parent_instance;
};


static gpointer moserial_serial_stream_recorder_parent_class = NULL;

gpointer moserial_serial_stream_recorder_ref (gpointer instance);
void moserial_serial_stream_recorder_unref (gpointer instance);
GParamSpec* moserial_param_spec_serial_stream_recorder (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void moserial_value_set_serial_stream_recorder (GValue* value, gpointer v_object);
gpointer moserial_value_get_serial_stream_recorder (const GValue* value);
GType moserial_serial_stream_recorder_get_type (void);
GType moserial_serial_stream_recorder_direction_get_type (void);
#define MOSERIAL_SERIAL_STREAM_RECORDER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), MOSERIAL_TYPE_SERIAL_STREAM_RECORDER, moserialSerialStreamRecorderPrivate))
enum  {
	MOSERIAL_SERIAL_STREAM_RECORDER_DUMMY_PROPERTY
};
void moserial_serial_stream_recorder_open (moserialSerialStreamRecorder* self, const char* filename, moserialSerialStreamRecorderDirection direction, GError** error);
static void moserial_serial_stream_recorder_write (moserialSerialStreamRecorder* self, guchar data);
void moserial_serial_stream_recorder_writeOutgoing (moserialSerialStreamRecorder* self, guchar data);
void moserial_serial_stream_recorder_writeIncoming (moserialSerialStreamRecorder* self, guchar data);
gint64 mo_utils_fileSize (const char* path);
void moserial_serial_stream_recorder_close (moserialSerialStreamRecorder* self, gboolean launch);
moserialSerialStreamRecorder* moserial_serial_stream_recorder_new (void);
moserialSerialStreamRecorder* moserial_serial_stream_recorder_construct (GType object_type);
static void moserial_serial_stream_recorder_finalize (moserialSerialStreamRecorder* obj);




GType moserial_serial_stream_recorder_direction_get_type (void) {
	static GType moserial_serial_stream_recorder_direction_type_id = 0;
	if (G_UNLIKELY (moserial_serial_stream_recorder_direction_type_id == 0)) {
		static const GEnumValue values[] = {{MOSERIAL_SERIAL_STREAM_RECORDER_DIRECTION_INCOMING, "MOSERIAL_SERIAL_STREAM_RECORDER_DIRECTION_INCOMING", "incoming"}, {MOSERIAL_SERIAL_STREAM_RECORDER_DIRECTION_OUTGOING, "MOSERIAL_SERIAL_STREAM_RECORDER_DIRECTION_OUTGOING", "outgoing"}, {MOSERIAL_SERIAL_STREAM_RECORDER_DIRECTION_BOTH, "MOSERIAL_SERIAL_STREAM_RECORDER_DIRECTION_BOTH", "both"}, {MOSERIAL_SERIAL_STREAM_RECORDER_DIRECTION_NULL, "MOSERIAL_SERIAL_STREAM_RECORDER_DIRECTION_NULL", "null"}, {0, NULL, NULL}};
		moserial_serial_stream_recorder_direction_type_id = g_enum_register_static ("moserialSerialStreamRecorderDirection", values);
	}
	return moserial_serial_stream_recorder_direction_type_id;
}


void moserial_serial_stream_recorder_open (moserialSerialStreamRecorder* self, const char* filename, moserialSerialStreamRecorderDirection direction, GError** error) {
	GError * _inner_error_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (filename != NULL);
	_inner_error_ = NULL;
	{
		GFile* _tmp0_;
		GFileOutputStream* _tmp1_;
		GFileOutputStream* _tmp2_;
		char* _tmp3_;
		_tmp0_ = NULL;
		self->priv->file = (_tmp0_ = g_file_new_for_path (filename), (self->priv->file == NULL) ? NULL : (self->priv->file = (g_object_unref (self->priv->file), NULL)), _tmp0_);
		_tmp1_ = g_file_replace (self->priv->file, NULL, FALSE, G_FILE_CREATE_NONE, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch7_g_error;
			goto __finally7;
		}
		_tmp2_ = NULL;
		self->priv->fos = (_tmp2_ = _tmp1_, (self->priv->fos == NULL) ? NULL : (self->priv->fos = (g_object_unref (self->priv->fos), NULL)), _tmp2_);
		self->priv->isOpen = TRUE;
		_tmp3_ = NULL;
		self->priv->uri = (_tmp3_ = g_file_get_uri (self->priv->file), self->priv->uri = (g_free (self->priv->uri), NULL), _tmp3_);
		self->priv->direction = direction;
	}
	goto __finally7;
	__catch7_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			GFile* _tmp4_;
			GFileOutputStream* _tmp5_;
			GError* _tmp6_;
			self->priv->isOpen = FALSE;
			_tmp4_ = NULL;
			self->priv->file = (_tmp4_ = NULL, (self->priv->file == NULL) ? NULL : (self->priv->file = (g_object_unref (self->priv->file), NULL)), _tmp4_);
			_tmp5_ = NULL;
			self->priv->fos = (_tmp5_ = NULL, (self->priv->fos == NULL) ? NULL : (self->priv->fos = (g_object_unref (self->priv->fos), NULL)), _tmp5_);
			_tmp6_ = NULL;
			_inner_error_ = (_tmp6_ = e, (_tmp6_ == NULL) ? ((gpointer) _tmp6_) : g_error_copy (_tmp6_));
			if (_inner_error_ != NULL) {
				(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
				goto __finally7;
			}
			(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
		}
	}
	__finally7:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
}


static void moserial_serial_stream_recorder_write (moserialSerialStreamRecorder* self, guchar data) {
	GError * _inner_error_;
	g_return_if_fail (self != NULL);
	_inner_error_ = NULL;
	if (self->priv->isOpen) {
		guchar* _tmp0_;
		gint o_size;
		gint o_length1;
		guchar* o;
		_tmp0_ = NULL;
		o = (_tmp0_ = g_new0 (guchar, 1), o_length1 = 1, o_size = o_length1, _tmp0_);
		o[0] = data;
		{
			g_output_stream_write ((GOutputStream*) self->priv->fos, o, (gsize) 1, NULL, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch8_g_error;
				goto __finally8;
			}
		}
		goto __finally8;
		__catch8_g_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			{
				fprintf (stdout, _ ("error: %s\n"), e->message);
				(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
			}
		}
		__finally8:
		if (_inner_error_ != NULL) {
			o = (g_free (o), NULL);
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return;
		}
		o = (g_free (o), NULL);
	}
}


/* What should be done here?*/
void moserial_serial_stream_recorder_writeOutgoing (moserialSerialStreamRecorder* self, guchar data) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = FALSE;
	if (self->priv->isOpen) {
		gboolean _tmp1_;
		_tmp1_ = FALSE;
		if (self->priv->direction == MOSERIAL_SERIAL_STREAM_RECORDER_DIRECTION_OUTGOING) {
			_tmp1_ = TRUE;
		} else {
			_tmp1_ = self->priv->direction == MOSERIAL_SERIAL_STREAM_RECORDER_DIRECTION_BOTH;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		moserial_serial_stream_recorder_write (self, data);
	}
}


void moserial_serial_stream_recorder_writeIncoming (moserialSerialStreamRecorder* self, guchar data) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = FALSE;
	if (self->priv->isOpen) {
		gboolean _tmp1_;
		_tmp1_ = FALSE;
		if (self->priv->direction == MOSERIAL_SERIAL_STREAM_RECORDER_DIRECTION_INCOMING) {
			_tmp1_ = TRUE;
		} else {
			_tmp1_ = self->priv->direction == MOSERIAL_SERIAL_STREAM_RECORDER_DIRECTION_BOTH;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		moserial_serial_stream_recorder_write (self, data);
	}
}


void moserial_serial_stream_recorder_close (moserialSerialStreamRecorder* self, gboolean launch) {
	GError * _inner_error_;
	g_return_if_fail (self != NULL);
	_inner_error_ = NULL;
	if (self->priv->isOpen) {
		gboolean _tmp0_;
		GFileOutputStream* _tmp1_;
		GFile* _tmp2_;
		{
			g_output_stream_flush ((GOutputStream*) self->priv->fos, NULL, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch9_g_error;
				goto __finally9;
			}
			g_output_stream_close ((GOutputStream*) self->priv->fos, NULL, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch9_g_error;
				goto __finally9;
			}
		}
		goto __finally9;
		__catch9_g_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			{
				fprintf (stdout, _ ("error: %s\n"), e->message);
				(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
			}
		}
		__finally9:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp0_ = FALSE;
		if (launch) {
			_tmp0_ = mo_utils_fileSize (self->priv->uri) > 0;
		} else {
			_tmp0_ = FALSE;
		}
		/* Error closing the file?
		 TODO: allow this feature to be enabled / disabled */
		if (_tmp0_) {
			{
				gtk_show_uri (NULL, self->priv->uri, (guint32) GDK_CURRENT_TIME, &_inner_error_);
				if (_inner_error_ != NULL) {
					goto __catch10_g_error;
					goto __finally10;
				}
			}
			goto __finally10;
			__catch10_g_error:
			{
				GError * e;
				e = _inner_error_;
				_inner_error_ = NULL;
				{
					g_warning (_ ("Unable to launch %s: %s"), self->priv->uri, e->message);
					(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
				}
			}
			__finally10:
			if (_inner_error_ != NULL) {
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_tmp1_ = NULL;
		self->priv->fos = (_tmp1_ = NULL, (self->priv->fos == NULL) ? NULL : (self->priv->fos = (g_object_unref (self->priv->fos), NULL)), _tmp1_);
		_tmp2_ = NULL;
		self->priv->file = (_tmp2_ = NULL, (self->priv->file == NULL) ? NULL : (self->priv->file = (g_object_unref (self->priv->file), NULL)), _tmp2_);
		self->priv->isOpen = FALSE;
	}
}


moserialSerialStreamRecorder* moserial_serial_stream_recorder_construct (GType object_type) {
	moserialSerialStreamRecorder* self;
	self = (moserialSerialStreamRecorder*) g_type_create_instance (object_type);
	return self;
}


moserialSerialStreamRecorder* moserial_serial_stream_recorder_new (void) {
	return moserial_serial_stream_recorder_construct (MOSERIAL_TYPE_SERIAL_STREAM_RECORDER);
}


static void moserial_value_serial_stream_recorder_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void moserial_value_serial_stream_recorder_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		moserial_serial_stream_recorder_unref (value->data[0].v_pointer);
	}
}


static void moserial_value_serial_stream_recorder_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = moserial_serial_stream_recorder_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer moserial_value_serial_stream_recorder_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* moserial_value_serial_stream_recorder_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		moserialSerialStreamRecorder* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = moserial_serial_stream_recorder_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* moserial_value_serial_stream_recorder_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	moserialSerialStreamRecorder** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags && G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = moserial_serial_stream_recorder_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* moserial_param_spec_serial_stream_recorder (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	moserialParamSpecSerialStreamRecorder* spec;
	g_return_val_if_fail (g_type_is_a (object_type, MOSERIAL_TYPE_SERIAL_STREAM_RECORDER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer moserial_value_get_serial_stream_recorder (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, MOSERIAL_TYPE_SERIAL_STREAM_RECORDER), NULL);
	return value->data[0].v_pointer;
}


void moserial_value_set_serial_stream_recorder (GValue* value, gpointer v_object) {
	moserialSerialStreamRecorder* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, MOSERIAL_TYPE_SERIAL_STREAM_RECORDER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, MOSERIAL_TYPE_SERIAL_STREAM_RECORDER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		moserial_serial_stream_recorder_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		moserial_serial_stream_recorder_unref (old);
	}
}


static void moserial_serial_stream_recorder_class_init (moserialSerialStreamRecorderClass * klass) {
	moserial_serial_stream_recorder_parent_class = g_type_class_peek_parent (klass);
	MOSERIAL_SERIAL_STREAM_RECORDER_CLASS (klass)->finalize = moserial_serial_stream_recorder_finalize;
	g_type_class_add_private (klass, sizeof (moserialSerialStreamRecorderPrivate));
}


static void moserial_serial_stream_recorder_instance_init (moserialSerialStreamRecorder * self) {
	self->priv = MOSERIAL_SERIAL_STREAM_RECORDER_GET_PRIVATE (self);
	self->priv->isOpen = FALSE;
	self->ref_count = 1;
}


static void moserial_serial_stream_recorder_finalize (moserialSerialStreamRecorder* obj) {
	moserialSerialStreamRecorder * self;
	self = MOSERIAL_SERIAL_STREAM_RECORDER (obj);
	(self->priv->file == NULL) ? NULL : (self->priv->file = (g_object_unref (self->priv->file), NULL));
	self->priv->uri = (g_free (self->priv->uri), NULL);
	(self->priv->fos == NULL) ? NULL : (self->priv->fos = (g_object_unref (self->priv->fos), NULL));
}


GType moserial_serial_stream_recorder_get_type (void) {
	static GType moserial_serial_stream_recorder_type_id = 0;
	if (moserial_serial_stream_recorder_type_id == 0) {
		static const GTypeValueTable g_define_type_value_table = { moserial_value_serial_stream_recorder_init, moserial_value_serial_stream_recorder_free_value, moserial_value_serial_stream_recorder_copy_value, moserial_value_serial_stream_recorder_peek_pointer, "p", moserial_value_serial_stream_recorder_collect_value, "p", moserial_value_serial_stream_recorder_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (moserialSerialStreamRecorderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) moserial_serial_stream_recorder_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (moserialSerialStreamRecorder), 0, (GInstanceInitFunc) moserial_serial_stream_recorder_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		moserial_serial_stream_recorder_type_id = g_type_register_fundamental (g_type_fundamental_next (), "moserialSerialStreamRecorder", &g_define_type_info, &g_define_type_fundamental_info, 0);
	}
	return moserial_serial_stream_recorder_type_id;
}


gpointer moserial_serial_stream_recorder_ref (gpointer instance) {
	moserialSerialStreamRecorder* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void moserial_serial_stream_recorder_unref (gpointer instance) {
	moserialSerialStreamRecorder* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		MOSERIAL_SERIAL_STREAM_RECORDER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}




