
#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <pango/pango.h>
#include <gdk/gdk.h>
#include <config.h>


#define MOSERIAL_TYPE_MAIN_WINDOW (moserial_main_window_get_type ())
#define MOSERIAL_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MOSERIAL_TYPE_MAIN_WINDOW, moserialMainWindow))
#define MOSERIAL_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MOSERIAL_TYPE_MAIN_WINDOW, moserialMainWindowClass))
#define MOSERIAL_IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MOSERIAL_TYPE_MAIN_WINDOW))
#define MOSERIAL_IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MOSERIAL_TYPE_MAIN_WINDOW))
#define MOSERIAL_MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MOSERIAL_TYPE_MAIN_WINDOW, moserialMainWindowClass))

typedef struct _moserialMainWindow moserialMainWindow;
typedef struct _moserialMainWindowClass moserialMainWindowClass;
typedef struct _moserialMainWindowPrivate moserialMainWindowPrivate;

#define MOSERIAL_TYPE_SETTINGS_DIALOG (moserial_settings_dialog_get_type ())
#define MOSERIAL_SETTINGS_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MOSERIAL_TYPE_SETTINGS_DIALOG, moserialSettingsDialog))
#define MOSERIAL_SETTINGS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MOSERIAL_TYPE_SETTINGS_DIALOG, moserialSettingsDialogClass))
#define MOSERIAL_IS_SETTINGS_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MOSERIAL_TYPE_SETTINGS_DIALOG))
#define MOSERIAL_IS_SETTINGS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MOSERIAL_TYPE_SETTINGS_DIALOG))
#define MOSERIAL_SETTINGS_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MOSERIAL_TYPE_SETTINGS_DIALOG, moserialSettingsDialogClass))

typedef struct _moserialSettingsDialog moserialSettingsDialog;
typedef struct _moserialSettingsDialogClass moserialSettingsDialogClass;

#define TYPE_SETTINGS (settings_get_type ())
#define SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SETTINGS, Settings))
#define SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SETTINGS, SettingsClass))
#define IS_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SETTINGS))
#define IS_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SETTINGS))
#define SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SETTINGS, SettingsClass))

typedef struct _Settings Settings;
typedef struct _SettingsClass SettingsClass;

#define TYPE_PREFERENCES (preferences_get_type ())
#define PREFERENCES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PREFERENCES, Preferences))
#define PREFERENCES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PREFERENCES, PreferencesClass))
#define IS_PREFERENCES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PREFERENCES))
#define IS_PREFERENCES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PREFERENCES))
#define PREFERENCES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PREFERENCES, PreferencesClass))

typedef struct _Preferences Preferences;
typedef struct _PreferencesClass PreferencesClass;

#define TYPE_DEFAULT_PATHS (default_paths_get_type ())
#define DEFAULT_PATHS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DEFAULT_PATHS, DefaultPaths))
#define DEFAULT_PATHS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DEFAULT_PATHS, DefaultPathsClass))
#define IS_DEFAULT_PATHS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DEFAULT_PATHS))
#define IS_DEFAULT_PATHS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DEFAULT_PATHS))
#define DEFAULT_PATHS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DEFAULT_PATHS, DefaultPathsClass))

typedef struct _DefaultPaths DefaultPaths;
typedef struct _DefaultPathsClass DefaultPathsClass;

#define MOSERIAL_TYPE_SEND_PROGRESS_DIALOG (moserial_send_progress_dialog_get_type ())
#define MOSERIAL_SEND_PROGRESS_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MOSERIAL_TYPE_SEND_PROGRESS_DIALOG, moserialSendProgressDialog))
#define MOSERIAL_SEND_PROGRESS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MOSERIAL_TYPE_SEND_PROGRESS_DIALOG, moserialSendProgressDialogClass))
#define MOSERIAL_IS_SEND_PROGRESS_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MOSERIAL_TYPE_SEND_PROGRESS_DIALOG))
#define MOSERIAL_IS_SEND_PROGRESS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MOSERIAL_TYPE_SEND_PROGRESS_DIALOG))
#define MOSERIAL_SEND_PROGRESS_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MOSERIAL_TYPE_SEND_PROGRESS_DIALOG, moserialSendProgressDialogClass))

typedef struct _moserialSendProgressDialog moserialSendProgressDialog;
typedef struct _moserialSendProgressDialogClass moserialSendProgressDialogClass;

#define MOSERIAL_TYPE_SEND_CHOOSER_DIALOG (moserial_send_chooser_dialog_get_type ())
#define MOSERIAL_SEND_CHOOSER_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MOSERIAL_TYPE_SEND_CHOOSER_DIALOG, moserialSendChooserDialog))
#define MOSERIAL_SEND_CHOOSER_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MOSERIAL_TYPE_SEND_CHOOSER_DIALOG, moserialSendChooserDialogClass))
#define MOSERIAL_IS_SEND_CHOOSER_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MOSERIAL_TYPE_SEND_CHOOSER_DIALOG))
#define MOSERIAL_IS_SEND_CHOOSER_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MOSERIAL_TYPE_SEND_CHOOSER_DIALOG))
#define MOSERIAL_SEND_CHOOSER_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MOSERIAL_TYPE_SEND_CHOOSER_DIALOG, moserialSendChooserDialogClass))

typedef struct _moserialSendChooserDialog moserialSendChooserDialog;
typedef struct _moserialSendChooserDialogClass moserialSendChooserDialogClass;

#define MOSERIAL_TYPE_RECEIVE_PROGRESS_DIALOG (moserial_receive_progress_dialog_get_type ())
#define MOSERIAL_RECEIVE_PROGRESS_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MOSERIAL_TYPE_RECEIVE_PROGRESS_DIALOG, moserialReceiveProgressDialog))
#define MOSERIAL_RECEIVE_PROGRESS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MOSERIAL_TYPE_RECEIVE_PROGRESS_DIALOG, moserialReceiveProgressDialogClass))
#define MOSERIAL_IS_RECEIVE_PROGRESS_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MOSERIAL_TYPE_RECEIVE_PROGRESS_DIALOG))
#define MOSERIAL_IS_RECEIVE_PROGRESS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MOSERIAL_TYPE_RECEIVE_PROGRESS_DIALOG))
#define MOSERIAL_RECEIVE_PROGRESS_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MOSERIAL_TYPE_RECEIVE_PROGRESS_DIALOG, moserialReceiveProgressDialogClass))

typedef struct _moserialReceiveProgressDialog moserialReceiveProgressDialog;
typedef struct _moserialReceiveProgressDialogClass moserialReceiveProgressDialogClass;

#define MOSERIAL_TYPE_RECEIVE_CHOOSER_DIALOG (moserial_receive_chooser_dialog_get_type ())
#define MOSERIAL_RECEIVE_CHOOSER_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MOSERIAL_TYPE_RECEIVE_CHOOSER_DIALOG, moserialReceiveChooserDialog))
#define MOSERIAL_RECEIVE_CHOOSER_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MOSERIAL_TYPE_RECEIVE_CHOOSER_DIALOG, moserialReceiveChooserDialogClass))
#define MOSERIAL_IS_RECEIVE_CHOOSER_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MOSERIAL_TYPE_RECEIVE_CHOOSER_DIALOG))
#define MOSERIAL_IS_RECEIVE_CHOOSER_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MOSERIAL_TYPE_RECEIVE_CHOOSER_DIALOG))
#define MOSERIAL_RECEIVE_CHOOSER_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MOSERIAL_TYPE_RECEIVE_CHOOSER_DIALOG, moserialReceiveChooserDialogClass))

typedef struct _moserialReceiveChooserDialog moserialReceiveChooserDialog;
typedef struct _moserialReceiveChooserDialogClass moserialReceiveChooserDialogClass;

#define MOSERIAL_TYPE_RECORD_DIALOG (moserial_record_dialog_get_type ())
#define MOSERIAL_RECORD_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MOSERIAL_TYPE_RECORD_DIALOG, moserialRecordDialog))
#define MOSERIAL_RECORD_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MOSERIAL_TYPE_RECORD_DIALOG, moserialRecordDialogClass))
#define MOSERIAL_IS_RECORD_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MOSERIAL_TYPE_RECORD_DIALOG))
#define MOSERIAL_IS_RECORD_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MOSERIAL_TYPE_RECORD_DIALOG))
#define MOSERIAL_RECORD_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MOSERIAL_TYPE_RECORD_DIALOG, moserialRecordDialogClass))

typedef struct _moserialRecordDialog moserialRecordDialog;
typedef struct _moserialRecordDialogClass moserialRecordDialogClass;

#define MOSERIAL_TYPE_PREFERENCES_DIALOG (moserial_preferences_dialog_get_type ())
#define MOSERIAL_PREFERENCES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MOSERIAL_TYPE_PREFERENCES_DIALOG, moserialPreferencesDialog))
#define MOSERIAL_PREFERENCES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MOSERIAL_TYPE_PREFERENCES_DIALOG, moserialPreferencesDialogClass))
#define MOSERIAL_IS_PREFERENCES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MOSERIAL_TYPE_PREFERENCES_DIALOG))
#define MOSERIAL_IS_PREFERENCES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MOSERIAL_TYPE_PREFERENCES_DIALOG))
#define MOSERIAL_PREFERENCES_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MOSERIAL_TYPE_PREFERENCES_DIALOG, moserialPreferencesDialogClass))

typedef struct _moserialPreferencesDialog moserialPreferencesDialog;
typedef struct _moserialPreferencesDialogClass moserialPreferencesDialogClass;

#define MOSERIAL_TYPE_SERIAL_CONNECTION (moserial_serial_connection_get_type ())
#define MOSERIAL_SERIAL_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MOSERIAL_TYPE_SERIAL_CONNECTION, moserialSerialConnection))
#define MOSERIAL_SERIAL_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MOSERIAL_TYPE_SERIAL_CONNECTION, moserialSerialConnectionClass))
#define MOSERIAL_IS_SERIAL_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MOSERIAL_TYPE_SERIAL_CONNECTION))
#define MOSERIAL_IS_SERIAL_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MOSERIAL_TYPE_SERIAL_CONNECTION))
#define MOSERIAL_SERIAL_CONNECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MOSERIAL_TYPE_SERIAL_CONNECTION, moserialSerialConnectionClass))

typedef struct _moserialSerialConnection moserialSerialConnection;
typedef struct _moserialSerialConnectionClass moserialSerialConnectionClass;

#define MOSERIAL_TYPE_HEX_TEXT_BUFFER (moserial_hex_text_buffer_get_type ())
#define MOSERIAL_HEX_TEXT_BUFFER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MOSERIAL_TYPE_HEX_TEXT_BUFFER, moserialHexTextBuffer))
#define MOSERIAL_HEX_TEXT_BUFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MOSERIAL_TYPE_HEX_TEXT_BUFFER, moserialHexTextBufferClass))
#define MOSERIAL_IS_HEX_TEXT_BUFFER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MOSERIAL_TYPE_HEX_TEXT_BUFFER))
#define MOSERIAL_IS_HEX_TEXT_BUFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MOSERIAL_TYPE_HEX_TEXT_BUFFER))
#define MOSERIAL_HEX_TEXT_BUFFER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MOSERIAL_TYPE_HEX_TEXT_BUFFER, moserialHexTextBufferClass))

typedef struct _moserialHexTextBuffer moserialHexTextBuffer;
typedef struct _moserialHexTextBufferClass moserialHexTextBufferClass;

#define MOSERIAL_TYPE_XMODEM_FILENAME_DIALOG (moserial_xmodem_filename_dialog_get_type ())
#define MOSERIAL_XMODEM_FILENAME_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MOSERIAL_TYPE_XMODEM_FILENAME_DIALOG, moserialXmodemFilenameDialog))
#define MOSERIAL_XMODEM_FILENAME_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MOSERIAL_TYPE_XMODEM_FILENAME_DIALOG, moserialXmodemFilenameDialogClass))
#define MOSERIAL_IS_XMODEM_FILENAME_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MOSERIAL_TYPE_XMODEM_FILENAME_DIALOG))
#define MOSERIAL_IS_XMODEM_FILENAME_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MOSERIAL_TYPE_XMODEM_FILENAME_DIALOG))
#define MOSERIAL_XMODEM_FILENAME_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MOSERIAL_TYPE_XMODEM_FILENAME_DIALOG, moserialXmodemFilenameDialogClass))

typedef struct _moserialXmodemFilenameDialog moserialXmodemFilenameDialog;
typedef struct _moserialXmodemFilenameDialogClass moserialXmodemFilenameDialogClass;

#define MOSERIAL_TYPE_SERIAL_STREAM_RECORDER (moserial_serial_stream_recorder_get_type ())
#define MOSERIAL_SERIAL_STREAM_RECORDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MOSERIAL_TYPE_SERIAL_STREAM_RECORDER, moserialSerialStreamRecorder))
#define MOSERIAL_SERIAL_STREAM_RECORDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MOSERIAL_TYPE_SERIAL_STREAM_RECORDER, moserialSerialStreamRecorderClass))
#define MOSERIAL_IS_SERIAL_STREAM_RECORDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MOSERIAL_TYPE_SERIAL_STREAM_RECORDER))
#define MOSERIAL_IS_SERIAL_STREAM_RECORDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MOSERIAL_TYPE_SERIAL_STREAM_RECORDER))
#define MOSERIAL_SERIAL_STREAM_RECORDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MOSERIAL_TYPE_SERIAL_STREAM_RECORDER, moserialSerialStreamRecorderClass))

typedef struct _moserialSerialStreamRecorder moserialSerialStreamRecorder;
typedef struct _moserialSerialStreamRecorderClass moserialSerialStreamRecorderClass;

#define MOSERIAL_TYPE_RZWRAPPER (moserial_rzwrapper_get_type ())
#define MOSERIAL_RZWRAPPER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MOSERIAL_TYPE_RZWRAPPER, moserialRzwrapper))
#define MOSERIAL_RZWRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MOSERIAL_TYPE_RZWRAPPER, moserialRzwrapperClass))
#define MOSERIAL_IS_RZWRAPPER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MOSERIAL_TYPE_RZWRAPPER))
#define MOSERIAL_IS_RZWRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MOSERIAL_TYPE_RZWRAPPER))
#define MOSERIAL_RZWRAPPER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MOSERIAL_TYPE_RZWRAPPER, moserialRzwrapperClass))

typedef struct _moserialRzwrapper moserialRzwrapper;
typedef struct _moserialRzwrapperClass moserialRzwrapperClass;

#define MOSERIAL_TYPE_SZWRAPPER (moserial_szwrapper_get_type ())
#define MOSERIAL_SZWRAPPER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MOSERIAL_TYPE_SZWRAPPER, moserialSzwrapper))
#define MOSERIAL_SZWRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MOSERIAL_TYPE_SZWRAPPER, moserialSzwrapperClass))
#define MOSERIAL_IS_SZWRAPPER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MOSERIAL_TYPE_SZWRAPPER))
#define MOSERIAL_IS_SZWRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MOSERIAL_TYPE_SZWRAPPER))
#define MOSERIAL_SZWRAPPER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MOSERIAL_TYPE_SZWRAPPER, moserialSzwrapperClass))

typedef struct _moserialSzwrapper moserialSzwrapper;
typedef struct _moserialSzwrapperClass moserialSzwrapperClass;

#define TYPE_PROFILE (profile_get_type ())
#define PROFILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROFILE, Profile))
#define PROFILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROFILE, ProfileClass))
#define IS_PROFILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROFILE))
#define IS_PROFILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROFILE))
#define PROFILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROFILE, ProfileClass))

typedef struct _Profile Profile;
typedef struct _ProfileClass ProfileClass;
typedef struct _moserialSerialConnectionPrivate moserialSerialConnectionPrivate;

#define MOSERIAL_SZWRAPPER_TYPE_PROTOCOL (moserial_szwrapper_protocol_get_type ())
typedef struct _moserialSendChooserDialogPrivate moserialSendChooserDialogPrivate;
typedef struct _moserialSzwrapperPrivate moserialSzwrapperPrivate;
typedef struct _moserialReceiveChooserDialogPrivate moserialReceiveChooserDialogPrivate;
typedef struct _moserialXmodemFilenameDialogPrivate moserialXmodemFilenameDialogPrivate;

#define MOSERIAL_RZWRAPPER_TYPE_PROTOCOL (moserial_rzwrapper_protocol_get_type ())
typedef struct _moserialRzwrapperPrivate moserialRzwrapperPrivate;

#define MOSERIAL_SERIAL_STREAM_RECORDER_TYPE_DIRECTION (moserial_serial_stream_recorder_direction_get_type ())

struct _moserialMainWindow {
	GtkWindow parent_instance;
	moserialMainWindowPrivate * priv;
};

struct _moserialMainWindowClass {
	GtkWindowClass parent_class;
};

struct _moserialMainWindowPrivate {
	GtkBuilder* _builder;
	GtkWindow* gtkWindow;
	moserialSettingsDialog* settingsDialog;
	GtkToolButton* settingsButton;
	GtkToggleToolButton* recordButton;
	Settings* currentSettings;
	Preferences* currentPreferences;
	DefaultPaths* currentPaths;
	GtkStatusbar* statusbar;
	GtkStatusbar* bytecountbar;
	guint statusbarContext;
	guint bytecountbarContext;
	GtkToolButton* send;
	moserialSendProgressDialog* sendProgressDialog;
	moserialSendChooserDialog* sendChooserDialog;
	GtkToolButton* receive;
	moserialReceiveProgressDialog* receiveProgressDialog;
	moserialReceiveChooserDialog* receiveChooserDialog;
	moserialRecordDialog* recordDialog;
	moserialPreferencesDialog* preferencesDialog;
	moserialSerialConnection* serialConnection;
	GtkTextView* incomingHexTextView;
	GtkTextView* incomingAsciiTextView;
	GtkTextView* outgoingHexTextView;
	GtkTextView* outgoingAsciiTextView;
	GtkComboBox* inputMode;
	GtkComboBox* terminationMode;
	GtkToggleToolButton* connectButton;
	GtkLabel* disconnectLabel;
	GtkLabel* connectLabel;
	GtkLabel* recordLabel;
	GtkLabel* stopRecordingLabel;
	GtkPaned* paned;
	GtkNotebook* incoming_notebook;
	GtkNotebook* outgoing_notebook;
	moserialHexTextBuffer* incomingHexTextBuffer;
	moserialHexTextBuffer* outgoingHexTextBuffer;
	GtkTextBuffer* incomingAsciiTextBuffer;
	GtkTextTag* echoTag;
	GtkTextBuffer* outgoingAsciiTextBuffer;
	GtkTextMark* echoStartMark;
	moserialXmodemFilenameDialog* xmodemFilenameDialog;
	GtkEntry* entry;
	GtkButton* sendButton;
	moserialSerialStreamRecorder* streamRecorder;
	gboolean recordDataReceived;
	guint recordTimeoutID;
	moserialRzwrapper* rz;
	moserialSzwrapper* sz;
	Profile* profile;
	char* _startupProfileFilename;
	char* profileFilename;
	gboolean profileChanged;
	GtkAction* cutMenuItem;
	GtkAction* copyMenuItem;
	GtkAdjustment* va1;
	GtkAdjustment* va2;
	GtkAdjustment* va3;
	GtkAdjustment* va4;
};

struct _moserialSerialConnection {
	GObject parent_instance;
	moserialSerialConnectionPrivate * priv;
	gulong tx;
	gulong rx;
	gulong nonprintable;
	gboolean forced_hex_view;
	gboolean lastRxCharWasCR;
	char* echoReference;
	char* echoCompare;
};

struct _moserialSerialConnectionClass {
	GObjectClass parent_class;
};

typedef enum  {
	HEX_PARSE_ERROR_INVALID_INPUT
} HexParseError;
#define HEX_PARSE_ERROR hex_parse_error_quark ()
typedef enum  {
	MOSERIAL_SZWRAPPER_PROTOCOL_XMODEM,
	MOSERIAL_SZWRAPPER_PROTOCOL_YMODEM,
	MOSERIAL_SZWRAPPER_PROTOCOL_ZMODEM,
	MOSERIAL_SZWRAPPER_PROTOCOL_RAW,
	MOSERIAL_SZWRAPPER_PROTOCOL_NULL
} moserialSzwrapperProtocol;

struct _moserialSendChooserDialog {
	GObject parent_instance;
	moserialSendChooserDialogPrivate * priv;
	GtkComboBox* protocolCombo;
	char* filename;
};

struct _moserialSendChooserDialogClass {
	GObjectClass parent_class;
};

struct _moserialSzwrapper {
	GObject parent_instance;
	moserialSzwrapperPrivate * priv;
	gboolean running;
};

struct _moserialSzwrapperClass {
	GObjectClass parent_class;
};

struct _moserialReceiveChooserDialog {
	GObject parent_instance;
	moserialReceiveChooserDialogPrivate * priv;
	GtkComboBox* protocolCombo;
	char* path;
};

struct _moserialReceiveChooserDialogClass {
	GObjectClass parent_class;
};

struct _moserialXmodemFilenameDialog {
	GObject parent_instance;
	moserialXmodemFilenameDialogPrivate * priv;
	char* filename;
};

struct _moserialXmodemFilenameDialogClass {
	GObjectClass parent_class;
};

typedef enum  {
	MOSERIAL_RZWRAPPER_PROTOCOL_XMODEM,
	MOSERIAL_RZWRAPPER_PROTOCOL_YMODEM,
	MOSERIAL_RZWRAPPER_PROTOCOL_ZMODEM,
	MOSERIAL_RZWRAPPER_PROTOCOL_NULL
} moserialRzwrapperProtocol;

struct _moserialRzwrapper {
	GObject parent_instance;
	moserialRzwrapperPrivate * priv;
	gboolean running;
};

struct _moserialRzwrapperClass {
	GObjectClass parent_class;
};

typedef enum  {
	MOSERIAL_SERIAL_STREAM_RECORDER_DIRECTION_INCOMING,
	MOSERIAL_SERIAL_STREAM_RECORDER_DIRECTION_OUTGOING,
	MOSERIAL_SERIAL_STREAM_RECORDER_DIRECTION_BOTH,
	MOSERIAL_SERIAL_STREAM_RECORDER_DIRECTION_NULL
} moserialSerialStreamRecorderDirection;


static gpointer moserial_main_window_parent_class = NULL;

GType moserial_main_window_get_type (void);
GType moserial_settings_dialog_get_type (void);
GType settings_get_type (void);
GType preferences_get_type (void);
GType default_paths_get_type (void);
GType moserial_send_progress_dialog_get_type (void);
GType moserial_send_chooser_dialog_get_type (void);
GType moserial_receive_progress_dialog_get_type (void);
GType moserial_receive_chooser_dialog_get_type (void);
GType moserial_record_dialog_get_type (void);
GType moserial_preferences_dialog_get_type (void);
GType moserial_serial_connection_get_type (void);
GType moserial_hex_text_buffer_get_type (void);
GType moserial_xmodem_filename_dialog_get_type (void);
gpointer moserial_serial_stream_recorder_ref (gpointer instance);
void moserial_serial_stream_recorder_unref (gpointer instance);
GParamSpec* moserial_param_spec_serial_stream_recorder (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void moserial_value_set_serial_stream_recorder (GValue* value, gpointer v_object);
gpointer moserial_value_get_serial_stream_recorder (const GValue* value);
GType moserial_serial_stream_recorder_get_type (void);
GType moserial_rzwrapper_get_type (void);
GType moserial_szwrapper_get_type (void);
GType profile_get_type (void);
#define MOSERIAL_MAIN_WINDOW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), MOSERIAL_TYPE_MAIN_WINDOW, moserialMainWindowPrivate))
enum  {
	MOSERIAL_MAIN_WINDOW_DUMMY_PROPERTY,
	MOSERIAL_MAIN_WINDOW_BUILDER,
	MOSERIAL_MAIN_WINDOW_STARTUP_PROFILE_FILENAME
};
moserialSerialConnection* moserial_serial_connection_new (void);
moserialSerialConnection* moserial_serial_connection_construct (GType object_type);
moserialSerialStreamRecorder* moserial_serial_stream_recorder_new (void);
moserialSerialStreamRecorder* moserial_serial_stream_recorder_construct (GType object_type);
#define MOSERIAL_MAIN_WINDOW_translators N_ ("translator-credits")
static void moserial_main_window_set_builder (moserialMainWindow* self, GtkBuilder* value);
static void moserial_main_window_set_startupProfileFilename (moserialMainWindow* self, const char* value);
moserialMainWindow* moserial_main_window_new (GtkBuilder* builder, const char* profileFilename);
moserialMainWindow* moserial_main_window_construct (GType object_type, GtkBuilder* builder, const char* profileFilename);
gboolean profile_load (Profile* self, const char* filename, GtkWindow* window);
void moserial_main_window_ensureDisconnected (moserialMainWindow* self);
Settings* settings_loadFromProfile (Profile* profile);
Preferences* preferences_loadFromProfile (Profile* profile);
DefaultPaths* default_paths_loadFromProfile (Profile* profile);
static void moserial_main_window_updatePreferences (moserialMainWindow* self, moserialPreferencesDialog* d, Preferences* newPreferences);
char* settings_getStatusbarString (Settings* self, gboolean open);
static void moserial_main_window_setWindowTitle (moserialMainWindow* self, const char* recordingFilename);
static void moserial_main_window_applyProfile (moserialMainWindow* self, const char* filename);
static void moserial_main_window_recentItemOpen (moserialMainWindow* self, GtkRecentChooser* r);
static void moserial_main_window_insertBufferEnd (moserialMainWindow* self, GtkTextBuffer* buf, const char* s);
gboolean moserial_main_window_ensureConnected (moserialMainWindow* self);
void moserial_serial_connection_sendByte (moserialSerialConnection* self, guchar byte);
void moserial_serial_stream_recorder_writeOutgoing (moserialSerialStreamRecorder* self, guchar data);
void moserial_hex_text_buffer_add (moserialHexTextBuffer* self, guchar data);
char* moserial_serial_connection_getLineEnd (moserialSerialConnection* self, gint e);
GQuark hex_parse_error_quark (void);
guchar* input_parser_parseHex (const char* s, int* result_length1, GError** error);
char* moserial_serial_connection_getBytecountbarString (moserialSerialConnection* self);
void moserial_main_window_sendString (moserialMainWindow* self, GtkWidget* w);
void moserial_send_chooser_dialog_show (moserialSendChooserDialog* self, const char* folder);
const char* default_paths_get_sendFrom (DefaultPaths* self);
static void moserial_main_window_doSendChooser (moserialMainWindow* self, GtkToolButton* button);
GType moserial_szwrapper_protocol_get_type (void);
char* mo_utils_getParentFolder (const char* path);
void default_paths_set_sendFrom (DefaultPaths* self, const char* value);
moserialSzwrapper* moserial_szwrapper_new (moserialSzwrapperProtocol* protocol, moserialSerialConnection* sc, const char* filename);
moserialSzwrapper* moserial_szwrapper_construct (GType object_type, moserialSzwrapperProtocol* protocol, moserialSerialConnection* sc, const char* filename);
void moserial_send_progress_dialog_show (moserialSendProgressDialog* self);
void moserial_send_progress_dialog_updateStatus (moserialSendProgressDialog* self, GObject* o, const char* newStatus);
static void _moserial_send_progress_dialog_updateStatus_moserial_szwrapper_update_status (moserialSzwrapper* _sender, const char* newStatus, gpointer self);
void moserial_szwrapper_transferCanceled (moserialSzwrapper* self, GObject* o);
static void _moserial_szwrapper_transferCanceled_moserial_send_progress_dialog_transfer_canceled (moserialSendProgressDialog* _sender, gpointer self);
void moserial_main_window_sendComplete (moserialMainWindow* self, GObject* o);
static void _moserial_main_window_sendComplete_moserial_szwrapper_transfer_complete (moserialSzwrapper* _sender, gpointer self);
static void moserial_main_window_doSend (moserialMainWindow* self, moserialSendChooserDialog* dialog);
gboolean moserial_send_progress_dialog_hide (moserialSendProgressDialog* self);
void moserial_receive_chooser_dialog_show (moserialReceiveChooserDialog* self, const char* folder);
const char* default_paths_get_receiveTo (DefaultPaths* self);
static void moserial_main_window_doReceiveChooser (moserialMainWindow* self, GtkToolButton* button);
void default_paths_set_receiveTo (DefaultPaths* self, const char* value);
void moserial_xmodem_filename_dialog_show (moserialXmodemFilenameDialog* self);
GType moserial_rzwrapper_protocol_get_type (void);
moserialRzwrapper* moserial_rzwrapper_new (moserialRzwrapperProtocol* protocol, moserialSerialConnection* sc, const char* p, const char* filename);
moserialRzwrapper* moserial_rzwrapper_construct (GType object_type, moserialRzwrapperProtocol* protocol, moserialSerialConnection* sc, const char* p, const char* filename);
void moserial_receive_progress_dialog_show (moserialReceiveProgressDialog* self);
void moserial_receive_progress_dialog_updateStatus (moserialReceiveProgressDialog* self, GObject* o, const char* newStatus);
static void _moserial_receive_progress_dialog_updateStatus_moserial_rzwrapper_update_status (moserialRzwrapper* _sender, const char* newStatus, gpointer self);
void moserial_rzwrapper_transferCanceled (moserialRzwrapper* self, GObject* o);
static void _moserial_rzwrapper_transferCanceled_moserial_receive_progress_dialog_transfer_canceled (moserialReceiveProgressDialog* _sender, gpointer self);
void moserial_main_window_receiveComplete (moserialMainWindow* self, GObject* o);
static void _moserial_main_window_receiveComplete_moserial_rzwrapper_transfer_complete (moserialRzwrapper* _sender, gpointer self);
static void moserial_main_window_doReceive (moserialMainWindow* self, moserialReceiveChooserDialog* dialog);
gboolean moserial_receive_progress_dialog_hide (moserialReceiveProgressDialog* self);
void moserial_record_dialog_show (moserialRecordDialog* self, const char* folder);
const char* default_paths_get_recordTo (DefaultPaths* self);
void moserial_serial_stream_recorder_close (moserialSerialStreamRecorder* self, gboolean launch);
gboolean preferences_get_recordLaunch (Preferences* self);
void moserial_main_window_record (moserialMainWindow* self, GtkToggleToolButton* button);
void moserial_main_window_stopRecording (moserialMainWindow* self, moserialRecordDialog* dialog);
GType moserial_serial_stream_recorder_direction_get_type (void);
void moserial_serial_stream_recorder_open (moserialSerialStreamRecorder* self, const char* filename, moserialSerialStreamRecorderDirection direction, GError** error);
void default_paths_set_recordTo (DefaultPaths* self, const char* value);
void moserial_main_window_startRecording (moserialMainWindow* self, moserialRecordDialog* dialog, const char* filename, moserialSerialStreamRecorderDirection direction);
gboolean moserial_main_window_recordTimeout (moserialMainWindow* self);
void moserial_main_window_showWindow (moserialMainWindow* self);
static void moserial_main_window_updateSettings (moserialMainWindow* self, moserialSettingsDialog* d, Settings* newSettings);
gboolean preferences_get_useSystemMonospaceFont (Preferences* self);
char* preferences_getSystemDefaultMonospaceFont (void);
const char* preferences_get_font (Preferences* self);
GdkColor preferences_getGdkColor (const char* color);
const char* preferences_get_fontColor (Preferences* self);
const char* preferences_get_backgroundColor (Preferences* self);
const char* preferences_get_highlightColor (Preferences* self);
void moserial_hex_text_buffer_applyPreferences (moserialHexTextBuffer* self, Preferences* preferences);
void moserial_settings_dialog_show (moserialSettingsDialog* self, Settings* settings);
static void moserial_main_window_showSettingsDialog (moserialMainWindow* self, GObject* o);
void moserial_preferences_dialog_show (moserialPreferencesDialog* self, Preferences* preferences, gboolean recording);
static void moserial_main_window_showPreferencesDialog (moserialMainWindow* self, GObject* o);
gboolean moserial_serial_connection_doConnect (moserialSerialConnection* self, Settings* settings);
const char* settings_get_device (Settings* self);
void moserial_hex_text_buffer_clear (moserialHexTextBuffer* self);
static void moserial_main_window_updateIncoming (moserialMainWindow* self, moserialSerialConnection* sc, guchar* data, int data_length1, gint size);
static void _moserial_main_window_updateIncoming_moserial_serial_connection_new_data (moserialSerialConnection* _sender, guchar* data, int data_length1, gint size, gpointer self);
static gboolean moserial_main_window_startConnection (moserialMainWindow* self);
void moserial_serial_connection_doDisconnect (moserialSerialConnection* self);
static void moserial_main_window_connectButtonClick (moserialMainWindow* self, GtkToggleToolButton* button);
void moserial_rzwrapper_writeChar (moserialRzwrapper* self, guchar byte);
void moserial_rzwrapper_flush (moserialRzwrapper* self);
void moserial_szwrapper_writeChar (moserialSzwrapper* self, guchar byte);
gboolean preferences_get_enableTimeout (Preferences* self);
gint preferences_get_timeout (Preferences* self);
static gboolean _moserial_main_window_recordTimeout_gsource_func (gpointer self);
void moserial_serial_stream_recorder_writeIncoming (moserialSerialStreamRecorder* self, guchar data);
static void moserial_main_window_inputModeChanged (moserialMainWindow* self, GtkComboBox* inputMode);
static void moserial_main_window_showHelp (moserialMainWindow* self);
static void moserial_main_window_showHelpButton (moserialMainWindow* self, GtkToolButton* button);
static void moserial_main_window_showHelpAction (moserialMainWindow* self, GtkAction* a);
static void moserial_main_window_url_hook (moserialMainWindow* self, GtkAboutDialog* about, const char* link);
static void _moserial_main_window_url_hook_gtk_about_dialog_activate_link_func (GtkAboutDialog* about, const char* link_, gpointer self);
static void moserial_main_window_showAboutDialog (moserialMainWindow* self);
static void moserial_main_window_windowSizeSave (moserialMainWindow* self);
static void moserial_main_window_quitSave (moserialMainWindow* self);
static void moserial_main_window_quitSizeSave (moserialMainWindow* self);
static gboolean moserial_main_window_deleteSaveSize (moserialMainWindow* self, GtkWidget* widget, GdkEvent* event);
void moserial_auto_scroll_scroll (GtkAdjustment* va);
static gboolean moserial_main_window_keyPress (moserialMainWindow* self, GtkWidget* widget, const GdkEventKey* key);
void profile_saveWindowSize (Profile* self, gint w, gint h);
void profile_saveWindowPanedPosition (Profile* self, gint pos);
void preferences_saveToProfile (Preferences* self, Profile* profile);
void settings_saveToProfile (Settings* self, Profile* profile);
void default_paths_saveToProfile (DefaultPaths* self, Profile* profile);
static void moserial_main_window_saveProfile (moserialMainWindow* self);
void profile_save (Profile* self, const char* filename, GtkWindow* window);
static void moserial_main_window_saveProfileAs (moserialMainWindow* self);
static void moserial_main_window_loadProfileOnStartup (moserialMainWindow* self, const char* profileFilename);
static void moserial_main_window_loadProfile (moserialMainWindow* self);
static void moserial_main_window_copy (moserialMainWindow* self);
static void moserial_main_window_cut (moserialMainWindow* self);
static void moserial_main_window_editMenu (moserialMainWindow* self, GtkAction* a);
static void moserial_main_window_paste (moserialMainWindow* self);
static void moserial_main_window_clear (moserialMainWindow* self);
GtkBuilder* moserial_main_window_get_builder (moserialMainWindow* self);
const char* moserial_main_window_get_startupProfileFilename (moserialMainWindow* self);
static void _moserial_main_window_quitSave_gtk_object_destroy (GtkWindow* _sender, gpointer self);
static gboolean _moserial_main_window_deleteSaveSize_gtk_widget_delete_event (GtkWindow* _sender, GdkEvent* event, gpointer self);
static gboolean _moserial_main_window_keyPress_gtk_widget_key_press_event (GtkWindow* _sender, const GdkEventKey* event, gpointer self);
Profile* profile_new (void);
Profile* profile_construct (GType object_type);
gint profile_getWindowWidth (Profile* self);
gint profile_getWindowHeight (Profile* self);
gint profile_getWindowPanedPosition (Profile* self);
static void _moserial_main_window_quitSizeSave_gtk_action_activate (GtkAction* _sender, gpointer self);
static void _moserial_main_window_saveProfileAs_gtk_action_activate (GtkAction* _sender, gpointer self);
static void _moserial_main_window_saveProfile_gtk_action_activate (GtkAction* _sender, gpointer self);
static void _moserial_main_window_loadProfile_gtk_action_activate (GtkAction* _sender, gpointer self);
static void _moserial_main_window_copy_gtk_action_activate (GtkAction* _sender, gpointer self);
static void _moserial_main_window_editMenu_gtk_action_activate (GtkAction* _sender, gpointer self);
static void _moserial_main_window_cut_gtk_action_activate (GtkAction* _sender, gpointer self);
static void _moserial_main_window_paste_gtk_action_activate (GtkAction* _sender, gpointer self);
static void _moserial_main_window_clear_gtk_action_activate (GtkAction* _sender, gpointer self);
moserialSettingsDialog* moserial_settings_dialog_new (GtkBuilder* builder);
moserialSettingsDialog* moserial_settings_dialog_construct (GType object_type, GtkBuilder* builder);
static void _moserial_main_window_updateSettings_moserial_settings_dialog_update_settings (moserialSettingsDialog* _sender, Settings* settings, gpointer self);
static void _moserial_main_window_showSettingsDialog_gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static void _moserial_main_window_showHelpButton_gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static void _moserial_main_window_showAboutDialog_gtk_action_activate (GtkAction* _sender, gpointer self);
moserialSendProgressDialog* moserial_send_progress_dialog_new (GtkBuilder* builder);
moserialSendProgressDialog* moserial_send_progress_dialog_construct (GType object_type, GtkBuilder* builder);
moserialSendChooserDialog* moserial_send_chooser_dialog_new (GtkBuilder* builder);
moserialSendChooserDialog* moserial_send_chooser_dialog_construct (GType object_type, GtkBuilder* builder);
static void _moserial_main_window_doSendChooser_gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static void _moserial_main_window_doSend_moserial_send_chooser_dialog_start_transfer (moserialSendChooserDialog* _sender, gpointer self);
moserialReceiveProgressDialog* moserial_receive_progress_dialog_new (GtkBuilder* builder);
moserialReceiveProgressDialog* moserial_receive_progress_dialog_construct (GType object_type, GtkBuilder* builder);
moserialReceiveChooserDialog* moserial_receive_chooser_dialog_new (GtkBuilder* builder);
moserialReceiveChooserDialog* moserial_receive_chooser_dialog_construct (GType object_type, GtkBuilder* builder);
static void _moserial_main_window_doReceiveChooser_gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static void _moserial_main_window_doReceive_moserial_receive_chooser_dialog_start_transfer (moserialReceiveChooserDialog* _sender, gpointer self);
moserialXmodemFilenameDialog* moserial_xmodem_filename_dialog_new (GtkBuilder* builder);
moserialXmodemFilenameDialog* moserial_xmodem_filename_dialog_construct (GType object_type, GtkBuilder* builder);
moserialRecordDialog* moserial_record_dialog_new (GtkBuilder* builder);
moserialRecordDialog* moserial_record_dialog_construct (GType object_type, GtkBuilder* builder);
static void _moserial_main_window_record_gtk_tool_button_clicked (GtkToggleToolButton* _sender, gpointer self);
static void _moserial_main_window_stopRecording_moserial_record_dialog_stop_recording (moserialRecordDialog* _sender, gpointer self);
static void _moserial_main_window_startRecording_moserial_record_dialog_start_recording (moserialRecordDialog* _sender, const char* fileName, moserialSerialStreamRecorderDirection direction, gpointer self);
moserialPreferencesDialog* moserial_preferences_dialog_new (GtkBuilder* builder);
moserialPreferencesDialog* moserial_preferences_dialog_construct (GType object_type, GtkBuilder* builder);
static void _moserial_main_window_updatePreferences_moserial_preferences_dialog_update_preferences (moserialPreferencesDialog* _sender, Preferences* preferences, gpointer self);
static void _moserial_main_window_showPreferencesDialog_gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static void _moserial_main_window_connectButtonClick_gtk_tool_button_clicked (GtkToggleToolButton* _sender, gpointer self);
static void _moserial_main_window_showHelpAction_gtk_action_activate (GtkAction* _sender, gpointer self);
moserialHexTextBuffer* moserial_hex_text_buffer_new (void);
moserialHexTextBuffer* moserial_hex_text_buffer_construct (GType object_type);
void moserial_auto_scroll_setup (GtkAdjustment* incomingAsciiVerticalAdjuster, GtkAdjustment* incomingHexVerticalAdjuster, GtkAdjustment* outgoingAsciiVerticalAdjuster, GtkAdjustment* outgoingHexVerticalAdjuster);
static void _moserial_main_window_sendString_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _moserial_main_window_sendString_gtk_entry_activate (GtkEntry* _sender, gpointer self);
static void _moserial_main_window_inputModeChanged_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self);
static void _moserial_main_window_recentItemOpen_gtk_recent_chooser_item_activated (GtkRecentChooserMenu* _sender, gpointer self);
static GObject * moserial_main_window_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void moserial_main_window_finalize (GObject* obj);
static void moserial_main_window_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void moserial_main_window_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static int _vala_strcmp0 (const char * str1, const char * str2);

static const char* MOSERIAL_MAIN_WINDOW_authors[] = {"Michael J. Chudobiak <mjc@svn.gnome.org>", "marlodavampire", NULL};
static const char* MOSERIAL_MAIN_WINDOW_license[] = {N_ ("moserial is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.\n"), N_ ("moserial is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more details.\n"), N_ ("You should have received a copy of the GNU General Public License along with this program.  If not, see <http://www.gnu.org/licenses/>.")};


/*private Gtk.RecentChooser recentChooser;*/
moserialMainWindow* moserial_main_window_construct (GType object_type, GtkBuilder* builder, const char* profileFilename) {
	GParameter * __params;
	GParameter * __params_it;
	moserialMainWindow * self;
	g_return_val_if_fail (builder != NULL, NULL);
	__params = g_new0 (GParameter, 2);
	__params_it = __params;
	__params_it->name = "builder";
	g_value_init (&__params_it->value, GTK_TYPE_BUILDER);
	g_value_set_object (&__params_it->value, builder);
	__params_it++;
	__params_it->name = "startupProfileFilename";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, profileFilename);
	__params_it++;
	self = g_object_newv (object_type, __params_it - __params, __params);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


moserialMainWindow* moserial_main_window_new (GtkBuilder* builder, const char* profileFilename) {
	return moserial_main_window_construct (MOSERIAL_TYPE_MAIN_WINDOW, builder, profileFilename);
}


static void moserial_main_window_applyProfile (moserialMainWindow* self, const char* filename) {
	GError * _inner_error_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (filename != NULL);
	_inner_error_ = NULL;
	if (profile_load (self->priv->profile, filename, self->priv->gtkWindow)) {
		char* _tmp1_;
		const char* _tmp0_;
		Settings* _tmp2_;
		Preferences* _tmp3_;
		DefaultPaths* _tmp4_;
		char* _tmp5_;
		GtkRecentManager* _tmp6_;
		GtkRecentManager* recentManager;
		char* _tmp7_;
		char* _tmp8_;
		_tmp1_ = NULL;
		_tmp0_ = NULL;
		self->priv->profileFilename = (_tmp1_ = (_tmp0_ = filename, (_tmp0_ == NULL) ? NULL : g_strdup (_tmp0_)), self->priv->profileFilename = (g_free (self->priv->profileFilename), NULL), _tmp1_);
		moserial_main_window_ensureDisconnected (self);
		_tmp2_ = NULL;
		self->priv->currentSettings = (_tmp2_ = settings_loadFromProfile (self->priv->profile), (self->priv->currentSettings == NULL) ? NULL : (self->priv->currentSettings = (g_object_unref (self->priv->currentSettings), NULL)), _tmp2_);
		_tmp3_ = NULL;
		self->priv->currentPreferences = (_tmp3_ = preferences_loadFromProfile (self->priv->profile), (self->priv->currentPreferences == NULL) ? NULL : (self->priv->currentPreferences = (g_object_unref (self->priv->currentPreferences), NULL)), _tmp3_);
		_tmp4_ = NULL;
		self->priv->currentPaths = (_tmp4_ = default_paths_loadFromProfile (self->priv->profile), (self->priv->currentPaths == NULL) ? NULL : (self->priv->currentPaths = (g_object_unref (self->priv->currentPaths), NULL)), _tmp4_);
		moserial_main_window_updatePreferences (self, NULL, self->priv->currentPreferences);
		gtk_statusbar_pop (self->priv->statusbar, self->priv->statusbarContext);
		_tmp5_ = NULL;
		gtk_statusbar_push (self->priv->statusbar, self->priv->statusbarContext, _tmp5_ = settings_getStatusbarString (self->priv->currentSettings, FALSE));
		_tmp5_ = (g_free (_tmp5_), NULL);
		moserial_main_window_setWindowTitle (self, NULL);
		self->priv->profileChanged = FALSE;
		_tmp6_ = NULL;
		recentManager = (_tmp6_ = gtk_recent_manager_get_default (), (_tmp6_ == NULL) ? NULL : g_object_ref (_tmp6_));
		_tmp7_ = g_filename_to_uri (filename, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			(recentManager == NULL) ? NULL : (recentManager = (g_object_unref (recentManager), NULL));
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp8_ = NULL;
		gtk_recent_manager_add_item (recentManager, _tmp8_ = _tmp7_);
		_tmp8_ = (g_free (_tmp8_), NULL);
		(recentManager == NULL) ? NULL : (recentManager = (g_object_unref (recentManager), NULL));
	}
}


static void moserial_main_window_setWindowTitle (moserialMainWindow* self, const char* recordingFilename) {
	GString* builder;
	g_return_if_fail (self != NULL);
	builder = g_string_new ("");
	g_string_append (builder, "moserial");
	if (self->priv->profileFilename != NULL) {
		char* _tmp0_;
		g_string_append (builder, " - ");
		_tmp0_ = NULL;
		g_string_append (builder, _tmp0_ = g_path_get_basename (self->priv->profileFilename));
		_tmp0_ = (g_free (_tmp0_), NULL);
	}
	if (recordingFilename != NULL) {
		char* _tmp1_;
		g_string_append (builder, " - ");
		_tmp1_ = NULL;
		g_string_append (builder, _tmp1_ = g_path_get_basename (recordingFilename));
		_tmp1_ = (g_free (_tmp1_), NULL);
	}
	gtk_window_set_title (self->priv->gtkWindow, builder->str);
	(builder == NULL) ? NULL : (builder = (g_string_free (builder, TRUE), NULL));
}


static void moserial_main_window_recentItemOpen (moserialMainWindow* self, GtkRecentChooser* r) {
	GError * _inner_error_;
	char* _tmp0_;
	char* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (r != NULL);
	_inner_error_ = NULL;
	_tmp0_ = g_filename_from_uri (gtk_recent_chooser_get_current_uri (r), NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp1_ = NULL;
	moserial_main_window_applyProfile (self, _tmp1_ = _tmp0_);
	_tmp1_ = (g_free (_tmp1_), NULL);
}


static glong string_get_length (const char* self) {
	glong result;
	g_return_val_if_fail (self != NULL, 0L);
	result = g_utf8_strlen (self, -1);
	return result;
}


static void moserial_main_window_insertBufferEnd (moserialMainWindow* self, GtkTextBuffer* buf, const char* s) {
	GtkTextIter iter = {0};
	gint i;
	GString* builder;
	g_return_if_fail (self != NULL);
	g_return_if_fail (buf != NULL);
	g_return_if_fail (s != NULL);
	i = 0;
	builder = g_string_new ("");
	{
		gboolean _tmp0_;
		i = 0;
		_tmp0_ = TRUE;
		while (TRUE) {
			gunichar c;
			gboolean _tmp1_;
			if (!_tmp0_) {
				i++;
			}
			_tmp0_ = FALSE;
			if (!(i < string_get_length (s))) {
				break;
			}
			c = g_utf8_get_char (s);
			_tmp1_ = FALSE;
			if (g_unichar_isprint (c)) {
				_tmp1_ = TRUE;
			} else {
				_tmp1_ = g_unichar_isspace (c);
			}
			if (_tmp1_) {
				g_string_append_unichar (builder, c);
			}
			s = g_utf8_next_char (s);
		}
	}
	gtk_text_buffer_get_end_iter (buf, &iter);
	gtk_text_buffer_insert (buf, &iter, builder->str, (gint) string_get_length (builder->str));
	(builder == NULL) ? NULL : (builder = (g_string_free (builder, TRUE), NULL));
}


void moserial_main_window_sendString (moserialMainWindow* self, GtkWidget* w) {
	GError * _inner_error_;
	char* s;
	char* _tmp1_;
	const char* _tmp0_;
	char* _tmp3_;
	const char* _tmp2_;
	glong len;
	char* _tmp16_;
	char* _tmp17_;
	GtkTextIter echoStartIter = {0};
	GtkTextMark* _tmp19_;
	GtkTextMark* _tmp18_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (w != NULL);
	_inner_error_ = NULL;
	if (!moserial_main_window_ensureConnected (self)) {
		return;
	}
	s = NULL;
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	s = (_tmp1_ = (_tmp0_ = gtk_entry_get_text (self->priv->entry), (_tmp0_ == NULL) ? NULL : g_strdup (_tmp0_)), s = (g_free (s), NULL), _tmp1_);
	_tmp3_ = NULL;
	_tmp2_ = NULL;
	self->priv->serialConnection->echoReference = (_tmp3_ = (_tmp2_ = s, (_tmp2_ == NULL) ? NULL : g_strdup (_tmp2_)), self->priv->serialConnection->echoReference = (g_free (self->priv->serialConnection->echoReference), NULL), _tmp3_);
	len = 0L;
	if (gtk_combo_box_get_active (self->priv->inputMode) == 0) {
		char* t;
		len = string_get_length (s);
		{
			gint x;
			x = 0;
			{
				gboolean _tmp4_;
				_tmp4_ = TRUE;
				while (TRUE) {
					char* _tmp5_;
					char* _tmp7_;
					const char* _tmp6_;
					if (!_tmp4_) {
						x++;
					}
					_tmp4_ = FALSE;
					if (!(x < len)) {
						break;
					}
					moserial_serial_connection_sendByte (self->priv->serialConnection, (guchar) g_utf8_get_char (s));
					moserial_serial_stream_recorder_writeOutgoing (self->priv->streamRecorder, (guchar) g_utf8_get_char (s));
					moserial_hex_text_buffer_add (self->priv->outgoingHexTextBuffer, (guchar) g_utf8_get_char (s));
					_tmp5_ = NULL;
					moserial_main_window_insertBufferEnd (self, self->priv->outgoingAsciiTextBuffer, _tmp5_ = g_strdup_printf ("%c", (gint) ((guchar) g_utf8_get_char (s))));
					_tmp5_ = (g_free (_tmp5_), NULL);
					_tmp7_ = NULL;
					_tmp6_ = NULL;
					s = (_tmp7_ = (_tmp6_ = g_utf8_next_char (s), (_tmp6_ == NULL) ? NULL : g_strdup (_tmp6_)), s = (g_free (s), NULL), _tmp7_);
				}
			}
		}
		t = moserial_serial_connection_getLineEnd (self->priv->serialConnection, gtk_combo_box_get_active (self->priv->terminationMode));
		len = string_get_length (t);
		{
			gint x;
			x = 0;
			{
				gboolean _tmp8_;
				_tmp8_ = TRUE;
				while (TRUE) {
					char* _tmp11_;
					const char* _tmp10_;
					if (!_tmp8_) {
						x++;
					}
					_tmp8_ = FALSE;
					if (!(x < len)) {
						break;
					}
					moserial_serial_connection_sendByte (self->priv->serialConnection, (guchar) g_utf8_get_char (t));
					moserial_serial_stream_recorder_writeOutgoing (self->priv->streamRecorder, (guchar) g_utf8_get_char (t));
					moserial_hex_text_buffer_add (self->priv->outgoingHexTextBuffer, (guchar) g_utf8_get_char (t));
					/* Just display the first byte of the terminator in the ASCII window,
					                                   so that CRLF doesn't cause two line advances. */
					if (x == 0) {
						char* _tmp9_;
						_tmp9_ = NULL;
						moserial_main_window_insertBufferEnd (self, self->priv->outgoingAsciiTextBuffer, _tmp9_ = g_strdup_printf ("%c", (gint) ((guchar) g_utf8_get_char (t))));
						_tmp9_ = (g_free (_tmp9_), NULL);
					}
					_tmp11_ = NULL;
					_tmp10_ = NULL;
					t = (_tmp11_ = (_tmp10_ = g_utf8_next_char (t), (_tmp10_ == NULL) ? NULL : g_strdup (_tmp10_)), t = (g_free (t), NULL), _tmp11_);
				}
			}
		}
		t = (g_free (t), NULL);
	} else {
		{
			guchar* _tmp13_;
			gint h_size;
			gint h_length1;
			gint _tmp12_;
			guchar* h;
			_tmp13_ = NULL;
			h = (_tmp13_ = input_parser_parseHex (s, &_tmp12_, &_inner_error_), h_length1 = _tmp12_, h_size = h_length1, _tmp13_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == HEX_PARSE_ERROR) {
					goto __catch0_hex_parse_error;
				}
				goto __finally0;
			}
			len = (glong) h_length1;
			{
				gint x;
				x = 0;
				{
					gboolean _tmp14_;
					_tmp14_ = TRUE;
					while (TRUE) {
						char* _tmp15_;
						if (!_tmp14_) {
							x++;
						}
						_tmp14_ = FALSE;
						if (!(x < len)) {
							break;
						}
						moserial_serial_connection_sendByte (self->priv->serialConnection, h[x]);
						moserial_serial_stream_recorder_writeOutgoing (self->priv->streamRecorder, h[x]);
						moserial_hex_text_buffer_add (self->priv->outgoingHexTextBuffer, h[x]);
						_tmp15_ = NULL;
						moserial_main_window_insertBufferEnd (self, self->priv->outgoingAsciiTextBuffer, _tmp15_ = g_strdup_printf ("%c", (gint) h[x]));
						_tmp15_ = (g_free (_tmp15_), NULL);
					}
				}
			}
			h = (g_free (h), NULL);
		}
		goto __finally0;
		__catch0_hex_parse_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			{
				GtkMessageDialog* errorDialog;
				errorDialog = g_object_ref_sink ((GtkMessageDialog*) gtk_message_dialog_new (self->priv->gtkWindow, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, e->message, NULL));
				gtk_dialog_run ((GtkDialog*) errorDialog);
				gtk_object_destroy ((GtkObject*) errorDialog);
				(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
				(errorDialog == NULL) ? NULL : (errorDialog = (g_object_unref (errorDialog), NULL));
			}
		}
		__finally0:
		if (_inner_error_ != NULL) {
			s = (g_free (s), NULL);
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	gtk_statusbar_pop (self->priv->bytecountbar, self->priv->bytecountbarContext);
	_tmp16_ = NULL;
	gtk_statusbar_push (self->priv->bytecountbar, self->priv->bytecountbarContext, _tmp16_ = moserial_serial_connection_getBytecountbarString (self->priv->serialConnection));
	_tmp16_ = (g_free (_tmp16_), NULL);
	gtk_entry_set_text (self->priv->entry, "");
	/* Start listening for an echo */
	_tmp17_ = NULL;
	self->priv->serialConnection->echoCompare = (_tmp17_ = g_strdup (""), self->priv->serialConnection->echoCompare = (g_free (self->priv->serialConnection->echoCompare), NULL), _tmp17_);
	gtk_text_buffer_get_end_iter (self->priv->incomingAsciiTextBuffer, &echoStartIter);
	_tmp19_ = NULL;
	_tmp18_ = NULL;
	self->priv->echoStartMark = (_tmp19_ = (_tmp18_ = gtk_text_buffer_create_mark (self->priv->incomingAsciiTextBuffer, "echo", &echoStartIter, TRUE), (_tmp18_ == NULL) ? NULL : g_object_ref (_tmp18_)), (self->priv->echoStartMark == NULL) ? NULL : (self->priv->echoStartMark = (g_object_unref (self->priv->echoStartMark), NULL)), _tmp19_);
	s = (g_free (s), NULL);
}


static void moserial_main_window_doSendChooser (moserialMainWindow* self, GtkToolButton* button) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	if (!moserial_main_window_ensureConnected (self)) {
		return;
	}
	moserial_send_chooser_dialog_show (self->priv->sendChooserDialog, default_paths_get_sendFrom (self->priv->currentPaths));
}


static void _moserial_send_progress_dialog_updateStatus_moserial_szwrapper_update_status (moserialSzwrapper* _sender, const char* newStatus, gpointer self) {
	moserial_send_progress_dialog_updateStatus (self, _sender, newStatus);
}


static void _moserial_szwrapper_transferCanceled_moserial_send_progress_dialog_transfer_canceled (moserialSendProgressDialog* _sender, gpointer self) {
	moserial_szwrapper_transferCanceled (self, _sender);
}


static void _moserial_main_window_sendComplete_moserial_szwrapper_transfer_complete (moserialSzwrapper* _sender, gpointer self) {
	moserial_main_window_sendComplete (self, _sender);
}


static void moserial_main_window_doSend (moserialMainWindow* self, moserialSendChooserDialog* dialog) {
	moserialSzwrapperProtocol protocol;
	char* filename;
	char* _tmp1_;
	const char* _tmp0_;
	char* _tmp2_;
	moserialSzwrapper* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dialog != NULL);
	protocol = 0;
	filename = NULL;
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	filename = (_tmp1_ = (_tmp0_ = dialog->filename, (_tmp0_ == NULL) ? NULL : g_strdup (_tmp0_)), filename = (g_free (filename), NULL), _tmp1_);
	_tmp2_ = NULL;
	default_paths_set_sendFrom (self->priv->currentPaths, _tmp2_ = mo_utils_getParentFolder (filename));
	_tmp2_ = (g_free (_tmp2_), NULL);
	switch (gtk_combo_box_get_active (dialog->protocolCombo)) {
		case 0:
		{
			protocol = MOSERIAL_SZWRAPPER_PROTOCOL_XMODEM;
			break;
		}
		case 1:
		{
			protocol = MOSERIAL_SZWRAPPER_PROTOCOL_YMODEM;
			break;
		}
		default:
		{
			protocol = MOSERIAL_SZWRAPPER_PROTOCOL_ZMODEM;
			break;
		}
		case 3:
		{
			protocol = MOSERIAL_SZWRAPPER_PROTOCOL_RAW;
			break;
		}
	}
	_tmp3_ = NULL;
	self->priv->sz = (_tmp3_ = moserial_szwrapper_new (&protocol, self->priv->serialConnection, filename), (self->priv->sz == NULL) ? NULL : (self->priv->sz = (g_object_unref (self->priv->sz), NULL)), _tmp3_);
	if (self->priv->sz->running) {
		moserial_send_progress_dialog_show (self->priv->sendProgressDialog);
		g_signal_connect_object (self->priv->sz, "update-status", (GCallback) _moserial_send_progress_dialog_updateStatus_moserial_szwrapper_update_status, self->priv->sendProgressDialog, 0);
		g_signal_connect_object (self->priv->sendProgressDialog, "transfer-canceled", (GCallback) _moserial_szwrapper_transferCanceled_moserial_send_progress_dialog_transfer_canceled, self->priv->sz, 0);
		g_signal_connect_object (self->priv->sz, "transfer-complete", (GCallback) _moserial_main_window_sendComplete_moserial_szwrapper_transfer_complete, self, 0);
	}
	filename = (g_free (filename), NULL);
}


void moserial_main_window_sendComplete (moserialMainWindow* self, GObject* o) {
	guint _tmp0_;
	guint _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (o != NULL);
	g_signal_handlers_disconnect_matched (self->priv->sz, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, (g_signal_parse_name ("update-status", MOSERIAL_TYPE_SZWRAPPER, &_tmp0_, NULL, FALSE), _tmp0_), 0, NULL, (GCallback) _moserial_send_progress_dialog_updateStatus_moserial_szwrapper_update_status, self->priv->sendProgressDialog);
	g_signal_handlers_disconnect_matched (self->priv->sendProgressDialog, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, (g_signal_parse_name ("transfer-canceled", MOSERIAL_TYPE_SEND_PROGRESS_DIALOG, &_tmp1_, NULL, FALSE), _tmp1_), 0, NULL, (GCallback) _moserial_szwrapper_transferCanceled_moserial_send_progress_dialog_transfer_canceled, self->priv->sz);
	moserial_send_progress_dialog_hide (self->priv->sendProgressDialog);
}


static void moserial_main_window_doReceiveChooser (moserialMainWindow* self, GtkToolButton* button) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	if (!moserial_main_window_ensureConnected (self)) {
		return;
	}
	moserial_receive_chooser_dialog_show (self->priv->receiveChooserDialog, default_paths_get_receiveTo (self->priv->currentPaths));
}


static void _moserial_receive_progress_dialog_updateStatus_moserial_rzwrapper_update_status (moserialRzwrapper* _sender, const char* newStatus, gpointer self) {
	moserial_receive_progress_dialog_updateStatus (self, _sender, newStatus);
}


static void _moserial_rzwrapper_transferCanceled_moserial_receive_progress_dialog_transfer_canceled (moserialReceiveProgressDialog* _sender, gpointer self) {
	moserial_rzwrapper_transferCanceled (self, _sender);
}


static void _moserial_main_window_receiveComplete_moserial_rzwrapper_transfer_complete (moserialRzwrapper* _sender, gpointer self) {
	moserial_main_window_receiveComplete (self, _sender);
}


static void moserial_main_window_doReceive (moserialMainWindow* self, moserialReceiveChooserDialog* dialog) {
	char* filename;
	moserialRzwrapperProtocol protocol;
	moserialRzwrapper* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dialog != NULL);
	filename = g_strdup ("");
	default_paths_set_receiveTo (self->priv->currentPaths, dialog->path);
	if (gtk_combo_box_get_active (dialog->protocolCombo) == 0) {
		char* _tmp1_;
		const char* _tmp0_;
		/*get the filename for xmodem*/
		moserial_xmodem_filename_dialog_show (self->priv->xmodemFilenameDialog);
		_tmp1_ = NULL;
		_tmp0_ = NULL;
		filename = (_tmp1_ = (_tmp0_ = self->priv->xmodemFilenameDialog->filename, (_tmp0_ == NULL) ? NULL : g_strdup (_tmp0_)), filename = (g_free (filename), NULL), _tmp1_);
	}
	protocol = 0;
	switch (gtk_combo_box_get_active (dialog->protocolCombo)) {
		case 0:
		{
			protocol = MOSERIAL_RZWRAPPER_PROTOCOL_XMODEM;
			break;
		}
		case 1:
		{
			protocol = MOSERIAL_RZWRAPPER_PROTOCOL_YMODEM;
			break;
		}
		default:
		{
			protocol = MOSERIAL_RZWRAPPER_PROTOCOL_ZMODEM;
			break;
		}
	}
	_tmp2_ = NULL;
	self->priv->rz = (_tmp2_ = moserial_rzwrapper_new (&protocol, self->priv->serialConnection, dialog->path, filename), (self->priv->rz == NULL) ? NULL : (self->priv->rz = (g_object_unref (self->priv->rz), NULL)), _tmp2_);
	if (self->priv->rz->running) {
		moserial_receive_progress_dialog_show (self->priv->receiveProgressDialog);
		g_signal_connect_object (self->priv->rz, "update-status", (GCallback) _moserial_receive_progress_dialog_updateStatus_moserial_rzwrapper_update_status, self->priv->receiveProgressDialog, 0);
		g_signal_connect_object (self->priv->receiveProgressDialog, "transfer-canceled", (GCallback) _moserial_rzwrapper_transferCanceled_moserial_receive_progress_dialog_transfer_canceled, self->priv->rz, 0);
		g_signal_connect_object (self->priv->rz, "transfer-complete", (GCallback) _moserial_main_window_receiveComplete_moserial_rzwrapper_transfer_complete, self, 0);
	}
	filename = (g_free (filename), NULL);
}


void moserial_main_window_receiveComplete (moserialMainWindow* self, GObject* o) {
	guint _tmp0_;
	guint _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (o != NULL);
	g_signal_handlers_disconnect_matched (self->priv->rz, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, (g_signal_parse_name ("update-status", MOSERIAL_TYPE_RZWRAPPER, &_tmp0_, NULL, FALSE), _tmp0_), 0, NULL, (GCallback) _moserial_receive_progress_dialog_updateStatus_moserial_rzwrapper_update_status, self->priv->receiveProgressDialog);
	g_signal_handlers_disconnect_matched (self->priv->receiveProgressDialog, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, (g_signal_parse_name ("transfer-canceled", MOSERIAL_TYPE_RECEIVE_PROGRESS_DIALOG, &_tmp1_, NULL, FALSE), _tmp1_), 0, NULL, (GCallback) _moserial_rzwrapper_transferCanceled_moserial_receive_progress_dialog_transfer_canceled, self->priv->rz);
	moserial_receive_progress_dialog_hide (self->priv->receiveProgressDialog);
}


void moserial_main_window_record (moserialMainWindow* self, GtkToggleToolButton* button) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	if (gtk_toggle_tool_button_get_active (button)) {
		if (!moserial_main_window_ensureConnected (self)) {
			gtk_toggle_tool_button_set_active (button, FALSE);
			return;
		}
		gtk_tool_button_set_label_widget ((GtkToolButton*) button, (GtkWidget*) self->priv->stopRecordingLabel);
		moserial_record_dialog_show (self->priv->recordDialog, default_paths_get_recordTo (self->priv->currentPaths));
	} else {
		moserial_serial_stream_recorder_close (self->priv->streamRecorder, preferences_get_recordLaunch (self->priv->currentPreferences));
		gtk_tool_button_set_label_widget ((GtkToolButton*) button, (GtkWidget*) self->priv->recordLabel);
		moserial_main_window_setWindowTitle (self, NULL);
		if (self->priv->recordTimeoutID > 0) {
			g_source_remove (self->priv->recordTimeoutID);
			self->priv->recordTimeoutID = (guint) 0;
		}
	}
}


void moserial_main_window_stopRecording (moserialMainWindow* self, moserialRecordDialog* dialog) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (dialog != NULL);
	gtk_toggle_tool_button_set_active (self->priv->recordButton, FALSE);
}


/*this generates recordButton.clicked signal*/
void moserial_main_window_startRecording (moserialMainWindow* self, moserialRecordDialog* dialog, const char* filename, moserialSerialStreamRecorderDirection direction) {
	GError * _inner_error_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dialog != NULL);
	g_return_if_fail (filename != NULL);
	_inner_error_ = NULL;
	{
		char* _tmp0_;
		moserial_serial_stream_recorder_open (self->priv->streamRecorder, filename, direction, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch1_g_error;
			goto __finally1;
		}
		_tmp0_ = NULL;
		default_paths_set_recordTo (self->priv->currentPaths, _tmp0_ = mo_utils_getParentFolder (filename));
		_tmp0_ = (g_free (_tmp0_), NULL);
		if (!moserial_main_window_ensureConnected (self)) {
			moserial_main_window_stopRecording (self, dialog);
		}
		moserial_main_window_setWindowTitle (self, filename);
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			char* _tmp1_;
			GtkMessageDialog* _tmp2_;
			GtkMessageDialog* errorDialog;
			_tmp1_ = NULL;
			_tmp2_ = NULL;
			errorDialog = (_tmp2_ = g_object_ref_sink ((GtkMessageDialog*) gtk_message_dialog_new (self->priv->gtkWindow, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, _tmp1_ = g_strdup_printf ("%s: %s\n%s", _ ("Error: Could not open file"), filename, e->message), NULL)), _tmp1_ = (g_free (_tmp1_), NULL), _tmp2_);
			gtk_dialog_run ((GtkDialog*) errorDialog);
			gtk_object_destroy ((GtkObject*) errorDialog);
			moserial_main_window_stopRecording (self, dialog);
			(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
			(errorDialog == NULL) ? NULL : (errorDialog = (g_object_unref (errorDialog), NULL));
		}
	}
	__finally1:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
		g_clear_error (&_inner_error_);
		return;
	}
}


gboolean moserial_main_window_recordTimeout (moserialMainWindow* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	gtk_toggle_tool_button_set_active (self->priv->recordButton, FALSE);
	result = FALSE;
	return result;
}


void moserial_main_window_showWindow (moserialMainWindow* self) {
	g_return_if_fail (self != NULL);
	gtk_widget_show_all ((GtkWidget*) self->priv->gtkWindow);
}


static void moserial_main_window_updateSettings (moserialMainWindow* self, moserialSettingsDialog* d, Settings* newSettings) {
	Settings* _tmp1_;
	Settings* _tmp0_;
	char* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (d != NULL);
	g_return_if_fail (newSettings != NULL);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	self->priv->currentSettings = (_tmp1_ = (_tmp0_ = newSettings, (_tmp0_ == NULL) ? NULL : g_object_ref (_tmp0_)), (self->priv->currentSettings == NULL) ? NULL : (self->priv->currentSettings = (g_object_unref (self->priv->currentSettings), NULL)), _tmp1_);
	gtk_statusbar_pop (self->priv->statusbar, self->priv->statusbarContext);
	_tmp2_ = NULL;
	gtk_statusbar_push (self->priv->statusbar, self->priv->statusbarContext, _tmp2_ = settings_getStatusbarString (self->priv->currentSettings, FALSE));
	_tmp2_ = (g_free (_tmp2_), NULL);
	self->priv->profileChanged = TRUE;
}


static void moserial_main_window_updatePreferences (moserialMainWindow* self, moserialPreferencesDialog* d, Preferences* newPreferences) {
	Preferences* _tmp1_;
	Preferences* _tmp0_;
	char* font;
	PangoFontDescription* _tmp5_;
	GdkColor _tmp6_ = {0};
	GdkColor _tmp7_ = {0};
	PangoFontDescription* _tmp8_;
	GdkColor _tmp9_ = {0};
	GdkColor _tmp10_ = {0};
	PangoFontDescription* _tmp11_;
	GdkColor _tmp12_ = {0};
	GdkColor _tmp13_ = {0};
	PangoFontDescription* _tmp14_;
	GdkColor _tmp15_ = {0};
	GdkColor _tmp16_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (newPreferences != NULL);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	self->priv->currentPreferences = (_tmp1_ = (_tmp0_ = newPreferences, (_tmp0_ == NULL) ? NULL : g_object_ref (_tmp0_)), (self->priv->currentPreferences == NULL) ? NULL : (self->priv->currentPreferences = (g_object_unref (self->priv->currentPreferences), NULL)), _tmp1_);
	font = NULL;
	if (preferences_get_useSystemMonospaceFont (self->priv->currentPreferences)) {
		char* _tmp2_;
		_tmp2_ = NULL;
		font = (_tmp2_ = preferences_getSystemDefaultMonospaceFont (), font = (g_free (font), NULL), _tmp2_);
	} else {
		char* _tmp4_;
		const char* _tmp3_;
		_tmp4_ = NULL;
		_tmp3_ = NULL;
		font = (_tmp4_ = (_tmp3_ = preferences_get_font (self->priv->currentPreferences), (_tmp3_ == NULL) ? NULL : g_strdup (_tmp3_)), font = (g_free (font), NULL), _tmp4_);
	}
	_tmp5_ = NULL;
	gtk_widget_modify_font ((GtkWidget*) self->priv->incomingAsciiTextView, _tmp5_ = pango_font_description_from_string (font));
	(_tmp5_ == NULL) ? NULL : (_tmp5_ = (pango_font_description_free (_tmp5_), NULL));
	gtk_widget_modify_text ((GtkWidget*) self->priv->incomingAsciiTextView, GTK_STATE_NORMAL, (_tmp6_ = preferences_getGdkColor (preferences_get_fontColor (self->priv->currentPreferences)), &_tmp6_));
	gtk_widget_modify_base ((GtkWidget*) self->priv->incomingAsciiTextView, GTK_STATE_NORMAL, (_tmp7_ = preferences_getGdkColor (preferences_get_backgroundColor (self->priv->currentPreferences)), &_tmp7_));
	g_object_set (self->priv->echoTag, "foreground", preferences_get_highlightColor (self->priv->currentPreferences), NULL);
	_tmp8_ = NULL;
	gtk_widget_modify_font ((GtkWidget*) self->priv->incomingHexTextView, _tmp8_ = pango_font_description_from_string (font));
	(_tmp8_ == NULL) ? NULL : (_tmp8_ = (pango_font_description_free (_tmp8_), NULL));
	gtk_widget_modify_text ((GtkWidget*) self->priv->incomingHexTextView, GTK_STATE_NORMAL, (_tmp9_ = preferences_getGdkColor (preferences_get_fontColor (self->priv->currentPreferences)), &_tmp9_));
	gtk_widget_modify_base ((GtkWidget*) self->priv->incomingHexTextView, GTK_STATE_NORMAL, (_tmp10_ = preferences_getGdkColor (preferences_get_backgroundColor (self->priv->currentPreferences)), &_tmp10_));
	moserial_hex_text_buffer_applyPreferences (self->priv->incomingHexTextBuffer, self->priv->currentPreferences);
	_tmp11_ = NULL;
	gtk_widget_modify_font ((GtkWidget*) self->priv->outgoingAsciiTextView, _tmp11_ = pango_font_description_from_string (font));
	(_tmp11_ == NULL) ? NULL : (_tmp11_ = (pango_font_description_free (_tmp11_), NULL));
	gtk_widget_modify_text ((GtkWidget*) self->priv->outgoingAsciiTextView, GTK_STATE_NORMAL, (_tmp12_ = preferences_getGdkColor (preferences_get_fontColor (self->priv->currentPreferences)), &_tmp12_));
	gtk_widget_modify_base ((GtkWidget*) self->priv->outgoingAsciiTextView, GTK_STATE_NORMAL, (_tmp13_ = preferences_getGdkColor (preferences_get_backgroundColor (self->priv->currentPreferences)), &_tmp13_));
	_tmp14_ = NULL;
	gtk_widget_modify_font ((GtkWidget*) self->priv->outgoingHexTextView, _tmp14_ = pango_font_description_from_string (font));
	(_tmp14_ == NULL) ? NULL : (_tmp14_ = (pango_font_description_free (_tmp14_), NULL));
	gtk_widget_modify_text ((GtkWidget*) self->priv->outgoingHexTextView, GTK_STATE_NORMAL, (_tmp15_ = preferences_getGdkColor (preferences_get_fontColor (self->priv->currentPreferences)), &_tmp15_));
	gtk_widget_modify_base ((GtkWidget*) self->priv->outgoingHexTextView, GTK_STATE_NORMAL, (_tmp16_ = preferences_getGdkColor (preferences_get_backgroundColor (self->priv->currentPreferences)), &_tmp16_));
	moserial_hex_text_buffer_applyPreferences (self->priv->outgoingHexTextBuffer, self->priv->currentPreferences);
	self->priv->profileChanged = TRUE;
	font = (g_free (font), NULL);
}


static void moserial_main_window_showSettingsDialog (moserialMainWindow* self, GObject* o) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (o != NULL);
	moserial_settings_dialog_show (self->priv->settingsDialog, self->priv->currentSettings);
}


static void moserial_main_window_showPreferencesDialog (moserialMainWindow* self, GObject* o) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (o != NULL);
	moserial_preferences_dialog_show (self->priv->preferencesDialog, self->priv->currentPreferences, gtk_toggle_tool_button_get_active (self->priv->recordButton));
}


gboolean moserial_main_window_ensureConnected (moserialMainWindow* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (!gtk_toggle_tool_button_get_active (self->priv->connectButton)) {
		gtk_toggle_tool_button_set_active (self->priv->connectButton, TRUE);
	}
	result = gtk_toggle_tool_button_get_active (self->priv->connectButton);
	return result;
}


void moserial_main_window_ensureDisconnected (moserialMainWindow* self) {
	g_return_if_fail (self != NULL);
	if (gtk_toggle_tool_button_get_active (self->priv->connectButton)) {
		gtk_toggle_tool_button_set_active (self->priv->connectButton, FALSE);
	}
}


static void _moserial_main_window_updateIncoming_moserial_serial_connection_new_data (moserialSerialConnection* _sender, guchar* data, int data_length1, gint size, gpointer self) {
	moserial_main_window_updateIncoming (self, _sender, data, data_length1, size);
}


static gboolean moserial_main_window_startConnection (moserialMainWindow* self) {
	gboolean result;
	char* _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	if (!moserial_serial_connection_doConnect (self->priv->serialConnection, self->priv->currentSettings)) {
		char* _tmp0_;
		GtkMessageDialog* _tmp1_;
		GtkMessageDialog* dialog;
		gtk_toggle_tool_button_set_active (self->priv->connectButton, FALSE);
		_tmp0_ = NULL;
		_tmp1_ = NULL;
		dialog = (_tmp1_ = g_object_ref_sink ((GtkMessageDialog*) gtk_message_dialog_new (self->priv->gtkWindow, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, _tmp0_ = g_strdup_printf ("%s: %s", _ ("Error: Could not open device"), settings_get_device (self->priv->currentSettings)), NULL)), _tmp0_ = (g_free (_tmp0_), NULL), _tmp1_);
		gtk_dialog_run ((GtkDialog*) dialog);
		gtk_object_destroy ((GtkObject*) dialog);
		result = FALSE;
		(dialog == NULL) ? NULL : (dialog = (g_object_unref (dialog), NULL));
		return result;
	}
	moserial_hex_text_buffer_clear (self->priv->incomingHexTextBuffer);
	gtk_text_buffer_set_text (self->priv->incomingAsciiTextBuffer, "", 0);
	moserial_hex_text_buffer_clear (self->priv->outgoingHexTextBuffer);
	gtk_text_buffer_set_text (self->priv->outgoingAsciiTextBuffer, "", 0);
	gtk_widget_set_sensitive ((GtkWidget*) self->priv->settingsButton, FALSE);
	gtk_statusbar_pop (self->priv->statusbar, self->priv->statusbarContext);
	_tmp2_ = NULL;
	gtk_statusbar_push (self->priv->statusbar, self->priv->statusbarContext, _tmp2_ = settings_getStatusbarString (self->priv->currentSettings, TRUE));
	_tmp2_ = (g_free (_tmp2_), NULL);
	g_signal_connect_object (self->priv->serialConnection, "new-data", (GCallback) _moserial_main_window_updateIncoming_moserial_serial_connection_new_data, self, 0);
	gtk_tool_button_set_label_widget ((GtkToolButton*) self->priv->connectButton, (GtkWidget*) self->priv->disconnectLabel);
	result = TRUE;
	return result;
}


static void moserial_main_window_connectButtonClick (moserialMainWindow* self, GtkToggleToolButton* button) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	if (gtk_toggle_tool_button_get_active (button)) {
		moserial_main_window_startConnection (self);
	} else {
		guint _tmp0_;
		char* _tmp1_;
		char* _tmp2_;
		gtk_widget_set_sensitive ((GtkWidget*) self->priv->settingsButton, TRUE);
		moserial_serial_connection_doDisconnect (self->priv->serialConnection);
		g_signal_handlers_disconnect_matched (self->priv->serialConnection, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, (g_signal_parse_name ("new-data", MOSERIAL_TYPE_SERIAL_CONNECTION, &_tmp0_, NULL, FALSE), _tmp0_), 0, NULL, (GCallback) _moserial_main_window_updateIncoming_moserial_serial_connection_new_data, self);
		gtk_statusbar_pop (self->priv->bytecountbar, self->priv->bytecountbarContext);
		_tmp1_ = NULL;
		gtk_statusbar_push (self->priv->bytecountbar, self->priv->bytecountbarContext, _tmp1_ = moserial_serial_connection_getBytecountbarString (self->priv->serialConnection));
		_tmp1_ = (g_free (_tmp1_), NULL);
		/*serialConnection = new SerialConnection();*/
		gtk_statusbar_pop (self->priv->statusbar, self->priv->statusbarContext);
		_tmp2_ = NULL;
		gtk_statusbar_push (self->priv->statusbar, self->priv->statusbarContext, _tmp2_ = settings_getStatusbarString (self->priv->currentSettings, FALSE));
		_tmp2_ = (g_free (_tmp2_), NULL);
		gtk_tool_button_set_label_widget ((GtkToolButton*) button, (GtkWidget*) self->priv->connectLabel);
		if (gtk_toggle_tool_button_get_active (self->priv->recordButton)) {
			gtk_toggle_tool_button_set_active (self->priv->recordButton, FALSE);
		}
	}
}


static gboolean _moserial_main_window_recordTimeout_gsource_func (gpointer self) {
	return moserial_main_window_recordTimeout (self);
}


static void moserial_main_window_updateIncoming (moserialMainWindow* self, moserialSerialConnection* sc, guchar* data, int data_length1, gint size) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (sc != NULL);
	if (self->priv->rz->running) {
		{
			gint x;
			x = 0;
			{
				gboolean _tmp0_;
				_tmp0_ = TRUE;
				while (TRUE) {
					if (!_tmp0_) {
						x++;
					}
					_tmp0_ = FALSE;
					if (!(x < size)) {
						break;
					}
					moserial_rzwrapper_writeChar (self->priv->rz, data[x]);
				}
			}
		}
		moserial_rzwrapper_flush (self->priv->rz);
	} else {
		if (self->priv->sz->running) {
			{
				gint x;
				x = 0;
				{
					gboolean _tmp1_;
					_tmp1_ = TRUE;
					while (TRUE) {
						if (!_tmp1_) {
							x++;
						}
						_tmp1_ = FALSE;
						if (!(x < size)) {
							break;
						}
						moserial_szwrapper_writeChar (self->priv->sz, data[x]);
					}
				}
			}
		} else {
			{
				gint x;
				x = 0;
				{
					gboolean _tmp2_;
					_tmp2_ = TRUE;
					while (TRUE) {
						char* _tmp3_;
						gunichar _tmp4_;
						gunichar c;
						char* s;
						gboolean _tmp6_;
						gboolean _tmp9_;
						gboolean _tmp12_;
						gboolean _tmp13_;
						gboolean _tmp14_;
						gboolean _tmp15_;
						char* _tmp16_;
						if (!_tmp2_) {
							x++;
						}
						_tmp2_ = FALSE;
						if (!(x < size)) {
							break;
						}
						moserial_hex_text_buffer_add (self->priv->incomingHexTextBuffer, data[x]);
						_tmp3_ = NULL;
						c = (_tmp4_ = g_utf8_get_char (_tmp3_ = g_strdup_printf ("%c", (gint) data[x])), _tmp3_ = (g_free (_tmp3_), NULL), _tmp4_);
						s = g_strdup_printf ("%c", (gint) data[x]);
						/* Keep a record of any possible echo */
						if (string_get_length (sc->echoCompare) < string_get_length (sc->echoReference)) {
							char* _tmp5_;
							_tmp5_ = NULL;
							sc->echoCompare = (_tmp5_ = g_strconcat (sc->echoCompare, s, NULL), sc->echoCompare = (g_free (sc->echoCompare), NULL), _tmp5_);
						}
						_tmp6_ = FALSE;
						if (g_utf8_validate (s, -1, NULL)) {
							gboolean _tmp7_;
							_tmp7_ = FALSE;
							if (g_unichar_isprint (c)) {
								_tmp7_ = TRUE;
							} else {
								_tmp7_ = g_unichar_isspace (c);
							}
							_tmp6_ = _tmp7_;
						} else {
							_tmp6_ = FALSE;
						}
						if (_tmp6_) {
							gboolean _tmp8_;
							_tmp8_ = FALSE;
							if (sc->lastRxCharWasCR) {
								_tmp8_ = c == '\n';
							} else {
								_tmp8_ = FALSE;
							}
							/* Ignore LF if last char was CR (CRLF terminator) */
							if (!_tmp8_) {
								moserial_main_window_insertBufferEnd (self, self->priv->incomingAsciiTextBuffer, s);
							}
						} else {
							sc->nonprintable = sc->nonprintable + 1;
						}
						sc->lastRxCharWasCR = c == '\r';
						_tmp9_ = FALSE;
						if (string_get_length (sc->echoCompare) > 0) {
							_tmp9_ = string_get_length (sc->echoCompare) == string_get_length (sc->echoReference);
						} else {
							_tmp9_ = FALSE;
						}
						/* Highlight any text that is an exact echo of the last transmission */
						if (_tmp9_) {
							char* _tmp10_;
							char* _tmp11_;
							if (_vala_strcmp0 (sc->echoCompare, sc->echoReference) == 0) {
								GtkTextIter echoStartIter = {0};
								GtkTextIter echoStopIter = {0};
								gtk_text_buffer_get_iter_at_mark (self->priv->incomingAsciiTextBuffer, &echoStartIter, self->priv->echoStartMark);
								gtk_text_buffer_get_end_iter (self->priv->incomingAsciiTextBuffer, &echoStopIter);
								gtk_text_buffer_apply_tag_by_name (self->priv->incomingAsciiTextBuffer, "echo", &echoStartIter, &echoStopIter);
							}
							_tmp10_ = NULL;
							sc->echoCompare = (_tmp10_ = g_strdup (""), sc->echoCompare = (g_free (sc->echoCompare), NULL), _tmp10_);
							_tmp11_ = NULL;
							sc->echoReference = (_tmp11_ = g_strdup (""), sc->echoReference = (g_free (sc->echoReference), NULL), _tmp11_);
						}
						_tmp12_ = FALSE;
						_tmp13_ = FALSE;
						_tmp14_ = FALSE;
						if (sc->rx > 32) {
							_tmp14_ = sc->nonprintable > 0;
						} else {
							_tmp14_ = FALSE;
						}
						if (_tmp14_) {
							_tmp13_ = (sc->rx / sc->nonprintable) < 4;
						} else {
							_tmp13_ = FALSE;
						}
						if (_tmp13_) {
							_tmp12_ = !sc->forced_hex_view;
						} else {
							_tmp12_ = FALSE;
						}
						/* Auto-select hex view for binary data */
						if (_tmp12_) {
							sc->forced_hex_view = TRUE;
							gtk_notebook_set_current_page (self->priv->incoming_notebook, 1);
						}
						_tmp15_ = FALSE;
						if (preferences_get_enableTimeout (self->priv->currentPreferences)) {
							_tmp15_ = gtk_toggle_tool_button_get_active (self->priv->recordButton);
						} else {
							_tmp15_ = FALSE;
						}
						if (_tmp15_) {
							if (self->priv->recordTimeoutID > 0) {
								g_source_remove (self->priv->recordTimeoutID);
							}
							if (preferences_get_timeout (self->priv->currentPreferences) > 0) {
								self->priv->recordTimeoutID = g_timeout_add_seconds ((guint) preferences_get_timeout (self->priv->currentPreferences), _moserial_main_window_recordTimeout_gsource_func, self);
							}
						}
						moserial_serial_stream_recorder_writeIncoming (self->priv->streamRecorder, data[x]);
						self->priv->recordDataReceived = TRUE;
						gtk_statusbar_pop (self->priv->bytecountbar, self->priv->bytecountbarContext);
						_tmp16_ = NULL;
						gtk_statusbar_push (self->priv->bytecountbar, self->priv->bytecountbarContext, _tmp16_ = moserial_serial_connection_getBytecountbarString (sc));
						_tmp16_ = (g_free (_tmp16_), NULL);
						s = (g_free (s), NULL);
					}
				}
			}
		}
	}
}


static void moserial_main_window_inputModeChanged (moserialMainWindow* self, GtkComboBox* inputMode) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (inputMode != NULL);
	if (gtk_combo_box_get_active (inputMode) == 1) {
		gtk_notebook_set_current_page (self->priv->outgoing_notebook, 1);
	} else {
		gtk_notebook_set_current_page (self->priv->outgoing_notebook, 0);
	}
}


/* ASCII*/
static void moserial_main_window_showHelpButton (moserialMainWindow* self, GtkToolButton* button) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	moserial_main_window_showHelp (self);
}


static void moserial_main_window_showHelpAction (moserialMainWindow* self, GtkAction* a) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (a != NULL);
	moserial_main_window_showHelp (self);
}


static void moserial_main_window_showHelp (moserialMainWindow* self) {
	GError * _inner_error_;
	g_return_if_fail (self != NULL);
	_inner_error_ = NULL;
	{
		gtk_show_uri (NULL, "ghelp:moserial", (guint32) GDK_CURRENT_TIME, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch2_g_error;
			goto __finally2;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning (_ ("Unable to display help file: %s"), e->message);
			(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
		}
	}
	__finally2:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void _moserial_main_window_url_hook_gtk_about_dialog_activate_link_func (GtkAboutDialog* about, const char* link_, gpointer self) {
	moserial_main_window_url_hook (self, about, link_);
}


static void moserial_main_window_showAboutDialog (moserialMainWindow* self) {
	char* _tmp2_;
	char* _tmp1_;
	char* _tmp0_;
	char* _tmp3_;
	char* license_trans;
	g_return_if_fail (self != NULL);
	_tmp2_ = NULL;
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	_tmp3_ = NULL;
	license_trans = (_tmp3_ = g_strconcat (_tmp2_ = g_strconcat (_tmp1_ = g_strconcat (_tmp0_ = g_strconcat (MOSERIAL_MAIN_WINDOW_license[0], "\n", NULL), MOSERIAL_MAIN_WINDOW_license[1], NULL), "\n", NULL), MOSERIAL_MAIN_WINDOW_license[2], NULL), _tmp2_ = (g_free (_tmp2_), NULL), _tmp1_ = (g_free (_tmp1_), NULL), _tmp0_ = (g_free (_tmp0_), NULL), _tmp3_);
	gtk_about_dialog_set_url_hook (_moserial_main_window_url_hook_gtk_about_dialog_activate_link_func, g_object_ref (self), g_object_unref);
	gtk_show_about_dialog (self->priv->gtkWindow, "version", VERSION, "copyright", "Copyright © 2009\nMichael J. Chudobiak\n<mjc@svn.gnome.org>", "comments", _ ("A serial terminal for the GNOME desktop, optimized for logging and file capture."), "authors", MOSERIAL_MAIN_WINDOW_authors, "translator-credits", MOSERIAL_MAIN_WINDOW_translators, "logo-icon-name", "moserial", "wrap-license", TRUE, "license", license_trans, "website", "http://live.gnome.org/moserial", NULL, NULL);
	license_trans = (g_free (license_trans), NULL);
}


static void moserial_main_window_url_hook (moserialMainWindow* self, GtkAboutDialog* about, const char* link) {
	GError * _inner_error_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (about != NULL);
	g_return_if_fail (link != NULL);
	_inner_error_ = NULL;
	{
		gtk_show_uri (NULL, link, (guint32) GDK_CURRENT_TIME, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch3_g_error;
			goto __finally3;
		}
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning (_ ("Can't display a clickable URL: %s"), e->message);
			(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
		}
	}
	__finally3:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void moserial_main_window_quitSizeSave (moserialMainWindow* self) {
	g_return_if_fail (self != NULL);
	moserial_main_window_windowSizeSave (self);
	moserial_main_window_quitSave (self);
}


static gboolean moserial_main_window_deleteSaveSize (moserialMainWindow* self, GtkWidget* widget, GdkEvent* event) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	moserial_main_window_windowSizeSave (self);
	moserial_main_window_quitSave (self);
	gtk_main_quit ();
	result = TRUE;
	return result;
}


static gboolean moserial_main_window_keyPress (moserialMainWindow* self, GtkWidget* widget, const GdkEventKey* key) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	/* Bug 551184 – Need gdk/gdkkeysyms.h bindings */
	if ((*key).keyval == 0xff1b) {
		/* Escape */
		moserial_auto_scroll_scroll (self->priv->va1);
		moserial_auto_scroll_scroll (self->priv->va2);
		moserial_auto_scroll_scroll (self->priv->va3);
		moserial_auto_scroll_scroll (self->priv->va4);
		gtk_widget_grab_focus ((GtkWidget*) self->priv->entry);
		gtk_editable_set_position ((GtkEditable*) self->priv->entry, -1);
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static void moserial_main_window_windowSizeSave (moserialMainWindow* self) {
	gint width;
	gint height;
	gint pos;
	g_return_if_fail (self != NULL);
	width = 0;
	height = 0;
	pos = gtk_paned_get_position (self->priv->paned);
	gtk_window_get_size (self->priv->gtkWindow, &width, &height);
	profile_saveWindowSize (self->priv->profile, width, height);
	profile_saveWindowPanedPosition (self->priv->profile, pos);
}


static void moserial_main_window_quitSave (moserialMainWindow* self) {
	g_return_if_fail (self != NULL);
	preferences_saveToProfile (self->priv->currentPreferences, self->priv->profile);
	settings_saveToProfile (self->priv->currentSettings, self->priv->profile);
	default_paths_saveToProfile (self->priv->currentPaths, self->priv->profile);
	if (self->priv->profileFilename != NULL) {
		if (self->priv->profileChanged) {
			GtkMessageDialog* dialog;
			gint response;
			dialog = g_object_ref_sink ((GtkMessageDialog*) gtk_message_dialog_new (self->priv->gtkWindow, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_QUESTION, GTK_BUTTONS_YES_NO, _ ("You have changed your setting or preferences. Do you want to save these changes to the loaded profile?"), NULL));
			response = gtk_dialog_run ((GtkDialog*) dialog);
			if (response == GTK_RESPONSE_YES) {
				moserial_main_window_saveProfile (self);
			}
			gtk_object_destroy ((GtkObject*) dialog);
			(dialog == NULL) ? NULL : (dialog = (g_object_unref (dialog), NULL));
		} else {
			/* Save the profile even if settings or preferences have not
			                                   changed, to save the default file locations */
			moserial_main_window_saveProfile (self);
		}
	}
	profile_save (self->priv->profile, NULL, self->priv->gtkWindow);
	gtk_main_quit ();
}


static void moserial_main_window_saveProfile (moserialMainWindow* self) {
	GError * _inner_error_;
	GtkRecentManager* _tmp0_;
	GtkRecentManager* recentManager;
	char* _tmp1_;
	char* _tmp2_;
	g_return_if_fail (self != NULL);
	_inner_error_ = NULL;
	preferences_saveToProfile (self->priv->currentPreferences, self->priv->profile);
	settings_saveToProfile (self->priv->currentSettings, self->priv->profile);
	default_paths_saveToProfile (self->priv->currentPaths, self->priv->profile);
	if (self->priv->profileFilename == NULL) {
		moserial_main_window_saveProfileAs (self);
	}
	if (self->priv->profileFilename == NULL) {
		return;
	}
	profile_save (self->priv->profile, self->priv->profileFilename, self->priv->gtkWindow);
	self->priv->profileChanged = FALSE;
	_tmp0_ = NULL;
	recentManager = (_tmp0_ = gtk_recent_manager_get_default (), (_tmp0_ == NULL) ? NULL : g_object_ref (_tmp0_));
	_tmp1_ = g_filename_to_uri (self->priv->profileFilename, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		(recentManager == NULL) ? NULL : (recentManager = (g_object_unref (recentManager), NULL));
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp2_ = NULL;
	gtk_recent_manager_add_item (recentManager, _tmp2_ = _tmp1_);
	_tmp2_ = (g_free (_tmp2_), NULL);
	(recentManager == NULL) ? NULL : (recentManager = (g_object_unref (recentManager), NULL));
}


static void moserial_main_window_saveProfileAs (moserialMainWindow* self) {
	GtkFileChooserDialog* dialog;
	gint response;
	g_return_if_fail (self != NULL);
	dialog = g_object_ref_sink ((GtkFileChooserDialog*) gtk_file_chooser_dialog_new (NULL, self->priv->gtkWindow, GTK_FILE_CHOOSER_ACTION_SAVE, NULL));
	gtk_dialog_add_buttons ((GtkDialog*) dialog, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, GTK_STOCK_SAVE, GTK_RESPONSE_ACCEPT, NULL, NULL);
	gtk_file_chooser_set_do_overwrite_confirmation ((GtkFileChooser*) dialog, TRUE);
	gtk_file_chooser_set_local_only ((GtkFileChooser*) dialog, FALSE);
	response = gtk_dialog_run ((GtkDialog*) dialog);
	if (response == GTK_RESPONSE_ACCEPT) {
		char* _tmp0_;
		_tmp0_ = NULL;
		self->priv->profileFilename = (_tmp0_ = gtk_file_chooser_get_filename ((GtkFileChooser*) dialog), self->priv->profileFilename = (g_free (self->priv->profileFilename), NULL), _tmp0_);
	}
	gtk_object_destroy ((GtkObject*) dialog);
	if (response == GTK_RESPONSE_ACCEPT) {
		moserial_main_window_saveProfile (self);
	}
	(dialog == NULL) ? NULL : (dialog = (g_object_unref (dialog), NULL));
}


static void moserial_main_window_loadProfileOnStartup (moserialMainWindow* self, const char* profileFilename) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (profileFilename != NULL);
	moserial_main_window_applyProfile (self, profileFilename);
}


static void moserial_main_window_loadProfile (moserialMainWindow* self) {
	GtkFileChooserDialog* dialog;
	gint response;
	g_return_if_fail (self != NULL);
	dialog = g_object_ref_sink ((GtkFileChooserDialog*) gtk_file_chooser_dialog_new (NULL, self->priv->gtkWindow, GTK_FILE_CHOOSER_ACTION_OPEN, NULL));
	gtk_dialog_add_buttons ((GtkDialog*) dialog, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, GTK_STOCK_OPEN, GTK_RESPONSE_ACCEPT, NULL, NULL);
	gtk_file_chooser_set_local_only ((GtkFileChooser*) dialog, FALSE);
	response = gtk_dialog_run ((GtkDialog*) dialog);
	if (response == GTK_RESPONSE_ACCEPT) {
		char* _tmp0_;
		_tmp0_ = NULL;
		moserial_main_window_applyProfile (self, _tmp0_ = gtk_file_chooser_get_filename ((GtkFileChooser*) dialog));
		_tmp0_ = (g_free (_tmp0_), NULL);
	}
	gtk_object_destroy ((GtkObject*) dialog);
	(dialog == NULL) ? NULL : (dialog = (g_object_unref (dialog), NULL));
}


static void moserial_main_window_copy (moserialMainWindow* self) {
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = FALSE;
	_tmp1_ = FALSE;
	_tmp2_ = FALSE;
	if (gtk_window_get_focus (self->priv->gtkWindow) == GTK_WIDGET (self->priv->outgoingAsciiTextView)) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = gtk_window_get_focus (self->priv->gtkWindow) == GTK_WIDGET (self->priv->incomingAsciiTextView);
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = gtk_window_get_focus (self->priv->gtkWindow) == GTK_WIDGET (self->priv->outgoingHexTextView);
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = gtk_window_get_focus (self->priv->gtkWindow) == GTK_WIDGET (self->priv->incomingHexTextView);
	}
	if (_tmp0_) {
		GtkTextView* _tmp3_;
		GtkTextView* tv;
		_tmp3_ = NULL;
		tv = (_tmp3_ = GTK_TEXT_VIEW (gtk_window_get_focus (self->priv->gtkWindow)), (_tmp3_ == NULL) ? NULL : g_object_ref (_tmp3_));
		gtk_text_buffer_copy_clipboard (gtk_text_view_get_buffer (tv), gtk_clipboard_get (GDK_SELECTION_CLIPBOARD));
		(tv == NULL) ? NULL : (tv = (g_object_unref (tv), NULL));
	} else {
		if (gtk_window_get_focus (self->priv->gtkWindow) == GTK_WIDGET (self->priv->entry)) {
			g_signal_emit_by_name (self->priv->entry, "copy-clipboard");
		}
	}
}


static void moserial_main_window_cut (moserialMainWindow* self) {
	g_return_if_fail (self != NULL);
	if (gtk_window_get_focus (self->priv->gtkWindow) == GTK_WIDGET (self->priv->entry)) {
		g_signal_emit_by_name (self->priv->entry, "cut-clipboard");
	}
}


static void moserial_main_window_editMenu (moserialMainWindow* self, GtkAction* a) {
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (a != NULL);
	_tmp0_ = FALSE;
	_tmp1_ = FALSE;
	_tmp2_ = FALSE;
	if (gtk_window_get_focus (self->priv->gtkWindow) == GTK_WIDGET (self->priv->outgoingAsciiTextView)) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = gtk_window_get_focus (self->priv->gtkWindow) == GTK_WIDGET (self->priv->incomingAsciiTextView);
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = gtk_window_get_focus (self->priv->gtkWindow) == GTK_WIDGET (self->priv->outgoingHexTextView);
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = gtk_window_get_focus (self->priv->gtkWindow) == GTK_WIDGET (self->priv->incomingHexTextView);
	}
	if (_tmp0_) {
		GtkTextView* _tmp3_;
		GtkTextView* tv;
		gtk_action_set_sensitive (self->priv->cutMenuItem, FALSE);
		_tmp3_ = NULL;
		tv = (_tmp3_ = GTK_TEXT_VIEW (gtk_window_get_focus (self->priv->gtkWindow)), (_tmp3_ == NULL) ? NULL : g_object_ref (_tmp3_));
		if (gtk_text_buffer_get_has_selection (gtk_text_view_get_buffer (tv))) {
			gtk_action_set_sensitive (self->priv->copyMenuItem, TRUE);
		} else {
			gtk_action_set_sensitive (self->priv->copyMenuItem, FALSE);
		}
		(tv == NULL) ? NULL : (tv = (g_object_unref (tv), NULL));
	} else {
		if (gtk_window_get_focus (self->priv->gtkWindow) == GTK_WIDGET (self->priv->entry)) {
			gint s;
			gint e;
			s = 0;
			e = 0;
			if (gtk_editable_get_selection_bounds ((GtkEditable*) self->priv->entry, s, e)) {
				gtk_action_set_sensitive (self->priv->cutMenuItem, TRUE);
				gtk_action_set_sensitive (self->priv->copyMenuItem, TRUE);
			} else {
				gtk_action_set_sensitive (self->priv->cutMenuItem, FALSE);
				gtk_action_set_sensitive (self->priv->copyMenuItem, FALSE);
			}
		} else {
			gtk_action_set_sensitive (self->priv->cutMenuItem, FALSE);
			gtk_action_set_sensitive (self->priv->copyMenuItem, FALSE);
		}
	}
}


static void moserial_main_window_paste (moserialMainWindow* self) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	g_signal_emit_by_name (self->priv->entry, "paste-clipboard");
	if (!(g_object_get ((GtkWidget*) self->priv->entry, "has-focus", &_tmp0_, NULL), _tmp0_)) {
		gtk_widget_grab_focus ((GtkWidget*) self->priv->entry);
		gtk_editable_set_position ((GtkEditable*) self->priv->entry, -1);
	}
}


static void moserial_main_window_clear (moserialMainWindow* self) {
	g_return_if_fail (self != NULL);
	moserial_hex_text_buffer_clear (self->priv->incomingHexTextBuffer);
	gtk_text_buffer_set_text (self->priv->incomingAsciiTextBuffer, "", 0);
	moserial_hex_text_buffer_clear (self->priv->outgoingHexTextBuffer);
	gtk_text_buffer_set_text (self->priv->outgoingAsciiTextBuffer, "", 0);
	gtk_entry_set_text (self->priv->entry, "");
}


GtkBuilder* moserial_main_window_get_builder (moserialMainWindow* self) {
	GtkBuilder* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_builder;
	return result;
}


static void moserial_main_window_set_builder (moserialMainWindow* self, GtkBuilder* value) {
	GtkBuilder* _tmp1_;
	GtkBuilder* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	self->priv->_builder = (_tmp1_ = (_tmp0_ = value, (_tmp0_ == NULL) ? NULL : g_object_ref (_tmp0_)), (self->priv->_builder == NULL) ? NULL : (self->priv->_builder = (g_object_unref (self->priv->_builder), NULL)), _tmp1_);
	g_object_notify ((GObject *) self, "builder");
}


const char* moserial_main_window_get_startupProfileFilename (moserialMainWindow* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_startupProfileFilename;
	return result;
}


static void moserial_main_window_set_startupProfileFilename (moserialMainWindow* self, const char* value) {
	char* _tmp1_;
	const char* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	self->priv->_startupProfileFilename = (_tmp1_ = (_tmp0_ = value, (_tmp0_ == NULL) ? NULL : g_strdup (_tmp0_)), self->priv->_startupProfileFilename = (g_free (self->priv->_startupProfileFilename), NULL), _tmp1_);
	g_object_notify ((GObject *) self, "startupProfileFilename");
}


static void _moserial_main_window_quitSave_gtk_object_destroy (GtkWindow* _sender, gpointer self) {
	moserial_main_window_quitSave (self);
}


static gboolean _moserial_main_window_deleteSaveSize_gtk_widget_delete_event (GtkWindow* _sender, GdkEvent* event, gpointer self) {
	return moserial_main_window_deleteSaveSize (self, _sender, event);
}


static gboolean _moserial_main_window_keyPress_gtk_widget_key_press_event (GtkWindow* _sender, const GdkEventKey* event, gpointer self) {
	return moserial_main_window_keyPress (self, _sender, event);
}


static void _moserial_main_window_quitSizeSave_gtk_action_activate (GtkAction* _sender, gpointer self) {
	moserial_main_window_quitSizeSave (self);
}


static void _moserial_main_window_saveProfileAs_gtk_action_activate (GtkAction* _sender, gpointer self) {
	moserial_main_window_saveProfileAs (self);
}


static void _moserial_main_window_saveProfile_gtk_action_activate (GtkAction* _sender, gpointer self) {
	moserial_main_window_saveProfile (self);
}


static void _moserial_main_window_loadProfile_gtk_action_activate (GtkAction* _sender, gpointer self) {
	moserial_main_window_loadProfile (self);
}


static void _moserial_main_window_copy_gtk_action_activate (GtkAction* _sender, gpointer self) {
	moserial_main_window_copy (self);
}


static void _moserial_main_window_editMenu_gtk_action_activate (GtkAction* _sender, gpointer self) {
	moserial_main_window_editMenu (self, _sender);
}


static void _moserial_main_window_cut_gtk_action_activate (GtkAction* _sender, gpointer self) {
	moserial_main_window_cut (self);
}


static void _moserial_main_window_paste_gtk_action_activate (GtkAction* _sender, gpointer self) {
	moserial_main_window_paste (self);
}


static void _moserial_main_window_clear_gtk_action_activate (GtkAction* _sender, gpointer self) {
	moserial_main_window_clear (self);
}


static void _moserial_main_window_updateSettings_moserial_settings_dialog_update_settings (moserialSettingsDialog* _sender, Settings* settings, gpointer self) {
	moserial_main_window_updateSettings (self, _sender, settings);
}


static void _moserial_main_window_showSettingsDialog_gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	moserial_main_window_showSettingsDialog (self, _sender);
}


static void _moserial_main_window_showHelpButton_gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	moserial_main_window_showHelpButton (self, _sender);
}


static void _moserial_main_window_showAboutDialog_gtk_action_activate (GtkAction* _sender, gpointer self) {
	moserial_main_window_showAboutDialog (self);
}


static void _moserial_main_window_doSendChooser_gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	moserial_main_window_doSendChooser (self, _sender);
}


static void _moserial_main_window_doSend_moserial_send_chooser_dialog_start_transfer (moserialSendChooserDialog* _sender, gpointer self) {
	moserial_main_window_doSend (self, _sender);
}


static void _moserial_main_window_doReceiveChooser_gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	moserial_main_window_doReceiveChooser (self, _sender);
}


static void _moserial_main_window_doReceive_moserial_receive_chooser_dialog_start_transfer (moserialReceiveChooserDialog* _sender, gpointer self) {
	moserial_main_window_doReceive (self, _sender);
}


static void _moserial_main_window_record_gtk_tool_button_clicked (GtkToggleToolButton* _sender, gpointer self) {
	moserial_main_window_record (self, _sender);
}


static void _moserial_main_window_stopRecording_moserial_record_dialog_stop_recording (moserialRecordDialog* _sender, gpointer self) {
	moserial_main_window_stopRecording (self, _sender);
}


static void _moserial_main_window_startRecording_moserial_record_dialog_start_recording (moserialRecordDialog* _sender, const char* fileName, moserialSerialStreamRecorderDirection direction, gpointer self) {
	moserial_main_window_startRecording (self, _sender, fileName, direction);
}


static void _moserial_main_window_updatePreferences_moserial_preferences_dialog_update_preferences (moserialPreferencesDialog* _sender, Preferences* preferences, gpointer self) {
	moserial_main_window_updatePreferences (self, _sender, preferences);
}


static void _moserial_main_window_showPreferencesDialog_gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	moserial_main_window_showPreferencesDialog (self, _sender);
}


static void _moserial_main_window_connectButtonClick_gtk_tool_button_clicked (GtkToggleToolButton* _sender, gpointer self) {
	moserial_main_window_connectButtonClick (self, _sender);
}


static void _moserial_main_window_showHelpAction_gtk_action_activate (GtkAction* _sender, gpointer self) {
	moserial_main_window_showHelpAction (self, _sender);
}


static void _moserial_main_window_sendString_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	moserial_main_window_sendString (self, _sender);
}


static void _moserial_main_window_sendString_gtk_entry_activate (GtkEntry* _sender, gpointer self) {
	moserial_main_window_sendString (self, _sender);
}


static void _moserial_main_window_inputModeChanged_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self) {
	moserial_main_window_inputModeChanged (self, _sender);
}


static void _moserial_main_window_recentItemOpen_gtk_recent_chooser_item_activated (GtkRecentChooserMenu* _sender, gpointer self) {
	moserial_main_window_recentItemOpen (self, _sender);
}


static GObject * moserial_main_window_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	moserialMainWindowClass * klass;
	GObjectClass * parent_class;
	moserialMainWindow * self;
	klass = MOSERIAL_MAIN_WINDOW_CLASS (g_type_class_peek (MOSERIAL_TYPE_MAIN_WINDOW));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = MOSERIAL_MAIN_WINDOW (obj);
	{
		GtkWindow* _tmp1_;
		GtkWindow* _tmp0_;
		Profile* _tmp2_;
		Settings* _tmp3_;
		gint width;
		gint height;
		gint panedPosition;
		gboolean _tmp4_;
		GtkPaned* _tmp6_;
		GtkPaned* _tmp5_;
		GtkAction* _tmp7_;
		GtkAction* quit;
		GtkAction* _tmp8_;
		GtkAction* saveAs;
		GtkAction* _tmp9_;
		GtkAction* save;
		GtkAction* _tmp10_;
		GtkAction* open;
		GtkAction* _tmp12_;
		GtkAction* _tmp11_;
		GtkAction* _tmp13_;
		GtkAction* editMenuItem;
		GtkAction* _tmp15_;
		GtkAction* _tmp14_;
		GtkAction* _tmp16_;
		GtkAction* pasteMenuItem;
		GtkAction* _tmp17_;
		GtkAction* clearMenuItem;
		moserialSettingsDialog* _tmp18_;
		GtkToolButton* _tmp20_;
		GtkToolButton* _tmp19_;
		GtkToolButton* _tmp21_;
		GtkToolButton* helpButton;
		GtkStatusbar* _tmp23_;
		GtkStatusbar* _tmp22_;
		char* _tmp24_;
		GtkStatusbar* _tmp26_;
		GtkStatusbar* _tmp25_;
		GtkAction* _tmp27_;
		GtkAction* about;
		moserialSendProgressDialog* _tmp28_;
		moserialSendChooserDialog* _tmp29_;
		GtkToolButton* _tmp31_;
		GtkToolButton* _tmp30_;
		moserialSzwrapper* _tmp33_;
		moserialSzwrapperProtocol _tmp32_;
		moserialReceiveProgressDialog* _tmp34_;
		moserialReceiveChooserDialog* _tmp35_;
		GtkToolButton* _tmp37_;
		GtkToolButton* _tmp36_;
		moserialXmodemFilenameDialog* _tmp38_;
		moserialRzwrapper* _tmp40_;
		moserialRzwrapperProtocol _tmp39_;
		moserialRecordDialog* _tmp41_;
		GtkToggleToolButton* _tmp43_;
		GtkToggleToolButton* _tmp42_;
		GtkLabel* _tmp45_;
		GtkLabel* _tmp44_;
		GtkLabel* _tmp47_;
		GtkLabel* _tmp46_;
		moserialPreferencesDialog* _tmp48_;
		GtkToolButton* _tmp49_;
		GtkToolButton* preferences;
		GtkToggleToolButton* _tmp51_;
		GtkToggleToolButton* _tmp50_;
		GtkLabel* _tmp53_;
		GtkLabel* _tmp52_;
		GtkLabel* _tmp55_;
		GtkLabel* _tmp54_;
		GtkAction* _tmp56_;
		GtkAction* contents;
		GtkNotebook* _tmp58_;
		GtkNotebook* _tmp57_;
		GtkNotebook* _tmp60_;
		GtkNotebook* _tmp59_;
		moserialHexTextBuffer* _tmp61_;
		GtkTextBuffer* _tmp63_;
		GtkTextTagTable* _tmp62_;
		moserialHexTextBuffer* _tmp64_;
		GtkTextBuffer* _tmp66_;
		GtkTextTagTable* _tmp65_;
		GtkTextTag* _tmp68_;
		GtkTextTag* _tmp67_;
		GtkTextView* _tmp70_;
		GtkTextView* _tmp69_;
		PangoFontDescription* _tmp71_;
		GtkTextView* _tmp73_;
		GtkTextView* _tmp72_;
		PangoFontDescription* _tmp74_;
		GtkTextView* _tmp76_;
		GtkTextView* _tmp75_;
		PangoFontDescription* _tmp77_;
		GtkTextView* _tmp79_;
		GtkTextView* _tmp78_;
		PangoFontDescription* _tmp80_;
		GtkScrolledWindow* _tmp81_;
		GtkScrolledWindow* incomingAsciiScrolledWindow;
		GtkAdjustment* _tmp83_;
		GtkAdjustment* _tmp82_;
		GtkScrolledWindow* _tmp84_;
		GtkScrolledWindow* incomingHexScrolledWindow;
		GtkAdjustment* _tmp86_;
		GtkAdjustment* _tmp85_;
		GtkScrolledWindow* _tmp87_;
		GtkScrolledWindow* outgoingAsciiScrolledWindow;
		GtkAdjustment* _tmp89_;
		GtkAdjustment* _tmp88_;
		GtkScrolledWindow* _tmp90_;
		GtkScrolledWindow* outgoingHexScrolledWindow;
		GtkAdjustment* _tmp92_;
		GtkAdjustment* _tmp91_;
		GtkButton* _tmp94_;
		GtkButton* _tmp93_;
		GtkEntry* _tmp96_;
		GtkEntry* _tmp95_;
		GtkComboBox* _tmp98_;
		GtkComboBox* _tmp97_;
		GtkComboBox* _tmp100_;
		GtkComboBox* _tmp99_;
		GtkRecentManager* _tmp101_;
		GtkRecentManager* recentManager;
		GtkRecentChooserMenu* recentChooserMenu;
		GtkRecentFilter* filter;
		GtkMenuShell* _tmp102_;
		GtkMenuShell* menuBar;
		GList* children;
		GtkMenuItem* fileMenu;
		GtkMenuItem* _tmp104_;
		GtkMenuItem* _tmp103_;
		GtkMenuShell* _tmp105_;
		GtkMenuShell* fileMenuShell;
		GList* _tmp106_;
		GtkMenuItem* _tmp107_;
		GtkMenuItem* recentFileItem;
		Preferences* _tmp108_;
		DefaultPaths* _tmp109_;
		/*setup window*/
		_tmp1_ = NULL;
		_tmp0_ = NULL;
		self->priv->gtkWindow = (_tmp1_ = (_tmp0_ = GTK_WINDOW (gtk_builder_get_object (self->priv->_builder, "window")), (_tmp0_ == NULL) ? NULL : g_object_ref (_tmp0_)), (self->priv->gtkWindow == NULL) ? NULL : (self->priv->gtkWindow = (g_object_unref (self->priv->gtkWindow), NULL)), _tmp1_);
		g_signal_connect_object ((GtkObject*) self->priv->gtkWindow, "destroy", (GCallback) _moserial_main_window_quitSave_gtk_object_destroy, self, 0);
		g_signal_connect_object ((GtkWidget*) self->priv->gtkWindow, "delete-event", (GCallback) _moserial_main_window_deleteSaveSize_gtk_widget_delete_event, self, 0);
		g_signal_connect_object ((GtkWidget*) self->priv->gtkWindow, "key-press-event", (GCallback) _moserial_main_window_keyPress_gtk_widget_key_press_event, self, 0);
		/*load defaults*/
		_tmp2_ = NULL;
		self->priv->profile = (_tmp2_ = profile_new (), (self->priv->profile == NULL) ? NULL : (self->priv->profile = (g_object_unref (self->priv->profile), NULL)), _tmp2_);
		profile_load (self->priv->profile, NULL, self->priv->gtkWindow);
		_tmp3_ = NULL;
		self->priv->currentSettings = (_tmp3_ = settings_loadFromProfile (self->priv->profile), (self->priv->currentSettings == NULL) ? NULL : (self->priv->currentSettings = (g_object_unref (self->priv->currentSettings), NULL)), _tmp3_);
		width = profile_getWindowWidth (self->priv->profile);
		height = profile_getWindowHeight (self->priv->profile);
		panedPosition = profile_getWindowPanedPosition (self->priv->profile);
		_tmp4_ = FALSE;
		if (width > 0) {
			_tmp4_ = height > 0;
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			gtk_window_resize (self->priv->gtkWindow, width, height);
		}
		/*setup paned*/
		_tmp6_ = NULL;
		_tmp5_ = NULL;
		self->priv->paned = (_tmp6_ = (_tmp5_ = GTK_PANED (gtk_builder_get_object (self->priv->_builder, "vpaned")), (_tmp5_ == NULL) ? NULL : g_object_ref (_tmp5_)), (self->priv->paned == NULL) ? NULL : (self->priv->paned = (g_object_unref (self->priv->paned), NULL)), _tmp6_);
		if (panedPosition >= (-1)) {
			gtk_paned_set_position (self->priv->paned, panedPosition);
		} else {
			gtk_paned_set_position (self->priv->paned, -1);
		}
		/*setup menu items*/
		_tmp7_ = NULL;
		quit = (_tmp7_ = GTK_ACTION (gtk_builder_get_object (self->priv->_builder, "menubar_quit")), (_tmp7_ == NULL) ? NULL : g_object_ref (_tmp7_));
		g_signal_connect_object (quit, "activate", (GCallback) _moserial_main_window_quitSizeSave_gtk_action_activate, self, 0);
		_tmp8_ = NULL;
		saveAs = (_tmp8_ = GTK_ACTION (gtk_builder_get_object (self->priv->_builder, "menubar_save_settings_as")), (_tmp8_ == NULL) ? NULL : g_object_ref (_tmp8_));
		g_signal_connect_object (saveAs, "activate", (GCallback) _moserial_main_window_saveProfileAs_gtk_action_activate, self, 0);
		_tmp9_ = NULL;
		save = (_tmp9_ = GTK_ACTION (gtk_builder_get_object (self->priv->_builder, "menubar_save_settings")), (_tmp9_ == NULL) ? NULL : g_object_ref (_tmp9_));
		g_signal_connect_object (save, "activate", (GCallback) _moserial_main_window_saveProfile_gtk_action_activate, self, 0);
		_tmp10_ = NULL;
		open = (_tmp10_ = GTK_ACTION (gtk_builder_get_object (self->priv->_builder, "menubar_open_settings")), (_tmp10_ == NULL) ? NULL : g_object_ref (_tmp10_));
		g_signal_connect_object (open, "activate", (GCallback) _moserial_main_window_loadProfile_gtk_action_activate, self, 0);
		_tmp12_ = NULL;
		_tmp11_ = NULL;
		self->priv->copyMenuItem = (_tmp12_ = (_tmp11_ = GTK_ACTION (gtk_builder_get_object (self->priv->_builder, "menubar_copy")), (_tmp11_ == NULL) ? NULL : g_object_ref (_tmp11_)), (self->priv->copyMenuItem == NULL) ? NULL : (self->priv->copyMenuItem = (g_object_unref (self->priv->copyMenuItem), NULL)), _tmp12_);
		g_signal_connect_object (self->priv->copyMenuItem, "activate", (GCallback) _moserial_main_window_copy_gtk_action_activate, self, 0);
		_tmp13_ = NULL;
		editMenuItem = (_tmp13_ = GTK_ACTION (gtk_builder_get_object (self->priv->_builder, "menubar_edit")), (_tmp13_ == NULL) ? NULL : g_object_ref (_tmp13_));
		g_signal_connect_object (editMenuItem, "activate", (GCallback) _moserial_main_window_editMenu_gtk_action_activate, self, 0);
		_tmp15_ = NULL;
		_tmp14_ = NULL;
		self->priv->cutMenuItem = (_tmp15_ = (_tmp14_ = GTK_ACTION (gtk_builder_get_object (self->priv->_builder, "menubar_cut")), (_tmp14_ == NULL) ? NULL : g_object_ref (_tmp14_)), (self->priv->cutMenuItem == NULL) ? NULL : (self->priv->cutMenuItem = (g_object_unref (self->priv->cutMenuItem), NULL)), _tmp15_);
		gtk_action_set_sensitive (self->priv->copyMenuItem, FALSE);
		gtk_action_set_sensitive (self->priv->cutMenuItem, FALSE);
		g_signal_connect_object (self->priv->cutMenuItem, "activate", (GCallback) _moserial_main_window_cut_gtk_action_activate, self, 0);
		_tmp16_ = NULL;
		pasteMenuItem = (_tmp16_ = GTK_ACTION (gtk_builder_get_object (self->priv->_builder, "menubar_paste")), (_tmp16_ == NULL) ? NULL : g_object_ref (_tmp16_));
		g_signal_connect_object (pasteMenuItem, "activate", (GCallback) _moserial_main_window_paste_gtk_action_activate, self, 0);
		_tmp17_ = NULL;
		clearMenuItem = (_tmp17_ = GTK_ACTION (gtk_builder_get_object (self->priv->_builder, "menubar_clear")), (_tmp17_ == NULL) ? NULL : g_object_ref (_tmp17_));
		g_signal_connect_object (clearMenuItem, "activate", (GCallback) _moserial_main_window_clear_gtk_action_activate, self, 0);
		/*setup the Port Settings Dialog*/
		_tmp18_ = NULL;
		self->priv->settingsDialog = (_tmp18_ = moserial_settings_dialog_new (self->priv->_builder), (self->priv->settingsDialog == NULL) ? NULL : (self->priv->settingsDialog = (g_object_unref (self->priv->settingsDialog), NULL)), _tmp18_);
		g_signal_connect_object (self->priv->settingsDialog, "update-settings", (GCallback) _moserial_main_window_updateSettings_moserial_settings_dialog_update_settings, self, 0);
		_tmp20_ = NULL;
		_tmp19_ = NULL;
		self->priv->settingsButton = (_tmp20_ = (_tmp19_ = GTK_TOOL_BUTTON (gtk_builder_get_object (self->priv->_builder, "toolbar_settings")), (_tmp19_ == NULL) ? NULL : g_object_ref (_tmp19_)), (self->priv->settingsButton == NULL) ? NULL : (self->priv->settingsButton = (g_object_unref (self->priv->settingsButton), NULL)), _tmp20_);
		g_signal_connect_object (self->priv->settingsButton, "clicked", (GCallback) _moserial_main_window_showSettingsDialog_gtk_tool_button_clicked, self, 0);
		/*setup the Help button*/
		_tmp21_ = NULL;
		helpButton = (_tmp21_ = GTK_TOOL_BUTTON (gtk_builder_get_object (self->priv->_builder, "toolbar_help")), (_tmp21_ == NULL) ? NULL : g_object_ref (_tmp21_));
		g_signal_connect_object (helpButton, "clicked", (GCallback) _moserial_main_window_showHelpButton_gtk_tool_button_clicked, self, 0);
		/*setup the statusbar*/
		_tmp23_ = NULL;
		_tmp22_ = NULL;
		self->priv->statusbar = (_tmp23_ = (_tmp22_ = GTK_STATUSBAR (gtk_builder_get_object (self->priv->_builder, "statusbar")), (_tmp22_ == NULL) ? NULL : g_object_ref (_tmp22_)), (self->priv->statusbar == NULL) ? NULL : (self->priv->statusbar = (g_object_unref (self->priv->statusbar), NULL)), _tmp23_);
		self->priv->statusbarContext = gtk_statusbar_get_context_id (self->priv->statusbar, "moserial port status");
		_tmp24_ = NULL;
		gtk_statusbar_push (self->priv->statusbar, self->priv->statusbarContext, _tmp24_ = settings_getStatusbarString (self->priv->currentSettings, FALSE));
		_tmp24_ = (g_free (_tmp24_), NULL);
		/*setup the byte count bar*/
		_tmp26_ = NULL;
		_tmp25_ = NULL;
		self->priv->bytecountbar = (_tmp26_ = (_tmp25_ = GTK_STATUSBAR (gtk_builder_get_object (self->priv->_builder, "bytecountbar")), (_tmp25_ == NULL) ? NULL : g_object_ref (_tmp25_)), (self->priv->bytecountbar == NULL) ? NULL : (self->priv->bytecountbar = (g_object_unref (self->priv->bytecountbar), NULL)), _tmp26_);
		self->priv->bytecountbarContext = gtk_statusbar_get_context_id (self->priv->statusbar, "moserial byte counts");
		gtk_statusbar_push (self->priv->bytecountbar, self->priv->bytecountbarContext, _ ("TX: 0, RX: 0"));
		/*setup the about dialog*/
		_tmp27_ = NULL;
		about = (_tmp27_ = GTK_ACTION (gtk_builder_get_object (self->priv->_builder, "menubar_about")), (_tmp27_ == NULL) ? NULL : g_object_ref (_tmp27_));
		g_signal_connect_object (about, "activate", (GCallback) _moserial_main_window_showAboutDialog_gtk_action_activate, self, 0);
		/*setup send*/
		_tmp28_ = NULL;
		self->priv->sendProgressDialog = (_tmp28_ = moserial_send_progress_dialog_new (self->priv->_builder), (self->priv->sendProgressDialog == NULL) ? NULL : (self->priv->sendProgressDialog = (g_object_unref (self->priv->sendProgressDialog), NULL)), _tmp28_);
		_tmp29_ = NULL;
		self->priv->sendChooserDialog = (_tmp29_ = moserial_send_chooser_dialog_new (self->priv->_builder), (self->priv->sendChooserDialog == NULL) ? NULL : (self->priv->sendChooserDialog = (g_object_unref (self->priv->sendChooserDialog), NULL)), _tmp29_);
		_tmp31_ = NULL;
		_tmp30_ = NULL;
		self->priv->send = (_tmp31_ = (_tmp30_ = GTK_TOOL_BUTTON (gtk_builder_get_object (self->priv->_builder, "toolbar_send")), (_tmp30_ == NULL) ? NULL : g_object_ref (_tmp30_)), (self->priv->send == NULL) ? NULL : (self->priv->send = (g_object_unref (self->priv->send), NULL)), _tmp31_);
		g_signal_connect_object (self->priv->send, "clicked", (GCallback) _moserial_main_window_doSendChooser_gtk_tool_button_clicked, self, 0);
		g_signal_connect_object (self->priv->sendChooserDialog, "start-transfer", (GCallback) _moserial_main_window_doSend_moserial_send_chooser_dialog_start_transfer, self, 0);
		_tmp33_ = NULL;
		self->priv->sz = (_tmp33_ = moserial_szwrapper_new ((_tmp32_ = MOSERIAL_SZWRAPPER_PROTOCOL_NULL, &_tmp32_), NULL, NULL), (self->priv->sz == NULL) ? NULL : (self->priv->sz = (g_object_unref (self->priv->sz), NULL)), _tmp33_);
		/*setup receive*/
		_tmp34_ = NULL;
		self->priv->receiveProgressDialog = (_tmp34_ = moserial_receive_progress_dialog_new (self->priv->_builder), (self->priv->receiveProgressDialog == NULL) ? NULL : (self->priv->receiveProgressDialog = (g_object_unref (self->priv->receiveProgressDialog), NULL)), _tmp34_);
		_tmp35_ = NULL;
		self->priv->receiveChooserDialog = (_tmp35_ = moserial_receive_chooser_dialog_new (self->priv->_builder), (self->priv->receiveChooserDialog == NULL) ? NULL : (self->priv->receiveChooserDialog = (g_object_unref (self->priv->receiveChooserDialog), NULL)), _tmp35_);
		_tmp37_ = NULL;
		_tmp36_ = NULL;
		self->priv->receive = (_tmp37_ = (_tmp36_ = GTK_TOOL_BUTTON (gtk_builder_get_object (self->priv->_builder, "toolbar_receive")), (_tmp36_ == NULL) ? NULL : g_object_ref (_tmp36_)), (self->priv->receive == NULL) ? NULL : (self->priv->receive = (g_object_unref (self->priv->receive), NULL)), _tmp37_);
		g_signal_connect_object (self->priv->receive, "clicked", (GCallback) _moserial_main_window_doReceiveChooser_gtk_tool_button_clicked, self, 0);
		g_signal_connect_object (self->priv->receiveChooserDialog, "start-transfer", (GCallback) _moserial_main_window_doReceive_moserial_receive_chooser_dialog_start_transfer, self, 0);
		_tmp38_ = NULL;
		self->priv->xmodemFilenameDialog = (_tmp38_ = moserial_xmodem_filename_dialog_new (self->priv->_builder), (self->priv->xmodemFilenameDialog == NULL) ? NULL : (self->priv->xmodemFilenameDialog = (g_object_unref (self->priv->xmodemFilenameDialog), NULL)), _tmp38_);
		_tmp40_ = NULL;
		self->priv->rz = (_tmp40_ = moserial_rzwrapper_new ((_tmp39_ = MOSERIAL_RZWRAPPER_PROTOCOL_NULL, &_tmp39_), NULL, NULL, NULL), (self->priv->rz == NULL) ? NULL : (self->priv->rz = (g_object_unref (self->priv->rz), NULL)), _tmp40_);
		/*setup recording*/
		_tmp41_ = NULL;
		self->priv->recordDialog = (_tmp41_ = moserial_record_dialog_new (self->priv->_builder), (self->priv->recordDialog == NULL) ? NULL : (self->priv->recordDialog = (g_object_unref (self->priv->recordDialog), NULL)), _tmp41_);
		_tmp43_ = NULL;
		_tmp42_ = NULL;
		self->priv->recordButton = (_tmp43_ = (_tmp42_ = GTK_TOGGLE_TOOL_BUTTON (gtk_builder_get_object (self->priv->_builder, "toolbar_logging")), (_tmp42_ == NULL) ? NULL : g_object_ref (_tmp42_)), (self->priv->recordButton == NULL) ? NULL : (self->priv->recordButton = (g_object_unref (self->priv->recordButton), NULL)), _tmp43_);
		g_signal_connect_object ((GtkToolButton*) self->priv->recordButton, "clicked", (GCallback) _moserial_main_window_record_gtk_tool_button_clicked, self, 0);
		g_signal_connect_object (self->priv->recordDialog, "stop-recording", (GCallback) _moserial_main_window_stopRecording_moserial_record_dialog_stop_recording, self, 0);
		g_signal_connect_object (self->priv->recordDialog, "start-recording", (GCallback) _moserial_main_window_startRecording_moserial_record_dialog_start_recording, self, 0);
		_tmp45_ = NULL;
		_tmp44_ = NULL;
		self->priv->recordLabel = (_tmp45_ = (_tmp44_ = GTK_LABEL (gtk_builder_get_object (self->priv->_builder, "record_label")), (_tmp44_ == NULL) ? NULL : g_object_ref (_tmp44_)), (self->priv->recordLabel == NULL) ? NULL : (self->priv->recordLabel = (g_object_unref (self->priv->recordLabel), NULL)), _tmp45_);
		_tmp47_ = NULL;
		_tmp46_ = NULL;
		self->priv->stopRecordingLabel = (_tmp47_ = (_tmp46_ = GTK_LABEL (gtk_builder_get_object (self->priv->_builder, "stop_recording_label")), (_tmp46_ == NULL) ? NULL : g_object_ref (_tmp46_)), (self->priv->stopRecordingLabel == NULL) ? NULL : (self->priv->stopRecordingLabel = (g_object_unref (self->priv->stopRecordingLabel), NULL)), _tmp47_);
		/*setup preferences*/
		_tmp48_ = NULL;
		self->priv->preferencesDialog = (_tmp48_ = moserial_preferences_dialog_new (self->priv->_builder), (self->priv->preferencesDialog == NULL) ? NULL : (self->priv->preferencesDialog = (g_object_unref (self->priv->preferencesDialog), NULL)), _tmp48_);
		g_signal_connect_object (self->priv->preferencesDialog, "update-preferences", (GCallback) _moserial_main_window_updatePreferences_moserial_preferences_dialog_update_preferences, self, 0);
		_tmp49_ = NULL;
		preferences = (_tmp49_ = GTK_TOOL_BUTTON (gtk_builder_get_object (self->priv->_builder, "toolbar_preferences")), (_tmp49_ == NULL) ? NULL : g_object_ref (_tmp49_));
		g_signal_connect_object (preferences, "clicked", (GCallback) _moserial_main_window_showPreferencesDialog_gtk_tool_button_clicked, self, 0);
		/*setup connectbutton*/
		_tmp51_ = NULL;
		_tmp50_ = NULL;
		self->priv->connectButton = (_tmp51_ = (_tmp50_ = GTK_TOGGLE_TOOL_BUTTON (gtk_builder_get_object (self->priv->_builder, "toolbar_connect")), (_tmp50_ == NULL) ? NULL : g_object_ref (_tmp50_)), (self->priv->connectButton == NULL) ? NULL : (self->priv->connectButton = (g_object_unref (self->priv->connectButton), NULL)), _tmp51_);
		g_signal_connect_object ((GtkToolButton*) self->priv->connectButton, "clicked", (GCallback) _moserial_main_window_connectButtonClick_gtk_tool_button_clicked, self, 0);
		_tmp53_ = NULL;
		_tmp52_ = NULL;
		self->priv->disconnectLabel = (_tmp53_ = (_tmp52_ = GTK_LABEL (gtk_builder_get_object (self->priv->_builder, "disconnect_label")), (_tmp52_ == NULL) ? NULL : g_object_ref (_tmp52_)), (self->priv->disconnectLabel == NULL) ? NULL : (self->priv->disconnectLabel = (g_object_unref (self->priv->disconnectLabel), NULL)), _tmp53_);
		_tmp55_ = NULL;
		_tmp54_ = NULL;
		self->priv->connectLabel = (_tmp55_ = (_tmp54_ = GTK_LABEL (gtk_builder_get_object (self->priv->_builder, "connect_label")), (_tmp54_ == NULL) ? NULL : g_object_ref (_tmp54_)), (self->priv->connectLabel == NULL) ? NULL : (self->priv->connectLabel = (g_object_unref (self->priv->connectLabel), NULL)), _tmp55_);
		/*setup help*/
		_tmp56_ = NULL;
		contents = (_tmp56_ = GTK_ACTION (gtk_builder_get_object (self->priv->_builder, "menubar_contents")), (_tmp56_ == NULL) ? NULL : g_object_ref (_tmp56_));
		g_signal_connect_object (contents, "activate", (GCallback) _moserial_main_window_showHelpAction_gtk_action_activate, self, 0);
		/*setup incoming notebook*/
		_tmp58_ = NULL;
		_tmp57_ = NULL;
		self->priv->incoming_notebook = (_tmp58_ = (_tmp57_ = GTK_NOTEBOOK (gtk_builder_get_object (self->priv->_builder, "incoming_notebook")), (_tmp57_ == NULL) ? NULL : g_object_ref (_tmp57_)), (self->priv->incoming_notebook == NULL) ? NULL : (self->priv->incoming_notebook = (g_object_unref (self->priv->incoming_notebook), NULL)), _tmp58_);
		/*setup outgoing notebook*/
		_tmp60_ = NULL;
		_tmp59_ = NULL;
		self->priv->outgoing_notebook = (_tmp60_ = (_tmp59_ = GTK_NOTEBOOK (gtk_builder_get_object (self->priv->_builder, "outgoing_notebook")), (_tmp59_ == NULL) ? NULL : g_object_ref (_tmp59_)), (self->priv->outgoing_notebook == NULL) ? NULL : (self->priv->outgoing_notebook = (g_object_unref (self->priv->outgoing_notebook), NULL)), _tmp60_);
		/*setup textBuffers;*/
		_tmp61_ = NULL;
		self->priv->incomingHexTextBuffer = (_tmp61_ = moserial_hex_text_buffer_new (), (self->priv->incomingHexTextBuffer == NULL) ? NULL : (self->priv->incomingHexTextBuffer = (g_object_unref (self->priv->incomingHexTextBuffer), NULL)), _tmp61_);
		_tmp63_ = NULL;
		_tmp62_ = NULL;
		self->priv->incomingAsciiTextBuffer = (_tmp63_ = gtk_text_buffer_new (_tmp62_ = gtk_text_tag_table_new ()), (self->priv->incomingAsciiTextBuffer == NULL) ? NULL : (self->priv->incomingAsciiTextBuffer = (g_object_unref (self->priv->incomingAsciiTextBuffer), NULL)), _tmp63_);
		(_tmp62_ == NULL) ? NULL : (_tmp62_ = (g_object_unref (_tmp62_), NULL));
		_tmp64_ = NULL;
		self->priv->outgoingHexTextBuffer = (_tmp64_ = moserial_hex_text_buffer_new (), (self->priv->outgoingHexTextBuffer == NULL) ? NULL : (self->priv->outgoingHexTextBuffer = (g_object_unref (self->priv->outgoingHexTextBuffer), NULL)), _tmp64_);
		_tmp66_ = NULL;
		_tmp65_ = NULL;
		self->priv->outgoingAsciiTextBuffer = (_tmp66_ = gtk_text_buffer_new (_tmp65_ = gtk_text_tag_table_new ()), (self->priv->outgoingAsciiTextBuffer == NULL) ? NULL : (self->priv->outgoingAsciiTextBuffer = (g_object_unref (self->priv->outgoingAsciiTextBuffer), NULL)), _tmp66_);
		(_tmp65_ == NULL) ? NULL : (_tmp65_ = (g_object_unref (_tmp65_), NULL));
		_tmp68_ = NULL;
		_tmp67_ = NULL;
		self->priv->echoTag = (_tmp68_ = (_tmp67_ = gtk_text_buffer_create_tag (self->priv->incomingAsciiTextBuffer, "echo", NULL, NULL), (_tmp67_ == NULL) ? NULL : g_object_ref (_tmp67_)), (self->priv->echoTag == NULL) ? NULL : (self->priv->echoTag = (g_object_unref (self->priv->echoTag), NULL)), _tmp68_);
		_tmp70_ = NULL;
		_tmp69_ = NULL;
		self->priv->incomingHexTextView = (_tmp70_ = (_tmp69_ = GTK_TEXT_VIEW (gtk_builder_get_object (self->priv->_builder, "incoming_hex_textview")), (_tmp69_ == NULL) ? NULL : g_object_ref (_tmp69_)), (self->priv->incomingHexTextView == NULL) ? NULL : (self->priv->incomingHexTextView = (g_object_unref (self->priv->incomingHexTextView), NULL)), _tmp70_);
		_tmp71_ = NULL;
		gtk_widget_modify_font ((GtkWidget*) self->priv->incomingHexTextView, _tmp71_ = pango_font_description_from_string ("Monospace 10"));
		(_tmp71_ == NULL) ? NULL : (_tmp71_ = (pango_font_description_free (_tmp71_), NULL));
		gtk_text_view_set_buffer (self->priv->incomingHexTextView, (GtkTextBuffer*) self->priv->incomingHexTextBuffer);
		_tmp73_ = NULL;
		_tmp72_ = NULL;
		self->priv->incomingAsciiTextView = (_tmp73_ = (_tmp72_ = GTK_TEXT_VIEW (gtk_builder_get_object (self->priv->_builder, "incoming_ascii_textview")), (_tmp72_ == NULL) ? NULL : g_object_ref (_tmp72_)), (self->priv->incomingAsciiTextView == NULL) ? NULL : (self->priv->incomingAsciiTextView = (g_object_unref (self->priv->incomingAsciiTextView), NULL)), _tmp73_);
		_tmp74_ = NULL;
		gtk_widget_modify_font ((GtkWidget*) self->priv->incomingAsciiTextView, _tmp74_ = pango_font_description_from_string ("Monospace 10"));
		(_tmp74_ == NULL) ? NULL : (_tmp74_ = (pango_font_description_free (_tmp74_), NULL));
		gtk_text_view_set_buffer (self->priv->incomingAsciiTextView, self->priv->incomingAsciiTextBuffer);
		_tmp76_ = NULL;
		_tmp75_ = NULL;
		self->priv->outgoingHexTextView = (_tmp76_ = (_tmp75_ = GTK_TEXT_VIEW (gtk_builder_get_object (self->priv->_builder, "outgoing_hex_textview")), (_tmp75_ == NULL) ? NULL : g_object_ref (_tmp75_)), (self->priv->outgoingHexTextView == NULL) ? NULL : (self->priv->outgoingHexTextView = (g_object_unref (self->priv->outgoingHexTextView), NULL)), _tmp76_);
		_tmp77_ = NULL;
		gtk_widget_modify_font ((GtkWidget*) self->priv->outgoingHexTextView, _tmp77_ = pango_font_description_from_string ("Monospace 10"));
		(_tmp77_ == NULL) ? NULL : (_tmp77_ = (pango_font_description_free (_tmp77_), NULL));
		gtk_text_view_set_buffer (self->priv->outgoingHexTextView, (GtkTextBuffer*) self->priv->outgoingHexTextBuffer);
		_tmp79_ = NULL;
		_tmp78_ = NULL;
		self->priv->outgoingAsciiTextView = (_tmp79_ = (_tmp78_ = GTK_TEXT_VIEW (gtk_builder_get_object (self->priv->_builder, "outgoing_ascii_textview")), (_tmp78_ == NULL) ? NULL : g_object_ref (_tmp78_)), (self->priv->outgoingAsciiTextView == NULL) ? NULL : (self->priv->outgoingAsciiTextView = (g_object_unref (self->priv->outgoingAsciiTextView), NULL)), _tmp79_);
		_tmp80_ = NULL;
		gtk_widget_modify_font ((GtkWidget*) self->priv->outgoingAsciiTextView, _tmp80_ = pango_font_description_from_string ("Monospace 10"));
		(_tmp80_ == NULL) ? NULL : (_tmp80_ = (pango_font_description_free (_tmp80_), NULL));
		gtk_text_view_set_buffer (self->priv->outgoingAsciiTextView, self->priv->outgoingAsciiTextBuffer);
		/*setup scrolling*/
		_tmp81_ = NULL;
		incomingAsciiScrolledWindow = (_tmp81_ = GTK_SCROLLED_WINDOW (gtk_builder_get_object (self->priv->_builder, "incoming_ascii_scrolledwindow")), (_tmp81_ == NULL) ? NULL : g_object_ref (_tmp81_));
		_tmp83_ = NULL;
		_tmp82_ = NULL;
		self->priv->va1 = (_tmp83_ = (_tmp82_ = gtk_scrolled_window_get_vadjustment (incomingAsciiScrolledWindow), (_tmp82_ == NULL) ? NULL : g_object_ref (_tmp82_)), (self->priv->va1 == NULL) ? NULL : (self->priv->va1 = (g_object_unref (self->priv->va1), NULL)), _tmp83_);
		_tmp84_ = NULL;
		incomingHexScrolledWindow = (_tmp84_ = GTK_SCROLLED_WINDOW (gtk_builder_get_object (self->priv->_builder, "incoming_hex_scrolledwindow")), (_tmp84_ == NULL) ? NULL : g_object_ref (_tmp84_));
		_tmp86_ = NULL;
		_tmp85_ = NULL;
		self->priv->va2 = (_tmp86_ = (_tmp85_ = gtk_scrolled_window_get_vadjustment (incomingHexScrolledWindow), (_tmp85_ == NULL) ? NULL : g_object_ref (_tmp85_)), (self->priv->va2 == NULL) ? NULL : (self->priv->va2 = (g_object_unref (self->priv->va2), NULL)), _tmp86_);
		_tmp87_ = NULL;
		outgoingAsciiScrolledWindow = (_tmp87_ = GTK_SCROLLED_WINDOW (gtk_builder_get_object (self->priv->_builder, "outgoing_ascii_scrolledwindow")), (_tmp87_ == NULL) ? NULL : g_object_ref (_tmp87_));
		_tmp89_ = NULL;
		_tmp88_ = NULL;
		self->priv->va3 = (_tmp89_ = (_tmp88_ = gtk_scrolled_window_get_vadjustment (outgoingAsciiScrolledWindow), (_tmp88_ == NULL) ? NULL : g_object_ref (_tmp88_)), (self->priv->va3 == NULL) ? NULL : (self->priv->va3 = (g_object_unref (self->priv->va3), NULL)), _tmp89_);
		_tmp90_ = NULL;
		outgoingHexScrolledWindow = (_tmp90_ = GTK_SCROLLED_WINDOW (gtk_builder_get_object (self->priv->_builder, "outgoing_hex_scrolledwindow")), (_tmp90_ == NULL) ? NULL : g_object_ref (_tmp90_));
		_tmp92_ = NULL;
		_tmp91_ = NULL;
		self->priv->va4 = (_tmp92_ = (_tmp91_ = gtk_scrolled_window_get_vadjustment (outgoingHexScrolledWindow), (_tmp91_ == NULL) ? NULL : g_object_ref (_tmp91_)), (self->priv->va4 == NULL) ? NULL : (self->priv->va4 = (g_object_unref (self->priv->va4), NULL)), _tmp92_);
		moserial_auto_scroll_setup (self->priv->va1, self->priv->va2, self->priv->va3, self->priv->va4);
		/*setup entry*/
		_tmp94_ = NULL;
		_tmp93_ = NULL;
		self->priv->sendButton = (_tmp94_ = (_tmp93_ = GTK_BUTTON (gtk_builder_get_object (self->priv->_builder, "send")), (_tmp93_ == NULL) ? NULL : g_object_ref (_tmp93_)), (self->priv->sendButton == NULL) ? NULL : (self->priv->sendButton = (g_object_unref (self->priv->sendButton), NULL)), _tmp94_);
		g_signal_connect_object (self->priv->sendButton, "clicked", (GCallback) _moserial_main_window_sendString_gtk_button_clicked, self, 0);
		_tmp96_ = NULL;
		_tmp95_ = NULL;
		self->priv->entry = (_tmp96_ = (_tmp95_ = GTK_ENTRY (gtk_builder_get_object (self->priv->_builder, "entry")), (_tmp95_ == NULL) ? NULL : g_object_ref (_tmp95_)), (self->priv->entry == NULL) ? NULL : (self->priv->entry = (g_object_unref (self->priv->entry), NULL)), _tmp96_);
		g_signal_connect_object (self->priv->entry, "activate", (GCallback) _moserial_main_window_sendString_gtk_entry_activate, self, 0);
		_tmp98_ = NULL;
		_tmp97_ = NULL;
		self->priv->inputMode = (_tmp98_ = (_tmp97_ = GTK_COMBO_BOX (gtk_builder_get_object (self->priv->_builder, "input_mode")), (_tmp97_ == NULL) ? NULL : g_object_ref (_tmp97_)), (self->priv->inputMode == NULL) ? NULL : (self->priv->inputMode = (g_object_unref (self->priv->inputMode), NULL)), _tmp98_);
		gtk_combo_box_set_active (self->priv->inputMode, 0);
		g_signal_connect_object (self->priv->inputMode, "changed", (GCallback) _moserial_main_window_inputModeChanged_gtk_combo_box_changed, self, 0);
		_tmp100_ = NULL;
		_tmp99_ = NULL;
		self->priv->terminationMode = (_tmp100_ = (_tmp99_ = GTK_COMBO_BOX (gtk_builder_get_object (self->priv->_builder, "termination_mode")), (_tmp99_ == NULL) ? NULL : g_object_ref (_tmp99_)), (self->priv->terminationMode == NULL) ? NULL : (self->priv->terminationMode = (g_object_unref (self->priv->terminationMode), NULL)), _tmp100_);
		gtk_combo_box_set_active (self->priv->terminationMode, 0);
		/*setup recent chooser*/
		_tmp101_ = NULL;
		recentManager = (_tmp101_ = gtk_recent_manager_get_default (), (_tmp101_ == NULL) ? NULL : g_object_ref (_tmp101_));
		recentChooserMenu = g_object_ref_sink ((GtkRecentChooserMenu*) gtk_recent_chooser_menu_new_for_manager (recentManager));
		g_signal_connect_object ((GtkRecentChooser*) recentChooserMenu, "item-activated", (GCallback) _moserial_main_window_recentItemOpen_gtk_recent_chooser_item_activated, self, 0);
		filter = g_object_ref_sink (gtk_recent_filter_new ());
		gtk_recent_filter_add_application (filter, g_get_application_name ());
		gtk_recent_chooser_add_filter ((GtkRecentChooser*) recentChooserMenu, filter);
		gtk_recent_chooser_menu_set_show_numbers (recentChooserMenu, TRUE);
		/* We have to do this ugly iteration stuff because 
		   gtk-builder-convert currently turns menuitems into actions.
		   Hopefully this wont be need with new glade versions. */
		_tmp102_ = NULL;
		menuBar = (_tmp102_ = (GtkMenuShell*) GTK_MENU_BAR (gtk_builder_get_object (self->priv->_builder, "menubar")), (_tmp102_ == NULL) ? NULL : g_object_ref (_tmp102_));
		children = gtk_container_get_children ((GtkContainer*) menuBar);
		fileMenu = NULL;
		_tmp104_ = NULL;
		_tmp103_ = NULL;
		fileMenu = (_tmp104_ = (_tmp103_ = GTK_MENU_ITEM (g_list_first (children)->data), (_tmp103_ == NULL) ? NULL : g_object_ref (_tmp103_)), (fileMenu == NULL) ? NULL : (fileMenu = (g_object_unref (fileMenu), NULL)), _tmp104_);
		_tmp105_ = NULL;
		fileMenuShell = (_tmp105_ = GTK_MENU_SHELL (gtk_menu_item_get_submenu (fileMenu)), (_tmp105_ == NULL) ? NULL : g_object_ref (_tmp105_));
		_tmp106_ = NULL;
		children = (_tmp106_ = gtk_container_get_children ((GtkContainer*) fileMenuShell), (children == NULL) ? NULL : (children = (g_list_free (children), NULL)), _tmp106_);
		_tmp107_ = NULL;
		recentFileItem = (_tmp107_ = GTK_MENU_ITEM (g_list_nth (children, (guint) 2)->data), (_tmp107_ == NULL) ? NULL : g_object_ref (_tmp107_));
		gtk_menu_item_set_submenu (recentFileItem, (GtkWidget*) recentChooserMenu);
		/*load and apply preferences*/
		_tmp108_ = NULL;
		self->priv->currentPreferences = (_tmp108_ = preferences_loadFromProfile (self->priv->profile), (self->priv->currentPreferences == NULL) ? NULL : (self->priv->currentPreferences = (g_object_unref (self->priv->currentPreferences), NULL)), _tmp108_);
		moserial_main_window_updatePreferences (self, NULL, self->priv->currentPreferences);
		self->priv->profileChanged = FALSE;
		if (!(self->priv->_startupProfileFilename == NULL)) {
			moserial_main_window_loadProfileOnStartup (self, self->priv->_startupProfileFilename);
		}
		_tmp109_ = NULL;
		self->priv->currentPaths = (_tmp109_ = default_paths_loadFromProfile (self->priv->profile), (self->priv->currentPaths == NULL) ? NULL : (self->priv->currentPaths = (g_object_unref (self->priv->currentPaths), NULL)), _tmp109_);
		(quit == NULL) ? NULL : (quit = (g_object_unref (quit), NULL));
		(saveAs == NULL) ? NULL : (saveAs = (g_object_unref (saveAs), NULL));
		(save == NULL) ? NULL : (save = (g_object_unref (save), NULL));
		(open == NULL) ? NULL : (open = (g_object_unref (open), NULL));
		(editMenuItem == NULL) ? NULL : (editMenuItem = (g_object_unref (editMenuItem), NULL));
		(pasteMenuItem == NULL) ? NULL : (pasteMenuItem = (g_object_unref (pasteMenuItem), NULL));
		(clearMenuItem == NULL) ? NULL : (clearMenuItem = (g_object_unref (clearMenuItem), NULL));
		(helpButton == NULL) ? NULL : (helpButton = (g_object_unref (helpButton), NULL));
		(about == NULL) ? NULL : (about = (g_object_unref (about), NULL));
		(preferences == NULL) ? NULL : (preferences = (g_object_unref (preferences), NULL));
		(contents == NULL) ? NULL : (contents = (g_object_unref (contents), NULL));
		(incomingAsciiScrolledWindow == NULL) ? NULL : (incomingAsciiScrolledWindow = (g_object_unref (incomingAsciiScrolledWindow), NULL));
		(incomingHexScrolledWindow == NULL) ? NULL : (incomingHexScrolledWindow = (g_object_unref (incomingHexScrolledWindow), NULL));
		(outgoingAsciiScrolledWindow == NULL) ? NULL : (outgoingAsciiScrolledWindow = (g_object_unref (outgoingAsciiScrolledWindow), NULL));
		(outgoingHexScrolledWindow == NULL) ? NULL : (outgoingHexScrolledWindow = (g_object_unref (outgoingHexScrolledWindow), NULL));
		(recentManager == NULL) ? NULL : (recentManager = (g_object_unref (recentManager), NULL));
		(recentChooserMenu == NULL) ? NULL : (recentChooserMenu = (g_object_unref (recentChooserMenu), NULL));
		(filter == NULL) ? NULL : (filter = (g_object_unref (filter), NULL));
		(menuBar == NULL) ? NULL : (menuBar = (g_object_unref (menuBar), NULL));
		(children == NULL) ? NULL : (children = (g_list_free (children), NULL));
		(fileMenu == NULL) ? NULL : (fileMenu = (g_object_unref (fileMenu), NULL));
		(fileMenuShell == NULL) ? NULL : (fileMenuShell = (g_object_unref (fileMenuShell), NULL));
		(recentFileItem == NULL) ? NULL : (recentFileItem = (g_object_unref (recentFileItem), NULL));
	}
	return obj;
}


static void moserial_main_window_class_init (moserialMainWindowClass * klass) {
	moserial_main_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (moserialMainWindowPrivate));
	G_OBJECT_CLASS (klass)->get_property = moserial_main_window_get_property;
	G_OBJECT_CLASS (klass)->set_property = moserial_main_window_set_property;
	G_OBJECT_CLASS (klass)->constructor = moserial_main_window_constructor;
	G_OBJECT_CLASS (klass)->finalize = moserial_main_window_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MOSERIAL_MAIN_WINDOW_BUILDER, g_param_spec_object ("builder", "builder", "builder", GTK_TYPE_BUILDER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MOSERIAL_MAIN_WINDOW_STARTUP_PROFILE_FILENAME, g_param_spec_string ("startupProfileFilename", "startupProfileFilename", "startupProfileFilename", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void moserial_main_window_instance_init (moserialMainWindow * self) {
	self->priv = MOSERIAL_MAIN_WINDOW_GET_PRIVATE (self);
	self->priv->serialConnection = moserial_serial_connection_new ();
	self->priv->streamRecorder = moserial_serial_stream_recorder_new ();
	self->priv->recordDataReceived = FALSE;
	self->priv->recordTimeoutID = (guint) 0;
	self->priv->profileFilename = NULL;
	self->priv->profileChanged = FALSE;
}


static void moserial_main_window_finalize (GObject* obj) {
	moserialMainWindow * self;
	self = MOSERIAL_MAIN_WINDOW (obj);
	(self->priv->_builder == NULL) ? NULL : (self->priv->_builder = (g_object_unref (self->priv->_builder), NULL));
	(self->priv->gtkWindow == NULL) ? NULL : (self->priv->gtkWindow = (g_object_unref (self->priv->gtkWindow), NULL));
	(self->priv->settingsDialog == NULL) ? NULL : (self->priv->settingsDialog = (g_object_unref (self->priv->settingsDialog), NULL));
	(self->priv->settingsButton == NULL) ? NULL : (self->priv->settingsButton = (g_object_unref (self->priv->settingsButton), NULL));
	(self->priv->recordButton == NULL) ? NULL : (self->priv->recordButton = (g_object_unref (self->priv->recordButton), NULL));
	(self->priv->currentSettings == NULL) ? NULL : (self->priv->currentSettings = (g_object_unref (self->priv->currentSettings), NULL));
	(self->priv->currentPreferences == NULL) ? NULL : (self->priv->currentPreferences = (g_object_unref (self->priv->currentPreferences), NULL));
	(self->priv->currentPaths == NULL) ? NULL : (self->priv->currentPaths = (g_object_unref (self->priv->currentPaths), NULL));
	(self->priv->statusbar == NULL) ? NULL : (self->priv->statusbar = (g_object_unref (self->priv->statusbar), NULL));
	(self->priv->bytecountbar == NULL) ? NULL : (self->priv->bytecountbar = (g_object_unref (self->priv->bytecountbar), NULL));
	(self->priv->send == NULL) ? NULL : (self->priv->send = (g_object_unref (self->priv->send), NULL));
	(self->priv->sendProgressDialog == NULL) ? NULL : (self->priv->sendProgressDialog = (g_object_unref (self->priv->sendProgressDialog), NULL));
	(self->priv->sendChooserDialog == NULL) ? NULL : (self->priv->sendChooserDialog = (g_object_unref (self->priv->sendChooserDialog), NULL));
	(self->priv->receive == NULL) ? NULL : (self->priv->receive = (g_object_unref (self->priv->receive), NULL));
	(self->priv->receiveProgressDialog == NULL) ? NULL : (self->priv->receiveProgressDialog = (g_object_unref (self->priv->receiveProgressDialog), NULL));
	(self->priv->receiveChooserDialog == NULL) ? NULL : (self->priv->receiveChooserDialog = (g_object_unref (self->priv->receiveChooserDialog), NULL));
	(self->priv->recordDialog == NULL) ? NULL : (self->priv->recordDialog = (g_object_unref (self->priv->recordDialog), NULL));
	(self->priv->preferencesDialog == NULL) ? NULL : (self->priv->preferencesDialog = (g_object_unref (self->priv->preferencesDialog), NULL));
	(self->priv->serialConnection == NULL) ? NULL : (self->priv->serialConnection = (g_object_unref (self->priv->serialConnection), NULL));
	(self->priv->incomingHexTextView == NULL) ? NULL : (self->priv->incomingHexTextView = (g_object_unref (self->priv->incomingHexTextView), NULL));
	(self->priv->incomingAsciiTextView == NULL) ? NULL : (self->priv->incomingAsciiTextView = (g_object_unref (self->priv->incomingAsciiTextView), NULL));
	(self->priv->outgoingHexTextView == NULL) ? NULL : (self->priv->outgoingHexTextView = (g_object_unref (self->priv->outgoingHexTextView), NULL));
	(self->priv->outgoingAsciiTextView == NULL) ? NULL : (self->priv->outgoingAsciiTextView = (g_object_unref (self->priv->outgoingAsciiTextView), NULL));
	(self->priv->inputMode == NULL) ? NULL : (self->priv->inputMode = (g_object_unref (self->priv->inputMode), NULL));
	(self->priv->terminationMode == NULL) ? NULL : (self->priv->terminationMode = (g_object_unref (self->priv->terminationMode), NULL));
	(self->priv->connectButton == NULL) ? NULL : (self->priv->connectButton = (g_object_unref (self->priv->connectButton), NULL));
	(self->priv->disconnectLabel == NULL) ? NULL : (self->priv->disconnectLabel = (g_object_unref (self->priv->disconnectLabel), NULL));
	(self->priv->connectLabel == NULL) ? NULL : (self->priv->connectLabel = (g_object_unref (self->priv->connectLabel), NULL));
	(self->priv->recordLabel == NULL) ? NULL : (self->priv->recordLabel = (g_object_unref (self->priv->recordLabel), NULL));
	(self->priv->stopRecordingLabel == NULL) ? NULL : (self->priv->stopRecordingLabel = (g_object_unref (self->priv->stopRecordingLabel), NULL));
	(self->priv->paned == NULL) ? NULL : (self->priv->paned = (g_object_unref (self->priv->paned), NULL));
	(self->priv->incoming_notebook == NULL) ? NULL : (self->priv->incoming_notebook = (g_object_unref (self->priv->incoming_notebook), NULL));
	(self->priv->outgoing_notebook == NULL) ? NULL : (self->priv->outgoing_notebook = (g_object_unref (self->priv->outgoing_notebook), NULL));
	(self->priv->incomingHexTextBuffer == NULL) ? NULL : (self->priv->incomingHexTextBuffer = (g_object_unref (self->priv->incomingHexTextBuffer), NULL));
	(self->priv->outgoingHexTextBuffer == NULL) ? NULL : (self->priv->outgoingHexTextBuffer = (g_object_unref (self->priv->outgoingHexTextBuffer), NULL));
	(self->priv->incomingAsciiTextBuffer == NULL) ? NULL : (self->priv->incomingAsciiTextBuffer = (g_object_unref (self->priv->incomingAsciiTextBuffer), NULL));
	(self->priv->echoTag == NULL) ? NULL : (self->priv->echoTag = (g_object_unref (self->priv->echoTag), NULL));
	(self->priv->outgoingAsciiTextBuffer == NULL) ? NULL : (self->priv->outgoingAsciiTextBuffer = (g_object_unref (self->priv->outgoingAsciiTextBuffer), NULL));
	(self->priv->echoStartMark == NULL) ? NULL : (self->priv->echoStartMark = (g_object_unref (self->priv->echoStartMark), NULL));
	(self->priv->xmodemFilenameDialog == NULL) ? NULL : (self->priv->xmodemFilenameDialog = (g_object_unref (self->priv->xmodemFilenameDialog), NULL));
	(self->priv->entry == NULL) ? NULL : (self->priv->entry = (g_object_unref (self->priv->entry), NULL));
	(self->priv->sendButton == NULL) ? NULL : (self->priv->sendButton = (g_object_unref (self->priv->sendButton), NULL));
	(self->priv->streamRecorder == NULL) ? NULL : (self->priv->streamRecorder = (moserial_serial_stream_recorder_unref (self->priv->streamRecorder), NULL));
	(self->priv->rz == NULL) ? NULL : (self->priv->rz = (g_object_unref (self->priv->rz), NULL));
	(self->priv->sz == NULL) ? NULL : (self->priv->sz = (g_object_unref (self->priv->sz), NULL));
	(self->priv->profile == NULL) ? NULL : (self->priv->profile = (g_object_unref (self->priv->profile), NULL));
	self->priv->_startupProfileFilename = (g_free (self->priv->_startupProfileFilename), NULL);
	self->priv->profileFilename = (g_free (self->priv->profileFilename), NULL);
	(self->priv->cutMenuItem == NULL) ? NULL : (self->priv->cutMenuItem = (g_object_unref (self->priv->cutMenuItem), NULL));
	(self->priv->copyMenuItem == NULL) ? NULL : (self->priv->copyMenuItem = (g_object_unref (self->priv->copyMenuItem), NULL));
	(self->priv->va1 == NULL) ? NULL : (self->priv->va1 = (g_object_unref (self->priv->va1), NULL));
	(self->priv->va2 == NULL) ? NULL : (self->priv->va2 = (g_object_unref (self->priv->va2), NULL));
	(self->priv->va3 == NULL) ? NULL : (self->priv->va3 = (g_object_unref (self->priv->va3), NULL));
	(self->priv->va4 == NULL) ? NULL : (self->priv->va4 = (g_object_unref (self->priv->va4), NULL));
	G_OBJECT_CLASS (moserial_main_window_parent_class)->finalize (obj);
}


GType moserial_main_window_get_type (void) {
	static GType moserial_main_window_type_id = 0;
	if (moserial_main_window_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (moserialMainWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) moserial_main_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (moserialMainWindow), 0, (GInstanceInitFunc) moserial_main_window_instance_init, NULL };
		moserial_main_window_type_id = g_type_register_static (GTK_TYPE_WINDOW, "moserialMainWindow", &g_define_type_info, 0);
	}
	return moserial_main_window_type_id;
}


static void moserial_main_window_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	moserialMainWindow * self;
	gpointer boxed;
	self = MOSERIAL_MAIN_WINDOW (object);
	switch (property_id) {
		case MOSERIAL_MAIN_WINDOW_BUILDER:
		g_value_set_object (value, moserial_main_window_get_builder (self));
		break;
		case MOSERIAL_MAIN_WINDOW_STARTUP_PROFILE_FILENAME:
		g_value_set_string (value, moserial_main_window_get_startupProfileFilename (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void moserial_main_window_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	moserialMainWindow * self;
	self = MOSERIAL_MAIN_WINDOW (object);
	switch (property_id) {
		case MOSERIAL_MAIN_WINDOW_BUILDER:
		moserial_main_window_set_builder (self, g_value_get_object (value));
		break;
		case MOSERIAL_MAIN_WINDOW_STARTUP_PROFILE_FILENAME:
		moserial_main_window_set_startupProfileFilename (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




