
#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gstdio.h>
#include <gdk/gdk.h>


#define MOSERIAL_TYPE_SETTINGS_DIALOG (moserial_settings_dialog_get_type ())
#define MOSERIAL_SETTINGS_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MOSERIAL_TYPE_SETTINGS_DIALOG, moserialSettingsDialog))
#define MOSERIAL_SETTINGS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MOSERIAL_TYPE_SETTINGS_DIALOG, moserialSettingsDialogClass))
#define MOSERIAL_IS_SETTINGS_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MOSERIAL_TYPE_SETTINGS_DIALOG))
#define MOSERIAL_IS_SETTINGS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MOSERIAL_TYPE_SETTINGS_DIALOG))
#define MOSERIAL_SETTINGS_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MOSERIAL_TYPE_SETTINGS_DIALOG, moserialSettingsDialogClass))

typedef struct _moserialSettingsDialog moserialSettingsDialog;
typedef struct _moserialSettingsDialogClass moserialSettingsDialogClass;
typedef struct _moserialSettingsDialogPrivate moserialSettingsDialogPrivate;

#define TYPE_SETTINGS (settings_get_type ())
#define SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SETTINGS, Settings))
#define SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SETTINGS, SettingsClass))
#define IS_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SETTINGS))
#define IS_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SETTINGS))
#define SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SETTINGS, SettingsClass))

typedef struct _Settings Settings;
typedef struct _SettingsClass SettingsClass;

#define SETTINGS_TYPE_PARITY (settings_parity_get_type ())

#define SETTINGS_TYPE_ACCESS_MODE (settings_access_mode_get_type ())

#define SETTINGS_TYPE_HANDSHAKE (settings_handshake_get_type ())

struct _moserialSettingsDialog {
	GObject parent_instance;
	moserialSettingsDialogPrivate * priv;
};

struct _moserialSettingsDialogClass {
	GObjectClass parent_class;
};

struct _moserialSettingsDialogPrivate {
	GtkBuilder* _builder;
	Settings* currentSettings;
	GtkDialog* dialog;
	GtkButton* cancelButton;
	GtkButton* okButton;
	Settings* settings;
	GtkComboBoxEntry* deviceCombo;
	GtkComboBox* baudRateCombo;
	GtkComboBox* dataBitsCombo;
	GtkComboBox* stopBitsCombo;
	GtkComboBox* parityCombo;
	GtkCheckButton* hardwareHandshake;
	GtkCheckButton* softwareHandshake;
	GtkComboBox* accessModeCombo;
	GtkCheckButton* localEcho;
	GtkListStore* ls;
};

typedef enum  {
	SETTINGS_PARITY_NONE,
	SETTINGS_PARITY_ODD,
	SETTINGS_PARITY_EVEN,
	SETTINGS_PARITY_MARK,
	SETTINGS_PARITY_SPACE
} SettingsParity;

typedef enum  {
	SETTINGS_ACCESS_MODE_READWRITE,
	SETTINGS_ACCESS_MODE_READONLY,
	SETTINGS_ACCESS_MODE_WRITEONLY
} SettingsAccessMode;

typedef enum  {
	SETTINGS_HANDSHAKE_NONE,
	SETTINGS_HANDSHAKE_HARDWARE,
	SETTINGS_HANDSHAKE_SOFTWARE,
	SETTINGS_HANDSHAKE_BOTH
} SettingsHandshake;


static gpointer moserial_settings_dialog_parent_class = NULL;

GType moserial_settings_dialog_get_type (void);
GType settings_get_type (void);
#define MOSERIAL_SETTINGS_DIALOG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), MOSERIAL_TYPE_SETTINGS_DIALOG, moserialSettingsDialogPrivate))
enum  {
	MOSERIAL_SETTINGS_DIALOG_DUMMY_PROPERTY,
	MOSERIAL_SETTINGS_DIALOG_BUILDER
};
#define MOSERIAL_SETTINGS_DIALOG_max_devices 32
static void moserial_settings_dialog_set_builder (moserialSettingsDialog* self, GtkBuilder* value);
moserialSettingsDialog* moserial_settings_dialog_new (GtkBuilder* builder);
moserialSettingsDialog* moserial_settings_dialog_construct (GType object_type, GtkBuilder* builder);
static void _g_list_free_g_free (GList* self);
static void moserial_settings_dialog_populateDevices (moserialSettingsDialog* self);
void moserial_settings_dialog_loadSettings (moserialSettingsDialog* self);
void moserial_settings_dialog_show (moserialSettingsDialog* self, Settings* settings);
const char* settings_get_device (Settings* self);
gint settings_get_baudRate (Settings* self);
gint settings_get_dataBits (Settings* self);
gint settings_get_stopBits (Settings* self);
GType settings_parity_get_type (void);
SettingsParity settings_get_parity (Settings* self);
GType settings_access_mode_get_type (void);
SettingsAccessMode settings_get_accessMode (Settings* self);
GType settings_handshake_get_type (void);
SettingsHandshake settings_get_handshake (Settings* self);
gboolean settings_get_localEcho (Settings* self);
gboolean moserial_settings_dialog_hide (moserialSettingsDialog* self, GtkWidget* w, GdkEvent* event);
void moserial_settings_dialog_cancel (moserialSettingsDialog* self, GtkWidget* w);
Settings* settings_new (const char* device, gint baudRate, gint dataBits, gint stopBits, SettingsParity parity, SettingsHandshake handshake, SettingsAccessMode accessMode, gboolean localEcho);
Settings* settings_construct (GType object_type, const char* device, gint baudRate, gint dataBits, gint stopBits, SettingsParity parity, SettingsHandshake handshake, SettingsAccessMode accessMode, gboolean localEcho);
void moserial_settings_dialog_ok (moserialSettingsDialog* self, GtkWidget* w);
GtkBuilder* moserial_settings_dialog_get_builder (moserialSettingsDialog* self);
static gboolean _moserial_settings_dialog_hide_gtk_widget_delete_event (GtkDialog* _sender, GdkEvent* event, gpointer self);
static void _moserial_settings_dialog_cancel_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _moserial_settings_dialog_ok_gtk_button_clicked (GtkButton* _sender, gpointer self);
static GObject * moserial_settings_dialog_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void moserial_settings_dialog_finalize (GObject* obj);
static void moserial_settings_dialog_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void moserial_settings_dialog_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static int _vala_strcmp0 (const char * str1, const char * str2);



moserialSettingsDialog* moserial_settings_dialog_construct (GType object_type, GtkBuilder* builder) {
	GParameter * __params;
	GParameter * __params_it;
	moserialSettingsDialog * self;
	g_return_val_if_fail (builder != NULL, NULL);
	__params = g_new0 (GParameter, 1);
	__params_it = __params;
	__params_it->name = "builder";
	g_value_init (&__params_it->value, GTK_TYPE_BUILDER);
	g_value_set_object (&__params_it->value, builder);
	__params_it++;
	self = g_object_newv (object_type, __params_it - __params, __params);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


moserialSettingsDialog* moserial_settings_dialog_new (GtkBuilder* builder) {
	return moserial_settings_dialog_construct (MOSERIAL_TYPE_SETTINGS_DIALOG, builder);
}


static void _g_list_free_g_free (GList* self) {
	g_list_foreach (self, (GFunc) g_free, NULL);
	g_list_free (self);
}


static void moserial_settings_dialog_populateDevices (moserialSettingsDialog* self) {
	GList* deviceTypes;
	GtkTreeIter iter = {0};
	g_return_if_fail (self != NULL);
	deviceTypes = NULL;
	deviceTypes = g_list_append (deviceTypes, g_strdup ("/dev/ttyS"));
	deviceTypes = g_list_append (deviceTypes, g_strdup ("/dev/ttyUSB"));
	deviceTypes = g_list_append (deviceTypes, g_strdup ("/dev/rfcomm"));
	gtk_list_store_clear (self->priv->ls);
	{
		GList* devType_collection;
		GList* devType_it;
		devType_collection = deviceTypes;
		for (devType_it = devType_collection; devType_it != NULL; devType_it = devType_it->next) {
			const char* _tmp1_;
			char* devType;
			_tmp1_ = NULL;
			devType = (_tmp1_ = (const char*) devType_it->data, (_tmp1_ == NULL) ? NULL : g_strdup (_tmp1_));
			{
				{
					gint i;
					i = 0;
					{
						gboolean _tmp0_;
						_tmp0_ = TRUE;
						while (TRUE) {
							char* dev;
							if (!_tmp0_) {
								i++;
							}
							_tmp0_ = FALSE;
							if (!(i < MOSERIAL_SETTINGS_DIALOG_max_devices)) {
								break;
							}
							dev = g_strdup_printf ("%s%d", devType, i);
							if (g_file_test (dev, G_FILE_TEST_EXISTS)) {
								gtk_list_store_append (self->priv->ls, &iter);
								gtk_list_store_set (self->priv->ls, &iter, 0, "", 1, dev, -1, -1);
							}
							dev = (g_free (dev), NULL);
						}
					}
				}
				devType = (g_free (devType), NULL);
			}
		}
	}
	(deviceTypes == NULL) ? NULL : (deviceTypes = (_g_list_free_g_free (deviceTypes), NULL));
}


void moserial_settings_dialog_show (moserialSettingsDialog* self, Settings* settings) {
	Settings* _tmp1_;
	Settings* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (settings != NULL);
	moserial_settings_dialog_populateDevices (self);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	self->priv->currentSettings = (_tmp1_ = (_tmp0_ = settings, (_tmp0_ == NULL) ? NULL : g_object_ref (_tmp0_)), (self->priv->currentSettings == NULL) ? NULL : (self->priv->currentSettings = (g_object_unref (self->priv->currentSettings), NULL)), _tmp1_);
	moserial_settings_dialog_loadSettings (self);
	gtk_widget_show_all ((GtkWidget*) self->priv->dialog);
}


/* Load the current settings into the dialog*/
void moserial_settings_dialog_loadSettings (moserialSettingsDialog* self) {
	GtkTreeModel* t;
	GtkTreeIter ti = {0};
	gboolean success;
	GtkTreeModel* _tmp1_;
	GtkTreeModel* _tmp0_;
	GtkTreeModel* _tmp5_;
	GtkTreeModel* _tmp4_;
	GtkTreeModel* _tmp11_;
	GtkTreeModel* _tmp10_;
	GtkTreeModel* _tmp17_;
	GtkTreeModel* _tmp16_;
	gboolean _tmp22_;
	gboolean _tmp23_;
	g_return_if_fail (self != NULL);
	t = NULL;
	success = FALSE;
	/*Device*/
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	t = (_tmp1_ = (_tmp0_ = gtk_combo_box_get_model ((GtkComboBox*) self->priv->deviceCombo), (_tmp0_ == NULL) ? NULL : g_object_ref (_tmp0_)), (t == NULL) ? NULL : (t = (g_object_unref (t), NULL)), _tmp1_);
	success = gtk_tree_model_get_iter_first (t, &ti);
	while (TRUE) {
		GValue str_data = {0};
		GValue _tmp3_ = {0};
		GValue _tmp2_ = {0};
		if (!success) {
			break;
		}
		gtk_tree_model_get_value (t, &ti, 1, &_tmp2_);
		str_data = (_tmp3_ = _tmp2_, G_IS_VALUE (&str_data) ? (g_value_unset (&str_data), NULL) : NULL, _tmp3_);
		if (_vala_strcmp0 (g_value_get_string (&str_data), settings_get_device (self->priv->currentSettings)) == 0) {
			gtk_combo_box_set_active_iter ((GtkComboBox*) self->priv->deviceCombo, &ti);
		}
		success = gtk_tree_model_iter_next (t, &ti);
		G_IS_VALUE (&str_data) ? (g_value_unset (&str_data), NULL) : NULL;
	}
	/*Baud Rate*/
	_tmp5_ = NULL;
	_tmp4_ = NULL;
	t = (_tmp5_ = (_tmp4_ = gtk_combo_box_get_model (self->priv->baudRateCombo), (_tmp4_ == NULL) ? NULL : g_object_ref (_tmp4_)), (t == NULL) ? NULL : (t = (g_object_unref (t), NULL)), _tmp5_);
	success = gtk_tree_model_get_iter_first (t, &ti);
	while (TRUE) {
		GValue str_data = {0};
		GValue _tmp7_ = {0};
		GValue _tmp6_ = {0};
		char* _tmp8_;
		gboolean _tmp9_;
		if (!success) {
			break;
		}
		gtk_tree_model_get_value (t, &ti, 0, &_tmp6_);
		str_data = (_tmp7_ = _tmp6_, G_IS_VALUE (&str_data) ? (g_value_unset (&str_data), NULL) : NULL, _tmp7_);
		_tmp8_ = NULL;
		if ((_tmp9_ = _vala_strcmp0 (g_value_get_string (&str_data), _tmp8_ = g_strdup_printf ("%i", settings_get_baudRate (self->priv->currentSettings))) == 0, _tmp8_ = (g_free (_tmp8_), NULL), _tmp9_)) {
			gtk_combo_box_set_active_iter (self->priv->baudRateCombo, &ti);
		}
		success = gtk_tree_model_iter_next (t, &ti);
		G_IS_VALUE (&str_data) ? (g_value_unset (&str_data), NULL) : NULL;
	}
	/*Data Bits*/
	_tmp11_ = NULL;
	_tmp10_ = NULL;
	t = (_tmp11_ = (_tmp10_ = gtk_combo_box_get_model (self->priv->dataBitsCombo), (_tmp10_ == NULL) ? NULL : g_object_ref (_tmp10_)), (t == NULL) ? NULL : (t = (g_object_unref (t), NULL)), _tmp11_);
	success = gtk_tree_model_get_iter_first (t, &ti);
	while (TRUE) {
		GValue str_data = {0};
		GValue _tmp13_ = {0};
		GValue _tmp12_ = {0};
		char* _tmp14_;
		gboolean _tmp15_;
		if (!success) {
			break;
		}
		gtk_tree_model_get_value (t, &ti, 0, &_tmp12_);
		str_data = (_tmp13_ = _tmp12_, G_IS_VALUE (&str_data) ? (g_value_unset (&str_data), NULL) : NULL, _tmp13_);
		_tmp14_ = NULL;
		if ((_tmp15_ = _vala_strcmp0 (g_value_get_string (&str_data), _tmp14_ = g_strdup_printf ("%i", settings_get_dataBits (self->priv->currentSettings))) == 0, _tmp14_ = (g_free (_tmp14_), NULL), _tmp15_)) {
			gtk_combo_box_set_active_iter (self->priv->dataBitsCombo, &ti);
		}
		success = gtk_tree_model_iter_next (t, &ti);
		G_IS_VALUE (&str_data) ? (g_value_unset (&str_data), NULL) : NULL;
	}
	/*Stop Bits*/
	_tmp17_ = NULL;
	_tmp16_ = NULL;
	t = (_tmp17_ = (_tmp16_ = gtk_combo_box_get_model (self->priv->stopBitsCombo), (_tmp16_ == NULL) ? NULL : g_object_ref (_tmp16_)), (t == NULL) ? NULL : (t = (g_object_unref (t), NULL)), _tmp17_);
	success = gtk_tree_model_get_iter_first (t, &ti);
	while (TRUE) {
		GValue str_data = {0};
		GValue _tmp19_ = {0};
		GValue _tmp18_ = {0};
		char* _tmp20_;
		gboolean _tmp21_;
		if (!success) {
			break;
		}
		gtk_tree_model_get_value (t, &ti, 0, &_tmp18_);
		str_data = (_tmp19_ = _tmp18_, G_IS_VALUE (&str_data) ? (g_value_unset (&str_data), NULL) : NULL, _tmp19_);
		_tmp20_ = NULL;
		if ((_tmp21_ = _vala_strcmp0 (g_value_get_string (&str_data), _tmp20_ = g_strdup_printf ("%i", settings_get_stopBits (self->priv->currentSettings))) == 0, _tmp20_ = (g_free (_tmp20_), NULL), _tmp21_)) {
			gtk_combo_box_set_active_iter (self->priv->stopBitsCombo, &ti);
		}
		success = gtk_tree_model_iter_next (t, &ti);
		G_IS_VALUE (&str_data) ? (g_value_unset (&str_data), NULL) : NULL;
	}
	gtk_combo_box_set_active (self->priv->parityCombo, (gint) settings_get_parity (self->priv->currentSettings));
	gtk_combo_box_set_active (self->priv->accessModeCombo, (gint) settings_get_accessMode (self->priv->currentSettings));
	gtk_toggle_button_set_active ((GtkToggleButton*) self->priv->hardwareHandshake, FALSE);
	gtk_toggle_button_set_active ((GtkToggleButton*) self->priv->softwareHandshake, FALSE);
	_tmp22_ = FALSE;
	if (settings_get_handshake (self->priv->currentSettings) == SETTINGS_HANDSHAKE_BOTH) {
		_tmp22_ = TRUE;
	} else {
		_tmp22_ = settings_get_handshake (self->priv->currentSettings) == SETTINGS_HANDSHAKE_HARDWARE;
	}
	if (_tmp22_) {
		gtk_toggle_button_set_active ((GtkToggleButton*) self->priv->hardwareHandshake, TRUE);
	}
	_tmp23_ = FALSE;
	if (settings_get_handshake (self->priv->currentSettings) == SETTINGS_HANDSHAKE_BOTH) {
		_tmp23_ = TRUE;
	} else {
		_tmp23_ = settings_get_handshake (self->priv->currentSettings) == SETTINGS_HANDSHAKE_SOFTWARE;
	}
	if (_tmp23_) {
		gtk_toggle_button_set_active ((GtkToggleButton*) self->priv->softwareHandshake, TRUE);
	}
	if (settings_get_localEcho (self->priv->currentSettings)) {
		gtk_toggle_button_set_active ((GtkToggleButton*) self->priv->localEcho, TRUE);
	} else {
		gtk_toggle_button_set_active ((GtkToggleButton*) self->priv->localEcho, FALSE);
	}
	(t == NULL) ? NULL : (t = (g_object_unref (t), NULL));
}


gboolean moserial_settings_dialog_hide (moserialSettingsDialog* self, GtkWidget* w, GdkEvent* event) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (w != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	gtk_widget_hide_all ((GtkWidget*) self->priv->dialog);
	result = TRUE;
	return result;
}


void moserial_settings_dialog_cancel (moserialSettingsDialog* self, GtkWidget* w) {
	Settings* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (w != NULL);
	_tmp0_ = NULL;
	self->priv->currentSettings = (_tmp0_ = NULL, (self->priv->currentSettings == NULL) ? NULL : (self->priv->currentSettings = (g_object_unref (self->priv->currentSettings), NULL)), _tmp0_);
	gtk_widget_hide_all ((GtkWidget*) self->priv->dialog);
}


void moserial_settings_dialog_ok (moserialSettingsDialog* self, GtkWidget* w) {
	char* device;
	gint baudRate;
	gint dataBits;
	gint stopBits;
	SettingsParity parity;
	SettingsHandshake handshake;
	SettingsAccessMode accessMode;
	gboolean pLocalEcho;
	char* _tmp1_;
	const char* _tmp0_;
	gboolean _tmp2_;
	Settings* _tmp3_;
	Settings* _tmp5_;
	Settings* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (w != NULL);
	device = NULL;
	baudRate = 0;
	dataBits = 0;
	stopBits = 0;
	parity = 0;
	handshake = 0;
	accessMode = 0;
	pLocalEcho = FALSE;
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	device = (_tmp1_ = (_tmp0_ = gtk_combo_box_get_active_text ((GtkComboBox*) self->priv->deviceCombo), (_tmp0_ == NULL) ? NULL : g_strdup (_tmp0_)), device = (g_free (device), NULL), _tmp1_);
	baudRate = atoi (gtk_combo_box_get_active_text (self->priv->baudRateCombo));
	dataBits = atoi (gtk_combo_box_get_active_text (self->priv->dataBitsCombo));
	stopBits = atoi (gtk_combo_box_get_active_text (self->priv->stopBitsCombo));
	/* Glade choices must be in same order as Settings enums */
	parity = (SettingsParity) gtk_combo_box_get_active (self->priv->parityCombo);
	accessMode = (SettingsAccessMode) gtk_combo_box_get_active (self->priv->accessModeCombo);
	_tmp2_ = FALSE;
	if (gtk_toggle_button_get_active ((GtkToggleButton*) self->priv->hardwareHandshake)) {
		_tmp2_ = gtk_toggle_button_get_active ((GtkToggleButton*) self->priv->softwareHandshake);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		handshake = SETTINGS_HANDSHAKE_BOTH;
	} else {
		if (gtk_toggle_button_get_active ((GtkToggleButton*) self->priv->hardwareHandshake)) {
			handshake = SETTINGS_HANDSHAKE_HARDWARE;
		} else {
			if (gtk_toggle_button_get_active ((GtkToggleButton*) self->priv->softwareHandshake)) {
				handshake = SETTINGS_HANDSHAKE_SOFTWARE;
			} else {
				handshake = SETTINGS_HANDSHAKE_NONE;
			}
		}
	}
	pLocalEcho = gtk_toggle_button_get_active ((GtkToggleButton*) self->priv->localEcho);
	_tmp3_ = NULL;
	self->priv->settings = (_tmp3_ = settings_new (device, baudRate, dataBits, stopBits, parity, handshake, accessMode, pLocalEcho), (self->priv->settings == NULL) ? NULL : (self->priv->settings = (g_object_unref (self->priv->settings), NULL)), _tmp3_);
	_tmp5_ = NULL;
	_tmp4_ = NULL;
	self->priv->currentSettings = (_tmp5_ = (_tmp4_ = self->priv->settings, (_tmp4_ == NULL) ? NULL : g_object_ref (_tmp4_)), (self->priv->currentSettings == NULL) ? NULL : (self->priv->currentSettings = (g_object_unref (self->priv->currentSettings), NULL)), _tmp5_);
	g_signal_emit_by_name (self, "update-settings", self->priv->currentSettings);
	gtk_widget_hide_all ((GtkWidget*) self->priv->dialog);
	device = (g_free (device), NULL);
}


GtkBuilder* moserial_settings_dialog_get_builder (moserialSettingsDialog* self) {
	GtkBuilder* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_builder;
	return result;
}


static void moserial_settings_dialog_set_builder (moserialSettingsDialog* self, GtkBuilder* value) {
	GtkBuilder* _tmp1_;
	GtkBuilder* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	self->priv->_builder = (_tmp1_ = (_tmp0_ = value, (_tmp0_ == NULL) ? NULL : g_object_ref (_tmp0_)), (self->priv->_builder == NULL) ? NULL : (self->priv->_builder = (g_object_unref (self->priv->_builder), NULL)), _tmp1_);
	g_object_notify ((GObject *) self, "builder");
}


static gboolean _moserial_settings_dialog_hide_gtk_widget_delete_event (GtkDialog* _sender, GdkEvent* event, gpointer self) {
	return moserial_settings_dialog_hide (self, _sender, event);
}


static void _moserial_settings_dialog_cancel_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	moserial_settings_dialog_cancel (self, _sender);
}


static void _moserial_settings_dialog_ok_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	moserial_settings_dialog_ok (self, _sender);
}


static GObject * moserial_settings_dialog_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	moserialSettingsDialogClass * klass;
	GObjectClass * parent_class;
	moserialSettingsDialog * self;
	klass = MOSERIAL_SETTINGS_DIALOG_CLASS (g_type_class_peek (MOSERIAL_TYPE_SETTINGS_DIALOG));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = MOSERIAL_SETTINGS_DIALOG (obj);
	{
		GtkDialog* _tmp1_;
		GtkDialog* _tmp0_;
		GtkButton* _tmp3_;
		GtkButton* _tmp2_;
		GtkButton* _tmp5_;
		GtkButton* _tmp4_;
		GtkComboBox* _tmp7_;
		GtkComboBox* _tmp6_;
		GtkComboBox* _tmp9_;
		GtkComboBox* _tmp8_;
		GtkComboBox* _tmp11_;
		GtkComboBox* _tmp10_;
		GtkComboBox* _tmp13_;
		GtkComboBox* _tmp12_;
		GtkCheckButton* _tmp15_;
		GtkCheckButton* _tmp14_;
		GtkCheckButton* _tmp17_;
		GtkCheckButton* _tmp16_;
		GtkComboBox* _tmp19_;
		GtkComboBox* _tmp18_;
		GtkCheckButton* _tmp21_;
		GtkCheckButton* _tmp20_;
		GtkListStore* _tmp22_;
		GtkComboBoxEntry* _tmp24_;
		GtkComboBoxEntry* _tmp23_;
		_tmp1_ = NULL;
		_tmp0_ = NULL;
		self->priv->dialog = (_tmp1_ = (_tmp0_ = GTK_DIALOG (gtk_builder_get_object (self->priv->_builder, "settings_dialog")), (_tmp0_ == NULL) ? NULL : g_object_ref (_tmp0_)), (self->priv->dialog == NULL) ? NULL : (self->priv->dialog = (g_object_unref (self->priv->dialog), NULL)), _tmp1_);
		_tmp3_ = NULL;
		_tmp2_ = NULL;
		self->priv->cancelButton = (_tmp3_ = (_tmp2_ = GTK_BUTTON (gtk_builder_get_object (self->priv->_builder, "settings_cancel_button")), (_tmp2_ == NULL) ? NULL : g_object_ref (_tmp2_)), (self->priv->cancelButton == NULL) ? NULL : (self->priv->cancelButton = (g_object_unref (self->priv->cancelButton), NULL)), _tmp3_);
		_tmp5_ = NULL;
		_tmp4_ = NULL;
		self->priv->okButton = (_tmp5_ = (_tmp4_ = GTK_BUTTON (gtk_builder_get_object (self->priv->_builder, "settings_ok_button")), (_tmp4_ == NULL) ? NULL : g_object_ref (_tmp4_)), (self->priv->okButton == NULL) ? NULL : (self->priv->okButton = (g_object_unref (self->priv->okButton), NULL)), _tmp5_);
		_tmp7_ = NULL;
		_tmp6_ = NULL;
		self->priv->baudRateCombo = (_tmp7_ = (_tmp6_ = GTK_COMBO_BOX (gtk_builder_get_object (self->priv->_builder, "settings_baud_rate")), (_tmp6_ == NULL) ? NULL : g_object_ref (_tmp6_)), (self->priv->baudRateCombo == NULL) ? NULL : (self->priv->baudRateCombo = (g_object_unref (self->priv->baudRateCombo), NULL)), _tmp7_);
		_tmp9_ = NULL;
		_tmp8_ = NULL;
		self->priv->dataBitsCombo = (_tmp9_ = (_tmp8_ = GTK_COMBO_BOX (gtk_builder_get_object (self->priv->_builder, "settings_data_bits")), (_tmp8_ == NULL) ? NULL : g_object_ref (_tmp8_)), (self->priv->dataBitsCombo == NULL) ? NULL : (self->priv->dataBitsCombo = (g_object_unref (self->priv->dataBitsCombo), NULL)), _tmp9_);
		_tmp11_ = NULL;
		_tmp10_ = NULL;
		self->priv->stopBitsCombo = (_tmp11_ = (_tmp10_ = GTK_COMBO_BOX (gtk_builder_get_object (self->priv->_builder, "settings_stop_bits")), (_tmp10_ == NULL) ? NULL : g_object_ref (_tmp10_)), (self->priv->stopBitsCombo == NULL) ? NULL : (self->priv->stopBitsCombo = (g_object_unref (self->priv->stopBitsCombo), NULL)), _tmp11_);
		_tmp13_ = NULL;
		_tmp12_ = NULL;
		self->priv->parityCombo = (_tmp13_ = (_tmp12_ = GTK_COMBO_BOX (gtk_builder_get_object (self->priv->_builder, "settings_parity")), (_tmp12_ == NULL) ? NULL : g_object_ref (_tmp12_)), (self->priv->parityCombo == NULL) ? NULL : (self->priv->parityCombo = (g_object_unref (self->priv->parityCombo), NULL)), _tmp13_);
		_tmp15_ = NULL;
		_tmp14_ = NULL;
		self->priv->hardwareHandshake = (_tmp15_ = (_tmp14_ = GTK_CHECK_BUTTON (gtk_builder_get_object (self->priv->_builder, "settings_hardware_handshake")), (_tmp14_ == NULL) ? NULL : g_object_ref (_tmp14_)), (self->priv->hardwareHandshake == NULL) ? NULL : (self->priv->hardwareHandshake = (g_object_unref (self->priv->hardwareHandshake), NULL)), _tmp15_);
		_tmp17_ = NULL;
		_tmp16_ = NULL;
		self->priv->softwareHandshake = (_tmp17_ = (_tmp16_ = GTK_CHECK_BUTTON (gtk_builder_get_object (self->priv->_builder, "settings_software_handshake")), (_tmp16_ == NULL) ? NULL : g_object_ref (_tmp16_)), (self->priv->softwareHandshake == NULL) ? NULL : (self->priv->softwareHandshake = (g_object_unref (self->priv->softwareHandshake), NULL)), _tmp17_);
		_tmp19_ = NULL;
		_tmp18_ = NULL;
		self->priv->accessModeCombo = (_tmp19_ = (_tmp18_ = GTK_COMBO_BOX (gtk_builder_get_object (self->priv->_builder, "settings_open_for")), (_tmp18_ == NULL) ? NULL : g_object_ref (_tmp18_)), (self->priv->accessModeCombo == NULL) ? NULL : (self->priv->accessModeCombo = (g_object_unref (self->priv->accessModeCombo), NULL)), _tmp19_);
		_tmp21_ = NULL;
		_tmp20_ = NULL;
		self->priv->localEcho = (_tmp21_ = (_tmp20_ = GTK_CHECK_BUTTON (gtk_builder_get_object (self->priv->_builder, "settings_local_echo")), (_tmp20_ == NULL) ? NULL : g_object_ref (_tmp20_)), (self->priv->localEcho == NULL) ? NULL : (self->priv->localEcho = (g_object_unref (self->priv->localEcho), NULL)), _tmp21_);
		g_signal_connect_object ((GtkWidget*) self->priv->dialog, "delete-event", (GCallback) _moserial_settings_dialog_hide_gtk_widget_delete_event, self, 0);
		g_signal_connect_object (self->priv->cancelButton, "clicked", (GCallback) _moserial_settings_dialog_cancel_gtk_button_clicked, self, 0);
		g_signal_connect_object (self->priv->okButton, "clicked", (GCallback) _moserial_settings_dialog_ok_gtk_button_clicked, self, 0);
		_tmp22_ = NULL;
		self->priv->ls = (_tmp22_ = gtk_list_store_new (2, G_TYPE_STRING, G_TYPE_STRING, NULL), (self->priv->ls == NULL) ? NULL : (self->priv->ls = (g_object_unref (self->priv->ls), NULL)), _tmp22_);
		_tmp24_ = NULL;
		_tmp23_ = NULL;
		self->priv->deviceCombo = (_tmp24_ = (_tmp23_ = GTK_COMBO_BOX_ENTRY (gtk_builder_get_object (self->priv->_builder, "settings_device")), (_tmp23_ == NULL) ? NULL : g_object_ref (_tmp23_)), (self->priv->deviceCombo == NULL) ? NULL : (self->priv->deviceCombo = (g_object_unref (self->priv->deviceCombo), NULL)), _tmp24_);
		gtk_combo_box_set_model ((GtkComboBox*) self->priv->deviceCombo, (GtkTreeModel*) self->priv->ls);
		gtk_combo_box_entry_set_text_column (self->priv->deviceCombo, 1);
	}
	return obj;
}


static void moserial_settings_dialog_class_init (moserialSettingsDialogClass * klass) {
	moserial_settings_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (moserialSettingsDialogPrivate));
	G_OBJECT_CLASS (klass)->get_property = moserial_settings_dialog_get_property;
	G_OBJECT_CLASS (klass)->set_property = moserial_settings_dialog_set_property;
	G_OBJECT_CLASS (klass)->constructor = moserial_settings_dialog_constructor;
	G_OBJECT_CLASS (klass)->finalize = moserial_settings_dialog_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MOSERIAL_SETTINGS_DIALOG_BUILDER, g_param_spec_object ("builder", "builder", "builder", GTK_TYPE_BUILDER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_signal_new ("update_settings", MOSERIAL_TYPE_SETTINGS_DIALOG, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, TYPE_SETTINGS);
}


static void moserial_settings_dialog_instance_init (moserialSettingsDialog * self) {
	self->priv = MOSERIAL_SETTINGS_DIALOG_GET_PRIVATE (self);
}


static void moserial_settings_dialog_finalize (GObject* obj) {
	moserialSettingsDialog * self;
	self = MOSERIAL_SETTINGS_DIALOG (obj);
	(self->priv->_builder == NULL) ? NULL : (self->priv->_builder = (g_object_unref (self->priv->_builder), NULL));
	(self->priv->currentSettings == NULL) ? NULL : (self->priv->currentSettings = (g_object_unref (self->priv->currentSettings), NULL));
	(self->priv->dialog == NULL) ? NULL : (self->priv->dialog = (g_object_unref (self->priv->dialog), NULL));
	(self->priv->cancelButton == NULL) ? NULL : (self->priv->cancelButton = (g_object_unref (self->priv->cancelButton), NULL));
	(self->priv->okButton == NULL) ? NULL : (self->priv->okButton = (g_object_unref (self->priv->okButton), NULL));
	(self->priv->settings == NULL) ? NULL : (self->priv->settings = (g_object_unref (self->priv->settings), NULL));
	(self->priv->deviceCombo == NULL) ? NULL : (self->priv->deviceCombo = (g_object_unref (self->priv->deviceCombo), NULL));
	(self->priv->baudRateCombo == NULL) ? NULL : (self->priv->baudRateCombo = (g_object_unref (self->priv->baudRateCombo), NULL));
	(self->priv->dataBitsCombo == NULL) ? NULL : (self->priv->dataBitsCombo = (g_object_unref (self->priv->dataBitsCombo), NULL));
	(self->priv->stopBitsCombo == NULL) ? NULL : (self->priv->stopBitsCombo = (g_object_unref (self->priv->stopBitsCombo), NULL));
	(self->priv->parityCombo == NULL) ? NULL : (self->priv->parityCombo = (g_object_unref (self->priv->parityCombo), NULL));
	(self->priv->hardwareHandshake == NULL) ? NULL : (self->priv->hardwareHandshake = (g_object_unref (self->priv->hardwareHandshake), NULL));
	(self->priv->softwareHandshake == NULL) ? NULL : (self->priv->softwareHandshake = (g_object_unref (self->priv->softwareHandshake), NULL));
	(self->priv->accessModeCombo == NULL) ? NULL : (self->priv->accessModeCombo = (g_object_unref (self->priv->accessModeCombo), NULL));
	(self->priv->localEcho == NULL) ? NULL : (self->priv->localEcho = (g_object_unref (self->priv->localEcho), NULL));
	(self->priv->ls == NULL) ? NULL : (self->priv->ls = (g_object_unref (self->priv->ls), NULL));
	G_OBJECT_CLASS (moserial_settings_dialog_parent_class)->finalize (obj);
}


GType moserial_settings_dialog_get_type (void) {
	static GType moserial_settings_dialog_type_id = 0;
	if (moserial_settings_dialog_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (moserialSettingsDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) moserial_settings_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (moserialSettingsDialog), 0, (GInstanceInitFunc) moserial_settings_dialog_instance_init, NULL };
		moserial_settings_dialog_type_id = g_type_register_static (G_TYPE_OBJECT, "moserialSettingsDialog", &g_define_type_info, 0);
	}
	return moserial_settings_dialog_type_id;
}


static void moserial_settings_dialog_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	moserialSettingsDialog * self;
	gpointer boxed;
	self = MOSERIAL_SETTINGS_DIALOG (object);
	switch (property_id) {
		case MOSERIAL_SETTINGS_DIALOG_BUILDER:
		g_value_set_object (value, moserial_settings_dialog_get_builder (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void moserial_settings_dialog_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	moserialSettingsDialog * self;
	self = MOSERIAL_SETTINGS_DIALOG (object);
	switch (property_id) {
		case MOSERIAL_SETTINGS_DIALOG_BUILDER:
		moserial_settings_dialog_set_builder (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




