/* MoUtils.c generated by valac, the Vala compiler
 * generated from MoUtils.vala, do not modify */

/*
 *  Copyright (C) 2009-2010 Michael J. Chudobiak.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Street #330, Boston, MA 02111-1307, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <stdio.h>


#define TYPE_MO_UTILS (mo_utils_get_type ())
#define MO_UTILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MO_UTILS, MoUtils))
#define MO_UTILS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MO_UTILS, MoUtilsClass))
#define IS_MO_UTILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MO_UTILS))
#define IS_MO_UTILS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MO_UTILS))
#define MO_UTILS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MO_UTILS, MoUtilsClass))

typedef struct _MoUtils MoUtils;
typedef struct _MoUtilsClass MoUtilsClass;
typedef struct _MoUtilsPrivate MoUtilsPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_PROFILE (profile_get_type ())
#define PROFILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROFILE, Profile))
#define PROFILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROFILE, ProfileClass))
#define IS_PROFILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROFILE))
#define IS_PROFILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROFILE))
#define PROFILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROFILE, ProfileClass))

typedef struct _Profile Profile;
typedef struct _ProfileClass ProfileClass;
typedef struct _ProfilePrivate ProfilePrivate;

struct _MoUtils {
	GObject parent_instance;
	MoUtilsPrivate * priv;
};

struct _MoUtilsClass {
	GObjectClass parent_class;
};

struct _Profile {
	GObject parent_instance;
	ProfilePrivate * priv;
	GKeyFile* keyFile;
};

struct _ProfileClass {
	GObjectClass parent_class;
};


static gpointer mo_utils_parent_class = NULL;

GType mo_utils_get_type (void);
enum  {
	MO_UTILS_DUMMY_PROPERTY
};
GFile* mo_utils_newFile (const char* path);
gboolean mo_utils_fileExists (const char* path);
gint64 mo_utils_fileSize (const char* path);
char* mo_utils_getParentFolder (const char* path);
GType profile_get_type (void);
char* mo_utils_getKeyString (Profile* profile, const char* group, const char* key);
gint mo_utils_getKeyInteger (Profile* profile, const char* group, const char* key, gint default_val);
gboolean mo_utils_getKeyBoolean (Profile* profile, const char* group, const char* key, gboolean default_val);
char* input_parser_statusReplace (const char* oldString);
char* mo_utils_getLastMessage (const char* messages);
MoUtils* mo_utils_new (void);
MoUtils* mo_utils_construct (GType object_type);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);



static gboolean string_contains (const char* self, const char* needle) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	result = strstr (self, needle) != NULL;
	return result;
}


GFile* mo_utils_newFile (const char* path) {
	GFile* result;
	char* uri;
	g_return_val_if_fail (path != NULL, NULL);
	uri = NULL;
	if (string_contains (path, "://")) {
		char* _tmp0_;
		uri = (_tmp0_ = g_strdup (path), _g_free0 (uri), _tmp0_);
	} else {
		char* _tmp1_;
		uri = (_tmp1_ = g_strdup_printf ("file://%s", path), _g_free0 (uri), _tmp1_);
	}
	result = g_file_new_for_uri (uri);
	_g_free0 (uri);
	return result;
}


gboolean mo_utils_fileExists (const char* path) {
	gboolean result;
	GFile* file;
	g_return_val_if_fail (path != NULL, FALSE);
	file = mo_utils_newFile (path);
	result = g_file_query_exists (file, NULL);
	_g_object_unref0 (file);
	return result;
}


gint64 mo_utils_fileSize (const char* path) {
	gint64 result;
	GError * _inner_error_;
	GFile* file;
	g_return_val_if_fail (path != NULL, 0LL);
	_inner_error_ = NULL;
	file = mo_utils_newFile (path);
	{
		GFileInfo* info;
		info = g_file_query_info (file, G_FILE_ATTRIBUTE_STANDARD_SIZE, 0, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch28_g_error;
			goto __finally28;
		}
		result = g_file_info_get_size (info);
		_g_object_unref0 (info);
		_g_object_unref0 (file);
		return result;
	}
	goto __finally28;
	__catch28_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("MoUtils.vala:42: %s", e->message);
			_g_error_free0 (e);
		}
	}
	__finally28:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0LL;
	}
	result = (gint64) 0;
	_g_object_unref0 (file);
	return result;
}


char* mo_utils_getParentFolder (const char* path) {
	char* result;
	GFile* file;
	GFile* parent;
	g_return_val_if_fail (path != NULL, NULL);
	file = mo_utils_newFile (path);
	parent = g_file_get_parent (file);
	result = g_file_get_parse_name (parent);
	_g_object_unref0 (file);
	_g_object_unref0 (parent);
	return result;
}


char* mo_utils_getKeyString (Profile* profile, const char* group, const char* key) {
	char* result;
	GError * _inner_error_;
	char* _result_;
	g_return_val_if_fail (profile != NULL, NULL);
	g_return_val_if_fail (group != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	_inner_error_ = NULL;
	_result_ = NULL;
	{
		char* _tmp0_;
		char* _tmp1_;
		_tmp0_ = g_key_file_get_string (profile->keyFile, group, key, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch29_g_key_file_error;
			}
			goto __finally29;
		}
		_result_ = (_tmp1_ = _tmp0_, _g_free0 (_result_), _tmp1_);
	}
	goto __finally29;
	__catch29_g_key_file_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			fprintf (stdout, "%s\n", e->message);
			_g_error_free0 (e);
		}
	}
	__finally29:
	if (_inner_error_ != NULL) {
		_g_free0 (_result_);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = _result_;
	return result;
}


gint mo_utils_getKeyInteger (Profile* profile, const char* group, const char* key, gint default_val) {
	gint result;
	GError * _inner_error_;
	gint _result_;
	g_return_val_if_fail (profile != NULL, 0);
	g_return_val_if_fail (group != NULL, 0);
	g_return_val_if_fail (key != NULL, 0);
	_inner_error_ = NULL;
	_result_ = default_val;
	{
		gint _tmp0_;
		_tmp0_ = g_key_file_get_integer (profile->keyFile, group, key, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch30_g_key_file_error;
			}
			goto __finally30;
		}
		_result_ = _tmp0_;
	}
	goto __finally30;
	__catch30_g_key_file_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			fprintf (stdout, "%s\n", e->message);
			_g_error_free0 (e);
		}
	}
	__finally30:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	result = _result_;
	return result;
}


gboolean mo_utils_getKeyBoolean (Profile* profile, const char* group, const char* key, gboolean default_val) {
	gboolean result;
	GError * _inner_error_;
	gboolean _result_;
	g_return_val_if_fail (profile != NULL, FALSE);
	g_return_val_if_fail (group != NULL, FALSE);
	g_return_val_if_fail (key != NULL, FALSE);
	_inner_error_ = NULL;
	_result_ = default_val;
	{
		gboolean _tmp0_;
		_tmp0_ = g_key_file_get_boolean (profile->keyFile, group, key, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch31_g_key_file_error;
			}
			goto __finally31;
		}
		_result_ = _tmp0_;
	}
	goto __finally31;
	__catch31_g_key_file_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			fprintf (stdout, "%s\n", e->message);
			_g_error_free0 (e);
		}
	}
	__finally31:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = _result_;
	return result;
}


static glong string_get_length (const char* self) {
	glong result;
	g_return_val_if_fail (self != NULL, 0L);
	result = g_utf8_strlen (self, -1);
	return result;
}


char* mo_utils_getLastMessage (const char* messages) {
	char* result;
	char* message;
	char* escaped;
	char* _tmp0_;
	gint splitMessages_size;
	gint splitMessages_length1;
	char** splitMessages;
	char** _tmp2_;
	char** _tmp1_;
	message = NULL;
	escaped = g_strescape (messages, "");
	escaped = (_tmp0_ = input_parser_statusReplace (escaped), _g_free0 (escaped), _tmp0_);
	splitMessages = (splitMessages_length1 = 0, NULL);
	splitMessages = (_tmp2_ = _tmp1_ = g_strsplit (escaped, "\\n", 20), splitMessages = (_vala_array_free (splitMessages, splitMessages_length1, (GDestroyNotify) g_free), NULL), splitMessages_length1 = _vala_array_length (_tmp1_), splitMessages_size = splitMessages_length1, _tmp2_);
	{
		gint x;
		x = 0;
		{
			gboolean _tmp3_;
			_tmp3_ = TRUE;
			while (TRUE) {
				if (!_tmp3_) {
					x++;
				}
				_tmp3_ = FALSE;
				if (!(x < g_strv_length (splitMessages))) {
					break;
				}
				if (string_get_length (splitMessages[x]) > 5) {
					char* _tmp4_;
					message = (_tmp4_ = g_strdup (splitMessages[x]), _g_free0 (message), _tmp4_);
				}
			}
		}
	}
	result = message;
	_g_free0 (escaped);
	splitMessages = (_vala_array_free (splitMessages, splitMessages_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


MoUtils* mo_utils_construct (GType object_type) {
	MoUtils * self;
	self = (MoUtils*) g_object_new (object_type, NULL);
	return self;
}


MoUtils* mo_utils_new (void) {
	return mo_utils_construct (TYPE_MO_UTILS);
}


static void mo_utils_class_init (MoUtilsClass * klass) {
	mo_utils_parent_class = g_type_class_peek_parent (klass);
}


static void mo_utils_instance_init (MoUtils * self) {
}


GType mo_utils_get_type (void) {
	static GType mo_utils_type_id = 0;
	if (mo_utils_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (MoUtilsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) mo_utils_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MoUtils), 0, (GInstanceInitFunc) mo_utils_instance_init, NULL };
		mo_utils_type_id = g_type_register_static (G_TYPE_OBJECT, "MoUtils", &g_define_type_info, 0);
	}
	return mo_utils_type_id;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}




