/* Settings.c generated by valac, the Vala compiler
 * generated from Settings.vala, do not modify */

/*
 *  Copyright (C) 2009-2010 Michael J. Chudobiak.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Street #330, Boston, MA 02111-1307, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>


#define TYPE_SETTINGS (settings_get_type ())
#define SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SETTINGS, Settings))
#define SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SETTINGS, SettingsClass))
#define IS_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SETTINGS))
#define IS_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SETTINGS))
#define SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SETTINGS, SettingsClass))

typedef struct _Settings Settings;
typedef struct _SettingsClass SettingsClass;
typedef struct _SettingsPrivate SettingsPrivate;

#define SETTINGS_TYPE_PARITY (settings_parity_get_type ())

#define SETTINGS_TYPE_HANDSHAKE (settings_handshake_get_type ())

#define SETTINGS_TYPE_ACCESS_MODE (settings_access_mode_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_PROFILE (profile_get_type ())
#define PROFILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROFILE, Profile))
#define PROFILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROFILE, ProfileClass))
#define IS_PROFILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROFILE))
#define IS_PROFILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROFILE))
#define PROFILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROFILE, ProfileClass))

typedef struct _Profile Profile;
typedef struct _ProfileClass ProfileClass;
typedef struct _ProfilePrivate ProfilePrivate;

struct _Settings {
	GObject parent_instance;
	SettingsPrivate * priv;
};

struct _SettingsClass {
	GObjectClass parent_class;
};

typedef enum  {
	SETTINGS_PARITY_NONE,
	SETTINGS_PARITY_ODD,
	SETTINGS_PARITY_EVEN,
	SETTINGS_PARITY_MARK,
	SETTINGS_PARITY_SPACE
} SettingsParity;

typedef enum  {
	SETTINGS_HANDSHAKE_NONE,
	SETTINGS_HANDSHAKE_HARDWARE,
	SETTINGS_HANDSHAKE_SOFTWARE,
	SETTINGS_HANDSHAKE_BOTH
} SettingsHandshake;

typedef enum  {
	SETTINGS_ACCESS_MODE_READWRITE,
	SETTINGS_ACCESS_MODE_READONLY,
	SETTINGS_ACCESS_MODE_WRITEONLY
} SettingsAccessMode;

struct _SettingsPrivate {
	char* _device;
	gint _baudRate;
	gint _dataBits;
	gint _stopBits;
	SettingsParity _parity;
	SettingsHandshake _handshake;
	SettingsAccessMode _accessMode;
	gboolean _localEcho;
};

struct _Profile {
	GObject parent_instance;
	ProfilePrivate * priv;
	GKeyFile* keyFile;
};

struct _ProfileClass {
	GObjectClass parent_class;
};


extern char* settings_DEFAULT_DEVICEFILE;
char* settings_DEFAULT_DEVICEFILE = NULL;
extern gint settings_DEFAULT_BAUDRATE;
gint settings_DEFAULT_BAUDRATE = 1200;
extern gint settings_DEFAULT_DATABITS;
gint settings_DEFAULT_DATABITS = 8;
extern gint settings_DEFAULT_STOPBITS;
gint settings_DEFAULT_STOPBITS = 1;
extern SettingsParity settings_DEFAULT_PARITY;
SettingsParity settings_DEFAULT_PARITY = SETTINGS_PARITY_NONE;
extern SettingsHandshake settings_DEFAULT_HANDSHAKE;
SettingsHandshake settings_DEFAULT_HANDSHAKE = SETTINGS_HANDSHAKE_HARDWARE;
extern SettingsAccessMode settings_DEFAULT_ACCESSMODE;
SettingsAccessMode settings_DEFAULT_ACCESSMODE = SETTINGS_ACCESS_MODE_READWRITE;
extern gboolean settings_DEFAULT_LOCAL_ECHO;
gboolean settings_DEFAULT_LOCAL_ECHO = FALSE;
static gpointer settings_parent_class = NULL;

GType settings_get_type (void);
GType settings_parity_get_type (void);
GType settings_handshake_get_type (void);
GType settings_access_mode_get_type (void);
#define SETTINGS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SETTINGS, SettingsPrivate))
enum  {
	SETTINGS_DUMMY_PROPERTY,
	SETTINGS_DEVICE,
	SETTINGS_BAUD_RATE,
	SETTINGS_DATA_BITS,
	SETTINGS_STOP_BITS,
	SETTINGS_PARITY,
	SETTINGS_HANDSHAKE,
	SETTINGS_ACCESS_MODE,
	SETTINGS_LOCAL_ECHO
};
static void settings_set_device (Settings* self, const char* value);
static void settings_set_baudRate (Settings* self, gint value);
static void settings_set_dataBits (Settings* self, gint value);
static void settings_set_stopBits (Settings* self, gint value);
static void settings_set_parity (Settings* self, SettingsParity value);
static void settings_set_handshake (Settings* self, SettingsHandshake value);
static void settings_set_accessMode (Settings* self, SettingsAccessMode value);
static void settings_set_localEcho (Settings* self, gboolean value);
Settings* settings_new (const char* device, gint baudRate, gint dataBits, gint stopBits, SettingsParity parity, SettingsHandshake handshake, SettingsAccessMode accessMode, gboolean localEcho);
Settings* settings_construct (GType object_type, const char* device, gint baudRate, gint dataBits, gint stopBits, SettingsParity parity, SettingsHandshake handshake, SettingsAccessMode accessMode, gboolean localEcho);
SettingsParity settings_get_parity (Settings* self);
char* settings_parityToChar (Settings* self);
const char* settings_get_device (Settings* self);
gint settings_get_baudRate (Settings* self);
gint settings_get_dataBits (Settings* self);
gint settings_get_stopBits (Settings* self);
char* settings_getStatusbarString (Settings* self, gboolean open);
GType profile_get_type (void);
SettingsHandshake settings_get_handshake (Settings* self);
SettingsAccessMode settings_get_accessMode (Settings* self);
gboolean settings_get_localEcho (Settings* self);
void settings_saveToProfile (Settings* self, Profile* profile);
char* mo_utils_getKeyString (Profile* profile, const char* group, const char* key);
gint mo_utils_getKeyInteger (Profile* profile, const char* group, const char* key, gint default_val);
gboolean mo_utils_getKeyBoolean (Profile* profile, const char* group, const char* key, gboolean default_val);
Settings* settings_loadFromProfile (Profile* profile);
static GObject * settings_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void settings_finalize (GObject* obj);
static void settings_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void settings_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);




GType settings_parity_get_type (void) {
	static GType settings_parity_type_id = 0;
	if (G_UNLIKELY (settings_parity_type_id == 0)) {
		static const GEnumValue values[] = {{SETTINGS_PARITY_NONE, "SETTINGS_PARITY_NONE", "none"}, {SETTINGS_PARITY_ODD, "SETTINGS_PARITY_ODD", "odd"}, {SETTINGS_PARITY_EVEN, "SETTINGS_PARITY_EVEN", "even"}, {SETTINGS_PARITY_MARK, "SETTINGS_PARITY_MARK", "mark"}, {SETTINGS_PARITY_SPACE, "SETTINGS_PARITY_SPACE", "space"}, {0, NULL, NULL}};
		settings_parity_type_id = g_enum_register_static ("SettingsParity", values);
	}
	return settings_parity_type_id;
}



GType settings_handshake_get_type (void) {
	static GType settings_handshake_type_id = 0;
	if (G_UNLIKELY (settings_handshake_type_id == 0)) {
		static const GEnumValue values[] = {{SETTINGS_HANDSHAKE_NONE, "SETTINGS_HANDSHAKE_NONE", "none"}, {SETTINGS_HANDSHAKE_HARDWARE, "SETTINGS_HANDSHAKE_HARDWARE", "hardware"}, {SETTINGS_HANDSHAKE_SOFTWARE, "SETTINGS_HANDSHAKE_SOFTWARE", "software"}, {SETTINGS_HANDSHAKE_BOTH, "SETTINGS_HANDSHAKE_BOTH", "both"}, {0, NULL, NULL}};
		settings_handshake_type_id = g_enum_register_static ("SettingsHandshake", values);
	}
	return settings_handshake_type_id;
}



GType settings_access_mode_get_type (void) {
	static GType settings_access_mode_type_id = 0;
	if (G_UNLIKELY (settings_access_mode_type_id == 0)) {
		static const GEnumValue values[] = {{SETTINGS_ACCESS_MODE_READWRITE, "SETTINGS_ACCESS_MODE_READWRITE", "readwrite"}, {SETTINGS_ACCESS_MODE_READONLY, "SETTINGS_ACCESS_MODE_READONLY", "readonly"}, {SETTINGS_ACCESS_MODE_WRITEONLY, "SETTINGS_ACCESS_MODE_WRITEONLY", "writeonly"}, {0, NULL, NULL}};
		settings_access_mode_type_id = g_enum_register_static ("SettingsAccessMode", values);
	}
	return settings_access_mode_type_id;
}


Settings* settings_construct (GType object_type, const char* device, gint baudRate, gint dataBits, gint stopBits, SettingsParity parity, SettingsHandshake handshake, SettingsAccessMode accessMode, gboolean localEcho) {
	GParameter * __params;
	GParameter * __params_it;
	Settings * self;
	__params = g_new0 (GParameter, 8);
	__params_it = __params;
	__params_it->name = "device";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, device);
	__params_it++;
	__params_it->name = "baudRate";
	g_value_init (&__params_it->value, G_TYPE_INT);
	g_value_set_int (&__params_it->value, baudRate);
	__params_it++;
	__params_it->name = "dataBits";
	g_value_init (&__params_it->value, G_TYPE_INT);
	g_value_set_int (&__params_it->value, dataBits);
	__params_it++;
	__params_it->name = "stopBits";
	g_value_init (&__params_it->value, G_TYPE_INT);
	g_value_set_int (&__params_it->value, stopBits);
	__params_it++;
	__params_it->name = "parity";
	g_value_init (&__params_it->value, SETTINGS_TYPE_PARITY);
	g_value_set_enum (&__params_it->value, parity);
	__params_it++;
	__params_it->name = "handshake";
	g_value_init (&__params_it->value, SETTINGS_TYPE_HANDSHAKE);
	g_value_set_enum (&__params_it->value, handshake);
	__params_it++;
	__params_it->name = "accessMode";
	g_value_init (&__params_it->value, SETTINGS_TYPE_ACCESS_MODE);
	g_value_set_enum (&__params_it->value, accessMode);
	__params_it++;
	__params_it->name = "localEcho";
	g_value_init (&__params_it->value, G_TYPE_BOOLEAN);
	g_value_set_boolean (&__params_it->value, localEcho);
	__params_it++;
	self = g_object_newv (object_type, __params_it - __params, __params);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


Settings* settings_new (const char* device, gint baudRate, gint dataBits, gint stopBits, SettingsParity parity, SettingsHandshake handshake, SettingsAccessMode accessMode, gboolean localEcho) {
	return settings_construct (TYPE_SETTINGS, device, baudRate, dataBits, stopBits, parity, handshake, accessMode, localEcho);
}


char* settings_parityToChar (Settings* self) {
	char* result;
	g_return_val_if_fail (self != NULL, NULL);
	switch (self->priv->_parity) {
		case SETTINGS_PARITY_NONE:
		{
			{
				result = g_strdup (_ ("N"));
				return result;
			}
		}
		case SETTINGS_PARITY_ODD:
		{
			{
				result = g_strdup (_ ("O"));
				return result;
			}
		}
		case SETTINGS_PARITY_EVEN:
		{
			{
				result = g_strdup (_ ("E"));
				return result;
			}
		}
		case SETTINGS_PARITY_MARK:
		{
			{
				result = g_strdup (_ ("M"));
				return result;
			}
		}
		case SETTINGS_PARITY_SPACE:
		{
			{
				result = g_strdup (_ ("S"));
				return result;
			}
		}
	}
	result = g_strdup ("?");
	return result;
}


char* settings_getStatusbarString (Settings* self, gboolean open) {
	char* result;
	char* r;
	char* _tmp0_;
	char* _tmp9_;
	char* _tmp8_;
	char* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	r = NULL;
	r = (_tmp0_ = g_strdup_printf ("%s", self->priv->_device), _g_free0 (r), _tmp0_);
	if (open) {
		char* _tmp3_;
		char* _tmp2_;
		char* _tmp1_;
		r = (_tmp3_ = g_strconcat (_tmp2_ = g_strconcat (_tmp1_ = g_strconcat (r, " ", NULL), _ ("OPEN"), NULL), " ", NULL), _g_free0 (r), _tmp3_);
		_g_free0 (_tmp2_);
		_g_free0 (_tmp1_);
	} else {
		char* _tmp6_;
		char* _tmp5_;
		char* _tmp4_;
		r = (_tmp6_ = g_strconcat (_tmp5_ = g_strconcat (_tmp4_ = g_strconcat (r, " ", NULL), _ ("CLOSED"), NULL), " ", NULL), _g_free0 (r), _tmp6_);
		_g_free0 (_tmp5_);
		_g_free0 (_tmp4_);
	}
	r = (_tmp9_ = g_strconcat (r, _tmp8_ = g_strdup_printf ("%i,%i%s%i", self->priv->_baudRate, self->priv->_dataBits, _tmp7_ = settings_parityToChar (self), self->priv->_stopBits), NULL), _g_free0 (r), _tmp9_);
	_g_free0 (_tmp8_);
	_g_free0 (_tmp7_);
	result = r;
	return result;
}


void settings_saveToProfile (Settings* self, Profile* profile) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (profile != NULL);
	g_key_file_set_string (profile->keyFile, "port_settings", "device", self->priv->_device);
	g_key_file_set_integer (profile->keyFile, "port_settings", "baud_rate", self->priv->_baudRate);
	g_key_file_set_integer (profile->keyFile, "port_settings", "data_bits", self->priv->_dataBits);
	g_key_file_set_integer (profile->keyFile, "port_settings", "stop_bits", self->priv->_stopBits);
	g_key_file_set_integer (profile->keyFile, "port_settings", "parity", (gint) self->priv->_parity);
	g_key_file_set_integer (profile->keyFile, "port_settings", "handshake", (gint) self->priv->_handshake);
	g_key_file_set_integer (profile->keyFile, "port_settings", "access_mode", (gint) self->priv->_accessMode);
	g_key_file_set_boolean (profile->keyFile, "port_settings", "local_echo", self->priv->_localEcho);
}


Settings* settings_loadFromProfile (Profile* profile) {
	Settings* result;
	char* device;
	gint baudRate = 0;
	gint dataBits = 0;
	gint stopBits = 0;
	SettingsParity parity = 0;
	SettingsHandshake handshake = 0;
	SettingsAccessMode accessMode = 0;
	gboolean localEcho = FALSE;
	char* _tmp0_;
	g_return_val_if_fail (profile != NULL, NULL);
	device = g_strdup (settings_DEFAULT_DEVICEFILE);
	device = (_tmp0_ = mo_utils_getKeyString (profile, "port_settings", "device"), _g_free0 (device), _tmp0_);
	baudRate = mo_utils_getKeyInteger (profile, "port_settings", "baud_rate", settings_DEFAULT_BAUDRATE);
	dataBits = mo_utils_getKeyInteger (profile, "port_settings", "data_bits", settings_DEFAULT_DATABITS);
	stopBits = mo_utils_getKeyInteger (profile, "port_settings", "stop_bits", settings_DEFAULT_STOPBITS);
	parity = (SettingsParity) mo_utils_getKeyInteger (profile, "port_settings", "parity", (gint) settings_DEFAULT_PARITY);
	handshake = (SettingsHandshake) mo_utils_getKeyInteger (profile, "port_settings", "handshake", (gint) settings_DEFAULT_HANDSHAKE);
	accessMode = (SettingsAccessMode) mo_utils_getKeyInteger (profile, "port_settings", "access_mode", (gint) settings_DEFAULT_ACCESSMODE);
	localEcho = mo_utils_getKeyBoolean (profile, "port_settings", "local_echo", settings_DEFAULT_LOCAL_ECHO);
	result = settings_new (device, baudRate, dataBits, stopBits, parity, handshake, accessMode, localEcho);
	_g_free0 (device);
	return result;
}


const char* settings_get_device (Settings* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_device;
	return result;
}


static void settings_set_device (Settings* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_device = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_device), _tmp0_);
	g_object_notify ((GObject *) self, "device");
}


gint settings_get_baudRate (Settings* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_baudRate;
	return result;
}


static void settings_set_baudRate (Settings* self, gint value) {
	g_return_if_fail (self != NULL);
	self->priv->_baudRate = value;
	g_object_notify ((GObject *) self, "baudRate");
}


gint settings_get_dataBits (Settings* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_dataBits;
	return result;
}


static void settings_set_dataBits (Settings* self, gint value) {
	g_return_if_fail (self != NULL);
	self->priv->_dataBits = value;
	g_object_notify ((GObject *) self, "dataBits");
}


gint settings_get_stopBits (Settings* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_stopBits;
	return result;
}


static void settings_set_stopBits (Settings* self, gint value) {
	g_return_if_fail (self != NULL);
	self->priv->_stopBits = value;
	g_object_notify ((GObject *) self, "stopBits");
}


SettingsParity settings_get_parity (Settings* self) {
	SettingsParity result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_parity;
	return result;
}


static void settings_set_parity (Settings* self, SettingsParity value) {
	g_return_if_fail (self != NULL);
	self->priv->_parity = value;
	g_object_notify ((GObject *) self, "parity");
}


SettingsHandshake settings_get_handshake (Settings* self) {
	SettingsHandshake result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_handshake;
	return result;
}


static void settings_set_handshake (Settings* self, SettingsHandshake value) {
	g_return_if_fail (self != NULL);
	self->priv->_handshake = value;
	g_object_notify ((GObject *) self, "handshake");
}


SettingsAccessMode settings_get_accessMode (Settings* self) {
	SettingsAccessMode result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_accessMode;
	return result;
}


static void settings_set_accessMode (Settings* self, SettingsAccessMode value) {
	g_return_if_fail (self != NULL);
	self->priv->_accessMode = value;
	g_object_notify ((GObject *) self, "accessMode");
}


gboolean settings_get_localEcho (Settings* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_localEcho;
	return result;
}


static void settings_set_localEcho (Settings* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_localEcho = value;
	g_object_notify ((GObject *) self, "localEcho");
}


static GObject * settings_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	Settings * self;
	parent_class = G_OBJECT_CLASS (settings_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = SETTINGS (obj);
	{
		if (self->priv->_device == NULL) {
			settings_set_device (self, settings_DEFAULT_DEVICEFILE);
		}
		if (self->priv->_baudRate == 0) {
			settings_set_baudRate (self, settings_DEFAULT_BAUDRATE);
		}
		if (self->priv->_dataBits == 0) {
			settings_set_dataBits (self, settings_DEFAULT_DATABITS);
		}
		if (self->priv->_stopBits == 0) {
			settings_set_stopBits (self, settings_DEFAULT_STOPBITS);
		}
	}
	return obj;
}


static void settings_class_init (SettingsClass * klass) {
	settings_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SettingsPrivate));
	G_OBJECT_CLASS (klass)->get_property = settings_get_property;
	G_OBJECT_CLASS (klass)->set_property = settings_set_property;
	G_OBJECT_CLASS (klass)->constructor = settings_constructor;
	G_OBJECT_CLASS (klass)->finalize = settings_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SETTINGS_DEVICE, g_param_spec_string ("device", "device", "device", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SETTINGS_BAUD_RATE, g_param_spec_int ("baudRate", "baudRate", "baudRate", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SETTINGS_DATA_BITS, g_param_spec_int ("dataBits", "dataBits", "dataBits", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SETTINGS_STOP_BITS, g_param_spec_int ("stopBits", "stopBits", "stopBits", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SETTINGS_PARITY, g_param_spec_enum ("parity", "parity", "parity", SETTINGS_TYPE_PARITY, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SETTINGS_HANDSHAKE, g_param_spec_enum ("handshake", "handshake", "handshake", SETTINGS_TYPE_HANDSHAKE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SETTINGS_ACCESS_MODE, g_param_spec_enum ("accessMode", "accessMode", "accessMode", SETTINGS_TYPE_ACCESS_MODE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SETTINGS_LOCAL_ECHO, g_param_spec_boolean ("localEcho", "localEcho", "localEcho", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	settings_DEFAULT_DEVICEFILE = g_strdup ("/dev/ttyS0");
}


static void settings_instance_init (Settings * self) {
	self->priv = SETTINGS_GET_PRIVATE (self);
}


static void settings_finalize (GObject* obj) {
	Settings * self;
	self = SETTINGS (obj);
	_g_free0 (self->priv->_device);
	G_OBJECT_CLASS (settings_parent_class)->finalize (obj);
}


GType settings_get_type (void) {
	static GType settings_type_id = 0;
	if (settings_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (SettingsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) settings_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Settings), 0, (GInstanceInitFunc) settings_instance_init, NULL };
		settings_type_id = g_type_register_static (G_TYPE_OBJECT, "Settings", &g_define_type_info, 0);
	}
	return settings_type_id;
}


static void settings_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	Settings * self;
	self = SETTINGS (object);
	switch (property_id) {
		case SETTINGS_DEVICE:
		g_value_set_string (value, settings_get_device (self));
		break;
		case SETTINGS_BAUD_RATE:
		g_value_set_int (value, settings_get_baudRate (self));
		break;
		case SETTINGS_DATA_BITS:
		g_value_set_int (value, settings_get_dataBits (self));
		break;
		case SETTINGS_STOP_BITS:
		g_value_set_int (value, settings_get_stopBits (self));
		break;
		case SETTINGS_PARITY:
		g_value_set_enum (value, settings_get_parity (self));
		break;
		case SETTINGS_HANDSHAKE:
		g_value_set_enum (value, settings_get_handshake (self));
		break;
		case SETTINGS_ACCESS_MODE:
		g_value_set_enum (value, settings_get_accessMode (self));
		break;
		case SETTINGS_LOCAL_ECHO:
		g_value_set_boolean (value, settings_get_localEcho (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void settings_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	Settings * self;
	self = SETTINGS (object);
	switch (property_id) {
		case SETTINGS_DEVICE:
		settings_set_device (self, g_value_get_string (value));
		break;
		case SETTINGS_BAUD_RATE:
		settings_set_baudRate (self, g_value_get_int (value));
		break;
		case SETTINGS_DATA_BITS:
		settings_set_dataBits (self, g_value_get_int (value));
		break;
		case SETTINGS_STOP_BITS:
		settings_set_stopBits (self, g_value_get_int (value));
		break;
		case SETTINGS_PARITY:
		settings_set_parity (self, g_value_get_enum (value));
		break;
		case SETTINGS_HANDSHAKE:
		settings_set_handshake (self, g_value_get_enum (value));
		break;
		case SETTINGS_ACCESS_MODE:
		settings_set_accessMode (self, g_value_get_enum (value));
		break;
		case SETTINGS_LOCAL_ECHO:
		settings_set_localEcho (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}




