/* Preferences.c generated by valac 0.10.2, the Vala compiler
 * generated from Preferences.vala, do not modify */

/*
 *  Copyright (C) 2009-2010 Michael J. Chudobiak.
 *
 *  This file is part of moserial.
 *
 *  moserial is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  moserial is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with moserial.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gconf/gconf-client.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>
#include <stdio.h>


#define TYPE_PREFERENCES (preferences_get_type ())
#define PREFERENCES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PREFERENCES, Preferences))
#define PREFERENCES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PREFERENCES, PreferencesClass))
#define IS_PREFERENCES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PREFERENCES))
#define IS_PREFERENCES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PREFERENCES))
#define PREFERENCES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PREFERENCES, PreferencesClass))

typedef struct _Preferences Preferences;
typedef struct _PreferencesClass PreferencesClass;
typedef struct _PreferencesPrivate PreferencesPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_PROFILE (profile_get_type ())
#define PROFILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROFILE, Profile))
#define PROFILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROFILE, ProfileClass))
#define IS_PROFILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROFILE))
#define IS_PROFILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROFILE))
#define PROFILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROFILE, ProfileClass))

typedef struct _Profile Profile;
typedef struct _ProfileClass ProfileClass;
typedef struct _ProfilePrivate ProfilePrivate;

struct _Preferences {
	GObject parent_instance;
	PreferencesPrivate * priv;
};

struct _PreferencesClass {
	GObjectClass parent_class;
};

struct _PreferencesPrivate {
	gboolean _useSystemMonospaceFont;
	char* _font;
	char* _fontColor;
	char* _backgroundColor;
	char* _highlightColor;
	gboolean _recordLaunch;
	gboolean _enableTimeout;
	gint _timeout;
};

struct _Profile {
	GObject parent_instance;
	ProfilePrivate * priv;
	GKeyFile* keyFile;
};

struct _ProfileClass {
	GObjectClass parent_class;
};


extern gboolean preferences_DEFAULT_USE_SYSTEM_MONOSPACE_FONT;
gboolean preferences_DEFAULT_USE_SYSTEM_MONOSPACE_FONT = TRUE;
extern char* preferences_DEFAULT_FONT;
char* preferences_DEFAULT_FONT = NULL;
extern char* preferences_DEFAULT_FONT_COLOR;
char* preferences_DEFAULT_FONT_COLOR = NULL;
extern char* preferences_DEFAULT_BACKGROUND_COLOR;
char* preferences_DEFAULT_BACKGROUND_COLOR = NULL;
extern char* preferences_DEFAULT_HIGHLIGHT_COLOR;
char* preferences_DEFAULT_HIGHLIGHT_COLOR = NULL;
extern gboolean preferences_DEFAULT_RECORD_LAUNCH;
gboolean preferences_DEFAULT_RECORD_LAUNCH = TRUE;
static gpointer preferences_parent_class = NULL;

GType preferences_get_type (void) G_GNUC_CONST;
#define PREFERENCES_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PREFERENCES, PreferencesPrivate))
enum  {
	PREFERENCES_DUMMY_PROPERTY,
	PREFERENCES_USE_SYSTEM_MONOSPACE_FONT,
	PREFERENCES_FONT,
	PREFERENCES_FONT_COLOR,
	PREFERENCES_BACKGROUND_COLOR,
	PREFERENCES_HIGHLIGHT_COLOR,
	PREFERENCES_RECORD_LAUNCH,
	PREFERENCES_ENABLE_TIMEOUT,
	PREFERENCES_TIMEOUT
};
Preferences* preferences_new (gboolean useSystemMonospaceFont, const char* font, const char* fontColor, const char* backgroundColor, const char* highlightColor, gboolean recordLaunch, gboolean enableTimeout, gint timeout);
Preferences* preferences_construct (GType object_type, gboolean useSystemMonospaceFont, const char* font, const char* fontColor, const char* backgroundColor, const char* highlightColor, gboolean recordLaunch, gboolean enableTimeout, gint timeout);
char* preferences_getSystemDefaultMonospaceFont (void);
void preferences_getGdkColor (const char* color, GdkColor* result);
void preferences_toString (Preferences* self);
gboolean preferences_get_useSystemMonospaceFont (Preferences* self);
const char* preferences_get_font (Preferences* self);
const char* preferences_get_fontColor (Preferences* self);
const char* preferences_get_backgroundColor (Preferences* self);
const char* preferences_get_highlightColor (Preferences* self);
gboolean preferences_get_recordLaunch (Preferences* self);
GType profile_get_type (void) G_GNUC_CONST;
void preferences_saveToProfile (Preferences* self, Profile* profile);
gboolean preferences_get_enableTimeout (Preferences* self);
gint preferences_get_timeout (Preferences* self);
Preferences* preferences_loadFromProfile (Profile* profile);
gboolean mo_utils_getKeyBoolean (Profile* profile, const char* group, const char* key, gboolean default_val);
char* mo_utils_getKeyString (Profile* profile, const char* group, const char* key);
gint mo_utils_getKeyInteger (Profile* profile, const char* group, const char* key, gint default_val);
static void preferences_set_useSystemMonospaceFont (Preferences* self, gboolean value);
static void preferences_set_font (Preferences* self, const char* value);
static void preferences_set_fontColor (Preferences* self, const char* value);
static void preferences_set_backgroundColor (Preferences* self, const char* value);
static void preferences_set_highlightColor (Preferences* self, const char* value);
static void preferences_set_recordLaunch (Preferences* self, gboolean value);
static void preferences_set_enableTimeout (Preferences* self, gboolean value);
static void preferences_set_timeout (Preferences* self, gint value);
static GObject * preferences_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void preferences_finalize (GObject* obj);
static void preferences_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void preferences_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);



Preferences* preferences_construct (GType object_type, gboolean useSystemMonospaceFont, const char* font, const char* fontColor, const char* backgroundColor, const char* highlightColor, gboolean recordLaunch, gboolean enableTimeout, gint timeout) {
	Preferences * self = NULL;
	self = (Preferences*) g_object_new (object_type, "useSystemMonospaceFont", useSystemMonospaceFont, "font", font, "recordLaunch", recordLaunch, "fontColor", fontColor, "backgroundColor", backgroundColor, "highlightColor", highlightColor, "enableTimeout", enableTimeout, "timeout", timeout, NULL);
	return self;
}


Preferences* preferences_new (gboolean useSystemMonospaceFont, const char* font, const char* fontColor, const char* backgroundColor, const char* highlightColor, gboolean recordLaunch, gboolean enableTimeout, gint timeout) {
	return preferences_construct (TYPE_PREFERENCES, useSystemMonospaceFont, font, fontColor, backgroundColor, highlightColor, recordLaunch, enableTimeout, timeout);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


char* preferences_getSystemDefaultMonospaceFont (void) {
	char* result = NULL;
	char* value;
	GConfClient* gc;
	GError * _inner_error_ = NULL;
	value = g_strdup ("");
	gc = _g_object_ref0 (gconf_client_get_default ());
	{
		char* _tmp0_;
		char* _tmp1_;
		_tmp0_ = gconf_client_get_string (gc, "/desktop/gnome/interface/monospace_font_name", &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch24_g_error;
		}
		value = (_tmp1_ = _tmp0_, _g_free0 (value), _tmp1_);
	}
	goto __finally24;
	__catch24_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			char* _tmp2_;
			g_warning (_ ("Unable to retrieve gconf key: %s"), e->message);
			value = (_tmp2_ = g_strdup ("Monospace 10"), _g_free0 (value), _tmp2_);
			_g_error_free0 (e);
		}
	}
	__finally24:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (gc);
		_g_free0 (value);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = value;
	_g_object_unref0 (gc);
	return result;
}


void preferences_getGdkColor (const char* color, GdkColor* result) {
	GdkColor c = {0};
	g_return_if_fail (color != NULL);
	gdk_color_parse (color, &c);
	*result = c;
	return;
}


void preferences_toString (Preferences* self) {
	g_return_if_fail (self != NULL);
	fprintf (stdout, "useSystemMonospaceFont: ");
	if (self->priv->_useSystemMonospaceFont) {
		fprintf (stdout, "true\n");
	} else {
		fprintf (stdout, "false\n");
	}
	fprintf (stdout, "font: %s\n", self->priv->_font);
	fprintf (stdout, "fontColor: %s\n", self->priv->_fontColor);
	fprintf (stdout, "backgroundColor: %s\n", self->priv->_backgroundColor);
	fprintf (stdout, "highlightColor: %s\n", self->priv->_highlightColor);
	fprintf (stdout, "recordLaunch: ");
	if (self->priv->_recordLaunch) {
		fprintf (stdout, "true\n");
	} else {
		fprintf (stdout, "false\n");
	}
}


void preferences_saveToProfile (Preferences* self, Profile* profile) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (profile != NULL);
	g_key_file_set_boolean (profile->keyFile, "preferences", "use_system_monospace_font", self->priv->_useSystemMonospaceFont);
	g_key_file_set_string (profile->keyFile, "preferences", "font", self->priv->_font);
	g_key_file_set_string (profile->keyFile, "preferences", "font_color", self->priv->_fontColor);
	g_key_file_set_string (profile->keyFile, "preferences", "background_color", self->priv->_backgroundColor);
	g_key_file_set_string (profile->keyFile, "preferences", "highlight_color", self->priv->_highlightColor);
	g_key_file_set_boolean (profile->keyFile, "preferences", "record_launch", self->priv->_recordLaunch);
	g_key_file_set_boolean (profile->keyFile, "preferences", "enable_timeout", self->priv->_enableTimeout);
	g_key_file_set_integer (profile->keyFile, "preferences", "timeout", self->priv->_timeout);
}


Preferences* preferences_loadFromProfile (Profile* profile) {
	Preferences* result = NULL;
	gboolean useSystemMonospaceFont = FALSE;
	char* font;
	char* fontColor;
	char* backgroundColor;
	char* highlightColor;
	gboolean recordLaunch = FALSE;
	gboolean enableTimeout = FALSE;
	gint timeout = 0;
	char* _tmp0_;
	char* _tmp1_;
	char* _tmp2_;
	char* _tmp3_;
	g_return_val_if_fail (profile != NULL, NULL);
	font = NULL;
	fontColor = NULL;
	backgroundColor = NULL;
	highlightColor = NULL;
	useSystemMonospaceFont = mo_utils_getKeyBoolean (profile, "preferences", "use_system_monospace_font", preferences_DEFAULT_USE_SYSTEM_MONOSPACE_FONT);
	font = (_tmp0_ = mo_utils_getKeyString (profile, "preferences", "font"), _g_free0 (font), _tmp0_);
	fontColor = (_tmp1_ = mo_utils_getKeyString (profile, "preferences", "font_color"), _g_free0 (fontColor), _tmp1_);
	backgroundColor = (_tmp2_ = mo_utils_getKeyString (profile, "preferences", "background_color"), _g_free0 (backgroundColor), _tmp2_);
	highlightColor = (_tmp3_ = mo_utils_getKeyString (profile, "preferences", "highlight_color"), _g_free0 (highlightColor), _tmp3_);
	recordLaunch = mo_utils_getKeyBoolean (profile, "preferences", "record_launch", TRUE);
	enableTimeout = mo_utils_getKeyBoolean (profile, "preferences", "enable_timeout", FALSE);
	timeout = mo_utils_getKeyInteger (profile, "preferences", "timeout", 30);
	result = preferences_new (useSystemMonospaceFont, font, fontColor, backgroundColor, highlightColor, recordLaunch, enableTimeout, timeout);
	_g_free0 (highlightColor);
	_g_free0 (backgroundColor);
	_g_free0 (fontColor);
	_g_free0 (font);
	return result;
}


gboolean preferences_get_useSystemMonospaceFont (Preferences* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_useSystemMonospaceFont;
	return result;
}


static void preferences_set_useSystemMonospaceFont (Preferences* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_useSystemMonospaceFont = value;
	g_object_notify ((GObject *) self, "useSystemMonospaceFont");
}


const char* preferences_get_font (Preferences* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_font;
	return result;
}


static void preferences_set_font (Preferences* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_font = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_font), _tmp0_);
	g_object_notify ((GObject *) self, "font");
}


const char* preferences_get_fontColor (Preferences* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_fontColor;
	return result;
}


static void preferences_set_fontColor (Preferences* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_fontColor = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_fontColor), _tmp0_);
	g_object_notify ((GObject *) self, "fontColor");
}


const char* preferences_get_backgroundColor (Preferences* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_backgroundColor;
	return result;
}


static void preferences_set_backgroundColor (Preferences* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_backgroundColor = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_backgroundColor), _tmp0_);
	g_object_notify ((GObject *) self, "backgroundColor");
}


const char* preferences_get_highlightColor (Preferences* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_highlightColor;
	return result;
}


static void preferences_set_highlightColor (Preferences* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_highlightColor = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_highlightColor), _tmp0_);
	g_object_notify ((GObject *) self, "highlightColor");
}


gboolean preferences_get_recordLaunch (Preferences* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_recordLaunch;
	return result;
}


static void preferences_set_recordLaunch (Preferences* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_recordLaunch = value;
	g_object_notify ((GObject *) self, "recordLaunch");
}


gboolean preferences_get_enableTimeout (Preferences* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_enableTimeout;
	return result;
}


static void preferences_set_enableTimeout (Preferences* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_enableTimeout = value;
	g_object_notify ((GObject *) self, "enableTimeout");
}


gint preferences_get_timeout (Preferences* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_timeout;
	return result;
}


static void preferences_set_timeout (Preferences* self, gint value) {
	g_return_if_fail (self != NULL);
	self->priv->_timeout = value;
	g_object_notify ((GObject *) self, "timeout");
}


static GObject * preferences_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	Preferences * self;
	parent_class = G_OBJECT_CLASS (preferences_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = PREFERENCES (obj);
	{
		if (self->priv->_font == NULL) {
			preferences_set_font (self, preferences_DEFAULT_FONT);
		}
		if (self->priv->_fontColor == NULL) {
			preferences_set_fontColor (self, preferences_DEFAULT_FONT_COLOR);
		}
		if (self->priv->_backgroundColor == NULL) {
			preferences_set_backgroundColor (self, preferences_DEFAULT_BACKGROUND_COLOR);
		}
		if (self->priv->_highlightColor == NULL) {
			preferences_set_highlightColor (self, preferences_DEFAULT_HIGHLIGHT_COLOR);
		}
	}
	return obj;
}


static void preferences_class_init (PreferencesClass * klass) {
	preferences_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (PreferencesPrivate));
	G_OBJECT_CLASS (klass)->get_property = preferences_get_property;
	G_OBJECT_CLASS (klass)->set_property = preferences_set_property;
	G_OBJECT_CLASS (klass)->constructor = preferences_constructor;
	G_OBJECT_CLASS (klass)->finalize = preferences_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), PREFERENCES_USE_SYSTEM_MONOSPACE_FONT, g_param_spec_boolean ("useSystemMonospaceFont", "useSystemMonospaceFont", "useSystemMonospaceFont", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PREFERENCES_FONT, g_param_spec_string ("font", "font", "font", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PREFERENCES_FONT_COLOR, g_param_spec_string ("fontColor", "fontColor", "fontColor", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PREFERENCES_BACKGROUND_COLOR, g_param_spec_string ("backgroundColor", "backgroundColor", "backgroundColor", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PREFERENCES_HIGHLIGHT_COLOR, g_param_spec_string ("highlightColor", "highlightColor", "highlightColor", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PREFERENCES_RECORD_LAUNCH, g_param_spec_boolean ("recordLaunch", "recordLaunch", "recordLaunch", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PREFERENCES_ENABLE_TIMEOUT, g_param_spec_boolean ("enableTimeout", "enableTimeout", "enableTimeout", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PREFERENCES_TIMEOUT, g_param_spec_int ("timeout", "timeout", "timeout", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	preferences_DEFAULT_FONT = g_strdup ("Monospace 10");
	preferences_DEFAULT_FONT_COLOR = g_strdup ("black");
	preferences_DEFAULT_BACKGROUND_COLOR = g_strdup ("white");
	preferences_DEFAULT_HIGHLIGHT_COLOR = g_strdup ("#2020ff");
}


static void preferences_instance_init (Preferences * self) {
	self->priv = PREFERENCES_GET_PRIVATE (self);
}


static void preferences_finalize (GObject* obj) {
	Preferences * self;
	self = PREFERENCES (obj);
	_g_free0 (self->priv->_font);
	_g_free0 (self->priv->_fontColor);
	_g_free0 (self->priv->_backgroundColor);
	_g_free0 (self->priv->_highlightColor);
	G_OBJECT_CLASS (preferences_parent_class)->finalize (obj);
}


GType preferences_get_type (void) {
	static volatile gsize preferences_type_id__volatile = 0;
	if (g_once_init_enter (&preferences_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PreferencesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) preferences_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Preferences), 0, (GInstanceInitFunc) preferences_instance_init, NULL };
		GType preferences_type_id;
		preferences_type_id = g_type_register_static (G_TYPE_OBJECT, "Preferences", &g_define_type_info, 0);
		g_once_init_leave (&preferences_type_id__volatile, preferences_type_id);
	}
	return preferences_type_id__volatile;
}


static void preferences_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	Preferences * self;
	self = PREFERENCES (object);
	switch (property_id) {
		case PREFERENCES_USE_SYSTEM_MONOSPACE_FONT:
		g_value_set_boolean (value, preferences_get_useSystemMonospaceFont (self));
		break;
		case PREFERENCES_FONT:
		g_value_set_string (value, preferences_get_font (self));
		break;
		case PREFERENCES_FONT_COLOR:
		g_value_set_string (value, preferences_get_fontColor (self));
		break;
		case PREFERENCES_BACKGROUND_COLOR:
		g_value_set_string (value, preferences_get_backgroundColor (self));
		break;
		case PREFERENCES_HIGHLIGHT_COLOR:
		g_value_set_string (value, preferences_get_highlightColor (self));
		break;
		case PREFERENCES_RECORD_LAUNCH:
		g_value_set_boolean (value, preferences_get_recordLaunch (self));
		break;
		case PREFERENCES_ENABLE_TIMEOUT:
		g_value_set_boolean (value, preferences_get_enableTimeout (self));
		break;
		case PREFERENCES_TIMEOUT:
		g_value_set_int (value, preferences_get_timeout (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void preferences_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	Preferences * self;
	self = PREFERENCES (object);
	switch (property_id) {
		case PREFERENCES_USE_SYSTEM_MONOSPACE_FONT:
		preferences_set_useSystemMonospaceFont (self, g_value_get_boolean (value));
		break;
		case PREFERENCES_FONT:
		preferences_set_font (self, g_value_get_string (value));
		break;
		case PREFERENCES_FONT_COLOR:
		preferences_set_fontColor (self, g_value_get_string (value));
		break;
		case PREFERENCES_BACKGROUND_COLOR:
		preferences_set_backgroundColor (self, g_value_get_string (value));
		break;
		case PREFERENCES_HIGHLIGHT_COLOR:
		preferences_set_highlightColor (self, g_value_get_string (value));
		break;
		case PREFERENCES_RECORD_LAUNCH:
		preferences_set_recordLaunch (self, g_value_get_boolean (value));
		break;
		case PREFERENCES_ENABLE_TIMEOUT:
		preferences_set_enableTimeout (self, g_value_get_boolean (value));
		break;
		case PREFERENCES_TIMEOUT:
		preferences_set_timeout (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}




