#ifndef GTK_SERVER_PROTOCOL_H
#define GTK_SERVER_PROTOCOL_H

#ifdef  __cplusplus
extern "C" {
#endif

#include <stdint.h>
#include <stddef.h>
#include "wayland-util.h"

struct wl_client;
struct wl_resource;

struct gtk_shell;
struct gtk_surface;

extern const struct wl_interface gtk_shell_interface;
extern const struct wl_interface gtk_surface_interface;

#ifndef GTK_SHELL_CAPABILITY_ENUM
#define GTK_SHELL_CAPABILITY_ENUM
enum gtk_shell_capability {
	GTK_SHELL_CAPABILITY_GLOBAL_APP_MENU = 1,
	GTK_SHELL_CAPABILITY_GLOBAL_MENU_BAR = 2,
};
#endif /* GTK_SHELL_CAPABILITY_ENUM */

struct gtk_shell_interface {
	/**
	 * get_gtk_surface - (none)
	 * @gtk_surface: (none)
	 * @surface: (none)
	 */
	void (*get_gtk_surface)(struct wl_client *client,
				struct wl_resource *resource,
				uint32_t gtk_surface,
				struct wl_resource *surface);
};

#define GTK_SHELL_CAPABILITIES	0

static inline void
gtk_shell_send_capabilities(struct wl_resource *resource_, uint32_t capabilities)
{
	wl_resource_post_event(resource_, GTK_SHELL_CAPABILITIES, capabilities);
}

struct gtk_surface_interface {
	/**
	 * set_dbus_properties - (none)
	 * @application_id: (none)
	 * @app_menu_path: (none)
	 * @menubar_path: (none)
	 * @window_object_path: (none)
	 * @application_object_path: (none)
	 * @unique_bus_name: (none)
	 */
	void (*set_dbus_properties)(struct wl_client *client,
				    struct wl_resource *resource,
				    const char *application_id,
				    const char *app_menu_path,
				    const char *menubar_path,
				    const char *window_object_path,
				    const char *application_object_path,
				    const char *unique_bus_name);
};

#ifdef  __cplusplus
}
#endif

#endif
