/* -*- Mode: C; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 8 -*- */
#include "liboaf.h"

OAF_Attribute *
oaf_server_info_attr_find (OAF_ServerInfo * server, const char *attr_name)
{
	int i;

	for (i = 0; i < server->attrs._length; i++) {
		if (!strcmp (server->attrs._buffer[i].name, attr_name))
			return &server->attrs._buffer[i];
	}

	return NULL;
}

const char *
oaf_server_info_attr_lookup (OAF_ServerInfo * server, const char *attr_name,
			     GSList * i18n_languages)
{
	GSList *cur;
	OAF_Attribute *attr;
        const char *retval;
        char *attr_name_buf;
        char short_lang[3];
                     
	if (i18n_languages) {
		for (cur = i18n_languages; cur; cur = cur->next) {
                        attr_name_buf = g_strdup_printf ("%s-%s", attr_name, (char *) cur->data);

			retval = oaf_server_info_attr_lookup (server, attr_name_buf, NULL);
                        g_free (attr_name_buf);

                        if (!retval) {
                                if (strlen ((char *) cur->data) > 2) {
                                        strncpy (short_lang, (char *) cur->data, 2);
                                        attr_name_buf = g_strdup_printf ("%s-%s", attr_name, short_lang);
                                        retval = oaf_server_info_attr_lookup (server, attr_name_buf, NULL);
                                        g_free (attr_name_buf);
                                }
                        }

			if (retval)
				return retval;
		}
	} 

        attr = oaf_server_info_attr_find (server, attr_name);
        if (attr != NULL && attr->v._d == OAF_A_STRING)
                return attr->v._u.value_string;

	return NULL;
}
