/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Author: Charles Kerr <charles@rebelbase.com>
 *
 * Copyright (C) 2000, 2001  Pan Development Team <pan@rebelbase.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */

#include <config.h>

#include <stdarg.h>
#include <stdio.h>
#include <time.h>

#include <pthread.h>

#include <pan/base/debug.h>
#include <pan/base/pan-glib-extensions.h>

unsigned long debug_level = 0;

gint depth = 0;
 
void
set_debug_level (unsigned long level)
{
	debug_level = level;
}

void
debug_printf (const gchar   * filename,
              int             line_num,
              gulong          flag,
              const gchar   * fmt,
              ...)
{
	static GHashTable * t2d = NULL;
	char timebuf[64];
	gchar * string;
	const gchar * prefix;
	time_t now_time_t;
	va_list args;
	struct tm now_tm;
	const gint self = (int) pthread_self ();

	if (t2d == NULL)
		t2d = g_hash_table_new (g_direct_hash, g_direct_equal);

	g_return_if_fail (fmt != NULL);

	/* get prefix */
	if (flag&DEBUG_QUEUE) prefix="QUEUE";
	else if (flag&DEBUG_SOCKET_INPUT) prefix="SOCKET INPUT";
	else if (flag&DEBUG_SOCKET_OUTPUT) prefix="SOCKET OUTPUT";
	else if (flag&DEBUG_DECODE) prefix="DECODE";
	else if (flag&DEBUG_ACACHE) prefix="ACACHE";
	else if (flag&DEBUG_LOCK) prefix="LOCK";
	else if (flag&DEBUG_PAN_OBJECT) prefix="PAN OBJECT";
	else if (flag&DEBUG_TRACE) prefix="TRACE";
	else {prefix="FOO";}

	va_start (args, fmt);
	string = g_strdup_vprintf (fmt, args);
	va_end (args);

	time (&now_time_t);
	gmtime_r (&now_time_t, &now_tm);
	strftime (timebuf, sizeof(timebuf), "%H:%M:%S", &now_tm);

	if (flag&DEBUG_TRACE)
	{
		const gint old_depth = GPOINTER_TO_INT (g_hash_table_lookup (t2d, GINT_TO_POINTER(self)));
		const gint new_depth = old_depth + (*fmt=='+' ? 1 : -1);

		g_hash_table_insert (t2d, 
		                     GINT_TO_POINTER(self),
		                     GINT_TO_POINTER(new_depth));

		printf ("(%20s:%04d)(thread %4d)(time %s)(depth %3d) %s: %s\n",
			filename,
			line_num,
			self,
			timebuf,
			new_depth,
			prefix,
			string);

		if (*fmt=='-')
			--depth;
	}
	else
	{
		printf ("(%20s:%04d)(thread %4d)(time %s) %s: %s\n",
			filename,
			line_num,
			self,
			timebuf,
			prefix,
			string);
	}
	fflush (NULL);

	g_free (string);
}

