#include <stdlib.h>

#include <string.h>

#include <glib.h>

#include <pan/base/article.h>
#include <pan/base/base-prefs.h>
#include <pan/base/debug.h>
#include <pan/base/group.h>
#include <pan/base/pan-glib-extensions.h>
#include <pan/base/server.h>

static void
pan_init (void)
{
	gchar * base;
	gchar * data_dir;
	gchar * temp_dir;
	gchar * download_dir;

	base = getenv ("srcdir");
	base = g_strdup_printf ("%s/", base!=NULL ? base : getenv("PWD"));
	data_dir = g_strdup_printf ("%s/data/", base);
	temp_dir = g_strdup_printf ("%s/data/tmp/", base);
	download_dir = g_strdup_printf ("%s/data/save/", base);
	base_prefs_init (data_dir, temp_dir, download_dir, 1000, FALSE, FALSE);
	g_free (data_dir);
	g_free (temp_dir);
	g_free (download_dir);
}


int
main (void)
{
	gint test = 0;
	Group * g;
	Article * a;
	Article * a1;
	gchar * pch;
	const gchar * cpch;

	g_thread_init (NULL);
	pan_init ();

	g = group_new ("alt.test");

	/* ctor sanity */
	++test;
	a1 = article_new (g);
	if (a1==NULL) return test;
	if (PAN_OBJECT(a1)->ref_count != 1) return test;
	if (a1->crosspost_qty != 0) return test;
	if (a1->part != 0) return test;
	if (a1->parts != 0) return test;
	if (a1->linecount != 0) return test;
	if (a1->state != 0) return test;
	if (a1->unread_children != 0) return test;
	if (a1->date != 0) return test;
	if (a1->threads != NULL) return test;
	if (a1->parent != NULL) return test;
	if (a1->author_addr != NULL) return test;
	if (a1->author_real != NULL) return test;
	if (a1->subject != NULL) return test;
	if (a1->message_id != NULL) return test;
	if (a1->references != NULL) return test;
	g_message ("PASS article ctor sanity check");

	/* set header: no chunk */
	++test;
	pch = "When the Levee Breaks";
	article_set_header (a1, HEADER_SUBJECT, pch, 0);
	if (a1->subject!=pch) return test;
	g_message ("PASS article_set_header, no chunk");

	/* clear header */
	++test;
	article_remove_header (a1, HEADER_SUBJECT);
	if (a1->subject!=NULL) return test;
	g_message ("PASS article_remove_header");

	/* set header: chunk */
	++test;
	article_set_header (a1, HEADER_SUBJECT, pch, DO_CHUNK);
	if (a1->subject==NULL || a1->subject==pch) return test;
	if (pan_strcmp(a1->subject, pch)) return test;
	g_message ("PASS article_set_header, do chunk");

	/* set-author-from-header */
	++test;
	a = a1;

	article_set_author_from_header (a, "joe@foo.com");
	pch = article_get_author_str (a);
	if (pan_strcmp(pch, "\"joe\" <joe@foo.com>")) return test;
	pch = article_get_short_author_str (a);
	if (pan_strcmp(pch, "joe")) return test;

	article_set_author_from_header (a, "joe@foo.com (Joe Bob)");
	pch = article_get_author_str (a);
	if (pan_strcmp(pch, "\"Joe Bob\" <joe@foo.com>")) return test;
	pch = article_get_short_author_str (a);
	if (pan_strcmp(pch, "Joe Bob")) return test;

	article_set_author_from_header (a, "Joe Bob <joe@foo.com>");
	pch = article_get_author_str (a);
	if (pan_strcmp(pch, "\"Joe Bob\" <joe@foo.com>")) return test;
	pch = article_get_short_author_str (a);
	if (pan_strcmp(pch, "Joe Bob")) return test;

	article_set_author_from_header (a, "Joe Bob");
	pch = article_get_author_str (a);
	if (pan_strcmp(pch,
		"\"Joe Bob\" <unknown@spammesenseless.net>")) return test;
	pch = article_get_short_author_str (a);
	if (pan_strcmp(pch, "Joe Bob")) return test;
	g_message ("PASS article_set_author_from_header 1");


	/* encoded authors */
	++test;
	article_set_author_from_header (a1,
		"\"Jrgen Irgendwie\" <juergen.irgendwie@email.com>");
	if (pan_strcmp(a1->author_addr,
		"juergen.irgendwie@email.com")) return test;
	if (pan_strcmp(a1->author_real, "Jrgen Irgendwie")) return test;
	pch = article_get_author_str (a1);
	if (pan_strcmp(pch,
		"\"Jrgen Irgendwie\" <juergen.irgendwie@email.com>"))
			return test;
	g_free (pch);
	pch = article_get_short_author_str (a1);
	if (pan_strcmp(pch,"Jrgen Irgendwie")) return test;
	g_free (pch);
	g_message ("PASS article_set_author_from_header");

	/* more encoded authors */
	++test;
	cpch = "some@email.com (M. =?ISO-8859-1?Q?H=F6lle?=)";
	article_set_author_from_header (a, cpch);
	if (pan_strcmp (a->author_addr,"some@email.com")) return test;
	if (pan_strcmp (a->author_real,"M. Hlle")) return test;
	pch = article_get_author_str (a);
	if (pan_strcmp (pch, "\"M. Hlle\" <some@email.com>")) return test;
	g_free (pch);
	pch = article_get_short_author_str (a);
	if (pan_strcmp (pch, "M. Hlle")) return test;
	g_message ("PASS encoded author header test");


	/* unref cleanup */
	++test;
	pan_object_unref (PAN_OBJECT(a1));
	if (a1->subject!=NULL) return test;
	if (a1->group!=NULL) return test;
	g_message ("PASS article dtor sanity check");


	/* success */
	g_message ("All article tests passed");
	return 0;
}
