/*
 * Pan - A Newsreader for X
 * Copyright (C) 2000, 2001  Pan Development Team (pan@superpimp.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */

#ifndef __GUI_HEADERS_H__
#define __GUI_HEADERS_H__

#include <glib.h>
#include <gtk/gtkwidget.h>
#include "article.h"

/**
 * These are the flgs passed in via the "header_fields" argument in
 * the function gui_set_headers().  For each flag, that header will
 * be displayed.
 */
enum {
	UI_HEADER_SUBJECT	= 1<<0,
	UI_HEADER_AUTHOR	= 1<<1,
	UI_HEADER_MESSAGE_ID	= 1<<2,
	UI_HEADER_REFERENCES	= 1<<3,
	UI_HEADER_REPLY_TO	= 1<<4,
	UI_HEADER_FOLLOWUP_TO	= 1<<5,
	UI_HEADER_DATE		= 1<<6,
	UI_HEADER_NEWSGROUPS	= 1<<7
};

/**
 * This variable is initialized in prefs_init() and defines the user-settable
 * default headers to be displayed.  This is an or'ed list of items from the
 * above enumeration.
 */
extern gulong header_flags;

/**
 * Updates the specified GtkTable to show the specified header_fields
 * associated with the article struct.  If a header is too long to fit
 * conveniently, it is truncated in a hopefully-reasonable way and
 * displayed as a button insted of a label.  When this button is clicked,
 * the untruncated header will be shown in a popup dialog.
 *
 * @param GtkTable the gtktable to use.  Its previous contents are removed.
 * @param Article the article whose headers to use.
 * @param header_fields which headers to show.
 */
void gui_headers_set              (GtkWidget         * gtk_table,
                                   const Article     * article,
                                   gboolean            need_lock,
                                   gulong              header_fields);

/**
 * The same as gui_set_headers, but uses the default header_fields specified
 * in the user's configuration file.  This is a convenience so that callers
 * don't have to query the configuration file by hand.
 */
void gui_headers_set_default      (GtkWidget         * table,
                                   const Article     * article,
                                   gboolean            need_lock);

#endif /* __GUI_HEADERS_H__ */
