/*
 * Pan - A Newsreader for X
 * Copyright (C) 1999, 2000, 2001  Pan Development Team (pan@superpimp.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */

#ifndef __LOG_H__
#define __LOG_H__

#include <time.h>
#include <glib.h>
#include "pan-callback.h"

void log_init (void);

void log_shutdown_module (void);

typedef enum
{
	LOG_ERROR,
	LOG_IMPORTANT,
	LOG_INFO
}
LogSeverity;

void log_add    (LogSeverity, const gchar *);

void log_add_va (LogSeverity, const gchar *, ...);

typedef struct
{
	time_t date;
	gchar * message;
	LogSeverity severity;
}
LogEntry;

GPtrArray * log_get_entries (void);

void log_clear (void);

PanCallback* log_get_entry_added_callback (void);

PanCallback* log_get_entry_list_changed_callback (void);


#endif /* __LOG_H__ */
