/*
 * Pan - A Newsreader for X
 * Copyright (C) 1999, 2000, 2001  Pan Development Team <pan@rebelbase.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */

/*********************
**********************  Includes
*********************/

#include <config.h>

#include <string.h>

#include <glib.h>

#include <pan/debug.h>
#include <pan/pan-glib-extensions.h>

#include <pan/task.h>

/*********************
**********************  Defines / Enumerated types
*********************/

/*********************
**********************  Macros
*********************/

/*********************
**********************  Structures / Typedefs
*********************/

/*********************
**********************  Private Function Prototypes
*********************/

/*********************
**********************  Variables
*********************/

/***********
************  Extern
***********/

/***********
************  Public
***********/

/***********
************  Private
***********/

/*********************
**********************  BEGINNING OF SOURCE
*********************/

/************
*************  PUBLIC ROUTINES
************/

/*****
******
*****/

void
task_constructor (Task *item,
                  PanObjectDestructor destructor,
                  StatusItemDescribeFunc describe,
                  TaskRunFunc run,
                  Server *server,
                  gboolean high_priority,
                  gboolean needs_socket)
{
	g_return_if_fail (item != NULL);

	/* construct parent's bits */
	status_item_constructor (STATUS_ITEM(item), destructor, describe);

	/* construct task's bits */
	pan_warn_if_fail (server != NULL);
	item->server = server;
	item->hint_abort = FALSE;
	item->high_priority = high_priority;
	item->thread_id = 0;
	item->needs_socket = needs_socket;
	item->sock = NULL;
	item->gets_bodies = FALSE;
	item->is_article_reader = FALSE;
	item->tries = 0;
	item->run = run;
	item->task_ran_callback = pan_callback_new ();

        debug1 (DEBUG_PAN_OBJECT, "task constructor: %p", item);
}

void
task_destructor (PanObject* item)
{
	g_return_if_fail (item != NULL);

	/* clean up task bits */
        debug1 (DEBUG_PAN_OBJECT, "task destructor: %p", item);
	pan_callback_free (TASK(item)->task_ran_callback);

	/* clean up parent's bits */
	status_item_destructor (PAN_OBJECT(item));
}

/*****
******
*****/

gint
task_run (Task * task)
{
	gint retval = TASK_FAIL_HOPELESS;

	if (task != NULL)
	{
        	retval = (*task->run)(task);
		status_item_emit_done (STATUS_ITEM(task), retval);
	}

	pan_warn_if_fail (retval==TASK_SUCCESS ||
	                  retval==TASK_FAIL ||
	                  retval==TASK_FAIL_HOPELESS);

	pan_callback_call (task->task_ran_callback,
	                   task,
			   GINT_TO_POINTER(retval));

	return retval;
}

/*****
******
*****/

void
task_hint_abort (Task * task)
{
	g_return_if_fail (task!=NULL);

	task->hint_abort = TRUE;
}
