/* Generated by GOB (v1.0.9) on Mon Jun  4 03:59:30 2001
   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */


#line 1 "pong-radio-group.gob"

/* PonG: radio button group
 * Author: George Lebl
 * (c) 2000 Eazel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#line 30 "pong-radio-group.c"
#define GOB_VERSION_MAJOR 1
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 9

#include <string.h> /* memset() */


#line 26 "pong-radio-group.gob"

#include "config.h"
#include <gnome.h>
#include <gconf/gconf-value.h>

#include "pong-i18n.h"

#include "pongpane.h"
#include "pongutil.h"

#include "pong-radio-group.h"
#include "pong-radio-group-private.h"

typedef struct _RadioButton RadioButton;
struct _RadioButton {
	GtkWidget *w;
	char *value;
};

static void free_radio_button(RadioButton *rb);
static void button_toggled(GtkWidget *w, gpointer data);


#line 62 "pong-radio-group.c"
/* self casting macros */
#define SELF(x) PONG_RADIO_GROUP(x)
#define SELF_CONST(x) PONG_RADIO_GROUP_CONST(x)
#define IS_SELF(x) PONG_IS_RADIO_GROUP(x)
#define TYPE_SELF PONG_TYPE_RADIO_GROUP
#define SELF_CLASS(x) PONG_RADIO_GROUP_CLASS(x)

#define SELF_GET_CLASS(x) PONG_RADIO_GROUP_GET_CLASS(x)

/* self typedefs */
typedef PongRadioGroup Self;
typedef PongRadioGroupClass SelfClass;

/* GTK_CLASS_TYPE for 1.2<->1.3/2.0 GTK+ compatibility */
#ifndef GTK_CLASS_TYPE
#define GTK_CLASS_TYPE(x) (GTK_OBJECT_CLASS(x)->type)
#endif /* GTK_CLASS_TYPE */

/* here are local prototypes */
static void ___object_set_arg (GtkObject *object, GtkArg *arg, guint arg_id);
static void ___object_get_arg (GtkObject *object, GtkArg *arg, guint arg_id);
static void pong_radio_group_class_init (PongRadioGroupClass * klass) G_GNUC_UNUSED;
static void pong_radio_group_init (PongRadioGroup * self) G_GNUC_UNUSED;
static void pong_radio_group_changed (PongRadioGroup * self) G_GNUC_UNUSED;
static char * pong_radio_group_get_cur_value (PongRadioGroup * self) G_GNUC_UNUSED;
static void pong_radio_group_disable_all (PongRadioGroup * self) G_GNUC_UNUSED;
static gboolean pong_radio_group_get_value (GtkWidget * w, const char * specifier, PongType type, GConfValue ** value) G_GNUC_UNUSED;
static gboolean pong_radio_group_set_value (GtkWidget * w, const char * specifier, GConfValue * value) G_GNUC_UNUSED;
static void pong_radio_group_add_options (GtkWidget * w, GList * pong_options) G_GNUC_UNUSED;
static void pong_radio_group_make_horizontal (PongRadioGroup * self) G_GNUC_UNUSED;
static void pong_radio_group_make_vertical (PongRadioGroup * self) G_GNUC_UNUSED;

enum {
	CHANGED_SIGNAL,
	LAST_SIGNAL
};

enum {
	ARG_0,
	ARG_HORIZONTAL
};

static guint object_signals[LAST_SIGNAL] = {0};

/* pointer to the class of our parent */
static GtkVBoxClass *parent_class = NULL;

GtkType
pong_radio_group_get_type (void)
{
	static GtkType type = 0;

	if (type == 0) {
		static const GtkTypeInfo info = {
			"PongRadioGroup",
			sizeof (PongRadioGroup),
			sizeof (PongRadioGroupClass),
			(GtkClassInitFunc) pong_radio_group_class_init,
			(GtkObjectInitFunc) pong_radio_group_init,
			/* reserved_1 */ NULL,
			/* reserved_2 */ NULL,
			(GtkClassInitFunc) NULL
		};

		type = gtk_type_unique (gtk_vbox_get_type(), &info);
	}

	return type;
}

/* Short form macros */
#if defined(__GNUC__) && !defined(__STRICT_ANSI__)
#define new() pong_radio_group_new()
#define new_with_options(args...) pong_radio_group_new_with_options(args)
#define changed(args...) pong_radio_group_changed(args)
#define get_cur_value(args...) pong_radio_group_get_cur_value(args)
#define disable_all(args...) pong_radio_group_disable_all(args)
#define get_value(args...) pong_radio_group_get_value(args)
#define set_value(args...) pong_radio_group_set_value(args)
#define add_options(args...) pong_radio_group_add_options(args)
#define make_horizontal(args...) pong_radio_group_make_horizontal(args)
#define make_vertical(args...) pong_radio_group_make_vertical(args)
#endif /* __GNUC__ && !__STRICT_ANSI__ */

/* Short form pointers */
static GtkWidget * (* const new) (void) = pong_radio_group_new;
static GtkWidget * (* const new_with_options) (GList * pong_options) = pong_radio_group_new_with_options;
static void (* const changed) (PongRadioGroup * self) = pong_radio_group_changed;
static char * (* const get_cur_value) (PongRadioGroup * self) = pong_radio_group_get_cur_value;
static void (* const disable_all) (PongRadioGroup * self) = pong_radio_group_disable_all;
static gboolean (* const get_value) (GtkWidget * w, const char * specifier, PongType type, GConfValue ** value) = pong_radio_group_get_value;
static gboolean (* const set_value) (GtkWidget * w, const char * specifier, GConfValue * value) = pong_radio_group_set_value;
static void (* const add_options) (GtkWidget * w, GList * pong_options) = pong_radio_group_add_options;
static void (* const make_horizontal) (PongRadioGroup * self) = pong_radio_group_make_horizontal;
static void (* const make_vertical) (PongRadioGroup * self) = pong_radio_group_make_vertical;

/* a macro for creating a new object of our type */
#define GET_NEW ((PongRadioGroup *)gtk_type_new(pong_radio_group_get_type()))


static void
___destroy(GtkObject *obj_self)
{
#define __GOB_FUNCTION__ "Pong:Radio:Group::destroy"
	PongRadioGroup *self = PONG_RADIO_GROUP (obj_self);
	if(GTK_OBJECT_CLASS(parent_class)->destroy) \
		(* GTK_OBJECT_CLASS(parent_class)->destroy)(obj_self);
#define VAR (self->_priv->radio_buttons)
	{
#line 68 "pong-radio-group.gob"
	
			g_list_foreach(VAR, (GFunc)free_radio_button, NULL);
			g_list_free(VAR);
		}
#line 177 "pong-radio-group.c"
	memset(&VAR, 0, sizeof(VAR));
#undef VAR
	return;
	self = NULL;
}
#undef __GOB_FUNCTION__


#ifdef G_OBJECT_CLASS
static void
___finalize(GObject *obj_self)
#else /* !G_OBJECT_CLASS */
static void
___finalize(GtkObject *obj_self)
#endif /* G_OBJECT_CLASS */
{
#define __GOB_FUNCTION__ "Pong:Radio:Group::finalize"
	PongRadioGroup *self = PONG_RADIO_GROUP (obj_self);
	gpointer priv = self->_priv;
#ifdef G_OBJECT_CLASS
	if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(obj_self);
#else /* !G_OBJECT_CLASS */
	if(GTK_OBJECT_CLASS(parent_class)->finalize) \
		(* GTK_OBJECT_CLASS(parent_class)->finalize)(obj_self);
#endif /* G_OBJECT_CLASS */
	g_free(priv);
}
#undef __GOB_FUNCTION__

#line 73 "pong-radio-group.gob"
static void 
pong_radio_group_class_init (PongRadioGroupClass * klass)
#line 211 "pong-radio-group.c"
{
#define __GOB_FUNCTION__ "Pong:Radio:Group::class_init"
	GtkObjectClass *gtk_object_class = (GtkObjectClass*) klass;
#ifdef G_OBJECT_CLASS
	GObjectClass *g_object_class = (GObjectClass*) klass;
#endif /* G_OBJECT_CLASS */

	parent_class = gtk_type_class (gtk_vbox_get_type ());

	object_signals[CHANGED_SIGNAL] =
		gtk_signal_new ("changed",
			(GtkSignalRunType)(GTK_RUN_LAST),
			GTK_CLASS_TYPE(gtk_object_class),
			GTK_SIGNAL_OFFSET (PongRadioGroupClass, changed),
			gtk_signal_default_marshaller,
			GTK_TYPE_NONE, 0);
	gtk_object_class_add_signals (gtk_object_class,
		object_signals, LAST_SIGNAL);


	klass->changed = NULL;
	gtk_object_class->destroy = ___destroy;
#ifdef G_OBJECT_CLASS
	g_object_class->finalize = ___finalize;
#else /* !G_OBJECT_CLASS */
	gtk_object_class->finalize = ___finalize;
#endif /* G_OBJECT_CLASS */

	gtk_object_add_arg_type("PongRadioGroup::horizontal",
		GTK_TYPE_BOOL,
		GTK_ARG_READWRITE,
		ARG_HORIZONTAL);

	gtk_object_class->get_arg = ___object_get_arg;
	gtk_object_class->set_arg = ___object_set_arg;
 {
#line 74 "pong-radio-group.gob"

		PongWidgetInterface *iface;

		iface = pong_widget_interface_add(GTK_OBJECT_CLASS(klass));
		iface->changed_signal = "changed";
		iface->get_value = get_value;
		iface->set_value = set_value;
		iface->add_options = add_options;
	
#line 258 "pong-radio-group.c"
 }
	return;
	klass = NULL;
	gtk_object_class = NULL;
#ifdef G_OBJECT_CLASS
	g_object_class = NULL;
#endif /* G_OBJECT_CLASS */
}
#undef __GOB_FUNCTION__
#line 84 "pong-radio-group.gob"
static void 
pong_radio_group_init (PongRadioGroup * self)
#line 271 "pong-radio-group.c"
{
#define __GOB_FUNCTION__ "Pong:Radio:Group::init"
	self->_priv = g_new0 (PongRadioGroupPrivate, 1);
#line 26 "pong-radio-group.gob"
	self->_priv->horiz = NULL;
#line 277 "pong-radio-group.c"
#line 63 "pong-radio-group.gob"
	self->_priv->radio_buttons = NULL;
#line 280 "pong-radio-group.c"
 {
#line 85 "pong-radio-group.gob"

		gtk_box_set_spacing(GTK_BOX(self), GNOME_PAD_SMALL);
	
#line 286 "pong-radio-group.c"
 }
	return;
	self = NULL;
}
#undef __GOB_FUNCTION__

static void
___object_set_arg (GtkObject *object,
	GtkArg *arg,
	guint arg_id)
#define __GOB_FUNCTION__ "Pong:Radio:Group::set_arg"
{
	PongRadioGroup *self;

	self = PONG_RADIO_GROUP (object);

	switch (arg_id) {
	case ARG_HORIZONTAL:
#define ARG (GTK_VALUE_BOOL(*arg))
		{
#line 55 "pong-radio-group.gob"

			if(ARG) {
				if( ! self->_priv->horiz)
					make_horizontal(self);
			} else {
				if(self->_priv->horiz)
					make_vertical(self);
			}
		
#line 317 "pong-radio-group.c"
		}
		break;
#undef ARG
	default:
		break;
	}
	return;
	self = NULL;
	arg = NULL;
}
#undef __GOB_FUNCTION__

static void
___object_get_arg (GtkObject *object,
	GtkArg *arg,
	guint arg_id)
#define __GOB_FUNCTION__ "Pong:Radio:Group::get_arg"
{
	PongRadioGroup *self;

	self = PONG_RADIO_GROUP (object);

	switch (arg_id) {
	case ARG_HORIZONTAL:
#define ARG (GTK_VALUE_BOOL(*arg))
		{
#line 63 "pong-radio-group.gob"

			ARG = self->_priv->horiz != NULL;
		
#line 348 "pong-radio-group.c"
		}
		break;
#undef ARG
	default:
		break;
	}
	return;
	self = NULL;
	arg = NULL;
}
#undef __GOB_FUNCTION__



/**
 * pong_radio_group_new:
 *
 * Description:  Create a new #PongRadioGroup widget
 *
 * Returns:  A new #PongCheckGroup widget
 **/
#line 96 "pong-radio-group.gob"
GtkWidget * 
pong_radio_group_new (void)
#line 373 "pong-radio-group.c"
{
#define __GOB_FUNCTION__ "Pong:Radio:Group::new"
{
#line 99 "pong-radio-group.gob"
	
		return (GtkWidget *) GET_NEW;
	}}
#line 381 "pong-radio-group.c"
#undef __GOB_FUNCTION__

/**
 * pong_radio_group_new_with_options:
 * @options:  a list of PongOption structs
 *
 * Description:  Create a new #PongRadioGroup widget and
 * setup the @options.
 *
 * Returns:  A new #PongRadioGroup widget
 **/
#line 112 "pong-radio-group.gob"
GtkWidget * 
pong_radio_group_new_with_options (GList * pong_options)
#line 396 "pong-radio-group.c"
{
#define __GOB_FUNCTION__ "Pong:Radio:Group::new_with_options"
{
#line 115 "pong-radio-group.gob"
	
		GtkWidget *w = (GtkWidget *) GET_NEW;
		add_options (w, pong_options);
		return w;
	}}
#line 406 "pong-radio-group.c"
#undef __GOB_FUNCTION__

#line 121 "pong-radio-group.gob"
static void 
pong_radio_group_changed (PongRadioGroup * self)
#line 412 "pong-radio-group.c"
{
#line 121 "pong-radio-group.gob"
	g_return_if_fail (self != NULL);
#line 121 "pong-radio-group.gob"
	g_return_if_fail (PONG_IS_RADIO_GROUP (self));
#line 418 "pong-radio-group.c"
	gtk_signal_emit (GTK_OBJECT (self),
		object_signals[CHANGED_SIGNAL]);
}

#line 126 "pong-radio-group.gob"
static char * 
pong_radio_group_get_cur_value (PongRadioGroup * self)
#line 426 "pong-radio-group.c"
{
#define __GOB_FUNCTION__ "Pong:Radio:Group::get_cur_value"
#line 126 "pong-radio-group.gob"
	g_return_val_if_fail (self != NULL, (char * )0);
#line 126 "pong-radio-group.gob"
	g_return_val_if_fail (PONG_IS_RADIO_GROUP (self), (char * )0);
#line 433 "pong-radio-group.c"
{
#line 128 "pong-radio-group.gob"
	
		GList *li;

		for (li = self->_priv->radio_buttons;
		     li != NULL;
		     li = li->next) {
			RadioButton *rb = li->data;
			if(GTK_TOGGLE_BUTTON(rb->w)->active)
				return rb->value;
		}
		return NULL;
	}}
#line 448 "pong-radio-group.c"
#undef __GOB_FUNCTION__

#line 142 "pong-radio-group.gob"
static void 
pong_radio_group_disable_all (PongRadioGroup * self)
#line 454 "pong-radio-group.c"
{
#define __GOB_FUNCTION__ "Pong:Radio:Group::disable_all"
#line 142 "pong-radio-group.gob"
	g_return_if_fail (self != NULL);
#line 142 "pong-radio-group.gob"
	g_return_if_fail (PONG_IS_RADIO_GROUP (self));
#line 461 "pong-radio-group.c"
{
#line 144 "pong-radio-group.gob"
	
		GList *li;

		for(li = self->_priv->radio_buttons;
		    li != NULL;
		    li = li->next) {
			RadioButton *rb = li->data;
			gtk_toggle_button_set_active
				(GTK_TOGGLE_BUTTON(rb->w), FALSE);
			return;
		}
	}}
#line 476 "pong-radio-group.c"
#undef __GOB_FUNCTION__

#line 157 "pong-radio-group.gob"
static gboolean 
pong_radio_group_get_value (GtkWidget * w, const char * specifier, PongType type, GConfValue ** value)
#line 482 "pong-radio-group.c"
{
#define __GOB_FUNCTION__ "Pong:Radio:Group::get_value"
#line 157 "pong-radio-group.gob"
	g_return_val_if_fail (w != NULL, (gboolean )0);
#line 157 "pong-radio-group.gob"
	g_return_val_if_fail (GTK_IS_WIDGET (w), (gboolean )0);
#line 157 "pong-radio-group.gob"
	g_return_val_if_fail (value != NULL, (gboolean )0);
#line 491 "pong-radio-group.c"
{
#line 162 "pong-radio-group.gob"
	
		Self *self = SELF(w);
		char *cur_value;

		*value = NULL;

		/* we are requesting a TRUE/FALSE of a specific value */
		if (specifier != NULL) {
			GList *li;

			if (type != PONG_TYPE_BOOL) {
				g_warning (_("Pong:Radio:Group supports only bool"
					     "when a 'specifier' is present"));
				return FALSE;
			}
			for (li = self->_priv->radio_buttons;
			     li != NULL;
			     li = li->next) {
				RadioButton *rb = li->data;
				if (rb->value != NULL &&
				    strcmp (rb->value, specifier) == 0) {
					*value = gconf_value_new (GCONF_VALUE_BOOL);
					gconf_value_set_bool (*value,
							      GTK_TOGGLE_BUTTON(rb->w)->active);
					return TRUE;
				}
			}
			g_warning (_("A specifier that doesn't exist "
				     "requested on Pong:Radio:Group"));
			return FALSE;
		}

		if(type != PONG_TYPE_STRING &&
		   type != PONG_TYPE_INT &&
		   type != PONG_TYPE_FLOAT &&
		   type != PONG_TYPE_BOOL) {
			g_warning(_("Unsupported type on Pong:Radio:Group"));
			return FALSE;
		}

		cur_value = get_cur_value(self);
		if( ! cur_value)
			return FALSE;

		switch(type) {
		case PONG_TYPE_STRING:
			*value = gconf_value_new(GCONF_VALUE_STRING);
			gconf_value_set_string(*value, cur_value);
			break;
		case PONG_TYPE_INT:
			{
				int ret;
				*value = gconf_value_new(GCONF_VALUE_INT);
				sscanf(cur_value, "%d", &ret);
				gconf_value_set_int(*value, ret);
				break;
			}
		case PONG_TYPE_FLOAT:
			{
				double ret;
				*value = gconf_value_new(GCONF_VALUE_FLOAT);
				pong_i18n_push_c_numeric_locale ();
				sscanf(cur_value, "%lf", &ret);
				pong_i18n_pop_c_numeric_locale ();
				gconf_value_set_float(*value, ret);
				break;
			}
		case PONG_TYPE_BOOL:
			*value = gconf_value_new(GCONF_VALUE_BOOL);
			gconf_value_set_bool(*value,
					     pong_bool_from_string(cur_value));
			break;
		default:
			g_assert_not_reached();
			break;
		}

		return TRUE;
	}}
#line 573 "pong-radio-group.c"
#undef __GOB_FUNCTION__

#line 242 "pong-radio-group.gob"
static gboolean 
pong_radio_group_set_value (GtkWidget * w, const char * specifier, GConfValue * value)
#line 579 "pong-radio-group.c"
{
#define __GOB_FUNCTION__ "Pong:Radio:Group::set_value"
#line 242 "pong-radio-group.gob"
	g_return_val_if_fail (w != NULL, (gboolean )0);
#line 242 "pong-radio-group.gob"
	g_return_val_if_fail (GTK_IS_WIDGET (w), (gboolean )0);
#line 242 "pong-radio-group.gob"
	g_return_val_if_fail (value != NULL, (gboolean )0);
#line 588 "pong-radio-group.c"
{
#line 246 "pong-radio-group.gob"
	
		Self *self = SELF(w);
		GList *li;

		/* we are setting a TRUE/FALSE of a specific value */
		if (specifier != NULL) {
			if (value->type != GCONF_VALUE_BOOL) {
				g_warning (_("Pong:Radio:Group supports only bool"
					     "when a 'specifier' is present"));
				return FALSE;
			}
			for (li = self->_priv->radio_buttons;
			     li != NULL;
			     li = li->next) {
				RadioButton *rb = li->data;
				if (rb->value != NULL &&
				    strcmp (rb->value, specifier) == 0) {
					gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (rb->w), 
								      gconf_value_get_bool (value));
					return TRUE;
				}
			}
			g_warning (_("A specifier that doesn't exist "
				     "requested on Pong:Radio:Group"));
			return FALSE;
		}


		if(value->type != GCONF_VALUE_STRING &&
		   value->type != GCONF_VALUE_INT &&
		   value->type != GCONF_VALUE_FLOAT &&
		   value->type != GCONF_VALUE_BOOL) {
			g_warning(_("Unsupported type on Pong:Radio:Group"));
			return FALSE;
		}

		for(li = self->_priv->radio_buttons;
		    li != NULL;
		    li = li->next) {
			RadioButton *rb = li->data;
			switch(value->type) {
			case GCONF_VALUE_STRING:
				if(strcmp(gconf_value_get_string (value), rb->value) == 0) {
					gtk_toggle_button_set_active
						(GTK_TOGGLE_BUTTON (rb->w), TRUE);
					return TRUE;
				}
				break;
			case GCONF_VALUE_INT:
				if (gconf_value_get_int (value) == atoi (rb->value)) {
					gtk_toggle_button_set_active
						(GTK_TOGGLE_BUTTON (rb->w), TRUE);
					return TRUE;
				}
				break;
			case GCONF_VALUE_FLOAT:
				{
					double foo;

					pong_i18n_push_c_numeric_locale ();
					foo = atof(rb->value);
					pong_i18n_pop_c_numeric_locale ();

					/* FIXME: EEEEK! float comparison !!!! */
					if (gconf_value_get_float (value) == foo) {
						gtk_toggle_button_set_active
							(GTK_TOGGLE_BUTTON (rb->w), TRUE);
						return TRUE;
					}
				}
				break;
			case GCONF_VALUE_BOOL:
				/* The reason for the ?: is that comparing bools
				 * directly is evil */
				if ((gconf_value_get_bool (value) ? 1 : 0) ==
				   (pong_bool_from_string (rb->value) ? 1 : 0)) {
					gtk_toggle_button_set_active
						(GTK_TOGGLE_BUTTON (rb->w), TRUE);
					return TRUE;
				}
				break;
			default:
				g_assert_not_reached ();
				break;
			}
		}

		disable_all(self);
		return FALSE;
	}}
#line 681 "pong-radio-group.c"
#undef __GOB_FUNCTION__

#line 337 "pong-radio-group.gob"
static void 
pong_radio_group_add_options (GtkWidget * w, GList * pong_options)
#line 687 "pong-radio-group.c"
{
#define __GOB_FUNCTION__ "Pong:Radio:Group::add_options"
#line 337 "pong-radio-group.gob"
	g_return_if_fail (w != NULL);
#line 337 "pong-radio-group.gob"
	g_return_if_fail (GTK_IS_WIDGET (w));
#line 694 "pong-radio-group.c"
{
#line 340 "pong-radio-group.gob"
	
		Self *self = SELF(w);
		GList *li;
		GtkWidget *lastw = NULL;

		for(li = pong_options; li != NULL; li = li->next) {
			PongOption *opt = li->data;
			RadioButton *rb = g_new0(RadioButton, 1);
			GSList *group = NULL;
			rb->value = g_strdup(opt->value);
			if(lastw)
				group = gtk_radio_button_group(GTK_RADIO_BUTTON(lastw));
			lastw = rb->w =
				gtk_radio_button_new_with_label(group,
								opt->label ?
								opt->label :
								_("???"));
			gtk_signal_connect(GTK_OBJECT(rb->w), "toggled",
					   GTK_SIGNAL_FUNC(button_toggled),
					   self);

			gtk_widget_show(rb->w);
			if(self->_priv->horiz)
				gtk_box_pack_start(GTK_BOX(self->_priv->horiz),
						   rb->w, FALSE, FALSE, 0);
			else
				gtk_box_pack_start(GTK_BOX(self),
						   rb->w, FALSE, FALSE, 0);

			self->_priv->radio_buttons =
				g_list_append(self->_priv->radio_buttons, rb);
		}
	}}
#line 730 "pong-radio-group.c"
#undef __GOB_FUNCTION__

#line 374 "pong-radio-group.gob"
static void 
pong_radio_group_make_horizontal (PongRadioGroup * self)
#line 736 "pong-radio-group.c"
{
#define __GOB_FUNCTION__ "Pong:Radio:Group::make_horizontal"
#line 374 "pong-radio-group.gob"
	g_return_if_fail (self != NULL);
#line 374 "pong-radio-group.gob"
	g_return_if_fail (PONG_IS_RADIO_GROUP (self));
#line 743 "pong-radio-group.c"
{
#line 376 "pong-radio-group.gob"
	
		GList *li;

		g_assert(self->_priv->horiz == NULL);
		self->_priv->horiz = gtk_hbox_new(FALSE, GNOME_PAD_SMALL);
		gtk_widget_show(self->_priv->horiz);
		gtk_box_pack_start(GTK_BOX(self), self->_priv->horiz,
				   FALSE, FALSE, 0);
		
		for(li = self->_priv->radio_buttons;
		    li != NULL;
		    li = li->next) {
			RadioButton *rb = li->data;
			gtk_widget_ref(rb->w);
			gtk_container_remove(GTK_CONTAINER(self), rb->w);
			gtk_box_pack_start(GTK_BOX(self->_priv->horiz),
					   rb->w, FALSE, FALSE, 0);
			gtk_widget_unref(rb->w);
		}
	}}
#line 766 "pong-radio-group.c"
#undef __GOB_FUNCTION__

#line 397 "pong-radio-group.gob"
static void 
pong_radio_group_make_vertical (PongRadioGroup * self)
#line 772 "pong-radio-group.c"
{
#define __GOB_FUNCTION__ "Pong:Radio:Group::make_vertical"
#line 397 "pong-radio-group.gob"
	g_return_if_fail (self != NULL);
#line 397 "pong-radio-group.gob"
	g_return_if_fail (PONG_IS_RADIO_GROUP (self));
#line 779 "pong-radio-group.c"
{
#line 399 "pong-radio-group.gob"
	
		GList *li;

		g_assert(self->_priv->horiz != NULL);

		for(li = self->_priv->radio_buttons;
		    li != NULL;
		    li = li->next) {
			RadioButton *rb = li->data;
			gtk_widget_ref(rb->w);
			gtk_container_remove(GTK_CONTAINER(self->_priv->horiz),
					     rb->w);
			gtk_box_pack_start(GTK_BOX(self), rb->w,
					   FALSE, FALSE, 0);
			gtk_widget_unref(rb->w);
		}

		gtk_widget_destroy(self->_priv->horiz);
		self->_priv->horiz = NULL;
	}}
#line 802 "pong-radio-group.c"
#undef __GOB_FUNCTION__


#if (!defined __GNUC__) || (defined __GNUC__ && defined __STRICT_ANSI__)
/*REALLY BAD HACK
  This is to avoid unused warnings if you don't call
  some method.  I need to find a better way to do
  this, not needed in GCC since we use some gcc
  extentions to make saner, faster code */
static void
___pong_radio_group_really_bad_hack_to_avoid_warnings(void)
{
	((void (*)(void))new)();
	((void (*)(void))new_with_options)();
	((void (*)(void))changed)();
	((void (*)(void))get_cur_value)();
	((void (*)(void))disable_all)();
	((void (*)(void))get_value)();
	((void (*)(void))set_value)();
	((void (*)(void))add_options)();
	((void (*)(void))make_horizontal)();
	((void (*)(void))make_vertical)();
	___pong_radio_group_really_bad_hack_to_avoid_warnings();
}
#endif /* !__GNUC__ || (__GNUC__ && __STRICT_ANSI__) */


#line 421 "pong-radio-group.gob"

static void
free_radio_button(RadioButton *rb)
{
	g_return_if_fail(rb != NULL);

	g_free(rb->value);
	rb->value = NULL; /* paranoia */
	g_free(rb);
}

static void
button_toggled(GtkWidget *w, gpointer data)
{
	changed(SELF(data));
}

#line 848 "pong-radio-group.c"
