# This file is part of pybliographer
# 
# Copyright (C) 1998 Frederic GOBRY
# Email : gobry@idiap.ch
# 	   
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2 
# of the License, or (at your option) any later version.
#   
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details. 
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
# 
# $Id: pybopen.py,v 1.1 1998/11/09 13:01:48 gobry Exp $


import tempfile
from types import *
import os, sys
import traceback
import pyb, pybhelp
import urlparse, urllib

# ----- Generic opening -----

OpeningMethods = []

def register_method (function):
	""
	OpeningMethods.append (function)


pybhelp.register ('bibopen', """
Syntax: database = bibopen (source)

bibopen  tries several  method  to open  `source'  as a  bibliographic
entry. `source'  can be  a simple file  or even  an URL. FTP  and HTTP
files are automatically fetched. One can even create a specific method
for client/server access for example.

One can apply the following commands on the output of bibopen :

 - database.keys () : lists the available entries
 - database ['key'] : returns a given entry
 - del database ['key'] : removes an entry from the file
 - database.where (...) : searches the base (see also `searching')
""")

def bibopen (entity):
	"Generic function to open a bibliographic database"

	# Consider the reference as an URL
	url = list (urlparse.urlparse (entity))

	if url [0] == '':
		url [0] = 'file'
		
	base = None
	for method in OpeningMethods:
		if base == None:
			base = method (url)

	# If one don't know how to retrieve a remote file, do it
	if base == None and (url [0] == 'http' or url [0] == 'ftp'):
		file, header = urllib.urlretrieve (entity)

		url = ['file', '', file, '', '', '']
		for method in OpeningMethods:
			if base == None:
				base = method (url)

		
	if base == None:
		raise IOError, "don't know how to open `" + entity + "'"
    
	return base

