# This file is part of pybliographer
# 
# Copyright (C) 1998 Frederic GOBRY
# Email : gobry@idiap.ch
# 	   
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2 
# of the License, or (at your option) any later version.
#   
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details. 
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
# 
# $Id: Database.py,v 1.4 1999/07/30 12:34:13 gobry Exp $

from Pyblio import Base
from Pyblio.GnomeUI.Config import *
from gtk import *

from string import *

class Database (GtkCList):
    """ Complete database display """
    
    def __init__ (self, fields = None):
        """ Creates a new list of entries """

        fields = fields or DefaultFieldList
        
        self.fields = fields
        lcfields = map (lower, fields)

        GtkCList.__init__ (self, len (self.fields), self.fields)
        
        for c in range (len (self.fields)):
            self.set_column_width (c, fieldwidth (self.fields [c]))

        self.connect ("click_column", self.sort)
        
        self.data = None
        return
    
    # --------------------------------------------------

    def set (self, data):
        self.data = data
        self.access = []
        self.clear ()

        def add_data (entry, self):
            row = []
            et  = entry.type
            
            for f in self.fields:
                lcf = lower (f)
                
                if entry.has_key (lcf):
                    t = Base.gettype (et, f)
                    
                    if t == Base.TypeAuthor:
                        def __toname (author):
                            return str (author.last)
                        text = join (map (__toname, entry [lcf]), ", ")
                    else:
                        text = str (entry [lcf])
                        
                    row.append (text)
                else:
                    row.append ("")

            self.append (row)
            self.access.append (entry.key)

        self.freeze ()
        data.foreach (add_data, self)
        self.thaw ()

    # --------------------------------------------------

    def __getattr__(self, attr):
        if attr == "selection":
            if self.data is None: return
            
            entries = []
            for s in GtkCList.__getattr__ (self, attr):
                entries.append (self.data [self.access [s]])
            return entries
        
        return GtkCList.__getattr__(self, attr)

    def selected_rows (self):
        return GtkCList.__getattr__ (self, 'selection')

        
    def sort (self, widget, column):
        if self.data is None: return
        
        field = lower (self.fields [column])
        keys = self.data.sort (field)
        
        self.set (keys)
        return
        
