# Site configuration

from Pyblio.TextUI import *
from Pyblio.Fields import *
from Pyblio import Base, Autoload

import string

Autoload.register (['', '', '.bib'], 'Pyblio.Format.BibTeX')
Autoload.register (['', '', '.brf'], 'Pyblio.Format.RefDB')

# Available fields

fields = [ "CrossRef", "Key", "Author", "Address_1", "Address_2",
           "Title", "SpecificTitle", "Journal", "Special", "Type", "BookTitle",
           "Subject", "Ownership", "Series", "Editor", "Edition", "Volume",
           "Number", "Chapter", "Pages", "School", "Organization", "Location",
           "Dates", "Institution", "Publisher", "Address", "Format", "Month",
           "Year", "NoSeries", "ConfPlace", "ConfDate", "Cote", "IEEECN",
           "LoCN",
           "ISBN", "ISSN", "Note", "Language", "HowPublished", "To_Appear",
           "From", "Received", "Owner", "KeyWords", "Abstract", "Remarks",
           "IPDmembership", "IPDascii", "IPDpostScript", "IPDhtml", "IPDxref",
           "IPDinAR", "IPDpriority" ]

desc = {}

for f in fields:
    desc [f] = FieldDescription (f)
    Base.Types [string.lower (f)] = desc [f]
    
# Special fields

desc['Author'].type = TypeAuthor
desc['Editor'].type = TypeAuthor

desc['Title'].type         = TypeTitle
desc['SpecificTitle'].type = TypeTitle
desc['BookTitle'].type     = TypeTitle

desc['Year'].type     = TypeDate
desc['ConfDate'].type = TypeDate


# Entry types

entries = {
    "Article" : (('Author', 'Title', 'Journal', 'Year'),
                 ('Volume', 'Number', 'Pages', 'Month', 'Note')),
    
    "Book" : (('Author', 'Editor', 'Title', 'Publisher', 'Year'),
              ( 'Volume', 'Number', 'Series', 'Address', 'Edition',
                'Month', 'Note')),
    
    "Booklet" : (('Title',),
                 ('Author', 'HowPublished', 'Address', 'Month', 'Year',
                  'Note')),
    
    "InBook" : (('Author', 'Editor', 'Title', 'Chapter', 'Pages', 'Publisher',
                 'Year'),
                ('Volume', 'Number', 'Series', 'Type', 'Address', 'Edition',
                 'Month', 'Note')),
    
    "InCollection" : (('Author', 'Title', 'BookTitle', 'Publisher', 'Year', ),
                      ('Editor', 'Volume', 'Number', 'Series', 'Type',
                      'Chapter', 'Pages', 'Address', 'Edition',)),
    
    "InProceedings" : (('Author', 'Title', 'BookTitle', 'Year',),
                       ('Editor', 'Volume', 'Number', 'Series',
                       'Pages', 'Address', 'Month', 'Organization',
                       'Publisher', 'Note')),
    
    "Manual" : (('Title',),
                ('Author', 'Organization', 'Address', 'Edition',
                'Month', 'Year', 'Note',)),
    
    "MastersThesis" : (('Author', 'Title', 'School', 'Year',),
                       ('Type', 'Address', 'Month', 'Note',)),
    
    "Misc" : ((),
              ('Author', 'Title', 'HowPublished', 'Month', 'Year', 'Note',)),
    
    "PhdThesis" : (('Author', 'Title', 'School', 'Year',),
                       ('Type', 'Address', 'Month', 'Note',)),
    
    "Proceedings" : (('Title', 'Year',),
                     ('Editor', 'Volume', 'Number', 'Series',
                     'Address', 'Publisher', 'Note', 'Month',
                      'Organization',)),
    
    "TechReport" : (('Author', 'Title', 'Institution', 'Year',),
                    ('Type', 'Number', 'Address', 'Month', 'Note',)),
    
    "Unpublished" : (('Author', 'Title', 'Note',),
                     ('Month', 'Year',)),
    }

ent = {}
for e in entries.keys ():
    ent [string.lower (e)] = EntryDescription (e)

    ent [string.lower (e)].mandatory = \
        map (lambda x, desc=desc: desc [x], entries [e] [0])
    ent [string.lower (e)].optional  = \
        map (lambda x, desc=desc: desc [x], entries [e] [1])


Base.Entries = ent

from Pyblio.GnomeUI import Config

Config.SearchedFields = ('Author',
                         'Title',
                         'Abstract',
                         'Year',
                         'Note',)
