// $Id: properties.cc,v 1.10 2000/10/31 17:18:22 cactus Exp $

// RadioActive Copyright (C) 1999-2000 RDI Gerg <cactus@cactus.rulez.org>
// 
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2
// (included in the RadioActive distribution in doc/GPL) as published by
// the Free Software Foundation.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

#include "properties.h"

#include "radioactive.h"
#include "file.h"

#define PROGNUM ((arg::progbutton_col) * (arg::progbutton_row))

using namespace Gtk;

Properties::Properties():
    fldStep (*manage (new Gtk::Adjustment (0.1, 0.05, 0.5, 0.05))),
    fldProgbutton_col (*manage (new Gtk::Adjustment (3, 1, 5))),
    fldProgbutton_row (*manage (new Gtk::Adjustment (3, 1, 5))),
    chkMuteExit (_("Mute radio on exit"), 0),
    chkSavePos (_("Save window position"), 0)
{
    VBox* vbox(0);
    Frame* frame(0);
    Label* label(0);
    Table* table(0);
    
    set_title(_("RadioActive properties"));
    close_hides(true);
    apply.connect(slot(this, &Properties::do_apply));
    show.connect(slot(this, &Properties::update));
    
    // ********************
    // Page 1: General
    vbox = new VBox();

    // Device settings
    frame = new Frame(_("Device"));
    table = new Table (2, 2);
    table->set_border_width (5);
    table->set_col_spacings (5);
    
    // Radio device
    fldDev.changed.connect (slot (this, &PropertyBox::changed));   
    label = new Label (_("Radio device:"));
    label->set_alignment (0, 0.5);
    
    table->attach (*manage (label), 0, 1, 0, 1, GTK_FILL);
    table->attach (fldDev, 1, 2, 0, 1);
    
    // Frequency skip
    fldStep.set_digits (2);
    fldStep.set_numeric (true);
    fldStep.changed.connect (slot (this, &PropertyBox::changed));
    label = new Label (_("Tuning step (MHz):"));
    label->set_alignment (0, 0.5);

    table->attach (*manage (label), 0, 1, 1, 2, GTK_FILL);
    table->attach (fldStep, 1, 2, 1, 2);
    
    frame->set_border_width (5);
    frame->add (*manage (table));
    vbox->add  (*manage (frame));

    // User interface
    fldProgbutton_col.changed.connect (slot (this, &PropertyBox::changed));
    fldProgbutton_row.changed.connect (slot (this, &PropertyBox::changed));
    frame = new Frame (_("User interface"));
    table = new Table (2, 3);
    table->set_border_width (5);
    table->set_col_spacings (5);

    label = new Label (_("Number of buttons in a row:"));
    label->set_alignment (0, 0.5);
    table->attach (*manage (label), 0, 1, 0, 1);
    table->attach (fldProgbutton_col, 1, 2, 0, 1);

    label = new Label (_("Number of rows:"));
    label->set_alignment (0, 0.5);
    table->attach (*manage (label), 0, 1, 1, 2);
    table->attach (fldProgbutton_row, 1, 2, 1, 2);

    label = new Label (_("Applying requires restarting RadioActive"));
    table->attach (*manage (label), 0, 2, 2, 3);

    frame->set_border_width (5);
    frame->add (*manage (table));
    vbox->add  (*manage (frame));

    // Persistency
    chkMuteExit.clicked.connect(
	slot(this, &PropertyBox::changed));
    chkSavePos.clicked.connect(
	slot(this, &PropertyBox::changed));
    frame = new Frame(_("Miscellaneous"));
    VBox* options_vbox = new VBox();
    
    options_vbox->set_border_width(5);
    options_vbox->set_spacing(5);
    options_vbox->pack_start(chkMuteExit, false);
    options_vbox->pack_start(chkSavePos, false);
    frame->set_border_width(5);
    frame->add(*manage(options_vbox));
    vbox->add(*manage(frame));
    
    // End of Page 1
    vbox->show_all();
    pageGeneral = append_page(*manage(vbox), *manage(new Label(_("General"))));

    // ********************
    // Page 2: Stations
    frame = new Frame();
    vbox = new VBox();
    table = new Table(3, arg::progbutton_row * arg::progbutton_col);
    ScrolledWindow* view = new ScrolledWindow();
    
    frame->set_border_width(5);
    table->set_border_width(5);
    view->set_usize(0, 100);

    prog_val = new Entry*[PROGNUM];
    prog_name = new Entry*[PROGNUM];
    for (int i = 0; i < PROGNUM; i++)
    {
	gchar* int_to_str = g_strdup_printf("%d", (i + 1));
	label = new Label(int_to_str);
	g_free(int_to_str);
	prog_val[i] = new Entry();
	prog_name[i] = new Entry();
	prog_val[i]->changed.connect(
	    slot(this, &PropertyBox::changed));
	prog_name[i]->changed.connect(
	    slot(this, &PropertyBox::changed));
	
	table->attach(*manage(label),        0, 1, i, i + 1);
	table->attach(*manage(prog_val[i]),  1, 2, i, i + 1);
	table->attach(*manage(prog_name[i]), 2, 3, i, i + 1);
    }
    
    table->set_col_spacing(1, 5);
    view->add_with_viewport(*manage(table));
    view->set_policy(GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
    frame->add(*manage(view));
    vbox->add(*manage(frame));
    vbox->show_all();
    pageStations = append_page(*manage(vbox),
			       *manage(new Label(_("Stations"))));
}

void Properties::do_apply(int page)
{
    vector<pair<float, string> > new_stations (PROGNUM, pair<float, string>(0, ""));
    
    if (page == pageGeneral)
    {
	arg::mute_exit = chkMuteExit.get_active();
	arg::save_pos = chkSavePos.get_active();
	arg::tune_step = fldStep.get_value_as_float ();
	arg::progbutton_col = fldProgbutton_col.get_value_as_int ();
	arg::progbutton_row = fldProgbutton_row.get_value_as_int ();
	device_change(fldDev.get_text());
    }
    if (page == pageStations)
    {
	for (int i = 0; i < PROGNUM; i++)
	{
	    float stat_val = atof(prog_val[i]->get_text().c_str());
	    string stat_name = prog_name[i]->get_text();
	    new_stations[i] = pair<float, string>(stat_val, stat_name);
	}
	station_change(new_stations);
    }
}

void Properties::set_stations(const vector<pair<float, string> > stations)
{
    station_data = stations;
}

void Properties::update()
{
    fldDev.set_text (arg::devfile);
    fldStep.set_value (arg::tune_step);
    fldProgbutton_col.set_value (arg::progbutton_col);
    fldProgbutton_row.set_value (arg::progbutton_row);
    chkMuteExit.set_active(arg::mute_exit);
    chkSavePos.set_active(arg::save_pos);
    
    gchar* tmp = 0;
    for (unsigned int i = 0; i < station_data.size(); i++)
    {
	tmp = g_strdup_printf("%.1f", station_data[i].first);
	prog_val[i]->set_text(tmp);
	g_free(tmp);
	prog_name[i]->set_text(station_data[i].second);
    }
    set_modified(false);
}
