/* module.c generated by valac 0.35.5, the Vala compiler
 * generated from module.vala, do not modify */

/* This file is part of retro-gtk. License: GPLv3*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <gio/gio.h>
#include <gmodule.h>
#include <stdio.h>


#define RETRO_TYPE_SYSTEM_INFO (retro_system_info_get_type ())
typedef struct _RetroSystemInfo RetroSystemInfo;

#define RETRO_TYPE_SYSTEM_AV_INFO (retro_system_av_info_get_type ())

#define RETRO_TYPE_GAME_GEOMETRY (retro_game_geometry_get_type ())
typedef struct _RetroGameGeometry RetroGameGeometry;

#define RETRO_TYPE_SYSTEM_TIMING (retro_system_timing_get_type ())
typedef struct _RetroSystemTiming RetroSystemTiming;
typedef struct _RetroSystemAvInfo RetroSystemAvInfo;

#define RETRO_TYPE_DEVICE_TYPE (retro_device_type_get_type ())

#define RETRO_TYPE_GAME_INFO (retro_game_info_get_type ())
typedef struct _RetroGameInfo RetroGameInfo;

#define RETRO_TYPE_MEMORY_TYPE (retro_memory_type_get_type ())

#define RETRO_TYPE_MODULE (retro_module_get_type ())
#define RETRO_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RETRO_TYPE_MODULE, RetroModule))
#define RETRO_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RETRO_TYPE_MODULE, RetroModuleClass))
#define RETRO_IS_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RETRO_TYPE_MODULE))
#define RETRO_IS_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RETRO_TYPE_MODULE))
#define RETRO_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RETRO_TYPE_MODULE, RetroModuleClass))

typedef struct _RetroModule RetroModule;
typedef struct _RetroModuleClass RetroModuleClass;
typedef struct _RetroModulePrivate RetroModulePrivate;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_module_close0(var) ((var == NULL) ? NULL : (var = (g_module_close (var), NULL)))

typedef void (*RetroCallbackSetter) (void* cb);
typedef void (*RetroInit) ();
typedef void (*RetroDeinit) ();
typedef guint (*RetroApiVersion) ();
struct _RetroSystemInfo {
	gchar* library_name;
	gchar* library_version;
	gchar* valid_extensions;
	gboolean need_fullpath;
	gboolean block_extract;
};

typedef void (*RetroGetSystemInfo) (RetroSystemInfo* info);
struct _RetroGameGeometry {
	guint base_width;
	guint base_height;
	guint max_width;
	guint max_height;
	gfloat aspect_ratio;
};

struct _RetroSystemTiming {
	gdouble fps;
	gdouble sample_rate;
};

struct _RetroSystemAvInfo {
	RetroGameGeometry geometry;
	RetroSystemTiming timing;
};

typedef void (*RetroGetSystemAvInfo) (RetroSystemAvInfo* info);
typedef enum  {
	RETRO_DEVICE_TYPE_TYPE_MASK = 0xff,
	RETRO_DEVICE_TYPE_NONE = 0,
	RETRO_DEVICE_TYPE_JOYPAD = 1,
	RETRO_DEVICE_TYPE_MOUSE = 2,
	RETRO_DEVICE_TYPE_KEYBOARD = 3,
	RETRO_DEVICE_TYPE_LIGHTGUN = 4,
	RETRO_DEVICE_TYPE_ANALOG = 5,
	RETRO_DEVICE_TYPE_POINTER = 6
} RetroDeviceType;

typedef void (*RetroSetControllerPortDevice) (guint port, RetroDeviceType device);
typedef void (*RetroReset) ();
typedef void (*RetroRun) ();
typedef gsize (*RetroSerializeSize) ();
typedef gboolean (*RetroSerialize) (guint8* data, int data_length1);
typedef gboolean (*RetroUnserialize) (guint8* data, int data_length1);
struct _RetroGameInfo {
	gchar* path;
	guint8* data;
	gint data_length1;
	gchar* meta;
};

typedef gboolean (*RetroLoadGame) (RetroGameInfo* game);
typedef void (*RetroUnloadGame) ();
typedef enum  {
	RETRO_MEMORY_TYPE_TYPE_MASK = 0xff,
	RETRO_MEMORY_TYPE_SAVE_RAM = 0,
	RETRO_MEMORY_TYPE_RTC = 1,
	RETRO_MEMORY_TYPE_SYSTEM_RAM = 2,
	RETRO_MEMORY_TYPE_VIDEO_RAM = 3,
	RETRO_MEMORY_TYPE_SNES_BSX_RAM = (1 << 8) | RETRO_MEMORY_TYPE_SAVE_RAM,
	RETRO_MEMORY_TYPE_SNES_BSX_PRAM = (2 << 8) | RETRO_MEMORY_TYPE_SAVE_RAM,
	RETRO_MEMORY_TYPE_SNES_SUFAMI_TURBO_A_RAM = (3 << 8) | RETRO_MEMORY_TYPE_SAVE_RAM,
	RETRO_MEMORY_TYPE_SNES_SUFAMI_TURBO_B_RAM = (4 << 8) | RETRO_MEMORY_TYPE_SAVE_RAM,
	RETRO_MEMORY_TYPE_SNES_GAME_BOY_RAM = (5 << 8) | RETRO_MEMORY_TYPE_SAVE_RAM,
	RETRO_MEMORY_TYPE_SNES_GAME_BOY_RTC = (6 << 8) | RETRO_MEMORY_TYPE_RTC
} RetroMemoryType;

typedef void* (*RetroGetMemoryData) (RetroMemoryType id);
typedef gsize (*RetroGetMemorySize) (RetroMemoryType id);
struct _RetroModule {
	GObject parent_instance;
	RetroModulePrivate * priv;
	GFile* tmp_file;
};

struct _RetroModuleClass {
	GObjectClass parent_class;
};

struct _RetroModulePrivate {
	gchar* _file_name;
	gboolean is_a_copy;
	GModule* module;
	RetroCallbackSetter _set_environment;
	RetroCallbackSetter _set_video_refresh;
	RetroCallbackSetter _set_audio_sample;
	RetroCallbackSetter _set_audio_sample_batch;
	RetroCallbackSetter _set_input_poll;
	RetroCallbackSetter _set_input_state;
	RetroInit _init;
	RetroDeinit _deinit;
	RetroApiVersion _api_version;
	RetroGetSystemInfo _get_system_info;
	RetroGetSystemAvInfo _get_system_av_info;
	RetroSetControllerPortDevice _set_controller_port_device;
	RetroReset _reset;
	RetroRun _run;
	RetroSerializeSize _serialize_size;
	RetroSerialize _serialize;
	RetroUnserialize _unserialize;
	RetroLoadGame _load_game;
	RetroUnloadGame _unload_game;
	RetroGetMemoryData _get_memory_data;
	RetroGetMemorySize _get_memory_size;
};


static gpointer retro_module_parent_class = NULL;
static GHashTable* retro_module_loaded_modules;
static GHashTable* retro_module_loaded_modules = NULL;

GType retro_system_info_get_type (void) G_GNUC_CONST;
RetroSystemInfo* retro_system_info_dup (const RetroSystemInfo* self);
void retro_system_info_free (RetroSystemInfo* self);
void retro_system_info_copy (const RetroSystemInfo* self, RetroSystemInfo* dest);
void retro_system_info_destroy (RetroSystemInfo* self);
GType retro_system_av_info_get_type (void) G_GNUC_CONST;
GType retro_game_geometry_get_type (void) G_GNUC_CONST;
RetroGameGeometry* retro_game_geometry_dup (const RetroGameGeometry* self);
void retro_game_geometry_free (RetroGameGeometry* self);
GType retro_system_timing_get_type (void) G_GNUC_CONST;
RetroSystemTiming* retro_system_timing_dup (const RetroSystemTiming* self);
void retro_system_timing_free (RetroSystemTiming* self);
RetroSystemAvInfo* retro_system_av_info_dup (const RetroSystemAvInfo* self);
void retro_system_av_info_free (RetroSystemAvInfo* self);
GType retro_device_type_get_type (void) G_GNUC_CONST;
GType retro_game_info_get_type (void) G_GNUC_CONST;
RetroGameInfo* retro_game_info_dup (const RetroGameInfo* self);
void retro_game_info_free (RetroGameInfo* self);
void retro_game_info_copy (const RetroGameInfo* self, RetroGameInfo* dest);
void retro_game_info_destroy (RetroGameInfo* self);
GType retro_memory_type_get_type (void) G_GNUC_CONST;
GType retro_module_get_type (void) G_GNUC_CONST;
#define RETRO_MODULE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RETRO_TYPE_MODULE, RetroModulePrivate))
enum  {
	RETRO_MODULE_DUMMY_PROPERTY,
	RETRO_MODULE_FILE_NAME,
	RETRO_MODULE_SET_ENVIRONMENT,
	RETRO_MODULE_SET_VIDEO_REFRESH,
	RETRO_MODULE_SET_AUDIO_SAMPLE,
	RETRO_MODULE_SET_AUDIO_SAMPLE_BATCH,
	RETRO_MODULE_SET_INPUT_POLL,
	RETRO_MODULE_SET_INPUT_STATE,
	RETRO_MODULE_INIT,
	RETRO_MODULE_DEINIT,
	RETRO_MODULE_API_VERSION,
	RETRO_MODULE_GET_SYSTEM_INFO,
	RETRO_MODULE_GET_SYSTEM_AV_INFO,
	RETRO_MODULE_SET_CONTROLLER_PORT_DEVICE,
	RETRO_MODULE_RESET,
	RETRO_MODULE_RUN,
	RETRO_MODULE_SERIALIZE_SIZE,
	RETRO_MODULE_SERIALIZE,
	RETRO_MODULE_UNSERIALIZE,
	RETRO_MODULE_LOAD_GAME,
	RETRO_MODULE_UNLOAD_GAME,
	RETRO_MODULE_GET_MEMORY_DATA,
	RETRO_MODULE_GET_MEMORY_SIZE
};
const gchar* retro_module_get_file_name (RetroModule* self);
static void _g_free0_ (gpointer var);
RetroModule* retro_module_new (const gchar* file_name);
RetroModule* retro_module_construct (GType object_type, const gchar* file_name);
static void retro_module_set_file_name (RetroModule* self, const gchar* value);
RetroCallbackSetter retro_module_get_set_environment (RetroModule* self);
static void retro_module_set_set_environment (RetroModule* self, RetroCallbackSetter value);
RetroCallbackSetter retro_module_get_set_video_refresh (RetroModule* self);
static void retro_module_set_set_video_refresh (RetroModule* self, RetroCallbackSetter value);
RetroCallbackSetter retro_module_get_set_audio_sample (RetroModule* self);
static void retro_module_set_set_audio_sample (RetroModule* self, RetroCallbackSetter value);
RetroCallbackSetter retro_module_get_set_audio_sample_batch (RetroModule* self);
static void retro_module_set_set_audio_sample_batch (RetroModule* self, RetroCallbackSetter value);
RetroCallbackSetter retro_module_get_set_input_poll (RetroModule* self);
static void retro_module_set_set_input_poll (RetroModule* self, RetroCallbackSetter value);
RetroCallbackSetter retro_module_get_set_input_state (RetroModule* self);
static void retro_module_set_set_input_state (RetroModule* self, RetroCallbackSetter value);
RetroInit retro_module_get_init (RetroModule* self);
static void retro_module_set_init (RetroModule* self, RetroInit value);
RetroDeinit retro_module_get_deinit (RetroModule* self);
static void retro_module_set_deinit (RetroModule* self, RetroDeinit value);
RetroApiVersion retro_module_get_api_version (RetroModule* self);
static void retro_module_set_api_version (RetroModule* self, RetroApiVersion value);
RetroGetSystemInfo retro_module_get_get_system_info (RetroModule* self);
static void retro_module_set_get_system_info (RetroModule* self, RetroGetSystemInfo value);
RetroGetSystemAvInfo retro_module_get_get_system_av_info (RetroModule* self);
static void retro_module_set_get_system_av_info (RetroModule* self, RetroGetSystemAvInfo value);
RetroSetControllerPortDevice retro_module_get_set_controller_port_device (RetroModule* self);
static void retro_module_set_set_controller_port_device (RetroModule* self, RetroSetControllerPortDevice value);
RetroReset retro_module_get_reset (RetroModule* self);
static void retro_module_set_reset (RetroModule* self, RetroReset value);
RetroRun retro_module_get_run (RetroModule* self);
static void retro_module_set_run (RetroModule* self, RetroRun value);
RetroSerializeSize retro_module_get_serialize_size (RetroModule* self);
static void retro_module_set_serialize_size (RetroModule* self, RetroSerializeSize value);
RetroSerialize retro_module_get_serialize (RetroModule* self);
static void retro_module_set_serialize (RetroModule* self, RetroSerialize value);
RetroUnserialize retro_module_get_unserialize (RetroModule* self);
static void retro_module_set_unserialize (RetroModule* self, RetroUnserialize value);
RetroLoadGame retro_module_get_load_game (RetroModule* self);
static void retro_module_set_load_game (RetroModule* self, RetroLoadGame value);
RetroUnloadGame retro_module_get_unload_game (RetroModule* self);
static void retro_module_set_unload_game (RetroModule* self, RetroUnloadGame value);
RetroGetMemoryData retro_module_get_get_memory_data (RetroModule* self);
static void retro_module_set_get_memory_data (RetroModule* self, RetroGetMemoryData value);
RetroGetMemorySize retro_module_get_get_memory_size (RetroModule* self);
static void retro_module_set_get_memory_size (RetroModule* self, RetroGetMemorySize value);
static GObject * retro_module_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void retro_module_finalize (GObject * obj);
static void _vala_retro_module_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_retro_module_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


/**
 * Create a Module from the file name of a Libretro implementation.
 *
 * The file must be a dynamically loadable shared object implementing the
 * same version of the Libretro API as Retro.
 *
 * @param file_name the file name of the Libretro implementation to load
 */
RetroModule* retro_module_construct (GType object_type, const gchar* file_name) {
	RetroModule * self = NULL;
	const gchar* _tmp0_;
	g_return_val_if_fail (file_name != NULL, NULL);
	_tmp0_ = file_name;
	self = (RetroModule*) g_object_new (object_type, "file-name", _tmp0_, NULL);
	return self;
}


RetroModule* retro_module_new (const gchar* file_name) {
	return retro_module_construct (RETRO_TYPE_MODULE, file_name);
}


const gchar* retro_module_get_file_name (RetroModule* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_file_name;
	result = _tmp0_;
	return result;
}


static void retro_module_set_file_name (RetroModule* self, const gchar* value) {
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, retro_module_get_file_name (self)) != 0) {
		const gchar* _tmp0_;
		gchar* _tmp1_;
		_tmp0_ = value;
		_tmp1_ = g_strdup (_tmp0_);
		_g_free0 (self->priv->_file_name);
		self->priv->_file_name = _tmp1_;
		g_object_notify ((GObject *) self, "file-name");
	}
}


RetroCallbackSetter retro_module_get_set_environment (RetroModule* self) {
	RetroCallbackSetter result;
	RetroCallbackSetter _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_set_environment;
	result = _tmp0_;
	return result;
}


static void retro_module_set_set_environment (RetroModule* self, RetroCallbackSetter value) {
	g_return_if_fail (self != NULL);
	if (retro_module_get_set_environment (self) != value) {
		RetroCallbackSetter _tmp0_;
		_tmp0_ = value;
		self->priv->_set_environment = _tmp0_;
		g_object_notify ((GObject *) self, "set-environment");
	}
}


RetroCallbackSetter retro_module_get_set_video_refresh (RetroModule* self) {
	RetroCallbackSetter result;
	RetroCallbackSetter _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_set_video_refresh;
	result = _tmp0_;
	return result;
}


static void retro_module_set_set_video_refresh (RetroModule* self, RetroCallbackSetter value) {
	g_return_if_fail (self != NULL);
	if (retro_module_get_set_video_refresh (self) != value) {
		RetroCallbackSetter _tmp0_;
		_tmp0_ = value;
		self->priv->_set_video_refresh = _tmp0_;
		g_object_notify ((GObject *) self, "set-video-refresh");
	}
}


RetroCallbackSetter retro_module_get_set_audio_sample (RetroModule* self) {
	RetroCallbackSetter result;
	RetroCallbackSetter _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_set_audio_sample;
	result = _tmp0_;
	return result;
}


static void retro_module_set_set_audio_sample (RetroModule* self, RetroCallbackSetter value) {
	g_return_if_fail (self != NULL);
	if (retro_module_get_set_audio_sample (self) != value) {
		RetroCallbackSetter _tmp0_;
		_tmp0_ = value;
		self->priv->_set_audio_sample = _tmp0_;
		g_object_notify ((GObject *) self, "set-audio-sample");
	}
}


RetroCallbackSetter retro_module_get_set_audio_sample_batch (RetroModule* self) {
	RetroCallbackSetter result;
	RetroCallbackSetter _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_set_audio_sample_batch;
	result = _tmp0_;
	return result;
}


static void retro_module_set_set_audio_sample_batch (RetroModule* self, RetroCallbackSetter value) {
	g_return_if_fail (self != NULL);
	if (retro_module_get_set_audio_sample_batch (self) != value) {
		RetroCallbackSetter _tmp0_;
		_tmp0_ = value;
		self->priv->_set_audio_sample_batch = _tmp0_;
		g_object_notify ((GObject *) self, "set-audio-sample-batch");
	}
}


RetroCallbackSetter retro_module_get_set_input_poll (RetroModule* self) {
	RetroCallbackSetter result;
	RetroCallbackSetter _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_set_input_poll;
	result = _tmp0_;
	return result;
}


static void retro_module_set_set_input_poll (RetroModule* self, RetroCallbackSetter value) {
	g_return_if_fail (self != NULL);
	if (retro_module_get_set_input_poll (self) != value) {
		RetroCallbackSetter _tmp0_;
		_tmp0_ = value;
		self->priv->_set_input_poll = _tmp0_;
		g_object_notify ((GObject *) self, "set-input-poll");
	}
}


RetroCallbackSetter retro_module_get_set_input_state (RetroModule* self) {
	RetroCallbackSetter result;
	RetroCallbackSetter _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_set_input_state;
	result = _tmp0_;
	return result;
}


static void retro_module_set_set_input_state (RetroModule* self, RetroCallbackSetter value) {
	g_return_if_fail (self != NULL);
	if (retro_module_get_set_input_state (self) != value) {
		RetroCallbackSetter _tmp0_;
		_tmp0_ = value;
		self->priv->_set_input_state = _tmp0_;
		g_object_notify ((GObject *) self, "set-input-state");
	}
}


RetroInit retro_module_get_init (RetroModule* self) {
	RetroInit result;
	RetroInit _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_init;
	result = _tmp0_;
	return result;
}


static void retro_module_set_init (RetroModule* self, RetroInit value) {
	g_return_if_fail (self != NULL);
	if (retro_module_get_init (self) != value) {
		RetroInit _tmp0_;
		_tmp0_ = value;
		self->priv->_init = _tmp0_;
		g_object_notify ((GObject *) self, "init");
	}
}


RetroDeinit retro_module_get_deinit (RetroModule* self) {
	RetroDeinit result;
	RetroDeinit _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_deinit;
	result = _tmp0_;
	return result;
}


static void retro_module_set_deinit (RetroModule* self, RetroDeinit value) {
	g_return_if_fail (self != NULL);
	if (retro_module_get_deinit (self) != value) {
		RetroDeinit _tmp0_;
		_tmp0_ = value;
		self->priv->_deinit = _tmp0_;
		g_object_notify ((GObject *) self, "deinit");
	}
}


RetroApiVersion retro_module_get_api_version (RetroModule* self) {
	RetroApiVersion result;
	RetroApiVersion _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_api_version;
	result = _tmp0_;
	return result;
}


static void retro_module_set_api_version (RetroModule* self, RetroApiVersion value) {
	g_return_if_fail (self != NULL);
	if (retro_module_get_api_version (self) != value) {
		RetroApiVersion _tmp0_;
		_tmp0_ = value;
		self->priv->_api_version = _tmp0_;
		g_object_notify ((GObject *) self, "api-version");
	}
}


RetroGetSystemInfo retro_module_get_get_system_info (RetroModule* self) {
	RetroGetSystemInfo result;
	RetroGetSystemInfo _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_get_system_info;
	result = _tmp0_;
	return result;
}


static void retro_module_set_get_system_info (RetroModule* self, RetroGetSystemInfo value) {
	g_return_if_fail (self != NULL);
	if (retro_module_get_get_system_info (self) != value) {
		RetroGetSystemInfo _tmp0_;
		_tmp0_ = value;
		self->priv->_get_system_info = _tmp0_;
		g_object_notify ((GObject *) self, "get-system-info");
	}
}


RetroGetSystemAvInfo retro_module_get_get_system_av_info (RetroModule* self) {
	RetroGetSystemAvInfo result;
	RetroGetSystemAvInfo _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_get_system_av_info;
	result = _tmp0_;
	return result;
}


static void retro_module_set_get_system_av_info (RetroModule* self, RetroGetSystemAvInfo value) {
	g_return_if_fail (self != NULL);
	if (retro_module_get_get_system_av_info (self) != value) {
		RetroGetSystemAvInfo _tmp0_;
		_tmp0_ = value;
		self->priv->_get_system_av_info = _tmp0_;
		g_object_notify ((GObject *) self, "get-system-av-info");
	}
}


RetroSetControllerPortDevice retro_module_get_set_controller_port_device (RetroModule* self) {
	RetroSetControllerPortDevice result;
	RetroSetControllerPortDevice _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_set_controller_port_device;
	result = _tmp0_;
	return result;
}


static void retro_module_set_set_controller_port_device (RetroModule* self, RetroSetControllerPortDevice value) {
	g_return_if_fail (self != NULL);
	if (retro_module_get_set_controller_port_device (self) != value) {
		RetroSetControllerPortDevice _tmp0_;
		_tmp0_ = value;
		self->priv->_set_controller_port_device = _tmp0_;
		g_object_notify ((GObject *) self, "set-controller-port-device");
	}
}


RetroReset retro_module_get_reset (RetroModule* self) {
	RetroReset result;
	RetroReset _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_reset;
	result = _tmp0_;
	return result;
}


static void retro_module_set_reset (RetroModule* self, RetroReset value) {
	g_return_if_fail (self != NULL);
	if (retro_module_get_reset (self) != value) {
		RetroReset _tmp0_;
		_tmp0_ = value;
		self->priv->_reset = _tmp0_;
		g_object_notify ((GObject *) self, "reset");
	}
}


RetroRun retro_module_get_run (RetroModule* self) {
	RetroRun result;
	RetroRun _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_run;
	result = _tmp0_;
	return result;
}


static void retro_module_set_run (RetroModule* self, RetroRun value) {
	g_return_if_fail (self != NULL);
	if (retro_module_get_run (self) != value) {
		RetroRun _tmp0_;
		_tmp0_ = value;
		self->priv->_run = _tmp0_;
		g_object_notify ((GObject *) self, "run");
	}
}


RetroSerializeSize retro_module_get_serialize_size (RetroModule* self) {
	RetroSerializeSize result;
	RetroSerializeSize _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_serialize_size;
	result = _tmp0_;
	return result;
}


static void retro_module_set_serialize_size (RetroModule* self, RetroSerializeSize value) {
	g_return_if_fail (self != NULL);
	if (retro_module_get_serialize_size (self) != value) {
		RetroSerializeSize _tmp0_;
		_tmp0_ = value;
		self->priv->_serialize_size = _tmp0_;
		g_object_notify ((GObject *) self, "serialize-size");
	}
}


RetroSerialize retro_module_get_serialize (RetroModule* self) {
	RetroSerialize result;
	RetroSerialize _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_serialize;
	result = _tmp0_;
	return result;
}


static void retro_module_set_serialize (RetroModule* self, RetroSerialize value) {
	g_return_if_fail (self != NULL);
	if (retro_module_get_serialize (self) != value) {
		RetroSerialize _tmp0_;
		_tmp0_ = value;
		self->priv->_serialize = _tmp0_;
		g_object_notify ((GObject *) self, "serialize");
	}
}


RetroUnserialize retro_module_get_unserialize (RetroModule* self) {
	RetroUnserialize result;
	RetroUnserialize _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_unserialize;
	result = _tmp0_;
	return result;
}


static void retro_module_set_unserialize (RetroModule* self, RetroUnserialize value) {
	g_return_if_fail (self != NULL);
	if (retro_module_get_unserialize (self) != value) {
		RetroUnserialize _tmp0_;
		_tmp0_ = value;
		self->priv->_unserialize = _tmp0_;
		g_object_notify ((GObject *) self, "unserialize");
	}
}


RetroLoadGame retro_module_get_load_game (RetroModule* self) {
	RetroLoadGame result;
	RetroLoadGame _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_load_game;
	result = _tmp0_;
	return result;
}


static void retro_module_set_load_game (RetroModule* self, RetroLoadGame value) {
	g_return_if_fail (self != NULL);
	if (retro_module_get_load_game (self) != value) {
		RetroLoadGame _tmp0_;
		_tmp0_ = value;
		self->priv->_load_game = _tmp0_;
		g_object_notify ((GObject *) self, "load-game");
	}
}


RetroUnloadGame retro_module_get_unload_game (RetroModule* self) {
	RetroUnloadGame result;
	RetroUnloadGame _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_unload_game;
	result = _tmp0_;
	return result;
}


static void retro_module_set_unload_game (RetroModule* self, RetroUnloadGame value) {
	g_return_if_fail (self != NULL);
	if (retro_module_get_unload_game (self) != value) {
		RetroUnloadGame _tmp0_;
		_tmp0_ = value;
		self->priv->_unload_game = _tmp0_;
		g_object_notify ((GObject *) self, "unload-game");
	}
}


RetroGetMemoryData retro_module_get_get_memory_data (RetroModule* self) {
	RetroGetMemoryData result;
	RetroGetMemoryData _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_get_memory_data;
	result = _tmp0_;
	return result;
}


static void retro_module_set_get_memory_data (RetroModule* self, RetroGetMemoryData value) {
	g_return_if_fail (self != NULL);
	if (retro_module_get_get_memory_data (self) != value) {
		RetroGetMemoryData _tmp0_;
		_tmp0_ = value;
		self->priv->_get_memory_data = _tmp0_;
		g_object_notify ((GObject *) self, "get-memory-data");
	}
}


RetroGetMemorySize retro_module_get_get_memory_size (RetroModule* self) {
	RetroGetMemorySize result;
	RetroGetMemorySize _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_get_memory_size;
	result = _tmp0_;
	return result;
}


static void retro_module_set_get_memory_size (RetroModule* self, RetroGetMemorySize value) {
	g_return_if_fail (self != NULL);
	if (retro_module_get_get_memory_size (self) != value) {
		RetroGetMemorySize _tmp0_;
		_tmp0_ = value;
		self->priv->_get_memory_size = _tmp0_;
		g_object_notify ((GObject *) self, "get-memory-size");
	}
}


static GObject * retro_module_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	RetroModule * self;
	const gchar* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* loaded_file_name;
	GHashTable* _tmp7_;
	const gchar* _tmp8_;
	gboolean _tmp9_;
	const gchar* _tmp35_;
	GModule* _tmp36_;
	void* function = NULL;
	GModule* _tmp37_;
	void* _tmp38_ = NULL;
	void* _tmp39_;
	GModule* _tmp40_;
	void* _tmp41_ = NULL;
	void* _tmp42_;
	GModule* _tmp43_;
	void* _tmp44_ = NULL;
	void* _tmp45_;
	GModule* _tmp46_;
	void* _tmp47_ = NULL;
	void* _tmp48_;
	GModule* _tmp49_;
	void* _tmp50_ = NULL;
	void* _tmp51_;
	GModule* _tmp52_;
	void* _tmp53_ = NULL;
	void* _tmp54_;
	GModule* _tmp55_;
	void* _tmp56_ = NULL;
	void* _tmp57_;
	GModule* _tmp58_;
	void* _tmp59_ = NULL;
	void* _tmp60_;
	GModule* _tmp61_;
	void* _tmp62_ = NULL;
	void* _tmp63_;
	GModule* _tmp64_;
	void* _tmp65_ = NULL;
	void* _tmp66_;
	GModule* _tmp67_;
	void* _tmp68_ = NULL;
	void* _tmp69_;
	GModule* _tmp70_;
	void* _tmp71_ = NULL;
	void* _tmp72_;
	GModule* _tmp73_;
	void* _tmp74_ = NULL;
	void* _tmp75_;
	GModule* _tmp76_;
	void* _tmp77_ = NULL;
	void* _tmp78_;
	GModule* _tmp79_;
	void* _tmp80_ = NULL;
	void* _tmp81_;
	GModule* _tmp82_;
	void* _tmp83_ = NULL;
	void* _tmp84_;
	GModule* _tmp85_;
	void* _tmp86_ = NULL;
	void* _tmp87_;
	GModule* _tmp88_;
	void* _tmp89_ = NULL;
	void* _tmp90_;
	GModule* _tmp91_;
	void* _tmp92_ = NULL;
	void* _tmp93_;
	GModule* _tmp94_;
	void* _tmp95_ = NULL;
	void* _tmp96_;
	GModule* _tmp97_;
	void* _tmp98_ = NULL;
	void* _tmp99_;
	GError * _inner_error_ = NULL;
	parent_class = G_OBJECT_CLASS (retro_module_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RETRO_TYPE_MODULE, RetroModule);
	_tmp0_ = self->priv->_file_name;
	_tmp1_ = g_file_new_for_path (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_file_resolve_relative_path (_tmp2_, "");
	_tmp4_ = _tmp3_;
	_tmp5_ = g_file_get_path (_tmp4_);
	_tmp6_ = _tmp5_;
	retro_module_set_file_name (self, _tmp6_);
	_g_free0 (_tmp6_);
	_g_object_unref0 (_tmp4_);
	_g_object_unref0 (_tmp2_);
	_g_object_unref0 (self->tmp_file);
	self->tmp_file = NULL;
	self->priv->is_a_copy = FALSE;
	loaded_file_name = NULL;
	_tmp7_ = retro_module_loaded_modules;
	_tmp8_ = self->priv->_file_name;
	_tmp9_ = g_hash_table_contains (_tmp7_, _tmp8_);
	if (_tmp9_) {
		{
			GFile* file;
			const gchar* _tmp10_;
			GFile* _tmp11_;
			GFileIOStream* ios = NULL;
			GFile* _tmp12_;
			GFileIOStream* _tmp13_ = NULL;
			GFile* _tmp14_;
			GFile* _tmp15_;
			GFile* _tmp16_;
			GFile* _tmp17_;
			GFile* _tmp18_;
			gchar* _tmp19_;
			_tmp10_ = self->priv->_file_name;
			_tmp11_ = g_file_new_for_path (_tmp10_);
			file = _tmp11_;
			_tmp14_ = g_file_new_tmp (NULL, &_tmp13_, &_inner_error_);
			_g_object_unref0 (ios);
			ios = _tmp13_;
			_tmp12_ = _tmp14_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_g_object_unref0 (ios);
				_g_object_unref0 (file);
				goto __catch1_g_error;
			}
			_tmp15_ = _tmp12_;
			_tmp12_ = NULL;
			_g_object_unref0 (self->tmp_file);
			self->tmp_file = _tmp15_;
			_tmp16_ = file;
			_tmp17_ = self->tmp_file;
			g_file_copy (_tmp16_, _tmp17_, G_FILE_COPY_OVERWRITE, NULL, NULL, NULL, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_g_object_unref0 (_tmp12_);
				_g_object_unref0 (ios);
				_g_object_unref0 (file);
				goto __catch1_g_error;
			}
			self->priv->is_a_copy = TRUE;
			_tmp18_ = self->tmp_file;
			_tmp19_ = g_file_get_path (_tmp18_);
			_g_free0 (loaded_file_name);
			loaded_file_name = _tmp19_;
			_g_object_unref0 (_tmp12_);
			_g_object_unref0 (ios);
			_g_object_unref0 (file);
		}
		goto __finally1;
		__catch1_g_error:
		{
			GError* e = NULL;
			FILE* _tmp20_;
			GError* _tmp21_;
			const gchar* _tmp22_;
			GFile* _tmp23_;
			const gchar* _tmp28_;
			gchar* _tmp29_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp20_ = stderr;
			_tmp21_ = e;
			_tmp22_ = _tmp21_->message;
			fprintf (_tmp20_, "Error: %s\n", _tmp22_);
			_tmp23_ = self->tmp_file;
			if (_tmp23_ != NULL) {
				{
					GFile* _tmp24_;
					_tmp24_ = self->tmp_file;
					g_file_delete (_tmp24_, NULL, &_inner_error_);
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						goto __catch2_g_error;
					}
				}
				goto __finally2;
				__catch2_g_error:
				{
					GError* e = NULL;
					FILE* _tmp25_;
					GError* _tmp26_;
					const gchar* _tmp27_;
					e = _inner_error_;
					_inner_error_ = NULL;
					_tmp25_ = stderr;
					_tmp26_ = e;
					_tmp27_ = _tmp26_->message;
					fprintf (_tmp25_, "Error: %s\n", _tmp27_);
					_g_error_free0 (e);
				}
				__finally2:
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					_g_error_free0 (e);
					_g_error_free0 (e);
					_g_free0 (loaded_file_name);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
				}
			}
			_g_object_unref0 (self->tmp_file);
			self->tmp_file = NULL;
			self->priv->is_a_copy = FALSE;
			_tmp28_ = self->priv->_file_name;
			_tmp29_ = g_strdup (_tmp28_);
			_g_free0 (loaded_file_name);
			loaded_file_name = _tmp29_;
			_g_error_free0 (e);
		}
		__finally1:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (loaded_file_name);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
	} else {
		GHashTable* _tmp30_;
		const gchar* _tmp31_;
		gchar* _tmp32_;
		const gchar* _tmp33_;
		gchar* _tmp34_;
		_tmp30_ = retro_module_loaded_modules;
		_tmp31_ = self->priv->_file_name;
		_tmp32_ = g_strdup (_tmp31_);
		g_hash_table_add (_tmp30_, _tmp32_);
		_tmp33_ = self->priv->_file_name;
		_tmp34_ = g_strdup (_tmp33_);
		_g_free0 (loaded_file_name);
		loaded_file_name = _tmp34_;
	}
	_tmp35_ = loaded_file_name;
	_tmp36_ = g_module_open (_tmp35_, G_MODULE_BIND_LAZY | G_MODULE_BIND_LOCAL);
	_g_module_close0 (self->priv->module);
	self->priv->module = _tmp36_;
	_tmp37_ = self->priv->module;
	g_module_symbol (_tmp37_, "retro_set_environment", &_tmp38_);
	function = _tmp38_;
	_tmp39_ = function;
	retro_module_set_set_environment (self, (RetroCallbackSetter) _tmp39_);
	_tmp40_ = self->priv->module;
	g_module_symbol (_tmp40_, "retro_set_video_refresh", &_tmp41_);
	function = _tmp41_;
	_tmp42_ = function;
	retro_module_set_set_video_refresh (self, (RetroCallbackSetter) _tmp42_);
	_tmp43_ = self->priv->module;
	g_module_symbol (_tmp43_, "retro_set_audio_sample", &_tmp44_);
	function = _tmp44_;
	_tmp45_ = function;
	retro_module_set_set_audio_sample (self, (RetroCallbackSetter) _tmp45_);
	_tmp46_ = self->priv->module;
	g_module_symbol (_tmp46_, "retro_set_audio_sample_batch", &_tmp47_);
	function = _tmp47_;
	_tmp48_ = function;
	retro_module_set_set_audio_sample_batch (self, (RetroCallbackSetter) _tmp48_);
	_tmp49_ = self->priv->module;
	g_module_symbol (_tmp49_, "retro_set_input_poll", &_tmp50_);
	function = _tmp50_;
	_tmp51_ = function;
	retro_module_set_set_input_poll (self, (RetroCallbackSetter) _tmp51_);
	_tmp52_ = self->priv->module;
	g_module_symbol (_tmp52_, "retro_set_input_state", &_tmp53_);
	function = _tmp53_;
	_tmp54_ = function;
	retro_module_set_set_input_state (self, (RetroCallbackSetter) _tmp54_);
	_tmp55_ = self->priv->module;
	g_module_symbol (_tmp55_, "retro_init", &_tmp56_);
	function = _tmp56_;
	_tmp57_ = function;
	retro_module_set_init (self, (RetroInit) _tmp57_);
	_tmp58_ = self->priv->module;
	g_module_symbol (_tmp58_, "retro_deinit", &_tmp59_);
	function = _tmp59_;
	_tmp60_ = function;
	retro_module_set_deinit (self, (RetroDeinit) _tmp60_);
	_tmp61_ = self->priv->module;
	g_module_symbol (_tmp61_, "retro_api_version", &_tmp62_);
	function = _tmp62_;
	_tmp63_ = function;
	retro_module_set_api_version (self, (RetroApiVersion) _tmp63_);
	_tmp64_ = self->priv->module;
	g_module_symbol (_tmp64_, "retro_get_system_info", &_tmp65_);
	function = _tmp65_;
	_tmp66_ = function;
	retro_module_set_get_system_info (self, (RetroGetSystemInfo) _tmp66_);
	_tmp67_ = self->priv->module;
	g_module_symbol (_tmp67_, "retro_get_system_av_info", &_tmp68_);
	function = _tmp68_;
	_tmp69_ = function;
	retro_module_set_get_system_av_info (self, (RetroGetSystemAvInfo) _tmp69_);
	_tmp70_ = self->priv->module;
	g_module_symbol (_tmp70_, "retro_set_controller_port_device", &_tmp71_);
	function = _tmp71_;
	_tmp72_ = function;
	retro_module_set_set_controller_port_device (self, (RetroSetControllerPortDevice) _tmp72_);
	_tmp73_ = self->priv->module;
	g_module_symbol (_tmp73_, "retro_reset", &_tmp74_);
	function = _tmp74_;
	_tmp75_ = function;
	retro_module_set_reset (self, (RetroReset) _tmp75_);
	_tmp76_ = self->priv->module;
	g_module_symbol (_tmp76_, "retro_run", &_tmp77_);
	function = _tmp77_;
	_tmp78_ = function;
	retro_module_set_run (self, (RetroRun) _tmp78_);
	_tmp79_ = self->priv->module;
	g_module_symbol (_tmp79_, "retro_serialize_size", &_tmp80_);
	function = _tmp80_;
	_tmp81_ = function;
	retro_module_set_serialize_size (self, (RetroSerializeSize) _tmp81_);
	_tmp82_ = self->priv->module;
	g_module_symbol (_tmp82_, "retro_serialize", &_tmp83_);
	function = _tmp83_;
	_tmp84_ = function;
	retro_module_set_serialize (self, (RetroSerialize) _tmp84_);
	_tmp85_ = self->priv->module;
	g_module_symbol (_tmp85_, "retro_unserialize", &_tmp86_);
	function = _tmp86_;
	_tmp87_ = function;
	retro_module_set_unserialize (self, (RetroUnserialize) _tmp87_);
	_tmp88_ = self->priv->module;
	g_module_symbol (_tmp88_, "retro_load_game", &_tmp89_);
	function = _tmp89_;
	_tmp90_ = function;
	retro_module_set_load_game (self, (RetroLoadGame) _tmp90_);
	_tmp91_ = self->priv->module;
	g_module_symbol (_tmp91_, "retro_unload_game", &_tmp92_);
	function = _tmp92_;
	_tmp93_ = function;
	retro_module_set_unload_game (self, (RetroUnloadGame) _tmp93_);
	_tmp94_ = self->priv->module;
	g_module_symbol (_tmp94_, "retro_get_memory_data", &_tmp95_);
	function = _tmp95_;
	_tmp96_ = function;
	retro_module_set_get_memory_data (self, (RetroGetMemoryData) _tmp96_);
	_tmp97_ = self->priv->module;
	g_module_symbol (_tmp97_, "retro_get_memory_size", &_tmp98_);
	function = _tmp98_;
	_tmp99_ = function;
	retro_module_set_get_memory_size (self, (RetroGetMemorySize) _tmp99_);
	_g_free0 (loaded_file_name);
	return obj;
}


static void retro_module_class_init (RetroModuleClass * klass) {
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	retro_module_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RetroModulePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_retro_module_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_retro_module_set_property;
	G_OBJECT_CLASS (klass)->constructor = retro_module_constructor;
	G_OBJECT_CLASS (klass)->finalize = retro_module_finalize;
	/**
	 * The file name of the module.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RETRO_MODULE_FILE_NAME, g_param_spec_string ("file-name", "file-name", "file-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RETRO_MODULE_SET_ENVIRONMENT, g_param_spec_pointer ("set-environment", "set-environment", "set-environment", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RETRO_MODULE_SET_VIDEO_REFRESH, g_param_spec_pointer ("set-video-refresh", "set-video-refresh", "set-video-refresh", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RETRO_MODULE_SET_AUDIO_SAMPLE, g_param_spec_pointer ("set-audio-sample", "set-audio-sample", "set-audio-sample", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RETRO_MODULE_SET_AUDIO_SAMPLE_BATCH, g_param_spec_pointer ("set-audio-sample-batch", "set-audio-sample-batch", "set-audio-sample-batch", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RETRO_MODULE_SET_INPUT_POLL, g_param_spec_pointer ("set-input-poll", "set-input-poll", "set-input-poll", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RETRO_MODULE_SET_INPUT_STATE, g_param_spec_pointer ("set-input-state", "set-input-state", "set-input-state", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RETRO_MODULE_INIT, g_param_spec_pointer ("init", "init", "init", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RETRO_MODULE_DEINIT, g_param_spec_pointer ("deinit", "deinit", "deinit", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RETRO_MODULE_API_VERSION, g_param_spec_pointer ("api-version", "api-version", "api-version", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RETRO_MODULE_GET_SYSTEM_INFO, g_param_spec_pointer ("get-system-info", "get-system-info", "get-system-info", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RETRO_MODULE_GET_SYSTEM_AV_INFO, g_param_spec_pointer ("get-system-av-info", "get-system-av-info", "get-system-av-info", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RETRO_MODULE_SET_CONTROLLER_PORT_DEVICE, g_param_spec_pointer ("set-controller-port-device", "set-controller-port-device", "set-controller-port-device", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RETRO_MODULE_RESET, g_param_spec_pointer ("reset", "reset", "reset", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RETRO_MODULE_RUN, g_param_spec_pointer ("run", "run", "run", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RETRO_MODULE_SERIALIZE_SIZE, g_param_spec_pointer ("serialize-size", "serialize-size", "serialize-size", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RETRO_MODULE_SERIALIZE, g_param_spec_pointer ("serialize", "serialize", "serialize", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RETRO_MODULE_UNSERIALIZE, g_param_spec_pointer ("unserialize", "unserialize", "unserialize", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RETRO_MODULE_LOAD_GAME, g_param_spec_pointer ("load-game", "load-game", "load-game", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RETRO_MODULE_UNLOAD_GAME, g_param_spec_pointer ("unload-game", "unload-game", "unload-game", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RETRO_MODULE_GET_MEMORY_DATA, g_param_spec_pointer ("get-memory-data", "get-memory-data", "get-memory-data", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RETRO_MODULE_GET_MEMORY_SIZE, g_param_spec_pointer ("get-memory-size", "get-memory-size", "get-memory-size", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, NULL, _g_free0_);
	retro_module_loaded_modules = _tmp2_;
}


static void retro_module_instance_init (RetroModule * self) {
	self->priv = RETRO_MODULE_GET_PRIVATE (self);
}


static void retro_module_finalize (GObject * obj) {
	RetroModule * self;
	GFile* _tmp0_;
	gboolean _tmp5_;
	GError * _inner_error_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RETRO_TYPE_MODULE, RetroModule);
	_tmp0_ = self->tmp_file;
	if (_tmp0_ != NULL) {
		{
			GFile* _tmp1_;
			_tmp1_ = self->tmp_file;
			g_file_delete (_tmp1_, NULL, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			FILE* _tmp2_;
			GError* _tmp3_;
			const gchar* _tmp4_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp2_ = stderr;
			_tmp3_ = e;
			_tmp4_ = _tmp3_->message;
			fprintf (_tmp2_, "Error: %s\n", _tmp4_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
	}
	_tmp5_ = self->priv->is_a_copy;
	if (!_tmp5_) {
		GHashTable* _tmp6_;
		const gchar* _tmp7_;
		_tmp6_ = retro_module_loaded_modules;
		_tmp7_ = self->priv->_file_name;
		g_hash_table_remove (_tmp6_, _tmp7_);
	}
	_g_free0 (self->priv->_file_name);
	_g_object_unref0 (self->tmp_file);
	_g_module_close0 (self->priv->module);
	G_OBJECT_CLASS (retro_module_parent_class)->finalize (obj);
}


/**
 * Loads a Libretro module.
 */
GType retro_module_get_type (void) {
	static volatile gsize retro_module_type_id__volatile = 0;
	if (g_once_init_enter (&retro_module_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RetroModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) retro_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RetroModule), 0, (GInstanceInitFunc) retro_module_instance_init, NULL };
		GType retro_module_type_id;
		retro_module_type_id = g_type_register_static (G_TYPE_OBJECT, "RetroModule", &g_define_type_info, 0);
		g_once_init_leave (&retro_module_type_id__volatile, retro_module_type_id);
	}
	return retro_module_type_id__volatile;
}


static void _vala_retro_module_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RetroModule * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RETRO_TYPE_MODULE, RetroModule);
	switch (property_id) {
		case RETRO_MODULE_FILE_NAME:
		g_value_set_string (value, retro_module_get_file_name (self));
		break;
		case RETRO_MODULE_SET_ENVIRONMENT:
		g_value_set_pointer (value, retro_module_get_set_environment (self));
		break;
		case RETRO_MODULE_SET_VIDEO_REFRESH:
		g_value_set_pointer (value, retro_module_get_set_video_refresh (self));
		break;
		case RETRO_MODULE_SET_AUDIO_SAMPLE:
		g_value_set_pointer (value, retro_module_get_set_audio_sample (self));
		break;
		case RETRO_MODULE_SET_AUDIO_SAMPLE_BATCH:
		g_value_set_pointer (value, retro_module_get_set_audio_sample_batch (self));
		break;
		case RETRO_MODULE_SET_INPUT_POLL:
		g_value_set_pointer (value, retro_module_get_set_input_poll (self));
		break;
		case RETRO_MODULE_SET_INPUT_STATE:
		g_value_set_pointer (value, retro_module_get_set_input_state (self));
		break;
		case RETRO_MODULE_INIT:
		g_value_set_pointer (value, retro_module_get_init (self));
		break;
		case RETRO_MODULE_DEINIT:
		g_value_set_pointer (value, retro_module_get_deinit (self));
		break;
		case RETRO_MODULE_API_VERSION:
		g_value_set_pointer (value, retro_module_get_api_version (self));
		break;
		case RETRO_MODULE_GET_SYSTEM_INFO:
		g_value_set_pointer (value, retro_module_get_get_system_info (self));
		break;
		case RETRO_MODULE_GET_SYSTEM_AV_INFO:
		g_value_set_pointer (value, retro_module_get_get_system_av_info (self));
		break;
		case RETRO_MODULE_SET_CONTROLLER_PORT_DEVICE:
		g_value_set_pointer (value, retro_module_get_set_controller_port_device (self));
		break;
		case RETRO_MODULE_RESET:
		g_value_set_pointer (value, retro_module_get_reset (self));
		break;
		case RETRO_MODULE_RUN:
		g_value_set_pointer (value, retro_module_get_run (self));
		break;
		case RETRO_MODULE_SERIALIZE_SIZE:
		g_value_set_pointer (value, retro_module_get_serialize_size (self));
		break;
		case RETRO_MODULE_SERIALIZE:
		g_value_set_pointer (value, retro_module_get_serialize (self));
		break;
		case RETRO_MODULE_UNSERIALIZE:
		g_value_set_pointer (value, retro_module_get_unserialize (self));
		break;
		case RETRO_MODULE_LOAD_GAME:
		g_value_set_pointer (value, retro_module_get_load_game (self));
		break;
		case RETRO_MODULE_UNLOAD_GAME:
		g_value_set_pointer (value, retro_module_get_unload_game (self));
		break;
		case RETRO_MODULE_GET_MEMORY_DATA:
		g_value_set_pointer (value, retro_module_get_get_memory_data (self));
		break;
		case RETRO_MODULE_GET_MEMORY_SIZE:
		g_value_set_pointer (value, retro_module_get_get_memory_size (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_retro_module_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RetroModule * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RETRO_TYPE_MODULE, RetroModule);
	switch (property_id) {
		case RETRO_MODULE_FILE_NAME:
		retro_module_set_file_name (self, g_value_get_string (value));
		break;
		case RETRO_MODULE_SET_ENVIRONMENT:
		retro_module_set_set_environment (self, g_value_get_pointer (value));
		break;
		case RETRO_MODULE_SET_VIDEO_REFRESH:
		retro_module_set_set_video_refresh (self, g_value_get_pointer (value));
		break;
		case RETRO_MODULE_SET_AUDIO_SAMPLE:
		retro_module_set_set_audio_sample (self, g_value_get_pointer (value));
		break;
		case RETRO_MODULE_SET_AUDIO_SAMPLE_BATCH:
		retro_module_set_set_audio_sample_batch (self, g_value_get_pointer (value));
		break;
		case RETRO_MODULE_SET_INPUT_POLL:
		retro_module_set_set_input_poll (self, g_value_get_pointer (value));
		break;
		case RETRO_MODULE_SET_INPUT_STATE:
		retro_module_set_set_input_state (self, g_value_get_pointer (value));
		break;
		case RETRO_MODULE_INIT:
		retro_module_set_init (self, g_value_get_pointer (value));
		break;
		case RETRO_MODULE_DEINIT:
		retro_module_set_deinit (self, g_value_get_pointer (value));
		break;
		case RETRO_MODULE_API_VERSION:
		retro_module_set_api_version (self, g_value_get_pointer (value));
		break;
		case RETRO_MODULE_GET_SYSTEM_INFO:
		retro_module_set_get_system_info (self, g_value_get_pointer (value));
		break;
		case RETRO_MODULE_GET_SYSTEM_AV_INFO:
		retro_module_set_get_system_av_info (self, g_value_get_pointer (value));
		break;
		case RETRO_MODULE_SET_CONTROLLER_PORT_DEVICE:
		retro_module_set_set_controller_port_device (self, g_value_get_pointer (value));
		break;
		case RETRO_MODULE_RESET:
		retro_module_set_reset (self, g_value_get_pointer (value));
		break;
		case RETRO_MODULE_RUN:
		retro_module_set_run (self, g_value_get_pointer (value));
		break;
		case RETRO_MODULE_SERIALIZE_SIZE:
		retro_module_set_serialize_size (self, g_value_get_pointer (value));
		break;
		case RETRO_MODULE_SERIALIZE:
		retro_module_set_serialize (self, g_value_get_pointer (value));
		break;
		case RETRO_MODULE_UNSERIALIZE:
		retro_module_set_unserialize (self, g_value_get_pointer (value));
		break;
		case RETRO_MODULE_LOAD_GAME:
		retro_module_set_load_game (self, g_value_get_pointer (value));
		break;
		case RETRO_MODULE_UNLOAD_GAME:
		retro_module_set_unload_game (self, g_value_get_pointer (value));
		break;
		case RETRO_MODULE_GET_MEMORY_DATA:
		retro_module_set_get_memory_data (self, g_value_get_pointer (value));
		break;
		case RETRO_MODULE_GET_MEMORY_SIZE:
		retro_module_set_get_memory_size (self, g_value_get_pointer (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



