/* retro-core-view.c generated by valac 0.36.1.17-97a62, the Vala compiler
 * generated from retro-core-view.vala, do not modify */

/* This file is part of retro-gtk. License: GPL-3.0+.*/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>


#define RETRO_TYPE_CORE_VIEW (retro_core_view_get_type ())
#define RETRO_CORE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RETRO_TYPE_CORE_VIEW, RetroCoreView))
#define RETRO_CORE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RETRO_TYPE_CORE_VIEW, RetroCoreViewClass))
#define RETRO_IS_CORE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RETRO_TYPE_CORE_VIEW))
#define RETRO_IS_CORE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RETRO_TYPE_CORE_VIEW))
#define RETRO_CORE_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RETRO_TYPE_CORE_VIEW, RetroCoreViewClass))

typedef struct _RetroCoreView RetroCoreView;
typedef struct _RetroCoreViewClass RetroCoreViewClass;
typedef struct _RetroCoreViewPrivate RetroCoreViewPrivate;

#define RETRO_TYPE_CAIRO_DISPLAY (retro_cairo_display_get_type ())
#define RETRO_CAIRO_DISPLAY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RETRO_TYPE_CAIRO_DISPLAY, RetroCairoDisplay))
#define RETRO_CAIRO_DISPLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RETRO_TYPE_CAIRO_DISPLAY, RetroCairoDisplayClass))
#define RETRO_IS_CAIRO_DISPLAY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RETRO_TYPE_CAIRO_DISPLAY))
#define RETRO_IS_CAIRO_DISPLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RETRO_TYPE_CAIRO_DISPLAY))
#define RETRO_CAIRO_DISPLAY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RETRO_TYPE_CAIRO_DISPLAY, RetroCairoDisplayClass))

typedef struct _RetroCairoDisplay RetroCairoDisplay;
typedef struct _RetroCairoDisplayClass RetroCairoDisplayClass;

#define RETRO_TYPE_CORE (retro_core_get_type ())
#define RETRO_CORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RETRO_TYPE_CORE, RetroCore))
#define RETRO_CORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RETRO_TYPE_CORE, RetroCoreClass))
#define RETRO_IS_CORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RETRO_TYPE_CORE))
#define RETRO_IS_CORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RETRO_TYPE_CORE))
#define RETRO_CORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RETRO_TYPE_CORE, RetroCoreClass))

typedef struct _RetroCore RetroCore;
typedef struct _RetroCoreClass RetroCoreClass;
enum  {
	RETRO_CORE_VIEW_DUMMY_PROPERTY,
	RETRO_CORE_VIEW_CAN_GRAB_POINTER,
	RETRO_CORE_VIEW_SNAP_POINTER_TO_BORDERS,
	RETRO_CORE_VIEW_LAST_PROPERTY
};
static GParamSpec* retro_core_view_properties[RETRO_CORE_VIEW_LAST_PROPERTY];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

#define RETRO_TYPE_DEVICE_TYPE (retro_device_type_get_type ())

#define RETRO_TYPE_INPUT_DEVICE (retro_input_device_get_type ())
#define RETRO_INPUT_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RETRO_TYPE_INPUT_DEVICE, RetroInputDevice))
#define RETRO_IS_INPUT_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RETRO_TYPE_INPUT_DEVICE))
#define RETRO_INPUT_DEVICE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RETRO_TYPE_INPUT_DEVICE, RetroInputDeviceIface))

typedef struct _RetroInputDevice RetroInputDevice;
typedef struct _RetroInputDeviceIface RetroInputDeviceIface;

struct _RetroCoreView {
	GtkEventBox parent_instance;
	RetroCoreViewPrivate * priv;
	RetroCairoDisplay* display;
	GHashTable* key_state;
	GHashTable* mouse_button_state;
	GdkScreen* grabbed_screen;
	GdkDevice* grabbed_device;
	gdouble mouse_x_delta;
	gdouble mouse_y_delta;
	gint screen_center_x;
	gint screen_center_y;
	gint position_on_grab_x;
	gint position_on_grab_y;
	gboolean pointer_is_on_display;
	gdouble pointer_x;
	gdouble pointer_y;
};

struct _RetroCoreViewClass {
	GtkEventBoxClass parent_class;
};

struct _RetroCoreViewPrivate {
	gboolean _can_grab_pointer;
	gboolean _snap_pointer_to_borders;
	RetroCore* core;
};

typedef enum  {
	RETRO_DEVICE_TYPE_TYPE_MASK = 0xff,
	RETRO_DEVICE_TYPE_NONE = 0,
	RETRO_DEVICE_TYPE_JOYPAD = 1,
	RETRO_DEVICE_TYPE_MOUSE = 2,
	RETRO_DEVICE_TYPE_KEYBOARD = 3,
	RETRO_DEVICE_TYPE_LIGHTGUN = 4,
	RETRO_DEVICE_TYPE_ANALOG = 5,
	RETRO_DEVICE_TYPE_POINTER = 6
} RetroDeviceType;

struct _RetroInputDeviceIface {
	GTypeInterface parent_iface;
	void (*poll) (RetroInputDevice* self);
	gint16 (*get_input_state) (RetroInputDevice* self, RetroDeviceType device, guint index, guint id);
	RetroDeviceType (*get_device_type) (RetroInputDevice* self);
	guint64 (*get_device_capabilities) (RetroInputDevice* self);
};


static gpointer retro_core_view_parent_class = NULL;

GType retro_core_view_get_type (void) G_GNUC_CONST;
GType retro_cairo_display_get_type (void) G_GNUC_CONST;
GType retro_core_get_type (void) G_GNUC_CONST;
#define RETRO_CORE_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RETRO_TYPE_CORE_VIEW, RetroCoreViewPrivate))
void retro_core_view_set_core (RetroCoreView* self, RetroCore* core);
void retro_cairo_display_set_core (RetroCairoDisplay* self, RetroCore* core);
RetroCairoDisplay* retro_core_view_get_display (RetroCoreView* self);
GType retro_device_type_get_type (void) G_GNUC_CONST;
GType retro_input_device_get_type (void) G_GNUC_CONST;
RetroInputDevice* retro_core_view_as_input_device (RetroCoreView* self, RetroDeviceType device_type);
gint16 retro_core_view_get_input_state (RetroCoreView* self, RetroDeviceType device, guint index, guint id);
guint64 retro_core_view_get_device_capabilities (RetroCoreView* self);
gboolean retro_core_view_get_is_pointer_grabbed (RetroCoreView* self);
void retro_core_view_ungrab (RetroCoreView* self);
gboolean retro_core_view_on_key_press_event (RetroCoreView* self, GtkWidget* source, GdkEventKey* event);
gboolean retro_core_view_on_key_release_event (RetroCoreView* self, GtkWidget* source, GdkEventKey* event);
gboolean retro_core_view_on_button_press_event (RetroCoreView* self, GtkWidget* source, GdkEventButton* event);
gboolean retro_core_view_on_button_release_event (RetroCoreView* self, GtkWidget* source, GdkEventButton* event);
gboolean retro_core_view_on_focus_out_event (RetroCoreView* self, GtkWidget* source, GdkEventFocus* event);
gboolean retro_core_view_on_motion_notify_event (RetroCoreView* self, GtkWidget* source, GdkEventMotion* event);
RetroCoreView* retro_core_view_new (void);
RetroCoreView* retro_core_view_construct (GType object_type);
gboolean retro_core_view_get_can_grab_pointer (RetroCoreView* self);
void retro_core_view_set_can_grab_pointer (RetroCoreView* self, gboolean value);
gboolean retro_core_view_get_snap_pointer_to_borders (RetroCoreView* self);
void retro_core_view_set_snap_pointer_to_borders (RetroCoreView* self, gboolean value);
static GObject * retro_core_view_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
RetroCairoDisplay* retro_cairo_display_new (void);
RetroCairoDisplay* retro_cairo_display_construct (GType object_type);
static void _g_free0_ (gpointer var);
static gboolean _retro_core_view_on_key_press_event_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self);
static gboolean _retro_core_view_on_key_release_event_gtk_widget_key_release_event (GtkWidget* _sender, GdkEventKey* event, gpointer self);
static gboolean _retro_core_view_on_button_press_event_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static gboolean _retro_core_view_on_button_release_event_gtk_widget_button_release_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static gboolean _retro_core_view_on_focus_out_event_gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self);
static gboolean _retro_core_view_on_motion_notify_event_gtk_widget_motion_notify_event (GtkWidget* _sender, GdkEventMotion* event, gpointer self);
static void retro_core_view_finalize (GObject * obj);
static void _vala_retro_core_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_retro_core_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void retro_core_view_set_core (RetroCoreView* self, RetroCore* core) {
	RetroCore* _tmp0_;
	RetroCore* _tmp2_;
	RetroCore* _tmp3_;
	RetroCore* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->core;
	if (_tmp0_ != NULL) {
		RetroCairoDisplay* _tmp1_;
		_tmp1_ = self->display;
		retro_cairo_display_set_core (_tmp1_, NULL);
	}
	_tmp2_ = core;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (self->priv->core);
	self->priv->core = _tmp3_;
	_tmp4_ = core;
	if (_tmp4_ != NULL) {
		RetroCairoDisplay* _tmp5_;
		RetroCore* _tmp6_;
		_tmp5_ = self->display;
		_tmp6_ = core;
		retro_cairo_display_set_core (_tmp5_, _tmp6_);
	}
}


RetroCairoDisplay* retro_core_view_get_display (RetroCoreView* self) {
	RetroCairoDisplay* result = NULL;
	RetroCairoDisplay* _tmp0_;
	RetroCairoDisplay* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->display;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


RetroCoreView* retro_core_view_construct (GType object_type) {
	RetroCoreView * self = NULL;
	self = (RetroCoreView*) g_object_new (object_type, NULL);
	return self;
}


RetroCoreView* retro_core_view_new (void) {
	return retro_core_view_construct (RETRO_TYPE_CORE_VIEW);
}


gboolean retro_core_view_get_can_grab_pointer (RetroCoreView* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_can_grab_pointer;
	result = _tmp0_;
	return result;
}


void retro_core_view_set_can_grab_pointer (RetroCoreView* self, gboolean value) {
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = self->priv->_can_grab_pointer;
	if (_tmp0_ == _tmp1_) {
		return;
	}
	_tmp2_ = value;
	self->priv->_can_grab_pointer = _tmp2_;
	_tmp4_ = self->priv->_can_grab_pointer;
	if (_tmp4_ == FALSE) {
		gboolean _tmp5_;
		_tmp5_ = retro_core_view_get_is_pointer_grabbed (self);
		_tmp3_ = _tmp5_;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		retro_core_view_ungrab (self);
	}
	g_object_notify_by_pspec ((GObject *) self, retro_core_view_properties[RETRO_CORE_VIEW_CAN_GRAB_POINTER]);
}


gboolean retro_core_view_get_snap_pointer_to_borders (RetroCoreView* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_snap_pointer_to_borders;
	result = _tmp0_;
	return result;
}


void retro_core_view_set_snap_pointer_to_borders (RetroCoreView* self, gboolean value) {
	g_return_if_fail (self != NULL);
	if (retro_core_view_get_snap_pointer_to_borders (self) != value) {
		gboolean _tmp0_;
		_tmp0_ = value;
		self->priv->_snap_pointer_to_borders = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, retro_core_view_properties[RETRO_CORE_VIEW_SNAP_POINTER_TO_BORDERS]);
	}
}


static void _g_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_free (var), NULL));
}


static gboolean _retro_core_view_on_key_press_event_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self) {
	gboolean result;
	result = retro_core_view_on_key_press_event ((RetroCoreView*) self, _sender, event);
	return result;
}


static gboolean _retro_core_view_on_key_release_event_gtk_widget_key_release_event (GtkWidget* _sender, GdkEventKey* event, gpointer self) {
	gboolean result;
	result = retro_core_view_on_key_release_event ((RetroCoreView*) self, _sender, event);
	return result;
}


static gboolean _retro_core_view_on_button_press_event_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = retro_core_view_on_button_press_event ((RetroCoreView*) self, _sender, event);
	return result;
}


static gboolean _retro_core_view_on_button_release_event_gtk_widget_button_release_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = retro_core_view_on_button_release_event ((RetroCoreView*) self, _sender, event);
	return result;
}


static gboolean _retro_core_view_on_focus_out_event_gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self) {
	gboolean result;
	result = retro_core_view_on_focus_out_event ((RetroCoreView*) self, _sender, event);
	return result;
}


static gboolean _retro_core_view_on_motion_notify_event_gtk_widget_motion_notify_event (GtkWidget* _sender, GdkEventMotion* event, gpointer self) {
	gboolean result;
	result = retro_core_view_on_motion_notify_event ((RetroCoreView*) self, _sender, event);
	return result;
}


static GObject * retro_core_view_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	RetroCoreView * self;
	RetroCairoDisplay* _tmp0_;
	RetroCairoDisplay* _tmp1_;
	RetroCairoDisplay* _tmp2_;
	RetroCairoDisplay* _tmp3_;
	GHashFunc _tmp4_;
	GEqualFunc _tmp5_;
	GHashTable* _tmp6_;
	GHashFunc _tmp7_;
	GEqualFunc _tmp8_;
	GHashTable* _tmp9_;
	parent_class = G_OBJECT_CLASS (retro_core_view_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RETRO_TYPE_CORE_VIEW, RetroCoreView);
	g_object_set ((GtkWidget*) self, "can-focus", TRUE, NULL);
	_tmp0_ = retro_cairo_display_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->display);
	self->display = _tmp0_;
	_tmp1_ = self->display;
	gtk_widget_set_visible ((GtkWidget*) _tmp1_, TRUE);
	_tmp2_ = self->display;
	g_object_set ((GtkWidget*) _tmp2_, "can-focus", FALSE, NULL);
	_tmp3_ = self->display;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp3_);
	_tmp4_ = g_int_hash;
	_tmp5_ = g_int_equal;
	_tmp6_ = g_hash_table_new_full (_tmp4_, _tmp5_, _g_free0_, _g_free0_);
	_g_hash_table_unref0 (self->key_state);
	self->key_state = _tmp6_;
	_tmp7_ = g_int_hash;
	_tmp8_ = g_int_equal;
	_tmp9_ = g_hash_table_new_full (_tmp7_, _tmp8_, _g_free0_, _g_free0_);
	_g_hash_table_unref0 (self->mouse_button_state);
	self->mouse_button_state = _tmp9_;
	g_signal_connect_object ((GtkWidget*) self, "key-press-event", (GCallback) _retro_core_view_on_key_press_event_gtk_widget_key_press_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "key-release-event", (GCallback) _retro_core_view_on_key_release_event_gtk_widget_key_release_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "button-press-event", (GCallback) _retro_core_view_on_button_press_event_gtk_widget_button_press_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "button-release-event", (GCallback) _retro_core_view_on_button_release_event_gtk_widget_button_release_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "focus-out-event", (GCallback) _retro_core_view_on_focus_out_event_gtk_widget_focus_out_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "motion-notify-event", (GCallback) _retro_core_view_on_motion_notify_event_gtk_widget_motion_notify_event, self, 0);
	return obj;
}


static void retro_core_view_class_init (RetroCoreViewClass * klass) {
	retro_core_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RetroCoreViewPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_retro_core_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_retro_core_view_set_property;
	G_OBJECT_CLASS (klass)->constructor = retro_core_view_constructor;
	G_OBJECT_CLASS (klass)->finalize = retro_core_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RETRO_CORE_VIEW_CAN_GRAB_POINTER, retro_core_view_properties[RETRO_CORE_VIEW_CAN_GRAB_POINTER] = g_param_spec_boolean ("can-grab-pointer", "can-grab-pointer", "can-grab-pointer", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RETRO_CORE_VIEW_SNAP_POINTER_TO_BORDERS, retro_core_view_properties[RETRO_CORE_VIEW_SNAP_POINTER_TO_BORDERS] = g_param_spec_boolean ("snap-pointer-to-borders", "snap-pointer-to-borders", "snap-pointer-to-borders", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void retro_core_view_instance_init (RetroCoreView * self) {
	self->priv = RETRO_CORE_VIEW_GET_PRIVATE (self);
}


static void retro_core_view_finalize (GObject * obj) {
	RetroCoreView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RETRO_TYPE_CORE_VIEW, RetroCoreView);
	_g_object_unref0 (self->priv->core);
	_g_object_unref0 (self->display);
	_g_hash_table_unref0 (self->key_state);
	_g_hash_table_unref0 (self->mouse_button_state);
	_g_object_unref0 (self->grabbed_screen);
	_g_object_unref0 (self->grabbed_device);
	G_OBJECT_CLASS (retro_core_view_parent_class)->finalize (obj);
}


GType retro_core_view_get_type (void) {
	static volatile gsize retro_core_view_type_id__volatile = 0;
	if (g_once_init_enter (&retro_core_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RetroCoreViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) retro_core_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RetroCoreView), 0, (GInstanceInitFunc) retro_core_view_instance_init, NULL };
		GType retro_core_view_type_id;
		retro_core_view_type_id = g_type_register_static (gtk_event_box_get_type (), "RetroCoreView", &g_define_type_info, 0);
		g_once_init_leave (&retro_core_view_type_id__volatile, retro_core_view_type_id);
	}
	return retro_core_view_type_id__volatile;
}


static void _vala_retro_core_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RetroCoreView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RETRO_TYPE_CORE_VIEW, RetroCoreView);
	switch (property_id) {
		case RETRO_CORE_VIEW_CAN_GRAB_POINTER:
		g_value_set_boolean (value, retro_core_view_get_can_grab_pointer (self));
		break;
		case RETRO_CORE_VIEW_SNAP_POINTER_TO_BORDERS:
		g_value_set_boolean (value, retro_core_view_get_snap_pointer_to_borders (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_retro_core_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RetroCoreView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RETRO_TYPE_CORE_VIEW, RetroCoreView);
	switch (property_id) {
		case RETRO_CORE_VIEW_CAN_GRAB_POINTER:
		retro_core_view_set_can_grab_pointer (self, g_value_get_boolean (value));
		break;
		case RETRO_CORE_VIEW_SNAP_POINTER_TO_BORDERS:
		retro_core_view_set_snap_pointer_to_borders (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



