/* retro-gtk-0.12.vapi generated by valac 0.36.1.17-97a62, do not modify. */

[CCode (gir_namespace = "Retro", gir_version = "0.12")]
namespace Retro {
	[CCode (cheader_filename = "retro-gtk.h")]
	public class CairoDisplay : Gtk.DrawingArea {
		public CairoDisplay ();
		public override bool draw (Cairo.Context cr);
		public bool get_coordinates_on_display (double widget_x, double widget_y, out double display_x, out double display_y);
		public void hide_video ();
		public void set_core (Retro.Core? core);
		public void set_filter (Retro.VideoFilter filter);
		public void show_video ();
		public Gdk.Pixbuf pixbuf { get; set; }
	}
	[CCode (cheader_filename = "retro-gtk.h")]
	public class Core : GLib.Object {
		public Core (string file_name);
		public void deserialize_state ([CCode (array_length_type = "gsize")] uint8[] data) throws GLib.Error;
		public uint8[] get_memory (Retro.MemoryType id);
		public size_t get_memory_size (Retro.MemoryType id);
		public void init () throws GLib.Error;
		public void reset ();
		public void run ();
		[CCode (array_length_type = "gsize")]
		public uint8[] serialize_state () throws GLib.Error;
		public void set_controller_port_device (uint port, Retro.DeviceType device);
		public void set_current_media (uint media_index) throws GLib.Error;
		public void set_medias ([CCode (array_length = false, array_null_terminated = true)] string[] uris);
		public void set_memory (Retro.MemoryType id, uint8[] data);
		public bool supports_serialization ();
		public uint api_version { get; }
		public string content_directory { get; set; }
		public string file_name { get; internal set; }
		public double frames_per_second { get; }
		public bool game_loaded { get; internal set; }
		public Retro.Input input_interface { get; set construct; }
		public bool is_initiated { get; internal set; }
		public string libretro_path { get; set; }
		public Retro.Rumble rumble_interface { get; set; }
		public string save_directory { get; set; }
		public bool support_no_game { get; internal set; }
		public string system_directory { get; set; }
		public signal void audio_output (int16[] frames, double sample_rate);
		public signal void log (string log_domain, GLib.LogLevelFlags log_level, string message);
		public signal bool message (string message, uint frames);
		public signal bool shutdown ();
		public signal void video_output (uint8[] data, uint width, uint height, size_t pitch, Retro.PixelFormat pixel_format, float aspect_ratio);
	}
	[CCode (cheader_filename = "retro-gtk.h")]
	public class CoreDescriptor : GLib.Object {
		public class Platform : GLib.Object {
		}
		public CoreDescriptor (string filename) throws GLib.Error, GLib.KeyFileError, GLib.FileError;
		public string get_firmware_md5 (string firmware) throws GLib.KeyFileError;
		public string get_firmware_path (string firmware) throws GLib.KeyFileError;
		public string get_firmware_sha512 (string firmware) throws GLib.KeyFileError;
		public string[] get_firmwares (string platform) throws GLib.KeyFileError;
		public GLib.Icon get_icon () throws GLib.KeyFileError;
		public string get_id ();
		public bool get_is_emulator () throws GLib.KeyFileError;
		public bool get_is_firmware_mandatory (string firmware) throws GLib.KeyFileError;
		public bool get_is_game () throws GLib.KeyFileError;
		public string[] get_mime_type (string platform) throws GLib.KeyFileError;
		public string get_module () throws GLib.KeyFileError;
		public GLib.File? get_module_file () throws GLib.KeyFileError;
		public string get_name () throws GLib.KeyFileError;
		public bool get_platform_supports_mime_types (string platform, string[] mime_types) throws GLib.KeyFileError;
		public string get_uri ();
		public bool has_firmware_md5 (string firmware) throws GLib.KeyFileError;
		public bool has_firmware_sha512 (string firmware) throws GLib.KeyFileError;
		public bool has_firmwares (string platform) throws GLib.KeyFileError;
		public bool has_icon () throws GLib.KeyFileError;
		public bool has_platform (string platform);
	}
	[CCode (cheader_filename = "retro-gtk.h")]
	public class CoreView : Gtk.EventBox {
		public CoreView ();
		public Retro.InputDevice as_input_device (Retro.DeviceType device_type);
		public Retro.CairoDisplay get_display ();
		public void set_core (Retro.Core? core);
		public bool can_grab_pointer { get; set; }
		public bool snap_pointer_to_borders { get; set; }
	}
	[CCode (cheader_filename = "retro-gtk.h")]
	public class InputDeviceManager : GLib.Object, Retro.Input {
		public InputDeviceManager ();
		public void remove_controller_device (uint port);
		public void set_controller_device (uint port, Retro.InputDevice device);
		public void set_keyboard (Gtk.Widget widget);
	}
	[CCode (cheader_filename = "retro-gtk.h")]
	public class MainLoop : GLib.Object {
		public MainLoop (Retro.Core core);
		public void reset ();
		public void start ();
		public void stop ();
		public Retro.Core core { get; set construct; }
		public double speed_rate { get; set construct; }
	}
	[CCode (cheader_filename = "retro-gtk.h")]
	public class ModuleIterator {
		public new Retro.CoreDescriptor? @get ();
		public bool next ();
	}
	[CCode (cheader_filename = "retro-gtk.h")]
	public class ModuleQuery {
		public ModuleQuery (bool recursive);
		public Retro.ModuleIterator iterator ();
	}
	[CCode (cheader_filename = "retro-gtk.h")]
	public class PaPlayer : GLib.Object {
		public PaPlayer ();
		public void set_core (Retro.Core? core);
	}
	[CCode (cheader_filename = "retro-gtk.h")]
	public interface Input : GLib.Object {
		public delegate void ControllerCallback (uint port, Retro.InputDevice device);
		public abstract void foreach_controller (Retro.Input.ControllerCallback callback);
		public abstract uint64 get_device_capabilities ();
		public abstract int16 get_state (uint port, Retro.DeviceType device, uint index, uint id);
		public abstract void poll ();
		public abstract void set_descriptors (Retro.InputDescriptor[] input_descriptors);
		public signal void controller_connected (uint port, Retro.InputDevice device);
		public signal void controller_disconnected (uint port);
		public signal bool key_event (Gdk.EventKey event);
	}
	[CCode (cheader_filename = "retro-gtk.h")]
	public interface InputDevice : GLib.Object {
		public abstract uint64 get_device_capabilities ();
		public abstract Retro.DeviceType get_device_type ();
		public abstract int16 get_input_state (Retro.DeviceType device, uint index, uint id);
		public abstract void poll ();
	}
	[CCode (cheader_filename = "retro-gtk.h")]
	public interface Rumble : GLib.Object {
		public abstract bool set_rumble_state (uint port, Retro.RumbleEffect effect, uint16 strength);
	}
	[CCode (cheader_filename = "retro-gtk.h")]
	public struct InputDescriptor {
		public uint port;
		public Retro.DeviceType device;
		public uint index;
		public uint id;
		public string description;
	}
	[CCode (cheader_filename = "retro-gtk.h")]
	public enum AnalogId {
		X,
		Y
	}
	[CCode (cheader_filename = "retro-gtk.h")]
	public enum AnalogIndex {
		LEFT,
		RIGHT
	}
	[CCode (cheader_filename = "retro-gtk.h")]
	public enum DeviceType {
		TYPE_MASK,
		NONE,
		JOYPAD,
		MOUSE,
		KEYBOARD,
		LIGHTGUN,
		ANALOG,
		POINTER;
		public Retro.DeviceType get_basic_type ();
	}
	[CCode (cheader_filename = "retro-gtk.h")]
	public enum JoypadId {
		B,
		Y,
		SELECT,
		START,
		UP,
		DOWN,
		LEFT,
		RIGHT,
		A,
		X,
		L,
		R,
		L2,
		R2,
		L3,
		R3,
		COUNT
	}
	[CCode (cheader_filename = "retro-gtk.h")]
	public enum MemoryType {
		SAVE_RAM,
		RTC,
		SYSTEM_RAM,
		VIDEO_RAM
	}
	[CCode (cheader_filename = "retro-gtk.h")]
	public enum PixelFormat {
		XRGB1555,
		XRGB8888,
		RGB565,
		UNKNOWN
	}
	[CCode (cheader_filename = "retro-gtk.h")]
	public enum RumbleEffect {
		STRONG,
		WEAK
	}
	[CCode (cheader_filename = "retro-gtk.h")]
	public enum VideoFilter {
		SMOOTH,
		SHARP;
		public static Retro.VideoFilter from_string (string filter);
	}
	[CCode (cheader_filename = "retro-gtk.h")]
	public const uint API_VERSION;
	[CCode (cheader_filename = "retro-gtk.h")]
	public static void g_log (Retro.Core core, string log_domain, GLib.LogLevelFlags log_level, string message);
}
