/* retro-gtk-internal.h generated by valac 0.36.1.17-97a62, the Vala compiler, do not modify */


#ifndef __RETRO_GTK_INTERNAL_H__
#define __RETRO_GTK_INTERNAL_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <float.h>
#include <math.h>
#include <gio/gio.h>
#include <gdk/gdk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>

G_BEGIN_DECLS


#define RETRO_TYPE_PA_PLAYER (retro_pa_player_get_type ())
#define RETRO_PA_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RETRO_TYPE_PA_PLAYER, RetroPaPlayer))
#define RETRO_PA_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RETRO_TYPE_PA_PLAYER, RetroPaPlayerClass))
#define RETRO_IS_PA_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RETRO_TYPE_PA_PLAYER))
#define RETRO_IS_PA_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RETRO_TYPE_PA_PLAYER))
#define RETRO_PA_PLAYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RETRO_TYPE_PA_PLAYER, RetroPaPlayerClass))

typedef struct _RetroPaPlayer RetroPaPlayer;
typedef struct _RetroPaPlayerClass RetroPaPlayerClass;
typedef struct _RetroPaPlayerPrivate RetroPaPlayerPrivate;

#define RETRO_TYPE_CORE (retro_core_get_type ())
#define RETRO_CORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RETRO_TYPE_CORE, RetroCore))
#define RETRO_CORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RETRO_TYPE_CORE, RetroCoreClass))
#define RETRO_IS_CORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RETRO_TYPE_CORE))
#define RETRO_IS_CORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RETRO_TYPE_CORE))
#define RETRO_CORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RETRO_TYPE_CORE, RetroCoreClass))

typedef struct _RetroCore RetroCore;
typedef struct _RetroCoreClass RetroCoreClass;

#define RETRO_TYPE_CONTROLLER_DESCRIPTION (retro_controller_description_get_type ())
typedef struct _RetroControllerDescription RetroControllerDescription;

#define RETRO_TYPE_CONTROLLER_INFO (retro_controller_info_get_type ())
typedef struct _RetroControllerInfo RetroControllerInfo;

#define RETRO_TYPE_DEVICE_TYPE (retro_device_type_get_type ())

#define RETRO_TYPE_JOYPAD_ID (retro_joypad_id_get_type ())

#define RETRO_TYPE_ANALOG_INDEX (retro_analog_index_get_type ())

#define RETRO_TYPE_ANALOG_ID (retro_analog_id_get_type ())

#define RETRO_TYPE_MOUSE_ID (retro_mouse_id_get_type ())

#define RETRO_TYPE_LIGHTGUN_ID (retro_lightgun_id_get_type ())

#define RETRO_TYPE_POINTER_ID (retro_pointer_id_get_type ())

#define RETRO_TYPE_INPUT_DESCRIPTOR (retro_input_descriptor_get_type ())
typedef struct _RetroInputDescriptor RetroInputDescriptor;

#define RETRO_TYPE_INPUT (retro_input_get_type ())
#define RETRO_INPUT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RETRO_TYPE_INPUT, RetroInput))
#define RETRO_IS_INPUT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RETRO_TYPE_INPUT))
#define RETRO_INPUT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RETRO_TYPE_INPUT, RetroInputIface))

typedef struct _RetroInput RetroInput;
typedef struct _RetroInputIface RetroInputIface;

#define RETRO_TYPE_INPUT_DEVICE (retro_input_device_get_type ())
#define RETRO_INPUT_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RETRO_TYPE_INPUT_DEVICE, RetroInputDevice))
#define RETRO_IS_INPUT_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RETRO_TYPE_INPUT_DEVICE))
#define RETRO_INPUT_DEVICE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RETRO_TYPE_INPUT_DEVICE, RetroInputDeviceIface))

typedef struct _RetroInputDevice RetroInputDevice;
typedef struct _RetroInputDeviceIface RetroInputDeviceIface;

#define RETRO_TYPE_INPUT_DEVICE_MANAGER (retro_input_device_manager_get_type ())
#define RETRO_INPUT_DEVICE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RETRO_TYPE_INPUT_DEVICE_MANAGER, RetroInputDeviceManager))
#define RETRO_INPUT_DEVICE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RETRO_TYPE_INPUT_DEVICE_MANAGER, RetroInputDeviceManagerClass))
#define RETRO_IS_INPUT_DEVICE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RETRO_TYPE_INPUT_DEVICE_MANAGER))
#define RETRO_IS_INPUT_DEVICE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RETRO_TYPE_INPUT_DEVICE_MANAGER))
#define RETRO_INPUT_DEVICE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RETRO_TYPE_INPUT_DEVICE_MANAGER, RetroInputDeviceManagerClass))

typedef struct _RetroInputDeviceManager RetroInputDeviceManager;
typedef struct _RetroInputDeviceManagerClass RetroInputDeviceManagerClass;
typedef struct _RetroInputDeviceManagerPrivate RetroInputDeviceManagerPrivate;

#define RETRO_TYPE_MAIN_LOOP (retro_main_loop_get_type ())
#define RETRO_MAIN_LOOP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RETRO_TYPE_MAIN_LOOP, RetroMainLoop))
#define RETRO_MAIN_LOOP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RETRO_TYPE_MAIN_LOOP, RetroMainLoopClass))
#define RETRO_IS_MAIN_LOOP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RETRO_TYPE_MAIN_LOOP))
#define RETRO_IS_MAIN_LOOP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RETRO_TYPE_MAIN_LOOP))
#define RETRO_MAIN_LOOP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RETRO_TYPE_MAIN_LOOP, RetroMainLoopClass))

typedef struct _RetroMainLoop RetroMainLoop;
typedef struct _RetroMainLoopClass RetroMainLoopClass;
typedef struct _RetroMainLoopPrivate RetroMainLoopPrivate;

#define RETRO_TYPE_OPTION (retro_option_get_type ())
#define RETRO_OPTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RETRO_TYPE_OPTION, RetroOption))
#define RETRO_OPTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RETRO_TYPE_OPTION, RetroOptionClass))
#define RETRO_IS_OPTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RETRO_TYPE_OPTION))
#define RETRO_IS_OPTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RETRO_TYPE_OPTION))
#define RETRO_OPTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RETRO_TYPE_OPTION, RetroOptionClass))

typedef struct _RetroOption RetroOption;
typedef struct _RetroOptionClass RetroOptionClass;
typedef struct _RetroOptionPrivate RetroOptionPrivate;

#define RETRO_TYPE_VARIABLE (retro_variable_get_type ())
typedef struct _RetroVariable RetroVariable;

#define RETRO_TYPE_VARIABLES (retro_variables_get_type ())
#define RETRO_VARIABLES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RETRO_TYPE_VARIABLES, RetroVariables))
#define RETRO_IS_VARIABLES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RETRO_TYPE_VARIABLES))
#define RETRO_VARIABLES_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RETRO_TYPE_VARIABLES, RetroVariablesIface))

typedef struct _RetroVariables RetroVariables;
typedef struct _RetroVariablesIface RetroVariablesIface;

#define RETRO_TYPE_OPTIONS (retro_options_get_type ())
#define RETRO_OPTIONS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RETRO_TYPE_OPTIONS, RetroOptions))
#define RETRO_OPTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RETRO_TYPE_OPTIONS, RetroOptionsClass))
#define RETRO_IS_OPTIONS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RETRO_TYPE_OPTIONS))
#define RETRO_IS_OPTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RETRO_TYPE_OPTIONS))
#define RETRO_OPTIONS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RETRO_TYPE_OPTIONS, RetroOptionsClass))

typedef struct _RetroOptions RetroOptions;
typedef struct _RetroOptionsClass RetroOptionsClass;
typedef struct _RetroOptionsPrivate RetroOptionsPrivate;
typedef struct _RetroCorePrivate RetroCorePrivate;

#define RETRO_TYPE_MEMORY_TYPE (retro_memory_type_get_type ())

#define RETRO_TYPE_RUMBLE (retro_rumble_get_type ())
#define RETRO_RUMBLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RETRO_TYPE_RUMBLE, RetroRumble))
#define RETRO_IS_RUMBLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RETRO_TYPE_RUMBLE))
#define RETRO_RUMBLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RETRO_TYPE_RUMBLE, RetroRumbleIface))

typedef struct _RetroRumble RetroRumble;
typedef struct _RetroRumbleIface RetroRumbleIface;

#define RETRO_TYPE_RUMBLE_EFFECT (retro_rumble_effect_get_type ())

#define RETRO_TYPE_CORE_DESCRIPTOR (retro_core_descriptor_get_type ())
#define RETRO_CORE_DESCRIPTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RETRO_TYPE_CORE_DESCRIPTOR, RetroCoreDescriptor))
#define RETRO_CORE_DESCRIPTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RETRO_TYPE_CORE_DESCRIPTOR, RetroCoreDescriptorClass))
#define RETRO_IS_CORE_DESCRIPTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RETRO_TYPE_CORE_DESCRIPTOR))
#define RETRO_IS_CORE_DESCRIPTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RETRO_TYPE_CORE_DESCRIPTOR))
#define RETRO_CORE_DESCRIPTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RETRO_TYPE_CORE_DESCRIPTOR, RetroCoreDescriptorClass))

typedef struct _RetroCoreDescriptor RetroCoreDescriptor;
typedef struct _RetroCoreDescriptorClass RetroCoreDescriptorClass;
typedef struct _RetroCoreDescriptorPrivate RetroCoreDescriptorPrivate;

#define RETRO_CORE_DESCRIPTOR_TYPE_PLATFORM (retro_core_descriptor_platform_get_type ())
#define RETRO_CORE_DESCRIPTOR_PLATFORM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RETRO_CORE_DESCRIPTOR_TYPE_PLATFORM, RetroCoreDescriptorPlatform))
#define RETRO_CORE_DESCRIPTOR_PLATFORM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RETRO_CORE_DESCRIPTOR_TYPE_PLATFORM, RetroCoreDescriptorPlatformClass))
#define RETRO_CORE_DESCRIPTOR_IS_PLATFORM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RETRO_CORE_DESCRIPTOR_TYPE_PLATFORM))
#define RETRO_CORE_DESCRIPTOR_IS_PLATFORM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RETRO_CORE_DESCRIPTOR_TYPE_PLATFORM))
#define RETRO_CORE_DESCRIPTOR_PLATFORM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RETRO_CORE_DESCRIPTOR_TYPE_PLATFORM, RetroCoreDescriptorPlatformClass))

typedef struct _RetroCoreDescriptorPlatform RetroCoreDescriptorPlatform;
typedef struct _RetroCoreDescriptorPlatformClass RetroCoreDescriptorPlatformClass;
typedef struct _RetroCoreDescriptorPlatformPrivate RetroCoreDescriptorPlatformPrivate;

#define RETRO_TYPE_CORE_VIEW (retro_core_view_get_type ())
#define RETRO_CORE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RETRO_TYPE_CORE_VIEW, RetroCoreView))
#define RETRO_CORE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RETRO_TYPE_CORE_VIEW, RetroCoreViewClass))
#define RETRO_IS_CORE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RETRO_TYPE_CORE_VIEW))
#define RETRO_IS_CORE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RETRO_TYPE_CORE_VIEW))
#define RETRO_CORE_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RETRO_TYPE_CORE_VIEW, RetroCoreViewClass))

typedef struct _RetroCoreView RetroCoreView;
typedef struct _RetroCoreViewClass RetroCoreViewClass;
typedef struct _RetroCoreViewPrivate RetroCoreViewPrivate;

#define RETRO_TYPE_CAIRO_DISPLAY (retro_cairo_display_get_type ())
#define RETRO_CAIRO_DISPLAY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RETRO_TYPE_CAIRO_DISPLAY, RetroCairoDisplay))
#define RETRO_CAIRO_DISPLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RETRO_TYPE_CAIRO_DISPLAY, RetroCairoDisplayClass))
#define RETRO_IS_CAIRO_DISPLAY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RETRO_TYPE_CAIRO_DISPLAY))
#define RETRO_IS_CAIRO_DISPLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RETRO_TYPE_CAIRO_DISPLAY))
#define RETRO_CAIRO_DISPLAY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RETRO_TYPE_CAIRO_DISPLAY, RetroCairoDisplayClass))

typedef struct _RetroCairoDisplay RetroCairoDisplay;
typedef struct _RetroCairoDisplayClass RetroCairoDisplayClass;

#define RETRO_TYPE_MODULE_QUERY (retro_module_query_get_type ())
#define RETRO_MODULE_QUERY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RETRO_TYPE_MODULE_QUERY, RetroModuleQuery))
#define RETRO_MODULE_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RETRO_TYPE_MODULE_QUERY, RetroModuleQueryClass))
#define RETRO_IS_MODULE_QUERY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RETRO_TYPE_MODULE_QUERY))
#define RETRO_IS_MODULE_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RETRO_TYPE_MODULE_QUERY))
#define RETRO_MODULE_QUERY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RETRO_TYPE_MODULE_QUERY, RetroModuleQueryClass))

typedef struct _RetroModuleQuery RetroModuleQuery;
typedef struct _RetroModuleQueryClass RetroModuleQueryClass;
typedef struct _RetroModuleQueryPrivate RetroModuleQueryPrivate;

#define RETRO_TYPE_MODULE_ITERATOR (retro_module_iterator_get_type ())
#define RETRO_MODULE_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RETRO_TYPE_MODULE_ITERATOR, RetroModuleIterator))
#define RETRO_MODULE_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RETRO_TYPE_MODULE_ITERATOR, RetroModuleIteratorClass))
#define RETRO_IS_MODULE_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RETRO_TYPE_MODULE_ITERATOR))
#define RETRO_IS_MODULE_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RETRO_TYPE_MODULE_ITERATOR))
#define RETRO_MODULE_ITERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RETRO_TYPE_MODULE_ITERATOR, RetroModuleIteratorClass))

typedef struct _RetroModuleIterator RetroModuleIterator;
typedef struct _RetroModuleIteratorClass RetroModuleIteratorClass;
typedef struct _RetroModuleIteratorPrivate RetroModuleIteratorPrivate;

#define RETRO_TYPE_PIXEL_FORMAT (retro_pixel_format_get_type ())
typedef struct _RetroCairoDisplayPrivate RetroCairoDisplayPrivate;

#define RETRO_TYPE_VIDEO_FILTER (retro_video_filter_get_type ())

struct _RetroPaPlayer {
	GObject parent_instance;
	RetroPaPlayerPrivate * priv;
};

struct _RetroPaPlayerClass {
	GObjectClass parent_class;
};

struct _RetroControllerDescription {
	gchar* desc;
	guint id;
};

struct _RetroControllerInfo {
	RetroControllerDescription* types;
	guint num_types;
};

typedef enum  {
	RETRO_DEVICE_TYPE_TYPE_MASK = 0xff,
	RETRO_DEVICE_TYPE_NONE = 0,
	RETRO_DEVICE_TYPE_JOYPAD = 1,
	RETRO_DEVICE_TYPE_MOUSE = 2,
	RETRO_DEVICE_TYPE_KEYBOARD = 3,
	RETRO_DEVICE_TYPE_LIGHTGUN = 4,
	RETRO_DEVICE_TYPE_ANALOG = 5,
	RETRO_DEVICE_TYPE_POINTER = 6
} RetroDeviceType;

typedef enum  {
	RETRO_JOYPAD_ID_B,
	RETRO_JOYPAD_ID_Y,
	RETRO_JOYPAD_ID_SELECT,
	RETRO_JOYPAD_ID_START,
	RETRO_JOYPAD_ID_UP,
	RETRO_JOYPAD_ID_DOWN,
	RETRO_JOYPAD_ID_LEFT,
	RETRO_JOYPAD_ID_RIGHT,
	RETRO_JOYPAD_ID_A,
	RETRO_JOYPAD_ID_X,
	RETRO_JOYPAD_ID_L,
	RETRO_JOYPAD_ID_R,
	RETRO_JOYPAD_ID_L2,
	RETRO_JOYPAD_ID_R2,
	RETRO_JOYPAD_ID_L3,
	RETRO_JOYPAD_ID_R3,
	RETRO_JOYPAD_ID_COUNT
} RetroJoypadId;

typedef enum  {
	RETRO_ANALOG_INDEX_LEFT,
	RETRO_ANALOG_INDEX_RIGHT
} RetroAnalogIndex;

typedef enum  {
	RETRO_ANALOG_ID_X,
	RETRO_ANALOG_ID_Y
} RetroAnalogId;

typedef enum  {
	RETRO_MOUSE_ID_X,
	RETRO_MOUSE_ID_Y,
	RETRO_MOUSE_ID_LEFT,
	RETRO_MOUSE_ID_RIGHT,
	RETRO_MOUSE_ID_WHEELUP,
	RETRO_MOUSE_ID_WHEELDOWN,
	RETRO_MOUSE_ID_MIDDLE,
	RETRO_MOUSE_ID_HORIZ_WHEELUP,
	RETRO_MOUSE_ID_HORIZ_WHEELDOWN
} RetroMouseId;

typedef enum  {
	RETRO_LIGHTGUN_ID_X,
	RETRO_LIGHTGUN_ID_Y,
	RETRO_LIGHTGUN_ID_TRIGGER,
	RETRO_LIGHTGUN_ID_CURSOR,
	RETRO_LIGHTGUN_ID_TURBO,
	RETRO_LIGHTGUN_ID_PAUSE,
	RETRO_LIGHTGUN_ID_START
} RetroLightgunId;

typedef enum  {
	RETRO_POINTER_ID_X,
	RETRO_POINTER_ID_Y,
	RETRO_POINTER_ID_PRESSED
} RetroPointerId;

struct _RetroInputDescriptor {
	guint port;
	RetroDeviceType device;
	guint index;
	guint id;
	gchar* description;
};

struct _RetroInputDeviceIface {
	GTypeInterface parent_iface;
	void (*poll) (RetroInputDevice* self);
	gint16 (*get_input_state) (RetroInputDevice* self, RetroDeviceType device, guint index, guint id);
	RetroDeviceType (*get_device_type) (RetroInputDevice* self);
	guint64 (*get_device_capabilities) (RetroInputDevice* self);
};

typedef void (*RetroInputControllerCallback) (guint port, RetroInputDevice* device, void* user_data);
struct _RetroInputIface {
	GTypeInterface parent_iface;
	void (*poll) (RetroInput* self);
	gint16 (*get_state) (RetroInput* self, guint port, RetroDeviceType device, guint index, guint id);
	void (*set_descriptors) (RetroInput* self, RetroInputDescriptor* input_descriptors, int input_descriptors_length1);
	guint64 (*get_device_capabilities) (RetroInput* self);
	void (*foreach_controller) (RetroInput* self, RetroInputControllerCallback callback, void* callback_target);
};

struct _RetroInputDeviceManager {
	GObject parent_instance;
	RetroInputDeviceManagerPrivate * priv;
};

struct _RetroInputDeviceManagerClass {
	GObjectClass parent_class;
};

struct _RetroMainLoop {
	GObject parent_instance;
	RetroMainLoopPrivate * priv;
};

struct _RetroMainLoopClass {
	GObjectClass parent_class;
};

struct _RetroOption {
	GObject parent_instance;
	RetroOptionPrivate * priv;
	gchar* key;
	gchar* description;
	gchar** values;
	gint values_length1;
	gint _values_size_;
};

struct _RetroOptionClass {
	GObjectClass parent_class;
};

struct _RetroVariable {
	gchar* key;
	gchar* value;
};

struct _RetroVariablesIface {
	GTypeInterface parent_iface;
	gchar* (*get_variable) (RetroVariables* self, const gchar* key);
	void (*set_variable) (RetroVariables* self, RetroVariable* variables, int variables_length1);
	gboolean (*get_variable_update) (RetroVariables* self);
	RetroCore* (*get_core) (RetroVariables* self);
	void (*set_core) (RetroVariables* self, RetroCore* value);
};

struct _RetroOptions {
	GObject parent_instance;
	RetroOptionsPrivate * priv;
	RetroCore* _core;
};

struct _RetroOptionsClass {
	GObjectClass parent_class;
};

struct _RetroCore {
	GObject parent_instance;
	RetroCorePrivate * priv;
	gdouble _frames_per_second;
	RetroVariables* variables_interface;
	void* environment_internal;
};

struct _RetroCoreClass {
	GObjectClass parent_class;
};

typedef enum  {
	RETRO_MEMORY_TYPE_SAVE_RAM = 0,
	RETRO_MEMORY_TYPE_RTC = 1,
	RETRO_MEMORY_TYPE_SYSTEM_RAM = 2,
	RETRO_MEMORY_TYPE_VIDEO_RAM = 3
} RetroMemoryType;

typedef enum  {
	RETRO_RUMBLE_EFFECT_STRONG,
	RETRO_RUMBLE_EFFECT_WEAK
} RetroRumbleEffect;

struct _RetroRumbleIface {
	GTypeInterface parent_iface;
	gboolean (*set_rumble_state) (RetroRumble* self, guint port, RetroRumbleEffect effect, guint16 strength);
};

typedef enum  {
	RETRO_CORE_ERROR_COULDNT_SERIALIZE,
	RETRO_CORE_ERROR_COULDNT_DESERIALIZE,
	RETRO_CORE_ERROR_SERIALIZATION_NOT_SUPPORTED
} RetroCoreError;
#define RETRO_CORE_ERROR retro_core_error_quark ()
typedef enum  {
	RETRO_CB_ERROR_NO_CORE,
	RETRO_CB_ERROR_NO_CALLBACK
} RetroCbError;
#define RETRO_CB_ERROR retro_cb_error_quark ()
struct _RetroCoreDescriptor {
	GObject parent_instance;
	RetroCoreDescriptorPrivate * priv;
};

struct _RetroCoreDescriptorClass {
	GObjectClass parent_class;
};

struct _RetroCoreDescriptorPlatform {
	GObject parent_instance;
	RetroCoreDescriptorPlatformPrivate * priv;
};

struct _RetroCoreDescriptorPlatformClass {
	GObjectClass parent_class;
};

typedef enum  {
	RETRO_CORE_DESCRIPTOR_ERROR_REQUIRED_GROUP_NOT_FOUND,
	RETRO_CORE_DESCRIPTOR_ERROR_REQUIRED_KEY_NOT_FOUND,
	RETRO_CORE_DESCRIPTOR_ERROR_FIRMWARE_NOT_FOUND
} RetroCoreDescriptorError;
#define RETRO_CORE_DESCRIPTOR_ERROR retro_core_descriptor_error_quark ()
struct _RetroCoreView {
	GtkEventBox parent_instance;
	RetroCoreViewPrivate * priv;
	RetroCairoDisplay* display;
	GHashTable* key_state;
	GHashTable* mouse_button_state;
	GdkScreen* grabbed_screen;
	GdkDevice* grabbed_device;
	gdouble mouse_x_delta;
	gdouble mouse_y_delta;
	gint screen_center_x;
	gint screen_center_y;
	gint position_on_grab_x;
	gint position_on_grab_y;
	gboolean pointer_is_on_display;
	gdouble pointer_x;
	gdouble pointer_y;
};

struct _RetroCoreViewClass {
	GtkEventBoxClass parent_class;
};

struct _RetroModuleQuery {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RetroModuleQueryPrivate * priv;
};

struct _RetroModuleQueryClass {
	GTypeClass parent_class;
	void (*finalize) (RetroModuleQuery *self);
};

struct _RetroModuleIterator {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RetroModuleIteratorPrivate * priv;
};

struct _RetroModuleIteratorClass {
	GTypeClass parent_class;
	void (*finalize) (RetroModuleIterator *self);
};

typedef enum  {
	RETRO_PIXEL_FORMAT_XRGB1555,
	RETRO_PIXEL_FORMAT_XRGB8888,
	RETRO_PIXEL_FORMAT_RGB565,
	RETRO_PIXEL_FORMAT_UNKNOWN = -1
} RetroPixelFormat;

struct _RetroCairoDisplay {
	GtkDrawingArea parent_instance;
	RetroCairoDisplayPrivate * priv;
};

struct _RetroCairoDisplayClass {
	GtkDrawingAreaClass parent_class;
};

typedef enum  {
	RETRO_VIDEO_FILTER_SMOOTH,
	RETRO_VIDEO_FILTER_SHARP
} RetroVideoFilter;


GType retro_pa_player_get_type (void) G_GNUC_CONST;
GType retro_core_get_type (void) G_GNUC_CONST;
void retro_pa_player_set_core (RetroPaPlayer* self, RetroCore* core);
RetroPaPlayer* retro_pa_player_new (void);
RetroPaPlayer* retro_pa_player_construct (GType object_type);
GType retro_controller_description_get_type (void) G_GNUC_CONST;
RetroControllerDescription* retro_controller_description_dup (const RetroControllerDescription* self);
void retro_controller_description_free (RetroControllerDescription* self);
void retro_controller_description_copy (const RetroControllerDescription* self, RetroControllerDescription* dest);
void retro_controller_description_destroy (RetroControllerDescription* self);
GType retro_controller_info_get_type (void) G_GNUC_CONST;
RetroControllerInfo* retro_controller_info_dup (const RetroControllerInfo* self);
void retro_controller_info_free (RetroControllerInfo* self);
void retro_controller_info_copy (const RetroControllerInfo* self, RetroControllerInfo* dest);
void retro_controller_info_destroy (RetroControllerInfo* self);
GType retro_device_type_get_type (void) G_GNUC_CONST;
RetroDeviceType retro_device_type_get_basic_type (RetroDeviceType self);
GType retro_joypad_id_get_type (void) G_GNUC_CONST;
GType retro_analog_index_get_type (void) G_GNUC_CONST;
GType retro_analog_id_get_type (void) G_GNUC_CONST;
GType retro_mouse_id_get_type (void) G_GNUC_CONST;
GType retro_lightgun_id_get_type (void) G_GNUC_CONST;
GType retro_pointer_id_get_type (void) G_GNUC_CONST;
GType retro_input_descriptor_get_type (void) G_GNUC_CONST;
RetroInputDescriptor* retro_input_descriptor_dup (const RetroInputDescriptor* self);
void retro_input_descriptor_free (RetroInputDescriptor* self);
void retro_input_descriptor_copy (const RetroInputDescriptor* self, RetroInputDescriptor* dest);
void retro_input_descriptor_destroy (RetroInputDescriptor* self);
GType retro_input_device_get_type (void) G_GNUC_CONST;
GType retro_input_get_type (void) G_GNUC_CONST;
void retro_input_poll (RetroInput* self);
gint16 retro_input_get_state (RetroInput* self, guint port, RetroDeviceType device, guint index, guint id);
void retro_input_set_descriptors (RetroInput* self, RetroInputDescriptor* input_descriptors, int input_descriptors_length1);
guint64 retro_input_get_device_capabilities (RetroInput* self);
void retro_input_foreach_controller (RetroInput* self, RetroInputControllerCallback callback, void* callback_target);
void retro_input_device_poll (RetroInputDevice* self);
gint16 retro_input_device_get_input_state (RetroInputDevice* self, RetroDeviceType device, guint index, guint id);
RetroDeviceType retro_input_device_get_device_type (RetroInputDevice* self);
guint64 retro_input_device_get_device_capabilities (RetroInputDevice* self);
GType retro_input_device_manager_get_type (void) G_GNUC_CONST;
void retro_input_device_manager_set_controller_device (RetroInputDeviceManager* self, guint port, RetroInputDevice* device);
void retro_input_device_manager_set_keyboard (RetroInputDeviceManager* self, GtkWidget* widget);
void retro_input_device_manager_remove_controller_device (RetroInputDeviceManager* self, guint port);
RetroInputDeviceManager* retro_input_device_manager_new (void);
RetroInputDeviceManager* retro_input_device_manager_construct (GType object_type);
GType retro_main_loop_get_type (void) G_GNUC_CONST;
RetroMainLoop* retro_main_loop_new (RetroCore* core);
RetroMainLoop* retro_main_loop_construct (GType object_type, RetroCore* core);
void retro_main_loop_start (RetroMainLoop* self);
void retro_main_loop_reset (RetroMainLoop* self);
void retro_main_loop_stop (RetroMainLoop* self);
RetroCore* retro_main_loop_get_core (RetroMainLoop* self);
void retro_main_loop_set_core (RetroMainLoop* self, RetroCore* value);
gdouble retro_main_loop_get_speed_rate (RetroMainLoop* self);
void retro_main_loop_set_speed_rate (RetroMainLoop* self, gdouble value);
GType retro_option_get_type (void) G_GNUC_CONST;
GType retro_variable_get_type (void) G_GNUC_CONST;
RetroVariable* retro_variable_dup (const RetroVariable* self);
void retro_variable_free (RetroVariable* self);
void retro_variable_copy (const RetroVariable* self, RetroVariable* dest);
void retro_variable_destroy (RetroVariable* self);
RetroOption* retro_option_new (RetroVariable* variable);
RetroOption* retro_option_construct (GType object_type, RetroVariable* variable);
const gchar* retro_option_get_current (RetroOption* self);
void retro_option_set_current (RetroOption* self, const gchar* value);
GType retro_variables_get_type (void) G_GNUC_CONST;
GType retro_options_get_type (void) G_GNUC_CONST;
void retro_options_set_option (RetroOptions* self, gchar* key, gchar* value);
void retro_options_set (RetroOptions* self, gchar* key, gchar* value);
gboolean retro_options_contains (RetroOptions* self, const gchar* key);
const gchar* retro_options_lookup (RetroOptions* self, const gchar* key);
const gchar* retro_options_lookup_description (RetroOptions* self, const gchar* key);
gchar** retro_options_lookup_values (RetroOptions* self, const gchar* key, int* result_length1);
const gchar* retro_options_get (RetroOptions* self, const gchar* key);
GList* retro_options_get_keys (RetroOptions* self);
void retro_options_for_each (RetroOptions* self, GHFunc func, void* func_target);
void retro_options_foreach (RetroOptions* self, GHFunc func, void* func_target);
guint retro_options_size (RetroOptions* self);
RetroOptions* retro_options_new (void);
RetroOptions* retro_options_construct (GType object_type);
gchar* retro_variables_get_variable (RetroVariables* self, const gchar* key);
void retro_variables_set_variable (RetroVariables* self, RetroVariable* variables, int variables_length1);
gboolean retro_variables_get_variable_update (RetroVariables* self);
RetroCore* retro_variables_get_core (RetroVariables* self);
void retro_variables_set_core (RetroVariables* self, RetroCore* value);
void retro_core_push_cb_data (RetroCore* self);
void retro_core_pop_cb_data (void);
RetroCore* retro_core_get_cb_data (void);
RetroCore* retro_core_new (const gchar* file_name);
RetroCore* retro_core_construct (GType object_type, const gchar* file_name);
void retro_core_init (RetroCore* self, GError** error);
void retro_core_set_medias (RetroCore* self, gchar** uris);
void retro_core_set_current_media (RetroCore* self, guint media_index, GError** error);
void retro_core_set_controller_port_device (RetroCore* self, guint port, RetroDeviceType device);
void retro_core_reset (RetroCore* self);
void retro_core_run (RetroCore* self);
gboolean retro_core_supports_serialization (RetroCore* self);
guint8* retro_core_serialize_state (RetroCore* self, gsize* result_length1, GError** error);
void retro_core_deserialize_state (RetroCore* self, guint8* data, gsize data_length1, GError** error);
GType retro_memory_type_get_type (void) G_GNUC_CONST;
gsize retro_core_get_memory_size (RetroCore* self, RetroMemoryType id);
guint8* retro_core_get_memory (RetroCore* self, RetroMemoryType id, int* result_length1);
void retro_core_set_memory (RetroCore* self, RetroMemoryType id, guint8* data, int data_length1);
guint retro_core_get_api_version (RetroCore* self);
const gchar* retro_core_get_file_name (RetroCore* self);
void retro_core_set_file_name (RetroCore* self, const gchar* value);
const gchar* retro_core_get_system_directory (RetroCore* self);
void retro_core_set_system_directory (RetroCore* self, const gchar* value);
const gchar* retro_core_get_libretro_path (RetroCore* self);
void retro_core_set_libretro_path (RetroCore* self, const gchar* value);
const gchar* retro_core_get_content_directory (RetroCore* self);
void retro_core_set_content_directory (RetroCore* self, const gchar* value);
const gchar* retro_core_get_save_directory (RetroCore* self);
void retro_core_set_save_directory (RetroCore* self, const gchar* value);
gboolean retro_core_get_is_initiated (RetroCore* self);
void retro_core_set_is_initiated (RetroCore* self, gboolean value);
gboolean retro_core_get_game_loaded (RetroCore* self);
void retro_core_set_game_loaded (RetroCore* self, gboolean value);
gboolean retro_core_get_support_no_game (RetroCore* self);
void retro_core_set_support_no_game (RetroCore* self, gboolean value);
gdouble retro_core_get_frames_per_second (RetroCore* self);
RetroInput* retro_core_get_input_interface (RetroCore* self);
void retro_core_set_input_interface (RetroCore* self, RetroInput* value);
GType retro_rumble_effect_get_type (void) G_GNUC_CONST;
GType retro_rumble_get_type (void) G_GNUC_CONST;
RetroRumble* retro_core_get_rumble_interface (RetroCore* self);
void retro_core_set_rumble_interface (RetroCore* self, RetroRumble* value);
GQuark retro_core_error_quark (void);
#define RETRO_API_VERSION ((guint) 1)
#define RETRO_ENV_PLUGIN_PATH "RETRO_PLUGIN_PATH_1_0"
GQuark retro_cb_error_quark (void);
void retro_g_log (RetroCore* core, const gchar* log_domain, GLogLevelFlags log_level, const gchar* message);
GType retro_core_descriptor_get_type (void) G_GNUC_CONST;
RetroCoreDescriptor* retro_core_descriptor_new (const gchar* filename, GError** error);
RetroCoreDescriptor* retro_core_descriptor_construct (GType object_type, const gchar* filename, GError** error);
gboolean retro_core_descriptor_has_icon (RetroCoreDescriptor* self, GError** error);
gchar* retro_core_descriptor_get_uri (RetroCoreDescriptor* self);
gchar* retro_core_descriptor_get_id (RetroCoreDescriptor* self);
gboolean retro_core_descriptor_get_is_game (RetroCoreDescriptor* self, GError** error);
gboolean retro_core_descriptor_get_is_emulator (RetroCoreDescriptor* self, GError** error);
gchar* retro_core_descriptor_get_name (RetroCoreDescriptor* self, GError** error);
GIcon* retro_core_descriptor_get_icon (RetroCoreDescriptor* self, GError** error);
gchar* retro_core_descriptor_get_module (RetroCoreDescriptor* self, GError** error);
GFile* retro_core_descriptor_get_module_file (RetroCoreDescriptor* self, GError** error);
gboolean retro_core_descriptor_has_platform (RetroCoreDescriptor* self, const gchar* platform);
gboolean retro_core_descriptor_has_firmwares (RetroCoreDescriptor* self, const gchar* platform, GError** error);
gboolean retro_core_descriptor_has_firmware_md5 (RetroCoreDescriptor* self, const gchar* firmware, GError** error);
gboolean retro_core_descriptor_has_firmware_sha512 (RetroCoreDescriptor* self, const gchar* firmware, GError** error);
gchar** retro_core_descriptor_get_mime_type (RetroCoreDescriptor* self, const gchar* platform, int* result_length1, GError** error);
gchar** retro_core_descriptor_get_firmwares (RetroCoreDescriptor* self, const gchar* platform, int* result_length1, GError** error);
gchar* retro_core_descriptor_get_firmware_path (RetroCoreDescriptor* self, const gchar* firmware, GError** error);
gchar* retro_core_descriptor_get_firmware_md5 (RetroCoreDescriptor* self, const gchar* firmware, GError** error);
gchar* retro_core_descriptor_get_firmware_sha512 (RetroCoreDescriptor* self, const gchar* firmware, GError** error);
gboolean retro_core_descriptor_get_is_firmware_mandatory (RetroCoreDescriptor* self, const gchar* firmware, GError** error);
gboolean retro_core_descriptor_get_platform_supports_mime_types (RetroCoreDescriptor* self, const gchar* platform, gchar** mime_types, int mime_types_length1, GError** error);
GType retro_core_descriptor_platform_get_type (void) G_GNUC_CONST;
GQuark retro_core_descriptor_error_quark (void);
GType retro_core_view_get_type (void) G_GNUC_CONST;
GType retro_cairo_display_get_type (void) G_GNUC_CONST;
void retro_core_view_set_core (RetroCoreView* self, RetroCore* core);
RetroCairoDisplay* retro_core_view_get_display (RetroCoreView* self);
RetroInputDevice* retro_core_view_as_input_device (RetroCoreView* self, RetroDeviceType device_type);
gint16 retro_core_view_get_input_state (RetroCoreView* self, RetroDeviceType device, guint index, guint id);
guint64 retro_core_view_get_device_capabilities (RetroCoreView* self);
gboolean retro_core_view_get_is_pointer_grabbed (RetroCoreView* self);
void retro_core_view_ungrab (RetroCoreView* self);
gboolean retro_core_view_on_key_press_event (RetroCoreView* self, GtkWidget* source, GdkEventKey* event);
gboolean retro_core_view_on_key_release_event (RetroCoreView* self, GtkWidget* source, GdkEventKey* event);
gboolean retro_core_view_on_button_press_event (RetroCoreView* self, GtkWidget* source, GdkEventButton* event);
gboolean retro_core_view_on_button_release_event (RetroCoreView* self, GtkWidget* source, GdkEventButton* event);
gboolean retro_core_view_on_focus_out_event (RetroCoreView* self, GtkWidget* source, GdkEventFocus* event);
gboolean retro_core_view_on_motion_notify_event (RetroCoreView* self, GtkWidget* source, GdkEventMotion* event);
RetroCoreView* retro_core_view_new (void);
RetroCoreView* retro_core_view_construct (GType object_type);
gboolean retro_core_view_get_can_grab_pointer (RetroCoreView* self);
void retro_core_view_set_can_grab_pointer (RetroCoreView* self, gboolean value);
gboolean retro_core_view_get_snap_pointer_to_borders (RetroCoreView* self);
void retro_core_view_set_snap_pointer_to_borders (RetroCoreView* self, gboolean value);
gpointer retro_module_query_ref (gpointer instance);
void retro_module_query_unref (gpointer instance);
GParamSpec* retro_param_spec_module_query (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void retro_value_set_module_query (GValue* value, gpointer v_object);
void retro_value_take_module_query (GValue* value, gpointer v_object);
gpointer retro_value_get_module_query (const GValue* value);
GType retro_module_query_get_type (void) G_GNUC_CONST;
RetroModuleQuery* retro_module_query_new (gboolean recursive);
RetroModuleQuery* retro_module_query_construct (GType object_type, gboolean recursive);
gpointer retro_module_iterator_ref (gpointer instance);
void retro_module_iterator_unref (gpointer instance);
GParamSpec* retro_param_spec_module_iterator (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void retro_value_set_module_iterator (GValue* value, gpointer v_object);
void retro_value_take_module_iterator (GValue* value, gpointer v_object);
gpointer retro_value_get_module_iterator (const GValue* value);
GType retro_module_iterator_get_type (void) G_GNUC_CONST;
RetroModuleIterator* retro_module_query_iterator (RetroModuleQuery* self);
RetroModuleIterator* retro_module_iterator_new (gchar** lookup_paths, int lookup_paths_length1, gboolean recursive);
RetroModuleIterator* retro_module_iterator_construct (GType object_type, gchar** lookup_paths, int lookup_paths_length1, gboolean recursive);
RetroCoreDescriptor* retro_module_iterator_get (RetroModuleIterator* self);
gboolean retro_module_iterator_next (RetroModuleIterator* self);
gboolean retro_rumble_set_rumble_state (RetroRumble* self, guint port, RetroRumbleEffect effect, guint16 strength);
GType retro_pixel_format_get_type (void) G_GNUC_CONST;
void retro_cairo_display_set_core (RetroCairoDisplay* self, RetroCore* core);
GType retro_video_filter_get_type (void) G_GNUC_CONST;
void retro_cairo_display_set_filter (RetroCairoDisplay* self, RetroVideoFilter filter);
gboolean retro_cairo_display_get_coordinates_on_display (RetroCairoDisplay* self, gdouble widget_x, gdouble widget_y, gdouble* display_x, gdouble* display_y);
void retro_cairo_display_show_video (RetroCairoDisplay* self);
void retro_cairo_display_hide_video (RetroCairoDisplay* self);
RetroCairoDisplay* retro_cairo_display_new (void);
RetroCairoDisplay* retro_cairo_display_construct (GType object_type);
GdkPixbuf* retro_cairo_display_get_pixbuf (RetroCairoDisplay* self);
void retro_cairo_display_set_pixbuf (RetroCairoDisplay* self, GdkPixbuf* value);
RetroVideoFilter retro_video_filter_from_string (const gchar* filter);


G_END_DECLS

#endif
