/* options.c generated by valac 0.36.1.39-72bb2, the Vala compiler
 * generated from options.vala, do not modify */

/* This file is part of retro-gtk. License: GPL-3.0+.*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>


#define RETRO_TYPE_OPTION (retro_option_get_type ())
#define RETRO_OPTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RETRO_TYPE_OPTION, RetroOption))
#define RETRO_OPTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RETRO_TYPE_OPTION, RetroOptionClass))
#define RETRO_IS_OPTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RETRO_TYPE_OPTION))
#define RETRO_IS_OPTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RETRO_TYPE_OPTION))
#define RETRO_OPTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RETRO_TYPE_OPTION, RetroOptionClass))

typedef struct _RetroOption RetroOption;
typedef struct _RetroOptionClass RetroOptionClass;
typedef struct _RetroOptionPrivate RetroOptionPrivate;
enum  {
	RETRO_OPTION_DUMMY_PROPERTY,
	RETRO_OPTION_CURRENT,
	RETRO_OPTION_LAST_PROPERTY
};
static GParamSpec* retro_option_properties[RETRO_OPTION_LAST_PROPERTY];
#define _g_free0(var) (var = (g_free (var), NULL))

#define RETRO_TYPE_VARIABLE (retro_variable_get_type ())
typedef struct _RetroVariable RetroVariable;

#define RETRO_TYPE_VARIABLES (retro_variables_get_type ())
#define RETRO_VARIABLES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RETRO_TYPE_VARIABLES, RetroVariables))
#define RETRO_IS_VARIABLES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RETRO_TYPE_VARIABLES))
#define RETRO_VARIABLES_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RETRO_TYPE_VARIABLES, RetroVariablesIface))

typedef struct _RetroVariables RetroVariables;
typedef struct _RetroVariablesIface RetroVariablesIface;

#define RETRO_TYPE_CORE (retro_core_get_type ())
#define RETRO_CORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RETRO_TYPE_CORE, RetroCore))
#define RETRO_CORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RETRO_TYPE_CORE, RetroCoreClass))
#define RETRO_IS_CORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RETRO_TYPE_CORE))
#define RETRO_IS_CORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RETRO_TYPE_CORE))
#define RETRO_CORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RETRO_TYPE_CORE, RetroCoreClass))

typedef struct _RetroCore RetroCore;
typedef struct _RetroCoreClass RetroCoreClass;

#define RETRO_TYPE_OPTIONS (retro_options_get_type ())
#define RETRO_OPTIONS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RETRO_TYPE_OPTIONS, RetroOptions))
#define RETRO_OPTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RETRO_TYPE_OPTIONS, RetroOptionsClass))
#define RETRO_IS_OPTIONS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RETRO_TYPE_OPTIONS))
#define RETRO_IS_OPTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RETRO_TYPE_OPTIONS))
#define RETRO_OPTIONS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RETRO_TYPE_OPTIONS, RetroOptionsClass))

typedef struct _RetroOptions RetroOptions;
typedef struct _RetroOptionsClass RetroOptionsClass;
typedef struct _RetroOptionsPrivate RetroOptionsPrivate;
enum  {
	RETRO_OPTIONS_DUMMY_PROPERTY,
	RETRO_OPTIONS_CORE,
	RETRO_OPTIONS_LAST_PROPERTY
};
static GParamSpec* retro_options_properties[RETRO_OPTIONS_LAST_PROPERTY];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
typedef struct _RetroCorePrivate RetroCorePrivate;
enum  {
	RETRO_OPTIONS_VALUE_CHANGED_SIGNAL,
	RETRO_OPTIONS_LAST_SIGNAL
};
static guint retro_options_signals[RETRO_OPTIONS_LAST_SIGNAL] = {0};

struct _RetroOption {
	GObject parent_instance;
	RetroOptionPrivate * priv;
	gchar* key;
	gchar* description;
	gchar** values;
	gint values_length1;
	gint _values_size_;
};

struct _RetroOptionClass {
	GObjectClass parent_class;
};

struct _RetroOptionPrivate {
	gchar* _current;
};

struct _RetroVariable {
	gchar* key;
	gchar* value;
};

struct _RetroVariablesIface {
	GTypeInterface parent_iface;
	gchar* (*get_variable) (RetroVariables* self, const gchar* key);
	void (*set_variable) (RetroVariables* self, RetroVariable* variables, int variables_length1);
	gboolean (*get_variable_update) (RetroVariables* self);
	RetroCore* (*get_core) (RetroVariables* self);
	void (*set_core) (RetroVariables* self, RetroCore* value);
};

struct _RetroOptions {
	GObject parent_instance;
	RetroOptionsPrivate * priv;
	RetroCore* _core;
};

struct _RetroOptionsClass {
	GObjectClass parent_class;
};

struct _RetroOptionsPrivate {
	GHashTable* table;
	gboolean update;
};

struct _RetroCore {
	GObject parent_instance;
	RetroCorePrivate * priv;
	gdouble _frames_per_second;
	RetroVariables* variables_interface;
	void* environment_internal;
};

struct _RetroCoreClass {
	GObjectClass parent_class;
};


static gpointer retro_option_parent_class = NULL;
static gpointer retro_options_parent_class = NULL;
static RetroVariablesIface * retro_options_retro_variables_parent_iface = NULL;

GType retro_option_get_type (void) G_GNUC_CONST;
#define RETRO_OPTION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RETRO_TYPE_OPTION, RetroOptionPrivate))
GType retro_variable_get_type (void) G_GNUC_CONST;
RetroVariable* retro_variable_dup (const RetroVariable* self);
void retro_variable_free (RetroVariable* self);
void retro_variable_copy (const RetroVariable* self, RetroVariable* dest);
void retro_variable_destroy (RetroVariable* self);
RetroOption* retro_option_new (RetroVariable* variable);
RetroOption* retro_option_construct (GType object_type, RetroVariable* variable);
void retro_option_set_current (RetroOption* self, const gchar* value);
const gchar* retro_option_get_current (RetroOption* self);
static gboolean _vala_string_array_contains (gchar* * stack, int stack_length, gchar* needle);
static void retro_option_finalize (GObject * obj);
static void _vala_retro_option_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_retro_option_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType retro_core_get_type (void) G_GNUC_CONST;
GType retro_variables_get_type (void) G_GNUC_CONST;
GType retro_options_get_type (void) G_GNUC_CONST;
#define RETRO_OPTIONS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RETRO_TYPE_OPTIONS, RetroOptionsPrivate))
static void retro_options_insert_multiple (RetroOptions* self, RetroVariable* variables, int variables_length1);
static void retro_options_insert (RetroOptions* self, gchar* key, RetroVariable* value);
void retro_options_set_option (RetroOptions* self, gchar* key, gchar* value);
void retro_options_set (RetroOptions* self, gchar* key, gchar* value);
gboolean retro_options_contains (RetroOptions* self, const gchar* key);
const gchar* retro_options_lookup (RetroOptions* self, const gchar* key);
const gchar* retro_options_lookup_description (RetroOptions* self, const gchar* key);
gchar** retro_options_lookup_values (RetroOptions* self, const gchar* key, int* result_length1);
const gchar* retro_options_get (RetroOptions* self, const gchar* key);
GList* retro_options_get_keys (RetroOptions* self);
void retro_options_for_each (RetroOptions* self, GHFunc func, void* func_target);
void retro_options_foreach (RetroOptions* self, GHFunc func, void* func_target);
guint retro_options_size (RetroOptions* self);
static gchar* retro_options_real_get_variable (RetroVariables* base, const gchar* key);
static void retro_options_real_set_variable (RetroVariables* base, RetroVariable* variables, int variables_length1);
static gboolean retro_options_real_get_variable_update (RetroVariables* base);
RetroOptions* retro_options_new (void);
RetroOptions* retro_options_construct (GType object_type);
static GObject * retro_options_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _g_free0_ (gpointer var);
static void _g_object_unref0_ (gpointer var);
static void retro_options_finalize (GObject * obj);
RetroCore* retro_variables_get_core (RetroVariables* self);
static void _vala_retro_options_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
void retro_variables_set_core (RetroVariables* self, RetroCore* value);
static void _vala_retro_options_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


RetroOption* retro_option_construct (GType object_type, RetroVariable* variable) {
	RetroOption * self = NULL;
	gchar** desc_and_vals = NULL;
	RetroVariable _tmp0_;
	const gchar* _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint desc_and_vals_length1;
	gint _desc_and_vals_size_;
	RetroVariable _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	const gchar* _tmp9_;
	gchar** _tmp10_;
	gchar** _tmp11_;
	gchar** _tmp12_;
	gint _tmp12__length1;
	const gchar* _tmp13_;
	g_return_val_if_fail (variable != NULL, NULL);
	self = (RetroOption*) g_object_new (object_type, NULL);
	_tmp0_ = *variable;
	_tmp1_ = _tmp0_.value;
	_tmp3_ = _tmp2_ = g_strsplit (_tmp1_, "; ", 2);
	desc_and_vals = _tmp3_;
	desc_and_vals_length1 = _vala_array_length (_tmp2_);
	_desc_and_vals_size_ = desc_and_vals_length1;
	_tmp4_ = *variable;
	_tmp5_ = _tmp4_.key;
	_tmp6_ = g_strdup (_tmp5_);
	_g_free0 (self->key);
	self->key = _tmp6_;
	_tmp7_ = desc_and_vals[0];
	_tmp8_ = g_strdup (_tmp7_);
	_g_free0 (self->description);
	self->description = _tmp8_;
	_tmp9_ = desc_and_vals[1];
	_tmp11_ = _tmp10_ = g_strsplit (_tmp9_, "|", 0);
	self->values = (_vala_array_free (self->values, self->values_length1, (GDestroyNotify) g_free), NULL);
	self->values = _tmp11_;
	self->values_length1 = _vala_array_length (_tmp10_);
	self->_values_size_ = self->values_length1;
	_tmp12_ = self->values;
	_tmp12__length1 = self->values_length1;
	_tmp13_ = _tmp12_[0];
	retro_option_set_current (self, _tmp13_);
	desc_and_vals = (_vala_array_free (desc_and_vals, desc_and_vals_length1, (GDestroyNotify) g_free), NULL);
	return self;
}


RetroOption* retro_option_new (RetroVariable* variable) {
	return retro_option_construct (RETRO_TYPE_OPTION, variable);
}


const gchar* retro_option_get_current (RetroOption* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_current;
	result = _tmp0_;
	return result;
}


static gboolean _vala_string_array_contains (gchar* * stack, int stack_length, gchar* needle) {
	int i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}


void retro_option_set_current (RetroOption* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar** _tmp1_;
	gint _tmp1__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = self->values;
	_tmp1__length1 = self->values_length1;
	if (_vala_string_array_contains (_tmp1_, _tmp1__length1, _tmp0_)) {
		const gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = value;
		_tmp3_ = g_strdup (_tmp2_);
		_g_free0 (self->priv->_current);
		self->priv->_current = _tmp3_;
	}
	g_object_notify_by_pspec ((GObject *) self, retro_option_properties[RETRO_OPTION_CURRENT]);
}


static void retro_option_class_init (RetroOptionClass * klass) {
	retro_option_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RetroOptionPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_retro_option_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_retro_option_set_property;
	G_OBJECT_CLASS (klass)->finalize = retro_option_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RETRO_OPTION_CURRENT, retro_option_properties[RETRO_OPTION_CURRENT] = g_param_spec_string ("current", "current", "current", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void retro_option_instance_init (RetroOption * self) {
	self->priv = RETRO_OPTION_GET_PRIVATE (self);
}


static void retro_option_finalize (GObject * obj) {
	RetroOption * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RETRO_TYPE_OPTION, RetroOption);
	_g_free0 (self->key);
	_g_free0 (self->description);
	self->values = (_vala_array_free (self->values, self->values_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (self->priv->_current);
	G_OBJECT_CLASS (retro_option_parent_class)->finalize (obj);
}


GType retro_option_get_type (void) {
	static volatile gsize retro_option_type_id__volatile = 0;
	if (g_once_init_enter (&retro_option_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RetroOptionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) retro_option_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RetroOption), 0, (GInstanceInitFunc) retro_option_instance_init, NULL };
		GType retro_option_type_id;
		retro_option_type_id = g_type_register_static (G_TYPE_OBJECT, "RetroOption", &g_define_type_info, 0);
		g_once_init_leave (&retro_option_type_id__volatile, retro_option_type_id);
	}
	return retro_option_type_id__volatile;
}


static void _vala_retro_option_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RetroOption * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RETRO_TYPE_OPTION, RetroOption);
	switch (property_id) {
		case RETRO_OPTION_CURRENT:
		g_value_set_string (value, retro_option_get_current (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_retro_option_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RetroOption * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RETRO_TYPE_OPTION, RetroOption);
	switch (property_id) {
		case RETRO_OPTION_CURRENT:
		retro_option_set_current (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void retro_options_insert_multiple (RetroOptions* self, RetroVariable* variables, int variables_length1) {
	RetroVariable* _tmp0_;
	gint _tmp0__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = variables;
	_tmp0__length1 = variables_length1;
	{
		RetroVariable* variable_collection = NULL;
		gint variable_collection_length1 = 0;
		gint _variable_collection_size_ = 0;
		gint variable_it = 0;
		variable_collection = _tmp0_;
		variable_collection_length1 = _tmp0__length1;
		for (variable_it = 0; variable_it < _tmp0__length1; variable_it = variable_it + 1) {
			RetroVariable _tmp1_ = {0};
			RetroVariable variable = {0};
			retro_variable_copy (&variable_collection[variable_it], &_tmp1_);
			variable = _tmp1_;
			{
				RetroVariable _tmp2_;
				const gchar* _tmp3_;
				gchar* _tmp4_;
				RetroVariable _tmp5_;
				RetroVariable _tmp6_ = {0};
				_tmp2_ = variable;
				_tmp3_ = _tmp2_.key;
				_tmp4_ = g_strdup (_tmp3_);
				_tmp5_ = variable;
				retro_variable_copy (&_tmp5_, &_tmp6_);
				retro_options_insert (self, _tmp4_, &_tmp6_);
				retro_variable_destroy (&variable);
			}
		}
	}
}


static void retro_options_insert (RetroOptions* self, gchar* key, RetroVariable* value) {
	GHashTable* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	RetroVariable _tmp3_;
	RetroOption* _tmp4_;
	const gchar* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (key != NULL);
	g_return_if_fail (value != NULL);
	_tmp0_ = self->priv->table;
	_tmp1_ = key;
	_tmp2_ = g_strdup (_tmp1_);
	_tmp3_ = *value;
	_tmp4_ = retro_option_new (&_tmp3_);
	g_hash_table_insert (_tmp0_, _tmp2_, _tmp4_);
	_tmp5_ = key;
	g_signal_emit (self, retro_options_signals[RETRO_OPTIONS_VALUE_CHANGED_SIGNAL], 0, _tmp5_);
	self->priv->update = TRUE;
	_g_free0 (key);
	retro_variable_destroy (value);
}


/**
 * Sets the current value of an option.
 *
 * @param key the key of the option
 * @param value the value of the option
 */
void retro_options_set_option (RetroOptions* self, gchar* key, gchar* value) {
	GHashTable* _tmp0_;
	const gchar* _tmp1_;
	gconstpointer _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (key != NULL);
	g_return_if_fail (value != NULL);
	_tmp0_ = self->priv->table;
	_tmp1_ = key;
	_tmp2_ = g_hash_table_lookup (_tmp0_, _tmp1_);
	_tmp3_ = value;
	retro_option_set_current ((RetroOption*) _tmp2_, _tmp3_);
	_tmp4_ = key;
	g_signal_emit (self, retro_options_signals[RETRO_OPTIONS_VALUE_CHANGED_SIGNAL], 0, _tmp4_);
	self->priv->update = TRUE;
	_g_free0 (key);
	_g_free0 (value);
}


void retro_options_set (RetroOptions* self, gchar* key, gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (key != NULL);
	g_return_if_fail (value != NULL);
	_tmp0_ = key;
	_tmp1_ = g_strdup (_tmp0_);
	_tmp2_ = value;
	_tmp3_ = g_strdup (_tmp2_);
	retro_options_set_option (self, _tmp1_, _tmp3_);
	_g_free0 (key);
	_g_free0 (value);
}


/**
 * Checks if an option exists for a key.
 *
 * @param key the key of the option
 * @return //true// if the option exists, //false// otherwise
 */
gboolean retro_options_contains (RetroOptions* self, const gchar* key) {
	gboolean result = FALSE;
	GHashTable* _tmp0_;
	const gchar* _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (key != NULL, FALSE);
	_tmp0_ = self->priv->table;
	_tmp1_ = key;
	_tmp2_ = g_hash_table_contains (_tmp0_, _tmp1_);
	result = _tmp2_;
	return result;
}


/**
 * Gets the current value of an option.
 *
 * @param key the key of the option
 */
const gchar* retro_options_lookup (RetroOptions* self, const gchar* key) {
	const gchar* result = NULL;
	GHashTable* _tmp0_;
	const gchar* _tmp1_;
	gconstpointer _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	_tmp0_ = self->priv->table;
	_tmp1_ = key;
	_tmp2_ = g_hash_table_lookup (_tmp0_, _tmp1_);
	_tmp3_ = retro_option_get_current ((RetroOption*) _tmp2_);
	_tmp4_ = _tmp3_;
	result = _tmp4_;
	return result;
}


/**
 * Gets the description of an option.
 *
 * @param key the key of the option
 */
const gchar* retro_options_lookup_description (RetroOptions* self, const gchar* key) {
	const gchar* result = NULL;
	GHashTable* _tmp0_;
	const gchar* _tmp1_;
	gconstpointer _tmp2_;
	const gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	_tmp0_ = self->priv->table;
	_tmp1_ = key;
	_tmp2_ = g_hash_table_lookup (_tmp0_, _tmp1_);
	_tmp3_ = ((RetroOption*) _tmp2_)->description;
	result = _tmp3_;
	return result;
}


/**
 * Gets the possible values of an option.
 *
 * @param key the key of the option
 */
gchar** retro_options_lookup_values (RetroOptions* self, const gchar* key, int* result_length1) {
	gchar** result = NULL;
	GHashTable* _tmp0_;
	const gchar* _tmp1_;
	gconstpointer _tmp2_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gchar** _tmp4_;
	gint _tmp4__length1;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	_tmp0_ = self->priv->table;
	_tmp1_ = key;
	_tmp2_ = g_hash_table_lookup (_tmp0_, _tmp1_);
	_tmp3_ = ((RetroOption*) _tmp2_)->values;
	_tmp3__length1 = ((RetroOption*) _tmp2_)->values_length1;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	return result;
}


const gchar* retro_options_get (RetroOptions* self, const gchar* key) {
	const gchar* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	_tmp0_ = key;
	_tmp1_ = retro_options_lookup (self, _tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Gets the keys of the available options.
 *
 * @return the keys of the available options
 */
GList* retro_options_get_keys (RetroOptions* self) {
	GList* result = NULL;
	GHashTable* _tmp0_;
	GList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->table;
	_tmp1_ = g_hash_table_get_keys (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Iterates through the options.
 *
 * @param func the function to apply to each option
 */
void retro_options_for_each (RetroOptions* self, GHFunc func, void* func_target) {
	GList* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = retro_options_get_keys (self);
	{
		GList* key_collection = NULL;
		GList* key_it = NULL;
		key_collection = _tmp0_;
		for (key_it = key_collection; key_it != NULL; key_it = key_it->next) {
			const gchar* key = NULL;
			key = (const gchar*) key_it->data;
			{
				GHFunc _tmp1_;
				void* _tmp1__target;
				const gchar* _tmp2_;
				const gchar* _tmp3_;
				const gchar* _tmp4_;
				_tmp1_ = func;
				_tmp1__target = func_target;
				_tmp2_ = key;
				_tmp3_ = key;
				_tmp4_ = retro_options_get (self, _tmp3_);
				_tmp1_ (_tmp2_, _tmp4_, _tmp1__target);
			}
		}
		_g_list_free0 (key_collection);
	}
}


void retro_options_foreach (RetroOptions* self, GHFunc func, void* func_target) {
	GHFunc _tmp0_;
	void* _tmp0__target;
	g_return_if_fail (self != NULL);
	_tmp0_ = func;
	_tmp0__target = func_target;
	retro_options_for_each (self, _tmp0_, _tmp0__target);
}


/**
 * Gets the number of options offered by the {@link core}
 *
 * @return the number of options offered by the {@link core}
 */
guint retro_options_size (RetroOptions* self) {
	guint result = 0U;
	GHashTable* _tmp0_;
	guint _tmp1_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->table;
	_tmp1_ = g_hash_table_size (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Gets the value for a variable.
 *
 * @param key the key of the variable whose value should be returned
 * @return the value of the variable or //null// if the key doesn't exist
 */
static gchar* retro_options_real_get_variable (RetroVariables* base, const gchar* key) {
	RetroOptions * self;
	gchar* result = NULL;
	const gchar* _tmp0_;
	gboolean _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	self = (RetroOptions*) base;
	g_return_val_if_fail (key != NULL, NULL);
	_tmp0_ = key;
	_tmp1_ = retro_options_contains (self, _tmp0_);
	if (!_tmp1_) {
		result = NULL;
		return result;
	}
	_tmp2_ = key;
	_tmp3_ = retro_options_lookup (self, _tmp2_);
	_tmp4_ = g_strdup (_tmp3_);
	result = _tmp4_;
	return result;
}


/**
 * Sets a set of variables to handle.
 *
 * @param variables the variables to handle
 */
static void retro_options_real_set_variable (RetroVariables* base, RetroVariable* variables, int variables_length1) {
	RetroOptions * self;
	RetroVariable* _tmp0_;
	gint _tmp0__length1;
	self = (RetroOptions*) base;
	_tmp0_ = variables;
	_tmp0__length1 = variables_length1;
	retro_options_insert_multiple (self, _tmp0_, _tmp0__length1);
}


/**
 * Gets whether a value have been updated since last call to
 * {@link get_variable}.
 *
 * @return //true// if a variable have been updated, //false// otherwise
 */
static gboolean retro_options_real_get_variable_update (RetroVariables* base) {
	RetroOptions * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	self = (RetroOptions*) base;
	_tmp0_ = self->priv->update;
	if (_tmp0_) {
		self->priv->update = FALSE;
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


RetroOptions* retro_options_construct (GType object_type) {
	RetroOptions * self = NULL;
	self = (RetroOptions*) g_object_new (object_type, NULL);
	return self;
}


RetroOptions* retro_options_new (void) {
	return retro_options_construct (RETRO_TYPE_OPTIONS);
}


static RetroCore* retro_options_real_get_core (RetroVariables* base) {
	RetroCore* result;
	RetroOptions* self;
	RetroCore* _tmp0_;
	self = (RetroOptions*) base;
	_tmp0_ = self->_core;
	result = _tmp0_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void retro_options_real_set_core (RetroVariables* base, RetroCore* value) {
	RetroOptions* self;
	RetroCore* _tmp0_;
	RetroCore* _tmp1_;
	RetroCore* _tmp2_;
	RetroCore* _tmp3_;
	gboolean _tmp4_ = FALSE;
	RetroCore* _tmp5_;
	self = (RetroOptions*) base;
	_tmp0_ = self->_core;
	_tmp1_ = value;
	if (_tmp0_ == _tmp1_) {
		return;
	}
	_tmp2_ = value;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (self->_core);
	self->_core = _tmp3_;
	_tmp5_ = self->_core;
	if (_tmp5_ != NULL) {
		RetroCore* _tmp6_;
		RetroVariables* _tmp7_;
		_tmp6_ = self->_core;
		_tmp7_ = _tmp6_->variables_interface;
		_tmp4_ = _tmp7_ != self;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		RetroCore* _tmp8_;
		RetroVariables* _tmp9_;
		_tmp8_ = self->_core;
		_tmp9_ = _g_object_ref0 ((RetroVariables*) self);
		_g_object_unref0 (_tmp8_->variables_interface);
		_tmp8_->variables_interface = _tmp9_;
	}
	g_object_notify_by_pspec ((GObject *) self, retro_options_properties[RETRO_OPTIONS_CORE]);
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static GObject * retro_options_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	RetroOptions * self;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	parent_class = G_OBJECT_CLASS (retro_options_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RETRO_TYPE_OPTIONS, RetroOptions);
	self->priv->update = FALSE;
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->table);
	self->priv->table = _tmp2_;
	return obj;
}


static void retro_options_class_init (RetroOptionsClass * klass) {
	retro_options_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RetroOptionsPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_retro_options_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_retro_options_set_property;
	G_OBJECT_CLASS (klass)->constructor = retro_options_constructor;
	G_OBJECT_CLASS (klass)->finalize = retro_options_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RETRO_OPTIONS_CORE, retro_options_properties[RETRO_OPTIONS_CORE] = g_param_spec_object ("core", "core", "core", RETRO_TYPE_CORE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	 * Notifies the change of an option's current value.
	 *
	 * @param key the key of the option whose value changed
	 */
	retro_options_signals[RETRO_OPTIONS_VALUE_CHANGED_SIGNAL] = g_signal_new ("value_changed", RETRO_TYPE_OPTIONS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
}


static void retro_options_retro_variables_interface_init (RetroVariablesIface * iface) {
	retro_options_retro_variables_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_variable = (gchar* (*) (RetroVariables *, const gchar*)) retro_options_real_get_variable;
	iface->set_variable = (void (*) (RetroVariables *, RetroVariable*, int)) retro_options_real_set_variable;
	iface->get_variable_update = (gboolean (*) (RetroVariables *)) retro_options_real_get_variable_update;
	iface->get_core = retro_options_real_get_core;
	iface->set_core = retro_options_real_set_core;
}


static void retro_options_instance_init (RetroOptions * self) {
	self->priv = RETRO_OPTIONS_GET_PRIVATE (self);
}


static void retro_options_finalize (GObject * obj) {
	RetroOptions * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RETRO_TYPE_OPTIONS, RetroOptions);
	_g_object_unref0 (self->_core);
	_g_hash_table_unref0 (self->priv->table);
	G_OBJECT_CLASS (retro_options_parent_class)->finalize (obj);
}


/**
 * Manage the options of a {@link Core}.
 *
 * The options are defined by the core's variables.
 */
GType retro_options_get_type (void) {
	static volatile gsize retro_options_type_id__volatile = 0;
	if (g_once_init_enter (&retro_options_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RetroOptionsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) retro_options_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RetroOptions), 0, (GInstanceInitFunc) retro_options_instance_init, NULL };
		static const GInterfaceInfo retro_variables_info = { (GInterfaceInitFunc) retro_options_retro_variables_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType retro_options_type_id;
		retro_options_type_id = g_type_register_static (G_TYPE_OBJECT, "RetroOptions", &g_define_type_info, 0);
		g_type_add_interface_static (retro_options_type_id, RETRO_TYPE_VARIABLES, &retro_variables_info);
		g_once_init_leave (&retro_options_type_id__volatile, retro_options_type_id);
	}
	return retro_options_type_id__volatile;
}


static void _vala_retro_options_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RetroOptions * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RETRO_TYPE_OPTIONS, RetroOptions);
	switch (property_id) {
		case RETRO_OPTIONS_CORE:
		g_value_set_object (value, retro_variables_get_core ((RetroVariables*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_retro_options_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RetroOptions * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RETRO_TYPE_OPTIONS, RetroOptions);
	switch (property_id) {
		case RETRO_OPTIONS_CORE:
		retro_variables_set_core ((RetroVariables*) self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



