/* rygel-external-container.c generated by valac 0.12.0, the Vala compiler
 * generated from rygel-external-container.vala, do not modify */

/*
 * Copyright (C) 2009 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 * Copyright (C) 2009,2010 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>


#define RYGEL_EXTERNAL_TYPE_CONTAINER (rygel_external_container_get_type ())
#define RYGEL_EXTERNAL_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_EXTERNAL_TYPE_CONTAINER, RygelExternalContainer))
#define RYGEL_EXTERNAL_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_EXTERNAL_TYPE_CONTAINER, RygelExternalContainerClass))
#define RYGEL_EXTERNAL_IS_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_EXTERNAL_TYPE_CONTAINER))
#define RYGEL_EXTERNAL_IS_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_EXTERNAL_TYPE_CONTAINER))
#define RYGEL_EXTERNAL_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_EXTERNAL_TYPE_CONTAINER, RygelExternalContainerClass))

typedef struct _RygelExternalContainer RygelExternalContainer;
typedef struct _RygelExternalContainerClass RygelExternalContainerClass;
typedef struct _RygelExternalContainerPrivate RygelExternalContainerPrivate;

#define RYGEL_EXTERNAL_TYPE_MEDIA_OBJECT_PROXY (rygel_external_media_object_proxy_get_type ())
#define RYGEL_EXTERNAL_MEDIA_OBJECT_PROXY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_EXTERNAL_TYPE_MEDIA_OBJECT_PROXY, RygelExternalMediaObjectProxy))
#define RYGEL_EXTERNAL_IS_MEDIA_OBJECT_PROXY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_EXTERNAL_TYPE_MEDIA_OBJECT_PROXY))
#define RYGEL_EXTERNAL_MEDIA_OBJECT_PROXY_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_EXTERNAL_TYPE_MEDIA_OBJECT_PROXY, RygelExternalMediaObjectProxyIface))

typedef struct _RygelExternalMediaObjectProxy RygelExternalMediaObjectProxy;
typedef struct _RygelExternalMediaObjectProxyIface RygelExternalMediaObjectProxyIface;

#define RYGEL_EXTERNAL_TYPE_MEDIA_OBJECT_PROXY_PROXY (rygel_external_media_object_proxy_proxy_get_type ())

#define RYGEL_EXTERNAL_TYPE_MEDIA_CONTAINER_PROXY (rygel_external_media_container_proxy_get_type ())
#define RYGEL_EXTERNAL_MEDIA_CONTAINER_PROXY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_EXTERNAL_TYPE_MEDIA_CONTAINER_PROXY, RygelExternalMediaContainerProxy))
#define RYGEL_EXTERNAL_IS_MEDIA_CONTAINER_PROXY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_EXTERNAL_TYPE_MEDIA_CONTAINER_PROXY))
#define RYGEL_EXTERNAL_MEDIA_CONTAINER_PROXY_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_EXTERNAL_TYPE_MEDIA_CONTAINER_PROXY, RygelExternalMediaContainerProxyIface))

typedef struct _RygelExternalMediaContainerProxy RygelExternalMediaContainerProxy;
typedef struct _RygelExternalMediaContainerProxyIface RygelExternalMediaContainerProxyIface;

#define RYGEL_EXTERNAL_TYPE_MEDIA_CONTAINER_PROXY_PROXY (rygel_external_media_container_proxy_proxy_get_type ())

#define RYGEL_EXTERNAL_TYPE_ITEM_FACTORY (rygel_external_item_factory_get_type ())
#define RYGEL_EXTERNAL_ITEM_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_EXTERNAL_TYPE_ITEM_FACTORY, RygelExternalItemFactory))
#define RYGEL_EXTERNAL_ITEM_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_EXTERNAL_TYPE_ITEM_FACTORY, RygelExternalItemFactoryClass))
#define RYGEL_EXTERNAL_IS_ITEM_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_EXTERNAL_TYPE_ITEM_FACTORY))
#define RYGEL_EXTERNAL_IS_ITEM_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_EXTERNAL_TYPE_ITEM_FACTORY))
#define RYGEL_EXTERNAL_ITEM_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_EXTERNAL_TYPE_ITEM_FACTORY, RygelExternalItemFactoryClass))

typedef struct _RygelExternalItemFactory RygelExternalItemFactory;
typedef struct _RygelExternalItemFactoryClass RygelExternalItemFactoryClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _rygel_external_item_factory_unref0(var) ((var == NULL) ? NULL : (var = (rygel_external_item_factory_unref (var), NULL)))
typedef struct _RygelExternalContainerGetChildrenData RygelExternalContainerGetChildrenData;
#define _rygel_search_expression_unref0(var) ((var == NULL) ? NULL : (var = (rygel_search_expression_unref (var), NULL)))
typedef struct _RygelExternalContainerSearchData RygelExternalContainerSearchData;

#define RYGEL_EXTERNAL_TYPE_DUMMY_CONTAINER (rygel_external_dummy_container_get_type ())
#define RYGEL_EXTERNAL_DUMMY_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_EXTERNAL_TYPE_DUMMY_CONTAINER, RygelExternalDummyContainer))
#define RYGEL_EXTERNAL_DUMMY_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_EXTERNAL_TYPE_DUMMY_CONTAINER, RygelExternalDummyContainerClass))
#define RYGEL_EXTERNAL_IS_DUMMY_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_EXTERNAL_TYPE_DUMMY_CONTAINER))
#define RYGEL_EXTERNAL_IS_DUMMY_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_EXTERNAL_TYPE_DUMMY_CONTAINER))
#define RYGEL_EXTERNAL_DUMMY_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_EXTERNAL_TYPE_DUMMY_CONTAINER, RygelExternalDummyContainerClass))

typedef struct _RygelExternalDummyContainer RygelExternalDummyContainer;
typedef struct _RygelExternalDummyContainerClass RygelExternalDummyContainerClass;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef struct _RygelExternalContainerFindObjectData RygelExternalContainerFindObjectData;
typedef struct _RygelExternalContainerCreateMediaObjectsData RygelExternalContainerCreateMediaObjectsData;
typedef struct _RygelExternalContainerRefreshChildContainersData RygelExternalContainerRefreshChildContainersData;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelExternalContainerUpdateContainerData RygelExternalContainerUpdateContainerData;

struct _RygelExternalMediaObjectProxyIface {
	GTypeInterface parent_iface;
	char* (*get_parent) (RygelExternalMediaObjectProxy* self);
	void (*set_parent) (RygelExternalMediaObjectProxy* self, const char* value);
	gchar* (*get_display_name) (RygelExternalMediaObjectProxy* self);
	void (*set_display_name) (RygelExternalMediaObjectProxy* self, const gchar* value);
	gchar* (*get_object_type) (RygelExternalMediaObjectProxy* self);
	void (*set_object_type) (RygelExternalMediaObjectProxy* self, const gchar* value);
};

struct _RygelExternalMediaContainerProxyIface {
	GTypeInterface parent_iface;
	void (*list_children) (RygelExternalMediaContainerProxy* self, guint offset, guint max_count, gchar** filter, int filter_length1, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GHashTable** (*list_children_finish) (RygelExternalMediaContainerProxy* self, GAsyncResult* _res_, int* result_length1, GError** error);
	void (*list_containers) (RygelExternalMediaContainerProxy* self, guint offset, guint max_count, gchar** filter, int filter_length1, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GHashTable** (*list_containers_finish) (RygelExternalMediaContainerProxy* self, GAsyncResult* _res_, int* result_length1, GError** error);
	void (*list_items) (RygelExternalMediaContainerProxy* self, guint offset, guint max_count, gchar** filter, int filter_length1, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GHashTable** (*list_items_finish) (RygelExternalMediaContainerProxy* self, GAsyncResult* _res_, int* result_length1, GError** error);
	void (*search_objects) (RygelExternalMediaContainerProxy* self, const gchar* query, guint offset, guint max_count, gchar** filter, int filter_length1, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GHashTable** (*search_objects_finish) (RygelExternalMediaContainerProxy* self, GAsyncResult* _res_, int* result_length1, GError** error);
	guint (*get_child_count) (RygelExternalMediaContainerProxy* self);
	void (*set_child_count) (RygelExternalMediaContainerProxy* self, guint value);
	guint (*get_item_count) (RygelExternalMediaContainerProxy* self);
	void (*set_item_count) (RygelExternalMediaContainerProxy* self, guint value);
	guint (*get_container_count) (RygelExternalMediaContainerProxy* self);
	void (*set_container_count) (RygelExternalMediaContainerProxy* self, guint value);
	gboolean (*get_searchable) (RygelExternalMediaContainerProxy* self);
	void (*set_searchable) (RygelExternalMediaContainerProxy* self, gboolean value);
	char* (*get_icon) (RygelExternalMediaContainerProxy* self);
	void (*set_icon) (RygelExternalMediaContainerProxy* self, const char* value);
};

struct _RygelExternalContainer {
	RygelMediaContainer parent_instance;
	RygelExternalContainerPrivate * priv;
	RygelExternalMediaContainerProxy* actual_container;
	gchar* service_name;
};

struct _RygelExternalContainerClass {
	RygelMediaContainerClass parent_class;
};

struct _RygelExternalContainerPrivate {
	RygelExternalItemFactory* item_factory;
	GeeArrayList* containers;
	gboolean searchable;
};

struct _RygelExternalContainerGetChildrenData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelExternalContainer* self;
	guint offset;
	guint max_count;
	GCancellable* cancellable;
	RygelMediaObjects* result;
	gchar** _tmp0_;
	gchar** filter;
	gint filter_length1;
	gint _filter_size_;
	const gchar** object_prop_collection;
	int object_prop_collection_length1;
	int object_prop_it;
	const gchar* object_prop;
	gchar* _tmp1_;
	const gchar** item_prop_collection;
	int item_prop_collection_length1;
	int item_prop_it;
	const gchar* item_prop;
	gchar* _tmp2_;
	gint _tmp3_;
	GHashTable** _tmp4_;
	GHashTable** children_props;
	gint children_props_length1;
	gint _children_props_size_;
	RygelMediaObjects* _tmp5_;
	RygelMediaObjects* _tmp6_;
	GError * _inner_error_;
};

struct _RygelExternalContainerSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelExternalContainer* self;
	RygelSearchExpression* expression;
	guint offset;
	guint max_count;
	guint total_matches;
	GCancellable* cancellable;
	RygelMediaObjects* result;
	gboolean _tmp0_;
	guint _tmp1_;
	RygelMediaObjects* _tmp2_;
	RygelMediaObjects* _tmp3_;
	gchar** _tmp4_;
	gchar** filter;
	gint filter_length1;
	gint _filter_size_;
	const gchar** object_prop_collection;
	int object_prop_collection_length1;
	int object_prop_it;
	const gchar* object_prop;
	gchar* _tmp5_;
	const gchar** container_prop_collection;
	int container_prop_collection_length1;
	int container_prop_it;
	const gchar* container_prop;
	gchar* _tmp6_;
	const gchar** item_prop_collection;
	int item_prop_collection_length1;
	int item_prop_it;
	const gchar* item_prop;
	gchar* _tmp7_;
	RygelSearchExpression* _tmp8_;
	RygelSearchExpression* ext_expression;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gint _tmp11_;
	GHashTable** _tmp12_;
	GHashTable** _tmp13_;
	GHashTable** _result_;
	gint _result__length1;
	gint __result__size_;
	RygelMediaObjects* _tmp14_;
	RygelMediaObjects* _tmp15_;
	GError * _inner_error_;
};

struct _RygelExternalContainerFindObjectData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelExternalContainer* self;
	gchar* id;
	GCancellable* cancellable;
	RygelMediaObject* result;
	RygelMediaObject* media_object;
	RygelExternalMediaObjectProxy* _tmp0_;
	RygelExternalMediaObjectProxy* actual_object;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_;
	RygelMediaContainer* _tmp4_;
	GeeArrayList* _tmp5_;
	GeeArrayList* _container_list;
	gint _tmp6_;
	gint _container_size;
	gint _container_index;
	gpointer _tmp7_;
	RygelExternalContainer* container;
	RygelMediaObject* _tmp8_;
	RygelMediaObject* _tmp9_;
	char* _tmp10_;
	gchar* _tmp11_;
	RygelExternalDummyContainer* _tmp12_;
	RygelExternalDummyContainer* _tmp13_;
	RygelExternalDummyContainer* parent_container;
	FreeDesktopProperties* _tmp14_;
	FreeDesktopProperties* props_iface;
	GHashTable* _tmp15_;
	GHashTable* props;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	RygelMediaItem* _tmp20_;
	RygelMediaItem* _tmp21_;
	RygelMediaItem* _tmp22_;
	GError * _inner_error_;
};

struct _RygelExternalContainerCreateMediaObjectsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelExternalContainer* self;
	GHashTable** all_props;
	gint all_props_length1;
	RygelMediaContainer* parent;
	RygelMediaObjects* result;
	RygelMediaObjects* _tmp0_;
	RygelMediaObjects* media_objects;
	GHashTable** props_collection;
	int props_collection_length1;
	int props_it;
	GHashTable* _tmp1_;
	GHashTable* props;
	gconstpointer _tmp2_;
	gchar* _tmp3_;
	gchar* id;
	gconstpointer _tmp4_;
	gchar* _tmp5_;
	gchar* type;
	RygelMediaContainer* parent_container;
	RygelMediaContainer* _tmp6_;
	gconstpointer _tmp7_;
	gchar* _tmp8_;
	gchar* parent_id;
	RygelExternalDummyContainer* _tmp9_;
	RygelMediaObject* media_object;
	RygelMediaContainer* _tmp10_;
	gconstpointer _tmp11_;
	gchar* _tmp12_;
	gchar* title;
	gconstpointer _tmp13_;
	guint child_count;
	RygelExternalDummyContainer* _tmp14_;
	RygelMediaItem* _tmp15_;
	RygelMediaItem* _tmp16_;
	GError * _inner_error_;
};

struct _RygelExternalContainerRefreshChildContainersData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelExternalContainer* self;
	gchar** _tmp0_;
	gchar** filter;
	gint filter_length1;
	gint _filter_size_;
	const gchar** object_prop_collection;
	int object_prop_collection_length1;
	int object_prop_it;
	const gchar* object_prop;
	gchar* _tmp1_;
	const gchar** container_prop_collection;
	int container_prop_collection_length1;
	int container_prop_it;
	const gchar* container_prop;
	gchar* _tmp2_;
	gint _tmp3_;
	GHashTable** _tmp4_;
	GHashTable** children_props;
	gint children_props_length1;
	gint _children_props_size_;
	GHashTable** props_collection;
	int props_collection_length1;
	int props_it;
	GHashTable* _tmp5_;
	GHashTable* props;
	gconstpointer _tmp6_;
	gchar* _tmp7_;
	gchar* path;
	gconstpointer _tmp8_;
	gchar* _tmp9_;
	gchar* title;
	gconstpointer _tmp10_;
	guint child_count;
	gconstpointer _tmp11_;
	gboolean searchable;
	RygelExternalContainer* _tmp12_;
	RygelExternalContainer* container;
	GError * _inner_error_;
};

struct _RygelExternalContainerUpdateContainerData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelExternalContainer* self;
	gboolean connect_signal;
	GError * err;
	const gchar* _tmp0_;
	GError * _inner_error_;
};


static gpointer rygel_external_container_parent_class = NULL;
static RygelSearchableContainerIface* rygel_external_container_rygel_searchable_container_parent_iface = NULL;

GType rygel_external_container_get_type (void) G_GNUC_CONST;
GType rygel_external_media_object_proxy_get_type (void) G_GNUC_CONST;
GType rygel_external_media_object_proxy_proxy_get_type (void) G_GNUC_CONST;
guint rygel_external_media_object_proxy_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType rygel_external_media_container_proxy_proxy_get_type (void) G_GNUC_CONST;
guint rygel_external_media_container_proxy_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType rygel_external_media_container_proxy_get_type (void) G_GNUC_CONST;
gpointer rygel_external_item_factory_ref (gpointer instance);
void rygel_external_item_factory_unref (gpointer instance);
GParamSpec* rygel_external_param_spec_item_factory (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_external_value_set_item_factory (GValue* value, gpointer v_object);
void rygel_external_value_take_item_factory (GValue* value, gpointer v_object);
gpointer rygel_external_value_get_item_factory (const GValue* value);
GType rygel_external_item_factory_get_type (void) G_GNUC_CONST;
#define RYGEL_EXTERNAL_CONTAINER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_EXTERNAL_TYPE_CONTAINER, RygelExternalContainerPrivate))
enum  {
	RYGEL_EXTERNAL_CONTAINER_DUMMY_PROPERTY
};
RygelExternalContainer* rygel_external_container_new (const gchar* id, const gchar* title, guint child_count, gboolean searchable, const gchar* service_name, const gchar* path, RygelExternalContainer* parent, GError** error);
RygelExternalContainer* rygel_external_container_construct (GType object_type, const gchar* id, const gchar* title, guint child_count, gboolean searchable, const gchar* service_name, const gchar* path, RygelExternalContainer* parent, GError** error);
RygelExternalItemFactory* rygel_external_item_factory_new (void);
RygelExternalItemFactory* rygel_external_item_factory_construct (GType object_type);
static void rygel_external_container_update_container (RygelExternalContainer* self, gboolean connect_signal, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_external_container_update_container_finish (RygelExternalContainer* self, GAsyncResult* _res_);
static void rygel_external_container_real_get_children_data_free (gpointer _data);
static void rygel_external_container_real_get_children (RygelMediaContainer* base, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_external_container_real_get_children_co (RygelExternalContainerGetChildrenData* data);
static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value);
void rygel_external_media_container_proxy_list_children (RygelExternalMediaContainerProxy* self, guint offset, guint max_count, gchar** filter, int filter_length1, GAsyncReadyCallback _callback_, gpointer _user_data_);
GHashTable** rygel_external_media_container_proxy_list_children_finish (RygelExternalMediaContainerProxy* self, GAsyncResult* _res_, int* result_length1, GError** error);
static void rygel_external_container_get_children_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void rygel_external_container_create_media_objects (RygelExternalContainer* self, GHashTable** all_props, int all_props_length1, RygelMediaContainer* parent, GAsyncReadyCallback _callback_, gpointer _user_data_);
static RygelMediaObjects* rygel_external_container_create_media_objects_finish (RygelExternalContainer* self, GAsyncResult* _res_, GError** error);
static void rygel_external_container_real_search_data_free (gpointer _data);
static void rygel_external_container_real_search (RygelSearchableContainer* base, RygelSearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_external_container_real_search_co (RygelExternalContainerSearchData* data);
static void rygel_external_container_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _vala_array_add3 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add4 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add5 (gchar*** array, int* length, int* size, gchar* value);
static RygelSearchExpression* rygel_external_container_translate_expression (RygelExternalContainer* self, RygelSearchExpression* upnp_expression);
void rygel_external_media_container_proxy_search_objects (RygelExternalMediaContainerProxy* self, const gchar* query, guint offset, guint max_count, gchar** filter, int filter_length1, GAsyncReadyCallback _callback_, gpointer _user_data_);
GHashTable** rygel_external_media_container_proxy_search_objects_finish (RygelExternalMediaContainerProxy* self, GAsyncResult* _res_, int* result_length1, GError** error);
static void rygel_external_container_real_find_object_data_free (gpointer _data);
static void rygel_external_container_real_find_object (RygelMediaContainer* base, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_external_container_real_find_object_co (RygelExternalContainerFindObjectData* data);
static void rygel_external_container_find_object_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
gchar* rygel_external_media_object_proxy_get_object_type (RygelExternalMediaObjectProxy* self);
static RygelMediaContainer* rygel_external_container_find_container_by_id (RygelExternalContainer* self, const gchar* id);
char* rygel_external_media_object_proxy_get_parent (RygelExternalMediaObjectProxy* self);
RygelExternalDummyContainer* rygel_external_dummy_container_new (const gchar* id, const gchar* title, guint child_count, RygelMediaContainer* parent);
RygelExternalDummyContainer* rygel_external_dummy_container_construct (GType object_type, const gchar* id, const gchar* title, guint child_count, RygelMediaContainer* parent);
GType rygel_external_dummy_container_get_type (void) G_GNUC_CONST;
#define RYGEL_EXTERNAL_MEDIA_ITEM_PROXY_IFACE "org.gnome.UPnP.MediaItem2"
void rygel_external_item_factory_create (RygelExternalItemFactory* self, const gchar* id, const gchar* type, const gchar* title, GHashTable* props, const gchar* service_name, RygelMediaContainer* parent, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaItem* rygel_external_item_factory_create_finish (RygelExternalItemFactory* self, GAsyncResult* _res_, GError** error);
gchar* rygel_external_media_object_proxy_get_display_name (RygelExternalMediaObjectProxy* self);
static void rygel_external_container_create_media_objects_data_free (gpointer _data);
static GHashTable** _vala_array_dup1 (GHashTable** self, int length);
static gboolean rygel_external_container_create_media_objects_co (RygelExternalContainerCreateMediaObjectsData* data);
static const gchar* _variant_get1 (GVariant* value);
static const gchar* _variant_get2 (GVariant* value);
static const gchar* _variant_get3 (GVariant* value);
static const gchar* _variant_get4 (GVariant* value);
static guint _variant_get5 (GVariant* value);
static void rygel_external_container_create_media_objects_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void rygel_external_container_refresh_child_containers_data_free (gpointer _data);
static void rygel_external_container_refresh_child_containers (RygelExternalContainer* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_external_container_refresh_child_containers_finish (RygelExternalContainer* self, GAsyncResult* _res_, GError** error);
static gboolean rygel_external_container_refresh_child_containers_co (RygelExternalContainerRefreshChildContainersData* data);
static void _vala_array_add6 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add7 (gchar*** array, int* length, int* size, gchar* value);
void rygel_external_media_container_proxy_list_containers (RygelExternalMediaContainerProxy* self, guint offset, guint max_count, gchar** filter, int filter_length1, GAsyncReadyCallback _callback_, gpointer _user_data_);
GHashTable** rygel_external_media_container_proxy_list_containers_finish (RygelExternalMediaContainerProxy* self, GAsyncResult* _res_, int* result_length1, GError** error);
static void rygel_external_container_refresh_child_containers_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static const gchar* _variant_get6 (GVariant* value);
static const gchar* _variant_get7 (GVariant* value);
static guint _variant_get8 (GVariant* value);
static gboolean _variant_get9 (GVariant* value);
static void rygel_external_container_update_container_data_free (gpointer _data);
static gboolean rygel_external_container_update_container_co (RygelExternalContainerUpdateContainerData* data);
static void rygel_external_container_update_container_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void rygel_external_container_on_updated (RygelExternalContainer* self, RygelExternalMediaContainerProxy* actual_container);
static void _rygel_external_container_on_updated_rygel_external_media_container_proxy_updated (RygelExternalMediaContainerProxy* _sender, gpointer self);
gchar* rygel_external_container_translate_property (RygelExternalContainer* self, const gchar* property);
static void rygel_external_container_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

extern const gchar* RYGEL_EXTERNAL_MEDIA_OBJECT_PROXY_PROPERTIES[4];
extern const gchar* RYGEL_EXTERNAL_MEDIA_ITEM_PROXY_PROPERTIES[18];
extern const gchar* RYGEL_EXTERNAL_MEDIA_CONTAINER_PROXY_PROPERTIES[2];

RygelExternalContainer* rygel_external_container_construct (GType object_type, const gchar* id, const gchar* title, guint child_count, gboolean searchable, const gchar* service_name, const gchar* path, RygelExternalContainer* parent, GError** error) {
	RygelExternalContainer * self = NULL;
	gchar* _tmp0_;
	RygelExternalItemFactory* _tmp1_ = NULL;
	GeeArrayList* _tmp2_ = NULL;
	RygelExternalMediaContainerProxy* _tmp3_ = NULL;
	RygelExternalMediaContainerProxy* _tmp4_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (title != NULL, NULL);
	g_return_val_if_fail (service_name != NULL, NULL);
	g_return_val_if_fail (path != NULL, NULL);
	self = (RygelExternalContainer*) rygel_media_container_construct (object_type, id, (RygelMediaContainer*) parent, title, (gint) child_count);
	_tmp0_ = g_strdup (service_name);
	_g_free0 (self->service_name);
	self->service_name = _tmp0_;
	_tmp1_ = rygel_external_item_factory_new ();
	_rygel_external_item_factory_unref0 (self->priv->item_factory);
	self->priv->item_factory = _tmp1_;
	_tmp2_ = gee_array_list_new (RYGEL_EXTERNAL_TYPE_CONTAINER, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
	_g_object_unref0 (self->priv->containers);
	self->priv->containers = _tmp2_;
	_tmp3_ = g_initable_new (RYGEL_EXTERNAL_TYPE_MEDIA_CONTAINER_PROXY_PROXY, NULL, &_inner_error_, "g-flags", G_DBUS_PROXY_FLAGS_DO_NOT_LOAD_PROPERTIES, "g-name", self->service_name, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", path, "g-interface-name", "org.gnome.UPnP.MediaContainer2", NULL);
	_tmp4_ = (RygelExternalMediaContainerProxy*) _tmp3_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_IO_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_g_object_unref0 (self->actual_container);
	self->actual_container = _tmp4_;
	rygel_external_container_update_container (self, TRUE, NULL, NULL);
	return self;
}


RygelExternalContainer* rygel_external_container_new (const gchar* id, const gchar* title, guint child_count, gboolean searchable, const gchar* service_name, const gchar* path, RygelExternalContainer* parent, GError** error) {
	return rygel_external_container_construct (RYGEL_EXTERNAL_TYPE_CONTAINER, id, title, child_count, searchable, service_name, path, parent, error);
}


static void rygel_external_container_real_get_children_data_free (gpointer _data) {
	RygelExternalContainerGetChildrenData* data;
	data = _data;
	_g_object_unref0 (data->cancellable);
	_g_object_unref0 (data->result);
	_g_object_unref0 (data->self);
	g_slice_free (RygelExternalContainerGetChildrenData, data);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void rygel_external_container_real_get_children (RygelMediaContainer* base, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelExternalContainer * self;
	RygelExternalContainerGetChildrenData* _data_;
	self = (RygelExternalContainer*) base;
	_data_ = g_slice_new0 (RygelExternalContainerGetChildrenData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_external_container_real_get_children);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_external_container_real_get_children_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->offset = offset;
	_data_->max_count = max_count;
	_data_->cancellable = _g_object_ref0 (cancellable);
	rygel_external_container_real_get_children_co (_data_);
}


static RygelMediaObjects* rygel_external_container_real_get_children_finish (RygelMediaContainer* base, GAsyncResult* _res_, GError** error) {
	RygelMediaObjects* result;
	RygelExternalContainerGetChildrenData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void rygel_external_container_get_children_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelExternalContainerGetChildrenData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	rygel_external_container_real_get_children_co (data);
}


static gboolean rygel_external_container_real_get_children_co (RygelExternalContainerGetChildrenData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = g_new0 (gchar*, 0 + 1);
	data->filter = data->_tmp0_;
	data->filter_length1 = 0;
	data->_filter_size_ = 0;
	{
		data->object_prop_collection = RYGEL_EXTERNAL_MEDIA_OBJECT_PROXY_PROPERTIES;
		data->object_prop_collection_length1 = G_N_ELEMENTS (RYGEL_EXTERNAL_MEDIA_OBJECT_PROXY_PROPERTIES);
		for (data->object_prop_it = 0; data->object_prop_it < G_N_ELEMENTS (RYGEL_EXTERNAL_MEDIA_OBJECT_PROXY_PROPERTIES); data->object_prop_it = data->object_prop_it + 1) {
			data->object_prop = data->object_prop_collection[data->object_prop_it];
			{
				data->_tmp1_ = g_strdup (data->object_prop);
				_vala_array_add1 (&data->filter, &data->filter_length1, &data->_filter_size_, data->_tmp1_);
			}
		}
	}
	{
		data->item_prop_collection = RYGEL_EXTERNAL_MEDIA_ITEM_PROXY_PROPERTIES;
		data->item_prop_collection_length1 = G_N_ELEMENTS (RYGEL_EXTERNAL_MEDIA_ITEM_PROXY_PROPERTIES);
		for (data->item_prop_it = 0; data->item_prop_it < G_N_ELEMENTS (RYGEL_EXTERNAL_MEDIA_ITEM_PROXY_PROPERTIES); data->item_prop_it = data->item_prop_it + 1) {
			data->item_prop = data->item_prop_collection[data->item_prop_it];
			{
				data->_tmp2_ = g_strdup (data->item_prop);
				_vala_array_add2 (&data->filter, &data->filter_length1, &data->_filter_size_, data->_tmp2_);
			}
		}
	}
	data->_state_ = 1;
	rygel_external_media_container_proxy_list_children (data->self->actual_container, data->offset, data->max_count, data->filter, data->filter_length1, rygel_external_container_get_children_ready, data);
	return FALSE;
	_state_1:
	data->_tmp4_ = NULL;
	data->_tmp4_ = rygel_external_media_container_proxy_list_children_finish (data->self->actual_container, data->_res_, &data->_tmp3_, &data->_inner_error_);
	data->children_props = data->_tmp4_;
	data->children_props_length1 = data->_tmp3_;
	data->_children_props_size_ = data->_tmp3_;
	if (data->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		data->filter = (_vala_array_free (data->filter, data->filter_length1, (GDestroyNotify) g_free), NULL);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	data->_state_ = 2;
	rygel_external_container_create_media_objects (data->self, data->children_props, data->children_props_length1, (RygelMediaContainer*) data->self, rygel_external_container_get_children_ready, data);
	return FALSE;
	_state_2:
	data->_tmp5_ = NULL;
	data->_tmp5_ = rygel_external_container_create_media_objects_finish (data->self, data->_res_, &data->_inner_error_);
	data->_tmp6_ = data->_tmp5_;
	if (data->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		data->children_props = (_vala_array_free (data->children_props, data->children_props_length1, (GDestroyNotify) g_hash_table_unref), NULL);
		data->filter = (_vala_array_free (data->filter, data->filter_length1, (GDestroyNotify) g_free), NULL);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	data->result = data->_tmp6_;
	data->children_props = (_vala_array_free (data->children_props, data->children_props_length1, (GDestroyNotify) g_hash_table_unref), NULL);
	data->filter = (_vala_array_free (data->filter, data->filter_length1, (GDestroyNotify) g_free), NULL);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
	data->children_props = (_vala_array_free (data->children_props, data->children_props_length1, (GDestroyNotify) g_hash_table_unref), NULL);
	data->filter = (_vala_array_free (data->filter, data->filter_length1, (GDestroyNotify) g_free), NULL);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void rygel_external_container_real_search_data_free (gpointer _data) {
	RygelExternalContainerSearchData* data;
	data = _data;
	_rygel_search_expression_unref0 (data->expression);
	_g_object_unref0 (data->cancellable);
	_g_object_unref0 (data->result);
	_g_object_unref0 (data->self);
	g_slice_free (RygelExternalContainerSearchData, data);
}


static gpointer _rygel_search_expression_ref0 (gpointer self) {
	return self ? rygel_search_expression_ref (self) : NULL;
}


static void rygel_external_container_real_search (RygelSearchableContainer* base, RygelSearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelExternalContainer * self;
	RygelExternalContainerSearchData* _data_;
	self = (RygelExternalContainer*) base;
	_data_ = g_slice_new0 (RygelExternalContainerSearchData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_external_container_real_search);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_external_container_real_search_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->expression = _rygel_search_expression_ref0 (expression);
	_data_->offset = offset;
	_data_->max_count = max_count;
	_data_->cancellable = _g_object_ref0 (cancellable);
	rygel_external_container_real_search_co (_data_);
}


static RygelMediaObjects* rygel_external_container_real_search_finish (RygelSearchableContainer* base, GAsyncResult* _res_, guint* total_matches, GError** error) {
	RygelMediaObjects* result;
	RygelExternalContainerSearchData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	*total_matches = _data_->total_matches;
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void rygel_external_container_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelExternalContainerSearchData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	rygel_external_container_real_search_co (data);
}


static void _vala_array_add3 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add4 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add5 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static gboolean rygel_external_container_real_search_co (RygelExternalContainerSearchData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (data->expression == NULL) {
		data->_tmp0_ = TRUE;
	} else {
		data->_tmp0_ = !data->self->priv->searchable;
	}
	if (data->_tmp0_) {
		data->_state_ = 1;
		rygel_searchable_container_simple_search ((RygelSearchableContainer*) data->self, data->expression, data->offset, data->max_count, data->cancellable, rygel_external_container_search_ready, data);
		return FALSE;
		_state_1:
		data->_tmp2_ = NULL;
		data->_tmp2_ = rygel_searchable_container_simple_search_finish ((RygelSearchableContainer*) data->self, data->_res_, &data->_tmp1_, &data->_inner_error_);
		data->total_matches = data->_tmp1_;
		data->_tmp3_ = data->_tmp2_;
		if (data->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
		data->result = data->_tmp3_;
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	data->_tmp4_ = NULL;
	data->_tmp4_ = g_new0 (gchar*, 0 + 1);
	data->filter = data->_tmp4_;
	data->filter_length1 = 0;
	data->_filter_size_ = 0;
	{
		data->object_prop_collection = RYGEL_EXTERNAL_MEDIA_OBJECT_PROXY_PROPERTIES;
		data->object_prop_collection_length1 = G_N_ELEMENTS (RYGEL_EXTERNAL_MEDIA_OBJECT_PROXY_PROPERTIES);
		for (data->object_prop_it = 0; data->object_prop_it < G_N_ELEMENTS (RYGEL_EXTERNAL_MEDIA_OBJECT_PROXY_PROPERTIES); data->object_prop_it = data->object_prop_it + 1) {
			data->object_prop = data->object_prop_collection[data->object_prop_it];
			{
				data->_tmp5_ = g_strdup (data->object_prop);
				_vala_array_add3 (&data->filter, &data->filter_length1, &data->_filter_size_, data->_tmp5_);
			}
		}
	}
	{
		data->container_prop_collection = RYGEL_EXTERNAL_MEDIA_CONTAINER_PROXY_PROPERTIES;
		data->container_prop_collection_length1 = G_N_ELEMENTS (RYGEL_EXTERNAL_MEDIA_CONTAINER_PROXY_PROPERTIES);
		for (data->container_prop_it = 0; data->container_prop_it < G_N_ELEMENTS (RYGEL_EXTERNAL_MEDIA_CONTAINER_PROXY_PROPERTIES); data->container_prop_it = data->container_prop_it + 1) {
			data->container_prop = data->container_prop_collection[data->container_prop_it];
			{
				data->_tmp6_ = g_strdup (data->container_prop);
				_vala_array_add4 (&data->filter, &data->filter_length1, &data->_filter_size_, data->_tmp6_);
			}
		}
	}
	{
		data->item_prop_collection = RYGEL_EXTERNAL_MEDIA_ITEM_PROXY_PROPERTIES;
		data->item_prop_collection_length1 = G_N_ELEMENTS (RYGEL_EXTERNAL_MEDIA_ITEM_PROXY_PROPERTIES);
		for (data->item_prop_it = 0; data->item_prop_it < G_N_ELEMENTS (RYGEL_EXTERNAL_MEDIA_ITEM_PROXY_PROPERTIES); data->item_prop_it = data->item_prop_it + 1) {
			data->item_prop = data->item_prop_collection[data->item_prop_it];
			{
				data->_tmp7_ = g_strdup (data->item_prop);
				_vala_array_add5 (&data->filter, &data->filter_length1, &data->_filter_size_, data->_tmp7_);
			}
		}
	}
	data->_tmp8_ = NULL;
	data->_tmp8_ = rygel_external_container_translate_expression (data->self, data->expression);
	data->ext_expression = data->_tmp8_;
	data->_tmp9_ = NULL;
	data->_tmp9_ = rygel_search_expression_to_string (data->ext_expression);
	data->_tmp10_ = data->_tmp9_;
	data->_state_ = 2;
	rygel_external_media_container_proxy_search_objects (data->self->actual_container, data->_tmp10_, data->offset, data->max_count, data->filter, data->filter_length1, rygel_external_container_search_ready, data);
	return FALSE;
	_state_2:
	data->_tmp12_ = NULL;
	data->_tmp12_ = rygel_external_media_container_proxy_search_objects_finish (data->self->actual_container, data->_res_, &data->_tmp11_, &data->_inner_error_);
	data->_tmp13_ = data->_tmp12_;
	_g_free0 (data->_tmp10_);
	data->_result_ = data->_tmp13_;
	data->_result__length1 = data->_tmp11_;
	data->__result__size_ = data->_tmp11_;
	if (data->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		_rygel_search_expression_unref0 (data->ext_expression);
		data->filter = (_vala_array_free (data->filter, data->filter_length1, (GDestroyNotify) g_free), NULL);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	data->total_matches = (guint) data->_result__length1;
	data->_state_ = 3;
	rygel_external_container_create_media_objects (data->self, data->_result_, data->_result__length1, NULL, rygel_external_container_search_ready, data);
	return FALSE;
	_state_3:
	data->_tmp14_ = NULL;
	data->_tmp14_ = rygel_external_container_create_media_objects_finish (data->self, data->_res_, &data->_inner_error_);
	data->_tmp15_ = data->_tmp14_;
	if (data->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		data->_result_ = (_vala_array_free (data->_result_, data->_result__length1, (GDestroyNotify) g_hash_table_unref), NULL);
		_rygel_search_expression_unref0 (data->ext_expression);
		data->filter = (_vala_array_free (data->filter, data->filter_length1, (GDestroyNotify) g_free), NULL);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	data->result = data->_tmp15_;
	data->_result_ = (_vala_array_free (data->_result_, data->_result__length1, (GDestroyNotify) g_hash_table_unref), NULL);
	_rygel_search_expression_unref0 (data->ext_expression);
	data->filter = (_vala_array_free (data->filter, data->filter_length1, (GDestroyNotify) g_free), NULL);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
	data->_result_ = (_vala_array_free (data->_result_, data->_result__length1, (GDestroyNotify) g_hash_table_unref), NULL);
	_rygel_search_expression_unref0 (data->ext_expression);
	data->filter = (_vala_array_free (data->filter, data->filter_length1, (GDestroyNotify) g_free), NULL);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void rygel_external_container_real_find_object_data_free (gpointer _data) {
	RygelExternalContainerFindObjectData* data;
	data = _data;
	_g_free0 (data->id);
	_g_object_unref0 (data->cancellable);
	_g_object_unref0 (data->result);
	_g_object_unref0 (data->self);
	g_slice_free (RygelExternalContainerFindObjectData, data);
}


static void rygel_external_container_real_find_object (RygelMediaContainer* base, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelExternalContainer * self;
	RygelExternalContainerFindObjectData* _data_;
	self = (RygelExternalContainer*) base;
	_data_ = g_slice_new0 (RygelExternalContainerFindObjectData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_external_container_real_find_object);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_external_container_real_find_object_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->id = g_strdup (id);
	_data_->cancellable = _g_object_ref0 (cancellable);
	rygel_external_container_real_find_object_co (_data_);
}


static RygelMediaObject* rygel_external_container_real_find_object_finish (RygelMediaContainer* base, GAsyncResult* _res_, GError** error) {
	RygelMediaObject* result;
	RygelExternalContainerFindObjectData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void rygel_external_container_find_object_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelExternalContainerFindObjectData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	rygel_external_container_real_find_object_co (data);
}


static gboolean rygel_external_container_real_find_object_co (RygelExternalContainerFindObjectData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		case 5:
		goto _state_5;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->media_object = NULL;
	data->_state_ = 1;
	g_async_initable_new_async (RYGEL_EXTERNAL_TYPE_MEDIA_OBJECT_PROXY_PROXY, 0, NULL, rygel_external_container_find_object_ready, data, "g-flags", 0, "g-name", data->self->service_name, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", data->id, "g-interface-name", "org.gnome.UPnP.MediaObject2", NULL);
	return FALSE;
	_state_1:
	data->_tmp0_ = NULL;
	data->_tmp0_ = g_async_initable_new_finish (data->_source_object_, data->_res_, &data->_inner_error_);
	data->actual_object = (RygelExternalMediaObjectProxy*) data->_tmp0_;
	if (data->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		_g_object_unref0 (data->media_object);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	data->_tmp1_ = NULL;
	data->_tmp1_ = rygel_external_media_object_proxy_get_object_type (data->actual_object);
	data->_tmp2_ = data->_tmp1_;
	data->_tmp3_ = g_strcmp0 (data->_tmp2_, "container") == 0;
	_g_free0 (data->_tmp2_);
	if (data->_tmp3_) {
		data->_tmp4_ = NULL;
		data->_tmp4_ = rygel_external_container_find_container_by_id (data->self, data->id);
		_g_object_unref0 (data->media_object);
		data->media_object = (RygelMediaObject*) data->_tmp4_;
		if (data->media_object == NULL) {
			{
				data->_tmp5_ = _g_object_ref0 (data->self->priv->containers);
				data->_container_list = data->_tmp5_;
				data->_tmp6_ = gee_collection_get_size ((GeeCollection*) data->_container_list);
				data->_container_size = data->_tmp6_;
				data->_container_index = -1;
				while (TRUE) {
					data->_container_index = data->_container_index + 1;
					if (!(data->_container_index < data->_container_size)) {
						break;
					}
					data->_tmp7_ = NULL;
					data->_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) data->_container_list, data->_container_index);
					data->container = (RygelExternalContainer*) data->_tmp7_;
					data->_state_ = 2;
					rygel_media_container_find_object ((RygelMediaContainer*) data->container, data->id, data->cancellable, rygel_external_container_find_object_ready, data);
					return FALSE;
					_state_2:
					data->_tmp8_ = NULL;
					data->_tmp8_ = rygel_media_container_find_object_finish ((RygelMediaContainer*) data->container, data->_res_, &data->_inner_error_);
					data->_tmp9_ = data->_tmp8_;
					if (data->_inner_error_ != NULL) {
						g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
						g_error_free (data->_inner_error_);
						_g_object_unref0 (data->container);
						_g_object_unref0 (data->_container_list);
						_g_object_unref0 (data->actual_object);
						_g_object_unref0 (data->media_object);
						if (data->_state_ == 0) {
							g_simple_async_result_complete_in_idle (data->_async_result);
						} else {
							g_simple_async_result_complete (data->_async_result);
						}
						g_object_unref (data->_async_result);
						return FALSE;
					}
					_g_object_unref0 (data->media_object);
					data->media_object = data->_tmp9_;
					if (data->media_object != NULL) {
						_g_object_unref0 (data->container);
						break;
					}
					_g_object_unref0 (data->container);
				}
				_g_object_unref0 (data->_container_list);
			}
		}
	} else {
		data->_tmp10_ = NULL;
		data->_tmp10_ = rygel_external_media_object_proxy_get_parent (data->actual_object);
		data->_tmp11_ = (gchar*) data->_tmp10_;
		data->_tmp12_ = NULL;
		data->_tmp12_ = rygel_external_dummy_container_new (data->_tmp11_, "LaLaLa", (guint) 0, NULL);
		data->_tmp13_ = data->_tmp12_;
		_g_free0 (data->_tmp11_);
		data->parent_container = data->_tmp13_;
		data->_state_ = 3;
		g_async_initable_new_async (FREE_DESKTOP_TYPE_PROPERTIES_PROXY, 0, NULL, rygel_external_container_find_object_ready, data, "g-flags", G_DBUS_PROXY_FLAGS_DO_NOT_LOAD_PROPERTIES, "g-name", data->self->service_name, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", data->id, "g-interface-name", "org.freedesktop.DBus.Properties", NULL);
		return FALSE;
		_state_3:
		data->_tmp14_ = NULL;
		data->_tmp14_ = g_async_initable_new_finish (data->_source_object_, data->_res_, &data->_inner_error_);
		data->props_iface = (FreeDesktopProperties*) data->_tmp14_;
		if (data->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_g_object_unref0 (data->parent_container);
			_g_object_unref0 (data->actual_object);
			_g_object_unref0 (data->media_object);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
		data->_state_ = 4;
		free_desktop_properties_get_all (data->props_iface, RYGEL_EXTERNAL_MEDIA_ITEM_PROXY_IFACE, rygel_external_container_find_object_ready, data);
		return FALSE;
		_state_4:
		data->_tmp15_ = NULL;
		data->_tmp15_ = free_desktop_properties_get_all_finish (data->props_iface, data->_res_, &data->_inner_error_);
		data->props = data->_tmp15_;
		if (data->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_g_object_unref0 (data->props_iface);
			_g_object_unref0 (data->parent_container);
			_g_object_unref0 (data->actual_object);
			_g_object_unref0 (data->media_object);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
		data->_tmp16_ = NULL;
		data->_tmp16_ = rygel_external_media_object_proxy_get_object_type (data->actual_object);
		data->_tmp17_ = data->_tmp16_;
		data->_tmp18_ = NULL;
		data->_tmp18_ = rygel_external_media_object_proxy_get_display_name (data->actual_object);
		data->_tmp19_ = data->_tmp18_;
		data->_state_ = 5;
		rygel_external_item_factory_create (data->self->priv->item_factory, data->id, data->_tmp17_, data->_tmp19_, data->props, data->self->service_name, (RygelMediaContainer*) data->parent_container, rygel_external_container_find_object_ready, data);
		return FALSE;
		_state_5:
		data->_tmp20_ = NULL;
		data->_tmp20_ = rygel_external_item_factory_create_finish (data->self->priv->item_factory, data->_res_, &data->_inner_error_);
		data->_tmp21_ = data->_tmp20_;
		_g_free0 (data->_tmp19_);
		_g_free0 (data->_tmp17_);
		data->_tmp22_ = data->_tmp21_;
		if (data->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_g_hash_table_unref0 (data->props);
			_g_object_unref0 (data->props_iface);
			_g_object_unref0 (data->parent_container);
			_g_object_unref0 (data->actual_object);
			_g_object_unref0 (data->media_object);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
		_g_object_unref0 (data->media_object);
		data->media_object = (RygelMediaObject*) data->_tmp22_;
		_g_hash_table_unref0 (data->props);
		_g_object_unref0 (data->props_iface);
		_g_object_unref0 (data->parent_container);
	}
	data->result = data->media_object;
	_g_object_unref0 (data->actual_object);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
	_g_object_unref0 (data->actual_object);
	_g_object_unref0 (data->media_object);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void rygel_external_container_create_media_objects_data_free (gpointer _data) {
	RygelExternalContainerCreateMediaObjectsData* data;
	data = _data;
	data->all_props = (_vala_array_free (data->all_props, data->all_props_length1, (GDestroyNotify) g_hash_table_unref), NULL);
	_g_object_unref0 (data->parent);
	_g_object_unref0 (data->result);
	_g_object_unref0 (data->self);
	g_slice_free (RygelExternalContainerCreateMediaObjectsData, data);
}


static gpointer _g_hash_table_ref0 (gpointer self) {
	return self ? g_hash_table_ref (self) : NULL;
}


static GHashTable** _vala_array_dup1 (GHashTable** self, int length) {
	GHashTable** result;
	int i;
	result = g_new0 (GHashTable*, length + 1);
	for (i = 0; i < length; i++) {
		result[i] = _g_hash_table_ref0 (self[i]);
	}
	return result;
}


static void rygel_external_container_create_media_objects (RygelExternalContainer* self, GHashTable** all_props, int all_props_length1, RygelMediaContainer* parent, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelExternalContainerCreateMediaObjectsData* _data_;
	GHashTable** _tmp0_;
	_data_ = g_slice_new0 (RygelExternalContainerCreateMediaObjectsData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_external_container_create_media_objects);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_external_container_create_media_objects_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->all_props = (_tmp0_ = all_props, (_tmp0_ == NULL) ? ((gpointer) _tmp0_) : _vala_array_dup1 (_tmp0_, all_props_length1));
	_data_->all_props_length1 = all_props_length1;
	_data_->parent = _g_object_ref0 (parent);
	rygel_external_container_create_media_objects_co (_data_);
}


static RygelMediaObjects* rygel_external_container_create_media_objects_finish (RygelExternalContainer* self, GAsyncResult* _res_, GError** error) {
	RygelMediaObjects* result;
	RygelExternalContainerCreateMediaObjectsData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static const gchar* _variant_get1 (GVariant* value) {
	return g_variant_dup_string (value, NULL);
}


static const gchar* _variant_get2 (GVariant* value) {
	return g_variant_dup_string (value, NULL);
}


static const gchar* _variant_get3 (GVariant* value) {
	return g_variant_dup_string (value, NULL);
}


static const gchar* _variant_get4 (GVariant* value) {
	return g_variant_dup_string (value, NULL);
}


static guint _variant_get5 (GVariant* value) {
	return g_variant_get_uint32 (value);
}


static void rygel_external_container_create_media_objects_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelExternalContainerCreateMediaObjectsData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	rygel_external_container_create_media_objects_co (data);
}


static gboolean rygel_external_container_create_media_objects_co (RygelExternalContainerCreateMediaObjectsData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = rygel_media_objects_new ();
	data->media_objects = data->_tmp0_;
	{
		data->props_collection = data->all_props;
		data->props_collection_length1 = data->all_props_length1;
		for (data->props_it = 0; data->props_it < data->all_props_length1; data->props_it = data->props_it + 1) {
			data->_tmp1_ = _g_hash_table_ref0 (data->props_collection[data->props_it]);
			data->props = data->_tmp1_;
			{
				data->_tmp2_ = NULL;
				data->_tmp2_ = g_hash_table_lookup (data->props, "Path");
				data->_tmp3_ = g_strdup (_variant_get1 ((GVariant*) data->_tmp2_));
				data->id = data->_tmp3_;
				data->_tmp4_ = NULL;
				data->_tmp4_ = g_hash_table_lookup (data->props, "Type");
				data->_tmp5_ = g_strdup (_variant_get2 ((GVariant*) data->_tmp4_));
				data->type = data->_tmp5_;
				if (data->parent != NULL) {
					data->_tmp6_ = _g_object_ref0 (data->parent);
					_g_object_unref0 (data->parent_container);
					data->parent_container = data->_tmp6_;
				} else {
					data->_tmp7_ = NULL;
					data->_tmp7_ = g_hash_table_lookup (data->props, "Parent");
					data->_tmp8_ = g_strdup (_variant_get3 ((GVariant*) data->_tmp7_));
					data->parent_id = data->_tmp8_;
					data->_tmp9_ = NULL;
					data->_tmp9_ = rygel_external_dummy_container_new (data->parent_id, "LaLaLa", (guint) 0, NULL);
					_g_object_unref0 (data->parent_container);
					data->parent_container = (RygelMediaContainer*) data->_tmp9_;
					_g_free0 (data->parent_id);
				}
				data->media_object = NULL;
				if (g_strcmp0 (data->type, "container") == 0) {
					data->_tmp10_ = NULL;
					data->_tmp10_ = rygel_external_container_find_container_by_id (data->self, data->id);
					_g_object_unref0 (data->media_object);
					data->media_object = (RygelMediaObject*) data->_tmp10_;
				}
				if (data->media_object == NULL) {
					data->_tmp11_ = NULL;
					data->_tmp11_ = g_hash_table_lookup (data->props, "DisplayName");
					data->_tmp12_ = g_strdup (_variant_get4 ((GVariant*) data->_tmp11_));
					data->title = data->_tmp12_;
					if (g_strcmp0 (data->type, "container") == 0) {
						data->_tmp13_ = NULL;
						data->_tmp13_ = g_hash_table_lookup (data->props, "ChildCount");
						data->child_count = _variant_get5 ((GVariant*) data->_tmp13_);
						data->_tmp14_ = NULL;
						data->_tmp14_ = rygel_external_dummy_container_new (data->id, data->title, data->child_count, data->parent_container);
						_g_object_unref0 (data->media_object);
						data->media_object = (RygelMediaObject*) data->_tmp14_;
					} else {
						data->_state_ = 1;
						rygel_external_item_factory_create (data->self->priv->item_factory, data->id, data->type, data->title, data->props, data->self->service_name, data->parent_container, rygel_external_container_create_media_objects_ready, data);
						return FALSE;
						_state_1:
						data->_tmp15_ = NULL;
						data->_tmp15_ = rygel_external_item_factory_create_finish (data->self->priv->item_factory, data->_res_, &data->_inner_error_);
						data->_tmp16_ = data->_tmp15_;
						if (data->_inner_error_ != NULL) {
							g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
							g_error_free (data->_inner_error_);
							_g_free0 (data->title);
							_g_object_unref0 (data->media_object);
							_g_object_unref0 (data->parent_container);
							_g_free0 (data->type);
							_g_free0 (data->id);
							_g_hash_table_unref0 (data->props);
							_g_object_unref0 (data->media_objects);
							if (data->_state_ == 0) {
								g_simple_async_result_complete_in_idle (data->_async_result);
							} else {
								g_simple_async_result_complete (data->_async_result);
							}
							g_object_unref (data->_async_result);
							return FALSE;
						}
						_g_object_unref0 (data->media_object);
						data->media_object = (RygelMediaObject*) data->_tmp16_;
					}
					_g_free0 (data->title);
				}
				gee_abstract_collection_add ((GeeAbstractCollection*) data->media_objects, data->media_object);
				_g_object_unref0 (data->media_object);
				_g_object_unref0 (data->parent_container);
				_g_free0 (data->type);
				_g_free0 (data->id);
				_g_hash_table_unref0 (data->props);
			}
		}
	}
	data->result = data->media_objects;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
	_g_object_unref0 (data->media_objects);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void rygel_external_container_refresh_child_containers_data_free (gpointer _data) {
	RygelExternalContainerRefreshChildContainersData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (RygelExternalContainerRefreshChildContainersData, data);
}


static void rygel_external_container_refresh_child_containers (RygelExternalContainer* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelExternalContainerRefreshChildContainersData* _data_;
	_data_ = g_slice_new0 (RygelExternalContainerRefreshChildContainersData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_external_container_refresh_child_containers);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_external_container_refresh_child_containers_data_free);
	_data_->self = _g_object_ref0 (self);
	rygel_external_container_refresh_child_containers_co (_data_);
}


static void rygel_external_container_refresh_child_containers_finish (RygelExternalContainer* self, GAsyncResult* _res_, GError** error) {
	RygelExternalContainerRefreshChildContainersData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void _vala_array_add6 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add7 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void rygel_external_container_refresh_child_containers_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelExternalContainerRefreshChildContainersData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	rygel_external_container_refresh_child_containers_co (data);
}


static const gchar* _variant_get6 (GVariant* value) {
	return g_variant_dup_string (value, NULL);
}


static const gchar* _variant_get7 (GVariant* value) {
	return g_variant_dup_string (value, NULL);
}


static guint _variant_get8 (GVariant* value) {
	return g_variant_get_uint32 (value);
}


static gboolean _variant_get9 (GVariant* value) {
	return g_variant_get_boolean (value);
}


static gboolean rygel_external_container_refresh_child_containers_co (RygelExternalContainerRefreshChildContainersData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = g_new0 (gchar*, 0 + 1);
	data->filter = data->_tmp0_;
	data->filter_length1 = 0;
	data->_filter_size_ = 0;
	{
		data->object_prop_collection = RYGEL_EXTERNAL_MEDIA_OBJECT_PROXY_PROPERTIES;
		data->object_prop_collection_length1 = G_N_ELEMENTS (RYGEL_EXTERNAL_MEDIA_OBJECT_PROXY_PROPERTIES);
		for (data->object_prop_it = 0; data->object_prop_it < G_N_ELEMENTS (RYGEL_EXTERNAL_MEDIA_OBJECT_PROXY_PROPERTIES); data->object_prop_it = data->object_prop_it + 1) {
			data->object_prop = data->object_prop_collection[data->object_prop_it];
			{
				data->_tmp1_ = g_strdup (data->object_prop);
				_vala_array_add6 (&data->filter, &data->filter_length1, &data->_filter_size_, data->_tmp1_);
			}
		}
	}
	{
		data->container_prop_collection = RYGEL_EXTERNAL_MEDIA_CONTAINER_PROXY_PROPERTIES;
		data->container_prop_collection_length1 = G_N_ELEMENTS (RYGEL_EXTERNAL_MEDIA_CONTAINER_PROXY_PROPERTIES);
		for (data->container_prop_it = 0; data->container_prop_it < G_N_ELEMENTS (RYGEL_EXTERNAL_MEDIA_CONTAINER_PROXY_PROPERTIES); data->container_prop_it = data->container_prop_it + 1) {
			data->container_prop = data->container_prop_collection[data->container_prop_it];
			{
				data->_tmp2_ = g_strdup (data->container_prop);
				_vala_array_add7 (&data->filter, &data->filter_length1, &data->_filter_size_, data->_tmp2_);
			}
		}
	}
	data->_state_ = 1;
	rygel_external_media_container_proxy_list_containers (data->self->actual_container, (guint) 0, (guint) 0, data->filter, data->filter_length1, rygel_external_container_refresh_child_containers_ready, data);
	return FALSE;
	_state_1:
	data->_tmp4_ = NULL;
	data->_tmp4_ = rygel_external_media_container_proxy_list_containers_finish (data->self->actual_container, data->_res_, &data->_tmp3_, &data->_inner_error_);
	data->children_props = data->_tmp4_;
	data->children_props_length1 = data->_tmp3_;
	data->_children_props_size_ = data->_tmp3_;
	if (data->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		data->filter = (_vala_array_free (data->filter, data->filter_length1, (GDestroyNotify) g_free), NULL);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	gee_abstract_collection_clear ((GeeAbstractCollection*) data->self->priv->containers);
	{
		data->props_collection = data->children_props;
		data->props_collection_length1 = data->children_props_length1;
		for (data->props_it = 0; data->props_it < data->children_props_length1; data->props_it = data->props_it + 1) {
			data->_tmp5_ = _g_hash_table_ref0 (data->props_collection[data->props_it]);
			data->props = data->_tmp5_;
			{
				data->_tmp6_ = NULL;
				data->_tmp6_ = g_hash_table_lookup (data->props, "Path");
				data->_tmp7_ = g_strdup (_variant_get6 ((GVariant*) data->_tmp6_));
				data->path = data->_tmp7_;
				data->_tmp8_ = NULL;
				data->_tmp8_ = g_hash_table_lookup (data->props, "DisplayName");
				data->_tmp9_ = g_strdup (_variant_get7 ((GVariant*) data->_tmp8_));
				data->title = data->_tmp9_;
				data->_tmp10_ = NULL;
				data->_tmp10_ = g_hash_table_lookup (data->props, "ChildCount");
				data->child_count = _variant_get8 ((GVariant*) data->_tmp10_);
				data->_tmp11_ = NULL;
				data->_tmp11_ = g_hash_table_lookup (data->props, "Searchable");
				data->searchable = _variant_get9 ((GVariant*) data->_tmp11_);
				data->_tmp12_ = NULL;
				data->_tmp12_ = rygel_external_container_new (data->path, data->title, data->child_count, data->searchable, data->self->service_name, data->path, data->self, &data->_inner_error_);
				data->container = data->_tmp12_;
				if (data->_inner_error_ != NULL) {
					g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
					g_error_free (data->_inner_error_);
					_g_free0 (data->title);
					_g_free0 (data->path);
					_g_hash_table_unref0 (data->props);
					data->children_props = (_vala_array_free (data->children_props, data->children_props_length1, (GDestroyNotify) g_hash_table_unref), NULL);
					data->filter = (_vala_array_free (data->filter, data->filter_length1, (GDestroyNotify) g_free), NULL);
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				}
				gee_abstract_collection_add ((GeeAbstractCollection*) data->self->priv->containers, data->container);
				_g_object_unref0 (data->container);
				_g_free0 (data->title);
				_g_free0 (data->path);
				_g_hash_table_unref0 (data->props);
			}
		}
	}
	data->children_props = (_vala_array_free (data->children_props, data->children_props_length1, (GDestroyNotify) g_hash_table_unref), NULL);
	data->filter = (_vala_array_free (data->filter, data->filter_length1, (GDestroyNotify) g_free), NULL);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void rygel_external_container_update_container_data_free (gpointer _data) {
	RygelExternalContainerUpdateContainerData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (RygelExternalContainerUpdateContainerData, data);
}


static void rygel_external_container_update_container (RygelExternalContainer* self, gboolean connect_signal, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelExternalContainerUpdateContainerData* _data_;
	_data_ = g_slice_new0 (RygelExternalContainerUpdateContainerData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_external_container_update_container);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_external_container_update_container_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->connect_signal = connect_signal;
	rygel_external_container_update_container_co (_data_);
}


static void rygel_external_container_update_container_finish (RygelExternalContainer* self, GAsyncResult* _res_) {
	RygelExternalContainerUpdateContainerData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_external_container_update_container_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelExternalContainerUpdateContainerData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	rygel_external_container_update_container_co (data);
}


static void _rygel_external_container_on_updated_rygel_external_media_container_proxy_updated (RygelExternalMediaContainerProxy* _sender, gpointer self) {
	rygel_external_container_on_updated (self, _sender);
}


static gboolean rygel_external_container_update_container_co (RygelExternalContainerUpdateContainerData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_state_ = 1;
	rygel_external_container_refresh_child_containers (data->self, rygel_external_container_update_container_ready, data);
	return FALSE;
	_state_1:
	rygel_external_container_refresh_child_containers_finish (data->self, data->_res_, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		goto __catch0_g_error;
	}
	goto __finally0;
	__catch0_g_error:
	{
		data->err = data->_inner_error_;
		data->_inner_error_ = NULL;
		data->_tmp0_ = NULL;
		data->_tmp0_ = g_dbus_proxy_get_object_path ((GDBusProxy*) data->self->actual_container);
		g_warning ("rygel-external-container.vala:269: Failed to update information about " \
"container '%s': %s", data->_tmp0_, data->err->message);
		_g_error_free0 (data->err);
	}
	__finally0:
	if (data->_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	rygel_media_container_updated ((RygelMediaContainer*) data->self);
	if (data->connect_signal) {
		g_signal_connect_object (data->self->actual_container, "updated", (GCallback) _rygel_external_container_on_updated_rygel_external_media_container_proxy_updated, data->self, 0);
	}
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void rygel_external_container_on_updated (RygelExternalContainer* self, RygelExternalMediaContainerProxy* actual_container) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (actual_container != NULL);
	rygel_external_container_update_container (self, FALSE, NULL, NULL);
}


static RygelMediaContainer* rygel_external_container_find_container_by_id (RygelExternalContainer* self, const gchar* id) {
	RygelMediaContainer* result = NULL;
	RygelMediaContainer* target;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (id != NULL, NULL);
	target = NULL;
	{
		GeeArrayList* _tmp0_;
		GeeArrayList* _container_list;
		gint _tmp1_;
		gint _container_size;
		gint _container_index;
		_tmp0_ = _g_object_ref0 (self->priv->containers);
		_container_list = _tmp0_;
		_tmp1_ = gee_collection_get_size ((GeeCollection*) _container_list);
		_container_size = _tmp1_;
		_container_index = -1;
		while (TRUE) {
			gpointer _tmp2_ = NULL;
			RygelExternalContainer* container;
			_container_index = _container_index + 1;
			if (!(_container_index < _container_size)) {
				break;
			}
			_tmp2_ = gee_abstract_list_get ((GeeAbstractList*) _container_list, _container_index);
			container = (RygelExternalContainer*) _tmp2_;
			if (g_strcmp0 (((RygelMediaObject*) container)->id, id) == 0) {
				RygelMediaContainer* _tmp3_;
				_tmp3_ = _g_object_ref0 ((RygelMediaContainer*) container);
				_g_object_unref0 (target);
				target = _tmp3_;
				_g_object_unref0 (container);
				break;
			}
			_g_object_unref0 (container);
		}
		_g_object_unref0 (_container_list);
	}
	result = target;
	return result;
}


static RygelSearchExpression* rygel_external_container_translate_expression (RygelExternalContainer* self, RygelSearchExpression* upnp_expression) {
	RygelSearchExpression* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (upnp_expression != NULL, NULL);
	if (RYGEL_IS_RELATIONAL_EXPRESSION (upnp_expression)) {
		RygelSearchExpression* _tmp0_;
		RygelRelationalExpression* _tmp1_;
		RygelRelationalExpression* expression;
		RygelRelationalExpression* _tmp2_ = NULL;
		RygelRelationalExpression* ext_expression;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_;
		_tmp0_ = upnp_expression;
		_tmp1_ = _rygel_search_expression_ref0 (RYGEL_IS_RELATIONAL_EXPRESSION (_tmp0_) ? ((RygelRelationalExpression*) _tmp0_) : NULL);
		expression = _tmp1_;
		_tmp2_ = rygel_relational_expression_new ();
		ext_expression = _tmp2_;
		((RygelSearchExpression*) ext_expression)->op = GINT_TO_POINTER (GPOINTER_TO_INT (((RygelSearchExpression*) expression)->op));
		_tmp3_ = rygel_external_container_translate_property (self, (const gchar*) ((RygelSearchExpression*) expression)->operand1);
		_g_free0 (((RygelSearchExpression*) ext_expression)->operand1);
		((RygelSearchExpression*) ext_expression)->operand1 = _tmp3_;
		_tmp4_ = g_strdup ((const gchar*) ((RygelSearchExpression*) expression)->operand2);
		_g_free0 (((RygelSearchExpression*) ext_expression)->operand2);
		((RygelSearchExpression*) ext_expression)->operand2 = _tmp4_;
		result = (RygelSearchExpression*) ext_expression;
		_rygel_search_expression_unref0 (expression);
		return result;
	} else {
		RygelSearchExpression* _tmp5_;
		RygelLogicalExpression* _tmp6_;
		RygelLogicalExpression* expression;
		RygelLogicalExpression* _tmp7_ = NULL;
		RygelLogicalExpression* ext_expression;
		RygelSearchExpression* _tmp8_ = NULL;
		RygelSearchExpression* _tmp9_ = NULL;
		_tmp5_ = upnp_expression;
		_tmp6_ = _rygel_search_expression_ref0 (RYGEL_IS_LOGICAL_EXPRESSION (_tmp5_) ? ((RygelLogicalExpression*) _tmp5_) : NULL);
		expression = _tmp6_;
		_tmp7_ = rygel_logical_expression_new ();
		ext_expression = _tmp7_;
		((RygelSearchExpression*) ext_expression)->op = GINT_TO_POINTER (GPOINTER_TO_INT (((RygelSearchExpression*) expression)->op));
		_tmp8_ = rygel_external_container_translate_expression (self, (RygelSearchExpression*) ((RygelSearchExpression*) expression)->operand1);
		_rygel_search_expression_unref0 (((RygelSearchExpression*) ext_expression)->operand1);
		((RygelSearchExpression*) ext_expression)->operand1 = _tmp8_;
		_tmp9_ = rygel_external_container_translate_expression (self, (RygelSearchExpression*) ((RygelSearchExpression*) expression)->operand2);
		_rygel_search_expression_unref0 (((RygelSearchExpression*) ext_expression)->operand2);
		((RygelSearchExpression*) ext_expression)->operand2 = _tmp9_;
		result = (RygelSearchExpression*) ext_expression;
		_rygel_search_expression_unref0 (expression);
		return result;
	}
}


gchar* rygel_external_container_translate_property (RygelExternalContainer* self, const gchar* property) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	GQuark _tmp1_;
	static GQuark _tmp1__label0 = 0;
	static GQuark _tmp1__label1 = 0;
	static GQuark _tmp1__label2 = 0;
	static GQuark _tmp1__label3 = 0;
	static GQuark _tmp1__label4 = 0;
	static GQuark _tmp1__label5 = 0;
	static GQuark _tmp1__label6 = 0;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (property != NULL, NULL);
	_tmp0_ = property;
	_tmp1_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp1_ == ((0 != _tmp1__label0) ? _tmp1__label0 : (_tmp1__label0 = g_quark_from_static_string ("@id")))) {
		switch (0) {
			default:
			{
				gchar* _tmp2_;
				_tmp2_ = g_strdup ("Path");
				result = _tmp2_;
				return result;
			}
		}
	} else if (_tmp1_ == ((0 != _tmp1__label1) ? _tmp1__label1 : (_tmp1__label1 = g_quark_from_static_string ("@parentID")))) {
		switch (0) {
			default:
			{
				gchar* _tmp3_;
				_tmp3_ = g_strdup ("Parent");
				result = _tmp3_;
				return result;
			}
		}
	} else if (_tmp1_ == ((0 != _tmp1__label2) ? _tmp1__label2 : (_tmp1__label2 = g_quark_from_static_string ("dc:title")))) {
		switch (0) {
			default:
			{
				gchar* _tmp4_;
				_tmp4_ = g_strdup ("DisplayName");
				result = _tmp4_;
				return result;
			}
		}
	} else if (((_tmp1_ == ((0 != _tmp1__label3) ? _tmp1__label3 : (_tmp1__label3 = g_quark_from_static_string ("dc:creator")))) || (_tmp1_ == ((0 != _tmp1__label4) ? _tmp1__label4 : (_tmp1__label4 = g_quark_from_static_string ("upnp:artist"))))) || (_tmp1_ == ((0 != _tmp1__label5) ? _tmp1__label5 : (_tmp1__label5 = g_quark_from_static_string ("upnp:author"))))) {
		switch (0) {
			default:
			{
				gchar* _tmp5_;
				_tmp5_ = g_strdup ("Artist");
				result = _tmp5_;
				return result;
			}
		}
	} else if (_tmp1_ == ((0 != _tmp1__label6) ? _tmp1__label6 : (_tmp1__label6 = g_quark_from_static_string ("upnp:album")))) {
		switch (0) {
			default:
			{
				gchar* _tmp6_;
				_tmp6_ = g_strdup ("Album");
				result = _tmp6_;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				gchar* _tmp7_;
				_tmp7_ = g_strdup (property);
				result = _tmp7_;
				return result;
			}
		}
	}
}


static void rygel_external_container_class_init (RygelExternalContainerClass * klass) {
	rygel_external_container_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelExternalContainerPrivate));
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->get_children = rygel_external_container_real_get_children;
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->get_children_finish = rygel_external_container_real_get_children_finish;
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->find_object = rygel_external_container_real_find_object;
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->find_object_finish = rygel_external_container_real_find_object_finish;
	G_OBJECT_CLASS (klass)->finalize = rygel_external_container_finalize;
}


static void rygel_external_container_rygel_searchable_container_interface_init (RygelSearchableContainerIface * iface) {
	rygel_external_container_rygel_searchable_container_parent_iface = g_type_interface_peek_parent (iface);
	iface->search = (RygelMediaObjects* (*)(RygelSearchableContainer* ,RygelSearchExpression* ,guint ,guint ,guint* ,GCancellable* ,GError**)) rygel_external_container_real_search;
	iface->search_finish = rygel_external_container_real_search_finish;
}


static void rygel_external_container_instance_init (RygelExternalContainer * self) {
	self->priv = RYGEL_EXTERNAL_CONTAINER_GET_PRIVATE (self);
}


static void rygel_external_container_finalize (GObject* obj) {
	RygelExternalContainer * self;
	self = RYGEL_EXTERNAL_CONTAINER (obj);
	_g_object_unref0 (self->actual_container);
	_g_free0 (self->service_name);
	_rygel_external_item_factory_unref0 (self->priv->item_factory);
	_g_object_unref0 (self->priv->containers);
	G_OBJECT_CLASS (rygel_external_container_parent_class)->finalize (obj);
}


/**
 * Represents an external container.
 */
GType rygel_external_container_get_type (void) {
	static volatile gsize rygel_external_container_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_external_container_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelExternalContainerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_external_container_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelExternalContainer), 0, (GInstanceInitFunc) rygel_external_container_instance_init, NULL };
		static const GInterfaceInfo rygel_searchable_container_info = { (GInterfaceInitFunc) rygel_external_container_rygel_searchable_container_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_external_container_type_id;
		rygel_external_container_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_CONTAINER, "RygelExternalContainer", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_external_container_type_id, RYGEL_TYPE_SEARCHABLE_CONTAINER, &rygel_searchable_container_info);
		g_once_init_leave (&rygel_external_container_type_id__volatile, rygel_external_container_type_id);
	}
	return rygel_external_container_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



