/* rygel-mediathek-playlist-parser.c generated by valac 0.12.0, the Vala compiler
 * generated from rygel-mediathek-playlist-parser.vala, do not modify */

/*
 * Copyright (C) 2011 Jens Georg
 *
 * Author: Jens Georg <mail@jensge.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <libsoup/soup.h>
#include <gio/gio.h>


#define RYGEL_MEDIATHEK_TYPE_PLAYLIST_PARSER (rygel_mediathek_playlist_parser_get_type ())
#define RYGEL_MEDIATHEK_PLAYLIST_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIATHEK_TYPE_PLAYLIST_PARSER, RygelMediathekPlaylistParser))
#define RYGEL_MEDIATHEK_PLAYLIST_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIATHEK_TYPE_PLAYLIST_PARSER, RygelMediathekPlaylistParserClass))
#define RYGEL_MEDIATHEK_IS_PLAYLIST_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIATHEK_TYPE_PLAYLIST_PARSER))
#define RYGEL_MEDIATHEK_IS_PLAYLIST_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIATHEK_TYPE_PLAYLIST_PARSER))
#define RYGEL_MEDIATHEK_PLAYLIST_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIATHEK_TYPE_PLAYLIST_PARSER, RygelMediathekPlaylistParserClass))

typedef struct _RygelMediathekPlaylistParser RygelMediathekPlaylistParser;
typedef struct _RygelMediathekPlaylistParserClass RygelMediathekPlaylistParserClass;
typedef struct _RygelMediathekPlaylistParserPrivate RygelMediathekPlaylistParserPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block1Data Block1Data;
typedef struct _RygelMediathekPlaylistParserParseData RygelMediathekPlaylistParserParseData;

typedef enum  {
	RYGEL_MEDIATHEK_VIDEO_ITEM_ERROR_XML_PARSE_ERROR,
	RYGEL_MEDIATHEK_VIDEO_ITEM_ERROR_NETWORK_ERROR
} RygelMediathekVideoItemError;
#define RYGEL_MEDIATHEK_VIDEO_ITEM_ERROR rygel_mediathek_video_item_error_quark ()
struct _RygelMediathekPlaylistParser {
	GObject parent_instance;
	RygelMediathekPlaylistParserPrivate * priv;
};

struct _RygelMediathekPlaylistParserClass {
	GObjectClass parent_class;
	GeeList* (*parse_playlist) (RygelMediathekPlaylistParser* self, const gchar* data, gint length, GError** error);
};

struct _RygelMediathekPlaylistParserPrivate {
	SoupSession* _session;
	gchar* _playlist_suffix;
	gchar* _mime_type;
};

struct _Block1Data {
	int _ref_count_;
	RygelMediathekPlaylistParser * self;
	GSourceFunc callback;
	gpointer callback_target;
	GDestroyNotify callback_target_destroy_notify;
	gpointer _async_data_;
};

struct _RygelMediathekPlaylistParserParseData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMediathekPlaylistParser* self;
	gchar* uri;
	GeeList* result;
	Block1Data* _data1_;
	SoupMessage* _tmp0_;
	SoupMessage* message;
	SoupMessage* _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	guint _tmp4_;
	const gchar* _tmp5_;
	GError* _tmp6_;
	GeeList* _tmp7_;
	GeeList* _tmp8_;
	GError * _inner_error_;
};


static gpointer rygel_mediathek_playlist_parser_parent_class = NULL;

GType rygel_mediathek_playlist_parser_get_type (void) G_GNUC_CONST;
GQuark rygel_mediathek_video_item_error_quark (void);
#define RYGEL_MEDIATHEK_PLAYLIST_PARSER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_MEDIATHEK_TYPE_PLAYLIST_PARSER, RygelMediathekPlaylistParserPrivate))
enum  {
	RYGEL_MEDIATHEK_PLAYLIST_PARSER_DUMMY_PROPERTY,
	RYGEL_MEDIATHEK_PLAYLIST_PARSER_SESSION,
	RYGEL_MEDIATHEK_PLAYLIST_PARSER_PLAYLIST_SUFFIX,
	RYGEL_MEDIATHEK_PLAYLIST_PARSER_MIME_TYPE
};
static void rygel_mediathek_playlist_parser_parse_data_free (gpointer _data);
void rygel_mediathek_playlist_parser_parse (RygelMediathekPlaylistParser* self, const gchar* uri, GAsyncReadyCallback _callback_, gpointer _user_data_);
GeeList* rygel_mediathek_playlist_parser_parse_finish (RygelMediathekPlaylistParser* self, GAsyncResult* _res_, GError** error);
static gboolean rygel_mediathek_playlist_parser_parse_co (RygelMediathekPlaylistParserParseData* data);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (Block1Data* _data1_);
static gboolean _rygel_mediathek_playlist_parser_parse_co_gsource_func (gpointer self);
SoupSession* rygel_mediathek_playlist_parser_get_session (RygelMediathekPlaylistParser* self);
static void _lambda0_ (Block1Data* _data1_);
static void __lambda0__soup_session_callback (SoupSession* session, SoupMessage* msg, gpointer self);
GeeList* rygel_mediathek_playlist_parser_parse_playlist (RygelMediathekPlaylistParser* self, const gchar* data, gint length, GError** error);
static GeeList* rygel_mediathek_playlist_parser_real_parse_playlist (RygelMediathekPlaylistParser* self, const gchar* data, gint length, GError** error);
RygelMediathekPlaylistParser* rygel_mediathek_playlist_parser_construct (GType object_type);
static void rygel_mediathek_playlist_parser_set_session (RygelMediathekPlaylistParser* self, SoupSession* value);
const gchar* rygel_mediathek_playlist_parser_get_playlist_suffix (RygelMediathekPlaylistParser* self);
static void rygel_mediathek_playlist_parser_set_playlist_suffix (RygelMediathekPlaylistParser* self, const gchar* value);
const gchar* rygel_mediathek_playlist_parser_get_mime_type (RygelMediathekPlaylistParser* self);
static void rygel_mediathek_playlist_parser_set_mime_type (RygelMediathekPlaylistParser* self, const gchar* value);
static void rygel_mediathek_playlist_parser_finalize (GObject* obj);
static void _vala_rygel_mediathek_playlist_parser_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_mediathek_playlist_parser_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static void rygel_mediathek_playlist_parser_parse_data_free (gpointer _data) {
	RygelMediathekPlaylistParserParseData* data;
	data = _data;
	_g_free0 (data->uri);
	_g_object_unref0 (data->result);
	_g_object_unref0 (data->self);
	g_slice_free (RygelMediathekPlaylistParserParseData, data);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void rygel_mediathek_playlist_parser_parse (RygelMediathekPlaylistParser* self, const gchar* uri, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMediathekPlaylistParserParseData* _data_;
	_data_ = g_slice_new0 (RygelMediathekPlaylistParserParseData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_mediathek_playlist_parser_parse);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_mediathek_playlist_parser_parse_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->uri = g_strdup (uri);
	rygel_mediathek_playlist_parser_parse_co (_data_);
}


GeeList* rygel_mediathek_playlist_parser_parse_finish (RygelMediathekPlaylistParser* self, GAsyncResult* _res_, GError** error) {
	GeeList* result;
	RygelMediathekPlaylistParserParseData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (Block1Data* _data1_) {
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_object_unref0 (_data1_->self);
		(_data1_->callback_target_destroy_notify == NULL) ? NULL : (_data1_->callback_target_destroy_notify (_data1_->callback_target), NULL);
		_data1_->callback = NULL;
		_data1_->callback_target = NULL;
		_data1_->callback_target_destroy_notify = NULL;
		g_slice_free (Block1Data, _data1_);
	}
}


static gboolean _rygel_mediathek_playlist_parser_parse_co_gsource_func (gpointer self) {
	gboolean result;
	result = rygel_mediathek_playlist_parser_parse_co (self);
	return result;
}


static void _lambda0_ (Block1Data* _data1_) {
	RygelMediathekPlaylistParser * self;
	self = _data1_->self;
	_data1_->callback (_data1_->callback_target);
}


static void __lambda0__soup_session_callback (SoupSession* session, SoupMessage* msg, gpointer self) {
	_lambda0_ (self);
}


static gboolean rygel_mediathek_playlist_parser_parse_co (RygelMediathekPlaylistParserParseData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_data1_ = g_slice_new0 (Block1Data);
	data->_data1_->_ref_count_ = 1;
	data->_data1_->self = g_object_ref (data->self);
	data->_data1_->_async_data_ = data;
	data->_tmp0_ = NULL;
	data->_tmp0_ = soup_message_new ("GET", data->uri);
	data->message = data->_tmp0_;
	data->_data1_->callback = _rygel_mediathek_playlist_parser_parse_co_gsource_func;
	data->_data1_->callback_target = data;
	data->_data1_->callback_target_destroy_notify = NULL;
	data->_tmp1_ = _g_object_ref0 (data->message);
	soup_session_queue_message (data->self->priv->_session, data->_tmp1_, __lambda0__soup_session_callback, data->_data1_);
	data->_state_ = 1;
	return FALSE;
	_state_1:
	;
	g_object_get (data->message, "status-code", &data->_tmp2_, NULL);
	if (data->_tmp2_ != 200) {
		g_object_get (data->message, "status-code", &data->_tmp3_, NULL);
		g_object_get (data->message, "status-code", &data->_tmp4_, NULL);
		data->_tmp5_ = NULL;
		data->_tmp5_ = soup_status_get_phrase (data->_tmp4_);
		data->_tmp6_ = NULL;
		data->_tmp6_ = g_error_new (RYGEL_MEDIATHEK_VIDEO_ITEM_ERROR, RYGEL_MEDIATHEK_VIDEO_ITEM_ERROR_NETWORK_ERROR, "Playlist download failed: %u (%s)", data->_tmp3_, data->_tmp5_);
		data->_inner_error_ = data->_tmp6_;
		if (data->_inner_error_->domain == RYGEL_MEDIATHEK_VIDEO_ITEM_ERROR) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_g_object_unref0 (data->message);
			block1_data_unref (data->_data1_);
			data->_data1_ = NULL;
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		} else {
			_g_object_unref0 (data->message);
			block1_data_unref (data->_data1_);
			data->_data1_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	data->_tmp7_ = NULL;
	data->_tmp7_ = rygel_mediathek_playlist_parser_parse_playlist (data->self, (const gchar*) data->message->response_body->data, (gint) data->message->response_body->length, &data->_inner_error_);
	data->_tmp8_ = data->_tmp7_;
	if (data->_inner_error_ != NULL) {
		if (data->_inner_error_->domain == RYGEL_MEDIATHEK_VIDEO_ITEM_ERROR) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_g_object_unref0 (data->message);
			block1_data_unref (data->_data1_);
			data->_data1_ = NULL;
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		} else {
			_g_object_unref0 (data->message);
			block1_data_unref (data->_data1_);
			data->_data1_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	data->result = data->_tmp8_;
	_g_object_unref0 (data->message);
	block1_data_unref (data->_data1_);
	data->_data1_ = NULL;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
	_g_object_unref0 (data->message);
	block1_data_unref (data->_data1_);
	data->_data1_ = NULL;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static GeeList* rygel_mediathek_playlist_parser_real_parse_playlist (RygelMediathekPlaylistParser* self, const gchar* data, gint length, GError** error) {
	g_return_val_if_fail (self != NULL, NULL);
	g_critical ("Type `%s' does not implement abstract method `rygel_mediathek_playlist_parser_parse_playlist'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


GeeList* rygel_mediathek_playlist_parser_parse_playlist (RygelMediathekPlaylistParser* self, const gchar* data, gint length, GError** error) {
	return RYGEL_MEDIATHEK_PLAYLIST_PARSER_GET_CLASS (self)->parse_playlist (self, data, length, error);
}


RygelMediathekPlaylistParser* rygel_mediathek_playlist_parser_construct (GType object_type) {
	RygelMediathekPlaylistParser * self = NULL;
	self = (RygelMediathekPlaylistParser*) g_object_new (object_type, NULL);
	return self;
}


SoupSession* rygel_mediathek_playlist_parser_get_session (RygelMediathekPlaylistParser* self) {
	SoupSession* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_session;
	return result;
}


static void rygel_mediathek_playlist_parser_set_session (RygelMediathekPlaylistParser* self, SoupSession* value) {
	SoupSession* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_session);
	self->priv->_session = _tmp0_;
	g_object_notify ((GObject *) self, "session");
}


const gchar* rygel_mediathek_playlist_parser_get_playlist_suffix (RygelMediathekPlaylistParser* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_playlist_suffix;
	return result;
}


static void rygel_mediathek_playlist_parser_set_playlist_suffix (RygelMediathekPlaylistParser* self, const gchar* value) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_playlist_suffix);
	self->priv->_playlist_suffix = _tmp0_;
	g_object_notify ((GObject *) self, "playlist-suffix");
}


const gchar* rygel_mediathek_playlist_parser_get_mime_type (RygelMediathekPlaylistParser* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_mime_type;
	return result;
}


static void rygel_mediathek_playlist_parser_set_mime_type (RygelMediathekPlaylistParser* self, const gchar* value) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_mime_type);
	self->priv->_mime_type = _tmp0_;
	g_object_notify ((GObject *) self, "mime-type");
}


static void rygel_mediathek_playlist_parser_class_init (RygelMediathekPlaylistParserClass * klass) {
	rygel_mediathek_playlist_parser_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelMediathekPlaylistParserPrivate));
	RYGEL_MEDIATHEK_PLAYLIST_PARSER_CLASS (klass)->parse_playlist = rygel_mediathek_playlist_parser_real_parse_playlist;
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_mediathek_playlist_parser_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_mediathek_playlist_parser_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_mediathek_playlist_parser_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIATHEK_PLAYLIST_PARSER_SESSION, g_param_spec_object ("session", "session", "session", SOUP_TYPE_SESSION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIATHEK_PLAYLIST_PARSER_PLAYLIST_SUFFIX, g_param_spec_string ("playlist-suffix", "playlist-suffix", "playlist-suffix", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIATHEK_PLAYLIST_PARSER_MIME_TYPE, g_param_spec_string ("mime-type", "mime-type", "mime-type", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void rygel_mediathek_playlist_parser_instance_init (RygelMediathekPlaylistParser * self) {
	self->priv = RYGEL_MEDIATHEK_PLAYLIST_PARSER_GET_PRIVATE (self);
}


static void rygel_mediathek_playlist_parser_finalize (GObject* obj) {
	RygelMediathekPlaylistParser * self;
	self = RYGEL_MEDIATHEK_PLAYLIST_PARSER (obj);
	_g_object_unref0 (self->priv->_session);
	_g_free0 (self->priv->_playlist_suffix);
	_g_free0 (self->priv->_mime_type);
	G_OBJECT_CLASS (rygel_mediathek_playlist_parser_parent_class)->finalize (obj);
}


GType rygel_mediathek_playlist_parser_get_type (void) {
	static volatile gsize rygel_mediathek_playlist_parser_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_mediathek_playlist_parser_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediathekPlaylistParserClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_mediathek_playlist_parser_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediathekPlaylistParser), 0, (GInstanceInitFunc) rygel_mediathek_playlist_parser_instance_init, NULL };
		GType rygel_mediathek_playlist_parser_type_id;
		rygel_mediathek_playlist_parser_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMediathekPlaylistParser", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&rygel_mediathek_playlist_parser_type_id__volatile, rygel_mediathek_playlist_parser_type_id);
	}
	return rygel_mediathek_playlist_parser_type_id__volatile;
}


static void _vala_rygel_mediathek_playlist_parser_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelMediathekPlaylistParser * self;
	self = RYGEL_MEDIATHEK_PLAYLIST_PARSER (object);
	switch (property_id) {
		case RYGEL_MEDIATHEK_PLAYLIST_PARSER_SESSION:
		g_value_set_object (value, rygel_mediathek_playlist_parser_get_session (self));
		break;
		case RYGEL_MEDIATHEK_PLAYLIST_PARSER_PLAYLIST_SUFFIX:
		g_value_set_string (value, rygel_mediathek_playlist_parser_get_playlist_suffix (self));
		break;
		case RYGEL_MEDIATHEK_PLAYLIST_PARSER_MIME_TYPE:
		g_value_set_string (value, rygel_mediathek_playlist_parser_get_mime_type (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_rygel_mediathek_playlist_parser_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelMediathekPlaylistParser * self;
	self = RYGEL_MEDIATHEK_PLAYLIST_PARSER (object);
	switch (property_id) {
		case RYGEL_MEDIATHEK_PLAYLIST_PARSER_SESSION:
		rygel_mediathek_playlist_parser_set_session (self, g_value_get_object (value));
		break;
		case RYGEL_MEDIATHEK_PLAYLIST_PARSER_PLAYLIST_SUFFIX:
		rygel_mediathek_playlist_parser_set_playlist_suffix (self, g_value_get_string (value));
		break;
		case RYGEL_MEDIATHEK_PLAYLIST_PARSER_MIME_TYPE:
		rygel_mediathek_playlist_parser_set_mime_type (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



