/* rygel-media-art-store.c generated by valac 0.12.0, the Vala compiler
 * generated from rygel-media-art-store.vala, do not modify */

/*
 * Copyright (C) 2010 Jens Georg <mail@jensge.org>.
 *
 * Author: Jens Georg <mail@jensge.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <libgupnp-av/gupnp-av.h>
#include <gee.h>
#include <gst/gst.h>


#define RYGEL_TYPE_MEDIA_ART_STORE (rygel_media_art_store_get_type ())
#define RYGEL_MEDIA_ART_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ART_STORE, RygelMediaArtStore))
#define RYGEL_MEDIA_ART_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ART_STORE, RygelMediaArtStoreClass))
#define RYGEL_IS_MEDIA_ART_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ART_STORE))
#define RYGEL_IS_MEDIA_ART_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ART_STORE))
#define RYGEL_MEDIA_ART_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ART_STORE, RygelMediaArtStoreClass))

typedef struct _RygelMediaArtStore RygelMediaArtStore;
typedef struct _RygelMediaArtStoreClass RygelMediaArtStoreClass;
typedef struct _RygelMediaArtStorePrivate RygelMediaArtStorePrivate;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;

#define RYGEL_TYPE_AUDIO_ITEM (rygel_audio_item_get_type ())
#define RYGEL_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem))
#define RYGEL_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))
#define RYGEL_IS_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_IS_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_AUDIO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))

typedef struct _RygelAudioItem RygelAudioItem;
typedef struct _RygelAudioItemClass RygelAudioItemClass;

#define RYGEL_TYPE_MUSIC_ITEM (rygel_music_item_get_type ())
#define RYGEL_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItem))
#define RYGEL_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItemClass))
#define RYGEL_IS_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MUSIC_ITEM))
#define RYGEL_IS_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MUSIC_ITEM))
#define RYGEL_MUSIC_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItemClass))

typedef struct _RygelMusicItem RygelMusicItem;
typedef struct _RygelMusicItemClass RygelMusicItemClass;

#define RYGEL_TYPE_ICON_INFO (rygel_icon_info_get_type ())
#define RYGEL_ICON_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ICON_INFO, RygelIconInfo))
#define RYGEL_ICON_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ICON_INFO, RygelIconInfoClass))
#define RYGEL_IS_ICON_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ICON_INFO))
#define RYGEL_IS_ICON_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ICON_INFO))
#define RYGEL_ICON_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ICON_INFO, RygelIconInfoClass))

typedef struct _RygelIconInfo RygelIconInfo;
typedef struct _RygelIconInfoClass RygelIconInfoClass;

#define RYGEL_TYPE_THUMBNAIL (rygel_thumbnail_get_type ())
#define RYGEL_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnail))
#define RYGEL_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))
#define RYGEL_IS_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_IS_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_THUMBNAIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))

typedef struct _RygelThumbnail RygelThumbnail;
typedef struct _RygelThumbnailClass RygelThumbnailClass;
typedef struct _RygelIconInfoPrivate RygelIconInfoPrivate;
#define _rygel_icon_info_unref0(var) ((var == NULL) ? NULL : (var = (rygel_icon_info_unref (var), NULL)))
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_TRANSCODE_MANAGER (rygel_transcode_manager_get_type ())
#define RYGEL_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManager))
#define RYGEL_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))
#define RYGEL_IS_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_IS_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_TRANSCODE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))

typedef struct _RygelTranscodeManager RygelTranscodeManager;
typedef struct _RygelTranscodeManagerClass RygelTranscodeManagerClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;
typedef struct _RygelMediaItemPrivate RygelMediaItemPrivate;
typedef struct _RygelAudioItemPrivate RygelAudioItemPrivate;
typedef struct _RygelMusicItemPrivate RygelMusicItemPrivate;

typedef enum  {
	MEDIA_ART_STORE_ERROR_NO_DIR,
	MEDIA_ART_STORE_ERROR_NO_MEDIA_ART
} MediaArtStoreError;
#define MEDIA_ART_STORE_ERROR media_art_store_error_quark ()
struct _RygelMediaArtStore {
	GObject parent_instance;
	RygelMediaArtStorePrivate * priv;
};

struct _RygelMediaArtStoreClass {
	GObjectClass parent_class;
};

struct _RygelMediaArtStorePrivate {
	GRegex* char_remove_regex;
	GRegex* char_convert_regex;
	GRegex* space_compress_regex;
	GRegex** block_regexes;
	gint block_regexes_length1;
	gint _block_regexes_size_;
	gchar* directory;
};

struct _RygelIconInfo {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelIconInfoPrivate * priv;
	gchar* mime_type;
	gchar* uri;
	gchar* file_extension;
	gint64 size;
	gint width;
	gint height;
	gint depth;
};

struct _RygelIconInfoClass {
	GTypeClass parent_class;
	void (*finalize) (RygelIconInfo *self);
};

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	gchar* id;
	gchar* ref_id;
	gchar* upnp_class;
	guint64 modified;
	GeeArrayList* uris;
	RygelMediaContainer* parent;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
	GUPnPDIDLLiteObject* (*serialize) (RygelMediaObject* self, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error);
	gint (*compare_by_property) (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property);
	GUPnPOCMFlags (*get_ocm_flags) (RygelMediaObject* self);
};

struct _RygelMediaItem {
	RygelMediaObject parent_instance;
	RygelMediaItemPrivate * priv;
	gchar* date;
	gchar* mime_type;
	gchar* dlna_profile;
	GRegex* address_regex;
};

struct _RygelMediaItemClass {
	RygelMediaObjectClass parent_class;
	GstElement* (*create_stream_source) (RygelMediaItem* self);
	gboolean (*streamable) (RygelMediaItem* self);
	void (*add_uri) (RygelMediaItem* self, const gchar* uri);
	GUPnPDIDLLiteResource* (*add_resource) (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, const gchar* uri, const gchar* protocol, const gchar* import_uri, GError** error);
	void (*add_proxy_resources) (RygelMediaItem* self, RygelHTTPServer* server, GUPnPDIDLLiteItem* didl_item, GError** error);
	GUPnPProtocolInfo* (*get_protocol_info) (RygelMediaItem* self, const gchar* uri, const gchar* protocol);
	void (*add_resources) (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, gboolean allow_internal, GError** error);
};

struct _RygelAudioItem {
	RygelMediaItem parent_instance;
	RygelAudioItemPrivate * priv;
	glong duration;
	gint bitrate;
	gint sample_freq;
	gint bits_per_sample;
	gint channels;
};

struct _RygelAudioItemClass {
	RygelMediaItemClass parent_class;
};

struct _RygelMusicItem {
	RygelAudioItem parent_instance;
	RygelMusicItemPrivate * priv;
	gchar* artist;
	gchar* album;
	gchar* genre;
	gint track_number;
	RygelThumbnail* album_art;
};

struct _RygelMusicItemClass {
	RygelAudioItemClass parent_class;
};


static gpointer rygel_media_art_store_parent_class = NULL;
static RygelMediaArtStore* rygel_media_art_store_media_art_store;
static RygelMediaArtStore* rygel_media_art_store_media_art_store = NULL;
static gboolean rygel_media_art_store_first_time;
static gboolean rygel_media_art_store_first_time = TRUE;

GQuark media_art_store_error_quark (void);
GType rygel_media_art_store_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIA_ART_STORE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_MEDIA_ART_STORE, RygelMediaArtStorePrivate))
enum  {
	RYGEL_MEDIA_ART_STORE_DUMMY_PROPERTY
};
#define RYGEL_MEDIA_ART_STORE_PLACEHOLDER_HASH "7215ee9c7d9dc229d2921a40e899ec5f"
#define RYGEL_MEDIA_ART_STORE_invalid_chars "()[]<>{}_!@#$^&*+=|\\/\"'?~"
#define RYGEL_MEDIA_ART_STORE_convert_chars "\t"
#define RYGEL_MEDIA_ART_STORE_block_pattern "%s[^%s]*%s"
RygelMediaArtStore* rygel_media_art_store_get_default (void);
static RygelMediaArtStore* rygel_media_art_store_new (GError** error);
static RygelMediaArtStore* rygel_media_art_store_construct (GType object_type, GError** error);
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
GType rygel_audio_item_get_type (void) G_GNUC_CONST;
GType rygel_music_item_get_type (void) G_GNUC_CONST;
gpointer rygel_icon_info_ref (gpointer instance);
void rygel_icon_info_unref (gpointer instance);
GParamSpec* rygel_param_spec_icon_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_icon_info (GValue* value, gpointer v_object);
void rygel_value_take_icon_info (GValue* value, gpointer v_object);
gpointer rygel_value_get_icon_info (const GValue* value);
GType rygel_icon_info_get_type (void) G_GNUC_CONST;
GType rygel_thumbnail_get_type (void) G_GNUC_CONST;
RygelThumbnail* rygel_media_art_store_find_media_art (RygelMediaArtStore* self, RygelMusicItem* item, gboolean simple, GError** error);
GFile* rygel_media_art_store_get_media_art_file (RygelMediaArtStore* self, const gchar* type, RygelMusicItem* item, gboolean simple);
RygelThumbnail* rygel_thumbnail_new (const gchar* mime_type, const gchar* dlna_profile, const gchar* file_extension);
RygelThumbnail* rygel_thumbnail_construct (GType object_type, const gchar* mime_type, const gchar* dlna_profile, const gchar* file_extension);
RygelThumbnail* rygel_media_art_store_find_media_art_any (RygelMediaArtStore* self, RygelMusicItem* item, GError** error);
static gchar* rygel_media_art_store_get_simple_hash (RygelMediaArtStore* self, const gchar* type, RygelMusicItem* item);
static gchar* rygel_media_art_store_get_hash (RygelMediaArtStore* self, const gchar* type, RygelMusicItem* item);
static void _vala_array_add1 (GRegex*** array, int* length, int* size, GRegex* value);
static gchar* rygel_media_art_store_normalize_and_hash (RygelMediaArtStore* self, const gchar* input, gboolean utf8_only);
GType rygel_transcode_manager_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
const gchar* rygel_media_object_get_title (RygelMediaObject* self);
static gchar* rygel_media_art_store_strip_invalid_entities (RygelMediaArtStore* self, const gchar* original);
static void rygel_media_art_store_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const gchar* RYGEL_MEDIA_ART_STORE_blocks[4] = {"()", "{}", "[]", "<>"};

GQuark media_art_store_error_quark (void) {
	return g_quark_from_static_string ("media_art_store_error-quark");
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


RygelMediaArtStore* rygel_media_art_store_get_default (void) {
	RygelMediaArtStore* result = NULL;
	RygelMediaArtStore* _tmp2_;
	GError * _inner_error_ = NULL;
	if (rygel_media_art_store_first_time) {
		RygelMediaArtStore* _tmp0_ = NULL;
		RygelMediaArtStore* _tmp1_;
		_tmp0_ = rygel_media_art_store_new (&_inner_error_);
		_tmp1_ = _tmp0_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == MEDIA_ART_STORE_ERROR) {
				goto __catch59_media_art_store_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_g_object_unref0 (rygel_media_art_store_media_art_store);
		rygel_media_art_store_media_art_store = _tmp1_;
		goto __finally59;
		__catch59_media_art_store_error:
		{
			GError * _error_;
			_error_ = _inner_error_;
			_inner_error_ = NULL;
			g_warning ("rygel-media-art-store.vala:48: No media art available: %s", _error_->message);
			_g_error_free0 (_error_);
		}
		__finally59:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	rygel_media_art_store_first_time = FALSE;
	_tmp2_ = _g_object_ref0 (rygel_media_art_store_media_art_store);
	result = _tmp2_;
	return result;
}


RygelThumbnail* rygel_media_art_store_find_media_art (RygelMediaArtStore* self, RygelMusicItem* item, gboolean simple, GError** error) {
	RygelThumbnail* result = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar** _tmp5_ = NULL;
	gchar** types;
	gint types_length1;
	gint _types_size_;
	GFile* file;
	GFileInfo* _tmp9_ = NULL;
	GFileInfo* info;
	gboolean _tmp10_;
	RygelThumbnail* _tmp11_ = NULL;
	RygelThumbnail* thumb;
	gchar* _tmp12_ = NULL;
	gint64 _tmp13_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (item != NULL, NULL);
	_tmp0_ = g_strdup ("track");
	_tmp1_ = g_strdup ("album");
	_tmp2_ = g_strdup ("artist");
	_tmp3_ = g_strdup ("podcast");
	_tmp4_ = g_strdup ("radio");
	_tmp5_ = g_new0 (gchar*, 5 + 1);
	_tmp5_[0] = _tmp0_;
	_tmp5_[1] = _tmp1_;
	_tmp5_[2] = _tmp2_;
	_tmp5_[3] = _tmp3_;
	_tmp5_[4] = _tmp4_;
	types = _tmp5_;
	types_length1 = 5;
	_types_size_ = 5;
	file = NULL;
	{
		gchar** type_collection;
		int type_collection_length1;
		int type_it;
		type_collection = types;
		type_collection_length1 = types_length1;
		for (type_it = 0; type_it < types_length1; type_it = type_it + 1) {
			gchar* _tmp6_;
			gchar* type;
			_tmp6_ = g_strdup (type_collection[type_it]);
			type = _tmp6_;
			{
				GFile* _tmp7_ = NULL;
				gboolean _tmp8_;
				_tmp7_ = rygel_media_art_store_get_media_art_file (self, type, item, simple);
				_g_object_unref0 (file);
				file = _tmp7_;
				_tmp8_ = g_file_query_exists (file, NULL);
				if (_tmp8_) {
					_g_free0 (type);
					break;
				} else {
					_g_object_unref0 (file);
					file = NULL;
				}
				_g_free0 (type);
			}
		}
	}
	if (file == NULL) {
		result = NULL;
		_g_object_unref0 (file);
		types = (_vala_array_free (types, types_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp9_ = g_file_query_info (file, G_FILE_ATTRIBUTE_ACCESS_CAN_READ "," G_FILE_ATTRIBUTE_STANDARD_SIZE, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
	info = _tmp9_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (file);
		types = (_vala_array_free (types, types_length1, (GDestroyNotify) g_free), NULL);
		return NULL;
	}
	_tmp10_ = g_file_info_get_attribute_boolean (info, G_FILE_ATTRIBUTE_ACCESS_CAN_READ);
	if (!_tmp10_) {
		result = NULL;
		_g_object_unref0 (info);
		_g_object_unref0 (file);
		types = (_vala_array_free (types, types_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp11_ = rygel_thumbnail_new ("image/jpeg", "JPEG_TN", "jpg");
	thumb = _tmp11_;
	_tmp12_ = g_file_get_uri (file);
	_g_free0 (((RygelIconInfo*) thumb)->uri);
	((RygelIconInfo*) thumb)->uri = _tmp12_;
	_tmp13_ = g_file_info_get_size (info);
	((RygelIconInfo*) thumb)->size = (gint64) _tmp13_;
	result = thumb;
	_g_object_unref0 (info);
	_g_object_unref0 (file);
	types = (_vala_array_free (types, types_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


RygelThumbnail* rygel_media_art_store_find_media_art_any (RygelMediaArtStore* self, RygelMusicItem* item, GError** error) {
	RygelThumbnail* result = NULL;
	RygelThumbnail* _tmp0_ = NULL;
	RygelThumbnail* thumb;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (item != NULL, NULL);
	_tmp0_ = rygel_media_art_store_find_media_art (self, item, FALSE, &_inner_error_);
	thumb = _tmp0_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	if (thumb == NULL) {
		RygelThumbnail* _tmp1_ = NULL;
		RygelThumbnail* _tmp2_;
		_tmp1_ = rygel_media_art_store_find_media_art (self, item, TRUE, &_inner_error_);
		_tmp2_ = _tmp1_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_rygel_icon_info_unref0 (thumb);
			return NULL;
		}
		_rygel_icon_info_unref0 (thumb);
		thumb = _tmp2_;
	}
	result = thumb;
	return result;
}


GFile* rygel_media_art_store_get_media_art_file (RygelMediaArtStore* self, const gchar* type, RygelMusicItem* item, gboolean simple) {
	GFile* result = NULL;
	gchar* hash = NULL;
	gchar* suffix = NULL;
	gchar* _tmp4_ = NULL;
	gchar* file_path;
	gchar* _tmp5_ = NULL;
	gchar* path;
	GFile* _tmp6_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (type != NULL, NULL);
	g_return_val_if_fail (item != NULL, NULL);
	if (simple) {
		gchar* _tmp0_ = NULL;
		gchar* _tmp1_;
		_tmp0_ = rygel_media_art_store_get_simple_hash (self, type, item);
		_g_free0 (hash);
		hash = _tmp0_;
		_tmp1_ = g_strdup ("jpg");
		_g_free0 (suffix);
		suffix = _tmp1_;
	} else {
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		_tmp2_ = rygel_media_art_store_get_hash (self, type, item);
		_g_free0 (hash);
		hash = _tmp2_;
		_tmp3_ = g_strdup ("jpeg");
		_g_free0 (suffix);
		suffix = _tmp3_;
	}
	_tmp4_ = g_strdup_printf ("%s-%s.%s", type, hash, suffix);
	file_path = _tmp4_;
	_tmp5_ = g_build_filename (self->priv->directory, file_path, NULL);
	path = _tmp5_;
	_tmp6_ = g_file_new_for_path (path);
	result = _tmp6_;
	_g_free0 (path);
	_g_free0 (file_path);
	_g_free0 (suffix);
	_g_free0 (hash);
	return result;
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	result = ((gchar*) self)[index];
	return result;
}


static void _vala_array_add1 (GRegex*** array, int* length, int* size, GRegex* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GRegex*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static RygelMediaArtStore* rygel_media_art_store_construct (GType object_type, GError** error) {
	RygelMediaArtStore * self = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* dir;
	GFile* _tmp2_ = NULL;
	GFile* file;
	gboolean _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_ = NULL;
	gchar* regex_string;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	GRegex* _tmp8_ = NULL;
	GRegex* _tmp9_;
	GRegex* _tmp10_;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_;
	GRegex* _tmp14_ = NULL;
	GRegex* _tmp15_;
	GRegex* _tmp16_;
	GRegex* _tmp17_ = NULL;
	GRegex* _tmp18_;
	GRegex** _tmp19_ = NULL;
	GError * _inner_error_ = NULL;
	self = (RygelMediaArtStore*) g_object_new (object_type, NULL);
	_tmp0_ = g_get_user_cache_dir ();
	_tmp1_ = g_build_filename (_tmp0_, "media-art", NULL);
	dir = _tmp1_;
	_tmp2_ = g_file_new_for_path (dir);
	file = _tmp2_;
	_tmp3_ = g_file_query_exists (file, NULL);
	if (!_tmp3_) {
		g_mkdir_with_parents (dir, 0750);
	}
	_tmp4_ = g_strdup (dir);
	_g_free0 (self->priv->directory);
	self->priv->directory = _tmp4_;
	_tmp5_ = g_regex_escape_string (RYGEL_MEDIA_ART_STORE_invalid_chars, -1);
	regex_string = _tmp5_;
	_tmp6_ = g_strdup_printf ("[%s]", regex_string);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_regex_new (_tmp7_, 0, 0, &_inner_error_);
	_tmp9_ = _tmp8_;
	_g_free0 (_tmp7_);
	_tmp10_ = _tmp9_;
	if (_inner_error_ != NULL) {
		_g_free0 (regex_string);
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch60_g_regex_error;
		}
		_g_free0 (regex_string);
		_g_object_unref0 (file);
		_g_free0 (dir);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_g_regex_unref0 (self->priv->char_remove_regex);
	self->priv->char_remove_regex = _tmp10_;
	_tmp11_ = g_regex_escape_string (RYGEL_MEDIA_ART_STORE_convert_chars, -1);
	_g_free0 (regex_string);
	regex_string = _tmp11_;
	_tmp12_ = g_strdup_printf ("[%s]", regex_string);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_regex_new (_tmp13_, 0, 0, &_inner_error_);
	_tmp15_ = _tmp14_;
	_g_free0 (_tmp13_);
	_tmp16_ = _tmp15_;
	if (_inner_error_ != NULL) {
		_g_free0 (regex_string);
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch60_g_regex_error;
		}
		_g_free0 (regex_string);
		_g_object_unref0 (file);
		_g_free0 (dir);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_g_regex_unref0 (self->priv->char_convert_regex);
	self->priv->char_convert_regex = _tmp16_;
	_tmp17_ = g_regex_new ("\\s+", 0, 0, &_inner_error_);
	_tmp18_ = _tmp17_;
	if (_inner_error_ != NULL) {
		_g_free0 (regex_string);
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch60_g_regex_error;
		}
		_g_free0 (regex_string);
		_g_object_unref0 (file);
		_g_free0 (dir);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_g_regex_unref0 (self->priv->space_compress_regex);
	self->priv->space_compress_regex = _tmp18_;
	_tmp19_ = g_new0 (GRegex*, 0 + 1);
	self->priv->block_regexes = (_vala_array_free (self->priv->block_regexes, self->priv->block_regexes_length1, (GDestroyNotify) g_regex_unref), NULL);
	self->priv->block_regexes = _tmp19_;
	self->priv->block_regexes_length1 = 0;
	self->priv->_block_regexes_size_ = 0;
	{
		const gchar** block_collection;
		int block_collection_length1;
		int block_it;
		block_collection = RYGEL_MEDIA_ART_STORE_blocks;
		block_collection_length1 = G_N_ELEMENTS (RYGEL_MEDIA_ART_STORE_blocks);
		for (block_it = 0; block_it < G_N_ELEMENTS (RYGEL_MEDIA_ART_STORE_blocks); block_it = block_it + 1) {
			const gchar* block;
			block = block_collection[block_it];
			{
				gchar _tmp20_;
				gchar* _tmp21_ = NULL;
				gchar* _tmp22_;
				gchar* _tmp23_ = NULL;
				gchar* _tmp24_;
				gchar _tmp25_;
				gchar* _tmp26_ = NULL;
				gchar* _tmp27_;
				gchar* _tmp28_ = NULL;
				gchar* _tmp29_;
				gchar _tmp30_;
				gchar* _tmp31_ = NULL;
				gchar* _tmp32_;
				gchar* _tmp33_ = NULL;
				gchar* _tmp34_;
				gchar* _tmp35_ = NULL;
				gchar* _tmp36_;
				gchar* block_re;
				GRegex* _tmp37_ = NULL;
				GRegex* _tmp38_;
				_tmp20_ = string_get (block, (glong) 0);
				_tmp21_ = g_strdup_printf ("%C", _tmp20_);
				_tmp22_ = _tmp21_;
				_tmp23_ = g_regex_escape_string (_tmp22_, -1);
				_tmp24_ = _tmp23_;
				_tmp25_ = string_get (block, (glong) 1);
				_tmp26_ = g_strdup_printf ("%C", _tmp25_);
				_tmp27_ = _tmp26_;
				_tmp28_ = g_regex_escape_string (_tmp27_, -1);
				_tmp29_ = _tmp28_;
				_tmp30_ = string_get (block, (glong) 1);
				_tmp31_ = g_strdup_printf ("%C", _tmp30_);
				_tmp32_ = _tmp31_;
				_tmp33_ = g_regex_escape_string (_tmp32_, -1);
				_tmp34_ = _tmp33_;
				_tmp35_ = g_strdup_printf (RYGEL_MEDIA_ART_STORE_block_pattern, _tmp24_, _tmp29_, _tmp34_);
				_tmp36_ = _tmp35_;
				_g_free0 (_tmp34_);
				_g_free0 (_tmp32_);
				_g_free0 (_tmp29_);
				_g_free0 (_tmp27_);
				_g_free0 (_tmp24_);
				_g_free0 (_tmp22_);
				block_re = _tmp36_;
				_tmp37_ = g_regex_new (block_re, 0, 0, &_inner_error_);
				_tmp38_ = _tmp37_;
				if (_inner_error_ != NULL) {
					_g_free0 (block_re);
					_g_free0 (regex_string);
					if (_inner_error_->domain == G_REGEX_ERROR) {
						goto __catch60_g_regex_error;
					}
					_g_free0 (block_re);
					_g_free0 (regex_string);
					_g_object_unref0 (file);
					_g_free0 (dir);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
				_vala_array_add1 (&self->priv->block_regexes, &self->priv->block_regexes_length1, &self->priv->_block_regexes_size_, _tmp38_);
				_g_free0 (block_re);
			}
		}
	}
	_g_free0 (regex_string);
	goto __finally60;
	__catch60_g_regex_error:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (_error_);
	}
	__finally60:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == MEDIA_ART_STORE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (file);
			_g_free0 (dir);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_object_unref0 (file);
			_g_free0 (dir);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_g_object_unref0 (file);
	_g_free0 (dir);
	return self;
}


static RygelMediaArtStore* rygel_media_art_store_new (GError** error) {
	return rygel_media_art_store_construct (RYGEL_TYPE_MEDIA_ART_STORE, error);
}


static gchar* rygel_media_art_store_get_simple_hash (RygelMediaArtStore* self, const gchar* type, RygelMusicItem* item) {
	gchar* result = NULL;
	gchar* hash = NULL;
	const gchar* _tmp0_;
	GQuark _tmp1_;
	static GQuark _tmp1__label0 = 0;
	static GQuark _tmp1__label1 = 0;
	static GQuark _tmp1__label2 = 0;
	static GQuark _tmp1__label3 = 0;
	static GQuark _tmp1__label4 = 0;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (type != NULL, NULL);
	g_return_val_if_fail (item != NULL, NULL);
	_tmp0_ = type;
	_tmp1_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if ((_tmp1_ == ((0 != _tmp1__label0) ? _tmp1__label0 : (_tmp1__label0 = g_quark_from_static_string ("artist")))) || (_tmp1_ == ((0 != _tmp1__label1) ? _tmp1__label1 : (_tmp1__label1 = g_quark_from_static_string ("radio"))))) {
		switch (0) {
			default:
			{
				gchar* _tmp2_ = NULL;
				_tmp2_ = rygel_media_art_store_normalize_and_hash (self, item->artist, TRUE);
				_g_free0 (hash);
				hash = _tmp2_;
				break;
			}
		}
	} else if (_tmp1_ == ((0 != _tmp1__label2) ? _tmp1__label2 : (_tmp1__label2 = g_quark_from_static_string ("podcast")))) {
		switch (0) {
			default:
			{
				const gchar* _tmp3_ = NULL;
				gchar* _tmp4_ = NULL;
				_tmp3_ = rygel_media_object_get_title ((RygelMediaObject*) item);
				_tmp4_ = rygel_media_art_store_normalize_and_hash (self, _tmp3_, TRUE);
				_g_free0 (hash);
				hash = _tmp4_;
				break;
			}
		}
	} else if (_tmp1_ == ((0 != _tmp1__label3) ? _tmp1__label3 : (_tmp1__label3 = g_quark_from_static_string ("album")))) {
		switch (0) {
			default:
			{
				gchar* _tmp5_;
				gchar* _tmp6_;
				gchar* _tmp7_;
				gchar* _tmp8_;
				gchar* _tmp9_ = NULL;
				_tmp5_ = g_strconcat (item->artist, "\t", NULL);
				_tmp6_ = _tmp5_;
				_tmp7_ = g_strconcat (_tmp6_, item->album, NULL);
				_tmp8_ = _tmp7_;
				_tmp9_ = rygel_media_art_store_normalize_and_hash (self, _tmp8_, TRUE);
				_g_free0 (hash);
				hash = _tmp9_;
				_g_free0 (_tmp8_);
				_g_free0 (_tmp6_);
				break;
			}
		}
	} else if (_tmp1_ == ((0 != _tmp1__label4) ? _tmp1__label4 : (_tmp1__label4 = g_quark_from_static_string ("track")))) {
		switch (0) {
			default:
			{
				gchar* _tmp10_;
				gchar* _tmp11_;
				gchar* _tmp12_;
				gchar* _tmp13_;
				gchar* _tmp14_;
				gchar* _tmp15_;
				const gchar* _tmp16_ = NULL;
				gchar* _tmp17_;
				gchar* _tmp18_;
				gchar* _tmp19_ = NULL;
				_tmp10_ = g_strconcat (item->artist, "\t", NULL);
				_tmp11_ = _tmp10_;
				_tmp12_ = g_strconcat (_tmp11_, item->album, NULL);
				_tmp13_ = _tmp12_;
				_tmp14_ = g_strconcat (_tmp13_, "\t", NULL);
				_tmp15_ = _tmp14_;
				_tmp16_ = rygel_media_object_get_title ((RygelMediaObject*) item);
				_tmp17_ = g_strconcat (_tmp15_, _tmp16_, NULL);
				_tmp18_ = _tmp17_;
				_tmp19_ = rygel_media_art_store_normalize_and_hash (self, _tmp18_, TRUE);
				_g_free0 (hash);
				hash = _tmp19_;
				_g_free0 (_tmp18_);
				_g_free0 (_tmp15_);
				_g_free0 (_tmp13_);
				_g_free0 (_tmp11_);
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				g_assert_not_reached ();
			}
		}
	}
	result = hash;
	return result;
}


static gchar* rygel_media_art_store_get_hash (RygelMediaArtStore* self, const gchar* type, RygelMusicItem* item) {
	gchar* result = NULL;
	gchar* b;
	gchar* c;
	const gchar* _tmp0_;
	GQuark _tmp1_;
	static GQuark _tmp1__label0 = 0;
	static GQuark _tmp1__label1 = 0;
	static GQuark _tmp1__label2 = 0;
	static GQuark _tmp1__label3 = 0;
	static GQuark _tmp1__label4 = 0;
	gchar* _tmp16_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (type != NULL, NULL);
	g_return_val_if_fail (item != NULL, NULL);
	b = NULL;
	c = NULL;
	_tmp0_ = type;
	_tmp1_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp1_ == ((0 != _tmp1__label0) ? _tmp1__label0 : (_tmp1__label0 = g_quark_from_static_string ("track")))) {
		switch (0) {
			default:
			{
				gchar* _tmp2_ = NULL;
				gchar* _tmp3_;
				gchar* _tmp4_;
				gchar* _tmp5_;
				gchar* _tmp6_ = NULL;
				gchar* _tmp7_;
				gchar* _tmp8_;
				const gchar* _tmp9_ = NULL;
				gchar* _tmp10_ = NULL;
				_tmp2_ = rygel_media_art_store_normalize_and_hash (self, item->artist, FALSE);
				_tmp3_ = _tmp2_;
				_tmp4_ = g_strconcat (_tmp3_, "-", NULL);
				_tmp5_ = _tmp4_;
				_tmp6_ = rygel_media_art_store_normalize_and_hash (self, item->album, FALSE);
				_tmp7_ = _tmp6_;
				_tmp8_ = g_strconcat (_tmp5_, _tmp7_, NULL);
				_g_free0 (b);
				b = _tmp8_;
				_g_free0 (_tmp7_);
				_g_free0 (_tmp5_);
				_g_free0 (_tmp3_);
				_tmp9_ = rygel_media_object_get_title ((RygelMediaObject*) item);
				_tmp10_ = rygel_media_art_store_normalize_and_hash (self, _tmp9_, FALSE);
				_g_free0 (c);
				c = _tmp10_;
				break;
			}
		}
	} else if ((_tmp1_ == ((0 != _tmp1__label1) ? _tmp1__label1 : (_tmp1__label1 = g_quark_from_static_string ("album")))) || (_tmp1_ == ((0 != _tmp1__label2) ? _tmp1__label2 : (_tmp1__label2 = g_quark_from_static_string ("artist"))))) {
		switch (0) {
			default:
			{
				gchar* _tmp11_ = NULL;
				gchar* _tmp12_ = NULL;
				_tmp11_ = rygel_media_art_store_normalize_and_hash (self, item->artist, FALSE);
				_g_free0 (b);
				b = _tmp11_;
				_tmp12_ = rygel_media_art_store_normalize_and_hash (self, item->album, FALSE);
				_g_free0 (c);
				c = _tmp12_;
				break;
			}
		}
	} else if ((_tmp1_ == ((0 != _tmp1__label3) ? _tmp1__label3 : (_tmp1__label3 = g_quark_from_static_string ("radio")))) || (_tmp1_ == ((0 != _tmp1__label4) ? _tmp1__label4 : (_tmp1__label4 = g_quark_from_static_string ("podcast"))))) {
		switch (0) {
			default:
			{
				const gchar* _tmp13_ = NULL;
				gchar* _tmp14_ = NULL;
				gchar* _tmp15_;
				_tmp13_ = rygel_media_object_get_title ((RygelMediaObject*) item);
				_tmp14_ = rygel_media_art_store_normalize_and_hash (self, _tmp13_, FALSE);
				_g_free0 (b);
				b = _tmp14_;
				_tmp15_ = g_strdup (RYGEL_MEDIA_ART_STORE_PLACEHOLDER_HASH);
				_g_free0 (c);
				c = _tmp15_;
				break;
			}
		}
	}
	_tmp16_ = g_strdup_printf ("%s-%s", b, c);
	result = _tmp16_;
	_g_free0 (c);
	_g_free0 (b);
	return result;
}


static gchar* rygel_media_art_store_normalize_and_hash (RygelMediaArtStore* self, const gchar* input, gboolean utf8_only) {
	gchar* result = NULL;
	gchar* _tmp0_;
	gchar* normalized;
	gboolean _tmp1_ = FALSE;
	gchar* _tmp6_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (" ");
	normalized = _tmp0_;
	if (input != NULL) {
		_tmp1_ = g_strcmp0 (input, "") != 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gchar* _tmp5_ = NULL;
		if (utf8_only) {
			gchar* _tmp2_;
			_tmp2_ = g_strdup (input);
			_g_free0 (normalized);
			normalized = _tmp2_;
		} else {
			gchar* _tmp3_ = NULL;
			gchar* _tmp4_ = NULL;
			_tmp3_ = rygel_media_art_store_strip_invalid_entities (self, input);
			_g_free0 (normalized);
			normalized = _tmp3_;
			_tmp4_ = g_utf8_strdown (normalized, (gssize) (-1));
			_g_free0 (normalized);
			normalized = _tmp4_;
		}
		_tmp5_ = g_utf8_normalize (normalized, (gssize) (-1), G_NORMALIZE_ALL);
		_g_free0 (normalized);
		normalized = _tmp5_;
	}
	_tmp6_ = g_compute_checksum_for_string (G_CHECKSUM_MD5, normalized, (gsize) (-1));
	result = _tmp6_;
	_g_free0 (normalized);
	return result;
}


static gpointer _g_regex_ref0 (gpointer self) {
	return self ? g_regex_ref (self) : NULL;
}


static gchar* rygel_media_art_store_strip_invalid_entities (RygelMediaArtStore* self, const gchar* original) {
	gchar* result = NULL;
	gchar* p = NULL;
	gchar* _tmp0_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (original != NULL, NULL);
	_tmp0_ = g_strdup (original);
	_g_free0 (p);
	p = _tmp0_;
	{
		GRegex** re_collection;
		int re_collection_length1;
		int re_it;
		re_collection = self->priv->block_regexes;
		re_collection_length1 = self->priv->block_regexes_length1;
		for (re_it = 0; re_it < self->priv->block_regexes_length1; re_it = re_it + 1) {
			GRegex* _tmp1_;
			GRegex* re;
			_tmp1_ = _g_regex_ref0 (re_collection[re_it]);
			re = _tmp1_;
			{
				gchar* _tmp2_ = NULL;
				gchar* _tmp3_;
				_tmp2_ = g_regex_replace_literal (re, p, (gssize) (-1), 0, "", 0, &_inner_error_);
				_tmp3_ = _tmp2_;
				if (_inner_error_ != NULL) {
					_g_regex_unref0 (re);
					if (_inner_error_->domain == G_REGEX_ERROR) {
						goto __catch61_g_regex_error;
					}
					_g_regex_unref0 (re);
					_g_free0 (p);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
				_g_free0 (p);
				p = _tmp3_;
				_g_regex_unref0 (re);
			}
		}
	}
	_tmp4_ = g_regex_replace_literal (self->priv->char_remove_regex, p, (gssize) (-1), 0, "", 0, &_inner_error_);
	_tmp5_ = _tmp4_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch61_g_regex_error;
		}
		_g_free0 (p);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_g_free0 (p);
	p = _tmp5_;
	_tmp6_ = g_regex_replace_literal (self->priv->char_convert_regex, p, (gssize) (-1), 0, " ", 0, &_inner_error_);
	_tmp7_ = _tmp6_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch61_g_regex_error;
		}
		_g_free0 (p);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_g_free0 (p);
	p = _tmp7_;
	_tmp8_ = g_regex_replace_literal (self->priv->space_compress_regex, p, (gssize) (-1), 0, " ", 0, &_inner_error_);
	_tmp9_ = _tmp8_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch61_g_regex_error;
		}
		_g_free0 (p);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_g_free0 (p);
	p = _tmp9_;
	result = p;
	return result;
	goto __finally61;
	__catch61_g_regex_error:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (_error_);
	}
	__finally61:
	_g_free0 (p);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return NULL;
}


static void rygel_media_art_store_class_init (RygelMediaArtStoreClass * klass) {
	rygel_media_art_store_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelMediaArtStorePrivate));
	G_OBJECT_CLASS (klass)->finalize = rygel_media_art_store_finalize;
}


static void rygel_media_art_store_instance_init (RygelMediaArtStore * self) {
	self->priv = RYGEL_MEDIA_ART_STORE_GET_PRIVATE (self);
}


static void rygel_media_art_store_finalize (GObject* obj) {
	RygelMediaArtStore * self;
	self = RYGEL_MEDIA_ART_STORE (obj);
	_g_regex_unref0 (self->priv->char_remove_regex);
	_g_regex_unref0 (self->priv->char_convert_regex);
	_g_regex_unref0 (self->priv->space_compress_regex);
	self->priv->block_regexes = (_vala_array_free (self->priv->block_regexes, self->priv->block_regexes_length1, (GDestroyNotify) g_regex_unref), NULL);
	_g_free0 (self->priv->directory);
	G_OBJECT_CLASS (rygel_media_art_store_parent_class)->finalize (obj);
}


GType rygel_media_art_store_get_type (void) {
	static volatile gsize rygel_media_art_store_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_art_store_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaArtStoreClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_art_store_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaArtStore), 0, (GInstanceInitFunc) rygel_media_art_store_instance_init, NULL };
		GType rygel_media_art_store_type_id;
		rygel_media_art_store_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMediaArtStore", &g_define_type_info, 0);
		g_once_init_leave (&rygel_media_art_store_type_id__volatile, rygel_media_art_store_type_id);
	}
	return rygel_media_art_store_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



