/* rygel-media-container.c generated by valac 0.13.3, the Vala compiler
 * generated from rygel-media-container.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2010 MediaNet Inh.
 * Copyright (C) 2010 Nokia Corporation.
 *
 * Authors: Zeeshan Ali <zeenix@gmail.com>
 *          Sunil Mohan Adapa <sunil@medhas.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libgupnp-av/gupnp-av.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gio/gio.h>


#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_TRANSCODE_MANAGER (rygel_transcode_manager_get_type ())
#define RYGEL_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManager))
#define RYGEL_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))
#define RYGEL_IS_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_IS_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_TRANSCODE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))

typedef struct _RygelTranscodeManager RygelTranscodeManager;
typedef struct _RygelTranscodeManagerClass RygelTranscodeManagerClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;
typedef struct _RygelMediaContainerPrivate RygelMediaContainerPrivate;

#define RYGEL_TYPE_MEDIA_OBJECTS (rygel_media_objects_get_type ())
#define RYGEL_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjects))
#define RYGEL_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))
#define RYGEL_IS_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_IS_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_MEDIA_OBJECTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))

typedef struct _RygelMediaObjects RygelMediaObjects;
typedef struct _RygelMediaObjectsClass RygelMediaObjectsClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_TYPE_SEARCHABLE_CONTAINER (rygel_searchable_container_get_type ())
#define RYGEL_SEARCHABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER, RygelSearchableContainer))
#define RYGEL_IS_SEARCHABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER))
#define RYGEL_SEARCHABLE_CONTAINER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER, RygelSearchableContainerIface))

typedef struct _RygelSearchableContainer RygelSearchableContainer;
typedef struct _RygelSearchableContainerIface RygelSearchableContainerIface;

#define RYGEL_TYPE_SEARCH_EXPRESSION (rygel_search_expression_get_type ())
#define RYGEL_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpression))
#define RYGEL_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpressionClass))
#define RYGEL_IS_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCH_EXPRESSION))
#define RYGEL_IS_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SEARCH_EXPRESSION))
#define RYGEL_SEARCH_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpressionClass))

typedef struct _RygelSearchExpression RygelSearchExpression;
typedef struct _RygelSearchExpressionClass RygelSearchExpressionClass;

#define RYGEL_TYPE_WRITABLE_CONTAINER (rygel_writable_container_get_type ())
#define RYGEL_WRITABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_WRITABLE_CONTAINER, RygelWritableContainer))
#define RYGEL_IS_WRITABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_WRITABLE_CONTAINER))
#define RYGEL_WRITABLE_CONTAINER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_WRITABLE_CONTAINER, RygelWritableContainerIface))

typedef struct _RygelWritableContainer RygelWritableContainer;
typedef struct _RygelWritableContainerIface RygelWritableContainerIface;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_META_CONFIG (rygel_meta_config_get_type ())
#define RYGEL_META_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_META_CONFIG, RygelMetaConfig))
#define RYGEL_META_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_META_CONFIG, RygelMetaConfigClass))
#define RYGEL_IS_META_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_META_CONFIG))
#define RYGEL_IS_META_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_META_CONFIG))
#define RYGEL_META_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_META_CONFIG, RygelMetaConfigClass))

typedef struct _RygelMetaConfig RygelMetaConfig;
typedef struct _RygelMetaConfigClass RygelMetaConfigClass;

#define RYGEL_TYPE_CONFIGURATION (rygel_configuration_get_type ())
#define RYGEL_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CONFIGURATION, RygelConfiguration))
#define RYGEL_IS_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CONFIGURATION))
#define RYGEL_CONFIGURATION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_CONFIGURATION, RygelConfigurationIface))

typedef struct _RygelConfiguration RygelConfiguration;
typedef struct _RygelConfigurationIface RygelConfigurationIface;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	gchar* id;
	gchar* ref_id;
	gchar* upnp_class;
	guint64 modified;
	GeeArrayList* uris;
	RygelMediaContainer* parent;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
	GUPnPDIDLLiteObject* (*serialize) (RygelMediaObject* self, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error);
	gint (*compare_by_property) (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property);
	GUPnPOCMFlags (*get_ocm_flags) (RygelMediaObject* self);
};

struct _RygelMediaContainer {
	RygelMediaObject parent_instance;
	RygelMediaContainerPrivate * priv;
	gint child_count;
	guint32 update_id;
	gint64 storage_used;
};

struct _RygelMediaContainerClass {
	RygelMediaObjectClass parent_class;
	void (*get_children) (RygelMediaContainer* self, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObjects* (*get_children_finish) (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
	void (*find_object) (RygelMediaContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObject* (*find_object_finish) (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
};

struct _RygelSearchableContainerIface {
	GTypeInterface parent_iface;
	void (*search) (RygelSearchableContainer* self, RygelSearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObjects* (*search_finish) (RygelSearchableContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
	GeeArrayList* (*get_search_classes) (RygelSearchableContainer* self);
	void (*set_search_classes) (RygelSearchableContainer* self, GeeArrayList* value);
};

struct _RygelWritableContainerIface {
	GTypeInterface parent_iface;
	void (*add_item) (RygelWritableContainer* self, RygelMediaItem* item, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*add_item_finish) (RygelWritableContainer* self, GAsyncResult* _res_, GError** error);
	void (*remove_item) (RygelWritableContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*remove_item_finish) (RygelWritableContainer* self, GAsyncResult* _res_, GError** error);
	GeeArrayList* (*get_create_classes) (RygelWritableContainer* self);
	void (*set_create_classes) (RygelWritableContainer* self, GeeArrayList* value);
};

struct _RygelConfigurationIface {
	GTypeInterface parent_iface;
	gboolean (*get_upnp_enabled) (RygelConfiguration* self, GError** error);
	gchar* (*get_interface) (RygelConfiguration* self, GError** error);
	gint (*get_port) (RygelConfiguration* self, GError** error);
	gboolean (*get_transcoding) (RygelConfiguration* self, GError** error);
	gboolean (*get_mp3_transcoder) (RygelConfiguration* self, GError** error);
	gboolean (*get_mp2ts_transcoder) (RygelConfiguration* self, GError** error);
	gboolean (*get_lpcm_transcoder) (RygelConfiguration* self, GError** error);
	gboolean (*get_wmv_transcoder) (RygelConfiguration* self, GError** error);
	gboolean (*get_allow_upload) (RygelConfiguration* self, GError** error);
	gboolean (*get_allow_deletion) (RygelConfiguration* self, GError** error);
	gchar* (*get_log_levels) (RygelConfiguration* self, GError** error);
	gchar* (*get_plugin_path) (RygelConfiguration* self, GError** error);
	gchar* (*get_video_upload_folder) (RygelConfiguration* self, GError** error);
	gchar* (*get_music_upload_folder) (RygelConfiguration* self, GError** error);
	gchar* (*get_picture_upload_folder) (RygelConfiguration* self, GError** error);
	gboolean (*get_enabled) (RygelConfiguration* self, const gchar* section, GError** error);
	gchar* (*get_title) (RygelConfiguration* self, const gchar* section, GError** error);
	gchar* (*get_string) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	GeeArrayList* (*get_string_list) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	gint (*get_int) (RygelConfiguration* self, const gchar* section, const gchar* key, gint min, gint max, GError** error);
	GeeArrayList* (*get_int_list) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	gboolean (*get_bool) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
};


static gpointer rygel_media_container_parent_class = NULL;

GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_transcode_manager_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
GType rygel_media_objects_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_MEDIA_CONTAINER_DUMMY_PROPERTY,
	RYGEL_MEDIA_CONTAINER_OCM_FLAGS
};
#define RYGEL_MEDIA_CONTAINER_UPNP_CLASS "object.container"
#define RYGEL_MEDIA_CONTAINER_STORAGE_FOLDER RYGEL_MEDIA_CONTAINER_UPNP_CLASS ".storageFolder"
#define RYGEL_MEDIA_CONTAINER_MUSIC_ALBUM RYGEL_MEDIA_CONTAINER_UPNP_CLASS ".album.musicAlbum"
#define RYGEL_MEDIA_CONTAINER_MUSIC_ARTIST RYGEL_MEDIA_CONTAINER_UPNP_CLASS ".person.musicArtist"
#define RYGEL_MEDIA_CONTAINER_MUSIC_GENRE RYGEL_MEDIA_CONTAINER_UPNP_CLASS ".genre.musicGenre"
RygelMediaContainer* rygel_media_container_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, gint child_count);
RygelMediaObject* rygel_media_object_construct (GType object_type);
void rygel_media_object_set_title (RygelMediaObject* self, const gchar* value);
static void rygel_media_container_on_container_updated (RygelMediaContainer* self, RygelMediaContainer* container, RygelMediaContainer* updated_container);
static void _rygel_media_container_on_container_updated_rygel_media_container_container_updated (RygelMediaContainer* _sender, RygelMediaContainer* container, gpointer self);
RygelMediaContainer* rygel_media_container_construct_root (GType object_type, const gchar* title, gint child_count);
void rygel_media_container_get_children (RygelMediaContainer* self, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObjects* rygel_media_container_get_children_finish (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
void rygel_media_container_find_object (RygelMediaContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObject* rygel_media_container_find_object_finish (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
void rygel_media_container_updated (RygelMediaContainer* self);
static GUPnPDIDLLiteObject* rygel_media_container_real_serialize (RygelMediaObject* base, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error);
const gchar* rygel_media_object_get_title (RygelMediaObject* self);
gpointer rygel_search_expression_ref (gpointer instance);
void rygel_search_expression_unref (gpointer instance);
GParamSpec* rygel_param_spec_search_expression (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_search_expression (GValue* value, gpointer v_object);
void rygel_value_take_search_expression (GValue* value, gpointer v_object);
gpointer rygel_value_get_search_expression (const GValue* value);
GType rygel_search_expression_get_type (void) G_GNUC_CONST;
GType rygel_searchable_container_get_type (void) G_GNUC_CONST;
void rygel_searchable_container_serialize_search_parameters (RygelSearchableContainer* self, GUPnPDIDLLiteContainer* didl_container);
gboolean rygel_media_object_get_restricted (RygelMediaObject* self);
GUPnPOCMFlags rygel_media_object_get_ocm_flags (RygelMediaObject* self);
GType rygel_media_item_get_type (void) G_GNUC_CONST;
GType rygel_writable_container_get_type (void) G_GNUC_CONST;
GeeArrayList* rygel_writable_container_get_create_classes (RygelWritableContainer* self);
GType rygel_meta_config_get_type (void) G_GNUC_CONST;
RygelMetaConfig* rygel_meta_config_get_default (void);
GType rygel_configuration_get_type (void) G_GNUC_CONST;
gboolean rygel_configuration_get_allow_upload (RygelConfiguration* self, GError** error);
gboolean rygel_configuration_get_allow_deletion (RygelConfiguration* self, GError** error);
static void rygel_media_container_finalize (GObject* obj);
static void _vala_rygel_media_container_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);


static void _rygel_media_container_on_container_updated_rygel_media_container_container_updated (RygelMediaContainer* _sender, RygelMediaContainer* container, gpointer self) {
#line 96 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
	rygel_media_container_on_container_updated (self, _sender, container);
#line 282 "rygel-media-container.c"
}


RygelMediaContainer* rygel_media_container_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, gint child_count) {
	RygelMediaContainer * self = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	RygelMediaContainer* _tmp2_;
	const gchar* _tmp3_;
	gint _tmp4_;
	gchar* _tmp5_;
#line 84 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
	g_return_val_if_fail (id != NULL, NULL);
#line 84 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
	g_return_val_if_fail (title != NULL, NULL);
#line 84 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
	self = (RygelMediaContainer*) rygel_media_object_construct (object_type);
#line 88 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
	_tmp0_ = id;
#line 88 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 88 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
	_g_free0 (((RygelMediaObject*) self)->id);
#line 88 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
	((RygelMediaObject*) self)->id = _tmp1_;
#line 89 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
	_tmp2_ = parent;
#line 89 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
	((RygelMediaObject*) self)->parent = _tmp2_;
#line 90 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
	_tmp3_ = title;
#line 90 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
	rygel_media_object_set_title ((RygelMediaObject*) self, _tmp3_);
#line 91 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
	_tmp4_ = child_count;
#line 91 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
	self->child_count = _tmp4_;
#line 92 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
	self->update_id = (guint32) 0;
#line 93 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
	self->storage_used = (gint64) (-1);
#line 94 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
	_tmp5_ = g_strdup (RYGEL_MEDIA_CONTAINER_STORAGE_FOLDER);
#line 94 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
	_g_free0 (((RygelMediaObject*) self)->upnp_class);
#line 94 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
	((RygelMediaObject*) self)->upnp_class = _tmp5_;
#line 96 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
	g_signal_connect_object (self, "container-updated", (GCallback) _rygel_media_container_on_container_updated_rygel_media_container_container_updated, self, 0);
#line 84 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
	return self;
#line 334 "rygel-media-container.c"
}


RygelMediaContainer* rygel_media_container_construct_root (GType object_type, const gchar* title, gint child_count) {
	RygelMediaContainer * self = NULL;
	const gchar* _tmp0_;
	gint _tmp1_;
#line 99 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
	g_return_val_if_fail (title != NULL, NULL);
#line 101 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
	_tmp0_ = title;
#line 101 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
	_tmp1_ = child_count;
#line 101 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
	self = (RygelMediaContainer*) rygel_media_container_construct (object_type, "0", NULL, _tmp0_, _tmp1_);
#line 99 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
	return self;
#line 352 "rygel-media-container.c"
}


void rygel_media_container_get_children (RygelMediaContainer* self, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
#line 34 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
	RYGEL_MEDIA_CONTAINER_GET_CLASS (self)->get_children (self, offset, max_count, cancellable, _callback_, _user_data_);
#line 359 "rygel-media-container.c"
}


RygelMediaObjects* rygel_media_container_get_children_finish (RygelMediaContainer* self, GAsyncResult* _res_, GError** error) {
#line 34 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
	return RYGEL_MEDIA_CONTAINER_GET_CLASS (self)->get_children_finish (self, _res_, error);
#line 366 "rygel-media-container.c"
}


void rygel_media_container_find_object (RygelMediaContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
#line 34 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
	RYGEL_MEDIA_CONTAINER_GET_CLASS (self)->find_object (self, id, cancellable, _callback_, _user_data_);
#line 373 "rygel-media-container.c"
}


RygelMediaObject* rygel_media_container_find_object_finish (RygelMediaContainer* self, GAsyncResult* _res_, GError** error) {
#line 34 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
	return RYGEL_MEDIA_CONTAINER_GET_CLASS (self)->find_object_finish (self, _res_, error);
#line 380 "rygel-media-container.c"
}


/**
     * Method to be be called each time this container is updated (metadata
     * changes for this container, items under it gets removed/added or their
     * metadata changes etc).
     *
     * @param container the container that just got updated.
     */
void rygel_media_container_updated (RygelMediaContainer* self) {
	guint32 _tmp0_;
#line 139 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
	g_return_if_fail (self != NULL);
#line 140 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
	_tmp0_ = self->update_id;
#line 140 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
	self->update_id = _tmp0_ + 1;
#line 143 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
	g_signal_emit_by_name (self, "container-updated", self);
#line 401 "rygel-media-container.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 172 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
	return self ? g_object_ref (self) : NULL;
#line 408 "rygel-media-container.c"
}


static GUPnPDIDLLiteObject* rygel_media_container_real_serialize (RygelMediaObject* base, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error) {
	RygelMediaContainer * self;
	GUPnPDIDLLiteObject* result = NULL;
	GUPnPDIDLLiteWriter* _tmp0_;
	GUPnPDIDLLiteContainer* _tmp1_ = NULL;
	GUPnPDIDLLiteContainer* didl_container;
	RygelMediaContainer* _tmp2_;
	GUPnPDIDLLiteContainer* _tmp7_;
	const gchar* _tmp8_;
	GUPnPDIDLLiteContainer* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	GUPnPDIDLLiteContainer* _tmp12_;
	gint _tmp13_;
	GUPnPDIDLLiteContainer* _tmp14_;
	const gchar* _tmp15_;
	GUPnPDIDLLiteContainer* _tmp16_;
	GUPnPDIDLLiteContainer* _tmp17_;
	gint64 _tmp18_;
	gboolean _tmp19_ = FALSE;
	RygelMediaContainer* _tmp20_;
	gboolean _tmp21_;
	gboolean _tmp23_;
	gboolean _tmp24_;
#line 146 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
	self = (RygelMediaContainer*) base;
#line 146 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
	g_return_val_if_fail (writer != NULL, NULL);
#line 146 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
	g_return_val_if_fail (http_server != NULL, NULL);
#line 149 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
	_tmp0_ = writer;
#line 149 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
	_tmp1_ = gupnp_didl_lite_writer_add_container (_tmp0_);
#line 149 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
	didl_container = _tmp1_;
#line 150 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
	_tmp2_ = ((RygelMediaObject*) self)->parent;
#line 150 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
	if (_tmp2_ != NULL) {
#line 452 "rygel-media-container.c"
		GUPnPDIDLLiteContainer* _tmp3_;
		RygelMediaContainer* _tmp4_;
		const gchar* _tmp5_;
#line 151 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
		_tmp3_ = didl_container;
#line 151 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
		_tmp4_ = ((RygelMediaObject*) self)->parent;
#line 151 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
		_tmp5_ = ((RygelMediaObject*) _tmp4_)->id;
#line 151 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
		gupnp_didl_lite_object_set_parent_id ((GUPnPDIDLLiteObject*) _tmp3_, _tmp5_);
#line 464 "rygel-media-container.c"
	} else {
		GUPnPDIDLLiteContainer* _tmp6_;
#line 153 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
		_tmp6_ = didl_container;
#line 153 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
		gupnp_didl_lite_object_set_parent_id ((GUPnPDIDLLiteObject*) _tmp6_, "-1");
#line 471 "rygel-media-container.c"
	}
#line 156 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
	_tmp7_ = didl_container;
#line 156 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
	_tmp8_ = ((RygelMediaObject*) self)->id;
#line 156 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
	gupnp_didl_lite_object_set_id ((GUPnPDIDLLiteObject*) _tmp7_, _tmp8_);
#line 157 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
	_tmp9_ = didl_container;
#line 157 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
	_tmp10_ = rygel_media_object_get_title ((RygelMediaObject*) self);
#line 157 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
	_tmp11_ = _tmp10_;
#line 157 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
	gupnp_didl_lite_object_set_title ((GUPnPDIDLLiteObject*) _tmp9_, _tmp11_);
#line 158 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
	_tmp12_ = didl_container;
#line 158 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
	_tmp13_ = self->child_count;
#line 158 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
	gupnp_didl_lite_container_set_child_count (_tmp12_, _tmp13_);
#line 159 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
	_tmp14_ = didl_container;
#line 159 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
	_tmp15_ = ((RygelMediaObject*) self)->upnp_class;
#line 159 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
	gupnp_didl_lite_object_set_upnp_class ((GUPnPDIDLLiteObject*) _tmp14_, _tmp15_);
#line 160 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
	_tmp16_ = didl_container;
#line 160 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
	gupnp_didl_lite_container_set_searchable (_tmp16_, RYGEL_IS_SEARCHABLE_CONTAINER (self));
#line 161 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
	_tmp17_ = didl_container;
#line 161 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
	_tmp18_ = self->storage_used;
#line 161 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
	gupnp_didl_lite_container_set_storage_used (_tmp17_, _tmp18_);
#line 163 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
	_tmp20_ = ((RygelMediaObject*) self)->parent;
#line 163 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
	if (_tmp20_ == NULL) {
#line 163 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
		_tmp19_ = RYGEL_IS_SEARCHABLE_CONTAINER (self);
#line 515 "rygel-media-container.c"
	} else {
#line 163 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
		_tmp19_ = FALSE;
#line 519 "rygel-media-container.c"
	}
#line 163 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
	_tmp21_ = _tmp19_;
#line 163 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
	if (_tmp21_) {
#line 525 "rygel-media-container.c"
		GUPnPDIDLLiteContainer* _tmp22_;
#line 164 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
		_tmp22_ = didl_container;
#line 164 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
		rygel_searchable_container_serialize_search_parameters (RYGEL_IS_SEARCHABLE_CONTAINER (self) ? ((RygelSearchableContainer*) self) : NULL, _tmp22_);
#line 531 "rygel-media-container.c"
	}
#line 168 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
	_tmp23_ = rygel_media_object_get_restricted ((RygelMediaObject*) self);
#line 168 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
	_tmp24_ = _tmp23_;
#line 168 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
	if (!_tmp24_) {
#line 539 "rygel-media-container.c"
		GUPnPDIDLLiteContainer* _tmp25_;
		GUPnPDIDLLiteContainer* _tmp26_;
		GUPnPOCMFlags _tmp27_;
		GUPnPOCMFlags _tmp28_;
		RygelWritableContainer* _tmp29_;
		RygelWritableContainer* writable;
#line 169 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
		_tmp25_ = didl_container;
#line 169 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
		gupnp_didl_lite_object_set_restricted ((GUPnPDIDLLiteObject*) _tmp25_, FALSE);
#line 170 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
		_tmp26_ = didl_container;
#line 170 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
		_tmp27_ = rygel_media_object_get_ocm_flags ((RygelMediaObject*) self);
#line 170 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
		_tmp28_ = _tmp27_;
#line 170 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
		gupnp_didl_lite_object_set_dlna_managed ((GUPnPDIDLLiteObject*) _tmp26_, _tmp28_);
#line 172 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
		_tmp29_ = _g_object_ref0 (RYGEL_IS_WRITABLE_CONTAINER (self) ? ((RygelWritableContainer*) self) : NULL);
#line 172 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
		writable = _tmp29_;
#line 562 "rygel-media-container.c"
		{
			RygelWritableContainer* _tmp30_;
			GeeArrayList* _tmp31_;
			GeeArrayList* _tmp32_;
			GeeArrayList* _tmp33_;
			GeeArrayList* _create_class_list;
			GeeArrayList* _tmp34_;
			gint _tmp35_;
			gint _tmp36_;
			gint _create_class_size;
			gint _create_class_index;
#line 173 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
			_tmp30_ = writable;
#line 173 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
			_tmp31_ = rygel_writable_container_get_create_classes (_tmp30_);
#line 173 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
			_tmp32_ = _tmp31_;
#line 173 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
			_tmp33_ = _g_object_ref0 (_tmp32_);
#line 173 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
			_create_class_list = _tmp33_;
#line 173 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
			_tmp34_ = _create_class_list;
#line 173 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
			_tmp35_ = gee_collection_get_size ((GeeCollection*) _tmp34_);
#line 173 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
			_tmp36_ = _tmp35_;
#line 173 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
			_create_class_size = _tmp36_;
#line 173 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
			_create_class_index = -1;
#line 173 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
			while (TRUE) {
#line 596 "rygel-media-container.c"
				gint _tmp37_;
				gint _tmp38_;
				gint _tmp39_;
				GeeArrayList* _tmp40_;
				gint _tmp41_;
				gpointer _tmp42_ = NULL;
				gchar* create_class;
				GUPnPDIDLLiteContainer* _tmp43_;
				const gchar* _tmp44_;
#line 173 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
				_tmp37_ = _create_class_index;
#line 173 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
				_create_class_index = _tmp37_ + 1;
#line 173 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
				_tmp38_ = _create_class_index;
#line 173 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
				_tmp39_ = _create_class_size;
#line 173 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
				if (!(_tmp38_ < _tmp39_)) {
#line 173 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
					break;
#line 618 "rygel-media-container.c"
				}
#line 173 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
				_tmp40_ = _create_class_list;
#line 173 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
				_tmp41_ = _create_class_index;
#line 173 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
				_tmp42_ = gee_abstract_list_get ((GeeAbstractList*) _tmp40_, _tmp41_);
#line 173 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
				create_class = (gchar*) _tmp42_;
#line 174 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
				_tmp43_ = didl_container;
#line 174 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
				_tmp44_ = create_class;
#line 174 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
				gupnp_didl_lite_container_add_create_class (_tmp43_, _tmp44_);
#line 173 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
				_g_free0 (create_class);
#line 636 "rygel-media-container.c"
			}
#line 173 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
			_g_object_unref0 (_create_class_list);
#line 640 "rygel-media-container.c"
		}
#line 168 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
		_g_object_unref0 (writable);
#line 644 "rygel-media-container.c"
	} else {
		GUPnPDIDLLiteContainer* _tmp45_;
#line 177 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
		_tmp45_ = didl_container;
#line 177 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
		gupnp_didl_lite_object_set_restricted ((GUPnPDIDLLiteObject*) _tmp45_, TRUE);
#line 651 "rygel-media-container.c"
	}
#line 180 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
	result = (GUPnPDIDLLiteObject*) didl_container;
#line 180 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
	return result;
#line 657 "rygel-media-container.c"
}


/**
     * handler for container_updated signal on this container. We only forward
     * it to the parent, hoping someone will get it from the root container
     * and act upon it.
     *
     * @param container the container that emitted the signal
     * @param updated_container the container that just got updated
     */
static void rygel_media_container_on_container_updated (RygelMediaContainer* self, RygelMediaContainer* container, RygelMediaContainer* updated_container) {
	RygelMediaContainer* _tmp0_;
#line 191 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
	g_return_if_fail (self != NULL);
#line 191 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
	g_return_if_fail (container != NULL);
#line 191 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
	g_return_if_fail (updated_container != NULL);
#line 193 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
	_tmp0_ = ((RygelMediaObject*) self)->parent;
#line 193 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
	if (_tmp0_ != NULL) {
#line 681 "rygel-media-container.c"
		RygelMediaContainer* _tmp1_;
		RygelMediaContainer* _tmp2_;
#line 194 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
		_tmp1_ = ((RygelMediaObject*) self)->parent;
#line 194 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
		_tmp2_ = updated_container;
#line 194 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
		g_signal_emit_by_name (_tmp1_, "container-updated", _tmp2_);
#line 690 "rygel-media-container.c"
	}
}


static GUPnPOCMFlags rygel_media_container_real_get_ocm_flags (RygelMediaObject* base) {
	GUPnPOCMFlags result;
	RygelMediaContainer* self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp4_;
	GUPnPOCMFlags flags;
	gboolean allow_upload;
	RygelMetaConfig* _tmp5_ = NULL;
	RygelMetaConfig* config;
	gboolean _tmp9_;
	gboolean allow_deletion;
	gboolean _tmp14_;
	GUPnPOCMFlags _tmp16_;
	GError * _inner_error_ = NULL;
#line 54 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
	self = (RygelMediaContainer*) base;
#line 55 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
	if (!RYGEL_IS_WRITABLE_CONTAINER (self)) {
#line 55 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
		_tmp0_ = TRUE;
#line 715 "rygel-media-container.c"
	} else {
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
#line 55 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
		_tmp1_ = ((RygelMediaObject*) self)->uris;
#line 55 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
		_tmp2_ = gee_collection_get_size ((GeeCollection*) _tmp1_);
#line 55 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
		_tmp3_ = _tmp2_;
#line 55 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
		_tmp0_ = _tmp3_ == 0;
#line 728 "rygel-media-container.c"
	}
#line 55 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
	_tmp4_ = _tmp0_;
#line 55 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
	if (_tmp4_) {
#line 56 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
		result = GUPNP_OCM_FLAGS_NONE;
#line 56 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
		return result;
#line 738 "rygel-media-container.c"
	}
#line 59 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
	flags = GUPNP_OCM_FLAGS_NONE;
#line 61 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
	allow_upload = TRUE;
#line 62 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
	_tmp5_ = rygel_meta_config_get_default ();
#line 62 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
	config = _tmp5_;
#line 748 "rygel-media-container.c"
	{
		RygelMetaConfig* _tmp6_;
		gboolean _tmp7_ = FALSE;
		gboolean _tmp8_;
#line 64 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
		_tmp6_ = config;
#line 64 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
		_tmp7_ = rygel_configuration_get_allow_upload ((RygelConfiguration*) _tmp6_, &_inner_error_);
#line 64 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
		_tmp8_ = _tmp7_;
#line 64 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
		if (_inner_error_ != NULL) {
#line 761 "rygel-media-container.c"
			goto __catch49_g_error;
		}
#line 64 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
		allow_upload = _tmp8_;
#line 766 "rygel-media-container.c"
	}
	goto __finally49;
	__catch49_g_error:
	{
		GError* _error_ = NULL;
#line 63 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
		_error_ = _inner_error_;
#line 63 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
		_inner_error_ = NULL;
#line 63 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
		_g_error_free0 (_error_);
#line 778 "rygel-media-container.c"
	}
	__finally49:
#line 63 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
	if (_inner_error_ != NULL) {
#line 63 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
		_g_object_unref0 (config);
#line 63 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 63 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
		g_clear_error (&_inner_error_);
#line 63 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
		return 0;
#line 791 "rygel-media-container.c"
	}
#line 67 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
	_tmp9_ = allow_upload;
#line 67 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
	if (_tmp9_) {
#line 797 "rygel-media-container.c"
		GUPnPOCMFlags _tmp10_;
#line 68 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
		_tmp10_ = flags;
#line 68 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
		flags = _tmp10_ | (GUPNP_OCM_FLAGS_UPLOAD | GUPNP_OCM_FLAGS_UPLOAD_DESTROYABLE);
#line 803 "rygel-media-container.c"
	}
#line 71 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
	allow_deletion = TRUE;
#line 807 "rygel-media-container.c"
	{
		RygelMetaConfig* _tmp11_;
		gboolean _tmp12_ = FALSE;
		gboolean _tmp13_;
#line 73 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
		_tmp11_ = config;
#line 73 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
		_tmp12_ = rygel_configuration_get_allow_deletion ((RygelConfiguration*) _tmp11_, &_inner_error_);
#line 73 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
		_tmp13_ = _tmp12_;
#line 73 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
		if (_inner_error_ != NULL) {
#line 820 "rygel-media-container.c"
			goto __catch50_g_error;
		}
#line 73 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
		allow_deletion = _tmp13_;
#line 825 "rygel-media-container.c"
	}
	goto __finally50;
	__catch50_g_error:
	{
		GError* _error_ = NULL;
#line 72 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
		_error_ = _inner_error_;
#line 72 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
		_inner_error_ = NULL;
#line 72 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
		_g_error_free0 (_error_);
#line 837 "rygel-media-container.c"
	}
	__finally50:
#line 72 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
	if (_inner_error_ != NULL) {
#line 72 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
		_g_object_unref0 (config);
#line 72 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 72 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
		g_clear_error (&_inner_error_);
#line 72 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
		return 0;
#line 850 "rygel-media-container.c"
	}
#line 76 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
	_tmp14_ = allow_deletion;
#line 76 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
	if (_tmp14_) {
#line 856 "rygel-media-container.c"
		GUPnPOCMFlags _tmp15_;
#line 77 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
		_tmp15_ = flags;
#line 77 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
		flags = _tmp15_ | GUPNP_OCM_FLAGS_DESTROYABLE;
#line 862 "rygel-media-container.c"
	}
#line 80 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
	_tmp16_ = flags;
#line 80 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
	result = _tmp16_;
#line 80 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
	_g_object_unref0 (config);
#line 80 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
	return result;
#line 872 "rygel-media-container.c"
}


static void rygel_media_container_class_init (RygelMediaContainerClass * klass) {
#line 34 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
	rygel_media_container_parent_class = g_type_class_peek_parent (klass);
#line 34 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
	RYGEL_MEDIA_OBJECT_CLASS (klass)->serialize = rygel_media_container_real_serialize;
#line 34 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
	RYGEL_MEDIA_OBJECT_CLASS (klass)->get_ocm_flags = rygel_media_container_real_get_ocm_flags;
#line 34 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_media_container_get_property;
#line 34 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_media_container_finalize;
#line 34 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
	g_object_class_override_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_CONTAINER_OCM_FLAGS, "ocm-flags");
#line 889 "rygel-media-container.c"
	/**
	     * container_updated signal that is emitted if a child container under the
	     * tree of this container gets updated.
	     *
	     * @param container the container that just got updated.
	     */
#line 34 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
	g_signal_new ("container_updated", RYGEL_TYPE_MEDIA_CONTAINER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, RYGEL_TYPE_MEDIA_CONTAINER);
#line 898 "rygel-media-container.c"
}


static void rygel_media_container_instance_init (RygelMediaContainer * self) {
}


static void rygel_media_container_finalize (GObject* obj) {
	RygelMediaContainer * self;
#line 34 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
	self = RYGEL_MEDIA_CONTAINER (obj);
#line 34 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
	G_OBJECT_CLASS (rygel_media_container_parent_class)->finalize (obj);
#line 912 "rygel-media-container.c"
}


/**
 * Represents a container (folder) for media items and containers. Provides
 * basic serialization (to DIDLLiteWriter) implementation. Deriving classes
 * are supposed to provide working implementations of get_children.
 */
GType rygel_media_container_get_type (void) {
	static volatile gsize rygel_media_container_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_container_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaContainerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_container_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaContainer), 0, (GInstanceInitFunc) rygel_media_container_instance_init, NULL };
		GType rygel_media_container_type_id;
		rygel_media_container_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_OBJECT, "RygelMediaContainer", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&rygel_media_container_type_id__volatile, rygel_media_container_type_id);
	}
	return rygel_media_container_type_id__volatile;
}


static void _vala_rygel_media_container_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelMediaContainer * self;
	self = RYGEL_MEDIA_CONTAINER (object);
#line 34 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
	switch (property_id) {
#line 34 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
		case RYGEL_MEDIA_CONTAINER_OCM_FLAGS:
#line 34 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
		g_value_set_flags (value, rygel_media_object_get_ocm_flags ((RygelMediaObject*) self));
#line 34 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
		break;
#line 944 "rygel-media-container.c"
		default:
#line 34 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 34 "/home/jens/Source/rygel/src/rygel/rygel-media-container.vala"
		break;
#line 950 "rygel-media-container.c"
	}
}



