/* rygel-media-device.c generated by valac 0.16.1, the Vala compiler
 * generated from rygel-media-device.vala, do not modify */

/*
 * Copyright (C) 2012 Openismus GmbH.
 *
 * Author: Jens Georg <jensg@openismus.com>
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libgupnp/gupnp.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <libgssdp/gssdp.h>
#include <gobject/gvaluecollector.h>


#define RYGEL_TYPE_DEVICE_CONTEXT (rygel_device_context_get_type ())
#define RYGEL_DEVICE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_DEVICE_CONTEXT, RygelDeviceContext))
#define RYGEL_DEVICE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_DEVICE_CONTEXT, RygelDeviceContextClass))
#define RYGEL_IS_DEVICE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_DEVICE_CONTEXT))
#define RYGEL_IS_DEVICE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_DEVICE_CONTEXT))
#define RYGEL_DEVICE_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_DEVICE_CONTEXT, RygelDeviceContextClass))

typedef struct _RygelDeviceContext RygelDeviceContext;
typedef struct _RygelDeviceContextClass RygelDeviceContextClass;
typedef struct _RygelDeviceContextPrivate RygelDeviceContextPrivate;

#define RYGEL_TYPE_ROOT_DEVICE (rygel_root_device_get_type ())
#define RYGEL_ROOT_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ROOT_DEVICE, RygelRootDevice))
#define RYGEL_ROOT_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ROOT_DEVICE, RygelRootDeviceClass))
#define RYGEL_IS_ROOT_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ROOT_DEVICE))
#define RYGEL_IS_ROOT_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ROOT_DEVICE))
#define RYGEL_ROOT_DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ROOT_DEVICE, RygelRootDeviceClass))

typedef struct _RygelRootDevice RygelRootDevice;
typedef struct _RygelRootDeviceClass RygelRootDeviceClass;

#define RYGEL_TYPE_ROOT_DEVICE_FACTORY (rygel_root_device_factory_get_type ())
#define RYGEL_ROOT_DEVICE_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ROOT_DEVICE_FACTORY, RygelRootDeviceFactory))
#define RYGEL_ROOT_DEVICE_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ROOT_DEVICE_FACTORY, RygelRootDeviceFactoryClass))
#define RYGEL_IS_ROOT_DEVICE_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ROOT_DEVICE_FACTORY))
#define RYGEL_IS_ROOT_DEVICE_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ROOT_DEVICE_FACTORY))
#define RYGEL_ROOT_DEVICE_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ROOT_DEVICE_FACTORY, RygelRootDeviceFactoryClass))

typedef struct _RygelRootDeviceFactory RygelRootDeviceFactory;
typedef struct _RygelRootDeviceFactoryClass RygelRootDeviceFactoryClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _rygel_root_device_factory_unref0(var) ((var == NULL) ? NULL : (var = (rygel_root_device_factory_unref (var), NULL)))

#define RYGEL_TYPE_PLUGIN (rygel_plugin_get_type ())
#define RYGEL_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLUGIN, RygelPlugin))
#define RYGEL_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PLUGIN, RygelPluginClass))
#define RYGEL_IS_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLUGIN))
#define RYGEL_IS_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PLUGIN))
#define RYGEL_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PLUGIN, RygelPluginClass))

typedef struct _RygelPlugin RygelPlugin;
typedef struct _RygelPluginClass RygelPluginClass;
#define _rygel_device_context_unref0(var) ((var == NULL) ? NULL : (var = (rygel_device_context_unref (var), NULL)))
typedef struct _RygelParamSpecDeviceContext RygelParamSpecDeviceContext;

#define RYGEL_TYPE_MEDIA_DEVICE (rygel_media_device_get_type ())
#define RYGEL_MEDIA_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_DEVICE, RygelMediaDevice))
#define RYGEL_MEDIA_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_DEVICE, RygelMediaDeviceClass))
#define RYGEL_IS_MEDIA_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_DEVICE))
#define RYGEL_IS_MEDIA_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_DEVICE))
#define RYGEL_MEDIA_DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_DEVICE, RygelMediaDeviceClass))

typedef struct _RygelMediaDevice RygelMediaDevice;
typedef struct _RygelMediaDeviceClass RygelMediaDeviceClass;
typedef struct _RygelMediaDevicePrivate RygelMediaDevicePrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define __g_list_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_free0_ (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _RygelDeviceContext {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelDeviceContextPrivate * priv;
	RygelRootDevice* device;
	RygelRootDeviceFactory* factory;
	GUPnPContext* context;
};

struct _RygelDeviceContextClass {
	GTypeClass parent_class;
	void (*finalize) (RygelDeviceContext *self);
};

struct _RygelParamSpecDeviceContext {
	GParamSpec parent_instance;
};

struct _RygelMediaDevice {
	GObject parent_instance;
	RygelMediaDevicePrivate * priv;
};

struct _RygelMediaDeviceClass {
	GObjectClass parent_class;
};

struct _RygelMediaDevicePrivate {
	GeeArrayList* interfaces;
	GeeHashMap* contexts;
	GeeHashMap* devices;
	GUPnPContextManager* manager;
	RygelPlugin* _plugin;
};


static gpointer rygel_device_context_parent_class = NULL;
static gpointer rygel_media_device_parent_class = NULL;

gpointer rygel_device_context_ref (gpointer instance);
void rygel_device_context_unref (gpointer instance);
GParamSpec* rygel_param_spec_device_context (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_device_context (GValue* value, gpointer v_object);
void rygel_value_take_device_context (GValue* value, gpointer v_object);
gpointer rygel_value_get_device_context (const GValue* value);
GType rygel_device_context_get_type (void) G_GNUC_CONST;
GType rygel_root_device_get_type (void) G_GNUC_CONST;
gpointer rygel_root_device_factory_ref (gpointer instance);
void rygel_root_device_factory_unref (gpointer instance);
GParamSpec* rygel_param_spec_root_device_factory (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_root_device_factory (GValue* value, gpointer v_object);
void rygel_value_take_root_device_factory (GValue* value, gpointer v_object);
gpointer rygel_value_get_root_device_factory (const GValue* value);
GType rygel_root_device_factory_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_DEVICE_CONTEXT_DUMMY_PROPERTY
};
GType rygel_plugin_get_type (void) G_GNUC_CONST;
RygelDeviceContext* rygel_device_context_new (GUPnPContext* context, RygelPlugin* plugin, GError** error);
RygelDeviceContext* rygel_device_context_construct (GType object_type, GUPnPContext* context, RygelPlugin* plugin, GError** error);
RygelRootDeviceFactory* rygel_root_device_factory_new (GUPnPContext* context, GError** error);
RygelRootDeviceFactory* rygel_root_device_factory_construct (GType object_type, GUPnPContext* context, GError** error);
RygelRootDevice* rygel_root_device_factory_create (RygelRootDeviceFactory* self, RygelPlugin* plugin, GError** error);
static void rygel_device_context_finalize (RygelDeviceContext* obj);
GType rygel_media_device_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIA_DEVICE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_MEDIA_DEVICE, RygelMediaDevicePrivate))
enum  {
	RYGEL_MEDIA_DEVICE_DUMMY_PROPERTY,
	RYGEL_MEDIA_DEVICE_PLUGIN
};
RygelMediaDevice* rygel_media_device_construct (GType object_type);
static void rygel_media_device_on_context_available (RygelMediaDevice* self, GUPnPContext* context);
static void _rygel_media_device_on_context_available_gupnp_context_manager_context_available (GUPnPContextManager* _sender, GUPnPContext* p0, gpointer self);
static void rygel_media_device_on_context_unavailable (RygelMediaDevice* self, GUPnPContext* context);
static void _rygel_media_device_on_context_unavailable_gupnp_context_manager_context_unavailable (GUPnPContextManager* _sender, GUPnPContext* p0, gpointer self);
void rygel_media_device_add_interface (RygelMediaDevice* self, const gchar* iface);
void rygel_media_device_remove_interface (RygelMediaDevice* self, const gchar* iface);
GList* rygel_media_device_get_interfaces (RygelMediaDevice* self);
static void _g_free0_ (gpointer var);
static void _g_list_free__g_free0_ (GList* self);
RygelPlugin* rygel_media_device_get_plugin (RygelMediaDevice* self);
void rygel_media_device_set_plugin (RygelMediaDevice* self, RygelPlugin* value);
static void rygel_media_device_finalize (GObject* obj);
static void _vala_rygel_media_device_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_media_device_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static gpointer _g_object_ref0 (gpointer self) {
#line 30 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	return self ? g_object_ref (self) : NULL;
#line 184 "rygel-media-device.c"
}


RygelDeviceContext* rygel_device_context_construct (GType object_type, GUPnPContext* context, RygelPlugin* plugin, GError** error) {
	RygelDeviceContext* self = NULL;
	GUPnPContext* _tmp0_;
	GUPnPContext* _tmp1_;
	GUPnPContext* _tmp2_;
	RygelRootDeviceFactory* _tmp3_;
	RygelRootDeviceFactory* _tmp4_;
	RygelRootDeviceFactory* _tmp5_;
	RygelPlugin* _tmp6_;
	RygelRootDevice* _tmp7_ = NULL;
	RygelRootDevice* _tmp8_;
	RygelRootDevice* _tmp9_;
	GError * _inner_error_ = NULL;
#line 29 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	g_return_val_if_fail (context != NULL, NULL);
#line 29 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	g_return_val_if_fail (plugin != NULL, NULL);
#line 29 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	self = (RygelDeviceContext*) g_type_create_instance (object_type);
#line 30 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp0_ = context;
#line 30 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 30 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_g_object_unref0 (self->context);
#line 30 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	self->context = _tmp1_;
#line 31 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp2_ = context;
#line 31 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp3_ = rygel_root_device_factory_new (_tmp2_, &_inner_error_);
#line 31 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp4_ = _tmp3_;
#line 31 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	if (_inner_error_ != NULL) {
#line 31 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		g_propagate_error (error, _inner_error_);
#line 31 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_rygel_device_context_unref0 (self);
#line 31 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		return NULL;
#line 229 "rygel-media-device.c"
	}
#line 31 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_rygel_root_device_factory_unref0 (self->factory);
#line 31 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	self->factory = _tmp4_;
#line 32 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp5_ = self->factory;
#line 32 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp6_ = plugin;
#line 32 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp7_ = rygel_root_device_factory_create (_tmp5_, _tmp6_, &_inner_error_);
#line 32 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp8_ = _tmp7_;
#line 32 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	if (_inner_error_ != NULL) {
#line 32 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		g_propagate_error (error, _inner_error_);
#line 32 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_rygel_device_context_unref0 (self);
#line 32 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		return NULL;
#line 251 "rygel-media-device.c"
	}
#line 32 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_g_object_unref0 (self->device);
#line 32 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	self->device = _tmp8_;
#line 33 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp9_ = self->device;
#line 33 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	gupnp_root_device_set_available ((GUPnPRootDevice*) _tmp9_, TRUE);
#line 29 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	return self;
#line 263 "rygel-media-device.c"
}


RygelDeviceContext* rygel_device_context_new (GUPnPContext* context, RygelPlugin* plugin, GError** error) {
#line 29 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	return rygel_device_context_construct (RYGEL_TYPE_DEVICE_CONTEXT, context, plugin, error);
#line 270 "rygel-media-device.c"
}


static void rygel_value_device_context_init (GValue* value) {
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	value->data[0].v_pointer = NULL;
#line 277 "rygel-media-device.c"
}


static void rygel_value_device_context_free_value (GValue* value) {
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	if (value->data[0].v_pointer) {
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		rygel_device_context_unref (value->data[0].v_pointer);
#line 286 "rygel-media-device.c"
	}
}


static void rygel_value_device_context_copy_value (const GValue* src_value, GValue* dest_value) {
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	if (src_value->data[0].v_pointer) {
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		dest_value->data[0].v_pointer = rygel_device_context_ref (src_value->data[0].v_pointer);
#line 296 "rygel-media-device.c"
	} else {
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		dest_value->data[0].v_pointer = NULL;
#line 300 "rygel-media-device.c"
	}
}


static gpointer rygel_value_device_context_peek_pointer (const GValue* value) {
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	return value->data[0].v_pointer;
#line 308 "rygel-media-device.c"
}


static gchar* rygel_value_device_context_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	if (collect_values[0].v_pointer) {
#line 315 "rygel-media-device.c"
		RygelDeviceContext* object;
		object = collect_values[0].v_pointer;
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		if (object->parent_instance.g_class == NULL) {
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 322 "rygel-media-device.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 326 "rygel-media-device.c"
		}
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		value->data[0].v_pointer = rygel_device_context_ref (object);
#line 330 "rygel-media-device.c"
	} else {
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		value->data[0].v_pointer = NULL;
#line 334 "rygel-media-device.c"
	}
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	return NULL;
#line 338 "rygel-media-device.c"
}


static gchar* rygel_value_device_context_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	RygelDeviceContext** object_p;
	object_p = collect_values[0].v_pointer;
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	if (!object_p) {
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 349 "rygel-media-device.c"
	}
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	if (!value->data[0].v_pointer) {
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		*object_p = NULL;
#line 355 "rygel-media-device.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		*object_p = value->data[0].v_pointer;
#line 359 "rygel-media-device.c"
	} else {
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		*object_p = rygel_device_context_ref (value->data[0].v_pointer);
#line 363 "rygel-media-device.c"
	}
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	return NULL;
#line 367 "rygel-media-device.c"
}


GParamSpec* rygel_param_spec_device_context (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	RygelParamSpecDeviceContext* spec;
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	g_return_val_if_fail (g_type_is_a (object_type, RYGEL_TYPE_DEVICE_CONTEXT), NULL);
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	return G_PARAM_SPEC (spec);
#line 381 "rygel-media-device.c"
}


gpointer rygel_value_get_device_context (const GValue* value) {
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_DEVICE_CONTEXT), NULL);
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	return value->data[0].v_pointer;
#line 390 "rygel-media-device.c"
}


void rygel_value_set_device_context (GValue* value, gpointer v_object) {
	RygelDeviceContext* old;
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_DEVICE_CONTEXT));
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	old = value->data[0].v_pointer;
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	if (v_object) {
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_DEVICE_CONTEXT));
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		value->data[0].v_pointer = v_object;
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		rygel_device_context_ref (value->data[0].v_pointer);
#line 410 "rygel-media-device.c"
	} else {
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		value->data[0].v_pointer = NULL;
#line 414 "rygel-media-device.c"
	}
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	if (old) {
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		rygel_device_context_unref (old);
#line 420 "rygel-media-device.c"
	}
}


void rygel_value_take_device_context (GValue* value, gpointer v_object) {
	RygelDeviceContext* old;
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_DEVICE_CONTEXT));
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	old = value->data[0].v_pointer;
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	if (v_object) {
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_DEVICE_CONTEXT));
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		value->data[0].v_pointer = v_object;
#line 439 "rygel-media-device.c"
	} else {
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		value->data[0].v_pointer = NULL;
#line 443 "rygel-media-device.c"
	}
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	if (old) {
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		rygel_device_context_unref (old);
#line 449 "rygel-media-device.c"
	}
}


static void rygel_device_context_class_init (RygelDeviceContextClass * klass) {
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	rygel_device_context_parent_class = g_type_class_peek_parent (klass);
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	RYGEL_DEVICE_CONTEXT_CLASS (klass)->finalize = rygel_device_context_finalize;
#line 459 "rygel-media-device.c"
}


static void rygel_device_context_instance_init (RygelDeviceContext * self) {
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	self->ref_count = 1;
#line 466 "rygel-media-device.c"
}


static void rygel_device_context_finalize (RygelDeviceContext* obj) {
	RygelDeviceContext * self;
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	self = RYGEL_DEVICE_CONTEXT (obj);
#line 25 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_g_object_unref0 (self->device);
#line 26 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_rygel_root_device_factory_unref0 (self->factory);
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_g_object_unref0 (self->context);
#line 480 "rygel-media-device.c"
}


GType rygel_device_context_get_type (void) {
	static volatile gsize rygel_device_context_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_device_context_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { rygel_value_device_context_init, rygel_value_device_context_free_value, rygel_value_device_context_copy_value, rygel_value_device_context_peek_pointer, "p", rygel_value_device_context_collect_value, "p", rygel_value_device_context_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (RygelDeviceContextClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_device_context_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelDeviceContext), 0, (GInstanceInitFunc) rygel_device_context_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType rygel_device_context_type_id;
		rygel_device_context_type_id = g_type_register_fundamental (g_type_fundamental_next (), "RygelDeviceContext", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&rygel_device_context_type_id__volatile, rygel_device_context_type_id);
	}
	return rygel_device_context_type_id__volatile;
}


gpointer rygel_device_context_ref (gpointer instance) {
	RygelDeviceContext* self;
	self = instance;
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	g_atomic_int_inc (&self->ref_count);
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	return instance;
#line 505 "rygel-media-device.c"
}


void rygel_device_context_unref (gpointer instance) {
	RygelDeviceContext* self;
	self = instance;
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		RYGEL_DEVICE_CONTEXT_GET_CLASS (self)->finalize (self);
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 518 "rygel-media-device.c"
	}
}


static void _rygel_media_device_on_context_available_gupnp_context_manager_context_available (GUPnPContextManager* _sender, GUPnPContext* p0, gpointer self) {
#line 47 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	rygel_media_device_on_context_available (self, p0);
#line 526 "rygel-media-device.c"
}


static void _rygel_media_device_on_context_unavailable_gupnp_context_manager_context_unavailable (GUPnPContextManager* _sender, GUPnPContext* p0, gpointer self) {
#line 48 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	rygel_media_device_on_context_unavailable (self, p0);
#line 533 "rygel-media-device.c"
}


RygelMediaDevice* rygel_media_device_construct (GType object_type) {
	RygelMediaDevice * self = NULL;
	GUPnPContextManager* _tmp0_ = NULL;
	GUPnPContextManager* _tmp1_;
	GUPnPContextManager* _tmp2_;
	GeeArrayList* _tmp3_;
	GeeHashMap* _tmp4_;
	GeeHashMap* _tmp5_;
#line 45 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	self = (RygelMediaDevice*) g_object_new (object_type, NULL);
#line 46 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp0_ = gupnp_context_manager_create ((guint) 0);
#line 46 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_g_object_unref0 (self->priv->manager);
#line 46 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	self->priv->manager = _tmp0_;
#line 47 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp1_ = self->priv->manager;
#line 47 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	g_signal_connect_object (_tmp1_, "context-available", (GCallback) _rygel_media_device_on_context_available_gupnp_context_manager_context_available, self, 0);
#line 48 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp2_ = self->priv->manager;
#line 48 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	g_signal_connect_object (_tmp2_, "context-unavailable", (GCallback) _rygel_media_device_on_context_unavailable_gupnp_context_manager_context_unavailable, self, 0);
#line 49 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp3_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
#line 49 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_g_object_unref0 (self->priv->interfaces);
#line 49 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	self->priv->interfaces = _tmp3_;
#line 50 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp4_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, GUPNP_TYPE_CONTEXT, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
#line 50 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_g_object_unref0 (self->priv->contexts);
#line 50 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	self->priv->contexts = _tmp4_;
#line 51 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp5_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, RYGEL_TYPE_DEVICE_CONTEXT, (GBoxedCopyFunc) rygel_device_context_ref, rygel_device_context_unref, NULL, NULL, NULL);
#line 51 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_g_object_unref0 (self->priv->devices);
#line 51 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	self->priv->devices = _tmp5_;
#line 45 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	return self;
#line 581 "rygel-media-device.c"
}


/**
     * Add a network interface the device should listen on.
     *
     * If the network interface is not already up, it will be used as soon as
     * it's ready, otherwise it's used right away.
     *
     * @param iface Name of the network interface, e.g. eth0
     */
void rygel_media_device_add_interface (RygelMediaDevice* self, const gchar* iface) {
	GeeArrayList* _tmp0_;
	const gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
#line 62 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	g_return_if_fail (self != NULL);
#line 62 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	g_return_if_fail (iface != NULL);
#line 63 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp0_ = self->priv->interfaces;
#line 63 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp1_ = iface;
#line 63 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp2_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp0_, _tmp1_);
#line 63 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	if (!_tmp2_) {
#line 609 "rygel-media-device.c"
		GeeArrayList* _tmp3_;
		const gchar* _tmp4_;
		GeeHashMap* _tmp5_;
		GeeSet* _tmp6_;
		GeeSet* _tmp7_;
		GeeSet* _tmp8_;
		const gchar* _tmp9_;
		gboolean _tmp10_ = FALSE;
		gboolean _tmp11_;
#line 64 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_tmp3_ = self->priv->interfaces;
#line 64 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_tmp4_ = iface;
#line 64 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp3_, _tmp4_);
#line 68 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_tmp5_ = self->priv->contexts;
#line 68 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_tmp6_ = gee_abstract_map_get_keys ((GeeMap*) _tmp5_);
#line 68 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_tmp7_ = _tmp6_;
#line 68 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_tmp8_ = _tmp7_;
#line 68 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_tmp9_ = iface;
#line 68 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_tmp10_ = gee_collection_contains ((GeeCollection*) _tmp8_, _tmp9_);
#line 68 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_tmp11_ = _tmp10_;
#line 68 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_g_object_unref0 (_tmp8_);
#line 68 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		if (_tmp11_) {
#line 643 "rygel-media-device.c"
			GeeHashMap* _tmp12_;
			const gchar* _tmp13_;
			gpointer _tmp14_ = NULL;
			GUPnPContext* _tmp15_;
#line 69 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			_tmp12_ = self->priv->contexts;
#line 69 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			_tmp13_ = iface;
#line 69 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			_tmp14_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp12_, _tmp13_);
#line 69 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			_tmp15_ = (GUPnPContext*) _tmp14_;
#line 69 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			rygel_media_device_on_context_available (self, _tmp15_);
#line 69 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			_g_object_unref0 (_tmp15_);
#line 660 "rygel-media-device.c"
		}
	}
}


/**
     * Remove a previously added network interface from the device.
     *
     * @param iface Name of the network interface, e.g. eth0
     */
void rygel_media_device_remove_interface (RygelMediaDevice* self, const gchar* iface) {
	GeeArrayList* _tmp0_;
	const gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	GeeArrayList* _tmp3_;
	const gchar* _tmp4_;
	GeeHashMap* _tmp5_;
	GeeSet* _tmp6_;
	GeeSet* _tmp7_;
	GeeSet* _tmp8_;
	const gchar* _tmp9_;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_;
#line 79 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	g_return_if_fail (self != NULL);
#line 79 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	g_return_if_fail (iface != NULL);
#line 80 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp0_ = self->priv->interfaces;
#line 80 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp1_ = iface;
#line 80 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp2_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp0_, _tmp1_);
#line 80 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	if (!_tmp2_) {
#line 81 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		return;
#line 698 "rygel-media-device.c"
	}
#line 84 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp3_ = self->priv->interfaces;
#line 84 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp4_ = iface;
#line 84 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp3_, _tmp4_);
#line 86 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp5_ = self->priv->devices;
#line 86 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp6_ = gee_abstract_map_get_keys ((GeeMap*) _tmp5_);
#line 86 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp7_ = _tmp6_;
#line 86 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp8_ = _tmp7_;
#line 86 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp9_ = iface;
#line 86 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp10_ = gee_collection_contains ((GeeCollection*) _tmp8_, _tmp9_);
#line 86 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp11_ = _tmp10_;
#line 86 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_g_object_unref0 (_tmp8_);
#line 86 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	if (_tmp11_) {
#line 724 "rygel-media-device.c"
		GeeHashMap* _tmp12_;
		const gchar* _tmp13_;
		GeeHashMap* _tmp14_;
		const gchar* _tmp15_;
		gpointer _tmp16_ = NULL;
		RygelDeviceContext* _tmp17_;
		GUPnPContext* _tmp18_;
		GeeHashMap* _tmp19_;
		const gchar* _tmp20_;
#line 87 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_tmp12_ = self->priv->contexts;
#line 87 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_tmp13_ = iface;
#line 87 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_tmp14_ = self->priv->devices;
#line 87 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_tmp15_ = iface;
#line 87 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_tmp16_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp14_, _tmp15_);
#line 87 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_tmp17_ = (RygelDeviceContext*) _tmp16_;
#line 87 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_tmp18_ = _tmp17_->context;
#line 87 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		gee_abstract_map_set ((GeeAbstractMap*) _tmp12_, _tmp13_, _tmp18_);
#line 87 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_rygel_device_context_unref0 (_tmp17_);
#line 88 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_tmp19_ = self->priv->devices;
#line 88 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_tmp20_ = iface;
#line 88 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		gee_abstract_map_unset ((GeeAbstractMap*) _tmp19_, _tmp20_, NULL);
#line 758 "rygel-media-device.c"
	}
}


/**
     * Get a list of the network interfaces the device is currently allowed
     * to use.
     *
     * @return list of interface names.
     */
static void _g_free0_ (gpointer var) {
#line 98 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	var = (g_free (var), NULL);
#line 772 "rygel-media-device.c"
}


static void _g_list_free__g_free0_ (GList* self) {
#line 98 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	g_list_foreach (self, (GFunc) _g_free0_, NULL);
#line 98 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	g_list_free (self);
#line 781 "rygel-media-device.c"
}


GList* rygel_media_device_get_interfaces (RygelMediaDevice* self) {
	GList* result = NULL;
	GList* _result_;
#line 98 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 99 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_result_ = NULL;
#line 792 "rygel-media-device.c"
	{
		GeeArrayList* _tmp0_;
		GeeArrayList* _tmp1_;
		GeeArrayList* _iface_list;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _iface_size;
		gint _iface_index;
#line 101 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_tmp0_ = self->priv->interfaces;
#line 101 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_tmp1_ = _g_object_ref0 (_tmp0_);
#line 101 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_iface_list = _tmp1_;
#line 101 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_tmp2_ = _iface_list;
#line 101 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_tmp3_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp2_);
#line 101 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_tmp4_ = _tmp3_;
#line 101 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_iface_size = _tmp4_;
#line 101 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_iface_index = -1;
#line 101 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		while (TRUE) {
#line 820 "rygel-media-device.c"
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			GeeArrayList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_ = NULL;
			gchar* iface;
			const gchar* _tmp11_;
			gchar* _tmp12_;
#line 101 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			_tmp5_ = _iface_index;
#line 101 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			_iface_index = _tmp5_ + 1;
#line 101 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			_tmp6_ = _iface_index;
#line 101 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			_tmp7_ = _iface_size;
#line 101 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			if (!(_tmp6_ < _tmp7_)) {
#line 101 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
				break;
#line 842 "rygel-media-device.c"
			}
#line 101 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			_tmp8_ = _iface_list;
#line 101 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			_tmp9_ = _iface_index;
#line 101 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
#line 101 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			iface = (gchar*) _tmp10_;
#line 102 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			_tmp11_ = iface;
#line 102 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			_tmp12_ = g_strdup (_tmp11_);
#line 102 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			_result_ = g_list_prepend (_result_, _tmp12_);
#line 101 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			_g_free0 (iface);
#line 860 "rygel-media-device.c"
		}
#line 101 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_g_object_unref0 (_iface_list);
#line 864 "rygel-media-device.c"
	}
#line 105 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_result_ = g_list_reverse (_result_);
#line 107 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	result = _result_;
#line 107 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	return result;
#line 872 "rygel-media-device.c"
}


static void rygel_media_device_on_context_available (RygelMediaDevice* self, GUPnPContext* context) {
	GeeArrayList* _tmp0_;
	GUPnPContext* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gboolean _tmp4_ = FALSE;
	GError * _inner_error_ = NULL;
#line 110 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	g_return_if_fail (self != NULL);
#line 110 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	g_return_if_fail (context != NULL);
#line 111 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp0_ = self->priv->interfaces;
#line 111 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp1_ = context;
#line 111 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp2_ = gssdp_client_get_interface ((GSSDPClient*) _tmp1_);
#line 111 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp3_ = _tmp2_;
#line 111 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp4_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp0_, _tmp3_);
#line 111 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	if (_tmp4_) {
#line 899 "rygel-media-device.c"
		{
			GUPnPContext* _tmp5_;
			RygelPlugin* _tmp6_;
			RygelDeviceContext* _tmp7_;
			RygelDeviceContext* ctx;
			GeeHashMap* _tmp8_;
			GUPnPContext* _tmp9_;
			const gchar* _tmp10_;
			const gchar* _tmp11_;
			RygelDeviceContext* _tmp12_;
#line 113 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			_tmp5_ = context;
#line 113 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			_tmp6_ = self->priv->_plugin;
#line 113 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			_tmp7_ = rygel_device_context_new (_tmp5_, _tmp6_, &_inner_error_);
#line 113 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			ctx = _tmp7_;
#line 113 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			if (_inner_error_ != NULL) {
#line 920 "rygel-media-device.c"
				goto __catch44_g_error;
			}
#line 114 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			_tmp8_ = self->priv->devices;
#line 114 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			_tmp9_ = context;
#line 114 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			_tmp10_ = gssdp_client_get_interface ((GSSDPClient*) _tmp9_);
#line 114 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			_tmp11_ = _tmp10_;
#line 114 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			_tmp12_ = ctx;
#line 114 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			gee_abstract_map_set ((GeeAbstractMap*) _tmp8_, _tmp11_, _tmp12_);
#line 112 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			_rygel_device_context_unref0 (ctx);
#line 937 "rygel-media-device.c"
		}
		goto __finally44;
		__catch44_g_error:
		{
			GError* _error_ = NULL;
			GError* _tmp13_;
			const gchar* _tmp14_;
#line 112 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			_error_ = _inner_error_;
#line 112 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			_inner_error_ = NULL;
#line 116 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			_tmp13_ = _error_;
#line 116 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			_tmp14_ = _tmp13_->message;
#line 116 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			g_warning ("rygel-media-device.vala:116: Failed to create device context: %s", _tmp14_);
#line 112 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			_g_error_free0 (_error_);
#line 957 "rygel-media-device.c"
		}
		__finally44:
#line 112 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		if (_inner_error_ != NULL) {
#line 112 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 112 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			g_clear_error (&_inner_error_);
#line 112 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			return;
#line 968 "rygel-media-device.c"
		}
	} else {
		GeeHashMap* _tmp15_;
		GUPnPContext* _tmp16_;
		const gchar* _tmp17_;
		const gchar* _tmp18_;
		GUPnPContext* _tmp19_;
#line 120 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_tmp15_ = self->priv->contexts;
#line 120 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_tmp16_ = context;
#line 120 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_tmp17_ = gssdp_client_get_interface ((GSSDPClient*) _tmp16_);
#line 120 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_tmp18_ = _tmp17_;
#line 120 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_tmp19_ = context;
#line 120 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		gee_abstract_map_set ((GeeAbstractMap*) _tmp15_, _tmp18_, _tmp19_);
#line 988 "rygel-media-device.c"
	}
}


static void rygel_media_device_on_context_unavailable (RygelMediaDevice* self, GUPnPContext* context) {
	GeeHashMap* _tmp0_;
	GeeSet* _tmp1_;
	GeeSet* _tmp2_;
	GeeSet* _tmp3_;
	GUPnPContext* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_;
#line 124 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	g_return_if_fail (self != NULL);
#line 124 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	g_return_if_fail (context != NULL);
#line 125 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp0_ = self->priv->devices;
#line 125 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp1_ = gee_abstract_map_get_keys ((GeeMap*) _tmp0_);
#line 125 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp2_ = _tmp1_;
#line 125 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp3_ = _tmp2_;
#line 125 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp4_ = context;
#line 125 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp5_ = gssdp_client_get_interface ((GSSDPClient*) _tmp4_);
#line 125 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp6_ = _tmp5_;
#line 125 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp7_ = gee_collection_contains ((GeeCollection*) _tmp3_, _tmp6_);
#line 125 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp8_ = _tmp7_;
#line 125 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_g_object_unref0 (_tmp3_);
#line 125 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	if (_tmp8_) {
#line 1029 "rygel-media-device.c"
		GeeHashMap* _tmp9_;
		GUPnPContext* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
#line 126 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_tmp9_ = self->priv->devices;
#line 126 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_tmp10_ = context;
#line 126 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_tmp11_ = gssdp_client_get_interface ((GSSDPClient*) _tmp10_);
#line 126 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_tmp12_ = _tmp11_;
#line 126 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		gee_abstract_map_unset ((GeeAbstractMap*) _tmp9_, _tmp12_, NULL);
#line 1044 "rygel-media-device.c"
	} else {
		GeeHashMap* _tmp13_;
		GUPnPContext* _tmp14_;
		const gchar* _tmp15_;
		const gchar* _tmp16_;
#line 128 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_tmp13_ = self->priv->contexts;
#line 128 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_tmp14_ = context;
#line 128 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_tmp15_ = gssdp_client_get_interface ((GSSDPClient*) _tmp14_);
#line 128 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_tmp16_ = _tmp15_;
#line 128 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		gee_abstract_map_unset ((GeeAbstractMap*) _tmp13_, _tmp16_, NULL);
#line 1060 "rygel-media-device.c"
	}
}


RygelPlugin* rygel_media_device_get_plugin (RygelMediaDevice* self) {
	RygelPlugin* result;
	RygelPlugin* _tmp0_;
#line 43 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 43 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp0_ = self->priv->_plugin;
#line 43 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	result = _tmp0_;
#line 43 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	return result;
#line 1076 "rygel-media-device.c"
}


void rygel_media_device_set_plugin (RygelMediaDevice* self, RygelPlugin* value) {
	RygelPlugin* _tmp0_;
	RygelPlugin* _tmp1_;
#line 43 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	g_return_if_fail (self != NULL);
#line 43 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp0_ = value;
#line 43 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 43 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_g_object_unref0 (self->priv->_plugin);
#line 43 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	self->priv->_plugin = _tmp1_;
#line 43 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	g_object_notify ((GObject *) self, "plugin");
#line 1095 "rygel-media-device.c"
}


static void rygel_media_device_class_init (RygelMediaDeviceClass * klass) {
#line 37 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	rygel_media_device_parent_class = g_type_class_peek_parent (klass);
#line 37 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	g_type_class_add_private (klass, sizeof (RygelMediaDevicePrivate));
#line 37 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_media_device_get_property;
#line 37 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_media_device_set_property;
#line 37 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_media_device_finalize;
#line 37 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_DEVICE_PLUGIN, g_param_spec_object ("plugin", "plugin", "plugin", RYGEL_TYPE_PLUGIN, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 1112 "rygel-media-device.c"
}


static void rygel_media_device_instance_init (RygelMediaDevice * self) {
#line 37 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	self->priv = RYGEL_MEDIA_DEVICE_GET_PRIVATE (self);
#line 1119 "rygel-media-device.c"
}


static void rygel_media_device_finalize (GObject* obj) {
	RygelMediaDevice * self;
#line 37 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	self = RYGEL_MEDIA_DEVICE (obj);
#line 38 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_g_object_unref0 (self->priv->interfaces);
#line 39 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_g_object_unref0 (self->priv->contexts);
#line 40 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_g_object_unref0 (self->priv->devices);
#line 41 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_g_object_unref0 (self->priv->manager);
#line 43 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_g_object_unref0 (self->priv->_plugin);
#line 37 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	G_OBJECT_CLASS (rygel_media_device_parent_class)->finalize (obj);
#line 1139 "rygel-media-device.c"
}


GType rygel_media_device_get_type (void) {
	static volatile gsize rygel_media_device_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_device_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaDeviceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_device_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaDevice), 0, (GInstanceInitFunc) rygel_media_device_instance_init, NULL };
		GType rygel_media_device_type_id;
		rygel_media_device_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMediaDevice", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&rygel_media_device_type_id__volatile, rygel_media_device_type_id);
	}
	return rygel_media_device_type_id__volatile;
}


static void _vala_rygel_media_device_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelMediaDevice * self;
	self = RYGEL_MEDIA_DEVICE (object);
#line 37 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	switch (property_id) {
#line 37 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		case RYGEL_MEDIA_DEVICE_PLUGIN:
#line 37 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		g_value_set_object (value, rygel_media_device_get_plugin (self));
#line 37 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		break;
#line 1166 "rygel-media-device.c"
		default:
#line 37 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 37 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		break;
#line 1172 "rygel-media-device.c"
	}
}


static void _vala_rygel_media_device_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelMediaDevice * self;
	self = RYGEL_MEDIA_DEVICE (object);
#line 37 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	switch (property_id) {
#line 37 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		case RYGEL_MEDIA_DEVICE_PLUGIN:
#line 37 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		rygel_media_device_set_plugin (self, g_value_get_object (value));
#line 37 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		break;
#line 1188 "rygel-media-device.c"
		default:
#line 37 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 37 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		break;
#line 1194 "rygel-media-device.c"
	}
}



