/* rygel-plugin-loader.c generated by valac 0.16.1, the Vala compiler
 * generated from rygel-plugin-loader.vala, do not modify */

/*
 * Copyright (C) 2008 Nokia Corporation.
 * Copyright (C) 2008 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp/gupnp.h>
#include <gmodule.h>
#include <config.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>


#define RYGEL_TYPE_PLUGIN_LOADER (rygel_plugin_loader_get_type ())
#define RYGEL_PLUGIN_LOADER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLUGIN_LOADER, RygelPluginLoader))
#define RYGEL_PLUGIN_LOADER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PLUGIN_LOADER, RygelPluginLoaderClass))
#define RYGEL_IS_PLUGIN_LOADER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLUGIN_LOADER))
#define RYGEL_IS_PLUGIN_LOADER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PLUGIN_LOADER))
#define RYGEL_PLUGIN_LOADER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PLUGIN_LOADER, RygelPluginLoaderClass))

typedef struct _RygelPluginLoader RygelPluginLoader;
typedef struct _RygelPluginLoaderClass RygelPluginLoaderClass;
typedef struct _RygelPluginLoaderPrivate RygelPluginLoaderPrivate;

#define RYGEL_TYPE_PLUGIN (rygel_plugin_get_type ())
#define RYGEL_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLUGIN, RygelPlugin))
#define RYGEL_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PLUGIN, RygelPluginClass))
#define RYGEL_IS_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLUGIN))
#define RYGEL_IS_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PLUGIN))
#define RYGEL_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PLUGIN, RygelPluginClass))

typedef struct _RygelPlugin RygelPlugin;
typedef struct _RygelPluginClass RygelPluginClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_META_CONFIG (rygel_meta_config_get_type ())
#define RYGEL_META_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_META_CONFIG, RygelMetaConfig))
#define RYGEL_META_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_META_CONFIG, RygelMetaConfigClass))
#define RYGEL_IS_META_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_META_CONFIG))
#define RYGEL_IS_META_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_META_CONFIG))
#define RYGEL_META_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_META_CONFIG, RygelMetaConfigClass))

typedef struct _RygelMetaConfig RygelMetaConfig;
typedef struct _RygelMetaConfigClass RygelMetaConfigClass;

#define RYGEL_TYPE_CONFIGURATION (rygel_configuration_get_type ())
#define RYGEL_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CONFIGURATION, RygelConfiguration))
#define RYGEL_IS_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CONFIGURATION))
#define RYGEL_CONFIGURATION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_CONFIGURATION, RygelConfigurationIface))

typedef struct _RygelConfiguration RygelConfiguration;
typedef struct _RygelConfigurationIface RygelConfigurationIface;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelPluginPrivate RygelPluginPrivate;

#define RYGEL_TYPE_ROOT_DEVICE (rygel_root_device_get_type ())
#define RYGEL_ROOT_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ROOT_DEVICE, RygelRootDevice))
#define RYGEL_ROOT_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ROOT_DEVICE, RygelRootDeviceClass))
#define RYGEL_IS_ROOT_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ROOT_DEVICE))
#define RYGEL_IS_ROOT_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ROOT_DEVICE))
#define RYGEL_ROOT_DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ROOT_DEVICE, RygelRootDeviceClass))

typedef struct _RygelRootDevice RygelRootDevice;
typedef struct _RygelRootDeviceClass RygelRootDeviceClass;

#define RYGEL_TYPE_RESOURCE_INFO (rygel_resource_info_get_type ())
#define RYGEL_RESOURCE_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_RESOURCE_INFO, RygelResourceInfo))
#define RYGEL_RESOURCE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_RESOURCE_INFO, RygelResourceInfoClass))
#define RYGEL_IS_RESOURCE_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_RESOURCE_INFO))
#define RYGEL_IS_RESOURCE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_RESOURCE_INFO))
#define RYGEL_RESOURCE_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_RESOURCE_INFO, RygelResourceInfoClass))

typedef struct _RygelResourceInfo RygelResourceInfo;
typedef struct _RygelResourceInfoClass RygelResourceInfoClass;

#define RYGEL_TYPE_ICON_INFO (rygel_icon_info_get_type ())
#define RYGEL_ICON_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ICON_INFO, RygelIconInfo))
#define RYGEL_ICON_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ICON_INFO, RygelIconInfoClass))
#define RYGEL_IS_ICON_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ICON_INFO))
#define RYGEL_IS_ICON_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ICON_INFO))
#define RYGEL_ICON_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ICON_INFO, RygelIconInfoClass))

typedef struct _RygelIconInfo RygelIconInfo;
typedef struct _RygelIconInfoClass RygelIconInfoClass;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
typedef struct _RygelPluginLoaderLoadModulesFromDirData RygelPluginLoaderLoadModulesFromDirData;
#define _g_module_close0(var) ((var == NULL) ? NULL : (var = (g_module_close (var), NULL)))

struct _RygelPluginLoader {
	GObject parent_instance;
	RygelPluginLoaderPrivate * priv;
};

struct _RygelPluginLoaderClass {
	GObjectClass parent_class;
};

struct _RygelPluginLoaderPrivate {
	GeeHashMap* plugin_hash;
	GeeHashSet* loaded_modules;
};

struct _RygelConfigurationIface {
	GTypeInterface parent_iface;
	gboolean (*get_upnp_enabled) (RygelConfiguration* self, GError** error);
	gchar* (*get_interface) (RygelConfiguration* self, GError** error);
	gint (*get_port) (RygelConfiguration* self, GError** error);
	gboolean (*get_transcoding) (RygelConfiguration* self, GError** error);
	gboolean (*get_mp3_transcoder) (RygelConfiguration* self, GError** error);
	gboolean (*get_mp2ts_transcoder) (RygelConfiguration* self, GError** error);
	gboolean (*get_lpcm_transcoder) (RygelConfiguration* self, GError** error);
	gboolean (*get_wmv_transcoder) (RygelConfiguration* self, GError** error);
	gboolean (*get_aac_transcoder) (RygelConfiguration* self, GError** error);
	gboolean (*get_avc_transcoder) (RygelConfiguration* self, GError** error);
	gboolean (*get_allow_upload) (RygelConfiguration* self, GError** error);
	gboolean (*get_allow_deletion) (RygelConfiguration* self, GError** error);
	gchar* (*get_log_levels) (RygelConfiguration* self, GError** error);
	gchar* (*get_plugin_path) (RygelConfiguration* self, GError** error);
	gchar* (*get_video_upload_folder) (RygelConfiguration* self, GError** error);
	gchar* (*get_music_upload_folder) (RygelConfiguration* self, GError** error);
	gchar* (*get_picture_upload_folder) (RygelConfiguration* self, GError** error);
	gboolean (*get_enabled) (RygelConfiguration* self, const gchar* section, GError** error);
	gchar* (*get_title) (RygelConfiguration* self, const gchar* section, GError** error);
	gchar* (*get_string) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	GeeArrayList* (*get_string_list) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	gint (*get_int) (RygelConfiguration* self, const gchar* section, const gchar* key, gint min, gint max, GError** error);
	GeeArrayList* (*get_int_list) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	gboolean (*get_bool) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
};

struct _RygelPlugin {
	GUPnPResourceFactory parent_instance;
	RygelPluginPrivate * priv;
	gchar* name;
	gchar* title;
	gchar* description;
	gchar* desc_path;
	GeeArrayList* resource_infos;
	GeeArrayList* icon_infos;
	GeeArrayList* default_icons;
};

struct _RygelPluginClass {
	GUPnPResourceFactoryClass parent_class;
	void (*apply_hacks) (RygelPlugin* self, RygelRootDevice* device, const gchar* description_path, GError** error);
};

struct _RygelPluginLoaderLoadModulesFromDirData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelPluginLoader* self;
	GFile* dir;
	GFile* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* attributes;
	GList* infos;
	GFileEnumerator* enumerator;
	GFile* _tmp4_;
	const gchar* _tmp5_;
	GFileEnumerator* _tmp6_;
	GFileEnumerator* _tmp7_;
	GFileEnumerator* _tmp8_;
	gint _tmp9_;
	GList* _tmp10_;
	GList* _tmp11_;
	GError* _error_;
	const gchar* _tmp12_;
	GFile* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	GError* _tmp16_;
	const gchar* _tmp17_;
	GList* _tmp18_;
	GList* info_collection;
	GList* info_it;
	GFileInfo* _tmp19_;
	GFileInfo* info;
	GFile* _tmp20_;
	GFileInfo* _tmp21_;
	const gchar* _tmp22_;
	GFile* _tmp23_;
	GFile* file;
	GFileInfo* _tmp24_;
	GFileType _tmp25_;
	GFileType file_type;
	GFileInfo* _tmp26_;
	const gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* content_type;
	const gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* mime;
	gboolean _tmp31_;
	GFileType _tmp32_;
	gboolean _tmp33_;
	GFileInfo* _tmp34_;
	const gchar* _tmp35_;
	GFileInfo* _tmp36_;
	gboolean _tmp37_;
	gboolean _tmp38_;
	gboolean _tmp39_;
	GFile* _tmp40_;
	const gchar* _tmp41_;
	GFile* _tmp42_;
	GFile* _tmp43_;
	gchar* _tmp44_;
	gchar* _tmp45_;
	GError * _inner_error_;
};

typedef void (*RygelPluginLoaderModuleInitFunc) (RygelPluginLoader* loader, void* user_data);

static gpointer rygel_plugin_loader_parent_class = NULL;

GType rygel_plugin_loader_get_type (void) G_GNUC_CONST;
GType rygel_plugin_get_type (void) G_GNUC_CONST;
#define RYGEL_PLUGIN_LOADER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_PLUGIN_LOADER, RygelPluginLoaderPrivate))
enum  {
	RYGEL_PLUGIN_LOADER_DUMMY_PROPERTY
};
RygelPluginLoader* rygel_plugin_loader_new (void);
RygelPluginLoader* rygel_plugin_loader_construct (GType object_type);
void rygel_plugin_loader_load_plugins (RygelPluginLoader* self);
GType rygel_meta_config_get_type (void) G_GNUC_CONST;
RygelMetaConfig* rygel_meta_config_get_default (void);
GType rygel_configuration_get_type (void) G_GNUC_CONST;
gchar* rygel_configuration_get_plugin_path (RygelConfiguration* self, GError** error);
static gboolean rygel_plugin_loader_is_dir (GFile* file);
static void rygel_plugin_loader_load_modules_from_dir (RygelPluginLoader* self, GFile* dir, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_plugin_loader_load_modules_from_dir_finish (RygelPluginLoader* self, GAsyncResult* _res_);
gboolean rygel_plugin_loader_plugin_disabled (RygelPluginLoader* self, const gchar* name);
gboolean rygel_configuration_get_enabled (RygelConfiguration* self, const gchar* section, GError** error);
void rygel_plugin_loader_add_plugin (RygelPluginLoader* self, RygelPlugin* plugin);
GType rygel_root_device_get_type (void) G_GNUC_CONST;
gpointer rygel_resource_info_ref (gpointer instance);
void rygel_resource_info_unref (gpointer instance);
GParamSpec* rygel_param_spec_resource_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_resource_info (GValue* value, gpointer v_object);
void rygel_value_take_resource_info (GValue* value, gpointer v_object);
gpointer rygel_value_get_resource_info (const GValue* value);
GType rygel_resource_info_get_type (void) G_GNUC_CONST;
gpointer rygel_icon_info_ref (gpointer instance);
void rygel_icon_info_unref (gpointer instance);
GParamSpec* rygel_param_spec_icon_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_icon_info (GValue* value, gpointer v_object);
void rygel_value_take_icon_info (GValue* value, gpointer v_object);
gpointer rygel_value_get_icon_info (const GValue* value);
GType rygel_icon_info_get_type (void) G_GNUC_CONST;
RygelPlugin* rygel_plugin_loader_get_plugin_by_name (RygelPluginLoader* self, const gchar* name);
GeeCollection* rygel_plugin_loader_list_plugins (RygelPluginLoader* self);
static void rygel_plugin_loader_load_modules_from_dir_data_free (gpointer _data);
static gboolean rygel_plugin_loader_load_modules_from_dir_co (RygelPluginLoaderLoadModulesFromDirData* _data_);
static void rygel_plugin_loader_load_modules_from_dir_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static void rygel_plugin_loader_load_module_from_file (RygelPluginLoader* self, GFile* module_file);
static void rygel_plugin_loader_finalize (GObject* obj);


RygelPluginLoader* rygel_plugin_loader_construct (GType object_type) {
	RygelPluginLoader * self = NULL;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GeeHashMap* _tmp2_;
	GeeHashSet* _tmp3_;
#line 44 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	self = (RygelPluginLoader*) g_object_new (object_type, NULL);
#line 45 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	_tmp0_ = g_str_hash;
#line 45 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	_tmp1_ = g_str_equal;
#line 45 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	_tmp2_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, RYGEL_TYPE_PLUGIN, (GBoxedCopyFunc) g_object_ref, g_object_unref, _tmp0_, _tmp1_, NULL);
#line 45 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	_g_object_unref0 (self->priv->plugin_hash);
#line 45 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	self->priv->plugin_hash = _tmp2_;
#line 46 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	_tmp3_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL);
#line 46 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	_g_object_unref0 (self->priv->loaded_modules);
#line 46 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	self->priv->loaded_modules = _tmp3_;
#line 44 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	return self;
#line 317 "rygel-plugin-loader.c"
}


RygelPluginLoader* rygel_plugin_loader_new (void) {
#line 44 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	return rygel_plugin_loader_construct (RYGEL_TYPE_PLUGIN_LOADER);
#line 324 "rygel-plugin-loader.c"
}


void rygel_plugin_loader_load_plugins (RygelPluginLoader* self) {
	gboolean _tmp0_ = FALSE;
	gchar* path = NULL;
	const gchar* _tmp5_;
	GFile* _tmp6_ = NULL;
	GFile* dir;
	gboolean _tmp7_ = FALSE;
	GFile* _tmp8_;
	gboolean _tmp11_;
	GFile* _tmp12_;
	GError * _inner_error_ = NULL;
#line 50 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	g_return_if_fail (self != NULL);
#line 51 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	_tmp0_ = g_module_supported ();
#line 51 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	g_assert (_tmp0_);
#line 345 "rygel-plugin-loader.c"
	{
		RygelMetaConfig* _tmp1_ = NULL;
		RygelMetaConfig* config;
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
#line 55 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		_tmp1_ = rygel_meta_config_get_default ();
#line 55 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		config = _tmp1_;
#line 56 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		_tmp2_ = rygel_configuration_get_plugin_path ((RygelConfiguration*) config, &_inner_error_);
#line 56 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		_tmp3_ = _tmp2_;
#line 56 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		if (_inner_error_ != NULL) {
#line 56 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
			_g_object_unref0 (config);
#line 363 "rygel-plugin-loader.c"
			goto __catch34_g_error;
		}
#line 56 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		_g_free0 (path);
#line 56 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		path = _tmp3_;
#line 54 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		_g_object_unref0 (config);
#line 372 "rygel-plugin-loader.c"
	}
	goto __finally34;
	__catch34_g_error:
	{
		GError* _error_ = NULL;
		gchar* _tmp4_;
#line 54 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		_error_ = _inner_error_;
#line 54 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		_inner_error_ = NULL;
#line 58 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		_tmp4_ = g_strdup (PLUGIN_DIR);
#line 58 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		_g_free0 (path);
#line 58 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		path = _tmp4_;
#line 54 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		_g_error_free0 (_error_);
#line 391 "rygel-plugin-loader.c"
	}
	__finally34:
#line 54 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	if (_inner_error_ != NULL) {
#line 54 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		_g_free0 (path);
#line 54 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 54 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		g_clear_error (&_inner_error_);
#line 54 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		return;
#line 404 "rygel-plugin-loader.c"
	}
#line 61 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	_tmp5_ = path;
#line 61 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	_tmp6_ = g_file_new_for_path (_tmp5_);
#line 61 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	dir = _tmp6_;
#line 62 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	_tmp8_ = dir;
#line 62 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	if (_tmp8_ != NULL) {
#line 416 "rygel-plugin-loader.c"
		GFile* _tmp9_;
		gboolean _tmp10_ = FALSE;
#line 62 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		_tmp9_ = dir;
#line 62 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		_tmp10_ = rygel_plugin_loader_is_dir (_tmp9_);
#line 62 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		_tmp7_ = _tmp10_;
#line 425 "rygel-plugin-loader.c"
	} else {
#line 62 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		_tmp7_ = FALSE;
#line 429 "rygel-plugin-loader.c"
	}
#line 62 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	_tmp11_ = _tmp7_;
#line 62 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	g_assert (_tmp11_);
#line 64 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	_tmp12_ = dir;
#line 64 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	rygel_plugin_loader_load_modules_from_dir (self, _tmp12_, NULL, NULL);
#line 50 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	_g_object_unref0 (dir);
#line 50 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	_g_free0 (path);
#line 443 "rygel-plugin-loader.c"
}


/**
     * Checks if a plugin is disabled by user
     *
     * @param name the name of plugin to check for.
     *
     * @return true if plugin is disabled, false if not.
     */
gboolean rygel_plugin_loader_plugin_disabled (RygelPluginLoader* self, const gchar* name) {
	gboolean result = FALSE;
	gboolean enabled;
	gboolean _tmp4_;
	GError * _inner_error_ = NULL;
#line 74 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 74 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	g_return_val_if_fail (name != NULL, FALSE);
#line 75 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	enabled = TRUE;
#line 465 "rygel-plugin-loader.c"
	{
		RygelMetaConfig* _tmp0_ = NULL;
		RygelMetaConfig* config;
		const gchar* _tmp1_;
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_;
#line 77 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		_tmp0_ = rygel_meta_config_get_default ();
#line 77 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		config = _tmp0_;
#line 78 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		_tmp1_ = name;
#line 78 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		_tmp2_ = rygel_configuration_get_enabled ((RygelConfiguration*) config, _tmp1_, &_inner_error_);
#line 78 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		_tmp3_ = _tmp2_;
#line 78 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		if (_inner_error_ != NULL) {
#line 78 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
			_g_object_unref0 (config);
#line 486 "rygel-plugin-loader.c"
			goto __catch35_g_error;
		}
#line 78 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		enabled = _tmp3_;
#line 76 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		_g_object_unref0 (config);
#line 493 "rygel-plugin-loader.c"
	}
	goto __finally35;
	__catch35_g_error:
	{
		GError* err = NULL;
#line 76 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		err = _inner_error_;
#line 76 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		_inner_error_ = NULL;
#line 76 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		_g_error_free0 (err);
#line 505 "rygel-plugin-loader.c"
	}
	__finally35:
#line 76 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	if (_inner_error_ != NULL) {
#line 76 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 76 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		g_clear_error (&_inner_error_);
#line 76 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		return FALSE;
#line 516 "rygel-plugin-loader.c"
	}
#line 81 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	_tmp4_ = enabled;
#line 81 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	result = !_tmp4_;
#line 81 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	return result;
#line 524 "rygel-plugin-loader.c"
}


void rygel_plugin_loader_add_plugin (RygelPluginLoader* self, RygelPlugin* plugin) {
	const gchar* _tmp0_ = NULL;
	RygelPlugin* _tmp1_;
	const gchar* _tmp2_;
	GeeHashMap* _tmp3_;
	RygelPlugin* _tmp4_;
	const gchar* _tmp5_;
	RygelPlugin* _tmp6_;
	RygelPlugin* _tmp7_;
#line 84 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	g_return_if_fail (self != NULL);
#line 84 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	g_return_if_fail (plugin != NULL);
#line 85 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	_tmp0_ = _ ("New plugin '%s' available");
#line 85 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	_tmp1_ = plugin;
#line 85 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	_tmp2_ = _tmp1_->name;
#line 85 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	g_message (_tmp0_, _tmp2_);
#line 86 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	_tmp3_ = self->priv->plugin_hash;
#line 86 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	_tmp4_ = plugin;
#line 86 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	_tmp5_ = _tmp4_->name;
#line 86 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	_tmp6_ = plugin;
#line 86 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	gee_abstract_map_set ((GeeAbstractMap*) _tmp3_, _tmp5_, _tmp6_);
#line 87 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	_tmp7_ = plugin;
#line 87 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	g_signal_emit_by_name (self, "plugin-available", _tmp7_);
#line 563 "rygel-plugin-loader.c"
}


RygelPlugin* rygel_plugin_loader_get_plugin_by_name (RygelPluginLoader* self, const gchar* name) {
	RygelPlugin* result = NULL;
	GeeHashMap* _tmp0_;
	const gchar* _tmp1_;
	gpointer _tmp2_ = NULL;
#line 90 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 90 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 91 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	_tmp0_ = self->priv->plugin_hash;
#line 91 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	_tmp1_ = name;
#line 91 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, _tmp1_);
#line 91 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	result = (RygelPlugin*) _tmp2_;
#line 91 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	return result;
#line 586 "rygel-plugin-loader.c"
}


GeeCollection* rygel_plugin_loader_list_plugins (RygelPluginLoader* self) {
	GeeCollection* result = NULL;
	GeeHashMap* _tmp0_;
	GeeCollection* _tmp1_;
	GeeCollection* _tmp2_;
#line 94 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 95 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	_tmp0_ = self->priv->plugin_hash;
#line 95 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	_tmp1_ = gee_abstract_map_get_values ((GeeMap*) _tmp0_);
#line 95 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	_tmp2_ = _tmp1_;
#line 95 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	result = _tmp2_;
#line 95 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	return result;
#line 607 "rygel-plugin-loader.c"
}


static void rygel_plugin_loader_load_modules_from_dir_data_free (gpointer _data) {
	RygelPluginLoaderLoadModulesFromDirData* _data_;
	_data_ = _data;
#line 35 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	_g_object_unref0 (_data_->dir);
#line 35 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	_g_object_unref0 (_data_->self);
#line 35 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	g_slice_free (RygelPluginLoaderLoadModulesFromDirData, _data_);
#line 620 "rygel-plugin-loader.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 35 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	return self ? g_object_ref (self) : NULL;
#line 627 "rygel-plugin-loader.c"
}


static void rygel_plugin_loader_load_modules_from_dir (RygelPluginLoader* self, GFile* dir, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelPluginLoaderLoadModulesFromDirData* _data_;
	RygelPluginLoader* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
#line 35 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	_data_ = g_slice_new0 (RygelPluginLoaderLoadModulesFromDirData);
#line 35 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_plugin_loader_load_modules_from_dir);
#line 35 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_plugin_loader_load_modules_from_dir_data_free);
#line 35 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 35 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	_data_->self = _tmp0_;
#line 35 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	_tmp1_ = dir;
#line 35 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 35 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	_data_->dir = _tmp2_;
#line 35 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	rygel_plugin_loader_load_modules_from_dir_co (_data_);
#line 654 "rygel-plugin-loader.c"
}


static void rygel_plugin_loader_load_modules_from_dir_finish (RygelPluginLoader* self, GAsyncResult* _res_) {
	RygelPluginLoaderLoadModulesFromDirData* _data_;
#line 35 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 662 "rygel-plugin-loader.c"
}


static void rygel_plugin_loader_load_modules_from_dir_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelPluginLoaderLoadModulesFromDirData* _data_;
#line 110 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	_data_ = _user_data_;
#line 110 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	_data_->_source_object_ = source_object;
#line 110 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	_data_->_res_ = _res_;
#line 110 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	rygel_plugin_loader_load_modules_from_dir_co (_data_);
#line 676 "rygel-plugin-loader.c"
}


static void _g_object_unref0_ (gpointer var) {
#line 116 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 683 "rygel-plugin-loader.c"
}


static void _g_list_free__g_object_unref0_ (GList* self) {
#line 116 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
#line 116 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	g_list_free (self);
#line 692 "rygel-plugin-loader.c"
}


static gboolean rygel_plugin_loader_load_modules_from_dir_co (RygelPluginLoaderLoadModulesFromDirData* _data_) {
#line 98 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	switch (_data_->_state_) {
#line 98 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		case 0:
#line 701 "rygel-plugin-loader.c"
		goto _state_0;
#line 98 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		case 1:
#line 705 "rygel-plugin-loader.c"
		goto _state_1;
#line 98 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		case 2:
#line 709 "rygel-plugin-loader.c"
		goto _state_2;
		default:
#line 98 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		g_assert_not_reached ();
#line 714 "rygel-plugin-loader.c"
	}
	_state_0:
#line 99 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	_data_->_tmp0_ = _data_->dir;
#line 99 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	_data_->_tmp1_ = NULL;
#line 99 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	_data_->_tmp1_ = g_file_get_path (_data_->_tmp0_);
#line 99 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	_data_->_tmp2_ = _data_->_tmp1_;
#line 99 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	g_debug ("rygel-plugin-loader.vala:99: Searching for modules in folder '%s'.", _data_->_tmp2_);
#line 99 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	_g_free0 (_data_->_tmp2_);
#line 101 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	_data_->_tmp3_ = g_strdup (G_FILE_ATTRIBUTE_STANDARD_NAME "," G_FILE_ATTRIBUTE_STANDARD_TYPE "," G_FILE_ATTRIBUTE_STANDARD_IS_HIDDEN "," G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE);
#line 101 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	_data_->attributes = _data_->_tmp3_;
#line 733 "rygel-plugin-loader.c"
	{
#line 110 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		_data_->_tmp4_ = _data_->dir;
#line 110 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		_data_->_tmp5_ = _data_->attributes;
#line 110 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		_data_->_state_ = 1;
#line 110 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		g_file_enumerate_children_async (_data_->_tmp4_, _data_->_tmp5_, G_FILE_QUERY_INFO_NONE, G_PRIORITY_DEFAULT, NULL, rygel_plugin_loader_load_modules_from_dir_ready, _data_);
#line 110 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		return FALSE;
#line 745 "rygel-plugin-loader.c"
		_state_1:
#line 110 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		_data_->_tmp6_ = NULL;
#line 110 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		_data_->_tmp6_ = g_file_enumerate_children_finish (_data_->_tmp4_, _data_->_res_, &_data_->_inner_error_);
#line 110 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		_data_->_tmp7_ = _data_->_tmp6_;
#line 110 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		if (_data_->_inner_error_ != NULL) {
#line 755 "rygel-plugin-loader.c"
			goto __catch36_g_error;
		}
#line 110 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		_g_object_unref0 (_data_->enumerator);
#line 110 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		_data_->enumerator = _data_->_tmp7_;
#line 116 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		_data_->_tmp8_ = _data_->enumerator;
#line 116 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		_data_->_tmp9_ = G_MAXINT;
#line 116 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		_data_->_state_ = 2;
#line 116 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		g_file_enumerator_next_files_async (_data_->_tmp8_, _data_->_tmp9_, G_PRIORITY_DEFAULT, NULL, rygel_plugin_loader_load_modules_from_dir_ready, _data_);
#line 116 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		return FALSE;
#line 772 "rygel-plugin-loader.c"
		_state_2:
#line 116 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		_data_->_tmp10_ = NULL;
#line 116 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		_data_->_tmp10_ = g_file_enumerator_next_files_finish (_data_->_tmp8_, _data_->_res_, &_data_->_inner_error_);
#line 116 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		_data_->_tmp11_ = _data_->_tmp10_;
#line 116 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		if (_data_->_inner_error_ != NULL) {
#line 782 "rygel-plugin-loader.c"
			goto __catch36_g_error;
		}
#line 116 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		__g_list_free__g_object_unref0_0 (_data_->infos);
#line 116 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		_data_->infos = _data_->_tmp11_;
#line 789 "rygel-plugin-loader.c"
	}
	goto __finally36;
	__catch36_g_error:
	{
#line 109 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		_data_->_error_ = _data_->_inner_error_;
#line 109 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		_data_->_inner_error_ = NULL;
#line 120 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		_data_->_tmp12_ = NULL;
#line 120 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		_data_->_tmp12_ = _ ("Error listing contents of folder '%s': %s");
#line 120 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		_data_->_tmp13_ = _data_->dir;
#line 120 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		_data_->_tmp14_ = NULL;
#line 120 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		_data_->_tmp14_ = g_file_get_path (_data_->_tmp13_);
#line 120 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		_data_->_tmp15_ = _data_->_tmp14_;
#line 120 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		_data_->_tmp16_ = _data_->_error_;
#line 120 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		_data_->_tmp17_ = _data_->_tmp16_->message;
#line 120 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		g_critical (_data_->_tmp12_, _data_->_tmp15_, _data_->_tmp17_);
#line 120 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		_g_free0 (_data_->_tmp15_);
#line 124 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		_g_error_free0 (_data_->_error_);
#line 124 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		_g_object_unref0 (_data_->enumerator);
#line 124 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		__g_list_free__g_object_unref0_0 (_data_->infos);
#line 124 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		_g_free0 (_data_->attributes);
#line 124 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		if (_data_->_state_ == 0) {
#line 124 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 830 "rygel-plugin-loader.c"
		} else {
#line 124 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 834 "rygel-plugin-loader.c"
		}
#line 124 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		g_object_unref (_data_->_async_result);
#line 124 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		return FALSE;
#line 840 "rygel-plugin-loader.c"
	}
	__finally36:
#line 109 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	if (_data_->_inner_error_ != NULL) {
#line 109 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		_g_object_unref0 (_data_->enumerator);
#line 109 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		__g_list_free__g_object_unref0_0 (_data_->infos);
#line 109 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		_g_free0 (_data_->attributes);
#line 109 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 109 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		g_clear_error (&_data_->_inner_error_);
#line 109 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		return FALSE;
#line 857 "rygel-plugin-loader.c"
	}
#line 127 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	_data_->_tmp18_ = _data_->infos;
#line 861 "rygel-plugin-loader.c"
	{
#line 127 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		_data_->info_collection = _data_->_tmp18_;
#line 127 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		for (_data_->info_it = _data_->info_collection; _data_->info_it != NULL; _data_->info_it = _data_->info_it->next) {
#line 127 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
			_data_->_tmp19_ = _g_object_ref0 ((GFileInfo*) _data_->info_it->data);
#line 127 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
			_data_->info = _data_->_tmp19_;
#line 871 "rygel-plugin-loader.c"
			{
#line 128 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
				_data_->_tmp20_ = _data_->dir;
#line 128 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
				_data_->_tmp21_ = _data_->info;
#line 128 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
				_data_->_tmp22_ = NULL;
#line 128 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
				_data_->_tmp22_ = g_file_info_get_name (_data_->_tmp21_);
#line 128 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
				_data_->_tmp23_ = NULL;
#line 128 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
				_data_->_tmp23_ = g_file_get_child (_data_->_tmp20_, _data_->_tmp22_);
#line 128 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
				_data_->file = _data_->_tmp23_;
#line 129 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
				_data_->_tmp24_ = _data_->info;
#line 129 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
				_data_->_tmp25_ = 0;
#line 129 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
				_data_->_tmp25_ = g_file_info_get_file_type (_data_->_tmp24_);
#line 129 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
				_data_->file_type = _data_->_tmp25_;
#line 130 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
				_data_->_tmp26_ = _data_->info;
#line 130 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
				_data_->_tmp27_ = NULL;
#line 130 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
				_data_->_tmp27_ = g_file_info_get_content_type (_data_->_tmp26_);
#line 130 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
				_data_->_tmp28_ = g_strdup (_data_->_tmp27_);
#line 130 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
				_data_->content_type = _data_->_tmp28_;
#line 131 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
				_data_->_tmp29_ = _data_->content_type;
#line 131 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
				_data_->_tmp30_ = NULL;
#line 131 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
				_data_->_tmp30_ = g_content_type_get_mime_type (_data_->_tmp29_);
#line 131 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
				_data_->mime = _data_->_tmp30_;
#line 133 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
				_data_->_tmp32_ = _data_->file_type;
#line 133 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
				if (_data_->_tmp32_ == G_FILE_TYPE_DIRECTORY) {
#line 134 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
					_data_->_tmp34_ = _data_->info;
#line 134 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
					_data_->_tmp35_ = NULL;
#line 134 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
					_data_->_tmp35_ = g_file_info_get_name (_data_->_tmp34_);
#line 134 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
					if (g_strcmp0 (_data_->_tmp35_, ".libs") == 0) {
#line 134 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
						_data_->_tmp33_ = TRUE;
#line 927 "rygel-plugin-loader.c"
					} else {
#line 135 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
						_data_->_tmp36_ = _data_->info;
#line 135 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
						_data_->_tmp37_ = FALSE;
#line 135 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
						_data_->_tmp37_ = g_file_info_get_is_hidden (_data_->_tmp36_);
#line 135 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
						_data_->_tmp33_ = !_data_->_tmp37_;
#line 937 "rygel-plugin-loader.c"
					}
#line 134 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
					_data_->_tmp38_ = _data_->_tmp33_;
#line 134 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
					_data_->_tmp31_ = _data_->_tmp38_;
#line 943 "rygel-plugin-loader.c"
				} else {
#line 133 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
					_data_->_tmp31_ = FALSE;
#line 947 "rygel-plugin-loader.c"
				}
#line 133 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
				_data_->_tmp39_ = _data_->_tmp31_;
#line 133 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
				if (_data_->_tmp39_) {
#line 137 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
					_data_->_tmp40_ = _data_->file;
#line 137 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
					rygel_plugin_loader_load_modules_from_dir (_data_->self, _data_->_tmp40_, NULL, NULL);
#line 957 "rygel-plugin-loader.c"
				} else {
#line 138 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
					_data_->_tmp41_ = _data_->mime;
#line 138 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
					if (g_strcmp0 (_data_->_tmp41_, "application/x-sharedlib") == 0) {
#line 140 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
						_data_->_tmp42_ = _data_->file;
#line 140 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
						rygel_plugin_loader_load_module_from_file (_data_->self, _data_->_tmp42_);
#line 967 "rygel-plugin-loader.c"
					}
				}
#line 127 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
				_g_free0 (_data_->mime);
#line 127 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
				_g_free0 (_data_->content_type);
#line 127 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
				_g_object_unref0 (_data_->file);
#line 127 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
				_g_object_unref0 (_data_->info);
#line 978 "rygel-plugin-loader.c"
			}
		}
	}
#line 144 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	_data_->_tmp43_ = _data_->dir;
#line 144 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	_data_->_tmp44_ = NULL;
#line 144 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	_data_->_tmp44_ = g_file_get_path (_data_->_tmp43_);
#line 144 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	_data_->_tmp45_ = _data_->_tmp44_;
#line 144 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	g_debug ("rygel-plugin-loader.vala:144: Finished searching for modules in folder" \
" '%s'", _data_->_tmp45_);
#line 144 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	_g_free0 (_data_->_tmp45_);
#line 98 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	_g_object_unref0 (_data_->enumerator);
#line 98 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	__g_list_free__g_object_unref0_0 (_data_->infos);
#line 98 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	_g_free0 (_data_->attributes);
#line 98 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	if (_data_->_state_ == 0) {
#line 98 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1004 "rygel-plugin-loader.c"
	} else {
#line 98 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1008 "rygel-plugin-loader.c"
	}
#line 98 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	g_object_unref (_data_->_async_result);
#line 98 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	return FALSE;
#line 1014 "rygel-plugin-loader.c"
}


static void rygel_plugin_loader_load_module_from_file (RygelPluginLoader* self, GFile* module_file) {
	GeeHashSet* _tmp0_;
	GFile* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_;
	GFile* _tmp10_;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_;
	GModule* _tmp13_ = NULL;
	GModule* _tmp14_;
	GModule* module;
	GModule* _tmp15_;
	void* function = NULL;
	GModule* _tmp21_;
	void* _tmp22_ = NULL;
	gboolean _tmp23_ = FALSE;
	void* _tmp29_;
	RygelPluginLoaderModuleInitFunc module_init;
	void* module_init_target;
	RygelPluginLoaderModuleInitFunc _tmp30_;
	void* _tmp30__target;
	GeeHashSet* _tmp31_;
	GFile* _tmp32_;
	gchar* _tmp33_ = NULL;
	gchar* _tmp34_;
	GModule* _tmp35_;
	RygelPluginLoaderModuleInitFunc _tmp36_;
	void* _tmp36__target;
	GModule* _tmp37_;
	const gchar* _tmp38_ = NULL;
#line 148 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	g_return_if_fail (self != NULL);
#line 148 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	g_return_if_fail (module_file != NULL);
#line 149 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	_tmp0_ = self->priv->loaded_modules;
#line 149 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	_tmp1_ = module_file;
#line 149 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	_tmp2_ = g_file_get_basename (_tmp1_);
#line 149 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	_tmp3_ = _tmp2_;
#line 149 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	_tmp4_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp0_, _tmp3_);
#line 149 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	_tmp5_ = _tmp4_;
#line 149 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	_g_free0 (_tmp3_);
#line 149 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	if (_tmp5_) {
#line 1070 "rygel-plugin-loader.c"
		const gchar* _tmp6_ = NULL;
		GFile* _tmp7_;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_;
#line 150 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		_tmp6_ = _ ("A module named %s is already loaded");
#line 150 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		_tmp7_ = module_file;
#line 150 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		_tmp8_ = g_file_get_basename (_tmp7_);
#line 150 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		_tmp9_ = _tmp8_;
#line 150 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		g_warning (_tmp6_, _tmp9_);
#line 150 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		_g_free0 (_tmp9_);
#line 153 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		return;
#line 1089 "rygel-plugin-loader.c"
	}
#line 156 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	_tmp10_ = module_file;
#line 156 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	_tmp11_ = g_file_get_path (_tmp10_);
#line 156 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	_tmp12_ = _tmp11_;
#line 156 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	_tmp13_ = g_module_open (_tmp12_, G_MODULE_BIND_LOCAL);
#line 156 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	_tmp14_ = _tmp13_;
#line 156 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	_g_free0 (_tmp12_);
#line 156 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	module = _tmp14_;
#line 158 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	_tmp15_ = module;
#line 158 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	if (_tmp15_ == NULL) {
#line 1109 "rygel-plugin-loader.c"
		const gchar* _tmp16_ = NULL;
		GFile* _tmp17_;
		gchar* _tmp18_ = NULL;
		gchar* _tmp19_;
		const gchar* _tmp20_ = NULL;
#line 159 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		_tmp16_ = _ ("Failed to load module from path '%s': %s");
#line 159 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		_tmp17_ = module_file;
#line 159 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		_tmp18_ = g_file_get_path (_tmp17_);
#line 159 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		_tmp19_ = _tmp18_;
#line 159 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		_tmp20_ = g_module_error ();
#line 159 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		g_warning (_tmp16_, _tmp19_, _tmp20_);
#line 159 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		_g_free0 (_tmp19_);
#line 163 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		_g_module_close0 (module);
#line 163 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		return;
#line 1133 "rygel-plugin-loader.c"
	}
#line 168 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	_tmp21_ = module;
#line 168 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	_tmp23_ = g_module_symbol (_tmp21_, "module_init", &_tmp22_);
#line 168 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	function = _tmp22_;
#line 168 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	if (!_tmp23_) {
#line 1143 "rygel-plugin-loader.c"
		const gchar* _tmp24_ = NULL;
		GFile* _tmp25_;
		gchar* _tmp26_ = NULL;
		gchar* _tmp27_;
		const gchar* _tmp28_ = NULL;
#line 169 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		_tmp24_ = _ ("Failed to find entry point function '%s' in '%s': %s");
#line 169 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		_tmp25_ = module_file;
#line 169 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		_tmp26_ = g_file_get_path (_tmp25_);
#line 169 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		_tmp27_ = _tmp26_;
#line 169 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		_tmp28_ = g_module_error ();
#line 169 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		g_warning (_tmp24_, "module_init", _tmp27_, _tmp28_);
#line 169 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		_g_free0 (_tmp27_);
#line 174 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		_g_module_close0 (module);
#line 174 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		return;
#line 1167 "rygel-plugin-loader.c"
	}
#line 177 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	_tmp29_ = function;
#line 177 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	module_init = (RygelPluginLoaderModuleInitFunc) _tmp29_;
#line 177 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	module_init_target = NULL;
#line 178 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	_tmp30_ = module_init;
#line 178 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	_tmp30__target = module_init_target;
#line 178 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	g_assert (_tmp30_ != NULL);
#line 179 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	_tmp31_ = self->priv->loaded_modules;
#line 179 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	_tmp32_ = module_file;
#line 179 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	_tmp33_ = g_file_get_basename (_tmp32_);
#line 179 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	_tmp34_ = _tmp33_;
#line 179 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp31_, _tmp34_);
#line 179 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	_g_free0 (_tmp34_);
#line 182 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	_tmp35_ = module;
#line 182 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	g_module_make_resident (_tmp35_);
#line 184 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	_tmp36_ = module_init;
#line 184 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	_tmp36__target = module_init_target;
#line 184 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	_tmp36_ (self, _tmp36__target);
#line 186 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	_tmp37_ = module;
#line 186 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	_tmp38_ = g_module_name (_tmp37_);
#line 186 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	g_debug ("rygel-plugin-loader.vala:186: Loaded module source: '%s'", _tmp38_);
#line 148 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	_g_module_close0 (module);
#line 1211 "rygel-plugin-loader.c"
}


static gboolean rygel_plugin_loader_is_dir (GFile* file) {
	gboolean result = FALSE;
	GFileInfo* file_info = NULL;
	GFileInfo* _tmp7_;
	GFileType _tmp8_ = 0;
	GError * _inner_error_ = NULL;
#line 189 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	g_return_val_if_fail (file != NULL, FALSE);
#line 1223 "rygel-plugin-loader.c"
	{
		GFile* _tmp0_;
		GFileInfo* _tmp1_ = NULL;
		GFileInfo* _tmp2_;
#line 193 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		_tmp0_ = file;
#line 193 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		_tmp1_ = g_file_query_info (_tmp0_, G_FILE_ATTRIBUTE_STANDARD_TYPE, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
#line 193 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		_tmp2_ = _tmp1_;
#line 193 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		if (_inner_error_ != NULL) {
#line 1236 "rygel-plugin-loader.c"
			goto __catch37_g_error;
		}
#line 193 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		_g_object_unref0 (file_info);
#line 193 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		file_info = _tmp2_;
#line 1243 "rygel-plugin-loader.c"
	}
	goto __finally37;
	__catch37_g_error:
	{
		GError* _error_ = NULL;
		const gchar* _tmp3_ = NULL;
		GFile* _tmp4_;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_;
#line 192 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		_error_ = _inner_error_;
#line 192 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		_inner_error_ = NULL;
#line 197 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		_tmp3_ = _ ("Failed to query content type for '%s'");
#line 197 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		_tmp4_ = file;
#line 197 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		_tmp5_ = g_file_get_path (_tmp4_);
#line 197 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		_tmp6_ = _tmp5_;
#line 197 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		g_critical (_tmp3_, _tmp6_);
#line 197 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		_g_free0 (_tmp6_);
#line 200 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		result = FALSE;
#line 200 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		_g_error_free0 (_error_);
#line 200 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		_g_object_unref0 (file_info);
#line 200 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		return result;
#line 1277 "rygel-plugin-loader.c"
	}
	__finally37:
#line 192 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	if (_inner_error_ != NULL) {
#line 192 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		_g_object_unref0 (file_info);
#line 192 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 192 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		g_clear_error (&_inner_error_);
#line 192 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
		return FALSE;
#line 1290 "rygel-plugin-loader.c"
	}
#line 203 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	_tmp7_ = file_info;
#line 203 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	_tmp8_ = g_file_info_get_file_type (_tmp7_);
#line 203 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	result = _tmp8_ == G_FILE_TYPE_DIRECTORY;
#line 203 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	_g_object_unref0 (file_info);
#line 203 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	return result;
#line 1302 "rygel-plugin-loader.c"
}


static void rygel_plugin_loader_class_init (RygelPluginLoaderClass * klass) {
#line 35 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	rygel_plugin_loader_parent_class = g_type_class_peek_parent (klass);
#line 35 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	g_type_class_add_private (klass, sizeof (RygelPluginLoaderPrivate));
#line 35 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_plugin_loader_finalize;
#line 35 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	g_signal_new ("plugin_available", RYGEL_TYPE_PLUGIN_LOADER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, RYGEL_TYPE_PLUGIN);
#line 1315 "rygel-plugin-loader.c"
}


static void rygel_plugin_loader_instance_init (RygelPluginLoader * self) {
#line 35 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	self->priv = RYGEL_PLUGIN_LOADER_GET_PRIVATE (self);
#line 1322 "rygel-plugin-loader.c"
}


static void rygel_plugin_loader_finalize (GObject* obj) {
	RygelPluginLoader * self;
#line 35 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	self = RYGEL_PLUGIN_LOADER (obj);
#line 38 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	_g_object_unref0 (self->priv->plugin_hash);
#line 39 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	_g_object_unref0 (self->priv->loaded_modules);
#line 35 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin-loader.vala"
	G_OBJECT_CLASS (rygel_plugin_loader_parent_class)->finalize (obj);
#line 1336 "rygel-plugin-loader.c"
}


/**
 * Responsible for plugin loading. Probes for shared library files in a specific
 * directry and tries to grab a function with a specific name and signature,
 * calls it. The loaded module can then add plugins to Rygel by calling the
 * add_plugin method. NOTE: The module SHOULD make sure that plugin is not
 * disabled by user using plugin_disabled method before creating the plugin
 * instance and resources related to that instance.
 */
GType rygel_plugin_loader_get_type (void) {
	static volatile gsize rygel_plugin_loader_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_plugin_loader_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelPluginLoaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_plugin_loader_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelPluginLoader), 0, (GInstanceInitFunc) rygel_plugin_loader_instance_init, NULL };
		GType rygel_plugin_loader_type_id;
		rygel_plugin_loader_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelPluginLoader", &g_define_type_info, 0);
		g_once_init_leave (&rygel_plugin_loader_type_id__volatile, rygel_plugin_loader_type_id);
	}
	return rygel_plugin_loader_type_id__volatile;
}



