/* rygel-media-export-harvester.c generated by valac 0.16.1, the Vala compiler
 * generated from rygel-media-export-harvester.vala, do not modify */

/*
 * Copyright (C) 2010 Jens Georg <mail@jensge.org>.
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <gio/gio.h>
#include <rygel-server.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <rygel-core.h>


#define RYGEL_MEDIA_EXPORT_TYPE_HARVESTER (rygel_media_export_harvester_get_type ())
#define RYGEL_MEDIA_EXPORT_HARVESTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_HARVESTER, RygelMediaExportHarvester))
#define RYGEL_MEDIA_EXPORT_HARVESTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_HARVESTER, RygelMediaExportHarvesterClass))
#define RYGEL_MEDIA_EXPORT_IS_HARVESTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_HARVESTER))
#define RYGEL_MEDIA_EXPORT_IS_HARVESTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_HARVESTER))
#define RYGEL_MEDIA_EXPORT_HARVESTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_HARVESTER, RygelMediaExportHarvesterClass))

typedef struct _RygelMediaExportHarvester RygelMediaExportHarvester;
typedef struct _RygelMediaExportHarvesterClass RygelMediaExportHarvesterClass;
typedef struct _RygelMediaExportHarvesterPrivate RygelMediaExportHarvesterPrivate;

#define RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK (rygel_media_export_harvesting_task_get_type ())
#define RYGEL_MEDIA_EXPORT_HARVESTING_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK, RygelMediaExportHarvestingTask))
#define RYGEL_MEDIA_EXPORT_HARVESTING_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK, RygelMediaExportHarvestingTaskClass))
#define RYGEL_MEDIA_EXPORT_IS_HARVESTING_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK))
#define RYGEL_MEDIA_EXPORT_IS_HARVESTING_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK))
#define RYGEL_MEDIA_EXPORT_HARVESTING_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK, RygelMediaExportHarvestingTaskClass))

typedef struct _RygelMediaExportHarvestingTask RygelMediaExportHarvestingTask;
typedef struct _RygelMediaExportHarvestingTaskClass RygelMediaExportHarvestingTaskClass;

#define RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR (rygel_media_export_metadata_extractor_get_type ())
#define RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR, RygelMediaExportMetadataExtractor))
#define RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR, RygelMediaExportMetadataExtractorClass))
#define RYGEL_MEDIA_EXPORT_IS_METADATA_EXTRACTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR))
#define RYGEL_MEDIA_EXPORT_IS_METADATA_EXTRACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR))
#define RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR, RygelMediaExportMetadataExtractorClass))

typedef struct _RygelMediaExportMetadataExtractor RygelMediaExportMetadataExtractor;
typedef struct _RygelMediaExportMetadataExtractorClass RygelMediaExportMetadataExtractorClass;

#define RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR (rygel_media_export_recursive_file_monitor_get_type ())
#define RYGEL_MEDIA_EXPORT_RECURSIVE_FILE_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR, RygelMediaExportRecursiveFileMonitor))
#define RYGEL_MEDIA_EXPORT_RECURSIVE_FILE_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR, RygelMediaExportRecursiveFileMonitorClass))
#define RYGEL_MEDIA_EXPORT_IS_RECURSIVE_FILE_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR))
#define RYGEL_MEDIA_EXPORT_IS_RECURSIVE_FILE_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR))
#define RYGEL_MEDIA_EXPORT_RECURSIVE_FILE_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR, RygelMediaExportRecursiveFileMonitorClass))

typedef struct _RygelMediaExportRecursiveFileMonitor RygelMediaExportRecursiveFileMonitor;
typedef struct _RygelMediaExportRecursiveFileMonitorClass RygelMediaExportRecursiveFileMonitorClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _RygelMediaExportHarvestingTaskPrivate RygelMediaExportHarvestingTaskPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE (rygel_media_export_media_cache_get_type ())
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCache))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCacheClass))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCacheClass))

typedef struct _RygelMediaExportMediaCache RygelMediaExportMediaCache;
typedef struct _RygelMediaExportMediaCacheClass RygelMediaExportMediaCacheClass;
typedef struct _Block3Data Block3Data;

struct _RygelMediaExportHarvester {
	GObject parent_instance;
	RygelMediaExportHarvesterPrivate * priv;
};

struct _RygelMediaExportHarvesterClass {
	GObjectClass parent_class;
};

struct _RygelMediaExportHarvesterPrivate {
	GeeHashMap* tasks;
	GeeHashMap* extraction_grace_timers;
	RygelMediaExportMetadataExtractor* extractor;
	RygelMediaExportRecursiveFileMonitor* monitor;
	GCancellable* cancellable;
	GeeArrayList* _locations;
};

struct _RygelMediaExportHarvestingTask {
	GObject parent_instance;
	RygelMediaExportHarvestingTaskPrivate * priv;
	GFile* origin;
};

struct _RygelMediaExportHarvestingTaskClass {
	GObjectClass parent_class;
};

typedef enum  {
	RYGEL_MEDIA_EXPORT_DATABASE_ERROR_IO_ERROR,
	RYGEL_MEDIA_EXPORT_DATABASE_ERROR_SQLITE_ERROR
} RygelMediaExportDatabaseError;
#define RYGEL_MEDIA_EXPORT_DATABASE_ERROR rygel_media_export_database_error_quark ()
typedef enum  {
	RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_SQLITE_ERROR,
	RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_GENERAL_ERROR,
	RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_INVALID_TYPE,
	RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_UNSUPPORTED_SEARCH
} RygelMediaExportMediaCacheError;
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR rygel_media_export_media_cache_error_quark ()
struct _Block3Data {
	int _ref_count_;
	RygelMediaExportHarvester * self;
	GFile* file;
};


static gpointer rygel_media_export_harvester_parent_class = NULL;

GType rygel_media_export_harvester_get_type (void) G_GNUC_CONST;
GType rygel_media_export_harvesting_task_get_type (void) G_GNUC_CONST;
GType rygel_media_export_metadata_extractor_get_type (void) G_GNUC_CONST;
GType rygel_media_export_recursive_file_monitor_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIA_EXPORT_HARVESTER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_MEDIA_EXPORT_TYPE_HARVESTER, RygelMediaExportHarvesterPrivate))
enum  {
	RYGEL_MEDIA_EXPORT_HARVESTER_DUMMY_PROPERTY,
	RYGEL_MEDIA_EXPORT_HARVESTER_LOCATIONS
};
#define RYGEL_MEDIA_EXPORT_HARVESTER_FILE_CHANGE_DEFAULT_GRACE_PERIOD ((guint) 5)
RygelMediaExportHarvester* rygel_media_export_harvester_new (GCancellable* cancellable, GeeArrayList* locations);
RygelMediaExportHarvester* rygel_media_export_harvester_construct (GType object_type, GCancellable* cancellable, GeeArrayList* locations);
static void rygel_media_export_harvester_set_locations (RygelMediaExportHarvester* self, GeeArrayList* value);
GeeArrayList* rygel_media_export_harvester_get_locations (RygelMediaExportHarvester* self);
RygelMediaExportMetadataExtractor* rygel_media_export_metadata_extractor_new (void);
RygelMediaExportMetadataExtractor* rygel_media_export_metadata_extractor_construct (GType object_type);
RygelMediaExportRecursiveFileMonitor* rygel_media_export_recursive_file_monitor_new (GCancellable* cancellable);
RygelMediaExportRecursiveFileMonitor* rygel_media_export_recursive_file_monitor_construct (GType object_type, GCancellable* cancellable);
static void rygel_media_export_harvester_on_file_changed (RygelMediaExportHarvester* self, GFile* file, GFile* other, GFileMonitorEvent event);
static void _rygel_media_export_harvester_on_file_changed_rygel_media_export_recursive_file_monitor_changed (RygelMediaExportRecursiveFileMonitor* _sender, GFile* file, GFile* other_file, GFileMonitorEvent event_type, gpointer self);
static guint _g_file_hash_ghash_func (gconstpointer key);
void rygel_media_export_harvester_schedule (RygelMediaExportHarvester* self, GFile* file, RygelMediaContainer* parent, const gchar* flag);
void rygel_media_export_harvester_cancel (RygelMediaExportHarvester* self, GFile* file);
RygelMediaExportHarvestingTask* rygel_media_export_harvesting_task_new (RygelMediaExportMetadataExtractor* extractor, RygelMediaExportRecursiveFileMonitor* monitor, GFile* file, RygelMediaContainer* parent, const gchar* flag);
RygelMediaExportHarvestingTask* rygel_media_export_harvesting_task_construct (GType object_type, RygelMediaExportMetadataExtractor* extractor, RygelMediaExportRecursiveFileMonitor* monitor, GFile* file, RygelMediaContainer* parent, const gchar* flag);
static void rygel_media_export_harvester_on_file_harvested (RygelMediaExportHarvester* self, RygelStateMachine* state_machine);
static void _rygel_media_export_harvester_on_file_harvested_rygel_state_machine_completed (RygelStateMachine* _sender, gpointer self);
void rygel_media_export_harvesting_task_cancel (RygelMediaExportHarvestingTask* self);
static void rygel_media_export_harvester_on_changes_done (RygelMediaExportHarvester* self, GFile* file, GError** error);
static void rygel_media_export_harvester_on_file_removed (RygelMediaExportHarvester* self, GFile* file, GError** error);
static void rygel_media_export_harvester_on_file_added (RygelMediaExportHarvester* self, GFile* file);
GType rygel_media_export_media_cache_get_type (void) G_GNUC_CONST;
RygelMediaExportMediaCache* rygel_media_export_media_cache_get_default (GError** error);
gchar* rygel_media_export_media_cache_get_id (GFile* file);
GQuark rygel_media_export_database_error_quark (void);
RygelMediaObject* rygel_media_export_media_cache_get_object (RygelMediaExportMediaCache* self, const gchar* object_id, GError** error);
#define RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_FILESYSTEM_FOLDER_ID "Filesystem"
GQuark rygel_media_export_media_cache_error_quark (void);
void rygel_media_export_media_cache_remove_object (RygelMediaExportMediaCache* self, RygelMediaObject* object, GError** error);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static gboolean __lambda2_ (Block3Data* _data3_);
static gboolean ___lambda2__gsource_func (gpointer self);
static void rygel_media_export_harvester_finalize (GObject* obj);
static void _vala_rygel_media_export_harvester_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_media_export_harvester_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


/**
     * Create a new instance of the meta-data extraction manager.
     */
static gpointer _g_object_ref0 (gpointer self) {
#line 45 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	return self ? g_object_ref (self) : NULL;
#line 195 "rygel-media-export-harvester.c"
}


static void _rygel_media_export_harvester_on_file_changed_rygel_media_export_recursive_file_monitor_changed (RygelMediaExportRecursiveFileMonitor* _sender, GFile* file, GFile* other_file, GFileMonitorEvent event_type, gpointer self) {
#line 56 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	rygel_media_export_harvester_on_file_changed (self, file, other_file, event_type);
#line 202 "rygel-media-export-harvester.c"
}


static guint _g_file_hash_ghash_func (gconstpointer key) {
	guint result;
	result = g_file_hash (key);
#line 58 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	return result;
#line 211 "rygel-media-export-harvester.c"
}


RygelMediaExportHarvester* rygel_media_export_harvester_construct (GType object_type, GCancellable* cancellable, GeeArrayList* locations) {
	RygelMediaExportHarvester * self = NULL;
	GCancellable* _tmp0_;
	GCancellable* _tmp1_;
	GeeArrayList* _tmp2_;
	GeeArrayList* _tmp3_;
	RygelMediaExportMetadataExtractor* _tmp19_;
	GCancellable* _tmp20_;
	RygelMediaExportRecursiveFileMonitor* _tmp21_;
	RygelMediaExportRecursiveFileMonitor* _tmp22_;
	GeeHashMap* _tmp23_;
	GeeHashMap* _tmp24_;
#line 43 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	g_return_val_if_fail (cancellable != NULL, NULL);
#line 43 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	g_return_val_if_fail (locations != NULL, NULL);
#line 43 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	self = (RygelMediaExportHarvester*) g_object_new (object_type, NULL);
#line 45 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp0_ = cancellable;
#line 45 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 45 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_g_object_unref0 (self->priv->cancellable);
#line 45 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	self->priv->cancellable = _tmp1_;
#line 46 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp2_ = gee_array_list_new (G_TYPE_FILE, (GBoxedCopyFunc) g_object_ref, g_object_unref, (GEqualFunc) g_file_equal);
#line 46 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp3_ = _tmp2_;
#line 46 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	rygel_media_export_harvester_set_locations (self, _tmp3_);
#line 46 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_g_object_unref0 (_tmp3_);
#line 249 "rygel-media-export-harvester.c"
	{
		GeeArrayList* _tmp4_;
		GeeArrayList* _tmp5_;
		GeeArrayList* _file_list;
		GeeArrayList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _file_size;
		gint _file_index;
#line 47 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp4_ = locations;
#line 47 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp5_ = _g_object_ref0 (_tmp4_);
#line 47 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_file_list = _tmp5_;
#line 47 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp6_ = _file_list;
#line 47 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp7_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp6_);
#line 47 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp8_ = _tmp7_;
#line 47 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_file_size = _tmp8_;
#line 47 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_file_index = -1;
#line 47 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		while (TRUE) {
#line 277 "rygel-media-export-harvester.c"
			gint _tmp9_;
			gint _tmp10_;
			gint _tmp11_;
			GeeArrayList* _tmp12_;
			gint _tmp13_;
			gpointer _tmp14_ = NULL;
			GFile* file;
			GFile* _tmp15_;
			gboolean _tmp16_ = FALSE;
#line 47 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp9_ = _file_index;
#line 47 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_file_index = _tmp9_ + 1;
#line 47 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp10_ = _file_index;
#line 47 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp11_ = _file_size;
#line 47 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			if (!(_tmp10_ < _tmp11_)) {
#line 47 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				break;
#line 299 "rygel-media-export-harvester.c"
			}
#line 47 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp12_ = _file_list;
#line 47 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp13_ = _file_index;
#line 47 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp14_ = gee_abstract_list_get ((GeeAbstractList*) _tmp12_, _tmp13_);
#line 47 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			file = (GFile*) _tmp14_;
#line 48 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp15_ = file;
#line 48 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp16_ = g_file_query_exists (_tmp15_, NULL);
#line 48 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			if (_tmp16_) {
#line 315 "rygel-media-export-harvester.c"
				GeeArrayList* _tmp17_;
				GFile* _tmp18_;
#line 49 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				_tmp17_ = self->priv->_locations;
#line 49 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				_tmp18_ = file;
#line 49 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp17_, _tmp18_);
#line 324 "rygel-media-export-harvester.c"
			}
#line 47 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_g_object_unref0 (file);
#line 328 "rygel-media-export-harvester.c"
		}
#line 47 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_g_object_unref0 (_file_list);
#line 332 "rygel-media-export-harvester.c"
	}
#line 53 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp19_ = rygel_media_export_metadata_extractor_new ();
#line 53 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_g_object_unref0 (self->priv->extractor);
#line 53 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	self->priv->extractor = _tmp19_;
#line 55 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp20_ = cancellable;
#line 55 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp21_ = rygel_media_export_recursive_file_monitor_new (_tmp20_);
#line 55 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_g_object_unref0 (self->priv->monitor);
#line 55 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	self->priv->monitor = _tmp21_;
#line 56 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp22_ = self->priv->monitor;
#line 56 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	g_signal_connect_object (_tmp22_, "changed", (GCallback) _rygel_media_export_harvester_on_file_changed_rygel_media_export_recursive_file_monitor_changed, self, 0);
#line 58 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp23_ = gee_hash_map_new (G_TYPE_FILE, (GBoxedCopyFunc) g_object_ref, g_object_unref, RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK, (GBoxedCopyFunc) g_object_ref, g_object_unref, _g_file_hash_ghash_func, (GEqualFunc) g_file_equal, NULL);
#line 58 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_g_object_unref0 (self->priv->tasks);
#line 58 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	self->priv->tasks = _tmp23_;
#line 60 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp24_ = gee_hash_map_new (G_TYPE_FILE, (GBoxedCopyFunc) g_object_ref, g_object_unref, G_TYPE_UINT, NULL, NULL, _g_file_hash_ghash_func, (GEqualFunc) g_file_equal, NULL);
#line 60 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_g_object_unref0 (self->priv->extraction_grace_timers);
#line 60 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	self->priv->extraction_grace_timers = _tmp24_;
#line 43 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	return self;
#line 366 "rygel-media-export-harvester.c"
}


RygelMediaExportHarvester* rygel_media_export_harvester_new (GCancellable* cancellable, GeeArrayList* locations) {
#line 43 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	return rygel_media_export_harvester_construct (RYGEL_MEDIA_EXPORT_TYPE_HARVESTER, cancellable, locations);
#line 373 "rygel-media-export-harvester.c"
}


/**
     * Put a file on queue for meta-data extraction
     *
     * @param file the file to investigate
     * @param parent container of the filer to be harvested
     * @param flag optional flag for the container to set in the database
     */
static void _rygel_media_export_harvester_on_file_harvested_rygel_state_machine_completed (RygelStateMachine* _sender, gpointer self) {
#line 90 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	rygel_media_export_harvester_on_file_harvested (self, _sender);
#line 387 "rygel-media-export-harvester.c"
}


void rygel_media_export_harvester_schedule (RygelMediaExportHarvester* self, GFile* file, RygelMediaContainer* parent, const gchar* flag) {
	GeeHashMap* _tmp0_;
	GFile* _tmp1_;
	RygelMediaExportMetadataExtractor* _tmp2_;
	GFile* _tmp4_;
	RygelMediaExportMetadataExtractor* _tmp5_;
	RygelMediaExportMetadataExtractor* _tmp6_;
	RygelMediaExportRecursiveFileMonitor* _tmp7_;
	GFile* _tmp8_;
	RygelMediaContainer* _tmp9_;
	const gchar* _tmp10_;
	RygelMediaExportHarvestingTask* _tmp11_;
	RygelMediaExportHarvestingTask* _tmp12_;
	RygelMediaExportHarvestingTask* task;
	RygelMediaExportHarvestingTask* _tmp13_;
	GCancellable* _tmp14_;
	RygelMediaExportHarvestingTask* _tmp15_;
	GeeHashMap* _tmp16_;
	GFile* _tmp17_;
	RygelMediaExportHarvestingTask* _tmp18_;
	RygelMediaExportHarvestingTask* _tmp19_;
#line 71 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	g_return_if_fail (self != NULL);
#line 71 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	g_return_if_fail (file != NULL);
#line 71 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	g_return_if_fail (parent != NULL);
#line 74 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp0_ = self->priv->extraction_grace_timers;
#line 74 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp1_ = file;
#line 74 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	gee_abstract_map_unset ((GeeAbstractMap*) _tmp0_, _tmp1_, NULL);
#line 75 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp2_ = self->priv->extractor;
#line 75 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	if (_tmp2_ == NULL) {
#line 428 "rygel-media-export-harvester.c"
		const gchar* _tmp3_ = NULL;
#line 76 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp3_ = _ ("No metadata extractor available. Will not crawl.");
#line 76 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		g_warning ("rygel-media-export-harvester.vala:76: %s", _tmp3_);
#line 78 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		return;
#line 436 "rygel-media-export-harvester.c"
	}
#line 82 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp4_ = file;
#line 82 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	rygel_media_export_harvester_cancel (self, _tmp4_);
#line 84 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp5_ = rygel_media_export_metadata_extractor_new ();
#line 84 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp6_ = _tmp5_;
#line 84 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp7_ = self->priv->monitor;
#line 84 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp8_ = file;
#line 84 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp9_ = parent;
#line 84 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp10_ = flag;
#line 84 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp11_ = rygel_media_export_harvesting_task_new (_tmp6_, _tmp7_, _tmp8_, _tmp9_, _tmp10_);
#line 84 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp12_ = _tmp11_;
#line 84 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_g_object_unref0 (_tmp6_);
#line 84 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	task = _tmp12_;
#line 89 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp13_ = task;
#line 89 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp14_ = self->priv->cancellable;
#line 89 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	rygel_state_machine_set_cancellable ((RygelStateMachine*) _tmp13_, _tmp14_);
#line 90 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp15_ = task;
#line 90 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	g_signal_connect_object ((RygelStateMachine*) _tmp15_, "completed", (GCallback) _rygel_media_export_harvester_on_file_harvested_rygel_state_machine_completed, self, 0);
#line 91 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp16_ = self->priv->tasks;
#line 91 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp17_ = file;
#line 91 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp18_ = task;
#line 91 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	gee_abstract_map_set ((GeeAbstractMap*) _tmp16_, _tmp17_, _tmp18_);
#line 92 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp19_ = task;
#line 92 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	rygel_state_machine_run ((RygelStateMachine*) _tmp19_, NULL, NULL);
#line 71 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_g_object_unref0 (task);
#line 486 "rygel-media-export-harvester.c"
}


/**
     * Cancel a running meta-data extraction run
     *
     * @param file file cancel the current run for
     */
void rygel_media_export_harvester_cancel (RygelMediaExportHarvester* self, GFile* file) {
	GeeHashMap* _tmp0_;
	GFile* _tmp1_;
	gboolean _tmp2_ = FALSE;
#line 100 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	g_return_if_fail (self != NULL);
#line 100 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	g_return_if_fail (file != NULL);
#line 101 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp0_ = self->priv->tasks;
#line 101 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp1_ = file;
#line 101 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp2_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, _tmp1_);
#line 101 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	if (_tmp2_) {
#line 511 "rygel-media-export-harvester.c"
		GeeHashMap* _tmp3_;
		GFile* _tmp4_;
		gpointer _tmp5_ = NULL;
		RygelMediaExportHarvestingTask* task;
		RygelMediaExportHarvestingTask* _tmp6_;
		guint _tmp7_ = 0U;
		GeeHashMap* _tmp8_;
		GFile* _tmp9_;
		RygelMediaExportHarvestingTask* _tmp10_;
#line 102 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp3_ = self->priv->tasks;
#line 102 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp4_ = file;
#line 102 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp5_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp3_, _tmp4_);
#line 102 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		task = (RygelMediaExportHarvestingTask*) _tmp5_;
#line 103 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp6_ = task;
#line 103 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		g_signal_parse_name ("completed", RYGEL_TYPE_STATE_MACHINE, &_tmp7_, NULL, FALSE);
#line 103 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		g_signal_handlers_disconnect_matched ((RygelStateMachine*) _tmp6_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp7_, 0, NULL, (GCallback) _rygel_media_export_harvester_on_file_harvested_rygel_state_machine_completed, self);
#line 104 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp8_ = self->priv->tasks;
#line 104 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp9_ = file;
#line 104 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		gee_abstract_map_unset ((GeeAbstractMap*) _tmp8_, _tmp9_, NULL);
#line 105 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp10_ = task;
#line 105 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		rygel_media_export_harvesting_task_cancel (_tmp10_);
#line 101 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_g_object_unref0 (task);
#line 547 "rygel-media-export-harvester.c"
	}
}


/**
     * Callback for finished harvester.
     *
     * Updates book-keeping hash.
     * @param state_machine HarvestingTask sending the event
     */
static void rygel_media_export_harvester_on_file_harvested (RygelMediaExportHarvester* self, RygelStateMachine* state_machine) {
	RygelStateMachine* _tmp0_;
	RygelMediaExportHarvestingTask* _tmp1_;
	RygelMediaExportHarvestingTask* task;
	RygelMediaExportHarvestingTask* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	GFile* file;
	const gchar* _tmp5_ = NULL;
	GFile* _tmp6_;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	GeeHashMap* _tmp9_;
	GFile* _tmp10_;
	GeeHashMap* _tmp11_;
	gboolean _tmp12_;
	gboolean _tmp13_;
#line 115 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	g_return_if_fail (self != NULL);
#line 115 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	g_return_if_fail (state_machine != NULL);
#line 116 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp0_ = state_machine;
#line 116 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp1_ = _g_object_ref0 (RYGEL_MEDIA_EXPORT_IS_HARVESTING_TASK (_tmp0_) ? ((RygelMediaExportHarvestingTask*) _tmp0_) : NULL);
#line 116 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	task = _tmp1_;
#line 117 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp2_ = task;
#line 117 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp3_ = _tmp2_->origin;
#line 117 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 117 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	file = _tmp4_;
#line 118 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp5_ = _ ("'%s' harvested");
#line 118 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp6_ = file;
#line 118 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp7_ = g_file_get_uri (_tmp6_);
#line 118 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp8_ = _tmp7_;
#line 118 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	g_message (_tmp5_, _tmp8_);
#line 118 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_g_free0 (_tmp8_);
#line 120 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp9_ = self->priv->tasks;
#line 120 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp10_ = file;
#line 120 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	gee_abstract_map_unset ((GeeAbstractMap*) _tmp9_, _tmp10_, NULL);
#line 121 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp11_ = self->priv->tasks;
#line 121 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp12_ = gee_abstract_map_get_is_empty ((GeeAbstractMap*) _tmp11_);
#line 121 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp13_ = _tmp12_;
#line 121 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	if (_tmp13_) {
#line 122 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		g_signal_emit_by_name (self, "done");
#line 621 "rygel-media-export-harvester.c"
	}
#line 115 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_g_object_unref0 (file);
#line 115 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_g_object_unref0 (task);
#line 627 "rygel-media-export-harvester.c"
}


static void rygel_media_export_harvester_on_file_changed (RygelMediaExportHarvester* self, GFile* file, GFile* other, GFileMonitorEvent event) {
	GError * _inner_error_ = NULL;
#line 126 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	g_return_if_fail (self != NULL);
#line 126 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	g_return_if_fail (file != NULL);
#line 637 "rygel-media-export-harvester.c"
	{
		GFileMonitorEvent _tmp0_;
#line 130 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp0_ = event;
#line 130 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		switch (_tmp0_) {
#line 130 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			case G_FILE_MONITOR_EVENT_CREATED:
#line 130 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			case G_FILE_MONITOR_EVENT_CHANGES_DONE_HINT:
#line 648 "rygel-media-export-harvester.c"
			{
				GFile* _tmp1_;
#line 133 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				_tmp1_ = file;
#line 133 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				rygel_media_export_harvester_on_changes_done (self, _tmp1_, &_inner_error_);
#line 133 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				if (_inner_error_ != NULL) {
#line 657 "rygel-media-export-harvester.c"
					goto __catch46_g_error;
				}
#line 134 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				break;
#line 662 "rygel-media-export-harvester.c"
			}
#line 130 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			case G_FILE_MONITOR_EVENT_DELETED:
#line 666 "rygel-media-export-harvester.c"
			{
				GFile* _tmp2_;
#line 136 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				_tmp2_ = file;
#line 136 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				rygel_media_export_harvester_on_file_removed (self, _tmp2_, &_inner_error_);
#line 136 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				if (_inner_error_ != NULL) {
#line 675 "rygel-media-export-harvester.c"
					goto __catch46_g_error;
				}
#line 137 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				break;
#line 680 "rygel-media-export-harvester.c"
			}
			default:
			{
#line 139 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				break;
#line 686 "rygel-media-export-harvester.c"
			}
		}
	}
	goto __finally46;
	__catch46_g_error:
	{
		GError* _error_ = NULL;
#line 129 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_error_ = _inner_error_;
#line 129 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_inner_error_ = NULL;
#line 129 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_g_error_free0 (_error_);
#line 700 "rygel-media-export-harvester.c"
	}
	__finally46:
#line 129 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	if (_inner_error_ != NULL) {
#line 129 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 129 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		g_clear_error (&_inner_error_);
#line 129 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		return;
#line 711 "rygel-media-export-harvester.c"
	}
}


static void rygel_media_export_harvester_on_file_added (RygelMediaExportHarvester* self, GFile* file) {
	GFile* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	GError * _inner_error_ = NULL;
#line 144 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	g_return_if_fail (self != NULL);
#line 144 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	g_return_if_fail (file != NULL);
#line 145 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp0_ = file;
#line 145 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp1_ = g_file_get_uri (_tmp0_);
#line 145 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp2_ = _tmp1_;
#line 145 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	g_debug ("rygel-media-export-harvester.vala:145: Filesystem events settled for %" \
"s, scheduling extraction…", _tmp2_);
#line 145 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_g_free0 (_tmp2_);
#line 735 "rygel-media-export-harvester.c"
	{
		RygelMediaExportMediaCache* _tmp3_ = NULL;
		RygelMediaExportMediaCache* cache;
		GFile* _tmp4_;
		GCancellable* _tmp5_;
		GFileInfo* _tmp6_ = NULL;
		GFileInfo* info;
		gboolean _tmp7_ = FALSE;
		gboolean _tmp8_ = FALSE;
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
		GFileInfo* _tmp11_;
		GFileType _tmp12_ = 0;
		gboolean _tmp16_;
		gboolean _tmp20_;
		gboolean _tmp24_;
		gboolean _tmp27_;
#line 148 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp3_ = rygel_media_export_media_cache_get_default (&_inner_error_);
#line 148 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		cache = _tmp3_;
#line 148 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		if (_inner_error_ != NULL) {
#line 759 "rygel-media-export-harvester.c"
			goto __catch47_g_error;
		}
#line 149 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp4_ = file;
#line 149 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp5_ = self->priv->cancellable;
#line 149 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp6_ = g_file_query_info (_tmp4_, G_FILE_ATTRIBUTE_STANDARD_TYPE "," G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE, G_FILE_QUERY_INFO_NONE, _tmp5_, &_inner_error_);
#line 149 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		info = _tmp6_;
#line 149 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		if (_inner_error_ != NULL) {
#line 149 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_g_object_unref0 (cache);
#line 774 "rygel-media-export-harvester.c"
			goto __catch47_g_error;
		}
#line 153 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp11_ = info;
#line 153 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp12_ = g_file_info_get_file_type (_tmp11_);
#line 153 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		if (_tmp12_ == G_FILE_TYPE_DIRECTORY) {
#line 153 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp10_ = TRUE;
#line 785 "rygel-media-export-harvester.c"
		} else {
			GFileInfo* _tmp13_;
			const gchar* _tmp14_ = NULL;
			gboolean _tmp15_ = FALSE;
#line 154 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp13_ = info;
#line 154 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp14_ = g_file_info_get_content_type (_tmp13_);
#line 154 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp15_ = g_str_has_prefix (_tmp14_, "image/");
#line 154 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp10_ = _tmp15_;
#line 798 "rygel-media-export-harvester.c"
		}
#line 153 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp16_ = _tmp10_;
#line 153 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		if (_tmp16_) {
#line 153 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp9_ = TRUE;
#line 806 "rygel-media-export-harvester.c"
		} else {
			GFileInfo* _tmp17_;
			const gchar* _tmp18_ = NULL;
			gboolean _tmp19_ = FALSE;
#line 155 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp17_ = info;
#line 155 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp18_ = g_file_info_get_content_type (_tmp17_);
#line 155 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp19_ = g_str_has_prefix (_tmp18_, "video/");
#line 155 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp9_ = _tmp19_;
#line 819 "rygel-media-export-harvester.c"
		}
#line 153 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp20_ = _tmp9_;
#line 153 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		if (_tmp20_) {
#line 153 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp8_ = TRUE;
#line 827 "rygel-media-export-harvester.c"
		} else {
			GFileInfo* _tmp21_;
			const gchar* _tmp22_ = NULL;
			gboolean _tmp23_ = FALSE;
#line 156 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp21_ = info;
#line 156 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp22_ = g_file_info_get_content_type (_tmp21_);
#line 156 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp23_ = g_str_has_prefix (_tmp22_, "audio/");
#line 156 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp8_ = _tmp23_;
#line 840 "rygel-media-export-harvester.c"
		}
#line 153 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp24_ = _tmp8_;
#line 153 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		if (_tmp24_) {
#line 153 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp7_ = TRUE;
#line 848 "rygel-media-export-harvester.c"
		} else {
			GFileInfo* _tmp25_;
			const gchar* _tmp26_ = NULL;
#line 157 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp25_ = info;
#line 157 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp26_ = g_file_info_get_content_type (_tmp25_);
#line 157 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp7_ = g_strcmp0 (_tmp26_, "application/ogg") == 0;
#line 858 "rygel-media-export-harvester.c"
		}
#line 153 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp27_ = _tmp7_;
#line 153 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		if (_tmp27_) {
#line 864 "rygel-media-export-harvester.c"
			gchar* id = NULL;
			{
				RygelMediaContainer* parent_container;
				GFile* _tmp28_;
				GFile* _tmp29_;
				GFile* current;
				GFile* _tmp50_;
				RygelMediaContainer* _tmp51_;
#line 160 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				parent_container = NULL;
#line 161 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				_tmp28_ = file;
#line 161 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				_tmp29_ = _g_object_ref0 (_tmp28_);
#line 161 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				current = _tmp29_;
#line 881 "rygel-media-export-harvester.c"
				{
					gboolean _tmp30_;
#line 162 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
					_tmp30_ = TRUE;
#line 162 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
					while (TRUE) {
#line 888 "rygel-media-export-harvester.c"
						gboolean _tmp31_;
						GFile* _tmp33_;
						GFile* _tmp34_ = NULL;
						GFile* parent;
						GFile* _tmp35_;
						gchar* _tmp36_ = NULL;
						RygelMediaExportMediaCache* _tmp37_;
						const gchar* _tmp38_;
						RygelMediaObject* _tmp39_ = NULL;
						RygelMediaObject* _tmp40_;
						RygelMediaContainer* _tmp41_;
						GeeArrayList* _tmp44_;
						GFile* _tmp45_;
						gboolean _tmp46_ = FALSE;
#line 162 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
						_tmp31_ = _tmp30_;
#line 162 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
						if (!_tmp31_) {
#line 907 "rygel-media-export-harvester.c"
							RygelMediaContainer* _tmp32_;
#line 180 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
							_tmp32_ = parent_container;
#line 180 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
							if (!(_tmp32_ == NULL)) {
#line 180 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
								break;
#line 915 "rygel-media-export-harvester.c"
							}
						}
#line 162 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
						_tmp30_ = FALSE;
#line 163 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
						_tmp33_ = current;
#line 163 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
						_tmp34_ = g_file_get_parent (_tmp33_);
#line 163 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
						parent = _tmp34_;
#line 164 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
						_tmp35_ = parent;
#line 164 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
						_tmp36_ = rygel_media_export_media_cache_get_id (_tmp35_);
#line 164 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
						_g_free0 (id);
#line 164 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
						id = _tmp36_;
#line 165 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
						_tmp37_ = cache;
#line 165 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
						_tmp38_ = id;
#line 165 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
						_tmp39_ = rygel_media_export_media_cache_get_object (_tmp37_, _tmp38_, &_inner_error_);
#line 165 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
						_tmp40_ = _tmp39_;
#line 165 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
						if (_inner_error_ != NULL) {
#line 165 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
							_g_object_unref0 (parent);
#line 165 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
							_g_object_unref0 (current);
#line 165 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
							_g_object_unref0 (parent_container);
#line 165 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
							if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 952 "rygel-media-export-harvester.c"
								goto __catch48_rygel_media_export_database_error;
							}
#line 165 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
							_g_object_unref0 (parent);
#line 165 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
							_g_object_unref0 (current);
#line 165 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
							_g_object_unref0 (parent_container);
#line 165 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
							_g_free0 (id);
#line 165 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
							_g_object_unref0 (info);
#line 165 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
							_g_object_unref0 (cache);
#line 165 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
							g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 165 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
							g_clear_error (&_inner_error_);
#line 165 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
							return;
#line 973 "rygel-media-export-harvester.c"
						}
#line 165 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
						_g_object_unref0 (parent_container);
#line 165 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
						parent_container = RYGEL_IS_MEDIA_CONTAINER (_tmp40_) ? ((RygelMediaContainer*) _tmp40_) : NULL;
#line 168 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
						_tmp41_ = parent_container;
#line 168 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
						if (_tmp41_ == NULL) {
#line 983 "rygel-media-export-harvester.c"
							GFile* _tmp42_;
							GFile* _tmp43_;
#line 169 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
							_tmp42_ = parent;
#line 169 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
							_tmp43_ = _g_object_ref0 (_tmp42_);
#line 169 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
							_g_object_unref0 (current);
#line 169 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
							current = _tmp43_;
#line 994 "rygel-media-export-harvester.c"
						}
#line 172 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
						_tmp44_ = self->priv->_locations;
#line 172 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
						_tmp45_ = current;
#line 172 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
						_tmp46_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp44_, _tmp45_);
#line 172 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
						if (_tmp46_) {
#line 1004 "rygel-media-export-harvester.c"
							RygelMediaExportMediaCache* _tmp47_;
							RygelMediaObject* _tmp48_ = NULL;
							RygelMediaObject* _tmp49_;
#line 174 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
							_tmp47_ = cache;
#line 174 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
							_tmp48_ = rygel_media_export_media_cache_get_object (_tmp47_, RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_FILESYSTEM_FOLDER_ID, &_inner_error_);
#line 174 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
							_tmp49_ = _tmp48_;
#line 174 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
							if (_inner_error_ != NULL) {
#line 174 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
								_g_object_unref0 (parent);
#line 174 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
								_g_object_unref0 (current);
#line 174 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
								_g_object_unref0 (parent_container);
#line 174 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
								if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 1024 "rygel-media-export-harvester.c"
									goto __catch48_rygel_media_export_database_error;
								}
#line 174 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
								_g_object_unref0 (parent);
#line 174 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
								_g_object_unref0 (current);
#line 174 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
								_g_object_unref0 (parent_container);
#line 174 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
								_g_free0 (id);
#line 174 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
								_g_object_unref0 (info);
#line 174 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
								_g_object_unref0 (cache);
#line 174 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
								g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 174 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
								g_clear_error (&_inner_error_);
#line 174 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
								return;
#line 1045 "rygel-media-export-harvester.c"
							}
#line 174 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
							_g_object_unref0 (parent_container);
#line 174 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
							parent_container = RYGEL_IS_MEDIA_CONTAINER (_tmp49_) ? ((RygelMediaContainer*) _tmp49_) : NULL;
#line 178 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
							_g_object_unref0 (parent);
#line 178 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
							break;
#line 1055 "rygel-media-export-harvester.c"
						}
#line 162 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
						_g_object_unref0 (parent);
#line 1059 "rygel-media-export-harvester.c"
					}
				}
#line 182 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				_tmp50_ = current;
#line 182 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				_tmp51_ = parent_container;
#line 182 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				rygel_media_export_harvester_schedule (self, _tmp50_, _tmp51_, NULL);
#line 159 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				_g_object_unref0 (current);
#line 159 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				_g_object_unref0 (parent_container);
#line 1072 "rygel-media-export-harvester.c"
			}
			goto __finally48;
			__catch48_rygel_media_export_database_error:
			{
				GError* _error_ = NULL;
				const gchar* _tmp52_ = NULL;
				const gchar* _tmp53_;
				GError* _tmp54_;
				const gchar* _tmp55_;
#line 159 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				_error_ = _inner_error_;
#line 159 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				_inner_error_ = NULL;
#line 184 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				_tmp52_ = _ ("Error fetching object '%s' from database: %s");
#line 184 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				_tmp53_ = id;
#line 184 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				_tmp54_ = _error_;
#line 184 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				_tmp55_ = _tmp54_->message;
#line 184 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				g_warning (_tmp52_, _tmp53_, _tmp55_);
#line 159 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				_g_error_free0 (_error_);
#line 1098 "rygel-media-export-harvester.c"
			}
			__finally48:
#line 159 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			if (_inner_error_ != NULL) {
#line 159 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				_g_free0 (id);
#line 159 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				_g_object_unref0 (info);
#line 159 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				_g_object_unref0 (cache);
#line 1109 "rygel-media-export-harvester.c"
				goto __catch47_g_error;
			}
#line 153 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_g_free0 (id);
#line 1114 "rygel-media-export-harvester.c"
		} else {
			GFile* _tmp56_;
			gchar* _tmp57_ = NULL;
			gchar* _tmp58_;
#line 189 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp56_ = file;
#line 189 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp57_ = g_file_get_uri (_tmp56_);
#line 189 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp58_ = _tmp57_;
#line 189 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			g_debug ("rygel-media-export-harvester.vala:189: %s is not eligible for extracti" \
"on", _tmp58_);
#line 189 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_g_free0 (_tmp58_);
#line 1129 "rygel-media-export-harvester.c"
		}
#line 147 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_g_object_unref0 (info);
#line 147 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_g_object_unref0 (cache);
#line 1135 "rygel-media-export-harvester.c"
	}
	goto __finally47;
	__catch47_g_error:
	{
		GError* _error_ = NULL;
		const gchar* _tmp59_ = NULL;
		GError* _tmp60_;
		const gchar* _tmp61_;
#line 147 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_error_ = _inner_error_;
#line 147 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_inner_error_ = NULL;
#line 192 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp59_ = _ ("Failed to access media cache: %s");
#line 192 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp60_ = _error_;
#line 192 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp61_ = _tmp60_->message;
#line 192 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		g_warning (_tmp59_, _tmp61_);
#line 147 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_g_error_free0 (_error_);
#line 1158 "rygel-media-export-harvester.c"
	}
	__finally47:
#line 147 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	if (_inner_error_ != NULL) {
#line 147 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 147 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		g_clear_error (&_inner_error_);
#line 147 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		return;
#line 1169 "rygel-media-export-harvester.c"
	}
}


static void rygel_media_export_harvester_on_file_removed (RygelMediaExportHarvester* self, GFile* file, GError** error) {
	RygelMediaExportMediaCache* _tmp0_ = NULL;
	RygelMediaExportMediaCache* cache;
	GeeHashMap* _tmp1_;
	GFile* _tmp2_;
	gboolean _tmp3_ = FALSE;
	GFile* _tmp9_;
	GError * _inner_error_ = NULL;
#line 196 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	g_return_if_fail (self != NULL);
#line 196 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	g_return_if_fail (file != NULL);
#line 197 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp0_ = rygel_media_export_media_cache_get_default (&_inner_error_);
#line 197 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	cache = _tmp0_;
#line 197 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	if (_inner_error_ != NULL) {
#line 197 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		g_propagate_error (error, _inner_error_);
#line 197 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		return;
#line 1196 "rygel-media-export-harvester.c"
	}
#line 198 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp1_ = self->priv->extraction_grace_timers;
#line 198 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp2_ = file;
#line 198 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp3_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp1_, _tmp2_);
#line 198 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	if (_tmp3_) {
#line 1206 "rygel-media-export-harvester.c"
		GeeHashMap* _tmp4_;
		GFile* _tmp5_;
		gpointer _tmp6_ = NULL;
		GeeHashMap* _tmp7_;
		GFile* _tmp8_;
#line 199 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp4_ = self->priv->extraction_grace_timers;
#line 199 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp5_ = file;
#line 199 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp6_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp4_, _tmp5_);
#line 199 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		g_source_remove (GPOINTER_TO_UINT (_tmp6_));
#line 200 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp7_ = self->priv->extraction_grace_timers;
#line 200 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp8_ = file;
#line 200 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		gee_abstract_map_unset ((GeeAbstractMap*) _tmp7_, _tmp8_, NULL);
#line 1226 "rygel-media-export-harvester.c"
	}
#line 203 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp9_ = file;
#line 203 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	rygel_media_export_harvester_cancel (self, _tmp9_);
#line 1232 "rygel-media-export-harvester.c"
	{
		GFile* _tmp10_;
		gchar* _tmp11_ = NULL;
		gchar* id;
		const gchar* _tmp12_;
		RygelMediaObject* _tmp13_ = NULL;
		RygelMediaObject* object;
		RygelMediaContainer* _tmp14_;
		RygelMediaContainer* parent;
		RygelMediaContainer* _tmp27_;
#line 208 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp10_ = file;
#line 208 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp11_ = rygel_media_export_media_cache_get_id (_tmp10_);
#line 208 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		id = _tmp11_;
#line 209 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp12_ = id;
#line 209 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp13_ = rygel_media_export_media_cache_get_object (cache, _tmp12_, &_inner_error_);
#line 209 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		object = _tmp13_;
#line 209 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		if (_inner_error_ != NULL) {
#line 209 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_g_free0 (id);
#line 1259 "rygel-media-export-harvester.c"
			goto __catch49_g_error;
		}
#line 210 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp14_ = _g_object_ref0 (RYGEL_IS_MEDIA_CONTAINER (NULL) ? ((RygelMediaContainer*) NULL) : NULL);
#line 210 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		parent = _tmp14_;
#line 212 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		while (TRUE) {
#line 1268 "rygel-media-export-harvester.c"
			RygelMediaObject* _tmp15_;
			RygelMediaObject* _tmp16_;
			RygelMediaContainer* _tmp17_;
			RygelMediaContainer* _tmp18_;
			RygelMediaObject* _tmp19_;
			RygelMediaContainer* _tmp20_;
			RygelMediaContainer* _tmp21_;
			gint _tmp22_;
			RygelMediaContainer* _tmp23_;
			gint _tmp24_;
			RygelMediaContainer* _tmp25_;
			RygelMediaObject* _tmp26_;
#line 212 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp15_ = object;
#line 212 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			if (!(_tmp15_ != NULL)) {
#line 212 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				break;
#line 1287 "rygel-media-export-harvester.c"
			}
#line 213 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp16_ = object;
#line 213 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp17_ = _tmp16_->parent;
#line 213 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp18_ = _g_object_ref0 (_tmp17_);
#line 213 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_g_object_unref0 (parent);
#line 213 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			parent = _tmp18_;
#line 214 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp19_ = object;
#line 214 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			rygel_media_export_media_cache_remove_object (cache, _tmp19_, &_inner_error_);
#line 214 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			if (_inner_error_ != NULL) {
#line 214 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				_g_object_unref0 (parent);
#line 214 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				_g_object_unref0 (object);
#line 214 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				_g_free0 (id);
#line 1311 "rygel-media-export-harvester.c"
				goto __catch49_g_error;
			}
#line 215 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp20_ = parent;
#line 215 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			if (_tmp20_ == NULL) {
#line 216 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				break;
#line 1320 "rygel-media-export-harvester.c"
			}
#line 219 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp21_ = parent;
#line 219 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp22_ = _tmp21_->child_count;
#line 219 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp21_->child_count = _tmp22_ - 1;
#line 220 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp23_ = parent;
#line 220 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp24_ = _tmp23_->child_count;
#line 220 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			if (_tmp24_ != 0) {
#line 221 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				break;
#line 1336 "rygel-media-export-harvester.c"
			}
#line 224 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp25_ = parent;
#line 224 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp26_ = _g_object_ref0 ((RygelMediaObject*) _tmp25_);
#line 224 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_g_object_unref0 (object);
#line 224 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			object = _tmp26_;
#line 1346 "rygel-media-export-harvester.c"
		}
#line 227 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp27_ = parent;
#line 227 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		if (_tmp27_ != NULL) {
#line 1352 "rygel-media-export-harvester.c"
			RygelMediaContainer* _tmp28_;
#line 228 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp28_ = parent;
#line 228 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			rygel_media_container_updated (_tmp28_);
#line 1358 "rygel-media-export-harvester.c"
		}
#line 204 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_g_object_unref0 (parent);
#line 204 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_g_object_unref0 (object);
#line 204 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_g_free0 (id);
#line 1366 "rygel-media-export-harvester.c"
	}
	goto __finally49;
	__catch49_g_error:
	{
		GError* _error_ = NULL;
		const gchar* _tmp29_ = NULL;
		GError* _tmp30_;
		const gchar* _tmp31_;
#line 204 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_error_ = _inner_error_;
#line 204 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_inner_error_ = NULL;
#line 231 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp29_ = _ ("Error removing object from database: %s");
#line 231 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp30_ = _error_;
#line 231 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp31_ = _tmp30_->message;
#line 231 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		g_warning (_tmp29_, _tmp31_);
#line 204 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_g_error_free0 (_error_);
#line 1389 "rygel-media-export-harvester.c"
	}
	__finally49:
#line 204 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	if (_inner_error_ != NULL) {
#line 204 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		g_propagate_error (error, _inner_error_);
#line 204 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_g_object_unref0 (cache);
#line 204 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		return;
#line 1400 "rygel-media-export-harvester.c"
	}
#line 196 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_g_object_unref0 (cache);
#line 1404 "rygel-media-export-harvester.c"
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
#line 236 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	g_atomic_int_inc (&_data3_->_ref_count_);
#line 236 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	return _data3_;
#line 1413 "rygel-media-export-harvester.c"
}


static void block3_data_unref (void * _userdata_) {
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
#line 236 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
#line 1422 "rygel-media-export-harvester.c"
		RygelMediaExportHarvester * self;
#line 236 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		self = _data3_->self;
#line 236 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_g_object_unref0 (_data3_->file);
#line 236 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_g_object_unref0 (self);
#line 236 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		g_slice_free (Block3Data, _data3_);
#line 1432 "rygel-media-export-harvester.c"
	}
}


static gboolean __lambda2_ (Block3Data* _data3_) {
	RygelMediaExportHarvester * self;
	gboolean result = FALSE;
	GFile* _tmp0_;
#line 244 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	self = _data3_->self;
#line 245 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp0_ = _data3_->file;
#line 245 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	rygel_media_export_harvester_on_file_added (self, _tmp0_);
#line 247 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	result = FALSE;
#line 247 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	return result;
#line 1451 "rygel-media-export-harvester.c"
}


static gboolean ___lambda2__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda2_ (self);
#line 244 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	return result;
#line 1460 "rygel-media-export-harvester.c"
}


static void rygel_media_export_harvester_on_changes_done (RygelMediaExportHarvester* self, GFile* file, GError** error) {
	Block3Data* _data3_;
	GFile* _tmp0_;
	GFile* _tmp1_;
	GeeHashMap* _tmp2_;
	GFile* _tmp3_;
	gboolean _tmp4_ = FALSE;
	GSourceFunc callback;
	void* callback_target;
	GDestroyNotify callback_target_destroy_notify;
	GSourceFunc _tmp11_;
	void* _tmp11__target;
	GDestroyNotify _tmp11__target_destroy_notify;
	guint _tmp12_ = 0U;
	guint timeout;
	GeeHashMap* _tmp13_;
	GFile* _tmp14_;
#line 236 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	g_return_if_fail (self != NULL);
#line 236 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	g_return_if_fail (file != NULL);
#line 236 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_data3_ = g_slice_new0 (Block3Data);
#line 236 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_data3_->_ref_count_ = 1;
#line 236 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_data3_->self = g_object_ref (self);
#line 236 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp0_ = file;
#line 236 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 236 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_data3_->file = _tmp1_;
#line 237 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp2_ = self->priv->extraction_grace_timers;
#line 237 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp3_ = _data3_->file;
#line 237 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp4_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp2_, _tmp3_);
#line 237 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	if (_tmp4_) {
#line 1505 "rygel-media-export-harvester.c"
		GeeHashMap* _tmp5_;
		GFile* _tmp6_;
		gpointer _tmp7_ = NULL;
#line 238 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp5_ = self->priv->extraction_grace_timers;
#line 238 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp6_ = _data3_->file;
#line 238 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp7_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp5_, _tmp6_);
#line 238 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		g_source_remove (GPOINTER_TO_UINT (_tmp7_));
#line 1517 "rygel-media-export-harvester.c"
	} else {
		GFile* _tmp8_;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_;
#line 240 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp8_ = _data3_->file;
#line 240 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp9_ = g_file_get_uri (_tmp8_);
#line 240 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp10_ = _tmp9_;
#line 240 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		g_debug ("rygel-media-export-harvester.vala:240: Starting grace timer for harves" \
"ting %s…", _tmp10_);
#line 240 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_g_free0 (_tmp10_);
#line 1532 "rygel-media-export-harvester.c"
	}
#line 244 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	callback = ___lambda2__gsource_func;
#line 244 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	callback_target = block3_data_ref (_data3_);
#line 244 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	callback_target_destroy_notify = block3_data_unref;
#line 250 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp11_ = callback;
#line 250 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp11__target = callback_target;
#line 250 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp11__target_destroy_notify = callback_target_destroy_notify;
#line 250 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	callback_target_destroy_notify = NULL;
#line 250 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp12_ = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, RYGEL_MEDIA_EXPORT_HARVESTER_FILE_CHANGE_DEFAULT_GRACE_PERIOD, _tmp11_, _tmp11__target, _tmp11__target_destroy_notify);
#line 250 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	timeout = _tmp12_;
#line 252 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp13_ = self->priv->extraction_grace_timers;
#line 252 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp14_ = _data3_->file;
#line 252 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	gee_abstract_map_set ((GeeAbstractMap*) _tmp13_, _tmp14_, GUINT_TO_POINTER (timeout));
#line 236 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	(callback_target_destroy_notify == NULL) ? NULL : (callback_target_destroy_notify (callback_target), NULL);
#line 236 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	callback = NULL;
#line 236 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	callback_target = NULL;
#line 236 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	callback_target_destroy_notify = NULL;
#line 236 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	block3_data_unref (_data3_);
#line 236 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_data3_ = NULL;
#line 1570 "rygel-media-export-harvester.c"
}


GeeArrayList* rygel_media_export_harvester_get_locations (RygelMediaExportHarvester* self) {
	GeeArrayList* result;
	GeeArrayList* _tmp0_;
#line 36 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 36 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp0_ = self->priv->_locations;
#line 36 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	result = _tmp0_;
#line 36 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	return result;
#line 1585 "rygel-media-export-harvester.c"
}


static void rygel_media_export_harvester_set_locations (RygelMediaExportHarvester* self, GeeArrayList* value) {
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
#line 36 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	g_return_if_fail (self != NULL);
#line 36 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp0_ = value;
#line 36 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 36 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_g_object_unref0 (self->priv->_locations);
#line 36 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	self->priv->_locations = _tmp1_;
#line 36 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	g_object_notify ((GObject *) self, "locations");
#line 1604 "rygel-media-export-harvester.c"
}


static void rygel_media_export_harvester_class_init (RygelMediaExportHarvesterClass * klass) {
#line 26 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	rygel_media_export_harvester_parent_class = g_type_class_peek_parent (klass);
#line 26 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	g_type_class_add_private (klass, sizeof (RygelMediaExportHarvesterPrivate));
#line 26 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_media_export_harvester_get_property;
#line 26 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_media_export_harvester_set_property;
#line 26 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_media_export_harvester_finalize;
#line 26 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_EXPORT_HARVESTER_LOCATIONS, g_param_spec_object ("locations", "locations", "locations", GEE_TYPE_ARRAY_LIST, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 26 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	g_signal_new ("done", RYGEL_MEDIA_EXPORT_TYPE_HARVESTER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 1623 "rygel-media-export-harvester.c"
}


static void rygel_media_export_harvester_instance_init (RygelMediaExportHarvester * self) {
#line 26 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	self->priv = RYGEL_MEDIA_EXPORT_HARVESTER_GET_PRIVATE (self);
#line 1630 "rygel-media-export-harvester.c"
}


static void rygel_media_export_harvester_finalize (GObject* obj) {
	RygelMediaExportHarvester * self;
#line 26 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	self = RYGEL_MEDIA_EXPORT_HARVESTER (obj);
#line 29 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_g_object_unref0 (self->priv->tasks);
#line 30 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_g_object_unref0 (self->priv->extraction_grace_timers);
#line 31 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_g_object_unref0 (self->priv->extractor);
#line 32 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_g_object_unref0 (self->priv->monitor);
#line 33 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_g_object_unref0 (self->priv->cancellable);
#line 36 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_g_object_unref0 (self->priv->_locations);
#line 26 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	G_OBJECT_CLASS (rygel_media_export_harvester_parent_class)->finalize (obj);
#line 1652 "rygel-media-export-harvester.c"
}


/**
 * This class takes care of the book-keeping of running and finished
 * extraction tasks running within the media-export plugin
 */
GType rygel_media_export_harvester_get_type (void) {
	static volatile gsize rygel_media_export_harvester_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_export_harvester_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaExportHarvesterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_export_harvester_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaExportHarvester), 0, (GInstanceInitFunc) rygel_media_export_harvester_instance_init, NULL };
		GType rygel_media_export_harvester_type_id;
		rygel_media_export_harvester_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMediaExportHarvester", &g_define_type_info, 0);
		g_once_init_leave (&rygel_media_export_harvester_type_id__volatile, rygel_media_export_harvester_type_id);
	}
	return rygel_media_export_harvester_type_id__volatile;
}


static void _vala_rygel_media_export_harvester_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelMediaExportHarvester * self;
	self = RYGEL_MEDIA_EXPORT_HARVESTER (object);
#line 26 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	switch (property_id) {
#line 26 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		case RYGEL_MEDIA_EXPORT_HARVESTER_LOCATIONS:
#line 26 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		g_value_set_object (value, rygel_media_export_harvester_get_locations (self));
#line 26 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		break;
#line 1683 "rygel-media-export-harvester.c"
		default:
#line 26 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 26 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		break;
#line 1689 "rygel-media-export-harvester.c"
	}
}


static void _vala_rygel_media_export_harvester_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelMediaExportHarvester * self;
	self = RYGEL_MEDIA_EXPORT_HARVESTER (object);
#line 26 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	switch (property_id) {
#line 26 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		case RYGEL_MEDIA_EXPORT_HARVESTER_LOCATIONS:
#line 26 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		rygel_media_export_harvester_set_locations (self, g_value_get_object (value));
#line 26 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		break;
#line 1705 "rygel-media-export-harvester.c"
		default:
#line 26 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 26 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		break;
#line 1711 "rygel-media-export-harvester.c"
	}
}



