/* rygel-media-export-media-cache.c generated by valac 0.16.1, the Vala compiler
 * generated from rygel-media-export-media-cache.vala, do not modify */

/*
 * Copyright (C) 2009,2010 Jens Georg <mail@jensge.org>.
 *
 * Author: Jens Georg <mail@jensge.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <string.h>
#include <gee.h>
#include <stdlib.h>
#include <gio/gio.h>
#include <rygel-server.h>
#include <glib/gi18n-lib.h>
#include <sqlite3.h>
#include <libgupnp-av/gupnp-av.h>


#define RYGEL_MEDIA_EXPORT_TYPE_OBJECT_TYPE (rygel_media_export_object_type_get_type ())

#define RYGEL_MEDIA_EXPORT_TYPE_EXISTS_CACHE_ENTRY (rygel_media_export_exists_cache_entry_get_type ())
typedef struct _RygelMediaExportExistsCacheEntry RygelMediaExportExistsCacheEntry;

#define RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE (rygel_media_export_media_cache_get_type ())
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCache))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCacheClass))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCacheClass))

typedef struct _RygelMediaExportMediaCache RygelMediaExportMediaCache;
typedef struct _RygelMediaExportMediaCacheClass RygelMediaExportMediaCacheClass;
typedef struct _RygelMediaExportMediaCachePrivate RygelMediaExportMediaCachePrivate;

#define RYGEL_MEDIA_EXPORT_TYPE_SQLITE_WRAPPER (rygel_media_export_sqlite_wrapper_get_type ())
#define RYGEL_MEDIA_EXPORT_SQLITE_WRAPPER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_SQLITE_WRAPPER, RygelMediaExportSqliteWrapper))
#define RYGEL_MEDIA_EXPORT_SQLITE_WRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_SQLITE_WRAPPER, RygelMediaExportSqliteWrapperClass))
#define RYGEL_MEDIA_EXPORT_IS_SQLITE_WRAPPER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_SQLITE_WRAPPER))
#define RYGEL_MEDIA_EXPORT_IS_SQLITE_WRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_SQLITE_WRAPPER))
#define RYGEL_MEDIA_EXPORT_SQLITE_WRAPPER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_SQLITE_WRAPPER, RygelMediaExportSqliteWrapperClass))

typedef struct _RygelMediaExportSqliteWrapper RygelMediaExportSqliteWrapper;
typedef struct _RygelMediaExportSqliteWrapperClass RygelMediaExportSqliteWrapperClass;

#define RYGEL_MEDIA_EXPORT_TYPE_DATABASE (rygel_media_export_database_get_type ())
#define RYGEL_MEDIA_EXPORT_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_DATABASE, RygelMediaExportDatabase))
#define RYGEL_MEDIA_EXPORT_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_DATABASE, RygelMediaExportDatabaseClass))
#define RYGEL_MEDIA_EXPORT_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_DATABASE))
#define RYGEL_MEDIA_EXPORT_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_DATABASE))
#define RYGEL_MEDIA_EXPORT_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_DATABASE, RygelMediaExportDatabaseClass))

typedef struct _RygelMediaExportDatabase RygelMediaExportDatabase;
typedef struct _RygelMediaExportDatabaseClass RygelMediaExportDatabaseClass;

#define RYGEL_MEDIA_EXPORT_TYPE_OBJECT_FACTORY (rygel_media_export_object_factory_get_type ())
#define RYGEL_MEDIA_EXPORT_OBJECT_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_OBJECT_FACTORY, RygelMediaExportObjectFactory))
#define RYGEL_MEDIA_EXPORT_OBJECT_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_OBJECT_FACTORY, RygelMediaExportObjectFactoryClass))
#define RYGEL_MEDIA_EXPORT_IS_OBJECT_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_OBJECT_FACTORY))
#define RYGEL_MEDIA_EXPORT_IS_OBJECT_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_OBJECT_FACTORY))
#define RYGEL_MEDIA_EXPORT_OBJECT_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_OBJECT_FACTORY, RygelMediaExportObjectFactoryClass))

typedef struct _RygelMediaExportObjectFactory RygelMediaExportObjectFactory;
typedef struct _RygelMediaExportObjectFactoryClass RygelMediaExportObjectFactoryClass;

#define RYGEL_MEDIA_EXPORT_TYPE_SQL_FACTORY (rygel_media_export_sql_factory_get_type ())
#define RYGEL_MEDIA_EXPORT_SQL_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_SQL_FACTORY, RygelMediaExportSQLFactory))
#define RYGEL_MEDIA_EXPORT_SQL_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_SQL_FACTORY, RygelMediaExportSQLFactoryClass))
#define RYGEL_MEDIA_EXPORT_IS_SQL_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_SQL_FACTORY))
#define RYGEL_MEDIA_EXPORT_IS_SQL_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_SQL_FACTORY))
#define RYGEL_MEDIA_EXPORT_SQL_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_SQL_FACTORY, RygelMediaExportSQLFactoryClass))

typedef struct _RygelMediaExportSQLFactory RygelMediaExportSQLFactory;
typedef struct _RygelMediaExportSQLFactoryClass RygelMediaExportSQLFactoryClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_MEDIA_EXPORT_TYPE_SQL_STRING (rygel_media_export_sql_string_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_MEDIA_EXPORT_TYPE_DATABASE_CURSOR (rygel_media_export_database_cursor_get_type ())
#define RYGEL_MEDIA_EXPORT_DATABASE_CURSOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_DATABASE_CURSOR, RygelMediaExportDatabaseCursor))
#define RYGEL_MEDIA_EXPORT_DATABASE_CURSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_DATABASE_CURSOR, RygelMediaExportDatabaseCursorClass))
#define RYGEL_MEDIA_EXPORT_IS_DATABASE_CURSOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_DATABASE_CURSOR))
#define RYGEL_MEDIA_EXPORT_IS_DATABASE_CURSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_DATABASE_CURSOR))
#define RYGEL_MEDIA_EXPORT_DATABASE_CURSOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_DATABASE_CURSOR, RygelMediaExportDatabaseCursorClass))

typedef struct _RygelMediaExportDatabaseCursor RygelMediaExportDatabaseCursor;
typedef struct _RygelMediaExportDatabaseCursorClass RygelMediaExportDatabaseCursorClass;

#define RYGEL_MEDIA_EXPORT_DATABASE_CURSOR_TYPE_ITERATOR (rygel_media_export_database_cursor_iterator_get_type ())
#define RYGEL_MEDIA_EXPORT_DATABASE_CURSOR_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_DATABASE_CURSOR_TYPE_ITERATOR, RygelMediaExportDatabaseCursorIterator))
#define RYGEL_MEDIA_EXPORT_DATABASE_CURSOR_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_DATABASE_CURSOR_TYPE_ITERATOR, RygelMediaExportDatabaseCursorIteratorClass))
#define RYGEL_MEDIA_EXPORT_DATABASE_CURSOR_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_DATABASE_CURSOR_TYPE_ITERATOR))
#define RYGEL_MEDIA_EXPORT_DATABASE_CURSOR_IS_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_DATABASE_CURSOR_TYPE_ITERATOR))
#define RYGEL_MEDIA_EXPORT_DATABASE_CURSOR_ITERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_DATABASE_CURSOR_TYPE_ITERATOR, RygelMediaExportDatabaseCursorIteratorClass))

typedef struct _RygelMediaExportDatabaseCursorIterator RygelMediaExportDatabaseCursorIterator;
typedef struct _RygelMediaExportDatabaseCursorIteratorClass RygelMediaExportDatabaseCursorIteratorClass;
#define _rygel_media_export_database_cursor_iterator_unref0(var) ((var == NULL) ? NULL : (var = (rygel_media_export_database_cursor_iterator_unref (var), NULL)))
#define _rygel_media_export_exists_cache_entry_free0(var) ((var == NULL) ? NULL : (var = (rygel_media_export_exists_cache_entry_free (var), NULL)))
#define _g_value_array_free0(var) ((var == NULL) ? NULL : (var = (g_value_array_free (var), NULL)))
#define __vala_GValue_free0(var) ((var == NULL) ? NULL : (var = (_vala_GValue_free (var), NULL)))

#define RYGEL_MEDIA_EXPORT_TYPE_DETAIL_COLUMN (rygel_media_export_detail_column_get_type ())

#define RYGEL_TYPE_NULL_CONTAINER (rygel_null_container_get_type ())
#define RYGEL_NULL_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_NULL_CONTAINER, RygelNullContainer))
#define RYGEL_NULL_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_NULL_CONTAINER, RygelNullContainerClass))
#define RYGEL_IS_NULL_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_NULL_CONTAINER))
#define RYGEL_IS_NULL_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_NULL_CONTAINER))
#define RYGEL_NULL_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_NULL_CONTAINER, RygelNullContainerClass))

typedef struct _RygelNullContainer RygelNullContainer;
typedef struct _RygelNullContainerClass RygelNullContainerClass;

#define RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER (rygel_media_export_media_cache_upgrader_get_type ())
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_UPGRADER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER, RygelMediaExportMediaCacheUpgrader))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_UPGRADER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER, RygelMediaExportMediaCacheUpgraderClass))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE_UPGRADER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE_UPGRADER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_UPGRADER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER, RygelMediaExportMediaCacheUpgraderClass))

typedef struct _RygelMediaExportMediaCacheUpgrader RygelMediaExportMediaCacheUpgrader;
typedef struct _RygelMediaExportMediaCacheUpgraderClass RygelMediaExportMediaCacheUpgraderClass;
#define _rygel_media_export_media_cache_upgrader_unref0(var) ((var == NULL) ? NULL : (var = (rygel_media_export_media_cache_upgrader_unref (var), NULL)))

#define RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM (rygel_media_export_music_item_get_type ())
#define RYGEL_MEDIA_EXPORT_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM, RygelMediaExportMusicItem))
#define RYGEL_MEDIA_EXPORT_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM, RygelMediaExportMusicItemClass))
#define RYGEL_MEDIA_EXPORT_IS_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM))
#define RYGEL_MEDIA_EXPORT_IS_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM))
#define RYGEL_MEDIA_EXPORT_MUSIC_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM, RygelMediaExportMusicItemClass))

typedef struct _RygelMediaExportMusicItem RygelMediaExportMusicItem;
typedef struct _RygelMediaExportMusicItemClass RygelMediaExportMusicItemClass;
typedef struct _RygelMediaExportMusicItemPrivate RygelMediaExportMusicItemPrivate;

#define RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER (rygel_media_export_db_container_get_type ())
#define RYGEL_MEDIA_EXPORT_DB_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, RygelMediaExportDBContainer))
#define RYGEL_MEDIA_EXPORT_DB_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, RygelMediaExportDBContainerClass))
#define RYGEL_MEDIA_EXPORT_IS_DB_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER))
#define RYGEL_MEDIA_EXPORT_IS_DB_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER))
#define RYGEL_MEDIA_EXPORT_DB_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, RygelMediaExportDBContainerClass))

typedef struct _RygelMediaExportDBContainer RygelMediaExportDBContainer;
typedef struct _RygelMediaExportDBContainerClass RygelMediaExportDBContainerClass;

#define RYGEL_MEDIA_EXPORT_TYPE_SQL_OPERATOR (rygel_media_export_sql_operator_get_type ())
#define RYGEL_MEDIA_EXPORT_SQL_OPERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_SQL_OPERATOR, RygelMediaExportSqlOperator))
#define RYGEL_MEDIA_EXPORT_SQL_OPERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_SQL_OPERATOR, RygelMediaExportSqlOperatorClass))
#define RYGEL_MEDIA_EXPORT_IS_SQL_OPERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_SQL_OPERATOR))
#define RYGEL_MEDIA_EXPORT_IS_SQL_OPERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_SQL_OPERATOR))
#define RYGEL_MEDIA_EXPORT_SQL_OPERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_SQL_OPERATOR, RygelMediaExportSqlOperatorClass))

typedef struct _RygelMediaExportSqlOperator RygelMediaExportSqlOperator;
typedef struct _RygelMediaExportSqlOperatorClass RygelMediaExportSqlOperatorClass;

#define RYGEL_MEDIA_EXPORT_TYPE_SQL_FUNCTION (rygel_media_export_sql_function_get_type ())
#define RYGEL_MEDIA_EXPORT_SQL_FUNCTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_SQL_FUNCTION, RygelMediaExportSqlFunction))
#define RYGEL_MEDIA_EXPORT_SQL_FUNCTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_SQL_FUNCTION, RygelMediaExportSqlFunctionClass))
#define RYGEL_MEDIA_EXPORT_IS_SQL_FUNCTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_SQL_FUNCTION))
#define RYGEL_MEDIA_EXPORT_IS_SQL_FUNCTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_SQL_FUNCTION))
#define RYGEL_MEDIA_EXPORT_SQL_FUNCTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_SQL_FUNCTION, RygelMediaExportSqlFunctionClass))

typedef struct _RygelMediaExportSqlFunction RygelMediaExportSqlFunction;
typedef struct _RygelMediaExportSqlFunctionClass RygelMediaExportSqlFunctionClass;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

typedef enum  {
	RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_SQLITE_ERROR,
	RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_GENERAL_ERROR,
	RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_INVALID_TYPE,
	RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_UNSUPPORTED_SEARCH
} RygelMediaExportMediaCacheError;
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR rygel_media_export_media_cache_error_quark ()
typedef enum  {
	RYGEL_MEDIA_EXPORT_OBJECT_TYPE_CONTAINER,
	RYGEL_MEDIA_EXPORT_OBJECT_TYPE_ITEM
} RygelMediaExportObjectType;

struct _RygelMediaExportExistsCacheEntry {
	gint64 mtime;
	gint64 size;
};

struct _RygelMediaExportMediaCache {
	GObject parent_instance;
	RygelMediaExportMediaCachePrivate * priv;
};

struct _RygelMediaExportMediaCacheClass {
	GObjectClass parent_class;
};

struct _RygelMediaExportMediaCachePrivate {
	RygelMediaExportDatabase* db;
	RygelMediaExportObjectFactory* factory;
	RygelMediaExportSQLFactory* sql;
	GeeHashMap* exists_cache;
};

typedef enum  {
	RYGEL_MEDIA_EXPORT_DATABASE_ERROR_IO_ERROR,
	RYGEL_MEDIA_EXPORT_DATABASE_ERROR_SQLITE_ERROR
} RygelMediaExportDatabaseError;
#define RYGEL_MEDIA_EXPORT_DATABASE_ERROR rygel_media_export_database_error_quark ()
typedef enum  {
	RYGEL_MEDIA_EXPORT_SQL_STRING_SAVE_METADATA,
	RYGEL_MEDIA_EXPORT_SQL_STRING_INSERT,
	RYGEL_MEDIA_EXPORT_SQL_STRING_DELETE,
	RYGEL_MEDIA_EXPORT_SQL_STRING_GET_OBJECT,
	RYGEL_MEDIA_EXPORT_SQL_STRING_GET_CHILDREN,
	RYGEL_MEDIA_EXPORT_SQL_STRING_GET_OBJECTS_BY_FILTER,
	RYGEL_MEDIA_EXPORT_SQL_STRING_GET_OBJECTS_BY_FILTER_WITH_ANCESTOR,
	RYGEL_MEDIA_EXPORT_SQL_STRING_GET_OBJECT_COUNT_BY_FILTER,
	RYGEL_MEDIA_EXPORT_SQL_STRING_GET_OBJECT_COUNT_BY_FILTER_WITH_ANCESTOR,
	RYGEL_MEDIA_EXPORT_SQL_STRING_GET_META_DATA_COLUMN,
	RYGEL_MEDIA_EXPORT_SQL_STRING_CHILD_COUNT,
	RYGEL_MEDIA_EXPORT_SQL_STRING_EXISTS,
	RYGEL_MEDIA_EXPORT_SQL_STRING_CHILD_IDS,
	RYGEL_MEDIA_EXPORT_SQL_STRING_TABLE_METADATA,
	RYGEL_MEDIA_EXPORT_SQL_STRING_TABLE_CLOSURE,
	RYGEL_MEDIA_EXPORT_SQL_STRING_TRIGGER_CLOSURE,
	RYGEL_MEDIA_EXPORT_SQL_STRING_TRIGGER_COMMON,
	RYGEL_MEDIA_EXPORT_SQL_STRING_INDEX_COMMON,
	RYGEL_MEDIA_EXPORT_SQL_STRING_SCHEMA,
	RYGEL_MEDIA_EXPORT_SQL_STRING_EXISTS_CACHE,
	RYGEL_MEDIA_EXPORT_SQL_STRING_STATISTICS
} RygelMediaExportSQLString;

typedef enum  {
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_TYPE,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_TITLE,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_SIZE,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_MIME_TYPE,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_WIDTH,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_HEIGHT,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_CLASS,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_AUTHOR,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_ALBUM,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_DATE,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_BITRATE,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_SAMPLE_FREQ,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_BITS_PER_SAMPLE,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_CHANNELS,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_TRACK,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_COLOR_DEPTH,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_DURATION,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_ID,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_PARENT,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_TIMESTAMP,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_URI,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_DLNA_PROFILE,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_GENRE,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_DISC
} RygelMediaExportDetailColumn;

struct _RygelMediaExportMusicItem {
	RygelMusicItem parent_instance;
	RygelMediaExportMusicItemPrivate * priv;
	gint disc;
};

struct _RygelMediaExportMusicItemClass {
	RygelMusicItemClass parent_class;
};


static gpointer rygel_media_export_media_cache_parent_class = NULL;
static RygelMediaExportMediaCache* rygel_media_export_media_cache_instance;
static RygelMediaExportMediaCache* rygel_media_export_media_cache_instance = NULL;

GQuark rygel_media_export_media_cache_error_quark (void);
GType rygel_media_export_object_type_get_type (void) G_GNUC_CONST;
GType rygel_media_export_exists_cache_entry_get_type (void) G_GNUC_CONST;
RygelMediaExportExistsCacheEntry* rygel_media_export_exists_cache_entry_dup (const RygelMediaExportExistsCacheEntry* self);
void rygel_media_export_exists_cache_entry_free (RygelMediaExportExistsCacheEntry* self);
GType rygel_media_export_media_cache_get_type (void) G_GNUC_CONST;
GType rygel_media_export_sqlite_wrapper_get_type (void) G_GNUC_CONST;
GType rygel_media_export_database_get_type (void) G_GNUC_CONST;
GType rygel_media_export_object_factory_get_type (void) G_GNUC_CONST;
GType rygel_media_export_sql_factory_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCachePrivate))
enum  {
	RYGEL_MEDIA_EXPORT_MEDIA_CACHE_DUMMY_PROPERTY
};
static RygelMediaExportMediaCache* rygel_media_export_media_cache_new (GError** error);
static RygelMediaExportMediaCache* rygel_media_export_media_cache_construct (GType object_type, GError** error);
RygelMediaExportSQLFactory* rygel_media_export_sql_factory_new (void);
RygelMediaExportSQLFactory* rygel_media_export_sql_factory_construct (GType object_type);
static void rygel_media_export_media_cache_open_db (RygelMediaExportMediaCache* self, const gchar* name, GError** error);
RygelMediaExportObjectFactory* rygel_media_export_object_factory_new (void);
RygelMediaExportObjectFactory* rygel_media_export_object_factory_construct (GType object_type);
GQuark rygel_media_export_database_error_quark (void);
static void rygel_media_export_media_cache_get_exists_cache (RygelMediaExportMediaCache* self, GError** error);
gchar* rygel_media_export_media_cache_get_id (GFile* file);
RygelMediaExportMediaCache* rygel_media_export_media_cache_get_default (GError** error);
void rygel_media_export_media_cache_remove_by_id (RygelMediaExportMediaCache* self, const gchar* id, GError** error);
void rygel_media_export_database_exec (RygelMediaExportDatabase* self, const gchar* sql, GValue* arguments, int arguments_length1, GError** error);
GType rygel_media_export_sql_string_get_type (void) G_GNUC_CONST;
const gchar* rygel_media_export_sql_factory_make (RygelMediaExportSQLFactory* self, RygelMediaExportSQLString query);
static void _vala_GValue_array_free (GValue* array, gint array_length);
void rygel_media_export_media_cache_remove_object (RygelMediaExportMediaCache* self, RygelMediaObject* object, GError** error);
void rygel_media_export_media_cache_save_container (RygelMediaExportMediaCache* self, RygelMediaContainer* container, GError** error);
void rygel_media_export_database_begin (RygelMediaExportDatabase* self, GError** error);
static void rygel_media_export_media_cache_create_object (RygelMediaExportMediaCache* self, RygelMediaObject* item, GError** error);
void rygel_media_export_database_commit (RygelMediaExportDatabase* self, GError** error);
void rygel_media_export_database_rollback (RygelMediaExportDatabase* self);
void rygel_media_export_media_cache_save_item (RygelMediaExportMediaCache* self, RygelMediaItem* item, GError** error);
static void rygel_media_export_media_cache_save_metadata (RygelMediaExportMediaCache* self, RygelMediaItem* item, GError** error);
RygelMediaObject* rygel_media_export_media_cache_get_object (RygelMediaExportMediaCache* self, const gchar* object_id, GError** error);
GType rygel_media_export_database_cursor_get_type (void) G_GNUC_CONST;
static RygelMediaExportDatabaseCursor* rygel_media_export_media_cache_exec_cursor (RygelMediaExportMediaCache* self, RygelMediaExportSQLString id, GValue* values, int values_length1, GError** error);
gpointer rygel_media_export_database_cursor_iterator_ref (gpointer instance);
void rygel_media_export_database_cursor_iterator_unref (gpointer instance);
GParamSpec* rygel_media_export_database_cursor_param_spec_iterator (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_media_export_database_cursor_value_set_iterator (GValue* value, gpointer v_object);
void rygel_media_export_database_cursor_value_take_iterator (GValue* value, gpointer v_object);
gpointer rygel_media_export_database_cursor_value_get_iterator (const GValue* value);
GType rygel_media_export_database_cursor_iterator_get_type (void) G_GNUC_CONST;
RygelMediaExportDatabaseCursorIterator* rygel_media_export_database_cursor_iterator (RygelMediaExportDatabaseCursor* self);
gboolean rygel_media_export_database_cursor_iterator_next (RygelMediaExportDatabaseCursorIterator* self);
sqlite3_stmt* rygel_media_export_database_cursor_iterator_get (RygelMediaExportDatabaseCursorIterator* self, GError** error);
static RygelMediaObject* rygel_media_export_media_cache_get_object_from_statement (RygelMediaExportMediaCache* self, RygelMediaContainer* parent, sqlite3_stmt* statement);
RygelMediaContainer* rygel_media_export_media_cache_get_container (RygelMediaExportMediaCache* self, const gchar* container_id, GError** error);
gint rygel_media_export_media_cache_get_child_count (RygelMediaExportMediaCache* self, const gchar* container_id, GError** error);
static gint rygel_media_export_media_cache_query_value (RygelMediaExportMediaCache* self, RygelMediaExportSQLString id, GValue* values, int values_length1, GError** error);
gboolean rygel_media_export_media_cache_exists (RygelMediaExportMediaCache* self, GFile* file, gint64* timestamp, gint64* size, GError** error);
sqlite3_stmt* rygel_media_export_database_cursor_next (RygelMediaExportDatabaseCursor* self, GError** error);
RygelMediaObjects* rygel_media_export_media_cache_get_children (RygelMediaExportMediaCache* self, RygelMediaContainer* container, const gchar* sort_criteria, glong offset, glong max_count, GError** error);
static gchar* rygel_media_export_media_cache_translate_sort_criteria (RygelMediaExportMediaCache* self, const gchar* sort_criteria);
RygelMediaExportDatabaseCursor* rygel_media_export_database_exec_cursor (RygelMediaExportDatabase* self, const gchar* sql, GValue* arguments, int arguments_length1, GError** error);
RygelMediaObjects* rygel_media_export_media_cache_get_objects_by_search_expression (RygelMediaExportMediaCache* self, RygelSearchExpression* expression, const gchar* container_id, const gchar* sort_criteria, guint offset, guint max_count, guint* total_matches, GError** error);
static gchar* rygel_media_export_media_cache_translate_search_expression (RygelMediaExportMediaCache* self, RygelSearchExpression* expression, GValueArray* args, const gchar* prefix, GError** error);
static guint rygel_media_export_media_cache_modify_limit (RygelMediaExportMediaCache* self, guint max_count);
glong rygel_media_export_media_cache_get_object_count_by_filter (RygelMediaExportMediaCache* self, const gchar* filter, GValueArray* args, const gchar* container_id, GError** error);
RygelMediaObjects* rygel_media_export_media_cache_get_objects_by_filter (RygelMediaExportMediaCache* self, const gchar* filter, GValueArray* args, const gchar* container_id, const gchar* sort_criteria, glong offset, glong max_count, GError** error);
glong rygel_media_export_media_cache_get_object_count_by_search_expression (RygelMediaExportMediaCache* self, RygelSearchExpression* expression, const gchar* container_id, GError** error);
static GValue* _g_value_dup (GValue* self);
static void _vala_GValue_free (GValue* self);
gint rygel_media_export_database_query_value (RygelMediaExportDatabase* self, const gchar* sql, GValue* args, int args_length1, GError** error);
GType rygel_media_export_detail_column_get_type (void) G_GNUC_CONST;
RygelNullContainer* rygel_null_container_new (void);
RygelNullContainer* rygel_null_container_construct (GType object_type);
GType rygel_null_container_get_type (void) G_GNUC_CONST;
void rygel_media_export_media_cache_debug_statistics (RygelMediaExportMediaCache* self);
GeeArrayList* rygel_media_export_media_cache_get_child_ids (RygelMediaExportMediaCache* self, const gchar* container_id, GError** error);
GeeList* rygel_media_export_media_cache_get_meta_data_column_by_filter (RygelMediaExportMediaCache* self, const gchar* column, const gchar* filter, GValueArray* args, glong offset, glong max_count, GError** error);
GeeList* rygel_media_export_media_cache_get_object_attribute_by_search_expression (RygelMediaExportMediaCache* self, const gchar* attribute, RygelSearchExpression* expression, glong offset, guint max_count, GError** error);
static gchar* rygel_media_export_media_cache_map_operand_to_column (RygelMediaExportMediaCache* self, const gchar* operand, gchar** collate, GError** error);
void rygel_media_export_media_cache_flag_object (RygelMediaExportMediaCache* self, GFile* file, const gchar* flag, GError** error);
GeeList* rygel_media_export_media_cache_get_flagged_uris (RygelMediaExportMediaCache* self, const gchar* flag, GError** error);
RygelMediaExportDatabase* rygel_media_export_database_new (const gchar* name, GError** error);
RygelMediaExportDatabase* rygel_media_export_database_construct (GType object_type, const gchar* name, GError** error);
#define RYGEL_MEDIA_EXPORT_SQL_FACTORY_schema_version "11"
RygelMediaExportMediaCacheUpgrader* rygel_media_export_media_cache_upgrader_new (RygelMediaExportDatabase* database, RygelMediaExportSQLFactory* sql);
RygelMediaExportMediaCacheUpgrader* rygel_media_export_media_cache_upgrader_construct (GType object_type, RygelMediaExportDatabase* database, RygelMediaExportSQLFactory* sql);
gpointer rygel_media_export_media_cache_upgrader_ref (gpointer instance);
void rygel_media_export_media_cache_upgrader_unref (gpointer instance);
GParamSpec* rygel_media_export_param_spec_media_cache_upgrader (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_media_export_value_set_media_cache_upgrader (GValue* value, gpointer v_object);
void rygel_media_export_value_take_media_cache_upgrader (GValue* value, gpointer v_object);
gpointer rygel_media_export_value_get_media_cache_upgrader (const GValue* value);
GType rygel_media_export_media_cache_upgrader_get_type (void) G_GNUC_CONST;
gboolean rygel_media_export_media_cache_upgrader_needs_upgrade (RygelMediaExportMediaCacheUpgrader* self, gint* current_version, GError** error);
void rygel_media_export_media_cache_upgrader_upgrade (RygelMediaExportMediaCacheUpgrader* self, gint old_version);
void rygel_media_export_media_cache_upgrader_fix_schema (RygelMediaExportMediaCacheUpgrader* self, GError** error);
void rygel_media_export_media_cache_upgrader_ensure_indices (RygelMediaExportMediaCacheUpgrader* self);
static gboolean rygel_media_export_media_cache_create_schema (RygelMediaExportMediaCache* self);
void rygel_media_export_database_null (GValue* result);
GType rygel_media_export_music_item_get_type (void) G_GNUC_CONST;
void rygel_media_export_database_analyze (RygelMediaExportDatabase* self);
GType rygel_media_export_db_container_get_type (void) G_GNUC_CONST;
RygelMediaExportDBContainer* rygel_media_export_object_factory_get_container (RygelMediaExportObjectFactory* self, RygelMediaExportMediaCache* media_db, const gchar* id, const gchar* title, guint child_count, const gchar* uri);
RygelMediaItem* rygel_media_export_object_factory_get_item (RygelMediaExportObjectFactory* self, RygelMediaExportMediaCache* media_db, RygelMediaContainer* parent, const gchar* id, const gchar* title, const gchar* upnp_class);
static void rygel_media_export_media_cache_fill_item (RygelMediaExportMediaCache* self, sqlite3_stmt* statement, RygelMediaItem* item);
static gchar* rygel_media_export_media_cache_search_expression_to_sql (RygelMediaExportMediaCache* self, RygelSearchExpression* expression, GValueArray* args, GError** error);
static gchar* rygel_media_export_media_cache_logical_expression_to_sql (RygelMediaExportMediaCache* self, RygelLogicalExpression* expression, GValueArray* args, GError** error);
static gchar* rygel_media_export_media_cache_relational_expression_to_sql (RygelMediaExportMediaCache* self, RygelRelationalExpression* exp, GValueArray* args, GError** error);
GType rygel_media_export_sql_operator_get_type (void) G_GNUC_CONST;
RygelMediaExportSqlOperator* rygel_media_export_sql_operator_new_from_search_criteria_op (GUPnPSearchCriteriaOp op, const gchar* arg, const gchar* collate);
RygelMediaExportSqlOperator* rygel_media_export_sql_operator_construct_from_search_criteria_op (GType object_type, GUPnPSearchCriteriaOp op, const gchar* arg, const gchar* collate);
RygelMediaExportSqlFunction* rygel_media_export_sql_function_new (const gchar* name, const gchar* arg);
RygelMediaExportSqlFunction* rygel_media_export_sql_function_construct (GType object_type, const gchar* name, const gchar* arg);
GType rygel_media_export_sql_function_get_type (void) G_GNUC_CONST;
RygelMediaExportSqlOperator* rygel_media_export_sql_operator_new (const gchar* name, const gchar* arg, const gchar* collate);
RygelMediaExportSqlOperator* rygel_media_export_sql_operator_construct (GType object_type, const gchar* name, const gchar* arg, const gchar* collate);
gchar* rygel_media_export_sql_operator_to_string (RygelMediaExportSqlOperator* self);
static void rygel_media_export_media_cache_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


GQuark rygel_media_export_media_cache_error_quark (void) {
	return g_quark_from_static_string ("rygel_media_export_media_cache_error-quark");
}


GType rygel_media_export_object_type_get_type (void) {
	static volatile gsize rygel_media_export_object_type_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_export_object_type_type_id__volatile)) {
		static const GEnumValue values[] = {{RYGEL_MEDIA_EXPORT_OBJECT_TYPE_CONTAINER, "RYGEL_MEDIA_EXPORT_OBJECT_TYPE_CONTAINER", "container"}, {RYGEL_MEDIA_EXPORT_OBJECT_TYPE_ITEM, "RYGEL_MEDIA_EXPORT_OBJECT_TYPE_ITEM", "item"}, {0, NULL, NULL}};
		GType rygel_media_export_object_type_type_id;
		rygel_media_export_object_type_type_id = g_enum_register_static ("RygelMediaExportObjectType", values);
		g_once_init_leave (&rygel_media_export_object_type_type_id__volatile, rygel_media_export_object_type_type_id);
	}
	return rygel_media_export_object_type_type_id__volatile;
}


RygelMediaExportExistsCacheEntry* rygel_media_export_exists_cache_entry_dup (const RygelMediaExportExistsCacheEntry* self) {
	RygelMediaExportExistsCacheEntry* dup;
#line 40 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	dup = g_new0 (RygelMediaExportExistsCacheEntry, 1);
#line 40 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	memcpy (dup, self, sizeof (RygelMediaExportExistsCacheEntry));
#line 40 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return dup;
#line 440 "rygel-media-export-media-cache.c"
}


void rygel_media_export_exists_cache_entry_free (RygelMediaExportExistsCacheEntry* self) {
#line 40 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_free (self);
#line 447 "rygel-media-export-media-cache.c"
}


GType rygel_media_export_exists_cache_entry_get_type (void) {
	static volatile gsize rygel_media_export_exists_cache_entry_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_export_exists_cache_entry_type_id__volatile)) {
		GType rygel_media_export_exists_cache_entry_type_id;
		rygel_media_export_exists_cache_entry_type_id = g_boxed_type_register_static ("RygelMediaExportExistsCacheEntry", (GBoxedCopyFunc) rygel_media_export_exists_cache_entry_dup, (GBoxedFreeFunc) rygel_media_export_exists_cache_entry_free);
		g_once_init_leave (&rygel_media_export_exists_cache_entry_type_id__volatile, rygel_media_export_exists_cache_entry_type_id);
	}
	return rygel_media_export_exists_cache_entry_type_id__volatile;
}


static RygelMediaExportMediaCache* rygel_media_export_media_cache_construct (GType object_type, GError** error) {
	RygelMediaExportMediaCache * self = NULL;
	RygelMediaExportSQLFactory* _tmp0_;
	RygelMediaExportObjectFactory* _tmp1_;
	GError * _inner_error_ = NULL;
#line 61 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	self = (RygelMediaExportMediaCache*) g_object_new (object_type, NULL);
#line 62 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = rygel_media_export_sql_factory_new ();
#line 62 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_object_unref0 (self->priv->sql);
#line 62 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	self->priv->sql = _tmp0_;
#line 63 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	rygel_media_export_media_cache_open_db (self, "media-export", &_inner_error_);
#line 63 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 63 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 63 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_object_unref0 (self);
#line 63 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return NULL;
#line 485 "rygel-media-export-media-cache.c"
	}
#line 64 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp1_ = rygel_media_export_object_factory_new ();
#line 64 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_object_unref0 (self->priv->factory);
#line 64 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	self->priv->factory = _tmp1_;
#line 65 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	rygel_media_export_media_cache_get_exists_cache (self, &_inner_error_);
#line 65 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 65 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 65 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_object_unref0 (self);
#line 65 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return NULL;
#line 503 "rygel-media-export-media-cache.c"
	}
#line 61 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return self;
#line 507 "rygel-media-export-media-cache.c"
}


static RygelMediaExportMediaCache* rygel_media_export_media_cache_new (GError** error) {
#line 61 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return rygel_media_export_media_cache_construct (RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, error);
#line 514 "rygel-media-export-media-cache.c"
}


gchar* rygel_media_export_media_cache_get_id (GFile* file) {
	gchar* result = NULL;
	GFile* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
#line 69 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (file != NULL, NULL);
#line 70 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = file;
#line 70 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp1_ = g_file_get_uri (_tmp0_);
#line 70 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp2_ = _tmp1_;
#line 70 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp3_ = g_compute_checksum_for_string (G_CHECKSUM_MD5, _tmp2_, (gsize) (-1));
#line 70 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp4_ = _tmp3_;
#line 70 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_free0 (_tmp2_);
#line 70 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	result = _tmp4_;
#line 70 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return result;
#line 543 "rygel-media-export-media-cache.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 79 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return self ? g_object_ref (self) : NULL;
#line 550 "rygel-media-export-media-cache.c"
}


RygelMediaExportMediaCache* rygel_media_export_media_cache_get_default (GError** error) {
	RygelMediaExportMediaCache* result = NULL;
	RygelMediaExportMediaCache* _tmp0_;
	RygelMediaExportMediaCache* _tmp3_;
	RygelMediaExportMediaCache* _tmp4_;
	GError * _inner_error_ = NULL;
#line 75 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = rygel_media_export_media_cache_instance;
#line 75 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_tmp0_ == NULL) {
#line 564 "rygel-media-export-media-cache.c"
		RygelMediaExportMediaCache* _tmp1_;
		RygelMediaExportMediaCache* _tmp2_;
#line 76 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp1_ = rygel_media_export_media_cache_new (&_inner_error_);
#line 76 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp2_ = _tmp1_;
#line 76 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_inner_error_ != NULL) {
#line 76 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_propagate_error (error, _inner_error_);
#line 76 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return NULL;
#line 577 "rygel-media-export-media-cache.c"
		}
#line 76 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_object_unref0 (rygel_media_export_media_cache_instance);
#line 76 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_media_export_media_cache_instance = _tmp2_;
#line 583 "rygel-media-export-media-cache.c"
	}
#line 79 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp3_ = rygel_media_export_media_cache_instance;
#line 79 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 79 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	result = _tmp4_;
#line 79 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return result;
#line 593 "rygel-media-export-media-cache.c"
}


static void _vala_GValue_array_free (GValue* array, gint array_length) {
#line 85 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (array != NULL) {
#line 600 "rygel-media-export-media-cache.c"
		int i;
#line 85 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		for (i = 0; i < array_length; i = i + 1) {
#line 85 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_value_unset (&array[i]);
#line 606 "rygel-media-export-media-cache.c"
		}
	}
#line 85 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_free (array);
#line 611 "rygel-media-export-media-cache.c"
}


void rygel_media_export_media_cache_remove_by_id (RygelMediaExportMediaCache* self, const gchar* id, GError** error) {
	const gchar* _tmp0_;
	GValue _tmp1_ = {0};
	GValue* _tmp2_ = NULL;
	GValue* values;
	gint values_length1;
	gint _values_size_;
	RygelMediaExportDatabase* _tmp3_;
	RygelMediaExportSQLFactory* _tmp4_;
	const gchar* _tmp5_ = NULL;
	GError * _inner_error_ = NULL;
#line 83 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_if_fail (self != NULL);
#line 83 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_if_fail (id != NULL);
#line 84 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = id;
#line 84 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp1_, G_TYPE_STRING);
#line 84 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_string (&_tmp1_, _tmp0_);
#line 84 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp2_ = g_new0 (GValue, 1);
#line 84 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp2_[0] = _tmp1_;
#line 84 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	values = _tmp2_;
#line 84 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	values_length1 = 1;
#line 84 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_values_size_ = values_length1;
#line 85 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp3_ = self->priv->db;
#line 85 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp4_ = self->priv->sql;
#line 85 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp5_ = rygel_media_export_sql_factory_make (_tmp4_, RYGEL_MEDIA_EXPORT_SQL_STRING_DELETE);
#line 85 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	rygel_media_export_database_exec (_tmp3_, _tmp5_, values, values_length1, &_inner_error_);
#line 85 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 85 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 85 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_propagate_error (error, _inner_error_);
#line 85 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 85 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return;
#line 664 "rygel-media-export-media-cache.c"
		} else {
#line 85 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 85 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 85 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_clear_error (&_inner_error_);
#line 85 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return;
#line 674 "rygel-media-export-media-cache.c"
		}
	}
#line 83 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 679 "rygel-media-export-media-cache.c"
}


void rygel_media_export_media_cache_remove_object (RygelMediaExportMediaCache* self, RygelMediaObject* object, GError** error) {
	RygelMediaObject* _tmp0_;
	const gchar* _tmp1_;
	GError * _inner_error_ = NULL;
#line 88 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_if_fail (self != NULL);
#line 88 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_if_fail (object != NULL);
#line 90 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = object;
#line 90 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp1_ = _tmp0_->id;
#line 90 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	rygel_media_export_media_cache_remove_by_id (self, _tmp1_, &_inner_error_);
#line 90 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 90 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if ((_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) || (_inner_error_->domain == RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR)) {
#line 90 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_propagate_error (error, _inner_error_);
#line 90 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return;
#line 705 "rygel-media-export-media-cache.c"
		} else {
#line 90 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 90 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_clear_error (&_inner_error_);
#line 90 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return;
#line 713 "rygel-media-export-media-cache.c"
		}
	}
}


static gpointer _g_error_copy0 (gpointer self) {
#line 101 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return self ? g_error_copy (self) : NULL;
#line 722 "rygel-media-export-media-cache.c"
}


void rygel_media_export_media_cache_save_container (RygelMediaExportMediaCache* self, RygelMediaContainer* container, GError** error) {
	GError * _inner_error_ = NULL;
#line 93 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_if_fail (self != NULL);
#line 93 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_if_fail (container != NULL);
#line 732 "rygel-media-export-media-cache.c"
	{
		RygelMediaExportDatabase* _tmp0_;
		RygelMediaContainer* _tmp1_;
		RygelMediaExportDatabase* _tmp2_;
#line 95 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp0_ = self->priv->db;
#line 95 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_media_export_database_begin (_tmp0_, &_inner_error_);
#line 95 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_inner_error_ != NULL) {
#line 95 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 745 "rygel-media-export-media-cache.c"
				goto __catch5_rygel_media_export_database_error;
			}
#line 95 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 95 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_clear_error (&_inner_error_);
#line 95 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return;
#line 754 "rygel-media-export-media-cache.c"
		}
#line 96 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp1_ = container;
#line 96 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_media_export_media_cache_create_object (self, (RygelMediaObject*) _tmp1_, &_inner_error_);
#line 96 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_inner_error_ != NULL) {
#line 96 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 764 "rygel-media-export-media-cache.c"
				goto __catch5_rygel_media_export_database_error;
			}
			goto __finally5;
		}
#line 97 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp2_ = self->priv->db;
#line 97 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_media_export_database_commit (_tmp2_, &_inner_error_);
#line 97 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_inner_error_ != NULL) {
#line 97 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 777 "rygel-media-export-media-cache.c"
				goto __catch5_rygel_media_export_database_error;
			}
#line 97 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 97 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_clear_error (&_inner_error_);
#line 97 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return;
#line 786 "rygel-media-export-media-cache.c"
		}
	}
	goto __finally5;
	__catch5_rygel_media_export_database_error:
	{
		GError* _error_ = NULL;
		RygelMediaExportDatabase* _tmp3_;
		GError* _tmp4_;
		GError* _tmp5_;
#line 94 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_error_ = _inner_error_;
#line 94 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_inner_error_ = NULL;
#line 99 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp3_ = self->priv->db;
#line 99 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_media_export_database_rollback (_tmp3_);
#line 101 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp4_ = _error_;
#line 101 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp5_ = _g_error_copy0 (_tmp4_);
#line 101 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_inner_error_ = _tmp5_;
#line 101 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_error_free0 (_error_);
#line 812 "rygel-media-export-media-cache.c"
		goto __finally5;
	}
	__finally5:
#line 94 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 94 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 94 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return;
#line 822 "rygel-media-export-media-cache.c"
	}
}


void rygel_media_export_media_cache_save_item (RygelMediaExportMediaCache* self, RygelMediaItem* item, GError** error) {
	GError * _inner_error_ = NULL;
#line 105 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_if_fail (self != NULL);
#line 105 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_if_fail (item != NULL);
#line 833 "rygel-media-export-media-cache.c"
	{
		RygelMediaExportDatabase* _tmp0_;
		RygelMediaItem* _tmp1_;
		RygelMediaItem* _tmp2_;
		RygelMediaExportDatabase* _tmp3_;
#line 107 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp0_ = self->priv->db;
#line 107 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_media_export_database_begin (_tmp0_, &_inner_error_);
#line 107 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_inner_error_ != NULL) {
#line 107 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 847 "rygel-media-export-media-cache.c"
				goto __catch6_rygel_media_export_database_error;
			}
#line 107 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 107 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_clear_error (&_inner_error_);
#line 107 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return;
#line 856 "rygel-media-export-media-cache.c"
		}
#line 108 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp1_ = item;
#line 108 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_media_export_media_cache_save_metadata (self, _tmp1_, &_inner_error_);
#line 108 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_inner_error_ != NULL) {
#line 108 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 866 "rygel-media-export-media-cache.c"
				goto __catch6_rygel_media_export_database_error;
			}
			goto __finally6;
		}
#line 109 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp2_ = item;
#line 109 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_media_export_media_cache_create_object (self, (RygelMediaObject*) _tmp2_, &_inner_error_);
#line 109 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_inner_error_ != NULL) {
#line 109 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 879 "rygel-media-export-media-cache.c"
				goto __catch6_rygel_media_export_database_error;
			}
			goto __finally6;
		}
#line 110 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp3_ = self->priv->db;
#line 110 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_media_export_database_commit (_tmp3_, &_inner_error_);
#line 110 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_inner_error_ != NULL) {
#line 110 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 892 "rygel-media-export-media-cache.c"
				goto __catch6_rygel_media_export_database_error;
			}
#line 110 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 110 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_clear_error (&_inner_error_);
#line 110 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return;
#line 901 "rygel-media-export-media-cache.c"
		}
	}
	goto __finally6;
	__catch6_rygel_media_export_database_error:
	{
		GError* _error_ = NULL;
		const gchar* _tmp4_ = NULL;
		RygelMediaItem* _tmp5_;
		const gchar* _tmp6_;
		GError* _tmp7_;
		const gchar* _tmp8_;
		RygelMediaExportDatabase* _tmp9_;
		GError* _tmp10_;
		GError* _tmp11_;
#line 106 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_error_ = _inner_error_;
#line 106 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_inner_error_ = NULL;
#line 112 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp4_ = _ ("Failed to add item with ID %s: %s");
#line 112 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp5_ = item;
#line 112 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp6_ = ((RygelMediaObject*) _tmp5_)->id;
#line 112 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp7_ = _error_;
#line 112 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp8_ = _tmp7_->message;
#line 112 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_warning (_tmp4_, _tmp6_, _tmp8_);
#line 115 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp9_ = self->priv->db;
#line 115 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_media_export_database_rollback (_tmp9_);
#line 117 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp10_ = _error_;
#line 117 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp11_ = _g_error_copy0 (_tmp10_);
#line 117 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_inner_error_ = _tmp11_;
#line 117 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_error_free0 (_error_);
#line 944 "rygel-media-export-media-cache.c"
		goto __finally6;
	}
	__finally6:
#line 106 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 106 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 106 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return;
#line 954 "rygel-media-export-media-cache.c"
	}
}


RygelMediaObject* rygel_media_export_media_cache_get_object (RygelMediaExportMediaCache* self, const gchar* object_id, GError** error) {
	RygelMediaObject* result = NULL;
	const gchar* _tmp0_;
	GValue _tmp1_ = {0};
	GValue* _tmp2_ = NULL;
	GValue* values;
	gint values_length1;
	gint _values_size_;
	RygelMediaObject* parent;
	GValue* _tmp3_;
	gint _tmp3__length1;
	RygelMediaExportDatabaseCursor* _tmp4_ = NULL;
	RygelMediaExportDatabaseCursor* cursor;
	GError * _inner_error_ = NULL;
#line 121 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 121 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (object_id != NULL, NULL);
#line 122 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = object_id;
#line 122 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp1_, G_TYPE_STRING);
#line 122 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_string (&_tmp1_, _tmp0_);
#line 122 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp2_ = g_new0 (GValue, 1);
#line 122 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp2_[0] = _tmp1_;
#line 122 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	values = _tmp2_;
#line 122 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	values_length1 = 1;
#line 122 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_values_size_ = values_length1;
#line 123 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	parent = NULL;
#line 125 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp3_ = values;
#line 125 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp3__length1 = values_length1;
#line 125 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp4_ = rygel_media_export_media_cache_exec_cursor (self, RYGEL_MEDIA_EXPORT_SQL_STRING_GET_OBJECT, _tmp3_, _tmp3__length1, &_inner_error_);
#line 125 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	cursor = _tmp4_;
#line 125 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 125 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 125 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_propagate_error (error, _inner_error_);
#line 125 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_object_unref0 (parent);
#line 125 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 125 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return NULL;
#line 1015 "rygel-media-export-media-cache.c"
		} else {
#line 125 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_object_unref0 (parent);
#line 125 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 125 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 125 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_clear_error (&_inner_error_);
#line 125 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return NULL;
#line 1027 "rygel-media-export-media-cache.c"
		}
	}
	{
		RygelMediaExportDatabaseCursor* _tmp5_;
		RygelMediaExportDatabaseCursorIterator* _tmp6_ = NULL;
		RygelMediaExportDatabaseCursorIterator* _statement_it;
#line 127 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp5_ = cursor;
#line 127 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp6_ = rygel_media_export_database_cursor_iterator (_tmp5_);
#line 127 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_statement_it = _tmp6_;
#line 127 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		while (TRUE) {
#line 1042 "rygel-media-export-media-cache.c"
			RygelMediaExportDatabaseCursorIterator* _tmp7_;
			gboolean _tmp8_ = FALSE;
			RygelMediaExportDatabaseCursorIterator* _tmp9_;
			sqlite3_stmt* _tmp10_ = NULL;
			sqlite3_stmt* statement;
			RygelMediaObject* _tmp11_;
			RygelMediaContainer* _tmp12_;
			RygelMediaContainer* parent_container;
			RygelMediaContainer* _tmp13_;
			sqlite3_stmt* _tmp14_;
			RygelMediaObject* _tmp15_ = NULL;
			RygelMediaObject* object;
			RygelMediaObject* _tmp16_;
			RygelMediaContainer* _tmp17_;
			RygelMediaObject* _tmp18_;
			RygelMediaObject* _tmp19_;
#line 127 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp7_ = _statement_it;
#line 127 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp8_ = rygel_media_export_database_cursor_iterator_next (_tmp7_);
#line 127 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (!_tmp8_) {
#line 127 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				break;
#line 1067 "rygel-media-export-media-cache.c"
			}
#line 127 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp9_ = _statement_it;
#line 127 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp10_ = rygel_media_export_database_cursor_iterator_get (_tmp9_, &_inner_error_);
#line 127 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			statement = _tmp10_;
#line 127 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (_inner_error_ != NULL) {
#line 127 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 127 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					g_propagate_error (error, _inner_error_);
#line 127 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
#line 127 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_g_object_unref0 (cursor);
#line 127 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_g_object_unref0 (parent);
#line 127 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 127 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					return NULL;
#line 1091 "rygel-media-export-media-cache.c"
				} else {
#line 127 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
#line 127 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_g_object_unref0 (cursor);
#line 127 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_g_object_unref0 (parent);
#line 127 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 127 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 127 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					g_clear_error (&_inner_error_);
#line 127 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					return NULL;
#line 1107 "rygel-media-export-media-cache.c"
				}
			}
#line 128 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp11_ = parent;
#line 128 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp12_ = _g_object_ref0 (RYGEL_IS_MEDIA_CONTAINER (_tmp11_) ? ((RygelMediaContainer*) _tmp11_) : NULL);
#line 128 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			parent_container = _tmp12_;
#line 129 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp13_ = parent_container;
#line 129 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp14_ = statement;
#line 129 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp15_ = rygel_media_export_media_cache_get_object_from_statement (self, _tmp13_, _tmp14_);
#line 129 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			object = _tmp15_;
#line 132 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp16_ = object;
#line 132 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp17_ = parent_container;
#line 132 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			rygel_media_object_set_parent_ref (_tmp16_, _tmp17_);
#line 133 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp18_ = object;
#line 133 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp19_ = _g_object_ref0 (_tmp18_);
#line 133 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_object_unref0 (parent);
#line 133 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			parent = _tmp19_;
#line 127 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_object_unref0 (object);
#line 127 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_object_unref0 (parent_container);
#line 1142 "rygel-media-export-media-cache.c"
		}
#line 127 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
#line 1146 "rygel-media-export-media-cache.c"
	}
#line 136 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	result = parent;
#line 136 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_object_unref0 (cursor);
#line 136 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 136 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return result;
#line 1156 "rygel-media-export-media-cache.c"
}


RygelMediaContainer* rygel_media_export_media_cache_get_container (RygelMediaExportMediaCache* self, const gchar* container_id, GError** error) {
	RygelMediaContainer* result = NULL;
	const gchar* _tmp0_;
	RygelMediaObject* _tmp1_ = NULL;
	RygelMediaObject* object;
	gboolean _tmp2_ = FALSE;
	RygelMediaObject* _tmp3_;
	gboolean _tmp5_;
	RygelMediaObject* _tmp8_;
	RygelMediaContainer* _tmp9_;
	GError * _inner_error_ = NULL;
#line 139 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 139 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (container_id != NULL, NULL);
#line 142 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = container_id;
#line 142 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp1_ = rygel_media_export_media_cache_get_object (self, _tmp0_, &_inner_error_);
#line 142 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	object = _tmp1_;
#line 142 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 142 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if ((_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) || (_inner_error_->domain == RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR)) {
#line 142 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_propagate_error (error, _inner_error_);
#line 142 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return NULL;
#line 1189 "rygel-media-export-media-cache.c"
		} else {
#line 142 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 142 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_clear_error (&_inner_error_);
#line 142 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return NULL;
#line 1197 "rygel-media-export-media-cache.c"
		}
	}
#line 143 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp3_ = object;
#line 143 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_tmp3_ != NULL) {
#line 1204 "rygel-media-export-media-cache.c"
		RygelMediaObject* _tmp4_;
#line 143 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp4_ = object;
#line 143 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp2_ = !RYGEL_IS_MEDIA_CONTAINER (_tmp4_);
#line 1210 "rygel-media-export-media-cache.c"
	} else {
#line 143 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp2_ = FALSE;
#line 1214 "rygel-media-export-media-cache.c"
	}
#line 143 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp5_ = _tmp2_;
#line 143 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_tmp5_) {
#line 1220 "rygel-media-export-media-cache.c"
		const gchar* _tmp6_;
		GError* _tmp7_;
#line 144 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp6_ = container_id;
#line 144 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp7_ = g_error_new (RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR, RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_INVALID_TYPE, "Object with id %s is " "not a MediaContainer", _tmp6_);
#line 144 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_inner_error_ = _tmp7_;
#line 144 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if ((_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) || (_inner_error_->domain == RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR)) {
#line 144 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_propagate_error (error, _inner_error_);
#line 144 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_object_unref0 (object);
#line 144 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return NULL;
#line 1237 "rygel-media-export-media-cache.c"
		} else {
#line 144 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_object_unref0 (object);
#line 144 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 144 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_clear_error (&_inner_error_);
#line 144 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return NULL;
#line 1247 "rygel-media-export-media-cache.c"
		}
	}
#line 149 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp8_ = object;
#line 149 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp9_ = _g_object_ref0 (RYGEL_IS_MEDIA_CONTAINER (_tmp8_) ? ((RygelMediaContainer*) _tmp8_) : NULL);
#line 149 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	result = _tmp9_;
#line 149 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_object_unref0 (object);
#line 149 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return result;
#line 1260 "rygel-media-export-media-cache.c"
}


gint rygel_media_export_media_cache_get_child_count (RygelMediaExportMediaCache* self, const gchar* container_id, GError** error) {
	gint result = 0;
	const gchar* _tmp0_;
	GValue _tmp1_ = {0};
	GValue* _tmp2_ = NULL;
	GValue* values;
	gint values_length1;
	gint _values_size_;
	gint _tmp3_ = 0;
	gint _tmp4_;
	GError * _inner_error_ = NULL;
#line 152 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 152 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (container_id != NULL, 0);
#line 153 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = container_id;
#line 153 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp1_, G_TYPE_STRING);
#line 153 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_string (&_tmp1_, _tmp0_);
#line 153 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp2_ = g_new0 (GValue, 1);
#line 153 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp2_[0] = _tmp1_;
#line 153 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	values = _tmp2_;
#line 153 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	values_length1 = 1;
#line 153 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_values_size_ = values_length1;
#line 155 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp3_ = rygel_media_export_media_cache_query_value (self, RYGEL_MEDIA_EXPORT_SQL_STRING_CHILD_COUNT, values, values_length1, &_inner_error_);
#line 155 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp4_ = _tmp3_;
#line 155 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 155 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 155 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_propagate_error (error, _inner_error_);
#line 155 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 155 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return 0;
#line 1309 "rygel-media-export-media-cache.c"
		} else {
#line 155 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 155 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 155 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_clear_error (&_inner_error_);
#line 155 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return 0;
#line 1319 "rygel-media-export-media-cache.c"
		}
	}
#line 155 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	result = _tmp4_;
#line 155 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 155 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return result;
#line 1328 "rygel-media-export-media-cache.c"
}


gboolean rygel_media_export_media_cache_exists (RygelMediaExportMediaCache* self, GFile* file, gint64* timestamp, gint64* size, GError** error) {
	gint64 _vala_timestamp = 0LL;
	gint64 _vala_size = 0LL;
	gboolean result = FALSE;
	GFile* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* uri;
	const gchar* _tmp2_;
	GValue _tmp3_ = {0};
	GValue* _tmp4_ = NULL;
	GValue* values;
	gint values_length1;
	gint _values_size_;
	GeeHashMap* _tmp5_;
	const gchar* _tmp6_;
	gboolean _tmp7_ = FALSE;
	GValue* _tmp17_;
	gint _tmp17__length1;
	RygelMediaExportDatabaseCursor* _tmp18_ = NULL;
	RygelMediaExportDatabaseCursor* cursor;
	RygelMediaExportDatabaseCursor* _tmp19_;
	sqlite3_stmt* _tmp20_ = NULL;
	sqlite3_stmt* statement;
	sqlite3_stmt* _tmp21_;
	gint64 _tmp22_ = 0LL;
	sqlite3_stmt* _tmp23_;
	gint64 _tmp24_ = 0LL;
	sqlite3_stmt* _tmp25_;
	gint _tmp26_ = 0;
	GError * _inner_error_ = NULL;
#line 159 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 159 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (file != NULL, FALSE);
#line 162 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = file;
#line 162 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp1_ = g_file_get_uri (_tmp0_);
#line 162 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	uri = _tmp1_;
#line 163 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp2_ = uri;
#line 163 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp3_, G_TYPE_STRING);
#line 163 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_string (&_tmp3_, _tmp2_);
#line 163 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp4_ = g_new0 (GValue, 1);
#line 163 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp4_[0] = _tmp3_;
#line 163 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	values = _tmp4_;
#line 163 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	values_length1 = 1;
#line 163 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_values_size_ = values_length1;
#line 165 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp5_ = self->priv->exists_cache;
#line 165 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp6_ = uri;
#line 165 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp7_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp5_, _tmp6_);
#line 165 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_tmp7_) {
#line 1396 "rygel-media-export-media-cache.c"
		GeeHashMap* _tmp8_;
		const gchar* _tmp9_;
		gpointer _tmp10_ = NULL;
		RygelMediaExportExistsCacheEntry* entry;
		GeeHashMap* _tmp11_;
		const gchar* _tmp12_;
		RygelMediaExportExistsCacheEntry* _tmp13_;
		gint64 _tmp14_;
		RygelMediaExportExistsCacheEntry* _tmp15_;
		gint64 _tmp16_;
#line 166 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp8_ = self->priv->exists_cache;
#line 166 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp9_ = uri;
#line 166 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp10_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp8_, _tmp9_);
#line 166 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		entry = (RygelMediaExportExistsCacheEntry*) _tmp10_;
#line 167 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp11_ = self->priv->exists_cache;
#line 167 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp12_ = uri;
#line 167 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		gee_abstract_map_unset ((GeeAbstractMap*) _tmp11_, _tmp12_, NULL);
#line 168 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp13_ = entry;
#line 168 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp14_ = (*_tmp13_).mtime;
#line 168 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_vala_timestamp = _tmp14_;
#line 169 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp15_ = entry;
#line 169 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp16_ = (*_tmp15_).size;
#line 169 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_vala_size = _tmp16_;
#line 171 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		result = TRUE;
#line 171 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_rygel_media_export_exists_cache_entry_free0 (entry);
#line 171 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 171 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_free0 (uri);
#line 171 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (timestamp) {
#line 171 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			*timestamp = _vala_timestamp;
#line 1445 "rygel-media-export-media-cache.c"
		}
#line 171 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (size) {
#line 171 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			*size = _vala_size;
#line 1451 "rygel-media-export-media-cache.c"
		}
#line 171 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return result;
#line 1455 "rygel-media-export-media-cache.c"
	}
#line 174 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp17_ = values;
#line 174 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp17__length1 = values_length1;
#line 174 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp18_ = rygel_media_export_media_cache_exec_cursor (self, RYGEL_MEDIA_EXPORT_SQL_STRING_EXISTS, _tmp17_, _tmp17__length1, &_inner_error_);
#line 174 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	cursor = _tmp18_;
#line 174 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 174 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 174 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_propagate_error (error, _inner_error_);
#line 174 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 174 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_free0 (uri);
#line 174 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return FALSE;
#line 1477 "rygel-media-export-media-cache.c"
		} else {
#line 174 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 174 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_free0 (uri);
#line 174 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 174 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_clear_error (&_inner_error_);
#line 174 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return FALSE;
#line 1489 "rygel-media-export-media-cache.c"
		}
	}
#line 175 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp19_ = cursor;
#line 175 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp20_ = rygel_media_export_database_cursor_next (_tmp19_, &_inner_error_);
#line 175 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	statement = _tmp20_;
#line 175 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 175 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 175 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_propagate_error (error, _inner_error_);
#line 175 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_object_unref0 (cursor);
#line 175 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 175 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_free0 (uri);
#line 175 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return FALSE;
#line 1512 "rygel-media-export-media-cache.c"
		} else {
#line 175 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_object_unref0 (cursor);
#line 175 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 175 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_free0 (uri);
#line 175 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 175 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_clear_error (&_inner_error_);
#line 175 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return FALSE;
#line 1526 "rygel-media-export-media-cache.c"
		}
	}
#line 176 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp21_ = statement;
#line 176 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp22_ = sqlite3_column_int64 (_tmp21_, 1);
#line 176 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_vala_timestamp = _tmp22_;
#line 177 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp23_ = statement;
#line 177 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp24_ = sqlite3_column_int64 (_tmp23_, 2);
#line 177 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_vala_size = _tmp24_;
#line 179 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp25_ = statement;
#line 179 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp26_ = sqlite3_column_int (_tmp25_, 0);
#line 179 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	result = _tmp26_ == 1;
#line 179 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_object_unref0 (cursor);
#line 179 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 179 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_free0 (uri);
#line 179 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (timestamp) {
#line 179 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		*timestamp = _vala_timestamp;
#line 1557 "rygel-media-export-media-cache.c"
	}
#line 179 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (size) {
#line 179 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		*size = _vala_size;
#line 1563 "rygel-media-export-media-cache.c"
	}
#line 179 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return result;
#line 1567 "rygel-media-export-media-cache.c"
}


RygelMediaObjects* rygel_media_export_media_cache_get_children (RygelMediaExportMediaCache* self, RygelMediaContainer* container, const gchar* sort_criteria, glong offset, glong max_count, GError** error) {
	RygelMediaObjects* result = NULL;
	RygelMediaObjects* _tmp0_;
	RygelMediaObjects* children;
	RygelMediaContainer* _tmp1_;
	const gchar* _tmp2_;
	GValue _tmp3_ = {0};
	glong _tmp4_;
	GValue _tmp5_ = {0};
	glong _tmp6_;
	GValue _tmp7_ = {0};
	GValue* _tmp8_ = NULL;
	GValue* values;
	gint values_length1;
	gint _values_size_;
	RygelMediaExportSQLFactory* _tmp9_;
	const gchar* _tmp10_ = NULL;
	gchar* _tmp11_;
	gchar* sql;
	const gchar* _tmp12_;
	gchar* _tmp13_ = NULL;
	gchar* sort_order;
	RygelMediaExportDatabase* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_ = NULL;
	gchar* _tmp18_;
	GValue* _tmp19_;
	gint _tmp19__length1;
	RygelMediaExportDatabaseCursor* _tmp20_ = NULL;
	RygelMediaExportDatabaseCursor* _tmp21_;
	RygelMediaExportDatabaseCursor* cursor;
	GError * _inner_error_ = NULL;
#line 182 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 182 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (container != NULL, NULL);
#line 182 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (sort_criteria != NULL, NULL);
#line 187 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = rygel_media_objects_new ();
#line 187 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	children = _tmp0_;
#line 189 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp1_ = container;
#line 189 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp2_ = ((RygelMediaObject*) _tmp1_)->id;
#line 189 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp3_, G_TYPE_STRING);
#line 189 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_string (&_tmp3_, _tmp2_);
#line 189 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp4_ = offset;
#line 189 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp5_, G_TYPE_LONG);
#line 189 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_long (&_tmp5_, _tmp4_);
#line 189 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp6_ = max_count;
#line 189 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp7_, G_TYPE_LONG);
#line 189 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_long (&_tmp7_, _tmp6_);
#line 189 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp8_ = g_new0 (GValue, 3);
#line 189 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp8_[0] = _tmp3_;
#line 189 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp8_[1] = _tmp5_;
#line 189 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp8_[2] = _tmp7_;
#line 189 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	values = _tmp8_;
#line 189 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	values_length1 = 3;
#line 189 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_values_size_ = values_length1;
#line 193 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp9_ = self->priv->sql;
#line 193 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp10_ = rygel_media_export_sql_factory_make (_tmp9_, RYGEL_MEDIA_EXPORT_SQL_STRING_GET_CHILDREN);
#line 193 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp11_ = g_strdup (_tmp10_);
#line 193 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	sql = _tmp11_;
#line 194 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp12_ = sort_criteria;
#line 194 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp13_ = rygel_media_export_media_cache_translate_sort_criteria (self, _tmp12_);
#line 194 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	sort_order = _tmp13_;
#line 195 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp14_ = self->priv->db;
#line 195 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp15_ = sql;
#line 195 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp16_ = sort_order;
#line 195 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp17_ = g_strdup_printf (_tmp15_, _tmp16_);
#line 195 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp18_ = _tmp17_;
#line 195 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp19_ = values;
#line 195 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp19__length1 = values_length1;
#line 195 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp20_ = rygel_media_export_database_exec_cursor (_tmp14_, _tmp18_, _tmp19_, _tmp19__length1, &_inner_error_);
#line 195 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp21_ = _tmp20_;
#line 195 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_free0 (_tmp18_);
#line 195 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	cursor = _tmp21_;
#line 195 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 195 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 195 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_free0 (sort_order);
#line 195 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_free0 (sql);
#line 195 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 195 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_object_unref0 (children);
#line 195 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return NULL;
#line 1698 "rygel-media-export-media-cache.c"
	}
	{
		RygelMediaExportDatabaseCursor* _tmp22_;
		RygelMediaExportDatabaseCursorIterator* _tmp23_ = NULL;
		RygelMediaExportDatabaseCursorIterator* _statement_it;
#line 197 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp22_ = cursor;
#line 197 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp23_ = rygel_media_export_database_cursor_iterator (_tmp22_);
#line 197 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_statement_it = _tmp23_;
#line 197 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		while (TRUE) {
#line 1712 "rygel-media-export-media-cache.c"
			RygelMediaExportDatabaseCursorIterator* _tmp24_;
			gboolean _tmp25_ = FALSE;
			RygelMediaExportDatabaseCursorIterator* _tmp26_;
			sqlite3_stmt* _tmp27_ = NULL;
			sqlite3_stmt* statement;
			RygelMediaObjects* _tmp28_;
			RygelMediaContainer* _tmp29_;
			sqlite3_stmt* _tmp30_;
			RygelMediaObject* _tmp31_ = NULL;
			RygelMediaObject* _tmp32_;
			RygelMediaObjects* _tmp33_;
			gpointer _tmp34_ = NULL;
			RygelMediaObject* _tmp35_;
			RygelMediaContainer* _tmp36_;
#line 197 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp24_ = _statement_it;
#line 197 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp25_ = rygel_media_export_database_cursor_iterator_next (_tmp24_);
#line 197 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (!_tmp25_) {
#line 197 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				break;
#line 1735 "rygel-media-export-media-cache.c"
			}
#line 197 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp26_ = _statement_it;
#line 197 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp27_ = rygel_media_export_database_cursor_iterator_get (_tmp26_, &_inner_error_);
#line 197 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			statement = _tmp27_;
#line 197 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (_inner_error_ != NULL) {
#line 197 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				g_propagate_error (error, _inner_error_);
#line 197 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
#line 197 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_object_unref0 (cursor);
#line 197 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_free0 (sort_order);
#line 197 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_free0 (sql);
#line 197 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 197 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_object_unref0 (children);
#line 197 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				return NULL;
#line 1761 "rygel-media-export-media-cache.c"
			}
#line 198 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp28_ = children;
#line 198 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp29_ = container;
#line 198 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp30_ = statement;
#line 198 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp31_ = rygel_media_export_media_cache_get_object_from_statement (self, _tmp29_, _tmp30_);
#line 198 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp32_ = _tmp31_;
#line 198 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp28_, _tmp32_);
#line 198 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_object_unref0 (_tmp32_);
#line 200 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp33_ = children;
#line 200 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp34_ = gee_abstract_list_last ((GeeAbstractList*) _tmp33_);
#line 200 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp35_ = (RygelMediaObject*) _tmp34_;
#line 200 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp36_ = container;
#line 200 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			rygel_media_object_set_parent_ref (_tmp35_, _tmp36_);
#line 200 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_object_unref0 (_tmp35_);
#line 1789 "rygel-media-export-media-cache.c"
		}
#line 197 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
#line 1793 "rygel-media-export-media-cache.c"
	}
#line 203 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	result = children;
#line 203 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_object_unref0 (cursor);
#line 203 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_free0 (sort_order);
#line 203 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_free0 (sql);
#line 203 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 203 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return result;
#line 1807 "rygel-media-export-media-cache.c"
}


RygelMediaObjects* rygel_media_export_media_cache_get_objects_by_search_expression (RygelMediaExportMediaCache* self, RygelSearchExpression* expression, const gchar* container_id, const gchar* sort_criteria, guint offset, guint max_count, guint* total_matches, GError** error) {
	guint _vala_total_matches = 0U;
	RygelMediaObjects* result = NULL;
	GValueArray* _tmp0_;
	GValueArray* args;
	RygelSearchExpression* _tmp1_;
	GValueArray* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* filter;
	RygelSearchExpression* _tmp4_;
	guint _tmp9_;
	guint _tmp10_ = 0U;
	guint max_objects;
	const gchar* _tmp11_;
	GValueArray* _tmp12_;
	const gchar* _tmp13_;
	glong _tmp14_ = 0L;
	glong _tmp15_;
	const gchar* _tmp16_;
	GValueArray* _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	guint _tmp20_;
	guint _tmp21_;
	RygelMediaObjects* _tmp22_ = NULL;
	RygelMediaObjects* _tmp23_;
	GError * _inner_error_ = NULL;
#line 206 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 206 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (sort_criteria != NULL, NULL);
#line 214 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = g_value_array_new ((guint) 0);
#line 214 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	args = _tmp0_;
#line 215 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp1_ = expression;
#line 215 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp2_ = args;
#line 215 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp3_ = rygel_media_export_media_cache_translate_search_expression (self, _tmp1_, _tmp2_, "WHERE", &_inner_error_);
#line 215 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	filter = _tmp3_;
#line 215 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 215 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 215 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_value_array_free0 (args);
#line 215 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return NULL;
#line 1862 "rygel-media-export-media-cache.c"
	}
#line 217 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp4_ = expression;
#line 217 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_tmp4_ != NULL) {
#line 1868 "rygel-media-export-media-cache.c"
		RygelSearchExpression* _tmp5_;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_;
		const gchar* _tmp8_;
#line 218 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp5_ = expression;
#line 218 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp6_ = rygel_search_expression_to_string (_tmp5_);
#line 218 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp7_ = _tmp6_;
#line 218 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_debug ("rygel-media-export-media-cache.vala:218: Original search: %s", _tmp7_);
#line 218 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_free0 (_tmp7_);
#line 219 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp8_ = filter;
#line 219 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_debug ("rygel-media-export-media-cache.vala:219: Parsed search expression: %s", _tmp8_);
#line 1887 "rygel-media-export-media-cache.c"
	}
#line 222 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp9_ = max_count;
#line 222 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp10_ = rygel_media_export_media_cache_modify_limit (self, _tmp9_);
#line 222 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	max_objects = _tmp10_;
#line 223 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp11_ = filter;
#line 223 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp12_ = args;
#line 223 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp13_ = container_id;
#line 223 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp14_ = rygel_media_export_media_cache_get_object_count_by_filter (self, _tmp11_, _tmp12_, _tmp13_, &_inner_error_);
#line 223 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp15_ = _tmp14_;
#line 223 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 223 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 223 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_free0 (filter);
#line 223 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_value_array_free0 (args);
#line 223 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return NULL;
#line 1915 "rygel-media-export-media-cache.c"
	}
#line 223 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_vala_total_matches = (guint) _tmp15_;
#line 227 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp16_ = filter;
#line 227 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp17_ = args;
#line 227 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp18_ = container_id;
#line 227 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp19_ = sort_criteria;
#line 227 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp20_ = offset;
#line 227 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp21_ = max_objects;
#line 227 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp22_ = rygel_media_export_media_cache_get_objects_by_filter (self, _tmp16_, _tmp17_, _tmp18_, _tmp19_, (glong) _tmp20_, (glong) _tmp21_, &_inner_error_);
#line 227 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp23_ = _tmp22_;
#line 227 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 227 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 227 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_free0 (filter);
#line 227 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_value_array_free0 (args);
#line 227 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return NULL;
#line 1945 "rygel-media-export-media-cache.c"
	}
#line 227 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	result = _tmp23_;
#line 227 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_free0 (filter);
#line 227 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_value_array_free0 (args);
#line 227 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (total_matches) {
#line 227 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		*total_matches = _vala_total_matches;
#line 1957 "rygel-media-export-media-cache.c"
	}
#line 227 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return result;
#line 1961 "rygel-media-export-media-cache.c"
}


static GValue* _g_value_dup (GValue* self) {
#line 248 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return g_boxed_copy (G_TYPE_VALUE, self);
#line 1968 "rygel-media-export-media-cache.c"
}


static gpointer __g_value_dup0 (gpointer self) {
#line 248 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return self ? _g_value_dup (self) : NULL;
#line 1975 "rygel-media-export-media-cache.c"
}


static void _vala_GValue_free (GValue* self) {
#line 247 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_unset (self);
#line 247 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_free (self);
#line 1984 "rygel-media-export-media-cache.c"
}


glong rygel_media_export_media_cache_get_object_count_by_search_expression (RygelMediaExportMediaCache* self, RygelSearchExpression* expression, const gchar* container_id, GError** error) {
	glong result = 0L;
	GValueArray* _tmp0_;
	GValueArray* args;
	RygelSearchExpression* _tmp1_;
	GValueArray* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* filter;
	RygelSearchExpression* _tmp4_;
	const gchar* _tmp29_;
	GValueArray* _tmp30_;
	const gchar* _tmp31_;
	glong _tmp32_ = 0L;
	glong _tmp33_;
	GError * _inner_error_ = NULL;
#line 235 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, 0L);
#line 239 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = g_value_array_new ((guint) 0);
#line 239 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	args = _tmp0_;
#line 240 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp1_ = expression;
#line 240 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp2_ = args;
#line 240 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp3_ = rygel_media_export_media_cache_translate_search_expression (self, _tmp1_, _tmp2_, "WHERE", &_inner_error_);
#line 240 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	filter = _tmp3_;
#line 240 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 240 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 240 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_value_array_free0 (args);
#line 240 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return 0L;
#line 2025 "rygel-media-export-media-cache.c"
	}
#line 242 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp4_ = expression;
#line 242 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_tmp4_ != NULL) {
#line 2031 "rygel-media-export-media-cache.c"
		RygelSearchExpression* _tmp5_;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_;
		const gchar* _tmp8_;
#line 243 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp5_ = expression;
#line 243 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp6_ = rygel_search_expression_to_string (_tmp5_);
#line 243 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp7_ = _tmp6_;
#line 243 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_debug ("rygel-media-export-media-cache.vala:243: Original search: %s", _tmp7_);
#line 243 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_free0 (_tmp7_);
#line 244 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp8_ = filter;
#line 244 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_debug ("rygel-media-export-media-cache.vala:244: Parsed search expression: %s", _tmp8_);
#line 2050 "rygel-media-export-media-cache.c"
	}
	{
		gint i;
#line 247 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		i = 0;
#line 2056 "rygel-media-export-media-cache.c"
		{
			gboolean _tmp9_;
#line 247 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp9_ = TRUE;
#line 247 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			while (TRUE) {
#line 2063 "rygel-media-export-media-cache.c"
				gboolean _tmp10_;
				gint _tmp12_;
				GValueArray* _tmp13_;
				guint _tmp14_;
				GValueArray* _tmp15_;
				gint _tmp16_;
				GValue* _tmp17_ = NULL;
				GValue* _tmp18_;
				GValue* arg;
				gchar* _tmp19_ = NULL;
				GValue* _tmp20_;
				gboolean _tmp21_ = FALSE;
				gint _tmp27_;
				const gchar* _tmp28_;
#line 247 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp10_ = _tmp9_;
#line 247 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				if (!_tmp10_) {
#line 2082 "rygel-media-export-media-cache.c"
					gint _tmp11_;
#line 247 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp11_ = i;
#line 247 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					i = _tmp11_ + 1;
#line 2088 "rygel-media-export-media-cache.c"
				}
#line 247 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp9_ = FALSE;
#line 247 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp12_ = i;
#line 247 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp13_ = args;
#line 247 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp14_ = _tmp13_->n_values;
#line 247 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				if (!(((guint) _tmp12_) < _tmp14_)) {
#line 247 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					break;
#line 2102 "rygel-media-export-media-cache.c"
				}
#line 248 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp15_ = args;
#line 248 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp16_ = i;
#line 248 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp17_ = g_value_array_get_nth (_tmp15_, (guint) _tmp16_);
#line 248 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp18_ = __g_value_dup0 (_tmp17_);
#line 248 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				arg = _tmp18_;
#line 249 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp20_ = arg;
#line 249 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp21_ = G_VALUE_HOLDS (_tmp20_, G_TYPE_STRING);
#line 249 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				if (_tmp21_) {
#line 2120 "rygel-media-export-media-cache.c"
					GValue* _tmp22_;
					const gchar* _tmp23_ = NULL;
					gchar* _tmp24_;
#line 250 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp22_ = arg;
#line 250 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp23_ = g_value_get_string (_tmp22_);
#line 250 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp24_ = g_strdup (_tmp23_);
#line 250 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_g_free0 (_tmp19_);
#line 250 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp19_ = _tmp24_;
#line 2134 "rygel-media-export-media-cache.c"
				} else {
					GValue* _tmp25_;
					gchar* _tmp26_ = NULL;
#line 251 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp25_ = arg;
#line 251 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp26_ = g_strdup_value_contents (_tmp25_);
#line 251 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_g_free0 (_tmp19_);
#line 251 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp19_ = _tmp26_;
#line 2146 "rygel-media-export-media-cache.c"
				}
#line 249 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp27_ = i;
#line 249 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp28_ = _tmp19_;
#line 249 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				g_debug ("rygel-media-export-media-cache.vala:249: Arg %d: %s", _tmp27_, _tmp28_);
#line 247 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_free0 (_tmp19_);
#line 247 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				__vala_GValue_free0 (arg);
#line 2158 "rygel-media-export-media-cache.c"
			}
		}
	}
#line 254 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp29_ = filter;
#line 254 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp30_ = args;
#line 254 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp31_ = container_id;
#line 254 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp32_ = rygel_media_export_media_cache_get_object_count_by_filter (self, _tmp29_, _tmp30_, _tmp31_, &_inner_error_);
#line 254 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp33_ = _tmp32_;
#line 254 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 254 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 254 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_free0 (filter);
#line 254 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_value_array_free0 (args);
#line 254 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return 0L;
#line 2182 "rygel-media-export-media-cache.c"
	}
#line 254 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	result = _tmp33_;
#line 254 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_free0 (filter);
#line 254 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_value_array_free0 (args);
#line 254 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return result;
#line 2192 "rygel-media-export-media-cache.c"
}


glong rygel_media_export_media_cache_get_object_count_by_filter (RygelMediaExportMediaCache* self, const gchar* filter, GValueArray* args, const gchar* container_id, GError** error) {
	glong result = 0L;
	const gchar* _tmp0_;
	GValueArray* _tmp5_;
	guint _tmp6_;
	const gchar* pattern = NULL;
	RygelMediaExportSQLString string_id = 0;
	const gchar* _tmp7_;
	RygelMediaExportSQLFactory* _tmp8_;
	RygelMediaExportSQLString _tmp9_;
	const gchar* _tmp10_ = NULL;
	RygelMediaExportDatabase* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_;
	GValueArray* _tmp15_;
	GValue* _tmp16_;
	gint _tmp16__length1;
	gint _tmp17_ = 0;
	gint _tmp18_;
	gint _tmp19_;
	GError * _inner_error_ = NULL;
#line 259 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, 0L);
#line 259 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (filter != NULL, 0L);
#line 259 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (args != NULL, 0L);
#line 264 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = container_id;
#line 264 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_tmp0_ != NULL) {
#line 2228 "rygel-media-export-media-cache.c"
		const gchar* _tmp1_;
		GValue _tmp2_ = {0};
		GValue v;
		GValueArray* _tmp3_;
		GValue _tmp4_;
#line 265 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp1_ = container_id;
#line 265 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_init (&_tmp2_, G_TYPE_STRING);
#line 265 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_set_string (&_tmp2_, _tmp1_);
#line 265 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		v = _tmp2_;
#line 266 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp3_ = args;
#line 266 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp4_ = v;
#line 266 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_array_prepend (_tmp3_, &_tmp4_);
#line 264 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
#line 2250 "rygel-media-export-media-cache.c"
	}
#line 269 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp5_ = args;
#line 269 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp6_ = _tmp5_->n_values;
#line 269 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_debug ("rygel-media-export-media-cache.vala:269: Parameters to bind: %u", _tmp6_);
#line 272 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp7_ = container_id;
#line 272 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_tmp7_ != NULL) {
#line 273 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		string_id = RYGEL_MEDIA_EXPORT_SQL_STRING_GET_OBJECT_COUNT_BY_FILTER_WITH_ANCESTOR;
#line 2264 "rygel-media-export-media-cache.c"
	} else {
#line 275 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		string_id = RYGEL_MEDIA_EXPORT_SQL_STRING_GET_OBJECT_COUNT_BY_FILTER;
#line 2268 "rygel-media-export-media-cache.c"
	}
#line 277 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp8_ = self->priv->sql;
#line 277 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp9_ = string_id;
#line 277 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp10_ = rygel_media_export_sql_factory_make (_tmp8_, _tmp9_);
#line 277 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	pattern = _tmp10_;
#line 279 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp11_ = self->priv->db;
#line 279 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp12_ = filter;
#line 279 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp13_ = g_strdup_printf (pattern, _tmp12_);
#line 279 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp14_ = _tmp13_;
#line 279 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp15_ = args;
#line 279 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp16_ = _tmp15_->values;
#line 279 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp16__length1 = (gint) _tmp15_->n_values;
#line 279 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp17_ = rygel_media_export_database_query_value (_tmp11_, _tmp14_, _tmp16_, _tmp16__length1, &_inner_error_);
#line 279 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp18_ = _tmp17_;
#line 279 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_free0 (_tmp14_);
#line 279 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp19_ = _tmp18_;
#line 279 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 279 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 279 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return 0L;
#line 2306 "rygel-media-export-media-cache.c"
	}
#line 279 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	result = (glong) _tmp19_;
#line 279 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return result;
#line 2312 "rygel-media-export-media-cache.c"
}


RygelMediaObjects* rygel_media_export_media_cache_get_objects_by_filter (RygelMediaExportMediaCache* self, const gchar* filter, GValueArray* args, const gchar* container_id, const gchar* sort_criteria, glong offset, glong max_count, GError** error) {
	RygelMediaObjects* result = NULL;
	RygelMediaObjects* _tmp0_;
	RygelMediaObjects* children;
	glong _tmp1_;
	GValue _tmp2_ = {0};
	GValue v;
	GValueArray* _tmp3_;
	GValue _tmp4_;
	glong _tmp5_;
	GValue _tmp6_ = {0};
	GValueArray* _tmp7_;
	GValue _tmp8_;
	RygelMediaContainer* parent;
	GValueArray* _tmp9_;
	guint _tmp10_;
	const gchar* sql = NULL;
	const gchar* _tmp31_;
	const gchar* _tmp36_;
	gchar* _tmp37_ = NULL;
	gchar* sort_order;
	RygelMediaExportDatabase* _tmp38_;
	const gchar* _tmp39_;
	const gchar* _tmp40_;
	const gchar* _tmp41_;
	gchar* _tmp42_ = NULL;
	gchar* _tmp43_;
	GValueArray* _tmp44_;
	GValue* _tmp45_;
	gint _tmp45__length1;
	RygelMediaExportDatabaseCursor* _tmp46_ = NULL;
	RygelMediaExportDatabaseCursor* _tmp47_;
	RygelMediaExportDatabaseCursor* cursor;
	GError * _inner_error_ = NULL;
#line 282 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 282 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (filter != NULL, NULL);
#line 282 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (args != NULL, NULL);
#line 282 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (sort_criteria != NULL, NULL);
#line 289 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = rygel_media_objects_new ();
#line 289 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	children = _tmp0_;
#line 290 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp1_ = offset;
#line 290 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp2_, G_TYPE_LONG);
#line 290 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_long (&_tmp2_, _tmp1_);
#line 290 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	v = _tmp2_;
#line 291 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp3_ = args;
#line 291 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp4_ = v;
#line 291 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_array_append (_tmp3_, &_tmp4_);
#line 292 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp5_ = max_count;
#line 292 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp6_, G_TYPE_LONG);
#line 292 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_long (&_tmp6_, _tmp5_);
#line 292 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
#line 292 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	v = _tmp6_;
#line 293 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp7_ = args;
#line 293 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp8_ = v;
#line 293 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_array_append (_tmp7_, &_tmp8_);
#line 294 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	parent = NULL;
#line 296 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp9_ = args;
#line 296 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp10_ = _tmp9_->n_values;
#line 296 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_debug ("rygel-media-export-media-cache.vala:296: Parameters to bind: %u", _tmp10_);
#line 2400 "rygel-media-export-media-cache.c"
	{
		gint i;
#line 297 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		i = 0;
#line 2405 "rygel-media-export-media-cache.c"
		{
			gboolean _tmp11_;
#line 297 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp11_ = TRUE;
#line 297 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			while (TRUE) {
#line 2412 "rygel-media-export-media-cache.c"
				gboolean _tmp12_;
				gint _tmp14_;
				GValueArray* _tmp15_;
				guint _tmp16_;
				GValueArray* _tmp17_;
				gint _tmp18_;
				GValue* _tmp19_ = NULL;
				GValue* _tmp20_;
				GValue* arg;
				gchar* _tmp21_ = NULL;
				GValue* _tmp22_;
				gboolean _tmp23_ = FALSE;
				gint _tmp29_;
				const gchar* _tmp30_;
#line 297 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp12_ = _tmp11_;
#line 297 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				if (!_tmp12_) {
#line 2431 "rygel-media-export-media-cache.c"
					gint _tmp13_;
#line 297 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp13_ = i;
#line 297 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					i = _tmp13_ + 1;
#line 2437 "rygel-media-export-media-cache.c"
				}
#line 297 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp11_ = FALSE;
#line 297 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp14_ = i;
#line 297 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp15_ = args;
#line 297 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp16_ = _tmp15_->n_values;
#line 297 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				if (!(((guint) _tmp14_) < _tmp16_)) {
#line 297 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					break;
#line 2451 "rygel-media-export-media-cache.c"
				}
#line 298 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp17_ = args;
#line 298 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp18_ = i;
#line 298 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp19_ = g_value_array_get_nth (_tmp17_, (guint) _tmp18_);
#line 298 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp20_ = __g_value_dup0 (_tmp19_);
#line 298 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				arg = _tmp20_;
#line 299 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp22_ = arg;
#line 299 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp23_ = G_VALUE_HOLDS (_tmp22_, G_TYPE_STRING);
#line 299 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				if (_tmp23_) {
#line 2469 "rygel-media-export-media-cache.c"
					GValue* _tmp24_;
					const gchar* _tmp25_ = NULL;
					gchar* _tmp26_;
#line 300 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp24_ = arg;
#line 300 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp25_ = g_value_get_string (_tmp24_);
#line 300 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp26_ = g_strdup (_tmp25_);
#line 300 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_g_free0 (_tmp21_);
#line 300 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp21_ = _tmp26_;
#line 2483 "rygel-media-export-media-cache.c"
				} else {
					GValue* _tmp27_;
					gchar* _tmp28_ = NULL;
#line 301 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp27_ = arg;
#line 301 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp28_ = g_strdup_value_contents (_tmp27_);
#line 301 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_g_free0 (_tmp21_);
#line 301 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp21_ = _tmp28_;
#line 2495 "rygel-media-export-media-cache.c"
				}
#line 299 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp29_ = i;
#line 299 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp30_ = _tmp21_;
#line 299 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				g_debug ("rygel-media-export-media-cache.vala:299: Arg %d: %s", _tmp29_, _tmp30_);
#line 297 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_free0 (_tmp21_);
#line 297 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				__vala_GValue_free0 (arg);
#line 2507 "rygel-media-export-media-cache.c"
			}
		}
	}
#line 305 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp31_ = container_id;
#line 305 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_tmp31_ != NULL) {
#line 2515 "rygel-media-export-media-cache.c"
		RygelMediaExportSQLFactory* _tmp32_;
		const gchar* _tmp33_ = NULL;
#line 306 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp32_ = self->priv->sql;
#line 306 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp33_ = rygel_media_export_sql_factory_make (_tmp32_, RYGEL_MEDIA_EXPORT_SQL_STRING_GET_OBJECTS_BY_FILTER_WITH_ANCESTOR);
#line 306 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		sql = _tmp33_;
#line 2524 "rygel-media-export-media-cache.c"
	} else {
		RygelMediaExportSQLFactory* _tmp34_;
		const gchar* _tmp35_ = NULL;
#line 308 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp34_ = self->priv->sql;
#line 308 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp35_ = rygel_media_export_sql_factory_make (_tmp34_, RYGEL_MEDIA_EXPORT_SQL_STRING_GET_OBJECTS_BY_FILTER);
#line 308 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		sql = _tmp35_;
#line 2534 "rygel-media-export-media-cache.c"
	}
#line 311 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp36_ = sort_criteria;
#line 311 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp37_ = rygel_media_export_media_cache_translate_sort_criteria (self, _tmp36_);
#line 311 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	sort_order = _tmp37_;
#line 312 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp38_ = self->priv->db;
#line 312 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp39_ = sql;
#line 312 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp40_ = filter;
#line 312 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp41_ = sort_order;
#line 312 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp42_ = g_strdup_printf (_tmp39_, _tmp40_, _tmp41_);
#line 312 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp43_ = _tmp42_;
#line 312 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp44_ = args;
#line 312 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp45_ = _tmp44_->values;
#line 312 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp45__length1 = (gint) _tmp44_->n_values;
#line 312 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp46_ = rygel_media_export_database_exec_cursor (_tmp38_, _tmp43_, _tmp45_, _tmp45__length1, &_inner_error_);
#line 312 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp47_ = _tmp46_;
#line 312 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_free0 (_tmp43_);
#line 312 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	cursor = _tmp47_;
#line 312 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 312 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 312 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_free0 (sort_order);
#line 312 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_object_unref0 (parent);
#line 312 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
#line 312 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_object_unref0 (children);
#line 312 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return NULL;
#line 2582 "rygel-media-export-media-cache.c"
	}
	{
		RygelMediaExportDatabaseCursor* _tmp48_;
		RygelMediaExportDatabaseCursorIterator* _tmp49_ = NULL;
		RygelMediaExportDatabaseCursorIterator* _statement_it;
#line 314 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp48_ = cursor;
#line 314 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp49_ = rygel_media_export_database_cursor_iterator (_tmp48_);
#line 314 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_statement_it = _tmp49_;
#line 314 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		while (TRUE) {
#line 2596 "rygel-media-export-media-cache.c"
			RygelMediaExportDatabaseCursorIterator* _tmp50_;
			gboolean _tmp51_ = FALSE;
			RygelMediaExportDatabaseCursorIterator* _tmp52_;
			sqlite3_stmt* _tmp53_ = NULL;
			sqlite3_stmt* statement;
			sqlite3_stmt* _tmp54_;
			const gchar* _tmp55_ = NULL;
			const gchar* parent_id;
			gboolean _tmp56_ = FALSE;
			RygelMediaContainer* _tmp57_;
			gboolean _tmp61_;
			RygelMediaContainer* _tmp66_;
#line 314 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp50_ = _statement_it;
#line 314 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp51_ = rygel_media_export_database_cursor_iterator_next (_tmp50_);
#line 314 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (!_tmp51_) {
#line 314 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				break;
#line 2617 "rygel-media-export-media-cache.c"
			}
#line 314 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp52_ = _statement_it;
#line 314 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp53_ = rygel_media_export_database_cursor_iterator_get (_tmp52_, &_inner_error_);
#line 314 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			statement = _tmp53_;
#line 314 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (_inner_error_ != NULL) {
#line 314 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				g_propagate_error (error, _inner_error_);
#line 314 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
#line 314 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_object_unref0 (cursor);
#line 314 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_free0 (sort_order);
#line 314 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_object_unref0 (parent);
#line 314 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
#line 314 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_object_unref0 (children);
#line 314 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				return NULL;
#line 2643 "rygel-media-export-media-cache.c"
			}
#line 315 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp54_ = statement;
#line 315 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp55_ = sqlite3_column_text (_tmp54_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_PARENT);
#line 315 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			parent_id = _tmp55_;
#line 317 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp57_ = parent;
#line 317 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (_tmp57_ == NULL) {
#line 317 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp56_ = TRUE;
#line 2657 "rygel-media-export-media-cache.c"
			} else {
				const gchar* _tmp58_;
				RygelMediaContainer* _tmp59_;
				const gchar* _tmp60_;
#line 317 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp58_ = parent_id;
#line 317 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp59_ = parent;
#line 317 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp60_ = ((RygelMediaObject*) _tmp59_)->id;
#line 317 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp56_ = g_strcmp0 (_tmp58_, _tmp60_) != 0;
#line 2670 "rygel-media-export-media-cache.c"
			}
#line 317 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp61_ = _tmp56_;
#line 317 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (_tmp61_) {
#line 2676 "rygel-media-export-media-cache.c"
				RygelNullContainer* _tmp62_;
				RygelMediaContainer* _tmp63_;
				const gchar* _tmp64_;
				gchar* _tmp65_;
#line 318 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp62_ = rygel_null_container_new ();
#line 318 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_object_unref0 (parent);
#line 318 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				parent = (RygelMediaContainer*) _tmp62_;
#line 319 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp63_ = parent;
#line 319 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp64_ = parent_id;
#line 319 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp65_ = g_strdup (_tmp64_);
#line 319 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_free0 (((RygelMediaObject*) _tmp63_)->id);
#line 319 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				((RygelMediaObject*) _tmp63_)->id = _tmp65_;
#line 2697 "rygel-media-export-media-cache.c"
			}
#line 322 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp66_ = parent;
#line 322 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (_tmp66_ != NULL) {
#line 2703 "rygel-media-export-media-cache.c"
				RygelMediaObjects* _tmp67_;
				RygelMediaContainer* _tmp68_;
				sqlite3_stmt* _tmp69_;
				RygelMediaObject* _tmp70_ = NULL;
				RygelMediaObject* _tmp71_;
				RygelMediaObjects* _tmp72_;
				gpointer _tmp73_ = NULL;
				RygelMediaObject* _tmp74_;
				RygelMediaContainer* _tmp75_;
#line 323 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp67_ = children;
#line 323 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp68_ = parent;
#line 323 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp69_ = statement;
#line 323 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp70_ = rygel_media_export_media_cache_get_object_from_statement (self, _tmp68_, _tmp69_);
#line 323 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp71_ = _tmp70_;
#line 323 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp67_, _tmp71_);
#line 323 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_object_unref0 (_tmp71_);
#line 325 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp72_ = children;
#line 325 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp73_ = gee_abstract_list_last ((GeeAbstractList*) _tmp72_);
#line 325 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp74_ = (RygelMediaObject*) _tmp73_;
#line 325 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp75_ = parent;
#line 325 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				rygel_media_object_set_parent_ref (_tmp74_, _tmp75_);
#line 325 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_object_unref0 (_tmp74_);
#line 2739 "rygel-media-export-media-cache.c"
			} else {
				sqlite3_stmt* _tmp76_;
				const gchar* _tmp77_ = NULL;
				const gchar* _tmp78_;
#line 327 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp76_ = statement;
#line 327 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp77_ = sqlite3_column_text (_tmp76_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_ID);
#line 327 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp78_ = parent_id;
#line 327 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				g_warning ("Inconsistent database: item %s " "has no parent %s", _tmp77_, _tmp78_);
#line 2752 "rygel-media-export-media-cache.c"
			}
		}
#line 314 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
#line 2757 "rygel-media-export-media-cache.c"
	}
#line 334 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	result = children;
#line 334 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_object_unref0 (cursor);
#line 334 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_free0 (sort_order);
#line 334 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_object_unref0 (parent);
#line 334 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
#line 334 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return result;
#line 2771 "rygel-media-export-media-cache.c"
}


void rygel_media_export_media_cache_debug_statistics (RygelMediaExportMediaCache* self) {
	GError * _inner_error_ = NULL;
#line 337 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_if_fail (self != NULL);
#line 2779 "rygel-media-export-media-cache.c"
	{
		RygelMediaExportDatabaseCursor* _tmp0_ = NULL;
		RygelMediaExportDatabaseCursor* cursor;
#line 339 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_debug ("rygel-media-export-media-cache.vala:339: Database statistics:");
#line 340 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp0_ = rygel_media_export_media_cache_exec_cursor (self, RYGEL_MEDIA_EXPORT_SQL_STRING_STATISTICS, NULL, 0, &_inner_error_);
#line 340 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		cursor = _tmp0_;
#line 340 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_inner_error_ != NULL) {
#line 2791 "rygel-media-export-media-cache.c"
			goto __catch7_g_error;
		}
		{
			RygelMediaExportDatabaseCursor* _tmp1_;
			RygelMediaExportDatabaseCursorIterator* _tmp2_ = NULL;
			RygelMediaExportDatabaseCursorIterator* _statement_it;
#line 341 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp1_ = cursor;
#line 341 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp2_ = rygel_media_export_database_cursor_iterator (_tmp1_);
#line 341 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_statement_it = _tmp2_;
#line 341 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			while (TRUE) {
#line 2806 "rygel-media-export-media-cache.c"
				RygelMediaExportDatabaseCursorIterator* _tmp3_;
				gboolean _tmp4_ = FALSE;
				RygelMediaExportDatabaseCursorIterator* _tmp5_;
				sqlite3_stmt* _tmp6_ = NULL;
				sqlite3_stmt* statement;
				sqlite3_stmt* _tmp7_;
				const gchar* _tmp8_ = NULL;
				sqlite3_stmt* _tmp9_;
				gint _tmp10_ = 0;
#line 341 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp3_ = _statement_it;
#line 341 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp4_ = rygel_media_export_database_cursor_iterator_next (_tmp3_);
#line 341 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				if (!_tmp4_) {
#line 341 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					break;
#line 2824 "rygel-media-export-media-cache.c"
				}
#line 341 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp5_ = _statement_it;
#line 341 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp6_ = rygel_media_export_database_cursor_iterator_get (_tmp5_, &_inner_error_);
#line 341 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				statement = _tmp6_;
#line 341 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				if (_inner_error_ != NULL) {
#line 341 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
#line 341 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_g_object_unref0 (cursor);
#line 2838 "rygel-media-export-media-cache.c"
					goto __catch7_g_error;
				}
#line 342 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp7_ = statement;
#line 342 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp8_ = sqlite3_column_text (_tmp7_, 0);
#line 342 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp9_ = statement;
#line 342 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp10_ = sqlite3_column_int (_tmp9_, 1);
#line 342 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				g_debug ("rygel-media-export-media-cache.vala:342: %s: %d", _tmp8_, _tmp10_);
#line 2851 "rygel-media-export-media-cache.c"
			}
#line 341 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
#line 2855 "rygel-media-export-media-cache.c"
		}
#line 338 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_object_unref0 (cursor);
#line 2859 "rygel-media-export-media-cache.c"
	}
	goto __finally7;
	__catch7_g_error:
	{
		GError* _error_ = NULL;
#line 338 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_error_ = _inner_error_;
#line 338 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_inner_error_ = NULL;
#line 338 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_error_free0 (_error_);
#line 2871 "rygel-media-export-media-cache.c"
	}
	__finally7:
#line 338 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 338 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 338 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_clear_error (&_inner_error_);
#line 338 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return;
#line 2882 "rygel-media-export-media-cache.c"
	}
}


GeeArrayList* rygel_media_export_media_cache_get_child_ids (RygelMediaExportMediaCache* self, const gchar* container_id, GError** error) {
	GeeArrayList* result = NULL;
	GEqualFunc _tmp0_;
	GeeArrayList* _tmp1_;
	GeeArrayList* children;
	const gchar* _tmp2_;
	GValue _tmp3_ = {0};
	GValue* _tmp4_ = NULL;
	GValue* values;
	gint values_length1;
	gint _values_size_;
	GValue* _tmp5_;
	gint _tmp5__length1;
	RygelMediaExportDatabaseCursor* _tmp6_ = NULL;
	RygelMediaExportDatabaseCursor* cursor;
	GError * _inner_error_ = NULL;
#line 349 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 349 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (container_id != NULL, NULL);
#line 351 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = g_str_equal;
#line 351 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp1_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, _tmp0_);
#line 351 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	children = _tmp1_;
#line 352 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp2_ = container_id;
#line 352 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp3_, G_TYPE_STRING);
#line 352 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_string (&_tmp3_, _tmp2_);
#line 352 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp4_ = g_new0 (GValue, 1);
#line 352 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp4_[0] = _tmp3_;
#line 352 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	values = _tmp4_;
#line 352 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	values_length1 = 1;
#line 352 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_values_size_ = values_length1;
#line 354 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp5_ = values;
#line 354 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp5__length1 = values_length1;
#line 354 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp6_ = rygel_media_export_media_cache_exec_cursor (self, RYGEL_MEDIA_EXPORT_SQL_STRING_CHILD_IDS, _tmp5_, _tmp5__length1, &_inner_error_);
#line 354 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	cursor = _tmp6_;
#line 354 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 354 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 354 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_propagate_error (error, _inner_error_);
#line 354 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 354 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_object_unref0 (children);
#line 354 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return NULL;
#line 2949 "rygel-media-export-media-cache.c"
		} else {
#line 354 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 354 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_object_unref0 (children);
#line 354 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 354 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_clear_error (&_inner_error_);
#line 354 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return NULL;
#line 2961 "rygel-media-export-media-cache.c"
		}
	}
	{
		RygelMediaExportDatabaseCursor* _tmp7_;
		RygelMediaExportDatabaseCursorIterator* _tmp8_ = NULL;
		RygelMediaExportDatabaseCursorIterator* _statement_it;
#line 355 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp7_ = cursor;
#line 355 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp8_ = rygel_media_export_database_cursor_iterator (_tmp7_);
#line 355 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_statement_it = _tmp8_;
#line 355 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		while (TRUE) {
#line 2976 "rygel-media-export-media-cache.c"
			RygelMediaExportDatabaseCursorIterator* _tmp9_;
			gboolean _tmp10_ = FALSE;
			RygelMediaExportDatabaseCursorIterator* _tmp11_;
			sqlite3_stmt* _tmp12_ = NULL;
			sqlite3_stmt* statement;
			GeeArrayList* _tmp13_;
			sqlite3_stmt* _tmp14_;
			const gchar* _tmp15_ = NULL;
#line 355 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp9_ = _statement_it;
#line 355 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp10_ = rygel_media_export_database_cursor_iterator_next (_tmp9_);
#line 355 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (!_tmp10_) {
#line 355 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				break;
#line 2993 "rygel-media-export-media-cache.c"
			}
#line 355 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp11_ = _statement_it;
#line 355 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp12_ = rygel_media_export_database_cursor_iterator_get (_tmp11_, &_inner_error_);
#line 355 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			statement = _tmp12_;
#line 355 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (_inner_error_ != NULL) {
#line 355 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 355 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					g_propagate_error (error, _inner_error_);
#line 355 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
#line 355 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_g_object_unref0 (cursor);
#line 355 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 355 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_g_object_unref0 (children);
#line 355 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					return NULL;
#line 3017 "rygel-media-export-media-cache.c"
				} else {
#line 355 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
#line 355 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_g_object_unref0 (cursor);
#line 355 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 355 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_g_object_unref0 (children);
#line 355 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 355 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					g_clear_error (&_inner_error_);
#line 355 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					return NULL;
#line 3033 "rygel-media-export-media-cache.c"
				}
			}
#line 356 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp13_ = children;
#line 356 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp14_ = statement;
#line 356 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp15_ = sqlite3_column_text (_tmp14_, 0);
#line 356 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp13_, _tmp15_);
#line 3044 "rygel-media-export-media-cache.c"
		}
#line 355 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
#line 3048 "rygel-media-export-media-cache.c"
	}
#line 359 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	result = children;
#line 359 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_object_unref0 (cursor);
#line 359 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 359 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return result;
#line 3058 "rygel-media-export-media-cache.c"
}


GeeList* rygel_media_export_media_cache_get_meta_data_column_by_filter (RygelMediaExportMediaCache* self, const gchar* column, const gchar* filter, GValueArray* args, glong offset, glong max_count, GError** error) {
	GeeList* result = NULL;
	glong _tmp0_;
	GValue _tmp1_ = {0};
	GValue v;
	GValueArray* _tmp2_;
	GValue _tmp3_;
	glong _tmp4_;
	GValue _tmp5_ = {0};
	GValueArray* _tmp6_;
	GValue _tmp7_;
	GeeArrayList* _tmp8_;
	GeeArrayList* data;
	RygelMediaExportSQLFactory* _tmp9_;
	const gchar* _tmp10_ = NULL;
	const gchar* sql;
	RygelMediaExportDatabase* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_ = NULL;
	gchar* _tmp16_;
	GValueArray* _tmp17_;
	GValue* _tmp18_;
	gint _tmp18__length1;
	RygelMediaExportDatabaseCursor* _tmp19_ = NULL;
	RygelMediaExportDatabaseCursor* _tmp20_;
	RygelMediaExportDatabaseCursor* cursor;
	GError * _inner_error_ = NULL;
#line 362 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 362 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (column != NULL, NULL);
#line 362 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (filter != NULL, NULL);
#line 362 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (args != NULL, NULL);
#line 369 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = offset;
#line 369 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp1_, G_TYPE_LONG);
#line 369 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_long (&_tmp1_, _tmp0_);
#line 369 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	v = _tmp1_;
#line 370 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp2_ = args;
#line 370 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp3_ = v;
#line 370 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_array_append (_tmp2_, &_tmp3_);
#line 371 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp4_ = max_count;
#line 371 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp5_, G_TYPE_LONG);
#line 371 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_long (&_tmp5_, _tmp4_);
#line 371 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
#line 371 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	v = _tmp5_;
#line 372 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp6_ = args;
#line 372 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp7_ = v;
#line 372 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_array_append (_tmp6_, &_tmp7_);
#line 374 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp8_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
#line 374 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	data = _tmp8_;
#line 376 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp9_ = self->priv->sql;
#line 376 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp10_ = rygel_media_export_sql_factory_make (_tmp9_, RYGEL_MEDIA_EXPORT_SQL_STRING_GET_META_DATA_COLUMN);
#line 376 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	sql = _tmp10_;
#line 377 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp11_ = self->priv->db;
#line 377 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp12_ = sql;
#line 377 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp13_ = column;
#line 377 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp14_ = filter;
#line 377 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp15_ = g_strdup_printf (_tmp12_, _tmp13_, _tmp14_);
#line 377 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp16_ = _tmp15_;
#line 377 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp17_ = args;
#line 377 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp18_ = _tmp17_->values;
#line 377 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp18__length1 = (gint) _tmp17_->n_values;
#line 377 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp19_ = rygel_media_export_database_exec_cursor (_tmp11_, _tmp16_, _tmp18_, _tmp18__length1, &_inner_error_);
#line 377 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp20_ = _tmp19_;
#line 377 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_free0 (_tmp16_);
#line 377 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	cursor = _tmp20_;
#line 377 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 377 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 377 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_object_unref0 (data);
#line 377 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
#line 377 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return NULL;
#line 3175 "rygel-media-export-media-cache.c"
	}
	{
		RygelMediaExportDatabaseCursor* _tmp21_;
		RygelMediaExportDatabaseCursorIterator* _tmp22_ = NULL;
		RygelMediaExportDatabaseCursorIterator* _statement_it;
#line 379 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp21_ = cursor;
#line 379 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp22_ = rygel_media_export_database_cursor_iterator (_tmp21_);
#line 379 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_statement_it = _tmp22_;
#line 379 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		while (TRUE) {
#line 3189 "rygel-media-export-media-cache.c"
			RygelMediaExportDatabaseCursorIterator* _tmp23_;
			gboolean _tmp24_ = FALSE;
			RygelMediaExportDatabaseCursorIterator* _tmp25_;
			sqlite3_stmt* _tmp26_ = NULL;
			sqlite3_stmt* statement;
			GeeArrayList* _tmp27_;
			sqlite3_stmt* _tmp28_;
			const gchar* _tmp29_ = NULL;
#line 379 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp23_ = _statement_it;
#line 379 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp24_ = rygel_media_export_database_cursor_iterator_next (_tmp23_);
#line 379 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (!_tmp24_) {
#line 379 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				break;
#line 3206 "rygel-media-export-media-cache.c"
			}
#line 379 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp25_ = _statement_it;
#line 379 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp26_ = rygel_media_export_database_cursor_iterator_get (_tmp25_, &_inner_error_);
#line 379 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			statement = _tmp26_;
#line 379 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (_inner_error_ != NULL) {
#line 379 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				g_propagate_error (error, _inner_error_);
#line 379 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
#line 379 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_object_unref0 (cursor);
#line 379 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_object_unref0 (data);
#line 379 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
#line 379 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				return NULL;
#line 3228 "rygel-media-export-media-cache.c"
			}
#line 380 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp27_ = data;
#line 380 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp28_ = statement;
#line 380 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp29_ = sqlite3_column_text (_tmp28_, 0);
#line 380 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp27_, _tmp29_);
#line 3238 "rygel-media-export-media-cache.c"
		}
#line 379 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
#line 3242 "rygel-media-export-media-cache.c"
	}
#line 383 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	result = (GeeList*) data;
#line 383 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_object_unref0 (cursor);
#line 383 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
#line 383 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return result;
#line 3252 "rygel-media-export-media-cache.c"
}


GeeList* rygel_media_export_media_cache_get_object_attribute_by_search_expression (RygelMediaExportMediaCache* self, const gchar* attribute, RygelSearchExpression* expression, glong offset, guint max_count, GError** error) {
	GeeList* result = NULL;
	GValueArray* _tmp0_;
	GValueArray* args;
	RygelSearchExpression* _tmp1_;
	GValueArray* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* filter;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* column;
	guint _tmp7_;
	guint _tmp8_ = 0U;
	guint max_objects;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	GValueArray* _tmp11_;
	glong _tmp12_;
	guint _tmp13_;
	GeeList* _tmp14_ = NULL;
	GeeList* _tmp15_;
	GError * _inner_error_ = NULL;
#line 386 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 386 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (attribute != NULL, NULL);
#line 392 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = g_value_array_new ((guint) 0);
#line 392 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	args = _tmp0_;
#line 393 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp1_ = expression;
#line 393 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp2_ = args;
#line 393 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp3_ = rygel_media_export_media_cache_translate_search_expression (self, _tmp1_, _tmp2_, "AND", &_inner_error_);
#line 393 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	filter = _tmp3_;
#line 393 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 393 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 393 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_value_array_free0 (args);
#line 393 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return NULL;
#line 3303 "rygel-media-export-media-cache.c"
	}
#line 397 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp4_ = filter;
#line 397 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_debug ("rygel-media-export-media-cache.vala:397: Parsed filter: %s", _tmp4_);
#line 399 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp5_ = attribute;
#line 399 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp6_ = rygel_media_export_media_cache_map_operand_to_column (self, _tmp5_, NULL, &_inner_error_);
#line 399 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	column = _tmp6_;
#line 399 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 399 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 399 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_free0 (filter);
#line 399 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_value_array_free0 (args);
#line 399 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return NULL;
#line 3325 "rygel-media-export-media-cache.c"
	}
#line 400 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp7_ = max_count;
#line 400 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp8_ = rygel_media_export_media_cache_modify_limit (self, _tmp7_);
#line 400 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	max_objects = _tmp8_;
#line 402 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp9_ = column;
#line 402 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp10_ = filter;
#line 402 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp11_ = args;
#line 402 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp12_ = offset;
#line 402 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp13_ = max_objects;
#line 402 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp14_ = rygel_media_export_media_cache_get_meta_data_column_by_filter (self, _tmp9_, _tmp10_, _tmp11_, _tmp12_, (glong) _tmp13_, &_inner_error_);
#line 402 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp15_ = _tmp14_;
#line 402 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 402 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 402 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_free0 (column);
#line 402 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_free0 (filter);
#line 402 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_value_array_free0 (args);
#line 402 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return NULL;
#line 3359 "rygel-media-export-media-cache.c"
	}
#line 402 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	result = _tmp15_;
#line 402 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_free0 (column);
#line 402 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_free0 (filter);
#line 402 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_value_array_free0 (args);
#line 402 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return result;
#line 3371 "rygel-media-export-media-cache.c"
}


void rygel_media_export_media_cache_flag_object (RygelMediaExportMediaCache* self, GFile* file, const gchar* flag, GError** error) {
	const gchar* _tmp0_;
	GValue _tmp1_ = {0};
	GFile* _tmp2_;
	gchar* _tmp3_ = NULL;
	GValue _tmp4_ = {0};
	GValue* _tmp5_ = NULL;
	GValue* args;
	gint args_length1;
	gint _args_size_;
	RygelMediaExportDatabase* _tmp6_;
	GError * _inner_error_ = NULL;
#line 409 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_if_fail (self != NULL);
#line 409 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_if_fail (file != NULL);
#line 409 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_if_fail (flag != NULL);
#line 410 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = flag;
#line 410 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp1_, G_TYPE_STRING);
#line 410 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_string (&_tmp1_, _tmp0_);
#line 410 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp2_ = file;
#line 410 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp3_ = g_file_get_uri (_tmp2_);
#line 410 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp4_, G_TYPE_STRING);
#line 410 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_take_string (&_tmp4_, _tmp3_);
#line 410 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp5_ = g_new0 (GValue, 2);
#line 410 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp5_[0] = _tmp1_;
#line 410 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp5_[1] = _tmp4_;
#line 410 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	args = _tmp5_;
#line 410 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	args_length1 = 2;
#line 410 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_args_size_ = args_length1;
#line 411 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp6_ = self->priv->db;
#line 411 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	rygel_media_export_database_exec (_tmp6_, "UPDATE Object SET flags = ? WHERE uri = ?", args, args_length1, &_inner_error_);
#line 411 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 411 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 411 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		args = (_vala_GValue_array_free (args, args_length1), NULL);
#line 411 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return;
#line 3431 "rygel-media-export-media-cache.c"
	}
#line 409 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	args = (_vala_GValue_array_free (args, args_length1), NULL);
#line 3435 "rygel-media-export-media-cache.c"
}


GeeList* rygel_media_export_media_cache_get_flagged_uris (RygelMediaExportMediaCache* self, const gchar* flag, GError** error) {
	GeeList* result = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* uris;
#line 416 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	static const char query[] = "SELECT uri FROM object WHERE flags = ?";
#line 3445 "rygel-media-export-media-cache.c"
	const gchar* _tmp1_;
	GValue _tmp2_ = {0};
	GValue* _tmp3_ = NULL;
	GValue* args;
	gint args_length1;
	gint _args_size_;
	RygelMediaExportDatabase* _tmp4_;
	GValue* _tmp5_;
	gint _tmp5__length1;
	RygelMediaExportDatabaseCursor* _tmp6_ = NULL;
	RygelMediaExportDatabaseCursor* cursor;
	GError * _inner_error_ = NULL;
#line 414 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 414 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (flag != NULL, NULL);
#line 415 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
#line 415 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	uris = _tmp0_;
#line 418 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp1_ = flag;
#line 418 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp2_, G_TYPE_STRING);
#line 418 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_string (&_tmp2_, _tmp1_);
#line 418 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp3_ = g_new0 (GValue, 1);
#line 418 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp3_[0] = _tmp2_;
#line 418 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	args = _tmp3_;
#line 418 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	args_length1 = 1;
#line 418 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_args_size_ = args_length1;
#line 420 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp4_ = self->priv->db;
#line 420 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp5_ = args;
#line 420 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp5__length1 = args_length1;
#line 420 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp6_ = rygel_media_export_database_exec_cursor (_tmp4_, query, _tmp5_, _tmp5__length1, &_inner_error_);
#line 420 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	cursor = _tmp6_;
#line 420 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 420 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 420 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		args = (_vala_GValue_array_free (args, args_length1), NULL);
#line 420 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_object_unref0 (uris);
#line 420 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return NULL;
#line 3502 "rygel-media-export-media-cache.c"
	}
	{
		RygelMediaExportDatabaseCursor* _tmp7_;
		RygelMediaExportDatabaseCursorIterator* _tmp8_ = NULL;
		RygelMediaExportDatabaseCursorIterator* _statement_it;
#line 421 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp7_ = cursor;
#line 421 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp8_ = rygel_media_export_database_cursor_iterator (_tmp7_);
#line 421 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_statement_it = _tmp8_;
#line 421 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		while (TRUE) {
#line 3516 "rygel-media-export-media-cache.c"
			RygelMediaExportDatabaseCursorIterator* _tmp9_;
			gboolean _tmp10_ = FALSE;
			RygelMediaExportDatabaseCursorIterator* _tmp11_;
			sqlite3_stmt* _tmp12_ = NULL;
			sqlite3_stmt* statement;
			GeeArrayList* _tmp13_;
			sqlite3_stmt* _tmp14_;
			const gchar* _tmp15_ = NULL;
#line 421 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp9_ = _statement_it;
#line 421 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp10_ = rygel_media_export_database_cursor_iterator_next (_tmp9_);
#line 421 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (!_tmp10_) {
#line 421 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				break;
#line 3533 "rygel-media-export-media-cache.c"
			}
#line 421 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp11_ = _statement_it;
#line 421 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp12_ = rygel_media_export_database_cursor_iterator_get (_tmp11_, &_inner_error_);
#line 421 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			statement = _tmp12_;
#line 421 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (_inner_error_ != NULL) {
#line 421 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				g_propagate_error (error, _inner_error_);
#line 421 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
#line 421 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_object_unref0 (cursor);
#line 421 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				args = (_vala_GValue_array_free (args, args_length1), NULL);
#line 421 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_object_unref0 (uris);
#line 421 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				return NULL;
#line 3555 "rygel-media-export-media-cache.c"
			}
#line 422 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp13_ = uris;
#line 422 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp14_ = statement;
#line 422 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp15_ = sqlite3_column_text (_tmp14_, 0);
#line 422 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp13_, _tmp15_);
#line 3565 "rygel-media-export-media-cache.c"
		}
#line 421 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
#line 3569 "rygel-media-export-media-cache.c"
	}
#line 425 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	result = (GeeList*) uris;
#line 425 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_object_unref0 (cursor);
#line 425 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	args = (_vala_GValue_array_free (args, args_length1), NULL);
#line 425 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return result;
#line 3579 "rygel-media-export-media-cache.c"
}


static void rygel_media_export_media_cache_get_exists_cache (RygelMediaExportMediaCache* self, GError** error) {
	GeeHashMap* _tmp0_;
	RygelMediaExportDatabaseCursor* _tmp1_ = NULL;
	RygelMediaExportDatabaseCursor* cursor;
	GError * _inner_error_ = NULL;
#line 429 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_if_fail (self != NULL);
#line 430 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, RYGEL_MEDIA_EXPORT_TYPE_EXISTS_CACHE_ENTRY, (GBoxedCopyFunc) rygel_media_export_exists_cache_entry_dup, rygel_media_export_exists_cache_entry_free, NULL, NULL, NULL);
#line 430 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_object_unref0 (self->priv->exists_cache);
#line 430 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	self->priv->exists_cache = _tmp0_;
#line 431 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp1_ = rygel_media_export_media_cache_exec_cursor (self, RYGEL_MEDIA_EXPORT_SQL_STRING_EXISTS_CACHE, NULL, 0, &_inner_error_);
#line 431 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	cursor = _tmp1_;
#line 431 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 431 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 431 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_propagate_error (error, _inner_error_);
#line 431 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return;
#line 3608 "rygel-media-export-media-cache.c"
		} else {
#line 431 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 431 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_clear_error (&_inner_error_);
#line 431 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return;
#line 3616 "rygel-media-export-media-cache.c"
		}
	}
	{
		RygelMediaExportDatabaseCursor* _tmp2_;
		RygelMediaExportDatabaseCursorIterator* _tmp3_ = NULL;
		RygelMediaExportDatabaseCursorIterator* _statement_it;
#line 432 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp2_ = cursor;
#line 432 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp3_ = rygel_media_export_database_cursor_iterator (_tmp2_);
#line 432 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_statement_it = _tmp3_;
#line 432 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		while (TRUE) {
#line 3631 "rygel-media-export-media-cache.c"
			RygelMediaExportDatabaseCursorIterator* _tmp4_;
			gboolean _tmp5_ = FALSE;
			RygelMediaExportDatabaseCursorIterator* _tmp6_;
			sqlite3_stmt* _tmp7_ = NULL;
			sqlite3_stmt* statement;
			RygelMediaExportExistsCacheEntry entry = {0};
			sqlite3_stmt* _tmp8_;
			gint64 _tmp9_ = 0LL;
			sqlite3_stmt* _tmp10_;
			gint64 _tmp11_ = 0LL;
			GeeHashMap* _tmp12_;
			sqlite3_stmt* _tmp13_;
			const gchar* _tmp14_ = NULL;
			RygelMediaExportExistsCacheEntry _tmp15_;
#line 432 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp4_ = _statement_it;
#line 432 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp5_ = rygel_media_export_database_cursor_iterator_next (_tmp4_);
#line 432 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (!_tmp5_) {
#line 432 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				break;
#line 3654 "rygel-media-export-media-cache.c"
			}
#line 432 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp6_ = _statement_it;
#line 432 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp7_ = rygel_media_export_database_cursor_iterator_get (_tmp6_, &_inner_error_);
#line 432 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			statement = _tmp7_;
#line 432 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (_inner_error_ != NULL) {
#line 432 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 432 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					g_propagate_error (error, _inner_error_);
#line 432 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
#line 432 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_g_object_unref0 (cursor);
#line 432 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					return;
#line 3674 "rygel-media-export-media-cache.c"
				} else {
#line 432 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
#line 432 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_g_object_unref0 (cursor);
#line 432 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 432 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					g_clear_error (&_inner_error_);
#line 432 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					return;
#line 3686 "rygel-media-export-media-cache.c"
				}
			}
#line 433 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			memset (&entry, 0, sizeof (RygelMediaExportExistsCacheEntry));
#line 434 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp8_ = statement;
#line 434 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp9_ = sqlite3_column_int64 (_tmp8_, 1);
#line 434 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			entry.mtime = _tmp9_;
#line 435 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp10_ = statement;
#line 435 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp11_ = sqlite3_column_int64 (_tmp10_, 0);
#line 435 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			entry.size = _tmp11_;
#line 436 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp12_ = self->priv->exists_cache;
#line 436 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp13_ = statement;
#line 436 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp14_ = sqlite3_column_text (_tmp13_, 2);
#line 436 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp15_ = entry;
#line 436 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			gee_abstract_map_set ((GeeAbstractMap*) _tmp12_, _tmp14_, &_tmp15_);
#line 3713 "rygel-media-export-media-cache.c"
		}
#line 432 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
#line 3717 "rygel-media-export-media-cache.c"
	}
#line 429 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_object_unref0 (cursor);
#line 3721 "rygel-media-export-media-cache.c"
}


static guint rygel_media_export_media_cache_modify_limit (RygelMediaExportMediaCache* self, guint max_count) {
	guint result = 0U;
	guint _tmp0_;
#line 440 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 441 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = max_count;
#line 441 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_tmp0_ == ((guint) 0)) {
#line 442 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		result = (guint) (-1);
#line 442 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return result;
#line 3738 "rygel-media-export-media-cache.c"
	} else {
		guint _tmp1_;
#line 444 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp1_ = max_count;
#line 444 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		result = _tmp1_;
#line 444 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return result;
#line 3747 "rygel-media-export-media-cache.c"
	}
}


static void rygel_media_export_media_cache_open_db (RygelMediaExportMediaCache* self, const gchar* name, GError** error) {
	const gchar* _tmp0_;
	RygelMediaExportDatabase* _tmp1_;
	RygelMediaExportDatabase* _tmp2_;
	gint old_version;
	gint _tmp3_ = 0;
	gint current_version;
	GError * _inner_error_ = NULL;
#line 448 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_if_fail (self != NULL);
#line 448 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_if_fail (name != NULL);
#line 449 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = name;
#line 449 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp1_ = rygel_media_export_database_new (_tmp0_, &_inner_error_);
#line 449 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp2_ = _tmp1_;
#line 449 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 449 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 449 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return;
#line 3776 "rygel-media-export-media-cache.c"
	}
#line 449 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_object_unref0 (self->priv->db);
#line 449 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	self->priv->db = _tmp2_;
#line 450 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	old_version = -1;
#line 451 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp3_ = atoi (RYGEL_MEDIA_EXPORT_SQL_FACTORY_schema_version);
#line 451 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	current_version = _tmp3_;
#line 3788 "rygel-media-export-media-cache.c"
	{
		RygelMediaExportDatabase* _tmp4_;
		RygelMediaExportSQLFactory* _tmp5_;
		RygelMediaExportMediaCacheUpgrader* _tmp6_;
		RygelMediaExportMediaCacheUpgrader* upgrader;
		RygelMediaExportMediaCacheUpgrader* _tmp7_;
		gint _tmp8_ = 0;
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_;
		RygelMediaExportMediaCacheUpgrader* _tmp19_;
#line 454 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp4_ = self->priv->db;
#line 454 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp5_ = self->priv->sql;
#line 454 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp6_ = rygel_media_export_media_cache_upgrader_new (_tmp4_, _tmp5_);
#line 454 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		upgrader = _tmp6_;
#line 455 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp7_ = upgrader;
#line 455 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp9_ = rygel_media_export_media_cache_upgrader_needs_upgrade (_tmp7_, &_tmp8_, &_inner_error_);
#line 455 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		old_version = _tmp8_;
#line 455 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp10_ = _tmp9_;
#line 455 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_inner_error_ != NULL) {
#line 455 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_rygel_media_export_media_cache_upgrader_unref0 (upgrader);
#line 455 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 3821 "rygel-media-export-media-cache.c"
				goto __catch8_rygel_media_export_database_error;
			}
			goto __finally8;
		}
#line 455 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_tmp10_) {
#line 3828 "rygel-media-export-media-cache.c"
			RygelMediaExportMediaCacheUpgrader* _tmp11_;
			gint _tmp12_;
#line 456 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp11_ = upgrader;
#line 456 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp12_ = old_version;
#line 456 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			rygel_media_export_media_cache_upgrader_upgrade (_tmp11_, _tmp12_);
#line 3837 "rygel-media-export-media-cache.c"
		} else {
			gint _tmp13_;
			gint _tmp14_;
#line 457 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp13_ = old_version;
#line 457 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp14_ = current_version;
#line 457 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (_tmp13_ == _tmp14_) {
#line 3847 "rygel-media-export-media-cache.c"
				RygelMediaExportMediaCacheUpgrader* _tmp15_;
#line 458 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp15_ = upgrader;
#line 458 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				rygel_media_export_media_cache_upgrader_fix_schema (_tmp15_, &_inner_error_);
#line 458 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				if (_inner_error_ != NULL) {
#line 458 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_rygel_media_export_media_cache_upgrader_unref0 (upgrader);
#line 458 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 3859 "rygel-media-export-media-cache.c"
						goto __catch8_rygel_media_export_database_error;
					}
					goto __finally8;
				}
			} else {
				gint _tmp16_;
				gint _tmp17_;
				GError* _tmp18_;
#line 460 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp16_ = old_version;
#line 460 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp17_ = current_version;
#line 460 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				g_warning ("The version \"%d\" of the detected database" " is newer than our supported version \"%d\"", _tmp16_, _tmp17_);
#line 464 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_object_unref0 (self->priv->db);
#line 464 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				self->priv->db = NULL;
#line 466 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp18_ = g_error_new_literal (RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR, RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_GENERAL_ERROR, "Database format" " not supported");
#line 466 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_inner_error_ = _tmp18_;
#line 466 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_rygel_media_export_media_cache_upgrader_unref0 (upgrader);
#line 466 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 3886 "rygel-media-export-media-cache.c"
					goto __catch8_rygel_media_export_database_error;
				}
				goto __finally8;
			}
		}
#line 469 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp19_ = upgrader;
#line 469 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_media_export_media_cache_upgrader_ensure_indices (_tmp19_);
#line 453 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_rygel_media_export_media_cache_upgrader_unref0 (upgrader);
#line 3898 "rygel-media-export-media-cache.c"
	}
	goto __finally8;
	__catch8_rygel_media_export_database_error:
	{
		GError* _error_ = NULL;
#line 453 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_error_ = _inner_error_;
#line 453 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_inner_error_ = NULL;
#line 471 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_debug ("rygel-media-export-media-cache.vala:471: %s", "Could not find schema version;" " checking for empty database...");
#line 3910 "rygel-media-export-media-cache.c"
		{
			RygelMediaExportDatabase* _tmp20_;
			gint _tmp21_ = 0;
			gint rows;
			gint _tmp22_;
#line 474 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp20_ = self->priv->db;
#line 474 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp21_ = rygel_media_export_database_query_value (_tmp20_, "SELECT count(type) FROM " "sqlite_master WHERE rowid=1", NULL, 0, &_inner_error_);
#line 474 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			rows = _tmp21_;
#line 474 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (_inner_error_ != NULL) {
#line 474 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 3926 "rygel-media-export-media-cache.c"
					goto __catch9_rygel_media_export_database_error;
				}
#line 474 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_error_free0 (_error_);
#line 474 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 474 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				g_clear_error (&_inner_error_);
#line 474 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				return;
#line 3937 "rygel-media-export-media-cache.c"
			}
#line 476 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp22_ = rows;
#line 476 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (_tmp22_ == 0) {
#line 3943 "rygel-media-export-media-cache.c"
				gboolean _tmp23_ = FALSE;
#line 477 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				g_debug ("rygel-media-export-media-cache.vala:477: Empty database, creating new " \
"schema version %s", RYGEL_MEDIA_EXPORT_SQL_FACTORY_schema_version);
#line 479 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp23_ = rygel_media_export_media_cache_create_schema (self);
#line 479 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				if (!_tmp23_) {
#line 480 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_g_object_unref0 (self->priv->db);
#line 480 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					self->priv->db = NULL;
#line 482 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_g_error_free0 (_error_);
#line 482 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					return;
#line 3959 "rygel-media-export-media-cache.c"
				}
			} else {
#line 485 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				g_warning ("rygel-media-export-media-cache.vala:485: Incompatible schema... cannot" \
" proceed");
#line 486 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_object_unref0 (self->priv->db);
#line 486 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				self->priv->db = NULL;
#line 488 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_error_free0 (_error_);
#line 488 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				return;
#line 3972 "rygel-media-export-media-cache.c"
			}
		}
		goto __finally9;
		__catch9_rygel_media_export_database_error:
		{
			GError* _error_ = NULL;
			GError* _tmp24_;
			const gchar* _tmp25_;
			GError* _tmp26_;
#line 473 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_error_ = _inner_error_;
#line 473 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_inner_error_ = NULL;
#line 491 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp24_ = _error_;
#line 491 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp25_ = _tmp24_->message;
#line 491 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_warning ("rygel-media-export-media-cache.vala:491: Something weird going on: %s", _tmp25_);
#line 492 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_object_unref0 (self->priv->db);
#line 492 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			self->priv->db = NULL;
#line 494 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp26_ = g_error_new_literal (RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR, RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_GENERAL_ERROR, "Invalid database");
#line 494 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_inner_error_ = _tmp26_;
#line 494 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_error_free0 (_error_);
#line 4002 "rygel-media-export-media-cache.c"
			goto __finally9;
		}
		__finally9:
#line 473 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_inner_error_ != NULL) {
#line 473 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_error_free0 (_error_);
#line 4010 "rygel-media-export-media-cache.c"
			goto __finally8;
		}
#line 453 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_error_free0 (_error_);
#line 4015 "rygel-media-export-media-cache.c"
	}
	__finally8:
#line 453 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 453 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 453 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return;
#line 4024 "rygel-media-export-media-cache.c"
	}
}


static void rygel_media_export_media_cache_save_metadata (RygelMediaExportMediaCache* self, RygelMediaItem* item, GError** error) {
	RygelMediaItem* _tmp0_;
	gint64 _tmp1_;
	gint64 _tmp2_;
	GValue _tmp3_ = {0};
	RygelMediaItem* _tmp4_;
	const gchar* _tmp5_;
	GValue _tmp6_ = {0};
	GValue _tmp7_ = {0};
	GValue _tmp8_ = {0};
	RygelMediaItem* _tmp9_;
	const gchar* _tmp10_;
	GValue _tmp11_ = {0};
	GValue _tmp12_ = {0};
	GValue _tmp13_ = {0};
	RygelMediaItem* _tmp14_;
	const gchar* _tmp15_;
	GValue _tmp16_ = {0};
	GValue _tmp17_ = {0};
	GValue _tmp18_ = {0};
	GValue _tmp19_ = {0};
	GValue _tmp20_ = {0};
	GValue _tmp21_ = {0};
	GValue _tmp22_ = {0};
	GValue _tmp23_ = {0};
	RygelMediaItem* _tmp24_;
	const gchar* _tmp25_;
	GValue _tmp26_ = {0};
	RygelMediaItem* _tmp27_;
	const gchar* _tmp28_;
	GValue _tmp29_ = {0};
	GValue _tmp30_ = {0};
	GValue _tmp31_ = {0};
	GValue* _tmp32_ = NULL;
	GValue* values;
	gint values_length1;
	gint _values_size_;
	RygelMediaItem* _tmp33_;
	RygelMediaItem* _tmp89_;
	RygelMediaExportDatabase* _tmp118_;
	RygelMediaExportSQLFactory* _tmp119_;
	const gchar* _tmp120_ = NULL;
	GValue* _tmp121_;
	gint _tmp121__length1;
	GError * _inner_error_ = NULL;
#line 499 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_if_fail (self != NULL);
#line 499 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_if_fail (item != NULL);
#line 501 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = item;
#line 501 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp1_ = rygel_media_item_get_size (_tmp0_);
#line 501 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp2_ = _tmp1_;
#line 501 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp3_, G_TYPE_INT64);
#line 501 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_int64 (&_tmp3_, _tmp2_);
#line 501 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp4_ = item;
#line 501 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp5_ = _tmp4_->mime_type;
#line 501 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp6_, G_TYPE_STRING);
#line 501 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_string (&_tmp6_, _tmp5_);
#line 501 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp7_, G_TYPE_INT);
#line 501 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_int (&_tmp7_, -1);
#line 501 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp8_, G_TYPE_INT);
#line 501 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_int (&_tmp8_, -1);
#line 501 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp9_ = item;
#line 501 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp10_ = ((RygelMediaObject*) _tmp9_)->upnp_class;
#line 501 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp11_, G_TYPE_STRING);
#line 501 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_string (&_tmp11_, _tmp10_);
#line 501 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	rygel_media_export_database_null (&_tmp12_);
#line 501 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	rygel_media_export_database_null (&_tmp13_);
#line 501 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp14_ = item;
#line 501 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp15_ = _tmp14_->date;
#line 501 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp16_, G_TYPE_STRING);
#line 501 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_string (&_tmp16_, _tmp15_);
#line 501 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp17_, G_TYPE_INT);
#line 501 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_int (&_tmp17_, -1);
#line 501 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp18_, G_TYPE_INT);
#line 501 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_int (&_tmp18_, -1);
#line 501 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp19_, G_TYPE_INT);
#line 501 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_int (&_tmp19_, -1);
#line 501 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp20_, G_TYPE_INT);
#line 501 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_int (&_tmp20_, -1);
#line 501 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp21_, G_TYPE_INT);
#line 501 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_int (&_tmp21_, -1);
#line 501 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp22_, G_TYPE_INT);
#line 501 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_int (&_tmp22_, -1);
#line 501 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp23_, G_TYPE_INT);
#line 501 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_int (&_tmp23_, -1);
#line 501 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp24_ = item;
#line 501 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp25_ = ((RygelMediaObject*) _tmp24_)->id;
#line 501 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp26_, G_TYPE_STRING);
#line 501 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_string (&_tmp26_, _tmp25_);
#line 501 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp27_ = item;
#line 501 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp28_ = _tmp27_->dlna_profile;
#line 501 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp29_, G_TYPE_STRING);
#line 501 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_string (&_tmp29_, _tmp28_);
#line 501 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	rygel_media_export_database_null (&_tmp30_);
#line 501 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp31_, G_TYPE_INT);
#line 501 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_int (&_tmp31_, -1);
#line 501 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp32_ = g_new0 (GValue, 19);
#line 501 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp32_[0] = _tmp3_;
#line 501 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp32_[1] = _tmp6_;
#line 501 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp32_[2] = _tmp7_;
#line 501 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp32_[3] = _tmp8_;
#line 501 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp32_[4] = _tmp11_;
#line 501 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp32_[5] = _tmp12_;
#line 501 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp32_[6] = _tmp13_;
#line 501 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp32_[7] = _tmp16_;
#line 501 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp32_[8] = _tmp17_;
#line 501 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp32_[9] = _tmp18_;
#line 501 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp32_[10] = _tmp19_;
#line 501 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp32_[11] = _tmp20_;
#line 501 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp32_[12] = _tmp21_;
#line 501 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp32_[13] = _tmp22_;
#line 501 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp32_[14] = _tmp23_;
#line 501 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp32_[15] = _tmp26_;
#line 501 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp32_[16] = _tmp29_;
#line 501 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp32_[17] = _tmp30_;
#line 501 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp32_[18] = _tmp31_;
#line 501 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	values = _tmp32_;
#line 501 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	values_length1 = 19;
#line 501 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_values_size_ = values_length1;
#line 521 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp33_ = item;
#line 521 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (RYGEL_IS_AUDIO_ITEM (_tmp33_)) {
#line 4224 "rygel-media-export-media-cache.c"
		RygelMediaItem* _tmp34_;
		RygelAudioItem* _tmp35_;
		RygelAudioItem* audio_item;
		GValue* _tmp36_;
		gint _tmp36__length1;
		RygelAudioItem* _tmp37_;
		glong _tmp38_;
		GValue _tmp39_ = {0};
		GValue _tmp40_;
		GValue* _tmp41_;
		gint _tmp41__length1;
		RygelAudioItem* _tmp42_;
		gint _tmp43_;
		GValue _tmp44_ = {0};
		GValue _tmp45_;
		GValue* _tmp46_;
		gint _tmp46__length1;
		RygelAudioItem* _tmp47_;
		gint _tmp48_;
		GValue _tmp49_ = {0};
		GValue _tmp50_;
		GValue* _tmp51_;
		gint _tmp51__length1;
		RygelAudioItem* _tmp52_;
		gint _tmp53_;
		GValue _tmp54_ = {0};
		GValue _tmp55_;
		GValue* _tmp56_;
		gint _tmp56__length1;
		RygelAudioItem* _tmp57_;
		gint _tmp58_;
		GValue _tmp59_ = {0};
		GValue _tmp60_;
		RygelMediaItem* _tmp61_;
#line 522 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp34_ = item;
#line 522 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp35_ = _g_object_ref0 (RYGEL_IS_AUDIO_ITEM (_tmp34_) ? ((RygelAudioItem*) _tmp34_) : NULL);
#line 522 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		audio_item = _tmp35_;
#line 523 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp36_ = values;
#line 523 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp36__length1 = values_length1;
#line 523 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp37_ = audio_item;
#line 523 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp38_ = _tmp37_->duration;
#line 523 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_init (&_tmp39_, G_TYPE_LONG);
#line 523 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_set_long (&_tmp39_, _tmp38_);
#line 523 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		G_IS_VALUE (&_tmp36_[14]) ? (g_value_unset (&_tmp36_[14]), NULL) : NULL;
#line 523 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp36_[14] = _tmp39_;
#line 523 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp40_ = _tmp36_[14];
#line 524 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp41_ = values;
#line 524 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp41__length1 = values_length1;
#line 524 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp42_ = audio_item;
#line 524 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp43_ = _tmp42_->bitrate;
#line 524 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_init (&_tmp44_, G_TYPE_INT);
#line 524 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_set_int (&_tmp44_, _tmp43_);
#line 524 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		G_IS_VALUE (&_tmp41_[8]) ? (g_value_unset (&_tmp41_[8]), NULL) : NULL;
#line 524 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp41_[8] = _tmp44_;
#line 524 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp45_ = _tmp41_[8];
#line 525 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp46_ = values;
#line 525 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp46__length1 = values_length1;
#line 525 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp47_ = audio_item;
#line 525 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp48_ = _tmp47_->sample_freq;
#line 525 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_init (&_tmp49_, G_TYPE_INT);
#line 525 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_set_int (&_tmp49_, _tmp48_);
#line 525 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		G_IS_VALUE (&_tmp46_[9]) ? (g_value_unset (&_tmp46_[9]), NULL) : NULL;
#line 525 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp46_[9] = _tmp49_;
#line 525 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp50_ = _tmp46_[9];
#line 526 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp51_ = values;
#line 526 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp51__length1 = values_length1;
#line 526 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp52_ = audio_item;
#line 526 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp53_ = _tmp52_->bits_per_sample;
#line 526 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_init (&_tmp54_, G_TYPE_INT);
#line 526 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_set_int (&_tmp54_, _tmp53_);
#line 526 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		G_IS_VALUE (&_tmp51_[10]) ? (g_value_unset (&_tmp51_[10]), NULL) : NULL;
#line 526 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp51_[10] = _tmp54_;
#line 526 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp55_ = _tmp51_[10];
#line 527 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp56_ = values;
#line 527 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp56__length1 = values_length1;
#line 527 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp57_ = audio_item;
#line 527 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp58_ = _tmp57_->channels;
#line 527 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_init (&_tmp59_, G_TYPE_INT);
#line 527 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_set_int (&_tmp59_, _tmp58_);
#line 527 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		G_IS_VALUE (&_tmp56_[11]) ? (g_value_unset (&_tmp56_[11]), NULL) : NULL;
#line 527 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp56_[11] = _tmp59_;
#line 527 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp60_ = _tmp56_[11];
#line 528 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp61_ = item;
#line 528 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (RYGEL_MEDIA_EXPORT_IS_MUSIC_ITEM (_tmp61_)) {
#line 4359 "rygel-media-export-media-cache.c"
			RygelMediaItem* _tmp62_;
			RygelMediaExportMusicItem* _tmp63_;
			RygelMediaExportMusicItem* music_item;
			GValue* _tmp64_;
			gint _tmp64__length1;
			RygelMediaExportMusicItem* _tmp65_;
			const gchar* _tmp66_;
			GValue _tmp67_ = {0};
			GValue _tmp68_;
			GValue* _tmp69_;
			gint _tmp69__length1;
			RygelMediaExportMusicItem* _tmp70_;
			const gchar* _tmp71_;
			GValue _tmp72_ = {0};
			GValue _tmp73_;
			GValue* _tmp74_;
			gint _tmp74__length1;
			RygelMediaExportMusicItem* _tmp75_;
			const gchar* _tmp76_;
			GValue _tmp77_ = {0};
			GValue _tmp78_;
			GValue* _tmp79_;
			gint _tmp79__length1;
			RygelMediaExportMusicItem* _tmp80_;
			gint _tmp81_;
			GValue _tmp82_ = {0};
			GValue _tmp83_;
			GValue* _tmp84_;
			gint _tmp84__length1;
			RygelMediaExportMusicItem* _tmp85_;
			gint _tmp86_;
			GValue _tmp87_ = {0};
			GValue _tmp88_;
#line 529 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp62_ = item;
#line 529 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp63_ = _g_object_ref0 (RYGEL_MEDIA_EXPORT_IS_MUSIC_ITEM (_tmp62_) ? ((RygelMediaExportMusicItem*) _tmp62_) : NULL);
#line 529 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			music_item = _tmp63_;
#line 530 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp64_ = values;
#line 530 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp64__length1 = values_length1;
#line 530 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp65_ = music_item;
#line 530 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp66_ = ((RygelMusicItem*) _tmp65_)->artist;
#line 530 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_value_init (&_tmp67_, G_TYPE_STRING);
#line 530 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_value_set_string (&_tmp67_, _tmp66_);
#line 530 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			G_IS_VALUE (&_tmp64_[5]) ? (g_value_unset (&_tmp64_[5]), NULL) : NULL;
#line 530 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp64_[5] = _tmp67_;
#line 530 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp68_ = _tmp64_[5];
#line 531 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp69_ = values;
#line 531 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp69__length1 = values_length1;
#line 531 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp70_ = music_item;
#line 531 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp71_ = ((RygelMusicItem*) _tmp70_)->album;
#line 531 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_value_init (&_tmp72_, G_TYPE_STRING);
#line 531 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_value_set_string (&_tmp72_, _tmp71_);
#line 531 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			G_IS_VALUE (&_tmp69_[6]) ? (g_value_unset (&_tmp69_[6]), NULL) : NULL;
#line 531 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp69_[6] = _tmp72_;
#line 531 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp73_ = _tmp69_[6];
#line 532 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp74_ = values;
#line 532 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp74__length1 = values_length1;
#line 532 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp75_ = music_item;
#line 532 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp76_ = ((RygelMusicItem*) _tmp75_)->genre;
#line 532 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_value_init (&_tmp77_, G_TYPE_STRING);
#line 532 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_value_set_string (&_tmp77_, _tmp76_);
#line 532 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			G_IS_VALUE (&_tmp74_[17]) ? (g_value_unset (&_tmp74_[17]), NULL) : NULL;
#line 532 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp74_[17] = _tmp77_;
#line 532 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp78_ = _tmp74_[17];
#line 533 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp79_ = values;
#line 533 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp79__length1 = values_length1;
#line 533 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp80_ = music_item;
#line 533 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp81_ = ((RygelMusicItem*) _tmp80_)->track_number;
#line 533 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_value_init (&_tmp82_, G_TYPE_INT);
#line 533 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_value_set_int (&_tmp82_, _tmp81_);
#line 533 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			G_IS_VALUE (&_tmp79_[12]) ? (g_value_unset (&_tmp79_[12]), NULL) : NULL;
#line 533 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp79_[12] = _tmp82_;
#line 533 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp83_ = _tmp79_[12];
#line 534 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp84_ = values;
#line 534 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp84__length1 = values_length1;
#line 534 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp85_ = music_item;
#line 534 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp86_ = _tmp85_->disc;
#line 534 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_value_init (&_tmp87_, G_TYPE_INT);
#line 534 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_value_set_int (&_tmp87_, _tmp86_);
#line 534 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			G_IS_VALUE (&_tmp84_[18]) ? (g_value_unset (&_tmp84_[18]), NULL) : NULL;
#line 534 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp84_[18] = _tmp87_;
#line 534 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp88_ = _tmp84_[18];
#line 528 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_object_unref0 (music_item);
#line 4491 "rygel-media-export-media-cache.c"
		}
#line 521 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_object_unref0 (audio_item);
#line 4495 "rygel-media-export-media-cache.c"
	}
#line 538 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp89_ = item;
#line 538 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (RYGEL_IS_VISUAL_ITEM (_tmp89_)) {
#line 4501 "rygel-media-export-media-cache.c"
		RygelMediaItem* _tmp90_;
		RygelVisualItem* _tmp91_;
		RygelVisualItem* visual_item;
		GValue* _tmp92_;
		gint _tmp92__length1;
		RygelVisualItem* _tmp93_;
		gint _tmp94_;
		gint _tmp95_;
		GValue _tmp96_ = {0};
		GValue _tmp97_;
		GValue* _tmp98_;
		gint _tmp98__length1;
		RygelVisualItem* _tmp99_;
		gint _tmp100_;
		gint _tmp101_;
		GValue _tmp102_ = {0};
		GValue _tmp103_;
		GValue* _tmp104_;
		gint _tmp104__length1;
		RygelVisualItem* _tmp105_;
		gint _tmp106_;
		gint _tmp107_;
		GValue _tmp108_ = {0};
		GValue _tmp109_;
		RygelMediaItem* _tmp110_;
#line 539 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp90_ = item;
#line 539 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp91_ = _g_object_ref0 (RYGEL_IS_VISUAL_ITEM (_tmp90_) ? ((RygelVisualItem*) _tmp90_) : NULL);
#line 539 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		visual_item = _tmp91_;
#line 540 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp92_ = values;
#line 540 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp92__length1 = values_length1;
#line 540 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp93_ = visual_item;
#line 540 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp94_ = rygel_visual_item_get_width (_tmp93_);
#line 540 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp95_ = _tmp94_;
#line 540 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_init (&_tmp96_, G_TYPE_INT);
#line 540 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_set_int (&_tmp96_, _tmp95_);
#line 540 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		G_IS_VALUE (&_tmp92_[2]) ? (g_value_unset (&_tmp92_[2]), NULL) : NULL;
#line 540 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp92_[2] = _tmp96_;
#line 540 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp97_ = _tmp92_[2];
#line 541 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp98_ = values;
#line 541 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp98__length1 = values_length1;
#line 541 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp99_ = visual_item;
#line 541 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp100_ = rygel_visual_item_get_height (_tmp99_);
#line 541 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp101_ = _tmp100_;
#line 541 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_init (&_tmp102_, G_TYPE_INT);
#line 541 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_set_int (&_tmp102_, _tmp101_);
#line 541 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		G_IS_VALUE (&_tmp98_[3]) ? (g_value_unset (&_tmp98_[3]), NULL) : NULL;
#line 541 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp98_[3] = _tmp102_;
#line 541 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp103_ = _tmp98_[3];
#line 542 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp104_ = values;
#line 542 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp104__length1 = values_length1;
#line 542 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp105_ = visual_item;
#line 542 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp106_ = rygel_visual_item_get_color_depth (_tmp105_);
#line 542 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp107_ = _tmp106_;
#line 542 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_init (&_tmp108_, G_TYPE_INT);
#line 542 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_set_int (&_tmp108_, _tmp107_);
#line 542 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		G_IS_VALUE (&_tmp104_[13]) ? (g_value_unset (&_tmp104_[13]), NULL) : NULL;
#line 542 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp104_[13] = _tmp108_;
#line 542 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp109_ = _tmp104_[13];
#line 543 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp110_ = item;
#line 543 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (RYGEL_IS_VIDEO_ITEM (_tmp110_)) {
#line 4597 "rygel-media-export-media-cache.c"
			RygelMediaItem* _tmp111_;
			RygelVideoItem* _tmp112_;
			RygelVideoItem* video_item;
			GValue* _tmp113_;
			gint _tmp113__length1;
			RygelVideoItem* _tmp114_;
			const gchar* _tmp115_;
			GValue _tmp116_ = {0};
			GValue _tmp117_;
#line 544 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp111_ = item;
#line 544 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp112_ = _g_object_ref0 (RYGEL_IS_VIDEO_ITEM (_tmp111_) ? ((RygelVideoItem*) _tmp111_) : NULL);
#line 544 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			video_item = _tmp112_;
#line 545 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp113_ = values;
#line 545 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp113__length1 = values_length1;
#line 545 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp114_ = video_item;
#line 545 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp115_ = _tmp114_->author;
#line 545 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_value_init (&_tmp116_, G_TYPE_STRING);
#line 545 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_value_set_string (&_tmp116_, _tmp115_);
#line 545 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			G_IS_VALUE (&_tmp113_[5]) ? (g_value_unset (&_tmp113_[5]), NULL) : NULL;
#line 545 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp113_[5] = _tmp116_;
#line 545 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp117_ = _tmp113_[5];
#line 543 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_object_unref0 (video_item);
#line 4633 "rygel-media-export-media-cache.c"
		}
#line 538 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_object_unref0 (visual_item);
#line 4637 "rygel-media-export-media-cache.c"
	}
#line 549 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp118_ = self->priv->db;
#line 549 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp119_ = self->priv->sql;
#line 549 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp120_ = rygel_media_export_sql_factory_make (_tmp119_, RYGEL_MEDIA_EXPORT_SQL_STRING_SAVE_METADATA);
#line 549 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp121_ = values;
#line 549 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp121__length1 = values_length1;
#line 549 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	rygel_media_export_database_exec (_tmp118_, _tmp120_, _tmp121_, _tmp121__length1, &_inner_error_);
#line 549 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 549 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 549 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 549 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return;
#line 4659 "rygel-media-export-media-cache.c"
	}
#line 499 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 4663 "rygel-media-export-media-cache.c"
}


static void rygel_media_export_media_cache_create_object (RygelMediaExportMediaCache* self, RygelMediaObject* item, GError** error) {
	gint type;
	GValue parent = {0};
	RygelMediaObject* _tmp0_;
	RygelMediaObject* _tmp1_;
	RygelMediaContainer* _tmp2_;
	gchar* _tmp8_ = NULL;
	RygelMediaObject* _tmp9_;
	GeeArrayList* _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	RygelMediaObject* _tmp16_;
	const gchar* _tmp17_;
	GValue _tmp18_ = {0};
	RygelMediaObject* _tmp19_;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	GValue _tmp22_ = {0};
	gint _tmp23_;
	GValue _tmp24_ = {0};
	GValue _tmp25_;
	GValue _tmp26_ = {0};
	RygelMediaObject* _tmp27_;
	guint64 _tmp28_;
	GValue _tmp29_ = {0};
	const gchar* _tmp30_;
	GValue _tmp31_ = {0};
	GValue* _tmp32_ = NULL;
	GValue* values;
	gint values_length1;
	gint _values_size_;
	RygelMediaExportDatabase* _tmp33_;
	RygelMediaExportSQLFactory* _tmp34_;
	const gchar* _tmp35_ = NULL;
	GError * _inner_error_ = NULL;
#line 552 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_if_fail (self != NULL);
#line 552 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_if_fail (item != NULL);
#line 553 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	type = (gint) RYGEL_MEDIA_EXPORT_OBJECT_TYPE_CONTAINER;
#line 556 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = item;
#line 556 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (RYGEL_IS_MEDIA_ITEM (_tmp0_)) {
#line 557 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		type = (gint) RYGEL_MEDIA_EXPORT_OBJECT_TYPE_ITEM;
#line 4714 "rygel-media-export-media-cache.c"
	}
#line 560 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp1_ = item;
#line 560 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp2_ = _tmp1_->parent;
#line 560 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_tmp2_ == NULL) {
#line 4722 "rygel-media-export-media-cache.c"
		GValue _tmp3_ = {0};
#line 561 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_media_export_database_null (&_tmp3_);
#line 561 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		G_IS_VALUE (&parent) ? (g_value_unset (&parent), NULL) : NULL;
#line 561 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		parent = _tmp3_;
#line 4730 "rygel-media-export-media-cache.c"
	} else {
		RygelMediaObject* _tmp4_;
		RygelMediaContainer* _tmp5_;
		const gchar* _tmp6_;
		GValue _tmp7_ = {0};
#line 563 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp4_ = item;
#line 563 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp5_ = _tmp4_->parent;
#line 563 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp6_ = ((RygelMediaObject*) _tmp5_)->id;
#line 563 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_init (&_tmp7_, G_TYPE_STRING);
#line 563 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_set_string (&_tmp7_, _tmp6_);
#line 563 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		G_IS_VALUE (&parent) ? (g_value_unset (&parent), NULL) : NULL;
#line 563 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		parent = _tmp7_;
#line 4750 "rygel-media-export-media-cache.c"
	}
#line 571 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp9_ = item;
#line 571 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp10_ = _tmp9_->uris;
#line 571 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp11_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp10_);
#line 571 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp12_ = _tmp11_;
#line 571 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_tmp12_ == 0) {
#line 571 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_free0 (_tmp8_);
#line 571 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp8_ = NULL;
#line 4766 "rygel-media-export-media-cache.c"
	} else {
		RygelMediaObject* _tmp13_;
		GeeArrayList* _tmp14_;
		gpointer _tmp15_ = NULL;
#line 571 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp13_ = item;
#line 571 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp14_ = _tmp13_->uris;
#line 571 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp15_ = gee_abstract_list_get ((GeeAbstractList*) _tmp14_, 0);
#line 571 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_free0 (_tmp8_);
#line 571 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp8_ = (gchar*) _tmp15_;
#line 4781 "rygel-media-export-media-cache.c"
	}
#line 566 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp16_ = item;
#line 566 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp17_ = _tmp16_->id;
#line 566 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp18_, G_TYPE_STRING);
#line 566 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_string (&_tmp18_, _tmp17_);
#line 566 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp19_ = item;
#line 566 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp20_ = rygel_media_object_get_title (_tmp19_);
#line 566 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp21_ = _tmp20_;
#line 566 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp22_, G_TYPE_STRING);
#line 566 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_string (&_tmp22_, _tmp21_);
#line 566 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp23_ = type;
#line 566 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp24_, G_TYPE_INT);
#line 566 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_int (&_tmp24_, _tmp23_);
#line 566 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp25_ = parent;
#line 566 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (G_IS_VALUE (&_tmp25_)) {
#line 566 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_init (&_tmp26_, G_VALUE_TYPE (&_tmp25_));
#line 566 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_copy (&_tmp25_, &_tmp26_);
#line 4815 "rygel-media-export-media-cache.c"
	} else {
#line 566 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp26_ = _tmp25_;
#line 4819 "rygel-media-export-media-cache.c"
	}
#line 566 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp27_ = item;
#line 566 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp28_ = _tmp27_->modified;
#line 566 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp29_, G_TYPE_UINT64);
#line 566 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_uint64 (&_tmp29_, _tmp28_);
#line 566 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp30_ = _tmp8_;
#line 566 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp31_, G_TYPE_STRING);
#line 566 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_string (&_tmp31_, _tmp30_);
#line 566 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp32_ = g_new0 (GValue, 6);
#line 566 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp32_[0] = _tmp18_;
#line 566 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp32_[1] = _tmp22_;
#line 566 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp32_[2] = _tmp24_;
#line 566 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp32_[3] = _tmp26_;
#line 566 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp32_[4] = _tmp29_;
#line 566 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp32_[5] = _tmp31_;
#line 566 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	values = _tmp32_;
#line 566 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	values_length1 = 6;
#line 566 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_values_size_ = values_length1;
#line 573 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp33_ = self->priv->db;
#line 573 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp34_ = self->priv->sql;
#line 573 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp35_ = rygel_media_export_sql_factory_make (_tmp34_, RYGEL_MEDIA_EXPORT_SQL_STRING_INSERT);
#line 573 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	rygel_media_export_database_exec (_tmp33_, _tmp35_, values, values_length1, &_inner_error_);
#line 573 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 573 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 573 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 573 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_free0 (_tmp8_);
#line 573 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		G_IS_VALUE (&parent) ? (g_value_unset (&parent), NULL) : NULL;
#line 573 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return;
#line 4875 "rygel-media-export-media-cache.c"
	}
#line 552 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 552 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_free0 (_tmp8_);
#line 552 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	G_IS_VALUE (&parent) ? (g_value_unset (&parent), NULL) : NULL;
#line 4883 "rygel-media-export-media-cache.c"
}


/**
     * Create the current schema.
     *
     * If schema creation fails, schema will be rolled back
     * completely.
     *
     * @returns: true on success, false on failure
     */
static gboolean rygel_media_export_media_cache_create_schema (RygelMediaExportMediaCache* self) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
#line 584 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 4900 "rygel-media-export-media-cache.c"
	{
		RygelMediaExportDatabase* _tmp0_;
		RygelMediaExportDatabase* _tmp1_;
		RygelMediaExportSQLFactory* _tmp2_;
		const gchar* _tmp3_ = NULL;
		RygelMediaExportDatabase* _tmp4_;
		RygelMediaExportSQLFactory* _tmp5_;
		const gchar* _tmp6_ = NULL;
		RygelMediaExportDatabase* _tmp7_;
		RygelMediaExportSQLFactory* _tmp8_;
		const gchar* _tmp9_ = NULL;
		RygelMediaExportDatabase* _tmp10_;
		RygelMediaExportSQLFactory* _tmp11_;
		const gchar* _tmp12_ = NULL;
		RygelMediaExportDatabase* _tmp13_;
		RygelMediaExportSQLFactory* _tmp14_;
		const gchar* _tmp15_ = NULL;
		RygelMediaExportDatabase* _tmp16_;
		RygelMediaExportDatabase* _tmp17_;
#line 586 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp0_ = self->priv->db;
#line 586 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_media_export_database_begin (_tmp0_, &_inner_error_);
#line 586 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_inner_error_ != NULL) {
#line 4926 "rygel-media-export-media-cache.c"
			goto __catch10_g_error;
		}
#line 587 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp1_ = self->priv->db;
#line 587 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp2_ = self->priv->sql;
#line 587 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp3_ = rygel_media_export_sql_factory_make (_tmp2_, RYGEL_MEDIA_EXPORT_SQL_STRING_SCHEMA);
#line 587 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_media_export_database_exec (_tmp1_, _tmp3_, NULL, 0, &_inner_error_);
#line 587 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_inner_error_ != NULL) {
#line 4939 "rygel-media-export-media-cache.c"
			goto __catch10_g_error;
		}
#line 588 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp4_ = self->priv->db;
#line 588 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp5_ = self->priv->sql;
#line 588 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp6_ = rygel_media_export_sql_factory_make (_tmp5_, RYGEL_MEDIA_EXPORT_SQL_STRING_TRIGGER_COMMON);
#line 588 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_media_export_database_exec (_tmp4_, _tmp6_, NULL, 0, &_inner_error_);
#line 588 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_inner_error_ != NULL) {
#line 4952 "rygel-media-export-media-cache.c"
			goto __catch10_g_error;
		}
#line 589 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp7_ = self->priv->db;
#line 589 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp8_ = self->priv->sql;
#line 589 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp9_ = rygel_media_export_sql_factory_make (_tmp8_, RYGEL_MEDIA_EXPORT_SQL_STRING_TABLE_CLOSURE);
#line 589 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_media_export_database_exec (_tmp7_, _tmp9_, NULL, 0, &_inner_error_);
#line 589 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_inner_error_ != NULL) {
#line 4965 "rygel-media-export-media-cache.c"
			goto __catch10_g_error;
		}
#line 590 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp10_ = self->priv->db;
#line 590 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp11_ = self->priv->sql;
#line 590 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp12_ = rygel_media_export_sql_factory_make (_tmp11_, RYGEL_MEDIA_EXPORT_SQL_STRING_INDEX_COMMON);
#line 590 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_media_export_database_exec (_tmp10_, _tmp12_, NULL, 0, &_inner_error_);
#line 590 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_inner_error_ != NULL) {
#line 4978 "rygel-media-export-media-cache.c"
			goto __catch10_g_error;
		}
#line 591 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp13_ = self->priv->db;
#line 591 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp14_ = self->priv->sql;
#line 591 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp15_ = rygel_media_export_sql_factory_make (_tmp14_, RYGEL_MEDIA_EXPORT_SQL_STRING_TRIGGER_CLOSURE);
#line 591 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_media_export_database_exec (_tmp13_, _tmp15_, NULL, 0, &_inner_error_);
#line 591 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_inner_error_ != NULL) {
#line 4991 "rygel-media-export-media-cache.c"
			goto __catch10_g_error;
		}
#line 592 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp16_ = self->priv->db;
#line 592 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_media_export_database_commit (_tmp16_, &_inner_error_);
#line 592 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_inner_error_ != NULL) {
#line 5000 "rygel-media-export-media-cache.c"
			goto __catch10_g_error;
		}
#line 593 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp17_ = self->priv->db;
#line 593 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_media_export_database_analyze (_tmp17_);
#line 595 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		result = TRUE;
#line 595 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return result;
#line 5011 "rygel-media-export-media-cache.c"
	}
	goto __finally10;
	__catch10_g_error:
	{
		GError* err = NULL;
		GError* _tmp18_;
		const gchar* _tmp19_;
		RygelMediaExportDatabase* _tmp20_;
#line 585 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		err = _inner_error_;
#line 585 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_inner_error_ = NULL;
#line 597 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp18_ = err;
#line 597 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp19_ = _tmp18_->message;
#line 597 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_warning ("rygel-media-export-media-cache.vala:597: Failed to create schema: %s", _tmp19_);
#line 598 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp20_ = self->priv->db;
#line 598 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_media_export_database_rollback (_tmp20_);
#line 585 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_error_free0 (err);
#line 5036 "rygel-media-export-media-cache.c"
	}
	__finally10:
#line 585 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 585 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 585 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_clear_error (&_inner_error_);
#line 585 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return FALSE;
#line 5047 "rygel-media-export-media-cache.c"
	}
#line 601 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	result = FALSE;
#line 601 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return result;
#line 5053 "rygel-media-export-media-cache.c"
}


static RygelMediaObject* rygel_media_export_media_cache_get_object_from_statement (RygelMediaExportMediaCache* self, RygelMediaContainer* parent, sqlite3_stmt* statement) {
	RygelMediaObject* result = NULL;
	RygelMediaObject* object;
	sqlite3_stmt* _tmp0_;
	const gchar* _tmp1_ = NULL;
	const gchar* title;
	sqlite3_stmt* _tmp2_;
	const gchar* _tmp3_ = NULL;
	const gchar* object_id;
	sqlite3_stmt* _tmp4_;
	const gchar* _tmp5_ = NULL;
	const gchar* uri;
	sqlite3_stmt* _tmp6_;
	gint _tmp7_ = 0;
	RygelMediaObject* _tmp32_;
#line 604 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 604 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (statement != NULL, NULL);
#line 606 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	object = NULL;
#line 607 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = statement;
#line 607 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp1_ = sqlite3_column_text (_tmp0_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_TITLE);
#line 607 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	title = _tmp1_;
#line 608 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp2_ = statement;
#line 608 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp3_ = sqlite3_column_text (_tmp2_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_ID);
#line 608 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	object_id = _tmp3_;
#line 609 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp4_ = statement;
#line 609 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp5_ = sqlite3_column_text (_tmp4_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_URI);
#line 609 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	uri = _tmp5_;
#line 611 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp6_ = statement;
#line 611 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp7_ = sqlite3_column_int (_tmp6_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_TYPE);
#line 611 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	switch (_tmp7_) {
#line 611 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		case 0:
#line 5104 "rygel-media-export-media-cache.c"
		{
			RygelMediaExportObjectFactory* _tmp8_;
			const gchar* _tmp9_;
			const gchar* _tmp10_;
			const gchar* _tmp11_;
			RygelMediaExportDBContainer* _tmp12_ = NULL;
			RygelMediaObject* _tmp13_;
			RygelMediaContainer* _tmp14_;
			RygelMediaContainer* container;
			const gchar* _tmp15_;
#line 614 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp8_ = self->priv->factory;
#line 614 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp9_ = object_id;
#line 614 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp10_ = title;
#line 614 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp11_ = uri;
#line 614 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp12_ = rygel_media_export_object_factory_get_container (_tmp8_, self, _tmp9_, _tmp10_, (guint) 0, _tmp11_);
#line 614 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_object_unref0 (object);
#line 614 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			object = (RygelMediaObject*) _tmp12_;
#line 616 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp13_ = object;
#line 616 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp14_ = _g_object_ref0 (RYGEL_IS_MEDIA_CONTAINER (_tmp13_) ? ((RygelMediaContainer*) _tmp13_) : NULL);
#line 616 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			container = _tmp14_;
#line 617 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp15_ = uri;
#line 617 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (_tmp15_ != NULL) {
#line 5139 "rygel-media-export-media-cache.c"
				RygelMediaContainer* _tmp16_;
				GeeArrayList* _tmp17_;
				const gchar* _tmp18_;
#line 618 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp16_ = container;
#line 618 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp17_ = ((RygelMediaObject*) _tmp16_)->uris;
#line 618 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp18_ = uri;
#line 618 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp17_, _tmp18_);
#line 5151 "rygel-media-export-media-cache.c"
			}
#line 620 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_object_unref0 (container);
#line 620 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			break;
#line 5157 "rygel-media-export-media-cache.c"
		}
#line 611 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		case 1:
#line 5161 "rygel-media-export-media-cache.c"
		{
			sqlite3_stmt* _tmp19_;
			const gchar* _tmp20_ = NULL;
			const gchar* upnp_class;
			RygelMediaExportObjectFactory* _tmp21_;
			RygelMediaContainer* _tmp22_;
			const gchar* _tmp23_;
			const gchar* _tmp24_;
			const gchar* _tmp25_;
			RygelMediaItem* _tmp26_ = NULL;
			sqlite3_stmt* _tmp27_;
			RygelMediaObject* _tmp28_;
			const gchar* _tmp29_;
#line 623 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp19_ = statement;
#line 623 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp20_ = sqlite3_column_text (_tmp19_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_CLASS);
#line 623 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			upnp_class = _tmp20_;
#line 625 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp21_ = self->priv->factory;
#line 625 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp22_ = parent;
#line 625 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp23_ = object_id;
#line 625 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp24_ = title;
#line 625 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp25_ = upnp_class;
#line 625 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp26_ = rygel_media_export_object_factory_get_item (_tmp21_, self, _tmp22_, _tmp23_, _tmp24_, _tmp25_);
#line 625 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_object_unref0 (object);
#line 625 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			object = (RygelMediaObject*) _tmp26_;
#line 630 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp27_ = statement;
#line 630 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp28_ = object;
#line 630 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			rygel_media_export_media_cache_fill_item (self, _tmp27_, RYGEL_IS_MEDIA_ITEM (_tmp28_) ? ((RygelMediaItem*) _tmp28_) : NULL);
#line 632 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp29_ = uri;
#line 632 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (_tmp29_ != NULL) {
#line 5207 "rygel-media-export-media-cache.c"
				RygelMediaObject* _tmp30_;
				const gchar* _tmp31_;
#line 633 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp30_ = object;
#line 633 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp31_ = uri;
#line 633 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				rygel_media_item_add_uri (RYGEL_IS_MEDIA_ITEM (_tmp30_) ? ((RygelMediaItem*) _tmp30_) : NULL, _tmp31_);
#line 5216 "rygel-media-export-media-cache.c"
			}
#line 635 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			break;
#line 5220 "rygel-media-export-media-cache.c"
		}
		default:
		{
#line 637 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_assert_not_reached ();
#line 5226 "rygel-media-export-media-cache.c"
		}
	}
#line 640 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp32_ = object;
#line 640 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_tmp32_ != NULL) {
#line 5233 "rygel-media-export-media-cache.c"
		RygelMediaObject* _tmp33_;
		sqlite3_stmt* _tmp34_;
		gint64 _tmp35_ = 0LL;
		gboolean _tmp36_ = FALSE;
		RygelMediaObject* _tmp37_;
		guint64 _tmp38_;
		gint64 _tmp39_;
		gboolean _tmp41_;
#line 641 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp33_ = object;
#line 641 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp34_ = statement;
#line 641 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp35_ = sqlite3_column_int64 (_tmp34_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_TIMESTAMP);
#line 641 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp33_->modified = (guint64) _tmp35_;
#line 642 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp37_ = object;
#line 642 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp38_ = _tmp37_->modified;
#line 642 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp39_ = G_MAXINT64;
#line 642 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_tmp38_ == ((guint64) _tmp39_)) {
#line 5258 "rygel-media-export-media-cache.c"
			RygelMediaObject* _tmp40_;
#line 642 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp40_ = object;
#line 642 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp36_ = RYGEL_IS_MEDIA_ITEM (_tmp40_);
#line 5264 "rygel-media-export-media-cache.c"
		} else {
#line 642 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp36_ = FALSE;
#line 5268 "rygel-media-export-media-cache.c"
		}
#line 642 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp41_ = _tmp36_;
#line 642 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_tmp41_) {
#line 5274 "rygel-media-export-media-cache.c"
			RygelMediaObject* _tmp42_;
			RygelMediaObject* _tmp43_;
#line 643 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp42_ = object;
#line 643 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp42_->modified = (guint64) 0;
#line 644 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp43_ = object;
#line 644 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			rygel_media_item_set_place_holder (RYGEL_IS_MEDIA_ITEM (_tmp43_) ? ((RygelMediaItem*) _tmp43_) : NULL, TRUE);
#line 5285 "rygel-media-export-media-cache.c"
		}
	}
#line 648 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	result = object;
#line 648 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return result;
#line 5292 "rygel-media-export-media-cache.c"
}


static void rygel_media_export_media_cache_fill_item (RygelMediaExportMediaCache* self, sqlite3_stmt* statement, RygelMediaItem* item) {
	RygelMediaItem* _tmp0_;
	sqlite3_stmt* _tmp1_;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	RygelMediaItem* _tmp4_;
	sqlite3_stmt* _tmp5_;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	RygelMediaItem* _tmp8_;
	sqlite3_stmt* _tmp9_;
	const gchar* _tmp10_ = NULL;
	gchar* _tmp11_;
	RygelMediaItem* _tmp12_;
	sqlite3_stmt* _tmp13_;
	gint64 _tmp14_ = 0LL;
	RygelMediaItem* _tmp15_;
	RygelMediaItem* _tmp52_;
#line 651 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_if_fail (self != NULL);
#line 651 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_if_fail (statement != NULL);
#line 651 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_if_fail (item != NULL);
#line 653 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = item;
#line 653 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp1_ = statement;
#line 653 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp2_ = sqlite3_column_text (_tmp1_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_DATE);
#line 653 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 653 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_free0 (_tmp0_->date);
#line 653 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_->date = _tmp3_;
#line 654 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp4_ = item;
#line 654 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp5_ = statement;
#line 654 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp6_ = sqlite3_column_text (_tmp5_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_MIME_TYPE);
#line 654 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp7_ = g_strdup (_tmp6_);
#line 654 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_free0 (_tmp4_->mime_type);
#line 654 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp4_->mime_type = _tmp7_;
#line 655 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp8_ = item;
#line 655 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp9_ = statement;
#line 655 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp10_ = sqlite3_column_text (_tmp9_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_DLNA_PROFILE);
#line 655 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp11_ = g_strdup (_tmp10_);
#line 655 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_free0 (_tmp8_->dlna_profile);
#line 655 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp8_->dlna_profile = _tmp11_;
#line 656 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp12_ = item;
#line 656 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp13_ = statement;
#line 656 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp14_ = sqlite3_column_int64 (_tmp13_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_SIZE);
#line 656 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	rygel_media_item_set_size (_tmp12_, _tmp14_);
#line 658 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp15_ = item;
#line 658 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (RYGEL_IS_AUDIO_ITEM (_tmp15_)) {
#line 5368 "rygel-media-export-media-cache.c"
		RygelMediaItem* _tmp16_;
		RygelAudioItem* _tmp17_;
		RygelAudioItem* audio_item;
		RygelAudioItem* _tmp18_;
		sqlite3_stmt* _tmp19_;
		gint64 _tmp20_ = 0LL;
		RygelAudioItem* _tmp21_;
		sqlite3_stmt* _tmp22_;
		gint _tmp23_ = 0;
		RygelAudioItem* _tmp24_;
		sqlite3_stmt* _tmp25_;
		gint _tmp26_ = 0;
		RygelAudioItem* _tmp27_;
		sqlite3_stmt* _tmp28_;
		gint _tmp29_ = 0;
		RygelAudioItem* _tmp30_;
		sqlite3_stmt* _tmp31_;
		gint _tmp32_ = 0;
		RygelMediaItem* _tmp33_;
#line 659 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp16_ = item;
#line 659 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp17_ = _g_object_ref0 (RYGEL_IS_AUDIO_ITEM (_tmp16_) ? ((RygelAudioItem*) _tmp16_) : NULL);
#line 659 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		audio_item = _tmp17_;
#line 660 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp18_ = audio_item;
#line 660 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp19_ = statement;
#line 660 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp20_ = sqlite3_column_int64 (_tmp19_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_DURATION);
#line 660 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp18_->duration = (glong) _tmp20_;
#line 662 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp21_ = audio_item;
#line 662 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp22_ = statement;
#line 662 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp23_ = sqlite3_column_int (_tmp22_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_BITRATE);
#line 662 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp21_->bitrate = _tmp23_;
#line 663 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp24_ = audio_item;
#line 663 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp25_ = statement;
#line 663 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp26_ = sqlite3_column_int (_tmp25_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_SAMPLE_FREQ);
#line 663 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp24_->sample_freq = _tmp26_;
#line 665 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp27_ = audio_item;
#line 665 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp28_ = statement;
#line 665 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp29_ = sqlite3_column_int (_tmp28_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_BITS_PER_SAMPLE);
#line 665 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp27_->bits_per_sample = _tmp29_;
#line 667 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp30_ = audio_item;
#line 667 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp31_ = statement;
#line 667 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp32_ = sqlite3_column_int (_tmp31_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_CHANNELS);
#line 667 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp30_->channels = _tmp32_;
#line 668 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp33_ = item;
#line 668 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (RYGEL_MEDIA_EXPORT_IS_MUSIC_ITEM (_tmp33_)) {
#line 5438 "rygel-media-export-media-cache.c"
			RygelMediaItem* _tmp34_;
			RygelMediaExportMusicItem* _tmp35_;
			RygelMediaExportMusicItem* music_item;
			RygelMediaExportMusicItem* _tmp36_;
			sqlite3_stmt* _tmp37_;
			const gchar* _tmp38_ = NULL;
			gchar* _tmp39_;
			RygelMediaExportMusicItem* _tmp40_;
			sqlite3_stmt* _tmp41_;
			const gchar* _tmp42_ = NULL;
			gchar* _tmp43_;
			RygelMediaExportMusicItem* _tmp44_;
			sqlite3_stmt* _tmp45_;
			const gchar* _tmp46_ = NULL;
			gchar* _tmp47_;
			RygelMediaExportMusicItem* _tmp48_;
			sqlite3_stmt* _tmp49_;
			gint _tmp50_ = 0;
			RygelMediaExportMusicItem* _tmp51_;
#line 669 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp34_ = item;
#line 669 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp35_ = _g_object_ref0 (RYGEL_MEDIA_EXPORT_IS_MUSIC_ITEM (_tmp34_) ? ((RygelMediaExportMusicItem*) _tmp34_) : NULL);
#line 669 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			music_item = _tmp35_;
#line 670 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp36_ = music_item;
#line 670 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp37_ = statement;
#line 670 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp38_ = sqlite3_column_text (_tmp37_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_AUTHOR);
#line 670 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp39_ = g_strdup (_tmp38_);
#line 670 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_free0 (((RygelMusicItem*) _tmp36_)->artist);
#line 670 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			((RygelMusicItem*) _tmp36_)->artist = _tmp39_;
#line 671 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp40_ = music_item;
#line 671 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp41_ = statement;
#line 671 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp42_ = sqlite3_column_text (_tmp41_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_ALBUM);
#line 671 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp43_ = g_strdup (_tmp42_);
#line 671 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_free0 (((RygelMusicItem*) _tmp40_)->album);
#line 671 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			((RygelMusicItem*) _tmp40_)->album = _tmp43_;
#line 672 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp44_ = music_item;
#line 672 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp45_ = statement;
#line 672 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp46_ = sqlite3_column_text (_tmp45_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_GENRE);
#line 672 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp47_ = g_strdup (_tmp46_);
#line 672 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_free0 (((RygelMusicItem*) _tmp44_)->genre);
#line 672 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			((RygelMusicItem*) _tmp44_)->genre = _tmp47_;
#line 673 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp48_ = music_item;
#line 673 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp49_ = statement;
#line 673 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp50_ = sqlite3_column_int (_tmp49_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_TRACK);
#line 673 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			((RygelMusicItem*) _tmp48_)->track_number = _tmp50_;
#line 675 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp51_ = music_item;
#line 675 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			rygel_music_item_lookup_album_art ((RygelMusicItem*) _tmp51_);
#line 668 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_object_unref0 (music_item);
#line 5514 "rygel-media-export-media-cache.c"
		}
#line 658 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_object_unref0 (audio_item);
#line 5518 "rygel-media-export-media-cache.c"
	}
#line 679 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp52_ = item;
#line 679 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (RYGEL_IS_VISUAL_ITEM (_tmp52_)) {
#line 5524 "rygel-media-export-media-cache.c"
		RygelMediaItem* _tmp53_;
		RygelVisualItem* _tmp54_;
		RygelVisualItem* visual_item;
		RygelVisualItem* _tmp55_;
		sqlite3_stmt* _tmp56_;
		gint _tmp57_ = 0;
		RygelVisualItem* _tmp58_;
		sqlite3_stmt* _tmp59_;
		gint _tmp60_ = 0;
		RygelVisualItem* _tmp61_;
		sqlite3_stmt* _tmp62_;
		gint _tmp63_ = 0;
		RygelMediaItem* _tmp64_;
#line 680 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp53_ = item;
#line 680 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp54_ = _g_object_ref0 (RYGEL_IS_VISUAL_ITEM (_tmp53_) ? ((RygelVisualItem*) _tmp53_) : NULL);
#line 680 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		visual_item = _tmp54_;
#line 681 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp55_ = visual_item;
#line 681 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp56_ = statement;
#line 681 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp57_ = sqlite3_column_int (_tmp56_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_WIDTH);
#line 681 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_visual_item_set_width (_tmp55_, _tmp57_);
#line 682 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp58_ = visual_item;
#line 682 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp59_ = statement;
#line 682 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp60_ = sqlite3_column_int (_tmp59_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_HEIGHT);
#line 682 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_visual_item_set_height (_tmp58_, _tmp60_);
#line 683 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp61_ = visual_item;
#line 683 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp62_ = statement;
#line 683 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp63_ = sqlite3_column_int (_tmp62_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_COLOR_DEPTH);
#line 683 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_visual_item_set_color_depth (_tmp61_, _tmp63_);
#line 685 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp64_ = item;
#line 685 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (RYGEL_IS_VIDEO_ITEM (_tmp64_)) {
#line 5572 "rygel-media-export-media-cache.c"
			RygelMediaItem* _tmp65_;
			RygelVideoItem* _tmp66_;
			RygelVideoItem* video_item;
			RygelVideoItem* _tmp67_;
			sqlite3_stmt* _tmp68_;
			const gchar* _tmp69_ = NULL;
			gchar* _tmp70_;
#line 686 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp65_ = item;
#line 686 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp66_ = _g_object_ref0 (RYGEL_IS_VIDEO_ITEM (_tmp65_) ? ((RygelVideoItem*) _tmp65_) : NULL);
#line 686 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			video_item = _tmp66_;
#line 687 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp67_ = video_item;
#line 687 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp68_ = statement;
#line 687 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp69_ = sqlite3_column_text (_tmp68_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_AUTHOR);
#line 687 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp70_ = g_strdup (_tmp69_);
#line 687 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_free0 (_tmp67_->author);
#line 687 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp67_->author = _tmp70_;
#line 685 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_object_unref0 (video_item);
#line 5600 "rygel-media-export-media-cache.c"
		}
#line 679 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_object_unref0 (visual_item);
#line 5604 "rygel-media-export-media-cache.c"
	}
}


static gchar* rygel_media_export_media_cache_translate_search_expression (RygelMediaExportMediaCache* self, RygelSearchExpression* expression, GValueArray* args, const gchar* prefix, GError** error) {
	gchar* result = NULL;
	RygelSearchExpression* _tmp0_;
	RygelSearchExpression* _tmp2_;
	GValueArray* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* filter;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_ = NULL;
	GError * _inner_error_ = NULL;
#line 692 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 692 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (args != NULL, NULL);
#line 692 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (prefix != NULL, NULL);
#line 697 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = expression;
#line 697 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_tmp0_ == NULL) {
#line 5630 "rygel-media-export-media-cache.c"
		gchar* _tmp1_;
#line 698 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp1_ = g_strdup ("");
#line 698 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		result = _tmp1_;
#line 698 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return result;
#line 5638 "rygel-media-export-media-cache.c"
	}
#line 701 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp2_ = expression;
#line 701 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp3_ = args;
#line 701 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp4_ = rygel_media_export_media_cache_search_expression_to_sql (self, _tmp2_, _tmp3_, &_inner_error_);
#line 701 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	filter = _tmp4_;
#line 701 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 701 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 701 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return NULL;
#line 5654 "rygel-media-export-media-cache.c"
	}
#line 703 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp5_ = prefix;
#line 703 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp6_ = filter;
#line 703 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp7_ = g_strdup_printf (" %s %s", _tmp5_, _tmp6_);
#line 703 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	result = _tmp7_;
#line 703 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_free0 (filter);
#line 703 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return result;
#line 5668 "rygel-media-export-media-cache.c"
}


static gchar* rygel_media_export_media_cache_search_expression_to_sql (RygelMediaExportMediaCache* self, RygelSearchExpression* expression, GValueArray* args, GError** error) {
	gchar* result = NULL;
	RygelSearchExpression* _tmp0_;
	RygelSearchExpression* _tmp2_;
	GError * _inner_error_ = NULL;
#line 706 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 706 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (args != NULL, NULL);
#line 709 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = expression;
#line 709 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_tmp0_ == NULL) {
#line 5685 "rygel-media-export-media-cache.c"
		gchar* _tmp1_;
#line 710 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp1_ = g_strdup ("");
#line 710 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		result = _tmp1_;
#line 710 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return result;
#line 5693 "rygel-media-export-media-cache.c"
	}
#line 713 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp2_ = expression;
#line 713 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (RYGEL_IS_LOGICAL_EXPRESSION (_tmp2_)) {
#line 5699 "rygel-media-export-media-cache.c"
		RygelSearchExpression* _tmp3_;
		GValueArray* _tmp4_;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_;
#line 714 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp3_ = expression;
#line 714 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp4_ = args;
#line 714 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp5_ = rygel_media_export_media_cache_logical_expression_to_sql (self, RYGEL_IS_LOGICAL_EXPRESSION (_tmp3_) ? ((RygelLogicalExpression*) _tmp3_) : NULL, _tmp4_, &_inner_error_);
#line 714 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp6_ = _tmp5_;
#line 714 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_inner_error_ != NULL) {
#line 714 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_propagate_error (error, _inner_error_);
#line 714 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return NULL;
#line 5718 "rygel-media-export-media-cache.c"
		}
#line 714 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		result = _tmp6_;
#line 714 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return result;
#line 5724 "rygel-media-export-media-cache.c"
	} else {
		RygelSearchExpression* _tmp7_;
		GValueArray* _tmp8_;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_;
#line 717 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp7_ = expression;
#line 717 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp8_ = args;
#line 717 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp9_ = rygel_media_export_media_cache_relational_expression_to_sql (self, RYGEL_IS_RELATIONAL_EXPRESSION (_tmp7_) ? ((RygelRelationalExpression*) _tmp7_) : NULL, _tmp8_, &_inner_error_);
#line 717 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp10_ = _tmp9_;
#line 717 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_inner_error_ != NULL) {
#line 717 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_propagate_error (error, _inner_error_);
#line 717 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return NULL;
#line 5744 "rygel-media-export-media-cache.c"
		}
#line 717 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		result = _tmp10_;
#line 717 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return result;
#line 5750 "rygel-media-export-media-cache.c"
	}
}


static gchar* rygel_media_export_media_cache_logical_expression_to_sql (RygelMediaExportMediaCache* self, RygelLogicalExpression* expression, GValueArray* args, GError** error) {
	gchar* result = NULL;
	RygelLogicalExpression* _tmp0_;
	gconstpointer _tmp1_;
	GValueArray* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* left_sql_string;
	RygelLogicalExpression* _tmp4_;
	gconstpointer _tmp5_;
	GValueArray* _tmp6_;
	gchar* _tmp7_ = NULL;
	gchar* right_sql_string;
	gchar* _tmp8_;
	gchar* operator_sql_string;
	RygelLogicalExpression* _tmp9_;
	gconstpointer _tmp10_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_ = NULL;
	GError * _inner_error_ = NULL;
#line 723 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 723 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (args != NULL, NULL);
#line 726 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = expression;
#line 726 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp1_ = ((RygelSearchExpression*) _tmp0_)->operand1;
#line 726 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp2_ = args;
#line 726 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp3_ = rygel_media_export_media_cache_search_expression_to_sql (self, (RygelSearchExpression*) _tmp1_, _tmp2_, &_inner_error_);
#line 726 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	left_sql_string = _tmp3_;
#line 726 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 726 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 726 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return NULL;
#line 5796 "rygel-media-export-media-cache.c"
	}
#line 728 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp4_ = expression;
#line 728 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp5_ = ((RygelSearchExpression*) _tmp4_)->operand2;
#line 728 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp6_ = args;
#line 728 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp7_ = rygel_media_export_media_cache_search_expression_to_sql (self, (RygelSearchExpression*) _tmp5_, _tmp6_, &_inner_error_);
#line 728 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	right_sql_string = _tmp7_;
#line 728 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 728 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 728 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_free0 (left_sql_string);
#line 728 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return NULL;
#line 5816 "rygel-media-export-media-cache.c"
	}
#line 730 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp8_ = g_strdup ("OR");
#line 730 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	operator_sql_string = _tmp8_;
#line 732 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp9_ = expression;
#line 732 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp10_ = ((RygelSearchExpression*) _tmp9_)->op;
#line 732 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (GPOINTER_TO_INT (_tmp10_) == RYGEL_LOGICAL_OPERATOR_AND) {
#line 5828 "rygel-media-export-media-cache.c"
		gchar* _tmp11_;
#line 733 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp11_ = g_strdup ("AND");
#line 733 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_free0 (operator_sql_string);
#line 733 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		operator_sql_string = _tmp11_;
#line 5836 "rygel-media-export-media-cache.c"
	}
#line 736 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp12_ = left_sql_string;
#line 736 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp13_ = operator_sql_string;
#line 736 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp14_ = right_sql_string;
#line 736 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp15_ = g_strdup_printf ("(%s %s %s)", _tmp12_, _tmp13_, _tmp14_);
#line 736 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	result = _tmp15_;
#line 736 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_free0 (operator_sql_string);
#line 736 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_free0 (right_sql_string);
#line 736 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_free0 (left_sql_string);
#line 736 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return result;
#line 5856 "rygel-media-export-media-cache.c"
}


static gchar* rygel_media_export_media_cache_map_operand_to_column (RygelMediaExportMediaCache* self, const gchar* operand, gchar** collate, GError** error) {
	gchar* _vala_collate = NULL;
	gchar* result = NULL;
	gchar* column;
	gboolean use_collation;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
#line 747 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	static GQuark _tmp2_label0 = 0;
#line 747 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	static GQuark _tmp2_label1 = 0;
#line 747 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	static GQuark _tmp2_label2 = 0;
#line 747 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	static GQuark _tmp2_label3 = 0;
#line 747 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	static GQuark _tmp2_label4 = 0;
#line 747 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	static GQuark _tmp2_label5 = 0;
#line 747 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	static GQuark _tmp2_label6 = 0;
#line 747 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	static GQuark _tmp2_label7 = 0;
#line 747 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	static GQuark _tmp2_label8 = 0;
#line 747 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	static GQuark _tmp2_label9 = 0;
#line 747 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	static GQuark _tmp2_label10 = 0;
#line 747 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	static GQuark _tmp2_label11 = 0;
#line 747 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	static GQuark _tmp2_label12 = 0;
#line 747 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	static GQuark _tmp2_label13 = 0;
#line 747 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	static GQuark _tmp2_label14 = 0;
#line 5898 "rygel-media-export-media-cache.c"
	gboolean _tmp21_;
	GError * _inner_error_ = NULL;
#line 741 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 741 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (operand != NULL, NULL);
#line 744 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	column = NULL;
#line 745 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	use_collation = FALSE;
#line 747 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = operand;
#line 747 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp1_ = _tmp0_;
#line 747 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
#line 747 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("res")))) {
#line 747 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		switch (0) {
#line 5919 "rygel-media-export-media-cache.c"
			default:
			{
				gchar* _tmp4_;
#line 749 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp4_ = g_strdup ("o.uri");
#line 749 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_free0 (column);
#line 749 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				column = _tmp4_;
#line 750 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				break;
#line 5931 "rygel-media-export-media-cache.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("res@duration")))) {
#line 747 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		switch (0) {
#line 5937 "rygel-media-export-media-cache.c"
			default:
			{
				gchar* _tmp5_;
#line 752 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp5_ = g_strdup ("m.duration");
#line 752 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_free0 (column);
#line 752 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				column = _tmp5_;
#line 753 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				break;
#line 5949 "rygel-media-export-media-cache.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("@refID")))) {
#line 747 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		switch (0) {
#line 5955 "rygel-media-export-media-cache.c"
			default:
			{
				gchar* _tmp6_;
#line 755 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp6_ = g_strdup ("NULL");
#line 755 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_free0 (column);
#line 755 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				column = _tmp6_;
#line 756 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				break;
#line 5967 "rygel-media-export-media-cache.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label3) ? _tmp2_label3 : (_tmp2_label3 = g_quark_from_static_string ("@id")))) {
#line 747 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		switch (0) {
#line 5973 "rygel-media-export-media-cache.c"
			default:
			{
				gchar* _tmp7_;
#line 758 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp7_ = g_strdup ("o.upnp_id");
#line 758 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_free0 (column);
#line 758 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				column = _tmp7_;
#line 759 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				break;
#line 5985 "rygel-media-export-media-cache.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label4) ? _tmp2_label4 : (_tmp2_label4 = g_quark_from_static_string ("@parentID")))) {
#line 747 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		switch (0) {
#line 5991 "rygel-media-export-media-cache.c"
			default:
			{
				gchar* _tmp8_;
#line 761 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp8_ = g_strdup ("o.parent");
#line 761 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_free0 (column);
#line 761 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				column = _tmp8_;
#line 762 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				break;
#line 6003 "rygel-media-export-media-cache.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label5) ? _tmp2_label5 : (_tmp2_label5 = g_quark_from_static_string ("upnp:class")))) {
#line 747 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		switch (0) {
#line 6009 "rygel-media-export-media-cache.c"
			default:
			{
				gchar* _tmp9_;
#line 764 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp9_ = g_strdup ("m.class");
#line 764 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_free0 (column);
#line 764 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				column = _tmp9_;
#line 765 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				break;
#line 6021 "rygel-media-export-media-cache.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label6) ? _tmp2_label6 : (_tmp2_label6 = g_quark_from_static_string ("dc:title")))) {
#line 747 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		switch (0) {
#line 6027 "rygel-media-export-media-cache.c"
			default:
			{
				gchar* _tmp10_;
#line 767 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp10_ = g_strdup ("o.title");
#line 767 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_free0 (column);
#line 767 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				column = _tmp10_;
#line 768 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				use_collation = TRUE;
#line 769 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				break;
#line 6041 "rygel-media-export-media-cache.c"
			}
		}
	} else if ((_tmp3_ == ((0 != _tmp2_label7) ? _tmp2_label7 : (_tmp2_label7 = g_quark_from_static_string ("upnp:artist")))) || (_tmp3_ == ((0 != _tmp2_label8) ? _tmp2_label8 : (_tmp2_label8 = g_quark_from_static_string ("dc:creator"))))) {
#line 747 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		switch (0) {
#line 6047 "rygel-media-export-media-cache.c"
			default:
			{
				gchar* _tmp11_;
#line 772 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp11_ = g_strdup ("m.author");
#line 772 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_free0 (column);
#line 772 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				column = _tmp11_;
#line 773 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				use_collation = TRUE;
#line 774 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				break;
#line 6061 "rygel-media-export-media-cache.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label9) ? _tmp2_label9 : (_tmp2_label9 = g_quark_from_static_string ("dc:date")))) {
#line 747 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		switch (0) {
#line 6067 "rygel-media-export-media-cache.c"
			default:
			{
				gchar* _tmp12_;
#line 776 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp12_ = g_strdup ("strftime(\"%Y\", m.date)");
#line 776 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_free0 (column);
#line 776 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				column = _tmp12_;
#line 777 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				break;
#line 6079 "rygel-media-export-media-cache.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label10) ? _tmp2_label10 : (_tmp2_label10 = g_quark_from_static_string ("upnp:album")))) {
#line 747 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		switch (0) {
#line 6085 "rygel-media-export-media-cache.c"
			default:
			{
				gchar* _tmp13_;
#line 779 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp13_ = g_strdup ("m.album");
#line 779 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_free0 (column);
#line 779 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				column = _tmp13_;
#line 780 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				use_collation = TRUE;
#line 781 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				break;
#line 6099 "rygel-media-export-media-cache.c"
			}
		}
	} else if ((_tmp3_ == ((0 != _tmp2_label11) ? _tmp2_label11 : (_tmp2_label11 = g_quark_from_static_string ("upnp:genre")))) || (_tmp3_ == ((0 != _tmp2_label12) ? _tmp2_label12 : (_tmp2_label12 = g_quark_from_static_string ("dc:genre"))))) {
#line 747 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		switch (0) {
#line 6105 "rygel-media-export-media-cache.c"
			default:
			{
				gchar* _tmp14_;
#line 785 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp14_ = g_strdup ("m.genre");
#line 785 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_free0 (column);
#line 785 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				column = _tmp14_;
#line 786 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				use_collation = TRUE;
#line 787 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				break;
#line 6119 "rygel-media-export-media-cache.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label13) ? _tmp2_label13 : (_tmp2_label13 = g_quark_from_static_string ("upnp:originalTrackNumber")))) {
#line 747 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		switch (0) {
#line 6125 "rygel-media-export-media-cache.c"
			default:
			{
				gchar* _tmp15_;
#line 789 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp15_ = g_strdup ("m.track");
#line 789 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_free0 (column);
#line 789 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				column = _tmp15_;
#line 790 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				break;
#line 6137 "rygel-media-export-media-cache.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label14) ? _tmp2_label14 : (_tmp2_label14 = g_quark_from_static_string ("rygel:originalVolumeNumber")))) {
#line 747 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		switch (0) {
#line 6143 "rygel-media-export-media-cache.c"
			default:
			{
				gchar* _tmp16_;
#line 792 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp16_ = g_strdup ("m.disc");
#line 792 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_free0 (column);
#line 792 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				column = _tmp16_;
#line 793 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				break;
#line 6155 "rygel-media-export-media-cache.c"
			}
		}
	} else {
#line 747 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		switch (0) {
#line 6161 "rygel-media-export-media-cache.c"
			default:
			{
				const gchar* _tmp17_;
				gchar* _tmp18_ = NULL;
				gchar* message;
				const gchar* _tmp19_;
				GError* _tmp20_;
#line 795 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp17_ = operand;
#line 795 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp18_ = g_strdup_printf ("Unsupported column %s", _tmp17_);
#line 795 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				message = _tmp18_;
#line 797 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp19_ = message;
#line 797 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp20_ = g_error_new_literal (RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR, RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_UNSUPPORTED_SEARCH, _tmp19_);
#line 797 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_inner_error_ = _tmp20_;
#line 797 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				g_propagate_error (error, _inner_error_);
#line 797 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_free0 (message);
#line 797 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_free0 (column);
#line 797 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				return NULL;
#line 6189 "rygel-media-export-media-cache.c"
			}
		}
	}
#line 800 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp21_ = use_collation;
#line 800 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_tmp21_) {
#line 6197 "rygel-media-export-media-cache.c"
		gchar* _tmp22_;
#line 801 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp22_ = g_strdup ("COLLATE CASEFOLD");
#line 801 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_free0 (_vala_collate);
#line 801 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_vala_collate = _tmp22_;
#line 6205 "rygel-media-export-media-cache.c"
	} else {
		gchar* _tmp23_;
#line 803 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp23_ = g_strdup ("");
#line 803 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_free0 (_vala_collate);
#line 803 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_vala_collate = _tmp23_;
#line 6214 "rygel-media-export-media-cache.c"
	}
#line 806 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	result = column;
#line 806 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (collate) {
#line 806 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		*collate = _vala_collate;
#line 6222 "rygel-media-export-media-cache.c"
	} else {
#line 806 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_free0 (_vala_collate);
#line 6226 "rygel-media-export-media-cache.c"
	}
#line 806 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return result;
#line 6230 "rygel-media-export-media-cache.c"
}


static gchar* rygel_media_export_media_cache_relational_expression_to_sql (RygelMediaExportMediaCache* self, RygelRelationalExpression* exp, GValueArray* args, GError** error) {
	gchar* result = NULL;
	GValue* v;
	gchar* collate;
	RygelRelationalExpression* _tmp0_;
	gconstpointer _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* column;
	RygelMediaExportSqlOperator* operator = NULL;
	RygelRelationalExpression* _tmp4_;
	gconstpointer _tmp5_;
	GValue* _tmp40_;
	RygelMediaExportSqlOperator* _tmp44_;
	gchar* _tmp45_ = NULL;
	GError * _inner_error_ = NULL;
#line 809 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 809 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (args != NULL, NULL);
#line 812 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	v = NULL;
#line 813 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	collate = NULL;
#line 815 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = exp;
#line 815 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp1_ = ((RygelSearchExpression*) _tmp0_)->operand1;
#line 815 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp3_ = rygel_media_export_media_cache_map_operand_to_column (self, (const gchar*) _tmp1_, &_tmp2_, &_inner_error_);
#line 815 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_free0 (collate);
#line 815 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	collate = _tmp2_;
#line 815 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	column = _tmp3_;
#line 815 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 815 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 815 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_free0 (collate);
#line 815 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		__vala_GValue_free0 (v);
#line 815 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return NULL;
#line 6280 "rygel-media-export-media-cache.c"
	}
#line 818 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp4_ = exp;
#line 818 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp5_ = ((RygelSearchExpression*) _tmp4_)->op;
#line 818 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	switch (GPOINTER_TO_INT (_tmp5_)) {
#line 818 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		case GUPNP_SEARCH_CRITERIA_OP_EXISTS:
#line 6290 "rygel-media-export-media-cache.c"
		{
			gchar* sql_function = NULL;
			RygelRelationalExpression* _tmp6_;
			gconstpointer _tmp7_;
			const gchar* _tmp10_;
			const gchar* _tmp11_;
			const gchar* _tmp12_;
			gchar* _tmp13_ = NULL;
#line 821 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp6_ = exp;
#line 821 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp7_ = ((RygelSearchExpression*) _tmp6_)->operand2;
#line 821 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (g_strcmp0 ((const gchar*) _tmp7_, "true") == 0) {
#line 6305 "rygel-media-export-media-cache.c"
				gchar* _tmp8_;
#line 822 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp8_ = g_strdup ("%s IS NOT NULL AND %s != ''");
#line 822 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_free0 (sql_function);
#line 822 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				sql_function = _tmp8_;
#line 6313 "rygel-media-export-media-cache.c"
			} else {
				gchar* _tmp9_;
#line 824 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp9_ = g_strdup ("%s IS NULL OR %s = ''");
#line 824 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_free0 (sql_function);
#line 824 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				sql_function = _tmp9_;
#line 6322 "rygel-media-export-media-cache.c"
			}
#line 827 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp10_ = sql_function;
#line 827 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp11_ = column;
#line 827 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp12_ = column;
#line 827 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp13_ = g_strdup_printf (_tmp10_, _tmp11_, _tmp12_);
#line 827 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			result = _tmp13_;
#line 827 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_free0 (sql_function);
#line 827 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_object_unref0 (operator);
#line 827 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_free0 (column);
#line 827 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_free0 (collate);
#line 827 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			__vala_GValue_free0 (v);
#line 827 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return result;
#line 6346 "rygel-media-export-media-cache.c"
		}
#line 818 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		case GUPNP_SEARCH_CRITERIA_OP_EQ:
#line 818 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		case GUPNP_SEARCH_CRITERIA_OP_NEQ:
#line 818 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		case GUPNP_SEARCH_CRITERIA_OP_LESS:
#line 818 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		case GUPNP_SEARCH_CRITERIA_OP_LEQ:
#line 818 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		case GUPNP_SEARCH_CRITERIA_OP_GREATER:
#line 818 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		case GUPNP_SEARCH_CRITERIA_OP_GEQ:
#line 6360 "rygel-media-export-media-cache.c"
		{
			RygelRelationalExpression* _tmp14_;
			gconstpointer _tmp15_;
			GValue* _tmp16_ = NULL;
			RygelRelationalExpression* _tmp17_;
			gconstpointer _tmp18_;
			const gchar* _tmp19_;
			const gchar* _tmp20_;
			RygelMediaExportSqlOperator* _tmp21_;
#line 834 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp14_ = exp;
#line 834 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp15_ = ((RygelSearchExpression*) _tmp14_)->operand2;
#line 834 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp16_ = g_new0 (GValue, 1);
#line 834 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_value_init (_tmp16_, G_TYPE_STRING);
#line 834 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_value_set_string (_tmp16_, (const gchar*) _tmp15_);
#line 834 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			__vala_GValue_free0 (v);
#line 834 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			v = _tmp16_;
#line 835 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp17_ = exp;
#line 835 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp18_ = ((RygelSearchExpression*) _tmp17_)->op;
#line 835 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp19_ = column;
#line 835 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp20_ = collate;
#line 835 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp21_ = rygel_media_export_sql_operator_new_from_search_criteria_op (GPOINTER_TO_INT (_tmp18_), _tmp19_, _tmp20_);
#line 835 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_object_unref0 (operator);
#line 835 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			operator = _tmp21_;
#line 837 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			break;
#line 6400 "rygel-media-export-media-cache.c"
		}
#line 818 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		case GUPNP_SEARCH_CRITERIA_OP_CONTAINS:
#line 6404 "rygel-media-export-media-cache.c"
		{
			const gchar* _tmp22_;
			RygelMediaExportSqlFunction* _tmp23_;
			RygelRelationalExpression* _tmp24_;
			gconstpointer _tmp25_;
			GValue* _tmp26_ = NULL;
#line 839 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp22_ = column;
#line 839 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp23_ = rygel_media_export_sql_function_new ("contains", _tmp22_);
#line 839 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_object_unref0 (operator);
#line 839 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			operator = (RygelMediaExportSqlOperator*) _tmp23_;
#line 840 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp24_ = exp;
#line 840 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp25_ = ((RygelSearchExpression*) _tmp24_)->operand2;
#line 840 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp26_ = g_new0 (GValue, 1);
#line 840 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_value_init (_tmp26_, G_TYPE_STRING);
#line 840 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_value_set_string (_tmp26_, (const gchar*) _tmp25_);
#line 840 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			__vala_GValue_free0 (v);
#line 840 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			v = _tmp26_;
#line 841 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			break;
#line 6435 "rygel-media-export-media-cache.c"
		}
#line 818 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		case GUPNP_SEARCH_CRITERIA_OP_DOES_NOT_CONTAIN:
#line 6439 "rygel-media-export-media-cache.c"
		{
			const gchar* _tmp27_;
			RygelMediaExportSqlFunction* _tmp28_;
			RygelRelationalExpression* _tmp29_;
			gconstpointer _tmp30_;
			GValue* _tmp31_ = NULL;
#line 843 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp27_ = column;
#line 843 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp28_ = rygel_media_export_sql_function_new ("NOT contains", _tmp27_);
#line 843 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_object_unref0 (operator);
#line 843 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			operator = (RygelMediaExportSqlOperator*) _tmp28_;
#line 844 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp29_ = exp;
#line 844 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp30_ = ((RygelSearchExpression*) _tmp29_)->operand2;
#line 844 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp31_ = g_new0 (GValue, 1);
#line 844 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_value_init (_tmp31_, G_TYPE_STRING);
#line 844 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_value_set_string (_tmp31_, (const gchar*) _tmp30_);
#line 844 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			__vala_GValue_free0 (v);
#line 844 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			v = _tmp31_;
#line 845 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			break;
#line 6470 "rygel-media-export-media-cache.c"
		}
#line 818 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		case GUPNP_SEARCH_CRITERIA_OP_DERIVED_FROM:
#line 6474 "rygel-media-export-media-cache.c"
		{
			const gchar* _tmp32_;
			RygelMediaExportSqlOperator* _tmp33_;
			RygelRelationalExpression* _tmp34_;
			gconstpointer _tmp35_;
			gchar* _tmp36_ = NULL;
			GValue* _tmp37_ = NULL;
#line 847 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp32_ = column;
#line 847 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp33_ = rygel_media_export_sql_operator_new ("LIKE", _tmp32_, "");
#line 847 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_object_unref0 (operator);
#line 847 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			operator = _tmp33_;
#line 848 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp34_ = exp;
#line 848 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp35_ = ((RygelSearchExpression*) _tmp34_)->operand2;
#line 848 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp36_ = g_strdup_printf ("%s%%", (const gchar*) _tmp35_);
#line 848 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp37_ = g_new0 (GValue, 1);
#line 848 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_value_init (_tmp37_, G_TYPE_STRING);
#line 848 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_value_take_string (_tmp37_, _tmp36_);
#line 848 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			__vala_GValue_free0 (v);
#line 848 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			v = _tmp37_;
#line 849 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			break;
#line 6508 "rygel-media-export-media-cache.c"
		}
		default:
		{
			RygelRelationalExpression* _tmp38_;
			gconstpointer _tmp39_;
#line 851 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp38_ = exp;
#line 851 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp39_ = ((RygelSearchExpression*) _tmp38_)->op;
#line 851 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_warning ("rygel-media-export-media-cache.vala:851: Unsupported op %d", (gint) GPOINTER_TO_INT (_tmp39_));
#line 852 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			result = NULL;
#line 852 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_object_unref0 (operator);
#line 852 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_free0 (column);
#line 852 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_free0 (collate);
#line 852 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			__vala_GValue_free0 (v);
#line 852 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return result;
#line 6532 "rygel-media-export-media-cache.c"
		}
	}
#line 855 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp40_ = v;
#line 855 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_tmp40_ != NULL) {
#line 6539 "rygel-media-export-media-cache.c"
		GValueArray* _tmp41_;
		GValue* _tmp42_;
		GValue _tmp43_;
#line 856 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp41_ = args;
#line 856 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp42_ = v;
#line 856 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp43_ = *_tmp42_;
#line 856 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_array_append (_tmp41_, &_tmp43_);
#line 6551 "rygel-media-export-media-cache.c"
	}
#line 859 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp44_ = operator;
#line 859 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp45_ = rygel_media_export_sql_operator_to_string (_tmp44_);
#line 859 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	result = _tmp45_;
#line 859 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_object_unref0 (operator);
#line 859 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_free0 (column);
#line 859 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_free0 (collate);
#line 859 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	__vala_GValue_free0 (v);
#line 859 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return result;
#line 6569 "rygel-media-export-media-cache.c"
}


static RygelMediaExportDatabaseCursor* rygel_media_export_media_cache_exec_cursor (RygelMediaExportMediaCache* self, RygelMediaExportSQLString id, GValue* values, int values_length1, GError** error) {
	RygelMediaExportDatabaseCursor* result = NULL;
	RygelMediaExportDatabase* _tmp0_;
	RygelMediaExportSQLFactory* _tmp1_;
	RygelMediaExportSQLString _tmp2_;
	const gchar* _tmp3_ = NULL;
	GValue* _tmp4_;
	gint _tmp4__length1;
	RygelMediaExportDatabaseCursor* _tmp5_ = NULL;
	RygelMediaExportDatabaseCursor* _tmp6_;
	GError * _inner_error_ = NULL;
#line 862 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 865 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = self->priv->db;
#line 865 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp1_ = self->priv->sql;
#line 865 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp2_ = id;
#line 865 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp3_ = rygel_media_export_sql_factory_make (_tmp1_, _tmp2_);
#line 865 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp4_ = values;
#line 865 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp4__length1 = values_length1;
#line 865 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp5_ = rygel_media_export_database_exec_cursor (_tmp0_, _tmp3_, _tmp4_, _tmp4__length1, &_inner_error_);
#line 865 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp6_ = _tmp5_;
#line 865 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 865 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 865 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_propagate_error (error, _inner_error_);
#line 865 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return NULL;
#line 6610 "rygel-media-export-media-cache.c"
		} else {
#line 865 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 865 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_clear_error (&_inner_error_);
#line 865 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return NULL;
#line 6618 "rygel-media-export-media-cache.c"
		}
	}
#line 865 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	result = _tmp6_;
#line 865 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return result;
#line 6625 "rygel-media-export-media-cache.c"
}


static gint rygel_media_export_media_cache_query_value (RygelMediaExportMediaCache* self, RygelMediaExportSQLString id, GValue* values, int values_length1, GError** error) {
	gint result = 0;
	RygelMediaExportDatabase* _tmp0_;
	RygelMediaExportSQLFactory* _tmp1_;
	RygelMediaExportSQLString _tmp2_;
	const gchar* _tmp3_ = NULL;
	GValue* _tmp4_;
	gint _tmp4__length1;
	gint _tmp5_ = 0;
	gint _tmp6_;
	GError * _inner_error_ = NULL;
#line 868 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 871 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = self->priv->db;
#line 871 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp1_ = self->priv->sql;
#line 871 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp2_ = id;
#line 871 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp3_ = rygel_media_export_sql_factory_make (_tmp1_, _tmp2_);
#line 871 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp4_ = values;
#line 871 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp4__length1 = values_length1;
#line 871 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp5_ = rygel_media_export_database_query_value (_tmp0_, _tmp3_, _tmp4_, _tmp4__length1, &_inner_error_);
#line 871 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp6_ = _tmp5_;
#line 871 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 871 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 871 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_propagate_error (error, _inner_error_);
#line 871 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return 0;
#line 6666 "rygel-media-export-media-cache.c"
		} else {
#line 871 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 871 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_clear_error (&_inner_error_);
#line 871 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return 0;
#line 6674 "rygel-media-export-media-cache.c"
		}
	}
#line 871 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	result = _tmp6_;
#line 871 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return result;
#line 6681 "rygel-media-export-media-cache.c"
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	glong string_length;
	glong _tmp2_;
	glong _tmp5_;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_;
	gboolean _tmp12_;
	gboolean _tmp13_ = FALSE;
	glong _tmp14_;
	gboolean _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
#line 1371 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1372 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1372 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1372 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
	string_length = (glong) _tmp1_;
#line 1373 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
	_tmp2_ = start;
#line 1373 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
	if (_tmp2_ < ((glong) 0)) {
#line 6716 "rygel-media-export-media-cache.c"
		glong _tmp3_;
		glong _tmp4_;
#line 1374 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
		_tmp3_ = string_length;
#line 1374 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
		_tmp4_ = start;
#line 1374 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
		start = _tmp3_ + _tmp4_;
#line 6725 "rygel-media-export-media-cache.c"
	}
#line 1376 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
	_tmp5_ = end;
#line 1376 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
	if (_tmp5_ < ((glong) 0)) {
#line 6731 "rygel-media-export-media-cache.c"
		glong _tmp6_;
		glong _tmp7_;
#line 1377 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
		_tmp6_ = string_length;
#line 1377 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
		_tmp7_ = end;
#line 1377 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
		end = _tmp6_ + _tmp7_;
#line 6740 "rygel-media-export-media-cache.c"
	}
#line 1379 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
	_tmp9_ = start;
#line 1379 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
	if (_tmp9_ >= ((glong) 0)) {
#line 6746 "rygel-media-export-media-cache.c"
		glong _tmp10_;
		glong _tmp11_;
#line 1379 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
		_tmp10_ = start;
#line 1379 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
		_tmp11_ = string_length;
#line 1379 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
		_tmp8_ = _tmp10_ <= _tmp11_;
#line 6755 "rygel-media-export-media-cache.c"
	} else {
#line 1379 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
		_tmp8_ = FALSE;
#line 6759 "rygel-media-export-media-cache.c"
	}
#line 1379 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
	_tmp12_ = _tmp8_;
#line 1379 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp12_, NULL);
#line 1380 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
	_tmp14_ = end;
#line 1380 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
	if (_tmp14_ >= ((glong) 0)) {
#line 6769 "rygel-media-export-media-cache.c"
		glong _tmp15_;
		glong _tmp16_;
#line 1380 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
		_tmp15_ = end;
#line 1380 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
		_tmp16_ = string_length;
#line 1380 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
		_tmp13_ = _tmp15_ <= _tmp16_;
#line 6778 "rygel-media-export-media-cache.c"
	} else {
#line 1380 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
		_tmp13_ = FALSE;
#line 6782 "rygel-media-export-media-cache.c"
	}
#line 1380 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
	_tmp17_ = _tmp13_;
#line 1380 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp17_, NULL);
#line 1381 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
	_tmp18_ = start;
#line 1381 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
	_tmp19_ = end;
#line 1381 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp18_ <= _tmp19_, NULL);
#line 1382 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
	_tmp20_ = start;
#line 1382 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
	_tmp21_ = end;
#line 1382 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
	_tmp22_ = start;
#line 1382 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
	_tmp23_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) (_tmp21_ - _tmp22_));
#line 1382 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
	result = _tmp23_;
#line 1382 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
	return result;
#line 6806 "rygel-media-export-media-cache.c"
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_;
	gchar _tmp1_;
#line 1159 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, '\0');
#line 1160 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
	_tmp0_ = index;
#line 1160 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
	_tmp1_ = ((gchar*) self)[_tmp0_];
#line 1160 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
	result = _tmp1_;
#line 1160 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
	return result;
#line 6824 "rygel-media-export-media-cache.c"
}


static gchar* rygel_media_export_media_cache_translate_sort_criteria (RygelMediaExportMediaCache* self, const gchar* sort_criteria) {
	gchar* result = NULL;
	gchar* collate = NULL;
	GString* _tmp0_;
	GString* builder;
	const gchar* _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_ = NULL;
	gchar** fields;
	gint fields_length1;
	gint _fields_size_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	GString* _tmp27_;
	const gchar* _tmp28_;
	gchar* _tmp29_;
	GError * _inner_error_ = NULL;
#line 874 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 874 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (sort_criteria != NULL, NULL);
#line 876 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = g_string_new ("ORDER BY ");
#line 876 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	builder = _tmp0_;
#line 877 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp1_ = sort_criteria;
#line 877 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp3_ = _tmp2_ = g_strsplit (_tmp1_, ",", 0);
#line 877 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	fields = _tmp3_;
#line 877 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	fields_length1 = _vala_array_length (_tmp2_);
#line 877 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_fields_size_ = fields_length1;
#line 878 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp4_ = fields;
#line 878 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp4__length1 = fields_length1;
#line 6867 "rygel-media-export-media-cache.c"
	{
		gchar** field_collection = NULL;
		gint field_collection_length1 = 0;
		gint _field_collection_size_ = 0;
		gint field_it = 0;
#line 878 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		field_collection = _tmp4_;
#line 878 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		field_collection_length1 = _tmp4__length1;
#line 878 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		for (field_it = 0; field_it < _tmp4__length1; field_it = field_it + 1) {
#line 6879 "rygel-media-export-media-cache.c"
			gchar* _tmp5_;
			gchar* field = NULL;
#line 878 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp5_ = g_strdup (field_collection[field_it]);
#line 878 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			field = _tmp5_;
#line 6886 "rygel-media-export-media-cache.c"
			{
				{
					const gchar* _tmp6_;
					const gchar* _tmp7_;
					gint _tmp8_;
					gint _tmp9_;
					gchar* _tmp10_ = NULL;
					gchar* _tmp11_;
					gchar* _tmp12_ = NULL;
					gchar* _tmp13_ = NULL;
					gchar* _tmp14_;
					gchar* column;
					const gchar* _tmp15_;
					gchar** _tmp16_;
					gint _tmp16__length1;
					const gchar* _tmp17_;
					const gchar* _tmp19_ = NULL;
					const gchar* _tmp20_;
					gchar _tmp21_ = '\0';
					GString* _tmp22_;
					const gchar* _tmp23_;
					const gchar* _tmp24_;
					const gchar* _tmp25_;
#line 880 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp6_ = field;
#line 880 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp7_ = field;
#line 880 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp8_ = strlen (_tmp7_);
#line 880 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp9_ = _tmp8_;
#line 880 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp10_ = string_slice (_tmp6_, (glong) 1, (glong) _tmp9_);
#line 880 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp11_ = _tmp10_;
#line 880 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp13_ = rygel_media_export_media_cache_map_operand_to_column (self, _tmp11_, &_tmp12_, &_inner_error_);
#line 880 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_g_free0 (collate);
#line 880 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					collate = _tmp12_;
#line 880 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp14_ = _tmp13_;
#line 880 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_g_free0 (_tmp11_);
#line 880 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					column = _tmp14_;
#line 880 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					if (_inner_error_ != NULL) {
#line 6936 "rygel-media-export-media-cache.c"
						goto __catch11_g_error;
					}
#line 882 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp15_ = field;
#line 882 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp16_ = fields;
#line 882 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp16__length1 = fields_length1;
#line 882 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp17_ = _tmp16_[0];
#line 882 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					if (g_strcmp0 (_tmp15_, _tmp17_) != 0) {
#line 6949 "rygel-media-export-media-cache.c"
						GString* _tmp18_;
#line 883 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
						_tmp18_ = builder;
#line 883 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
						g_string_append (_tmp18_, ",");
#line 6955 "rygel-media-export-media-cache.c"
					}
#line 888 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp20_ = field;
#line 888 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp21_ = string_get (_tmp20_, (glong) 0);
#line 888 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					if (_tmp21_ == '-') {
#line 888 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
						_tmp19_ = "DESC";
#line 6965 "rygel-media-export-media-cache.c"
					} else {
#line 888 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
						_tmp19_ = "ASC";
#line 6969 "rygel-media-export-media-cache.c"
					}
#line 885 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp22_ = builder;
#line 885 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp23_ = column;
#line 885 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp24_ = collate;
#line 885 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp25_ = _tmp19_;
#line 885 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					g_string_append_printf (_tmp22_, "%s %s %s ", _tmp23_, _tmp24_, _tmp25_);
#line 879 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_g_free0 (column);
#line 6983 "rygel-media-export-media-cache.c"
				}
				goto __finally11;
				__catch11_g_error:
				{
					GError* _error_ = NULL;
					const gchar* _tmp26_;
#line 879 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_error_ = _inner_error_;
#line 879 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_inner_error_ = NULL;
#line 890 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp26_ = field;
#line 890 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					g_warning ("rygel-media-export-media-cache.vala:890: Skipping nsupported field: %s", _tmp26_);
#line 879 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_g_error_free0 (_error_);
#line 7000 "rygel-media-export-media-cache.c"
				}
				__finally11:
#line 879 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				if (_inner_error_ != NULL) {
#line 879 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_g_free0 (field);
#line 879 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					fields = (_vala_array_free (fields, fields_length1, (GDestroyNotify) g_free), NULL);
#line 879 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_g_string_free0 (builder);
#line 879 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_g_free0 (collate);
#line 879 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 879 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					g_clear_error (&_inner_error_);
#line 879 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					return NULL;
#line 7019 "rygel-media-export-media-cache.c"
				}
#line 878 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_free0 (field);
#line 7023 "rygel-media-export-media-cache.c"
			}
		}
	}
#line 894 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp27_ = builder;
#line 894 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp28_ = _tmp27_->str;
#line 894 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp29_ = g_strdup (_tmp28_);
#line 894 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	result = _tmp29_;
#line 894 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	fields = (_vala_array_free (fields, fields_length1, (GDestroyNotify) g_free), NULL);
#line 894 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_string_free0 (builder);
#line 894 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_free0 (collate);
#line 894 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return result;
#line 7043 "rygel-media-export-media-cache.c"
}


static void rygel_media_export_media_cache_class_init (RygelMediaExportMediaCacheClass * klass) {
#line 50 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	rygel_media_export_media_cache_parent_class = g_type_class_peek_parent (klass);
#line 50 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_type_class_add_private (klass, sizeof (RygelMediaExportMediaCachePrivate));
#line 50 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_media_export_media_cache_finalize;
#line 7054 "rygel-media-export-media-cache.c"
}


static void rygel_media_export_media_cache_instance_init (RygelMediaExportMediaCache * self) {
#line 50 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	self->priv = RYGEL_MEDIA_EXPORT_MEDIA_CACHE_GET_PRIVATE (self);
#line 7061 "rygel-media-export-media-cache.c"
}


static void rygel_media_export_media_cache_finalize (GObject* obj) {
	RygelMediaExportMediaCache * self;
#line 50 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	self = RYGEL_MEDIA_EXPORT_MEDIA_CACHE (obj);
#line 52 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_object_unref0 (self->priv->db);
#line 53 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_object_unref0 (self->priv->factory);
#line 54 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_object_unref0 (self->priv->sql);
#line 55 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_object_unref0 (self->priv->exists_cache);
#line 50 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	G_OBJECT_CLASS (rygel_media_export_media_cache_parent_class)->finalize (obj);
#line 7079 "rygel-media-export-media-cache.c"
}


/**
 * Persistent storage of media objects
 *
 *  MediaExportDB is a sqlite3 backed persistent storage of media objects
 */
GType rygel_media_export_media_cache_get_type (void) {
	static volatile gsize rygel_media_export_media_cache_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_export_media_cache_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaExportMediaCacheClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_export_media_cache_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaExportMediaCache), 0, (GInstanceInitFunc) rygel_media_export_media_cache_instance_init, NULL };
		GType rygel_media_export_media_cache_type_id;
		rygel_media_export_media_cache_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMediaExportMediaCache", &g_define_type_info, 0);
		g_once_init_leave (&rygel_media_export_media_cache_type_id__volatile, rygel_media_export_media_cache_type_id);
	}
	return rygel_media_export_media_cache_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



