/* rygel-media-export-metadata-extractor.c generated by valac 0.16.1, the Vala compiler
 * generated from rygel-media-export-metadata-extractor.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 * Copyright (C) 2009 Jens Georg <mail@jensge.org>.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 * Author: Jens Georg <mail@jensge.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libgupnp-dlna/gupnp-dlna-discoverer.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <rygel-core.h>
#include <gst/gst.h>
#include <libgupnp-dlna/gupnp-dlna-information.h>
#include <gst/pbutils/pbutils.h>
#include <glib/gi18n-lib.h>


#define RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR (rygel_media_export_metadata_extractor_get_type ())
#define RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR, RygelMediaExportMetadataExtractor))
#define RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR, RygelMediaExportMetadataExtractorClass))
#define RYGEL_MEDIA_EXPORT_IS_METADATA_EXTRACTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR))
#define RYGEL_MEDIA_EXPORT_IS_METADATA_EXTRACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR))
#define RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR, RygelMediaExportMetadataExtractorClass))

typedef struct _RygelMediaExportMetadataExtractor RygelMediaExportMetadataExtractor;
typedef struct _RygelMediaExportMetadataExtractorClass RygelMediaExportMetadataExtractorClass;
typedef struct _RygelMediaExportMetadataExtractorPrivate RygelMediaExportMetadataExtractorPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _RygelMediaExportMetadataExtractor {
	GObject parent_instance;
	RygelMediaExportMetadataExtractorPrivate * priv;
};

struct _RygelMediaExportMetadataExtractorClass {
	GObjectClass parent_class;
};

struct _RygelMediaExportMetadataExtractorPrivate {
	GUPnPDLNADiscoverer* discoverer;
	GeeHashMap* file_hash;
	guint64 timeout;
	gboolean extract_metadata;
};


static gpointer rygel_media_export_metadata_extractor_parent_class = NULL;

GType rygel_media_export_metadata_extractor_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR, RygelMediaExportMetadataExtractorPrivate))
enum  {
	RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_DUMMY_PROPERTY
};
RygelMediaExportMetadataExtractor* rygel_media_export_metadata_extractor_new (void);
RygelMediaExportMetadataExtractor* rygel_media_export_metadata_extractor_construct (GType object_type);
void rygel_media_export_metadata_extractor_extract (RygelMediaExportMetadataExtractor* self, GFile* file);
static void rygel_media_export_metadata_extractor_on_done (RygelMediaExportMetadataExtractor* self, GUPnPDLNAInformation* dlna, GError* err);
static void _rygel_media_export_metadata_extractor_on_done_gupnp_dlna_discoverer_done (GUPnPDLNADiscoverer* _sender, GUPnPDLNAInformation* dlna, GError* err, gpointer self);
static void rygel_media_export_metadata_extractor_extract_basic_information (RygelMediaExportMetadataExtractor* self, GFile* file, GUPnPDLNAInformation* dlna);
static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT_OBJECT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__OBJECT_POINTER (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void rygel_media_export_metadata_extractor_finalize (GObject* obj);


RygelMediaExportMetadataExtractor* rygel_media_export_metadata_extractor_construct (GType object_type) {
	RygelMediaExportMetadataExtractor * self = NULL;
	GeeHashMap* _tmp0_;
	RygelMetaConfig* _tmp1_ = NULL;
	RygelMetaConfig* config;
	gboolean _tmp4_;
	GError * _inner_error_ = NULL;
#line 57 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
	self = (RygelMediaExportMetadataExtractor*) g_object_new (object_type, NULL);
#line 58 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_FILE, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
#line 58 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
	_g_object_unref0 (self->priv->file_hash);
#line 58 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
	self->priv->file_hash = _tmp0_;
#line 60 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
	_tmp1_ = rygel_meta_config_get_default ();
#line 60 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
	config = _tmp1_;
#line 111 "rygel-media-export-metadata-extractor.c"
	{
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_;
#line 62 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
		_tmp2_ = rygel_configuration_get_bool ((RygelConfiguration*) config, "MediaExport", "extract-metadata", &_inner_error_);
#line 62 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
		_tmp3_ = _tmp2_;
#line 62 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
		if (_inner_error_ != NULL) {
#line 121 "rygel-media-export-metadata-extractor.c"
			goto __catch22_g_error;
		}
#line 62 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
		self->priv->extract_metadata = _tmp3_;
#line 126 "rygel-media-export-metadata-extractor.c"
	}
	goto __finally22;
	__catch22_g_error:
	{
		GError* _error_ = NULL;
#line 61 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
		_error_ = _inner_error_;
#line 61 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
		_inner_error_ = NULL;
#line 65 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
		self->priv->extract_metadata = TRUE;
#line 61 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
		_g_error_free0 (_error_);
#line 140 "rygel-media-export-metadata-extractor.c"
	}
	__finally22:
#line 61 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
	if (_inner_error_ != NULL) {
#line 61 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
		_g_object_unref0 (config);
#line 61 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 61 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
		g_clear_error (&_inner_error_);
#line 61 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
		return NULL;
#line 153 "rygel-media-export-metadata-extractor.c"
	}
#line 69 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
	_tmp4_ = self->priv->extract_metadata;
#line 69 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
	if (_tmp4_) {
#line 159 "rygel-media-export-metadata-extractor.c"
	}
#line 57 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
	_g_object_unref0 (config);
#line 57 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
	return self;
#line 165 "rygel-media-export-metadata-extractor.c"
}


RygelMediaExportMetadataExtractor* rygel_media_export_metadata_extractor_new (void) {
#line 57 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
	return rygel_media_export_metadata_extractor_construct (RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR);
#line 172 "rygel-media-export-metadata-extractor.c"
}


static void _rygel_media_export_metadata_extractor_on_done_gupnp_dlna_discoverer_done (GUPnPDLNADiscoverer* _sender, GUPnPDLNAInformation* dlna, GError* err, gpointer self) {
#line 82 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
	rygel_media_export_metadata_extractor_on_done (self, dlna, err);
#line 179 "rygel-media-export-metadata-extractor.c"
}


void rygel_media_export_metadata_extractor_extract (RygelMediaExportMetadataExtractor* self, GFile* file) {
	gboolean _tmp0_;
#line 74 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
	g_return_if_fail (self != NULL);
#line 74 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
	g_return_if_fail (file != NULL);
#line 75 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
	_tmp0_ = self->priv->extract_metadata;
#line 75 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
	if (_tmp0_) {
#line 193 "rygel-media-export-metadata-extractor.c"
		GFile* _tmp1_;
		gchar* _tmp2_ = NULL;
		gchar* uri;
		GeeHashMap* _tmp3_;
		const gchar* _tmp4_;
		GFile* _tmp5_;
		guint64 _tmp6_;
		GstClockTime gst_timeout;
		GstClockTime _tmp7_;
		GUPnPDLNADiscoverer* _tmp8_;
		GUPnPDLNADiscoverer* _tmp9_;
		GUPnPDLNADiscoverer* _tmp10_;
		GUPnPDLNADiscoverer* _tmp11_;
		const gchar* _tmp12_;
#line 76 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
		_tmp1_ = file;
#line 76 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
		_tmp2_ = g_file_get_uri (_tmp1_);
#line 76 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
		uri = _tmp2_;
#line 77 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
		_tmp3_ = self->priv->file_hash;
#line 77 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
		_tmp4_ = uri;
#line 77 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
		_tmp5_ = file;
#line 77 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
		gee_abstract_map_set ((GeeAbstractMap*) _tmp3_, _tmp4_, _tmp5_);
#line 78 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
		_tmp6_ = self->priv->timeout;
#line 78 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
		gst_timeout = (GstClockTime) (_tmp6_ * GST_SECOND);
#line 79 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
		_tmp7_ = gst_timeout;
#line 79 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
		_tmp8_ = gupnp_dlna_discoverer_new (_tmp7_, TRUE, TRUE);
#line 79 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
		_g_object_unref0 (self->priv->discoverer);
#line 79 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
		self->priv->discoverer = _tmp8_;
#line 82 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
		_tmp9_ = self->priv->discoverer;
#line 82 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
		g_signal_connect_object (_tmp9_, "done", (GCallback) _rygel_media_export_metadata_extractor_on_done_gupnp_dlna_discoverer_done, self, 0);
#line 83 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
		_tmp10_ = self->priv->discoverer;
#line 83 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
		gst_discoverer_start ((GstDiscoverer*) _tmp10_);
#line 84 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
		_tmp11_ = self->priv->discoverer;
#line 84 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
		_tmp12_ = uri;
#line 84 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
		gupnp_dlna_discoverer_discover_uri (_tmp11_, _tmp12_);
#line 75 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
		_g_free0 (uri);
#line 250 "rygel-media-export-metadata-extractor.c"
	} else {
		GFile* _tmp13_;
#line 86 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
		_tmp13_ = file;
#line 86 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
		rygel_media_export_metadata_extractor_extract_basic_information (self, _tmp13_, NULL);
#line 257 "rygel-media-export-metadata-extractor.c"
	}
}


static void rygel_media_export_metadata_extractor_on_done (RygelMediaExportMetadataExtractor* self, GUPnPDLNAInformation* dlna, GError* err) {
	GUPnPDLNADiscoverer* _tmp0_;
	guint _tmp1_ = 0U;
	GeeHashMap* _tmp2_;
	GUPnPDLNAInformation* _tmp3_;
	GstDiscovererInfo* _tmp4_;
	GstDiscovererInfo* _tmp5_;
	const gchar* _tmp6_ = NULL;
	gpointer _tmp7_ = NULL;
	GFile* file;
	GFile* _tmp8_;
	GeeHashMap* _tmp13_;
	GUPnPDLNAInformation* _tmp14_;
	GstDiscovererInfo* _tmp15_;
	GstDiscovererInfo* _tmp16_;
	const gchar* _tmp17_ = NULL;
	GUPnPDLNAInformation* _tmp18_;
	GstDiscovererInfo* _tmp19_;
	GstDiscovererInfo* _tmp20_;
	GstDiscovererResult _tmp21_ = 0;
	GFile* _tmp31_;
	GUPnPDLNAInformation* _tmp32_;
#line 90 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
	g_return_if_fail (self != NULL);
#line 90 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
	g_return_if_fail (dlna != NULL);
#line 92 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
	_tmp0_ = self->priv->discoverer;
#line 92 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
	g_signal_parse_name ("done", GUPNP_TYPE_DLNA_DISCOVERER, &_tmp1_, NULL, FALSE);
#line 92 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _rygel_media_export_metadata_extractor_on_done_gupnp_dlna_discoverer_done, self);
#line 93 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
	_g_object_unref0 (self->priv->discoverer);
#line 93 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
	self->priv->discoverer = NULL;
#line 94 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
	_tmp2_ = self->priv->file_hash;
#line 94 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
	_tmp3_ = dlna;
#line 94 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
	_tmp4_ = gupnp_dlna_information_get_info (_tmp3_);
#line 94 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
	_tmp5_ = _tmp4_;
#line 94 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
	_tmp6_ = gst_discoverer_info_get_uri (_tmp5_);
#line 94 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
	_tmp7_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp2_, _tmp6_);
#line 94 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
	file = (GFile*) _tmp7_;
#line 95 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
	_tmp8_ = file;
#line 95 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
	if (_tmp8_ == NULL) {
#line 316 "rygel-media-export-metadata-extractor.c"
		GUPnPDLNAInformation* _tmp9_;
		GstDiscovererInfo* _tmp10_;
		GstDiscovererInfo* _tmp11_;
		const gchar* _tmp12_ = NULL;
#line 96 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
		_tmp9_ = dlna;
#line 96 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
		_tmp10_ = gupnp_dlna_information_get_info (_tmp9_);
#line 96 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
		_tmp11_ = _tmp10_;
#line 96 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
		_tmp12_ = gst_discoverer_info_get_uri (_tmp11_);
#line 96 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
		g_warning ("rygel-media-export-metadata-extractor.vala:96: File %s already handled" \
", ignoring event", _tmp12_);
#line 99 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
		_g_object_unref0 (file);
#line 99 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
		return;
#line 335 "rygel-media-export-metadata-extractor.c"
	}
#line 102 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
	_tmp13_ = self->priv->file_hash;
#line 102 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
	_tmp14_ = dlna;
#line 102 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
	_tmp15_ = gupnp_dlna_information_get_info (_tmp14_);
#line 102 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
	_tmp16_ = _tmp15_;
#line 102 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
	_tmp17_ = gst_discoverer_info_get_uri (_tmp16_);
#line 102 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
	gee_abstract_map_unset ((GeeAbstractMap*) _tmp13_, _tmp17_, NULL);
#line 104 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
	_tmp18_ = dlna;
#line 104 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
	_tmp19_ = gupnp_dlna_information_get_info (_tmp18_);
#line 104 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
	_tmp20_ = _tmp19_;
#line 104 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
	_tmp21_ = gst_discoverer_info_get_result (_tmp20_);
#line 104 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
	if ((_tmp21_ & GST_DISCOVERER_TIMEOUT) != 0) {
#line 359 "rygel-media-export-metadata-extractor.c"
		GFile* _tmp22_;
		gchar* _tmp23_ = NULL;
		gchar* _tmp24_;
#line 105 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
		_tmp22_ = file;
#line 105 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
		_tmp23_ = g_file_get_uri (_tmp22_);
#line 105 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
		_tmp24_ = _tmp23_;
#line 105 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
		g_debug ("rygel-media-export-metadata-extractor.vala:105: Extraction timed out o" \
"n %s", _tmp24_);
#line 105 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
		_g_free0 (_tmp24_);
#line 108 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
		dlna = NULL;
#line 375 "rygel-media-export-metadata-extractor.c"
	} else {
		GUPnPDLNAInformation* _tmp25_;
		GstDiscovererInfo* _tmp26_;
		GstDiscovererInfo* _tmp27_;
		GstDiscovererResult _tmp28_ = 0;
#line 109 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
		_tmp25_ = dlna;
#line 109 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
		_tmp26_ = gupnp_dlna_information_get_info (_tmp25_);
#line 109 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
		_tmp27_ = _tmp26_;
#line 109 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
		_tmp28_ = gst_discoverer_info_get_result (_tmp27_);
#line 109 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
		if ((_tmp28_ & GST_DISCOVERER_ERROR) != 0) {
#line 391 "rygel-media-export-metadata-extractor.c"
			GFile* _tmp29_;
			GError* _tmp30_;
#line 111 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
			_tmp29_ = file;
#line 111 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
			_tmp30_ = err;
#line 111 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
			g_signal_emit_by_name (self, "error", _tmp29_, _tmp30_);
#line 113 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
			_g_object_unref0 (file);
#line 113 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
			return;
#line 404 "rygel-media-export-metadata-extractor.c"
		}
	}
#line 116 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
	_tmp31_ = file;
#line 116 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
	_tmp32_ = dlna;
#line 116 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
	rygel_media_export_metadata_extractor_extract_basic_information (self, _tmp31_, _tmp32_);
#line 90 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
	_g_object_unref0 (file);
#line 415 "rygel-media-export-metadata-extractor.c"
}


static gpointer _g_error_copy0 (gpointer self) {
#line 140 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
	return self ? g_error_copy (self) : NULL;
#line 422 "rygel-media-export-metadata-extractor.c"
}


static void rygel_media_export_metadata_extractor_extract_basic_information (RygelMediaExportMetadataExtractor* self, GFile* file, GUPnPDLNAInformation* dlna) {
	GError * _inner_error_ = NULL;
#line 119 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
	g_return_if_fail (self != NULL);
#line 119 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
	g_return_if_fail (file != NULL);
#line 432 "rygel-media-export-metadata-extractor.c"
	{
		GFileInfo* file_info = NULL;
		GFile* _tmp11_;
		GUPnPDLNAInformation* _tmp12_;
		{
			GFile* _tmp0_;
			GFileInfo* _tmp1_ = NULL;
			GFileInfo* _tmp2_;
#line 125 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
			_tmp0_ = file;
#line 125 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
			_tmp1_ = g_file_query_info (_tmp0_, G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE "," G_FILE_ATTRIBUTE_STANDARD_SIZE "," G_FILE_ATTRIBUTE_TIME_MODIFIED "," G_FILE_ATTRIBUTE_STANDARD_DISPLAY_NAME, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
#line 125 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
			_tmp2_ = _tmp1_;
#line 125 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
			if (_inner_error_ != NULL) {
#line 449 "rygel-media-export-metadata-extractor.c"
				goto __catch24_g_error;
			}
#line 125 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
			_g_object_unref0 (file_info);
#line 125 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
			file_info = _tmp2_;
#line 456 "rygel-media-export-metadata-extractor.c"
		}
		goto __finally24;
		__catch24_g_error:
		{
			GError* _error_ = NULL;
			const gchar* _tmp3_ = NULL;
			GFile* _tmp4_;
			gchar* _tmp5_ = NULL;
			gchar* _tmp6_;
			GFile* _tmp7_;
			GError* _tmp8_;
			GError* _tmp9_;
			GError* _tmp10_;
#line 124 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
			_error_ = _inner_error_;
#line 124 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
			_inner_error_ = NULL;
#line 134 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
			_tmp3_ = _ ("Failed to query content type for '%s'");
#line 134 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
			_tmp4_ = file;
#line 134 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
			_tmp5_ = g_file_get_uri (_tmp4_);
#line 134 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
			_tmp6_ = _tmp5_;
#line 134 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
			g_warning (_tmp3_, _tmp6_);
#line 134 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
			_g_free0 (_tmp6_);
#line 138 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
			_tmp7_ = file;
#line 138 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
			_tmp8_ = _error_;
#line 138 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
			g_signal_emit_by_name (self, "error", _tmp7_, _tmp8_);
#line 140 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
			_tmp9_ = _error_;
#line 140 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
			_tmp10_ = _g_error_copy0 (_tmp9_);
#line 140 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
			_inner_error_ = _tmp10_;
#line 140 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
			_g_error_free0 (_error_);
#line 500 "rygel-media-export-metadata-extractor.c"
			goto __finally24;
		}
		__finally24:
#line 124 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
		if (_inner_error_ != NULL) {
#line 124 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
			_g_object_unref0 (file_info);
#line 508 "rygel-media-export-metadata-extractor.c"
			goto __catch23_g_error;
		}
#line 143 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
		_tmp11_ = file;
#line 143 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
		_tmp12_ = dlna;
#line 143 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
		g_signal_emit_by_name (self, "extraction-done", _tmp11_, _tmp12_, file_info);
#line 121 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
		_g_object_unref0 (file_info);
#line 519 "rygel-media-export-metadata-extractor.c"
	}
	goto __finally23;
	__catch23_g_error:
	{
		GError* _error_ = NULL;
		GFile* _tmp13_;
		gchar* _tmp14_ = NULL;
		gchar* _tmp15_;
		GError* _tmp16_;
		const gchar* _tmp17_;
		GFile* _tmp18_;
		GError* _tmp19_;
#line 121 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
		_error_ = _inner_error_;
#line 121 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
		_inner_error_ = NULL;
#line 147 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
		_tmp13_ = file;
#line 147 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
		_tmp14_ = g_file_get_uri (_tmp13_);
#line 147 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
		_tmp15_ = _tmp14_;
#line 147 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
		_tmp16_ = _error_;
#line 147 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
		_tmp17_ = _tmp16_->message;
#line 147 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
		g_debug ("rygel-media-export-metadata-extractor.vala:147: Failed to extract basi" \
"c metadata from %s: %s", _tmp15_, _tmp17_);
#line 147 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
		_g_free0 (_tmp15_);
#line 150 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
		_tmp18_ = file;
#line 150 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
		_tmp19_ = _error_;
#line 150 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
		g_signal_emit_by_name (self, "error", _tmp18_, _tmp19_);
#line 121 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
		_g_error_free0 (_error_);
#line 558 "rygel-media-export-metadata-extractor.c"
	}
	__finally23:
#line 121 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
	if (_inner_error_ != NULL) {
#line 121 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 121 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
		g_clear_error (&_inner_error_);
#line 121 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
		return;
#line 569 "rygel-media-export-metadata-extractor.c"
	}
}


static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT_OBJECT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__OBJECT_OBJECT_OBJECT) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer arg_3, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_OBJECT_OBJECT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 35 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
	g_return_if_fail (n_param_values == 4);
#line 35 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 35 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
		data1 = closure->data;
#line 35 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
		data2 = param_values->data[0].v_pointer;
#line 589 "rygel-media-export-metadata-extractor.c"
	} else {
#line 35 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
		data1 = param_values->data[0].v_pointer;
#line 35 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
		data2 = closure->data;
#line 595 "rygel-media-export-metadata-extractor.c"
	}
#line 35 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
	callback = (GMarshalFunc_VOID__OBJECT_OBJECT_OBJECT) (marshal_data ? marshal_data : cc->callback);
#line 35 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
	callback (data1, g_value_get_object (param_values + 1), g_value_get_object (param_values + 2), g_value_get_object (param_values + 3), data2);
#line 601 "rygel-media-export-metadata-extractor.c"
}


static void g_cclosure_user_marshal_VOID__OBJECT_POINTER (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__OBJECT_POINTER) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_POINTER callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 35 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
	g_return_if_fail (n_param_values == 3);
#line 35 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 35 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
		data1 = closure->data;
#line 35 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
		data2 = param_values->data[0].v_pointer;
#line 620 "rygel-media-export-metadata-extractor.c"
	} else {
#line 35 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
		data1 = param_values->data[0].v_pointer;
#line 35 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
		data2 = closure->data;
#line 626 "rygel-media-export-metadata-extractor.c"
	}
#line 35 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
	callback = (GMarshalFunc_VOID__OBJECT_POINTER) (marshal_data ? marshal_data : cc->callback);
#line 35 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
	callback (data1, g_value_get_object (param_values + 1), g_value_get_pointer (param_values + 2), data2);
#line 632 "rygel-media-export-metadata-extractor.c"
}


static void rygel_media_export_metadata_extractor_class_init (RygelMediaExportMetadataExtractorClass * klass) {
#line 35 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
	rygel_media_export_metadata_extractor_parent_class = g_type_class_peek_parent (klass);
#line 35 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
	g_type_class_add_private (klass, sizeof (RygelMediaExportMetadataExtractorPrivate));
#line 35 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_media_export_metadata_extractor_finalize;
#line 35 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
	g_signal_new ("extraction_done", RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT_OBJECT, G_TYPE_NONE, 3, G_TYPE_FILE, GUPNP_TYPE_DLNA_INFORMATION, g_file_info_get_type ());
#line 645 "rygel-media-export-metadata-extractor.c"
	/**
	     * Signalize that an error occured during metadata extraction
	     */
#line 35 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
	g_signal_new ("error", RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_POINTER, G_TYPE_NONE, 2, G_TYPE_FILE, G_TYPE_POINTER);
#line 651 "rygel-media-export-metadata-extractor.c"
}


static void rygel_media_export_metadata_extractor_instance_init (RygelMediaExportMetadataExtractor * self) {
#line 35 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
	self->priv = RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_GET_PRIVATE (self);
#line 53 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
	self->priv->timeout = (guint64) 10;
#line 660 "rygel-media-export-metadata-extractor.c"
}


static void rygel_media_export_metadata_extractor_finalize (GObject* obj) {
	RygelMediaExportMetadataExtractor * self;
#line 35 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
	self = RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR (obj);
#line 46 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
	_g_object_unref0 (self->priv->discoverer);
#line 52 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
	_g_object_unref0 (self->priv->file_hash);
#line 35 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-metadata-extractor.vala"
	G_OBJECT_CLASS (rygel_media_export_metadata_extractor_parent_class)->finalize (obj);
#line 674 "rygel-media-export-metadata-extractor.c"
}


/**
 * Metadata extractor based on Gstreamer. Just set the URI of the media on the
 * uri property, it will extact the metadata for you and emit signal
 * metadata_available for each key/value pair extracted.
 */
GType rygel_media_export_metadata_extractor_get_type (void) {
	static volatile gsize rygel_media_export_metadata_extractor_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_export_metadata_extractor_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaExportMetadataExtractorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_export_metadata_extractor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaExportMetadataExtractor), 0, (GInstanceInitFunc) rygel_media_export_metadata_extractor_instance_init, NULL };
		GType rygel_media_export_metadata_extractor_type_id;
		rygel_media_export_metadata_extractor_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMediaExportMetadataExtractor", &g_define_type_info, 0);
		g_once_init_leave (&rygel_media_export_metadata_extractor_type_id__volatile, rygel_media_export_metadata_extractor_type_id);
	}
	return rygel_media_export_metadata_extractor_type_id__volatile;
}



