/* rygel-media-export-query-container-factory.c generated by valac 0.16.1, the Vala compiler
 * generated from rygel-media-export-query-container-factory.vala, do not modify */

/*
 * Copyright (C) 2011 Jens Georg <mail@jensge.org>.
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <rygel-server.h>
#include <libgupnp-av/gupnp-av.h>


#define RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER_FACTORY (rygel_media_export_query_container_factory_get_type ())
#define RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER_FACTORY, RygelMediaExportQueryContainerFactory))
#define RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER_FACTORY, RygelMediaExportQueryContainerFactoryClass))
#define RYGEL_MEDIA_EXPORT_IS_QUERY_CONTAINER_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER_FACTORY))
#define RYGEL_MEDIA_EXPORT_IS_QUERY_CONTAINER_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER_FACTORY))
#define RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER_FACTORY, RygelMediaExportQueryContainerFactoryClass))

typedef struct _RygelMediaExportQueryContainerFactory RygelMediaExportQueryContainerFactory;
typedef struct _RygelMediaExportQueryContainerFactoryClass RygelMediaExportQueryContainerFactoryClass;
typedef struct _RygelMediaExportQueryContainerFactoryPrivate RygelMediaExportQueryContainerFactoryPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE (rygel_media_export_media_cache_get_type ())
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCache))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCacheClass))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCacheClass))

typedef struct _RygelMediaExportMediaCache RygelMediaExportMediaCache;
typedef struct _RygelMediaExportMediaCacheClass RygelMediaExportMediaCacheClass;

#define RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER (rygel_media_export_db_container_get_type ())
#define RYGEL_MEDIA_EXPORT_DB_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, RygelMediaExportDBContainer))
#define RYGEL_MEDIA_EXPORT_DB_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, RygelMediaExportDBContainerClass))
#define RYGEL_MEDIA_EXPORT_IS_DB_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER))
#define RYGEL_MEDIA_EXPORT_IS_DB_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER))
#define RYGEL_MEDIA_EXPORT_DB_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, RygelMediaExportDBContainerClass))

typedef struct _RygelMediaExportDBContainer RygelMediaExportDBContainer;
typedef struct _RygelMediaExportDBContainerClass RygelMediaExportDBContainerClass;

#define RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER (rygel_media_export_query_container_get_type ())
#define RYGEL_MEDIA_EXPORT_QUERY_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER, RygelMediaExportQueryContainer))
#define RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER, RygelMediaExportQueryContainerClass))
#define RYGEL_MEDIA_EXPORT_IS_QUERY_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER))
#define RYGEL_MEDIA_EXPORT_IS_QUERY_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER))
#define RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER, RygelMediaExportQueryContainerClass))

typedef struct _RygelMediaExportQueryContainer RygelMediaExportQueryContainer;
typedef struct _RygelMediaExportQueryContainerClass RygelMediaExportQueryContainerClass;

#define RYGEL_MEDIA_EXPORT_TYPE_LEAF_QUERY_CONTAINER (rygel_media_export_leaf_query_container_get_type ())
#define RYGEL_MEDIA_EXPORT_LEAF_QUERY_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_LEAF_QUERY_CONTAINER, RygelMediaExportLeafQueryContainer))
#define RYGEL_MEDIA_EXPORT_LEAF_QUERY_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_LEAF_QUERY_CONTAINER, RygelMediaExportLeafQueryContainerClass))
#define RYGEL_MEDIA_EXPORT_IS_LEAF_QUERY_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_LEAF_QUERY_CONTAINER))
#define RYGEL_MEDIA_EXPORT_IS_LEAF_QUERY_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_LEAF_QUERY_CONTAINER))
#define RYGEL_MEDIA_EXPORT_LEAF_QUERY_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_LEAF_QUERY_CONTAINER, RygelMediaExportLeafQueryContainerClass))

typedef struct _RygelMediaExportLeafQueryContainer RygelMediaExportLeafQueryContainer;
typedef struct _RygelMediaExportLeafQueryContainerClass RygelMediaExportLeafQueryContainerClass;

#define RYGEL_MEDIA_EXPORT_TYPE_NODE_QUERY_CONTAINER (rygel_media_export_node_query_container_get_type ())
#define RYGEL_MEDIA_EXPORT_NODE_QUERY_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_NODE_QUERY_CONTAINER, RygelMediaExportNodeQueryContainer))
#define RYGEL_MEDIA_EXPORT_NODE_QUERY_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_NODE_QUERY_CONTAINER, RygelMediaExportNodeQueryContainerClass))
#define RYGEL_MEDIA_EXPORT_IS_NODE_QUERY_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_NODE_QUERY_CONTAINER))
#define RYGEL_MEDIA_EXPORT_IS_NODE_QUERY_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_NODE_QUERY_CONTAINER))
#define RYGEL_MEDIA_EXPORT_NODE_QUERY_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_NODE_QUERY_CONTAINER, RygelMediaExportNodeQueryContainerClass))

typedef struct _RygelMediaExportNodeQueryContainer RygelMediaExportNodeQueryContainer;
typedef struct _RygelMediaExportNodeQueryContainerClass RygelMediaExportNodeQueryContainerClass;
#define _rygel_search_expression_unref0(var) ((var == NULL) ? NULL : (var = (rygel_search_expression_unref (var), NULL)))

struct _RygelMediaExportQueryContainerFactory {
	GObject parent_instance;
	RygelMediaExportQueryContainerFactoryPrivate * priv;
};

struct _RygelMediaExportQueryContainerFactoryClass {
	GObjectClass parent_class;
};

struct _RygelMediaExportQueryContainerFactoryPrivate {
	GeeHashMap* virtual_container_map;
};


static gpointer rygel_media_export_query_container_factory_parent_class = NULL;
static RygelMediaExportQueryContainerFactory* rygel_media_export_query_container_factory_instance;
static RygelMediaExportQueryContainerFactory* rygel_media_export_query_container_factory_instance = NULL;

GType rygel_media_export_query_container_factory_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_FACTORY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER_FACTORY, RygelMediaExportQueryContainerFactoryPrivate))
enum  {
	RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_FACTORY_DUMMY_PROPERTY
};
RygelMediaExportQueryContainerFactory* rygel_media_export_query_container_factory_get_default (void);
static RygelMediaExportQueryContainerFactory* rygel_media_export_query_container_factory_new (void);
static RygelMediaExportQueryContainerFactory* rygel_media_export_query_container_factory_construct (GType object_type);
void rygel_media_export_query_container_factory_register_id (RygelMediaExportQueryContainerFactory* self, gchar** id);
#define RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_PREFIX "virtual-container:"
gchar* rygel_media_export_query_container_factory_get_virtual_container_definition (RygelMediaExportQueryContainerFactory* self, const gchar* hash);
GType rygel_media_export_media_cache_get_type (void) G_GNUC_CONST;
GType rygel_media_export_db_container_get_type (void) G_GNUC_CONST;
GType rygel_media_export_query_container_get_type (void) G_GNUC_CONST;
RygelMediaExportQueryContainer* rygel_media_export_query_container_factory_create_from_id (RygelMediaExportQueryContainerFactory* self, RygelMediaExportMediaCache* cache, const gchar* id, const gchar* name);
RygelMediaExportQueryContainer* rygel_media_export_query_container_factory_create_from_description (RygelMediaExportQueryContainerFactory* self, RygelMediaExportMediaCache* cache, const gchar* definition, const gchar* name);
static RygelSearchExpression* rygel_media_export_query_container_factory_parse_description (RygelMediaExportQueryContainerFactory* self, const gchar* description, gchar** pattern, gchar** attribute, gchar** upnp_class, gchar** name);
RygelMediaExportLeafQueryContainer* rygel_media_export_leaf_query_container_new (RygelMediaExportMediaCache* cache, RygelSearchExpression* expression, const gchar* id, const gchar* name);
RygelMediaExportLeafQueryContainer* rygel_media_export_leaf_query_container_construct (GType object_type, RygelMediaExportMediaCache* cache, RygelSearchExpression* expression, const gchar* id, const gchar* name);
GType rygel_media_export_leaf_query_container_get_type (void) G_GNUC_CONST;
RygelMediaExportNodeQueryContainer* rygel_media_export_node_query_container_new (RygelMediaExportMediaCache* cache, RygelSearchExpression* expression, const gchar* id, const gchar* name, const gchar* template, const gchar* attribute);
RygelMediaExportNodeQueryContainer* rygel_media_export_node_query_container_construct (GType object_type, RygelMediaExportMediaCache* cache, RygelSearchExpression* expression, const gchar* id, const gchar* name, const gchar* template, const gchar* attribute);
GType rygel_media_export_node_query_container_get_type (void) G_GNUC_CONST;
static gchar* rygel_media_export_query_container_factory_map_upnp_class (RygelMediaExportQueryContainerFactory* self, const gchar* attribute);
static void rygel_media_export_query_container_factory_update_search_expression (RygelMediaExportQueryContainerFactory* self, RygelSearchExpression** expression, const gchar* key, const gchar* value);
static void rygel_media_export_query_container_factory_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gpointer _g_object_ref0 (gpointer self) {
#line 36 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	return self ? g_object_ref (self) : NULL;
#line 152 "rygel-media-export-query-container-factory.c"
}


RygelMediaExportQueryContainerFactory* rygel_media_export_query_container_factory_get_default (void) {
	RygelMediaExportQueryContainerFactory* result = NULL;
	RygelMediaExportQueryContainerFactory* _tmp0_;
	gboolean _tmp1_ = FALSE;
	RygelMediaExportQueryContainerFactory* _tmp3_;
	RygelMediaExportQueryContainerFactory* _tmp4_;
#line 32 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_tmp0_ = rygel_media_export_query_container_factory_instance;
#line 32 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_tmp1_ = G_UNLIKELY (_tmp0_ == NULL);
#line 32 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	if (_tmp1_) {
#line 168 "rygel-media-export-query-container-factory.c"
		RygelMediaExportQueryContainerFactory* _tmp2_;
#line 33 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_tmp2_ = rygel_media_export_query_container_factory_new ();
#line 33 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_g_object_unref0 (rygel_media_export_query_container_factory_instance);
#line 33 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		rygel_media_export_query_container_factory_instance = _tmp2_;
#line 176 "rygel-media-export-query-container-factory.c"
	}
#line 36 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_tmp3_ = rygel_media_export_query_container_factory_instance;
#line 36 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 36 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	result = _tmp4_;
#line 36 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	return result;
#line 186 "rygel-media-export-query-container-factory.c"
}


static RygelMediaExportQueryContainerFactory* rygel_media_export_query_container_factory_construct (GType object_type) {
	RygelMediaExportQueryContainerFactory * self = NULL;
	GeeHashMap* _tmp0_;
#line 40 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	self = (RygelMediaExportQueryContainerFactory*) g_object_new (object_type, NULL);
#line 41 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
#line 41 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_g_object_unref0 (self->priv->virtual_container_map);
#line 41 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	self->priv->virtual_container_map = _tmp0_;
#line 40 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	return self;
#line 203 "rygel-media-export-query-container-factory.c"
}


static RygelMediaExportQueryContainerFactory* rygel_media_export_query_container_factory_new (void) {
#line 40 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	return rygel_media_export_query_container_factory_construct (RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER_FACTORY);
#line 210 "rygel-media-export-query-container-factory.c"
}


/**
     * Register a plaintext description for a query container. The passed
     * string will be modified to the checksum id of the container.
     *
     * @param id Originally contains the plaintext id which is replaced with
     *           the hashed id on return.
     */
void rygel_media_export_query_container_factory_register_id (RygelMediaExportQueryContainerFactory* self, gchar** id) {
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* md5;
	GeeHashMap* _tmp2_;
	const gchar* _tmp3_;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp10_;
	gchar* _tmp11_;
#line 53 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	g_return_if_fail (self != NULL);
#line 53 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	g_return_if_fail (*id != NULL);
#line 54 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_tmp0_ = *id;
#line 54 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_tmp1_ = g_compute_checksum_for_string (G_CHECKSUM_MD5, _tmp0_, (gsize) (-1));
#line 54 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	md5 = _tmp1_;
#line 56 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_tmp2_ = self->priv->virtual_container_map;
#line 56 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_tmp3_ = md5;
#line 56 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_tmp4_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp2_, _tmp3_);
#line 56 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	if (!_tmp4_) {
#line 248 "rygel-media-export-query-container-factory.c"
		GeeHashMap* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
#line 57 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_tmp5_ = self->priv->virtual_container_map;
#line 57 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_tmp6_ = md5;
#line 57 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_tmp7_ = *id;
#line 57 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		gee_abstract_map_set ((GeeAbstractMap*) _tmp5_, _tmp6_, _tmp7_);
#line 58 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_tmp8_ = md5;
#line 58 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_tmp9_ = *id;
#line 58 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		g_debug ("rygel-media-export-query-container-factory.vala:58: Registering %s for" \
" %s", _tmp8_, _tmp9_);
#line 268 "rygel-media-export-query-container-factory.c"
	}
#line 61 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_tmp10_ = md5;
#line 61 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_tmp11_ = g_strconcat (RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_PREFIX, _tmp10_, NULL);
#line 61 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_g_free0 (*id);
#line 61 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	*id = _tmp11_;
#line 53 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_g_free0 (md5);
#line 280 "rygel-media-export-query-container-factory.c"
}


/**
     * Get the plaintext definition from a hashed id.
     *
     * Inverse function of register_id().
     *
     * @param hash A hashed id
     * @return the plaintext defintion of the virtual folder
     */
static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
#line 1423 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1423 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1423 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 301 "rygel-media-export-query-container-factory.c"
	{
		const gchar* _tmp0_;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		GRegex* _tmp3_;
		GRegex* _tmp4_;
		GRegex* regex;
		GRegex* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
#line 1425 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
		_tmp0_ = old;
#line 1425 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
#line 1425 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
		_tmp2_ = _tmp1_;
#line 1425 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
#line 1425 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
		_tmp4_ = _tmp3_;
#line 1425 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
		_g_free0 (_tmp2_);
#line 1425 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
		regex = _tmp4_;
#line 1425 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
		if (_inner_error_ != NULL) {
#line 1425 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 331 "rygel-media-export-query-container-factory.c"
				goto __catch40_g_regex_error;
			}
#line 1425 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1425 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1425 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
			return NULL;
#line 340 "rygel-media-export-query-container-factory.c"
		}
#line 1426 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
		_tmp5_ = regex;
#line 1426 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
		_tmp6_ = replacement;
#line 1426 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
		_tmp7_ = g_regex_replace_literal (_tmp5_, self, (gssize) (-1), 0, _tmp6_, 0, &_inner_error_);
#line 1426 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
		_tmp8_ = _tmp7_;
#line 1426 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
		if (_inner_error_ != NULL) {
#line 1426 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1426 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 356 "rygel-media-export-query-container-factory.c"
				goto __catch40_g_regex_error;
			}
#line 1426 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1426 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1426 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1426 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
			return NULL;
#line 367 "rygel-media-export-query-container-factory.c"
		}
#line 1426 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
		result = _tmp8_;
#line 1426 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
		_g_regex_unref0 (regex);
#line 1426 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
		return result;
#line 375 "rygel-media-export-query-container-factory.c"
	}
	goto __finally40;
	__catch40_g_regex_error:
	{
		GError* e = NULL;
#line 1424 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
		e = _inner_error_;
#line 1424 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
		_inner_error_ = NULL;
#line 1428 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
		g_assert_not_reached ();
#line 1424 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
		_g_error_free0 (e);
#line 389 "rygel-media-export-query-container-factory.c"
	}
	__finally40:
#line 1424 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
	if (_inner_error_ != NULL) {
#line 1424 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1424 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
		g_clear_error (&_inner_error_);
#line 1424 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
		return NULL;
#line 400 "rygel-media-export-query-container-factory.c"
	}
}


gchar* rygel_media_export_query_container_factory_get_virtual_container_definition (RygelMediaExportQueryContainerFactory* self, const gchar* hash) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* id;
	GeeHashMap* _tmp2_;
	gpointer _tmp3_ = NULL;
#line 72 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 72 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	g_return_val_if_fail (hash != NULL, NULL);
#line 73 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_tmp0_ = hash;
#line 73 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_tmp1_ = string_replace (_tmp0_, RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_PREFIX, "");
#line 73 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	id = _tmp1_;
#line 75 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_tmp2_ = self->priv->virtual_container_map;
#line 75 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_tmp3_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp2_, id);
#line 75 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	result = (gchar*) _tmp3_;
#line 75 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_g_free0 (id);
#line 75 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	return result;
#line 432 "rygel-media-export-query-container-factory.c"
}


/**
     * Factory method.
     *
     * Create a QueryContainer directly from MD5 hashed id.
     *
     * @param cache An instance of the meta-data cache
     * @param id    The hashed id of the container
     * @param name  An the title of the container. If not supplied, it will
     *              be derived from the plain-text description of the
     *              container
     * @return A new instance of QueryContainer or null if id does not exist
     */
RygelMediaExportQueryContainer* rygel_media_export_query_container_factory_create_from_id (RygelMediaExportQueryContainerFactory* self, RygelMediaExportMediaCache* cache, const gchar* id, const gchar* name) {
	RygelMediaExportQueryContainer* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* definition;
	const gchar* _tmp2_;
	RygelMediaExportMediaCache* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	RygelMediaExportQueryContainer* _tmp6_ = NULL;
#line 90 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 90 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	g_return_val_if_fail (cache != NULL, NULL);
#line 90 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	g_return_val_if_fail (id != NULL, NULL);
#line 90 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 93 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_tmp0_ = id;
#line 93 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_tmp1_ = rygel_media_export_query_container_factory_get_virtual_container_definition (self, _tmp0_);
#line 93 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	definition = _tmp1_;
#line 94 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_tmp2_ = definition;
#line 94 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	if (_tmp2_ == NULL) {
#line 95 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		result = NULL;
#line 95 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_g_free0 (definition);
#line 95 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		return result;
#line 482 "rygel-media-export-query-container-factory.c"
	}
#line 98 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_tmp3_ = cache;
#line 98 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_tmp4_ = definition;
#line 98 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_tmp5_ = name;
#line 98 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_tmp6_ = rygel_media_export_query_container_factory_create_from_description (self, _tmp3_, _tmp4_, _tmp5_);
#line 98 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	result = _tmp6_;
#line 98 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_g_free0 (definition);
#line 98 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	return result;
#line 498 "rygel-media-export-query-container-factory.c"
}


/**
     * Factory method.
     *
     * Create a QueryContainer from a plain-text description string.
     *
     * @param cache      An instance of the meta-data cache
     * @param definition Plain-text defintion of the query-container
     * @param name       The title of the container. If not supplied, it
     *                   will be derived from the plain-text description of
     *                   the container
     * @return A new instance of QueryContainer
     */
RygelMediaExportQueryContainer* rygel_media_export_query_container_factory_create_from_description (RygelMediaExportQueryContainerFactory* self, RygelMediaExportMediaCache* cache, const gchar* definition, const gchar* name) {
	RygelMediaExportQueryContainer* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* title;
	gchar* attribute;
	gchar* pattern;
	gchar* upnp_class;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* id;
	RygelMediaExportQueryContainer* container = NULL;
	const gchar* _tmp4_;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	RygelSearchExpression* _tmp8_ = NULL;
	RygelSearchExpression* expression;
	gboolean _tmp9_ = FALSE;
	const gchar* _tmp10_;
	gboolean _tmp12_;
	const gchar* _tmp25_;
#line 113 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 113 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	g_return_val_if_fail (cache != NULL, NULL);
#line 113 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	g_return_val_if_fail (definition != NULL, NULL);
#line 113 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 116 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_tmp0_ = name;
#line 116 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 116 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	title = _tmp1_;
#line 117 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	attribute = NULL;
#line 118 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	pattern = NULL;
#line 119 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	upnp_class = NULL;
#line 120 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_tmp2_ = definition;
#line 120 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 120 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	id = _tmp3_;
#line 123 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	rygel_media_export_query_container_factory_register_id (self, &id);
#line 125 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_tmp4_ = definition;
#line 125 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_tmp8_ = rygel_media_export_query_container_factory_parse_description (self, _tmp4_, &_tmp5_, &_tmp6_, &_tmp7_, &title);
#line 125 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_g_free0 (pattern);
#line 125 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	pattern = _tmp5_;
#line 125 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_g_free0 (attribute);
#line 125 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	attribute = _tmp6_;
#line 125 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_g_free0 (upnp_class);
#line 125 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	upnp_class = _tmp7_;
#line 125 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	expression = _tmp8_;
#line 131 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_tmp10_ = pattern;
#line 131 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	if (_tmp10_ == NULL) {
#line 131 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_tmp9_ = TRUE;
#line 588 "rygel-media-export-query-container-factory.c"
	} else {
		const gchar* _tmp11_;
#line 131 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_tmp11_ = pattern;
#line 131 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_tmp9_ = g_strcmp0 (_tmp11_, "") == 0;
#line 595 "rygel-media-export-query-container-factory.c"
	}
#line 131 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_tmp12_ = _tmp9_;
#line 131 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	if (_tmp12_) {
#line 601 "rygel-media-export-query-container-factory.c"
		RygelMediaExportMediaCache* _tmp13_;
		RygelSearchExpression* _tmp14_;
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		RygelMediaExportLeafQueryContainer* _tmp17_;
#line 132 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_tmp13_ = cache;
#line 132 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_tmp14_ = expression;
#line 132 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_tmp15_ = id;
#line 132 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_tmp16_ = title;
#line 132 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_tmp17_ = rygel_media_export_leaf_query_container_new (_tmp13_, _tmp14_, _tmp15_, _tmp16_);
#line 132 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_g_object_unref0 (container);
#line 132 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		container = (RygelMediaExportQueryContainer*) _tmp17_;
#line 621 "rygel-media-export-query-container-factory.c"
	} else {
		RygelMediaExportMediaCache* _tmp18_;
		RygelSearchExpression* _tmp19_;
		const gchar* _tmp20_;
		const gchar* _tmp21_;
		const gchar* _tmp22_;
		const gchar* _tmp23_;
		RygelMediaExportNodeQueryContainer* _tmp24_;
#line 137 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_tmp18_ = cache;
#line 137 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_tmp19_ = expression;
#line 137 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_tmp20_ = id;
#line 137 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_tmp21_ = title;
#line 137 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_tmp22_ = pattern;
#line 137 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_tmp23_ = attribute;
#line 137 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_tmp24_ = rygel_media_export_node_query_container_new (_tmp18_, _tmp19_, _tmp20_, _tmp21_, _tmp22_, _tmp23_);
#line 137 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_g_object_unref0 (container);
#line 137 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		container = (RygelMediaExportQueryContainer*) _tmp24_;
#line 648 "rygel-media-export-query-container-factory.c"
	}
#line 145 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_tmp25_ = upnp_class;
#line 145 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	if (_tmp25_ != NULL) {
#line 654 "rygel-media-export-query-container-factory.c"
		RygelMediaExportQueryContainer* _tmp26_;
		const gchar* _tmp27_;
		gchar* _tmp28_;
		const gchar* _tmp29_;
#line 146 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_tmp26_ = container;
#line 146 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_tmp27_ = upnp_class;
#line 146 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_tmp28_ = g_strdup (_tmp27_);
#line 146 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_g_free0 (((RygelMediaObject*) _tmp26_)->upnp_class);
#line 146 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		((RygelMediaObject*) _tmp26_)->upnp_class = _tmp28_;
#line 147 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_tmp29_ = upnp_class;
#line 147 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		if (g_strcmp0 (_tmp29_, RYGEL_MEDIA_CONTAINER_MUSIC_ALBUM) == 0) {
#line 673 "rygel-media-export-query-container-factory.c"
			RygelMediaExportQueryContainer* _tmp30_;
#line 148 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
			_tmp30_ = container;
#line 148 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
			rygel_media_container_set_sort_criteria ((RygelMediaContainer*) _tmp30_, RYGEL_MEDIA_CONTAINER_ALBUM_SORT_CRITERIA);
#line 679 "rygel-media-export-query-container-factory.c"
		}
	}
#line 152 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	result = container;
#line 152 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_rygel_search_expression_unref0 (expression);
#line 152 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_g_free0 (id);
#line 152 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_g_free0 (upnp_class);
#line 152 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_g_free0 (pattern);
#line 152 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_g_free0 (attribute);
#line 152 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_g_free0 (title);
#line 152 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	return result;
#line 698 "rygel-media-export-query-container-factory.c"
}


/**
     * Map a DIDL attribute to a UPnP container class.
     *
     * @return A matching UPnP class for the attribute or null if it can't be
     *         mapped.
     */
static gchar* rygel_media_export_query_container_factory_map_upnp_class (RygelMediaExportQueryContainerFactory* self, const gchar* attribute) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
#line 164 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	static GQuark _tmp2_label0 = 0;
#line 164 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	static GQuark _tmp2_label1 = 0;
#line 164 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	static GQuark _tmp2_label2 = 0;
#line 164 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	static GQuark _tmp2_label3 = 0;
#line 163 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 163 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	g_return_val_if_fail (attribute != NULL, NULL);
#line 164 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_tmp0_ = attribute;
#line 164 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_tmp1_ = _tmp0_;
#line 164 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
#line 164 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("upnp:album")))) {
#line 164 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		switch (0) {
#line 735 "rygel-media-export-query-container-factory.c"
			default:
			{
				gchar* _tmp4_;
#line 166 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
				_tmp4_ = g_strdup (RYGEL_MEDIA_CONTAINER_MUSIC_ALBUM);
#line 166 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
				result = _tmp4_;
#line 166 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
				return result;
#line 745 "rygel-media-export-query-container-factory.c"
			}
		}
	} else if ((_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("dc:creator")))) || (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("upnp:artist"))))) {
#line 164 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		switch (0) {
#line 751 "rygel-media-export-query-container-factory.c"
			default:
			{
				gchar* _tmp5_;
#line 169 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
				_tmp5_ = g_strdup (RYGEL_MEDIA_CONTAINER_MUSIC_ARTIST);
#line 169 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
				result = _tmp5_;
#line 169 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
				return result;
#line 761 "rygel-media-export-query-container-factory.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label3) ? _tmp2_label3 : (_tmp2_label3 = g_quark_from_static_string ("dc:genre")))) {
#line 164 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		switch (0) {
#line 767 "rygel-media-export-query-container-factory.c"
			default:
			{
				gchar* _tmp6_;
#line 171 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
				_tmp6_ = g_strdup (RYGEL_MEDIA_CONTAINER_MUSIC_GENRE);
#line 171 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
				result = _tmp6_;
#line 171 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
				return result;
#line 777 "rygel-media-export-query-container-factory.c"
			}
		}
	} else {
#line 164 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		switch (0) {
#line 783 "rygel-media-export-query-container-factory.c"
			default:
			{
#line 173 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
				result = NULL;
#line 173 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
				return result;
#line 790 "rygel-media-export-query-container-factory.c"
			}
		}
	}
}


/**
     * Parse a plaintext container description into a search expression.
     *
     * Also generates a name for the container and other meta-data necessary
     * for node containers.
     *
     * @param description The plaintext container description
     * @param pattern     Contains the pattern used for child containers if
     *                    descrption is for a node container, null otherwise.
     * @param attribute   Contains the UPnP attribute the container describes.
     * @param name        If passed empty, name will be generated from the
     *                    description.
     * @return A SearchExpression corresponding to the non-variable part of
     *         the description.
     */
static gpointer _rygel_search_expression_ref0 (gpointer self) {
#line 198 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	return self ? rygel_search_expression_ref (self) : NULL;
#line 815 "rygel-media-export-query-container-factory.c"
}


static RygelSearchExpression* rygel_media_export_query_container_factory_parse_description (RygelMediaExportQueryContainerFactory* self, const gchar* description, gchar** pattern, gchar** attribute, gchar** upnp_class, gchar** name) {
	gchar* _vala_pattern = NULL;
	gchar* _vala_attribute = NULL;
	gchar* _vala_upnp_class = NULL;
	RygelSearchExpression* result = NULL;
	const gchar* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_ = NULL;
	gchar** args;
	gint args_length1;
	gint _args_size_;
	RygelSearchExpression* _tmp3_;
	RygelSearchExpression* expression;
	gint i;
#line 192 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 192 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	g_return_val_if_fail (description != NULL, NULL);
#line 192 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	g_return_val_if_fail (*name != NULL, NULL);
#line 197 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_tmp0_ = description;
#line 197 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_tmp2_ = _tmp1_ = g_strsplit (_tmp0_, ",", 0);
#line 197 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	args = _tmp2_;
#line 197 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	args_length1 = _vala_array_length (_tmp1_);
#line 197 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_args_size_ = args_length1;
#line 198 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_tmp3_ = _rygel_search_expression_ref0 (RYGEL_IS_SEARCH_EXPRESSION (NULL) ? ((RygelSearchExpression*) NULL) : NULL);
#line 198 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	expression = _tmp3_;
#line 199 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_g_free0 (_vala_pattern);
#line 199 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_vala_pattern = NULL;
#line 200 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_g_free0 (_vala_attribute);
#line 200 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_vala_attribute = NULL;
#line 201 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_g_free0 (_vala_upnp_class);
#line 201 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_vala_upnp_class = NULL;
#line 203 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	i = 0;
#line 204 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	while (TRUE) {
#line 869 "rygel-media-export-query-container-factory.c"
		gint _tmp4_;
		gchar** _tmp5_;
		gint _tmp5__length1;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* previous_attribute;
		gchar** _tmp8_;
		gint _tmp8__length1;
		gint _tmp9_;
		const gchar* _tmp10_;
		gchar* _tmp11_ = NULL;
		const gchar* _tmp12_;
		gchar* _tmp13_ = NULL;
		gchar** _tmp14_;
		gint _tmp14__length1;
		gint _tmp15_;
		const gchar* _tmp16_;
		gint _tmp43_;
#line 204 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_tmp4_ = i;
#line 204 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_tmp5_ = args;
#line 204 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_tmp5__length1 = args_length1;
#line 204 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		if (!(_tmp4_ < _tmp5__length1)) {
#line 204 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
			break;
#line 898 "rygel-media-export-query-container-factory.c"
		}
#line 205 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_tmp6_ = _vala_attribute;
#line 205 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_tmp7_ = g_strdup (_tmp6_);
#line 205 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		previous_attribute = _tmp7_;
#line 207 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_tmp8_ = args;
#line 207 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_tmp8__length1 = args_length1;
#line 207 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_tmp9_ = i;
#line 207 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_tmp10_ = _tmp8_[_tmp9_];
#line 207 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_tmp11_ = string_replace (_tmp10_, RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_PREFIX, "");
#line 207 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_g_free0 (_vala_attribute);
#line 207 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_vala_attribute = _tmp11_;
#line 208 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_tmp12_ = _vala_attribute;
#line 208 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_tmp13_ = g_uri_unescape_string (_tmp12_, NULL);
#line 208 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_g_free0 (_vala_attribute);
#line 208 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_vala_attribute = _tmp13_;
#line 210 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_tmp14_ = args;
#line 210 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_tmp14__length1 = args_length1;
#line 210 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_tmp15_ = i;
#line 210 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_tmp16_ = _tmp14_[_tmp15_ + 1];
#line 210 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		if (g_strcmp0 (_tmp16_, "?") != 0) {
#line 938 "rygel-media-export-query-container-factory.c"
			gchar** _tmp17_;
			gint _tmp17__length1;
			gint _tmp18_;
			const gchar* _tmp19_;
			gchar** _tmp20_;
			gint _tmp20__length1;
			gint _tmp21_;
			const gchar* _tmp22_;
			gint _tmp23_;
			gchar** _tmp24_;
			gint _tmp24__length1;
#line 211 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
			_tmp17_ = args;
#line 211 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
			_tmp17__length1 = args_length1;
#line 211 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
			_tmp18_ = i;
#line 211 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
			_tmp19_ = _tmp17_[_tmp18_];
#line 211 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
			_tmp20_ = args;
#line 211 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
			_tmp20__length1 = args_length1;
#line 211 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
			_tmp21_ = i;
#line 211 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
			_tmp22_ = _tmp20_[_tmp21_ + 1];
#line 211 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
			rygel_media_export_query_container_factory_update_search_expression (self, &expression, _tmp19_, _tmp22_);
#line 216 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
			_tmp23_ = i;
#line 216 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
			_tmp24_ = args;
#line 216 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
			_tmp24__length1 = args_length1;
#line 216 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
			if ((_tmp23_ + 2) == _tmp24__length1) {
#line 976 "rygel-media-export-query-container-factory.c"
				const gchar* _tmp25_;
				gchar* _tmp26_ = NULL;
#line 217 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
				_tmp25_ = _vala_attribute;
#line 217 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
				_tmp26_ = rygel_media_export_query_container_factory_map_upnp_class (self, _tmp25_);
#line 217 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
				_g_free0 (_vala_upnp_class);
#line 217 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
				_vala_upnp_class = _tmp26_;
#line 987 "rygel-media-export-query-container-factory.c"
			}
		} else {
			gchar** _tmp27_;
			gint _tmp27__length1;
			gint _tmp28_;
			gchar* _tmp29_;
			gchar* _tmp30_;
			gchar** _tmp31_;
			gint _tmp31__length1;
			gchar* _tmp32_ = NULL;
			const gchar* _tmp33_;
			gchar* _tmp34_ = NULL;
			gboolean _tmp35_ = FALSE;
			const gchar* _tmp36_;
			gboolean _tmp38_;
#line 220 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
			_tmp27_ = args;
#line 220 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
			_tmp27__length1 = args_length1;
#line 220 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
			_tmp28_ = i;
#line 220 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
			_tmp29_ = g_strdup ("%s");
#line 220 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
			_g_free0 (_tmp27_[_tmp28_ + 1]);
#line 220 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
			_tmp27_[_tmp28_ + 1] = _tmp29_;
#line 220 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
			_tmp30_ = _tmp27_[_tmp28_ + 1];
#line 221 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
			_tmp31_ = args;
#line 221 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
			_tmp31__length1 = args_length1;
#line 221 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
			_tmp32_ = g_strjoinv (",", _tmp31_);
#line 221 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
			_g_free0 (_vala_pattern);
#line 221 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
			_vala_pattern = _tmp32_;
#line 225 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
			_tmp33_ = previous_attribute;
#line 225 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
			_tmp34_ = rygel_media_export_query_container_factory_map_upnp_class (self, _tmp33_);
#line 225 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
			_g_free0 (_vala_upnp_class);
#line 225 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
			_vala_upnp_class = _tmp34_;
#line 227 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
			_tmp36_ = *name;
#line 227 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
			if (g_strcmp0 (_tmp36_, "") == 0) {
#line 1039 "rygel-media-export-query-container-factory.c"
				gint _tmp37_;
#line 227 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
				_tmp37_ = i;
#line 227 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
				_tmp35_ = _tmp37_ > 0;
#line 1045 "rygel-media-export-query-container-factory.c"
			} else {
#line 227 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
				_tmp35_ = FALSE;
#line 1049 "rygel-media-export-query-container-factory.c"
			}
#line 227 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
			_tmp38_ = _tmp35_;
#line 227 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
			if (_tmp38_) {
#line 1055 "rygel-media-export-query-container-factory.c"
				gchar** _tmp39_;
				gint _tmp39__length1;
				gint _tmp40_;
				const gchar* _tmp41_;
				gchar* _tmp42_ = NULL;
#line 228 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
				_tmp39_ = args;
#line 228 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
				_tmp39__length1 = args_length1;
#line 228 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
				_tmp40_ = i;
#line 228 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
				_tmp41_ = _tmp39_[_tmp40_ - 1];
#line 228 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
				_tmp42_ = g_uri_unescape_string (_tmp41_, NULL);
#line 228 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
				_g_free0 (*name);
#line 228 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
				*name = _tmp42_;
#line 1075 "rygel-media-export-query-container-factory.c"
			}
#line 231 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
			_g_free0 (previous_attribute);
#line 231 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
			break;
#line 1081 "rygel-media-export-query-container-factory.c"
		}
#line 234 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_tmp43_ = i;
#line 234 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		i = _tmp43_ + 2;
#line 204 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_g_free0 (previous_attribute);
#line 1089 "rygel-media-export-query-container-factory.c"
	}
#line 237 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	result = expression;
#line 237 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
#line 237 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	if (pattern) {
#line 237 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		*pattern = _vala_pattern;
#line 1099 "rygel-media-export-query-container-factory.c"
	} else {
#line 237 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_g_free0 (_vala_pattern);
#line 1103 "rygel-media-export-query-container-factory.c"
	}
#line 237 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	if (attribute) {
#line 237 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		*attribute = _vala_attribute;
#line 1109 "rygel-media-export-query-container-factory.c"
	} else {
#line 237 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_g_free0 (_vala_attribute);
#line 1113 "rygel-media-export-query-container-factory.c"
	}
#line 237 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	if (upnp_class) {
#line 237 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		*upnp_class = _vala_upnp_class;
#line 1119 "rygel-media-export-query-container-factory.c"
	} else {
#line 237 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_g_free0 (_vala_upnp_class);
#line 1123 "rygel-media-export-query-container-factory.c"
	}
#line 237 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	return result;
#line 1127 "rygel-media-export-query-container-factory.c"
}


/**
     * Update a SearchExpression with a new key = value condition.
     *
     * Will modifiy the passed expression to (expression AND (key = value))
     *
     * @param expression The expression to update or null to create a new one
     * @param key        Key of the key/value condition
     * @param value      Value of the key/value condition
     */
static void rygel_media_export_query_container_factory_update_search_expression (RygelMediaExportQueryContainerFactory* self, RygelSearchExpression** expression, const gchar* key, const gchar* value) {
	RygelRelationalExpression* _tmp0_;
	RygelRelationalExpression* subexpression;
	const gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* clean_key;
	RygelRelationalExpression* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_ = NULL;
	RygelRelationalExpression* _tmp6_;
	RygelRelationalExpression* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_ = NULL;
	RygelSearchExpression* _tmp10_;
#line 249 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	g_return_if_fail (self != NULL);
#line 249 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	g_return_if_fail (key != NULL);
#line 249 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	g_return_if_fail (value != NULL);
#line 252 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_tmp0_ = rygel_relational_expression_new ();
#line 252 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	subexpression = _tmp0_;
#line 253 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_tmp1_ = key;
#line 253 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_tmp2_ = string_replace (_tmp1_, RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_PREFIX, "");
#line 253 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	clean_key = _tmp2_;
#line 254 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_tmp3_ = subexpression;
#line 254 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_tmp4_ = clean_key;
#line 254 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_tmp5_ = g_uri_unescape_string (_tmp4_, NULL);
#line 254 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_g_free0 (((RygelSearchExpression*) _tmp3_)->operand1);
#line 254 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	((RygelSearchExpression*) _tmp3_)->operand1 = _tmp5_;
#line 255 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_tmp6_ = subexpression;
#line 255 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	((RygelSearchExpression*) _tmp6_)->op = GINT_TO_POINTER (GUPNP_SEARCH_CRITERIA_OP_EQ);
#line 256 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_tmp7_ = subexpression;
#line 256 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_tmp8_ = value;
#line 256 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_tmp9_ = g_uri_unescape_string (_tmp8_, NULL);
#line 256 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_g_free0 (((RygelSearchExpression*) _tmp7_)->operand2);
#line 256 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	((RygelSearchExpression*) _tmp7_)->operand2 = _tmp9_;
#line 258 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_tmp10_ = *expression;
#line 258 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	if (_tmp10_ != NULL) {
#line 1198 "rygel-media-export-query-container-factory.c"
		RygelLogicalExpression* _tmp11_;
		RygelLogicalExpression* conjunction;
		RygelLogicalExpression* _tmp12_;
		RygelSearchExpression* _tmp13_;
		RygelSearchExpression* _tmp14_;
		RygelLogicalExpression* _tmp15_;
		RygelRelationalExpression* _tmp16_;
		RygelSearchExpression* _tmp17_;
		RygelLogicalExpression* _tmp18_;
		RygelLogicalExpression* _tmp19_;
		RygelSearchExpression* _tmp20_;
#line 259 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_tmp11_ = rygel_logical_expression_new ();
#line 259 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		conjunction = _tmp11_;
#line 260 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_tmp12_ = conjunction;
#line 260 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_tmp13_ = *expression;
#line 260 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_tmp14_ = _rygel_search_expression_ref0 (_tmp13_);
#line 260 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_rygel_search_expression_unref0 (((RygelSearchExpression*) _tmp12_)->operand1);
#line 260 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		((RygelSearchExpression*) _tmp12_)->operand1 = _tmp14_;
#line 261 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_tmp15_ = conjunction;
#line 261 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_tmp16_ = subexpression;
#line 261 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_tmp17_ = _rygel_search_expression_ref0 ((RygelSearchExpression*) _tmp16_);
#line 261 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_rygel_search_expression_unref0 (((RygelSearchExpression*) _tmp15_)->operand2);
#line 261 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		((RygelSearchExpression*) _tmp15_)->operand2 = _tmp17_;
#line 262 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_tmp18_ = conjunction;
#line 262 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		((RygelSearchExpression*) _tmp18_)->op = GINT_TO_POINTER (RYGEL_LOGICAL_OPERATOR_AND);
#line 263 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_tmp19_ = conjunction;
#line 263 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_tmp20_ = _rygel_search_expression_ref0 ((RygelSearchExpression*) _tmp19_);
#line 263 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_rygel_search_expression_unref0 (*expression);
#line 263 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		*expression = _tmp20_;
#line 258 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_rygel_search_expression_unref0 (conjunction);
#line 1248 "rygel-media-export-query-container-factory.c"
	} else {
		RygelRelationalExpression* _tmp21_;
		RygelSearchExpression* _tmp22_;
#line 265 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_tmp21_ = subexpression;
#line 265 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_tmp22_ = _rygel_search_expression_ref0 ((RygelSearchExpression*) _tmp21_);
#line 265 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_rygel_search_expression_unref0 (*expression);
#line 265 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		*expression = _tmp22_;
#line 1260 "rygel-media-export-query-container-factory.c"
	}
#line 249 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_g_free0 (clean_key);
#line 249 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_rygel_search_expression_unref0 (subexpression);
#line 1266 "rygel-media-export-query-container-factory.c"
}


static void rygel_media_export_query_container_factory_class_init (RygelMediaExportQueryContainerFactoryClass * klass) {
#line 23 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	rygel_media_export_query_container_factory_parent_class = g_type_class_peek_parent (klass);
#line 23 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	g_type_class_add_private (klass, sizeof (RygelMediaExportQueryContainerFactoryPrivate));
#line 23 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_media_export_query_container_factory_finalize;
#line 1277 "rygel-media-export-query-container-factory.c"
}


static void rygel_media_export_query_container_factory_instance_init (RygelMediaExportQueryContainerFactory * self) {
#line 23 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	self->priv = RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_FACTORY_GET_PRIVATE (self);
#line 1284 "rygel-media-export-query-container-factory.c"
}


static void rygel_media_export_query_container_factory_finalize (GObject* obj) {
	RygelMediaExportQueryContainerFactory * self;
#line 23 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	self = RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_FACTORY (obj);
#line 28 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_g_object_unref0 (self->priv->virtual_container_map);
#line 23 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	G_OBJECT_CLASS (rygel_media_export_query_container_factory_parent_class)->finalize (obj);
#line 1296 "rygel-media-export-query-container-factory.c"
}


GType rygel_media_export_query_container_factory_get_type (void) {
	static volatile gsize rygel_media_export_query_container_factory_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_export_query_container_factory_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaExportQueryContainerFactoryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_export_query_container_factory_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaExportQueryContainerFactory), 0, (GInstanceInitFunc) rygel_media_export_query_container_factory_instance_init, NULL };
		GType rygel_media_export_query_container_factory_type_id;
		rygel_media_export_query_container_factory_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMediaExportQueryContainerFactory", &g_define_type_info, 0);
		g_once_init_leave (&rygel_media_export_query_container_factory_type_id__volatile, rygel_media_export_query_container_factory_type_id);
	}
	return rygel_media_export_query_container_factory_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



