/* rygel-tracker-search-container.c generated by valac 0.16.1, the Vala compiler
 * generated from rygel-tracker-search-container.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2008-2012 Nokia Corporation.
 * Copyright (C) 2010 MediaNet Inh.
 *
 * Authors: Zeeshan Ali <zeenix@gmail.com>
 *          Sunil Mohan Adapa <sunil@medhas.org>
 *         Jens Georg <jensg@openismus.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel-server.h>
#include <libtracker-sparql/tracker-sparql.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <libgupnp-av/gupnp-av.h>


#define RYGEL_TRACKER_TYPE_SEARCH_CONTAINER (rygel_tracker_search_container_get_type ())
#define RYGEL_TRACKER_SEARCH_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_SEARCH_CONTAINER, RygelTrackerSearchContainer))
#define RYGEL_TRACKER_SEARCH_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_SEARCH_CONTAINER, RygelTrackerSearchContainerClass))
#define RYGEL_TRACKER_IS_SEARCH_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_SEARCH_CONTAINER))
#define RYGEL_TRACKER_IS_SEARCH_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_SEARCH_CONTAINER))
#define RYGEL_TRACKER_SEARCH_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_SEARCH_CONTAINER, RygelTrackerSearchContainerClass))

typedef struct _RygelTrackerSearchContainer RygelTrackerSearchContainer;
typedef struct _RygelTrackerSearchContainerClass RygelTrackerSearchContainerClass;
typedef struct _RygelTrackerSearchContainerPrivate RygelTrackerSearchContainerPrivate;

#define RYGEL_TRACKER_TYPE_QUERY (rygel_tracker_query_get_type ())
#define RYGEL_TRACKER_QUERY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_QUERY, RygelTrackerQuery))
#define RYGEL_TRACKER_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_QUERY, RygelTrackerQueryClass))
#define RYGEL_TRACKER_IS_QUERY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_QUERY))
#define RYGEL_TRACKER_IS_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_QUERY))
#define RYGEL_TRACKER_QUERY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_QUERY, RygelTrackerQueryClass))

typedef struct _RygelTrackerQuery RygelTrackerQuery;
typedef struct _RygelTrackerQueryClass RygelTrackerQueryClass;

#define RYGEL_TRACKER_TYPE_SELECTION_QUERY (rygel_tracker_selection_query_get_type ())
#define RYGEL_TRACKER_SELECTION_QUERY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_SELECTION_QUERY, RygelTrackerSelectionQuery))
#define RYGEL_TRACKER_SELECTION_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_SELECTION_QUERY, RygelTrackerSelectionQueryClass))
#define RYGEL_TRACKER_IS_SELECTION_QUERY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_SELECTION_QUERY))
#define RYGEL_TRACKER_IS_SELECTION_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_SELECTION_QUERY))
#define RYGEL_TRACKER_SELECTION_QUERY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_SELECTION_QUERY, RygelTrackerSelectionQueryClass))

typedef struct _RygelTrackerSelectionQuery RygelTrackerSelectionQuery;
typedef struct _RygelTrackerSelectionQueryClass RygelTrackerSelectionQueryClass;

#define RYGEL_TRACKER_TYPE_ITEM_FACTORY (rygel_tracker_item_factory_get_type ())
#define RYGEL_TRACKER_ITEM_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_ITEM_FACTORY, RygelTrackerItemFactory))
#define RYGEL_TRACKER_ITEM_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_ITEM_FACTORY, RygelTrackerItemFactoryClass))
#define RYGEL_TRACKER_IS_ITEM_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_ITEM_FACTORY))
#define RYGEL_TRACKER_IS_ITEM_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_ITEM_FACTORY))
#define RYGEL_TRACKER_ITEM_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_ITEM_FACTORY, RygelTrackerItemFactoryClass))

typedef struct _RygelTrackerItemFactory RygelTrackerItemFactory;
typedef struct _RygelTrackerItemFactoryClass RygelTrackerItemFactoryClass;
#define _rygel_tracker_query_unref0(var) ((var == NULL) ? NULL : (var = (rygel_tracker_query_unref (var), NULL)))
#define _rygel_tracker_item_factory_unref0(var) ((var == NULL) ? NULL : (var = (rygel_tracker_item_factory_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TRACKER_TYPE_QUERY_TRIPLETS (rygel_tracker_query_triplets_get_type ())
#define RYGEL_TRACKER_QUERY_TRIPLETS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_QUERY_TRIPLETS, RygelTrackerQueryTriplets))
#define RYGEL_TRACKER_QUERY_TRIPLETS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_QUERY_TRIPLETS, RygelTrackerQueryTripletsClass))
#define RYGEL_TRACKER_IS_QUERY_TRIPLETS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_QUERY_TRIPLETS))
#define RYGEL_TRACKER_IS_QUERY_TRIPLETS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_QUERY_TRIPLETS))
#define RYGEL_TRACKER_QUERY_TRIPLETS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_QUERY_TRIPLETS, RygelTrackerQueryTripletsClass))

typedef struct _RygelTrackerQueryTriplets RygelTrackerQueryTriplets;
typedef struct _RygelTrackerQueryTripletsClass RygelTrackerQueryTripletsClass;
typedef struct _RygelTrackerItemFactoryPrivate RygelTrackerItemFactoryPrivate;

#define RYGEL_TRACKER_TYPE_QUERY_TRIPLET (rygel_tracker_query_triplet_get_type ())
#define RYGEL_TRACKER_QUERY_TRIPLET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_QUERY_TRIPLET, RygelTrackerQueryTriplet))
#define RYGEL_TRACKER_QUERY_TRIPLET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_QUERY_TRIPLET, RygelTrackerQueryTripletClass))
#define RYGEL_TRACKER_IS_QUERY_TRIPLET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_QUERY_TRIPLET))
#define RYGEL_TRACKER_IS_QUERY_TRIPLET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_QUERY_TRIPLET))
#define RYGEL_TRACKER_QUERY_TRIPLET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_QUERY_TRIPLET, RygelTrackerQueryTripletClass))

typedef struct _RygelTrackerQueryTriplet RygelTrackerQueryTriplet;
typedef struct _RygelTrackerQueryTripletClass RygelTrackerQueryTripletClass;
#define _rygel_tracker_query_triplet_unref0(var) ((var == NULL) ? NULL : (var = (rygel_tracker_query_triplet_unref (var), NULL)))

#define RYGEL_TRACKER_TYPE_UPN_PPROPERTY_MAP (rygel_tracker_upn_pproperty_map_get_type ())
#define RYGEL_TRACKER_UPN_PPROPERTY_MAP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_UPN_PPROPERTY_MAP, RygelTrackerUPnPPropertyMap))
#define RYGEL_TRACKER_UPN_PPROPERTY_MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_UPN_PPROPERTY_MAP, RygelTrackerUPnPPropertyMapClass))
#define RYGEL_TRACKER_IS_UPN_PPROPERTY_MAP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_UPN_PPROPERTY_MAP))
#define RYGEL_TRACKER_IS_UPN_PPROPERTY_MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_UPN_PPROPERTY_MAP))
#define RYGEL_TRACKER_UPN_PPROPERTY_MAP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_UPN_PPROPERTY_MAP, RygelTrackerUPnPPropertyMapClass))

typedef struct _RygelTrackerUPnPPropertyMap RygelTrackerUPnPPropertyMap;
typedef struct _RygelTrackerUPnPPropertyMapClass RygelTrackerUPnPPropertyMapClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _rygel_search_expression_unref0(var) ((var == NULL) ? NULL : (var = (rygel_search_expression_unref (var), NULL)))
typedef struct _RygelTrackerSearchContainerGetChildrenData RygelTrackerSearchContainerGetChildrenData;
typedef struct _RygelTrackerQueryPrivate RygelTrackerQueryPrivate;
typedef struct _RygelTrackerSelectionQueryPrivate RygelTrackerSelectionQueryPrivate;
typedef struct _RygelTrackerSearchContainerExecuteQueryData RygelTrackerSearchContainerExecuteQueryData;
typedef struct _RygelTrackerSearchContainerFindObjectData RygelTrackerSearchContainerFindObjectData;
typedef struct _RygelTrackerSearchContainerGetChildrenCountData RygelTrackerSearchContainerGetChildrenCountData;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

struct _RygelTrackerSearchContainer {
	RygelSimpleContainer parent_instance;
	RygelTrackerSearchContainerPrivate * priv;
	RygelTrackerSelectionQuery* query;
	RygelTrackerItemFactory* item_factory;
};

struct _RygelTrackerSearchContainerClass {
	RygelSimpleContainerClass parent_class;
};

struct _RygelTrackerSearchContainerPrivate {
	TrackerSparqlConnection* resources;
};

struct _RygelTrackerItemFactory {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelTrackerItemFactoryPrivate * priv;
	gchar* category;
	gchar* category_iri;
	gchar* upnp_class;
	gchar* upload_dir;
	GeeArrayList* properties;
};

struct _RygelTrackerItemFactoryClass {
	GTypeClass parent_class;
	void (*finalize) (RygelTrackerItemFactory *self);
	RygelMediaItem* (*create) (RygelTrackerItemFactory* self, const gchar* id, const gchar* uri, RygelTrackerSearchContainer* parent, TrackerSparqlCursor* metadata, GError** error);
	void (*set_metadata) (RygelTrackerItemFactory* self, RygelMediaItem* item, const gchar* uri, TrackerSparqlCursor* metadata, GError** error);
};

struct _RygelTrackerSearchContainerGetChildrenData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelTrackerSearchContainer* self;
	guint offset;
	guint max_count;
	gchar* sort_criteria;
	GCancellable* cancellable;
	RygelMediaObjects* result;
	RygelRelationalExpression* _tmp0_;
	RygelRelationalExpression* expression;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	guint total_matches;
	const gchar* _tmp4_;
	guint _tmp5_;
	guint _tmp6_;
	GCancellable* _tmp7_;
	guint _tmp8_;
	RygelMediaObjects* _tmp9_;
	RygelMediaObjects* _tmp10_;
	GError * _inner_error_;
};

struct _RygelTrackerQuery {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelTrackerQueryPrivate * priv;
	RygelTrackerQueryTriplets* triplets;
};

struct _RygelTrackerQueryClass {
	GTypeClass parent_class;
	void (*finalize) (RygelTrackerQuery *self);
	void (*execute) (RygelTrackerQuery* self, TrackerSparqlConnection* resources, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*execute_finish) (RygelTrackerQuery* self, GAsyncResult* _res_, GError** error);
	gchar* (*to_string) (RygelTrackerQuery* self);
};

struct _RygelTrackerSelectionQuery {
	RygelTrackerQuery parent_instance;
	RygelTrackerSelectionQueryPrivate * priv;
	GeeArrayList* variables;
	GeeArrayList* filters;
	gchar* order_by;
	gint offset;
	gint max_count;
	TrackerSparqlCursor* result;
};

struct _RygelTrackerSelectionQueryClass {
	RygelTrackerQueryClass parent_class;
};

struct _RygelTrackerSearchContainerExecuteQueryData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelTrackerSearchContainer* self;
	RygelSearchExpression* expression;
	gchar* sort_criteria;
	guint offset;
	guint max_count;
	guint total_matches;
	GCancellable* cancellable;
	RygelMediaObjects* result;
	RygelMediaObjects* _tmp0_;
	RygelMediaObjects* results;
	RygelSearchExpression* _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	const gchar* _tmp4_;
	RygelTrackerSelectionQuery* _tmp5_;
	RygelTrackerSelectionQuery* query;
	RygelTrackerSelectionQuery* _tmp6_;
	RygelTrackerSelectionQuery* _tmp7_;
	TrackerSparqlConnection* _tmp8_;
	RygelTrackerSelectionQuery* _tmp9_;
	TrackerSparqlCursor* _tmp10_;
	gboolean _tmp11_;
	gboolean _tmp12_;
	RygelTrackerSelectionQuery* _tmp13_;
	TrackerSparqlCursor* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* id;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	RygelTrackerSelectionQuery* _tmp19_;
	TrackerSparqlCursor* _tmp20_;
	const gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* uri;
	RygelTrackerItemFactory* _tmp23_;
	const gchar* _tmp24_;
	const gchar* _tmp25_;
	RygelTrackerSelectionQuery* _tmp26_;
	TrackerSparqlCursor* _tmp27_;
	RygelMediaItem* _tmp28_;
	RygelMediaItem* item;
	RygelMediaObjects* _tmp29_;
	RygelMediaItem* _tmp30_;
	RygelMediaObjects* _tmp31_;
	gint _tmp32_;
	gint _tmp33_;
	GError * _inner_error_;
};

struct _RygelTrackerSearchContainerFindObjectData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelTrackerSearchContainer* self;
	gchar* id;
	GCancellable* cancellable;
	RygelMediaObject* result;
	const gchar* _tmp0_;
	gboolean _tmp1_;
	RygelRelationalExpression* _tmp2_;
	RygelRelationalExpression* expression;
	RygelRelationalExpression* _tmp3_;
	RygelRelationalExpression* _tmp4_;
	gchar* _tmp5_;
	RygelRelationalExpression* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	guint total_matches;
	RygelRelationalExpression* _tmp9_;
	GCancellable* _tmp10_;
	guint _tmp11_;
	RygelMediaObjects* _tmp12_;
	RygelMediaObjects* results;
	RygelMediaObjects* _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	RygelMediaObjects* _tmp16_;
	gpointer _tmp17_;
	GError * _inner_error_;
};

struct _RygelTrackerSearchContainerGetChildrenCountData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelTrackerSearchContainer* self;
	RygelTrackerSelectionQuery* _tmp0_;
	RygelTrackerSelectionQuery* _tmp1_;
	RygelTrackerSelectionQuery* query;
	RygelTrackerSelectionQuery* _tmp2_;
	GeeArrayList* _tmp3_;
	RygelTrackerSelectionQuery* _tmp4_;
	GeeArrayList* _tmp5_;
	RygelTrackerSelectionQuery* _tmp6_;
	TrackerSparqlConnection* _tmp7_;
	RygelTrackerSelectionQuery* _tmp8_;
	TrackerSparqlCursor* _tmp9_;
	gboolean _tmp10_;
	gboolean _tmp11_;
	RygelTrackerSelectionQuery* _tmp12_;
	TrackerSparqlCursor* _tmp13_;
	const gchar* _tmp14_;
	gint _tmp15_;
	GError* _error_;
	const gchar* _tmp16_;
	RygelTrackerItemFactory* _tmp17_;
	const gchar* _tmp18_;
	GError* _tmp19_;
	const gchar* _tmp20_;
	GError * _inner_error_;
};


static gpointer rygel_tracker_search_container_parent_class = NULL;
static GeeHashMap* rygel_tracker_search_container_update_id_hash;
static GeeHashMap* rygel_tracker_search_container_update_id_hash = NULL;

GType rygel_tracker_search_container_get_type (void) G_GNUC_CONST;
gpointer rygel_tracker_query_ref (gpointer instance);
void rygel_tracker_query_unref (gpointer instance);
GParamSpec* rygel_tracker_param_spec_query (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_tracker_value_set_query (GValue* value, gpointer v_object);
void rygel_tracker_value_take_query (GValue* value, gpointer v_object);
gpointer rygel_tracker_value_get_query (const GValue* value);
GType rygel_tracker_query_get_type (void) G_GNUC_CONST;
GType rygel_tracker_selection_query_get_type (void) G_GNUC_CONST;
gpointer rygel_tracker_item_factory_ref (gpointer instance);
void rygel_tracker_item_factory_unref (gpointer instance);
GParamSpec* rygel_tracker_param_spec_item_factory (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_tracker_value_set_item_factory (GValue* value, gpointer v_object);
void rygel_tracker_value_take_item_factory (GValue* value, gpointer v_object);
gpointer rygel_tracker_value_get_item_factory (const GValue* value);
GType rygel_tracker_item_factory_get_type (void) G_GNUC_CONST;
#define RYGEL_TRACKER_SEARCH_CONTAINER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TRACKER_TYPE_SEARCH_CONTAINER, RygelTrackerSearchContainerPrivate))
enum  {
	RYGEL_TRACKER_SEARCH_CONTAINER_DUMMY_PROPERTY
};
#define RYGEL_TRACKER_SEARCH_CONTAINER_MODIFIED_PROPERTY "nfo:fileLastModified"
GType rygel_tracker_query_triplets_get_type (void) G_GNUC_CONST;
RygelTrackerSearchContainer* rygel_tracker_search_container_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, RygelTrackerItemFactory* item_factory, RygelTrackerQueryTriplets* triplets, GeeArrayList* filters);
RygelTrackerSearchContainer* rygel_tracker_search_container_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, RygelTrackerItemFactory* item_factory, RygelTrackerQueryTriplets* triplets, GeeArrayList* filters);
static void __lambda2_ (RygelTrackerSearchContainer* self, RygelMediaContainer* container, RygelMediaContainer* origin);
static void ___lambda2__rygel_media_container_container_updated (RygelMediaContainer* _sender, RygelMediaContainer* container, gpointer self);
#define RYGEL_TRACKER_SELECTION_QUERY_ITEM_VARIABLE "?item"
RygelTrackerQueryTriplets* rygel_tracker_query_triplets_new (void);
RygelTrackerQueryTriplets* rygel_tracker_query_triplets_construct (GType object_type);
RygelTrackerQueryTriplet* rygel_tracker_query_triplet_new (const gchar* subject, const gchar* predicate, const gchar* obj);
RygelTrackerQueryTriplet* rygel_tracker_query_triplet_construct (GType object_type, const gchar* subject, const gchar* predicate, const gchar* obj);
gpointer rygel_tracker_query_triplet_ref (gpointer instance);
void rygel_tracker_query_triplet_unref (gpointer instance);
GParamSpec* rygel_tracker_param_spec_query_triplet (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_tracker_value_set_query_triplet (GValue* value, gpointer v_object);
void rygel_tracker_value_take_query_triplet (GValue* value, gpointer v_object);
gpointer rygel_tracker_value_get_query_triplet (const GValue* value);
GType rygel_tracker_query_triplet_get_type (void) G_GNUC_CONST;
GType rygel_tracker_upn_pproperty_map_get_type (void) G_GNUC_CONST;
RygelTrackerUPnPPropertyMap* rygel_tracker_upn_pproperty_map_get_property_map (void);
gchar* rygel_tracker_upn_pproperty_map_get (RygelTrackerUPnPPropertyMap* self, const gchar* property);
RygelTrackerSelectionQuery* rygel_tracker_selection_query_new (GeeArrayList* variables, RygelTrackerQueryTriplets* triplets, GeeArrayList* filters, const gchar* order_by, gint offset, gint max_count);
RygelTrackerSelectionQuery* rygel_tracker_selection_query_construct (GType object_type, GeeArrayList* variables, RygelTrackerQueryTriplets* triplets, GeeArrayList* filters, const gchar* order_by, gint offset, gint max_count);
void rygel_tracker_search_container_get_children_count (RygelTrackerSearchContainer* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_tracker_search_container_get_children_count_finish (RygelTrackerSearchContainer* self, GAsyncResult* _res_);
static void rygel_tracker_search_container_real_get_children_data_free (gpointer _data);
static void rygel_tracker_search_container_real_get_children (RygelMediaContainer* base, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_tracker_search_container_real_get_children_co (RygelTrackerSearchContainerGetChildrenData* _data_);
void rygel_tracker_search_container_execute_query (RygelTrackerSearchContainer* self, RygelSearchExpression* expression, const gchar* sort_criteria, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObjects* rygel_tracker_search_container_execute_query_finish (RygelTrackerSearchContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
static void rygel_tracker_search_container_get_children_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void rygel_tracker_search_container_execute_query_data_free (gpointer _data);
static gboolean rygel_tracker_search_container_execute_query_co (RygelTrackerSearchContainerExecuteQueryData* _data_);
static RygelTrackerSelectionQuery* rygel_tracker_search_container_create_query (RygelTrackerSearchContainer* self, RygelRelationalExpression* expression, gint offset, gint max_count, const gchar* sort_criteria);
void rygel_tracker_query_execute (RygelTrackerQuery* self, TrackerSparqlConnection* resources, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_tracker_query_execute_finish (RygelTrackerQuery* self, GAsyncResult* _res_, GError** error);
static void rygel_tracker_search_container_execute_query_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
gchar* rygel_tracker_search_container_create_child_id_for_urn (RygelTrackerSearchContainer* self, const gchar* urn);
RygelMediaItem* rygel_tracker_item_factory_create (RygelTrackerItemFactory* self, const gchar* id, const gchar* uri, RygelTrackerSearchContainer* parent, TrackerSparqlCursor* metadata, GError** error);
static void rygel_tracker_search_container_real_find_object_data_free (gpointer _data);
static void rygel_tracker_search_container_real_find_object (RygelMediaContainer* base, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_tracker_search_container_real_find_object_co (RygelTrackerSearchContainerFindObjectData* _data_);
static gboolean rygel_tracker_search_container_is_our_child (RygelTrackerSearchContainer* self, const gchar* id);
static void rygel_tracker_search_container_find_object_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
gchar* rygel_tracker_search_container_get_item_info (RygelTrackerSearchContainer* self, const gchar* item_id, gchar** parent_id);
static void rygel_tracker_search_container_get_children_count_data_free (gpointer _data);
static gboolean rygel_tracker_search_container_get_children_count_co (RygelTrackerSearchContainerGetChildrenCountData* _data_);
RygelTrackerSelectionQuery* rygel_tracker_selection_query_new_clone (RygelTrackerSelectionQuery* query);
RygelTrackerSelectionQuery* rygel_tracker_selection_query_construct_clone (GType object_type, RygelTrackerSelectionQuery* query);
static void rygel_tracker_search_container_get_children_count_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static RygelTrackerSelectionQuery* rygel_tracker_search_container_create_sorted_query (RygelTrackerSearchContainer* self, const gchar* sort_criteria);
static gchar* rygel_tracker_search_container_create_filter_for_child (RygelTrackerSearchContainer* self, RygelRelationalExpression* expression);
RygelTrackerQueryTriplets* rygel_tracker_query_triplets_new_clone (RygelTrackerQueryTriplets* triplets);
RygelTrackerQueryTriplets* rygel_tracker_query_triplets_construct_clone (GType object_type, RygelTrackerQueryTriplets* triplets);
static gchar* rygel_tracker_search_container_urn_to_utf8 (RygelTrackerSearchContainer* self, const gchar* urn);
gchar* rygel_tracker_query_escape_string (const gchar* literal);
gchar* rygel_tracker_query_escape_regex (const gchar* literal);
static void rygel_tracker_search_container_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static void __lambda2_ (RygelTrackerSearchContainer* self, RygelMediaContainer* container, RygelMediaContainer* origin) {
	RygelMediaContainer* _tmp0_;
#line 61 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	g_return_if_fail (container != NULL);
#line 61 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	g_return_if_fail (origin != NULL);
#line 62 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp0_ = origin;
#line 62 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	if (_tmp0_ == RYGEL_MEDIA_CONTAINER (self)) {
#line 437 "rygel-tracker-search-container.c"
		GeeHashMap* _tmp1_;
		const gchar* _tmp2_;
		guint32 _tmp3_;
#line 63 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp1_ = rygel_tracker_search_container_update_id_hash;
#line 63 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp2_ = ((RygelMediaObject*) self)->id;
#line 63 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp3_ = ((RygelMediaContainer*) self)->update_id;
#line 63 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		gee_abstract_map_set ((GeeAbstractMap*) _tmp1_, _tmp2_, GUINT_TO_POINTER ((guint) _tmp3_));
#line 449 "rygel-tracker-search-container.c"
	}
}


static void ___lambda2__rygel_media_container_container_updated (RygelMediaContainer* _sender, RygelMediaContainer* container, gpointer self) {
#line 61 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	__lambda2_ (self, _sender, container);
#line 457 "rygel-tracker-search-container.c"
}


static gpointer _rygel_tracker_item_factory_ref0 (gpointer self) {
#line 67 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	return self ? rygel_tracker_item_factory_ref (self) : NULL;
#line 464 "rygel-tracker-search-container.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 74 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	return self ? g_object_ref (self) : NULL;
#line 471 "rygel-tracker-search-container.c"
}


RygelTrackerSearchContainer* rygel_tracker_search_container_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, RygelTrackerItemFactory* item_factory, RygelTrackerQueryTriplets* triplets, GeeArrayList* filters) {
	RygelTrackerSearchContainer * self = NULL;
	const gchar* _tmp0_;
	RygelMediaContainer* _tmp1_;
	const gchar* _tmp2_;
	GeeHashMap* _tmp3_;
	gboolean _tmp4_ = FALSE;
	GeeHashMap* _tmp6_;
	const gchar* _tmp7_;
	gboolean _tmp8_ = FALSE;
	RygelTrackerItemFactory* _tmp12_;
	RygelTrackerItemFactory* _tmp13_;
	GeeArrayList* _tmp14_;
	GeeArrayList* variables;
	GeeArrayList* _tmp15_;
	RygelTrackerQueryTriplets* our_triplets = NULL;
	RygelTrackerQueryTriplets* _tmp16_;
	RygelTrackerQueryTriplets* _tmp20_;
	RygelTrackerItemFactory* _tmp21_;
	const gchar* _tmp22_;
	RygelTrackerQueryTriplet* _tmp23_;
	RygelTrackerQueryTriplet* _tmp24_;
	RygelTrackerUPnPPropertyMap* _tmp25_ = NULL;
	RygelTrackerUPnPPropertyMap* property_map;
	gchar* _tmp43_;
	gchar* order_by;
	GeeArrayList* _tmp44_;
	RygelTrackerQueryTriplets* _tmp45_;
	GeeArrayList* _tmp46_;
	RygelTrackerSelectionQuery* _tmp47_;
	GError * _inner_error_ = NULL;
#line 45 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	g_return_val_if_fail (id != NULL, NULL);
#line 45 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	g_return_val_if_fail (parent != NULL, NULL);
#line 45 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	g_return_val_if_fail (title != NULL, NULL);
#line 45 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	g_return_val_if_fail (item_factory != NULL, NULL);
#line 51 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp0_ = id;
#line 51 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp1_ = parent;
#line 51 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp2_ = title;
#line 51 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	self = (RygelTrackerSearchContainer*) rygel_simple_container_construct (object_type, _tmp0_, _tmp1_, _tmp2_);
#line 53 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp3_ = rygel_tracker_search_container_update_id_hash;
#line 53 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp4_ = G_UNLIKELY (_tmp3_ == NULL);
#line 53 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	if (_tmp4_) {
#line 528 "rygel-tracker-search-container.c"
		GeeHashMap* _tmp5_;
#line 54 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp5_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_UINT, NULL, NULL, NULL, NULL, NULL);
#line 54 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_g_object_unref0 (rygel_tracker_search_container_update_id_hash);
#line 54 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		rygel_tracker_search_container_update_id_hash = _tmp5_;
#line 536 "rygel-tracker-search-container.c"
	}
#line 57 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp6_ = rygel_tracker_search_container_update_id_hash;
#line 57 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp7_ = ((RygelMediaObject*) self)->id;
#line 57 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp8_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp6_, _tmp7_);
#line 57 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	if (_tmp8_) {
#line 546 "rygel-tracker-search-container.c"
		GeeHashMap* _tmp9_;
		const gchar* _tmp10_;
		gpointer _tmp11_ = NULL;
#line 58 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp9_ = rygel_tracker_search_container_update_id_hash;
#line 58 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp10_ = ((RygelMediaObject*) self)->id;
#line 58 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp11_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp9_, _tmp10_);
#line 58 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		((RygelMediaContainer*) self)->update_id = (guint32) GPOINTER_TO_UINT (_tmp11_);
#line 558 "rygel-tracker-search-container.c"
	}
#line 61 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	g_signal_connect_object ((RygelMediaContainer*) self, "container-updated", (GCallback) ___lambda2__rygel_media_container_container_updated, self, 0);
#line 67 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp12_ = item_factory;
#line 67 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp13_ = _rygel_tracker_item_factory_ref0 (_tmp12_);
#line 67 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_rygel_tracker_item_factory_unref0 (self->item_factory);
#line 67 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	self->item_factory = _tmp13_;
#line 69 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp14_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
#line 69 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	variables = _tmp14_;
#line 70 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp15_ = variables;
#line 70 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp15_, RYGEL_TRACKER_SELECTION_QUERY_ITEM_VARIABLE);
#line 73 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp16_ = triplets;
#line 73 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	if (_tmp16_ != NULL) {
#line 582 "rygel-tracker-search-container.c"
		RygelTrackerQueryTriplets* _tmp17_;
		RygelTrackerQueryTriplets* _tmp18_;
#line 74 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp17_ = triplets;
#line 74 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp18_ = _g_object_ref0 (_tmp17_);
#line 74 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_g_object_unref0 (our_triplets);
#line 74 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		our_triplets = _tmp18_;
#line 593 "rygel-tracker-search-container.c"
	} else {
		RygelTrackerQueryTriplets* _tmp19_;
#line 76 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp19_ = rygel_tracker_query_triplets_new ();
#line 76 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_g_object_unref0 (our_triplets);
#line 76 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		our_triplets = _tmp19_;
#line 602 "rygel-tracker-search-container.c"
	}
#line 79 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp20_ = our_triplets;
#line 79 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp21_ = item_factory;
#line 79 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp22_ = _tmp21_->category;
#line 79 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp23_ = rygel_tracker_query_triplet_new (RYGEL_TRACKER_SELECTION_QUERY_ITEM_VARIABLE, "a", _tmp22_);
#line 79 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp24_ = _tmp23_;
#line 79 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp20_, _tmp24_);
#line 79 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_rygel_tracker_query_triplet_unref0 (_tmp24_);
#line 84 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp25_ = rygel_tracker_upn_pproperty_map_get_property_map ();
#line 84 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	property_map = _tmp25_;
#line 622 "rygel-tracker-search-container.c"
	{
		RygelTrackerItemFactory* _tmp26_;
		GeeArrayList* _tmp27_;
		GeeArrayList* _tmp28_;
		GeeArrayList* _property_list;
		GeeArrayList* _tmp29_;
		gint _tmp30_;
		gint _tmp31_;
		gint _property_size;
		gint _property_index;
#line 85 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp26_ = self->item_factory;
#line 85 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp27_ = _tmp26_->properties;
#line 85 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp28_ = _g_object_ref0 (_tmp27_);
#line 85 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_property_list = _tmp28_;
#line 85 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp29_ = _property_list;
#line 85 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp30_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp29_);
#line 85 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp31_ = _tmp30_;
#line 85 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_property_size = _tmp31_;
#line 85 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_property_index = -1;
#line 85 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		while (TRUE) {
#line 653 "rygel-tracker-search-container.c"
			gint _tmp32_;
			gint _tmp33_;
			gint _tmp34_;
			GeeArrayList* _tmp35_;
			gint _tmp36_;
			gpointer _tmp37_ = NULL;
			gchar* property;
			GeeArrayList* _tmp38_;
			RygelTrackerUPnPPropertyMap* _tmp39_;
			const gchar* _tmp40_;
			gchar* _tmp41_ = NULL;
			gchar* _tmp42_;
#line 85 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_tmp32_ = _property_index;
#line 85 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_property_index = _tmp32_ + 1;
#line 85 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_tmp33_ = _property_index;
#line 85 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_tmp34_ = _property_size;
#line 85 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			if (!(_tmp33_ < _tmp34_)) {
#line 85 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				break;
#line 678 "rygel-tracker-search-container.c"
			}
#line 85 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_tmp35_ = _property_list;
#line 85 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_tmp36_ = _property_index;
#line 85 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_tmp37_ = gee_abstract_list_get ((GeeAbstractList*) _tmp35_, _tmp36_);
#line 85 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			property = (gchar*) _tmp37_;
#line 86 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_tmp38_ = variables;
#line 86 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_tmp39_ = property_map;
#line 86 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_tmp40_ = property;
#line 86 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_tmp41_ = rygel_tracker_upn_pproperty_map_get (_tmp39_, _tmp40_);
#line 86 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_tmp42_ = _tmp41_;
#line 86 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp38_, _tmp42_);
#line 86 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_g_free0 (_tmp42_);
#line 85 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_g_free0 (property);
#line 704 "rygel-tracker-search-container.c"
		}
#line 85 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_g_object_unref0 (_property_list);
#line 708 "rygel-tracker-search-container.c"
	}
#line 89 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp43_ = g_strdup (RYGEL_TRACKER_SEARCH_CONTAINER_MODIFIED_PROPERTY "(" RYGEL_TRACKER_SELECTION_QUERY_ITEM_VARIABLE ")");
#line 89 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	order_by = _tmp43_;
#line 94 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp44_ = variables;
#line 94 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp45_ = our_triplets;
#line 94 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp46_ = filters;
#line 94 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp47_ = rygel_tracker_selection_query_new (_tmp44_, _tmp45_, _tmp46_, order_by, 0, -1);
#line 94 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_rygel_tracker_query_unref0 (self->query);
#line 94 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	self->query = _tmp47_;
#line 726 "rygel-tracker-search-container.c"
	{
		TrackerSparqlConnection* _tmp48_ = NULL;
		TrackerSparqlConnection* _tmp49_;
#line 100 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp48_ = tracker_sparql_connection_get (NULL, &_inner_error_);
#line 100 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp49_ = _tmp48_;
#line 100 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		if (_inner_error_ != NULL) {
#line 736 "rygel-tracker-search-container.c"
			goto __catch4_g_error;
		}
#line 100 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_g_object_unref0 (self->priv->resources);
#line 100 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		self->priv->resources = _tmp49_;
#line 102 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		rygel_tracker_search_container_get_children_count (self, NULL, NULL);
#line 745 "rygel-tracker-search-container.c"
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* _error_ = NULL;
		const gchar* _tmp50_ = NULL;
		GError* _tmp51_;
		const gchar* _tmp52_;
#line 99 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_error_ = _inner_error_;
#line 99 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_inner_error_ = NULL;
#line 104 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp50_ = _ ("Failed to get Tracker connection: %s");
#line 104 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp51_ = _error_;
#line 104 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp52_ = _tmp51_->message;
#line 104 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		g_critical (_tmp50_, _tmp52_);
#line 99 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_g_error_free0 (_error_);
#line 768 "rygel-tracker-search-container.c"
	}
	__finally4:
#line 99 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	if (_inner_error_ != NULL) {
#line 99 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_g_free0 (order_by);
#line 99 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_g_object_unref0 (property_map);
#line 99 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_g_object_unref0 (our_triplets);
#line 99 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_g_object_unref0 (variables);
#line 99 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 99 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		g_clear_error (&_inner_error_);
#line 99 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		return NULL;
#line 787 "rygel-tracker-search-container.c"
	}
#line 45 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_g_free0 (order_by);
#line 45 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_g_object_unref0 (property_map);
#line 45 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_g_object_unref0 (our_triplets);
#line 45 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_g_object_unref0 (variables);
#line 45 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	return self;
#line 799 "rygel-tracker-search-container.c"
}


RygelTrackerSearchContainer* rygel_tracker_search_container_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, RygelTrackerItemFactory* item_factory, RygelTrackerQueryTriplets* triplets, GeeArrayList* filters) {
#line 45 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	return rygel_tracker_search_container_construct (RYGEL_TRACKER_TYPE_SEARCH_CONTAINER, id, parent, title, item_factory, triplets, filters);
#line 806 "rygel-tracker-search-container.c"
}


static void rygel_tracker_search_container_real_get_children_data_free (gpointer _data) {
	RygelTrackerSearchContainerGetChildrenData* _data_;
	_data_ = _data;
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_g_free0 (_data_->sort_criteria);
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_g_object_unref0 (_data_->cancellable);
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_g_object_unref0 (_data_->result);
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_g_object_unref0 (_data_->self);
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	g_slice_free (RygelTrackerSearchContainerGetChildrenData, _data_);
#line 823 "rygel-tracker-search-container.c"
}


static void rygel_tracker_search_container_real_get_children (RygelMediaContainer* base, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelTrackerSearchContainer * self;
	RygelTrackerSearchContainerGetChildrenData* _data_;
	RygelTrackerSearchContainer* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	GCancellable* _tmp5_;
	GCancellable* _tmp6_;
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	self = (RygelTrackerSearchContainer*) base;
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_ = g_slice_new0 (RygelTrackerSearchContainerGetChildrenData);
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_tracker_search_container_real_get_children);
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_tracker_search_container_real_get_children_data_free);
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->self = _tmp0_;
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp1_ = offset;
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->offset = _tmp1_;
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp2_ = max_count;
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->max_count = _tmp2_;
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp3_ = sort_criteria;
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp4_ = g_strdup (_tmp3_);
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->sort_criteria = _tmp4_;
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp5_ = cancellable;
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp6_ = _g_object_ref0 (_tmp5_);
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->cancellable = _tmp6_;
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	rygel_tracker_search_container_real_get_children_co (_data_);
#line 871 "rygel-tracker-search-container.c"
}


static RygelMediaObjects* rygel_tracker_search_container_real_get_children_finish (RygelMediaContainer* base, GAsyncResult* _res_, GError** error) {
	RygelMediaObjects* result;
	RygelTrackerSearchContainerGetChildrenData* _data_;
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		return NULL;
#line 882 "rygel-tracker-search-container.c"
	}
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	result = _data_->result;
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->result = NULL;
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	return result;
#line 892 "rygel-tracker-search-container.c"
}


static void rygel_tracker_search_container_get_children_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelTrackerSearchContainerGetChildrenData* _data_;
#line 120 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_ = _user_data_;
#line 120 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_source_object_ = source_object;
#line 120 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_res_ = _res_;
#line 120 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	rygel_tracker_search_container_real_get_children_co (_data_);
#line 906 "rygel-tracker-search-container.c"
}


static gboolean rygel_tracker_search_container_real_get_children_co (RygelTrackerSearchContainerGetChildrenData* _data_) {
#line 108 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	switch (_data_->_state_) {
#line 108 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		case 0:
#line 915 "rygel-tracker-search-container.c"
		goto _state_0;
#line 108 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		case 1:
#line 919 "rygel-tracker-search-container.c"
		goto _state_1;
		default:
#line 108 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		g_assert_not_reached ();
#line 924 "rygel-tracker-search-container.c"
	}
	_state_0:
#line 113 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_tmp0_ = rygel_relational_expression_new ();
#line 113 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->expression = _data_->_tmp0_;
#line 114 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	((RygelSearchExpression*) _data_->expression)->op = GINT_TO_POINTER (GUPNP_SEARCH_CRITERIA_OP_EQ);
#line 115 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_tmp1_ = g_strdup ("@parentID");
#line 115 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_g_free0 (((RygelSearchExpression*) _data_->expression)->operand1);
#line 115 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	((RygelSearchExpression*) _data_->expression)->operand1 = _data_->_tmp1_;
#line 116 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_tmp2_ = ((RygelMediaObject*) _data_->self)->id;
#line 116 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_tmp3_ = g_strdup (_data_->_tmp2_);
#line 116 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_g_free0 (((RygelSearchExpression*) _data_->expression)->operand2);
#line 116 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	((RygelSearchExpression*) _data_->expression)->operand2 = _data_->_tmp3_;
#line 120 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_tmp4_ = _data_->sort_criteria;
#line 120 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_tmp5_ = _data_->offset;
#line 120 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_tmp6_ = _data_->max_count;
#line 120 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_tmp7_ = _data_->cancellable;
#line 120 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_tmp8_ = 0U;
#line 120 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_state_ = 1;
#line 120 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	rygel_tracker_search_container_execute_query (_data_->self, (RygelSearchExpression*) _data_->expression, _data_->_tmp4_, _data_->_tmp5_, _data_->_tmp6_, _data_->_tmp7_, rygel_tracker_search_container_get_children_ready, _data_);
#line 120 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	return FALSE;
#line 963 "rygel-tracker-search-container.c"
	_state_1:
#line 120 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_tmp9_ = NULL;
#line 120 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_tmp9_ = rygel_tracker_search_container_execute_query_finish (_data_->self, _data_->_res_, &_data_->_tmp8_, &_data_->_inner_error_);
#line 120 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->total_matches = _data_->_tmp8_;
#line 120 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_tmp10_ = _data_->_tmp9_;
#line 120 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	if (_data_->_inner_error_ != NULL) {
#line 120 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 120 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		g_error_free (_data_->_inner_error_);
#line 120 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_rygel_search_expression_unref0 (_data_->expression);
#line 120 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		if (_data_->_state_ == 0) {
#line 120 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 985 "rygel-tracker-search-container.c"
		} else {
#line 120 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 989 "rygel-tracker-search-container.c"
		}
#line 120 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		g_object_unref (_data_->_async_result);
#line 120 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		return FALSE;
#line 995 "rygel-tracker-search-container.c"
	}
#line 120 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->result = _data_->_tmp10_;
#line 120 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_rygel_search_expression_unref0 (_data_->expression);
#line 120 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	if (_data_->_state_ == 0) {
#line 120 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1005 "rygel-tracker-search-container.c"
	} else {
#line 120 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1009 "rygel-tracker-search-container.c"
	}
#line 120 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	g_object_unref (_data_->_async_result);
#line 120 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	return FALSE;
#line 108 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_rygel_search_expression_unref0 (_data_->expression);
#line 108 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	if (_data_->_state_ == 0) {
#line 108 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1021 "rygel-tracker-search-container.c"
	} else {
#line 108 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1025 "rygel-tracker-search-container.c"
	}
#line 108 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	g_object_unref (_data_->_async_result);
#line 108 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	return FALSE;
#line 1031 "rygel-tracker-search-container.c"
}


static void rygel_tracker_search_container_execute_query_data_free (gpointer _data) {
	RygelTrackerSearchContainerExecuteQueryData* _data_;
	_data_ = _data;
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_rygel_search_expression_unref0 (_data_->expression);
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_g_free0 (_data_->sort_criteria);
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_g_object_unref0 (_data_->cancellable);
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_g_object_unref0 (_data_->result);
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_g_object_unref0 (_data_->self);
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	g_slice_free (RygelTrackerSearchContainerExecuteQueryData, _data_);
#line 1050 "rygel-tracker-search-container.c"
}


static gpointer _rygel_search_expression_ref0 (gpointer self) {
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	return self ? rygel_search_expression_ref (self) : NULL;
#line 1057 "rygel-tracker-search-container.c"
}


void rygel_tracker_search_container_execute_query (RygelTrackerSearchContainer* self, RygelSearchExpression* expression, const gchar* sort_criteria, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelTrackerSearchContainerExecuteQueryData* _data_;
	RygelTrackerSearchContainer* _tmp0_;
	RygelSearchExpression* _tmp1_;
	RygelSearchExpression* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	guint _tmp5_;
	guint _tmp6_;
	GCancellable* _tmp7_;
	GCancellable* _tmp8_;
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_ = g_slice_new0 (RygelTrackerSearchContainerExecuteQueryData);
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_tracker_search_container_execute_query);
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_tracker_search_container_execute_query_data_free);
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->self = _tmp0_;
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp1_ = expression;
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp2_ = _rygel_search_expression_ref0 (_tmp1_);
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->expression = _tmp2_;
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp3_ = sort_criteria;
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp4_ = g_strdup (_tmp3_);
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->sort_criteria = _tmp4_;
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp5_ = offset;
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->offset = _tmp5_;
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp6_ = max_count;
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->max_count = _tmp6_;
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp7_ = cancellable;
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp8_ = _g_object_ref0 (_tmp7_);
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->cancellable = _tmp8_;
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	rygel_tracker_search_container_execute_query_co (_data_);
#line 1110 "rygel-tracker-search-container.c"
}


RygelMediaObjects* rygel_tracker_search_container_execute_query_finish (RygelTrackerSearchContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error) {
	RygelMediaObjects* result;
	RygelTrackerSearchContainerExecuteQueryData* _data_;
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		return NULL;
#line 1121 "rygel-tracker-search-container.c"
	}
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	if (total_matches) {
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		*total_matches = _data_->total_matches;
#line 1129 "rygel-tracker-search-container.c"
	}
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	result = _data_->result;
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->result = NULL;
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	return result;
#line 1137 "rygel-tracker-search-container.c"
}


static void rygel_tracker_search_container_execute_query_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelTrackerSearchContainerExecuteQueryData* _data_;
#line 143 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_ = _user_data_;
#line 143 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_source_object_ = source_object;
#line 143 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_res_ = _res_;
#line 143 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	rygel_tracker_search_container_execute_query_co (_data_);
#line 1151 "rygel-tracker-search-container.c"
}


static gboolean rygel_tracker_search_container_execute_query_co (RygelTrackerSearchContainerExecuteQueryData* _data_) {
#line 128 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	switch (_data_->_state_) {
#line 128 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		case 0:
#line 1160 "rygel-tracker-search-container.c"
		goto _state_0;
#line 128 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		case 1:
#line 1164 "rygel-tracker-search-container.c"
		goto _state_1;
#line 128 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		case 2:
#line 1168 "rygel-tracker-search-container.c"
		goto _state_2;
		default:
#line 128 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		g_assert_not_reached ();
#line 1173 "rygel-tracker-search-container.c"
	}
	_state_0:
#line 135 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_tmp0_ = rygel_media_objects_new ();
#line 135 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->results = _data_->_tmp0_;
#line 137 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_tmp1_ = _data_->expression;
#line 137 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_tmp2_ = _data_->offset;
#line 137 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_tmp3_ = _data_->max_count;
#line 137 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_tmp4_ = _data_->sort_criteria;
#line 137 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_tmp5_ = NULL;
#line 137 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_tmp5_ = rygel_tracker_search_container_create_query (_data_->self, RYGEL_IS_RELATIONAL_EXPRESSION (_data_->_tmp1_) ? ((RygelRelationalExpression*) _data_->_tmp1_) : NULL, (gint) _data_->_tmp2_, (gint) _data_->_tmp3_, _data_->_tmp4_);
#line 137 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->query = _data_->_tmp5_;
#line 142 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_tmp6_ = _data_->query;
#line 142 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	if (_data_->_tmp6_ != NULL) {
#line 143 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_data_->_tmp7_ = _data_->query;
#line 143 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_data_->_tmp8_ = _data_->self->priv->resources;
#line 143 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_data_->_state_ = 1;
#line 143 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		rygel_tracker_query_execute ((RygelTrackerQuery*) _data_->_tmp7_, _data_->_tmp8_, rygel_tracker_search_container_execute_query_ready, _data_);
#line 143 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		return FALSE;
#line 1208 "rygel-tracker-search-container.c"
		_state_1:
#line 143 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		rygel_tracker_query_execute_finish ((RygelTrackerQuery*) _data_->_tmp7_, _data_->_res_, &_data_->_inner_error_);
#line 143 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		if (_data_->_inner_error_ != NULL) {
#line 143 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 143 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			g_error_free (_data_->_inner_error_);
#line 143 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_rygel_tracker_query_unref0 (_data_->query);
#line 143 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_g_object_unref0 (_data_->results);
#line 143 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			if (_data_->_state_ == 0) {
#line 143 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1226 "rygel-tracker-search-container.c"
			} else {
#line 143 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 1230 "rygel-tracker-search-container.c"
			}
#line 143 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			g_object_unref (_data_->_async_result);
#line 143 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			return FALSE;
#line 1236 "rygel-tracker-search-container.c"
		}
#line 146 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		while (TRUE) {
#line 146 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_data_->_tmp9_ = _data_->query;
#line 146 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_data_->_tmp10_ = _data_->_tmp9_->result;
#line 146 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_data_->_state_ = 2;
#line 146 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			tracker_sparql_cursor_next_async (_data_->_tmp10_, NULL, rygel_tracker_search_container_execute_query_ready, _data_);
#line 146 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			return FALSE;
#line 1250 "rygel-tracker-search-container.c"
			_state_2:
#line 146 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_data_->_tmp11_ = FALSE;
#line 146 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_data_->_tmp11_ = tracker_sparql_cursor_next_finish (_data_->_tmp10_, _data_->_res_, &_data_->_inner_error_);
#line 146 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_data_->_tmp12_ = _data_->_tmp11_;
#line 146 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			if (_data_->_inner_error_ != NULL) {
#line 146 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 146 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				g_error_free (_data_->_inner_error_);
#line 146 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				_rygel_tracker_query_unref0 (_data_->query);
#line 146 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				_g_object_unref0 (_data_->results);
#line 146 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				if (_data_->_state_ == 0) {
#line 146 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
					g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1272 "rygel-tracker-search-container.c"
				} else {
#line 146 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
					g_simple_async_result_complete (_data_->_async_result);
#line 1276 "rygel-tracker-search-container.c"
				}
#line 146 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				g_object_unref (_data_->_async_result);
#line 146 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				return FALSE;
#line 1282 "rygel-tracker-search-container.c"
			}
#line 146 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			if (!_data_->_tmp12_) {
#line 146 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				break;
#line 1288 "rygel-tracker-search-container.c"
			}
#line 147 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_data_->_tmp13_ = _data_->query;
#line 147 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_data_->_tmp14_ = _data_->_tmp13_->result;
#line 147 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_data_->_tmp15_ = NULL;
#line 147 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_data_->_tmp15_ = tracker_sparql_cursor_get_string (_data_->_tmp14_, 0, NULL);
#line 147 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_data_->_tmp16_ = g_strdup (_data_->_tmp15_);
#line 147 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_data_->id = _data_->_tmp16_;
#line 148 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_data_->_tmp17_ = _data_->id;
#line 148 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_data_->_tmp18_ = NULL;
#line 148 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_data_->_tmp18_ = rygel_tracker_search_container_create_child_id_for_urn (_data_->self, _data_->_tmp17_);
#line 148 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_g_free0 (_data_->id);
#line 148 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_data_->id = _data_->_tmp18_;
#line 149 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_data_->_tmp19_ = _data_->query;
#line 149 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_data_->_tmp20_ = _data_->_tmp19_->result;
#line 149 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_data_->_tmp21_ = NULL;
#line 149 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_data_->_tmp21_ = tracker_sparql_cursor_get_string (_data_->_tmp20_, 1, NULL);
#line 149 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_data_->_tmp22_ = g_strdup (_data_->_tmp21_);
#line 149 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_data_->uri = _data_->_tmp22_;
#line 151 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_data_->_tmp23_ = _data_->self->item_factory;
#line 151 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_data_->_tmp24_ = _data_->id;
#line 151 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_data_->_tmp25_ = _data_->uri;
#line 151 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_data_->_tmp26_ = _data_->query;
#line 151 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_data_->_tmp27_ = _data_->_tmp26_->result;
#line 151 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_data_->_tmp28_ = NULL;
#line 151 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_data_->_tmp28_ = rygel_tracker_item_factory_create (_data_->_tmp23_, _data_->_tmp24_, _data_->_tmp25_, _data_->self, _data_->_tmp27_, &_data_->_inner_error_);
#line 151 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_data_->item = _data_->_tmp28_;
#line 151 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			if (_data_->_inner_error_ != NULL) {
#line 151 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 151 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				g_error_free (_data_->_inner_error_);
#line 151 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				_g_free0 (_data_->uri);
#line 151 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				_g_free0 (_data_->id);
#line 151 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				_rygel_tracker_query_unref0 (_data_->query);
#line 151 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				_g_object_unref0 (_data_->results);
#line 151 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				if (_data_->_state_ == 0) {
#line 151 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
					g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1358 "rygel-tracker-search-container.c"
				} else {
#line 151 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
					g_simple_async_result_complete (_data_->_async_result);
#line 1362 "rygel-tracker-search-container.c"
				}
#line 151 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				g_object_unref (_data_->_async_result);
#line 151 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				return FALSE;
#line 1368 "rygel-tracker-search-container.c"
			}
#line 155 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_data_->_tmp29_ = _data_->results;
#line 155 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_data_->_tmp30_ = _data_->item;
#line 155 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp29_, (RygelMediaObject*) _data_->_tmp30_);
#line 146 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_g_object_unref0 (_data_->item);
#line 146 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_g_free0 (_data_->uri);
#line 146 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_g_free0 (_data_->id);
#line 1382 "rygel-tracker-search-container.c"
		}
	}
#line 159 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_tmp31_ = _data_->results;
#line 159 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_tmp32_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp31_);
#line 159 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_tmp33_ = _data_->_tmp32_;
#line 159 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->total_matches = (guint) _data_->_tmp33_;
#line 161 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->result = _data_->results;
#line 161 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_rygel_tracker_query_unref0 (_data_->query);
#line 161 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	if (_data_->_state_ == 0) {
#line 161 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1401 "rygel-tracker-search-container.c"
	} else {
#line 161 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1405 "rygel-tracker-search-container.c"
	}
#line 161 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	g_object_unref (_data_->_async_result);
#line 161 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	return FALSE;
#line 128 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_rygel_tracker_query_unref0 (_data_->query);
#line 128 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_g_object_unref0 (_data_->results);
#line 128 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	if (_data_->_state_ == 0) {
#line 128 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1419 "rygel-tracker-search-container.c"
	} else {
#line 128 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1423 "rygel-tracker-search-container.c"
	}
#line 128 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	g_object_unref (_data_->_async_result);
#line 128 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	return FALSE;
#line 1429 "rygel-tracker-search-container.c"
}


static void rygel_tracker_search_container_real_find_object_data_free (gpointer _data) {
	RygelTrackerSearchContainerFindObjectData* _data_;
	_data_ = _data;
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_g_free0 (_data_->id);
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_g_object_unref0 (_data_->cancellable);
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_g_object_unref0 (_data_->result);
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_g_object_unref0 (_data_->self);
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	g_slice_free (RygelTrackerSearchContainerFindObjectData, _data_);
#line 1446 "rygel-tracker-search-container.c"
}


static void rygel_tracker_search_container_real_find_object (RygelMediaContainer* base, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelTrackerSearchContainer * self;
	RygelTrackerSearchContainerFindObjectData* _data_;
	RygelTrackerSearchContainer* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	GCancellable* _tmp3_;
	GCancellable* _tmp4_;
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	self = (RygelTrackerSearchContainer*) base;
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_ = g_slice_new0 (RygelTrackerSearchContainerFindObjectData);
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_tracker_search_container_real_find_object);
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_tracker_search_container_real_find_object_data_free);
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->self = _tmp0_;
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp1_ = id;
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->id = _tmp2_;
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp3_ = cancellable;
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->cancellable = _tmp4_;
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	rygel_tracker_search_container_real_find_object_co (_data_);
#line 1484 "rygel-tracker-search-container.c"
}


static RygelMediaObject* rygel_tracker_search_container_real_find_object_finish (RygelMediaContainer* base, GAsyncResult* _res_, GError** error) {
	RygelMediaObject* result;
	RygelTrackerSearchContainerFindObjectData* _data_;
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		return NULL;
#line 1495 "rygel-tracker-search-container.c"
	}
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	result = _data_->result;
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->result = NULL;
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	return result;
#line 1505 "rygel-tracker-search-container.c"
}


static void rygel_tracker_search_container_find_object_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelTrackerSearchContainerFindObjectData* _data_;
#line 177 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_ = _user_data_;
#line 177 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_source_object_ = source_object;
#line 177 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_res_ = _res_;
#line 177 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	rygel_tracker_search_container_real_find_object_co (_data_);
#line 1519 "rygel-tracker-search-container.c"
}


static gboolean rygel_tracker_search_container_real_find_object_co (RygelTrackerSearchContainerFindObjectData* _data_) {
#line 164 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	switch (_data_->_state_) {
#line 164 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		case 0:
#line 1528 "rygel-tracker-search-container.c"
		goto _state_0;
#line 164 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		case 1:
#line 1532 "rygel-tracker-search-container.c"
		goto _state_1;
		default:
#line 164 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		g_assert_not_reached ();
#line 1537 "rygel-tracker-search-container.c"
	}
	_state_0:
#line 167 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_tmp0_ = _data_->id;
#line 167 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_tmp1_ = FALSE;
#line 167 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_tmp1_ = rygel_tracker_search_container_is_our_child (_data_->self, _data_->_tmp0_);
#line 167 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	if (!_data_->_tmp1_) {
#line 168 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_data_->result = NULL;
#line 168 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		if (_data_->_state_ == 0) {
#line 168 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1554 "rygel-tracker-search-container.c"
		} else {
#line 168 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1558 "rygel-tracker-search-container.c"
		}
#line 168 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		g_object_unref (_data_->_async_result);
#line 168 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		return FALSE;
#line 1564 "rygel-tracker-search-container.c"
	}
#line 171 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_tmp2_ = rygel_relational_expression_new ();
#line 171 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->expression = _data_->_tmp2_;
#line 172 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_tmp3_ = _data_->expression;
#line 172 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	((RygelSearchExpression*) _data_->_tmp3_)->op = GINT_TO_POINTER (GUPNP_SEARCH_CRITERIA_OP_EQ);
#line 173 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_tmp4_ = _data_->expression;
#line 173 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_tmp5_ = g_strdup ("@id");
#line 173 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_g_free0 (((RygelSearchExpression*) _data_->_tmp4_)->operand1);
#line 173 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	((RygelSearchExpression*) _data_->_tmp4_)->operand1 = _data_->_tmp5_;
#line 174 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_tmp6_ = _data_->expression;
#line 174 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_tmp7_ = _data_->id;
#line 174 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_tmp8_ = g_strdup (_data_->_tmp7_);
#line 174 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_g_free0 (((RygelSearchExpression*) _data_->_tmp6_)->operand2);
#line 174 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	((RygelSearchExpression*) _data_->_tmp6_)->operand2 = _data_->_tmp8_;
#line 177 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_tmp9_ = _data_->expression;
#line 177 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_tmp10_ = _data_->cancellable;
#line 177 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_tmp11_ = 0U;
#line 177 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_state_ = 1;
#line 177 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	rygel_tracker_search_container_execute_query (_data_->self, (RygelSearchExpression*) _data_->_tmp9_, "", (guint) 0, (guint) 1, _data_->_tmp10_, rygel_tracker_search_container_find_object_ready, _data_);
#line 177 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	return FALSE;
#line 1604 "rygel-tracker-search-container.c"
	_state_1:
#line 177 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_tmp12_ = NULL;
#line 177 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_tmp12_ = rygel_tracker_search_container_execute_query_finish (_data_->self, _data_->_res_, &_data_->_tmp11_, &_data_->_inner_error_);
#line 177 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->total_matches = _data_->_tmp11_;
#line 177 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->results = _data_->_tmp12_;
#line 177 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	if (_data_->_inner_error_ != NULL) {
#line 177 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 177 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		g_error_free (_data_->_inner_error_);
#line 177 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_rygel_search_expression_unref0 (_data_->expression);
#line 177 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		if (_data_->_state_ == 0) {
#line 177 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1626 "rygel-tracker-search-container.c"
		} else {
#line 177 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1630 "rygel-tracker-search-container.c"
		}
#line 177 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		g_object_unref (_data_->_async_result);
#line 177 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		return FALSE;
#line 1636 "rygel-tracker-search-container.c"
	}
#line 183 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_tmp13_ = _data_->results;
#line 183 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_tmp14_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp13_);
#line 183 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_tmp15_ = _data_->_tmp14_;
#line 183 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	if (_data_->_tmp15_ > 0) {
#line 184 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_data_->_tmp16_ = _data_->results;
#line 184 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_data_->_tmp17_ = NULL;
#line 184 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_data_->_tmp17_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp16_, 0);
#line 184 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_data_->result = (RygelMediaObject*) _data_->_tmp17_;
#line 184 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_g_object_unref0 (_data_->results);
#line 184 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_rygel_search_expression_unref0 (_data_->expression);
#line 184 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		if (_data_->_state_ == 0) {
#line 184 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1662 "rygel-tracker-search-container.c"
		} else {
#line 184 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1666 "rygel-tracker-search-container.c"
		}
#line 184 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		g_object_unref (_data_->_async_result);
#line 184 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		return FALSE;
#line 1672 "rygel-tracker-search-container.c"
	} else {
#line 186 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_data_->result = NULL;
#line 186 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_g_object_unref0 (_data_->results);
#line 186 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_rygel_search_expression_unref0 (_data_->expression);
#line 186 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		if (_data_->_state_ == 0) {
#line 186 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1684 "rygel-tracker-search-container.c"
		} else {
#line 186 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1688 "rygel-tracker-search-container.c"
		}
#line 186 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		g_object_unref (_data_->_async_result);
#line 186 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		return FALSE;
#line 1694 "rygel-tracker-search-container.c"
	}
#line 164 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_g_object_unref0 (_data_->results);
#line 164 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_rygel_search_expression_unref0 (_data_->expression);
#line 164 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	if (_data_->_state_ == 0) {
#line 164 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1704 "rygel-tracker-search-container.c"
	} else {
#line 164 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1708 "rygel-tracker-search-container.c"
	}
#line 164 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	g_object_unref (_data_->_async_result);
#line 164 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	return FALSE;
#line 1714 "rygel-tracker-search-container.c"
}


gchar* rygel_tracker_search_container_create_child_id_for_urn (RygelTrackerSearchContainer* self, const gchar* urn) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
#line 190 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 190 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	g_return_val_if_fail (urn != NULL, NULL);
#line 191 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp0_ = ((RygelMediaObject*) self)->id;
#line 191 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp1_ = g_strconcat (_tmp0_, ",", NULL);
#line 191 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp2_ = _tmp1_;
#line 191 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp3_ = urn;
#line 191 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp4_ = g_strconcat (_tmp2_, _tmp3_, NULL);
#line 191 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp5_ = _tmp4_;
#line 191 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_g_free0 (_tmp2_);
#line 191 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	result = _tmp5_;
#line 191 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	return result;
#line 1748 "rygel-tracker-search-container.c"
}


gchar* rygel_tracker_search_container_get_item_info (RygelTrackerSearchContainer* self, const gchar* item_id, gchar** parent_id) {
	gchar* _vala_parent_id = NULL;
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_ = NULL;
	gchar** tokens;
	gint tokens_length1;
	gint _tokens_size_;
	gboolean _tmp3_ = FALSE;
	gchar** _tmp4_;
	gint _tmp4__length1;
	const gchar* _tmp5_;
	gboolean _tmp8_;
#line 196 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 196 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	g_return_val_if_fail (item_id != NULL, NULL);
#line 198 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp0_ = item_id;
#line 198 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp2_ = _tmp1_ = g_strsplit (_tmp0_, ",", 2);
#line 198 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	tokens = _tmp2_;
#line 198 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	tokens_length1 = _vala_array_length (_tmp1_);
#line 198 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tokens_size_ = tokens_length1;
#line 200 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp4_ = tokens;
#line 200 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp4__length1 = tokens_length1;
#line 200 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp5_ = _tmp4_[0];
#line 200 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	if (_tmp5_ != NULL) {
#line 1788 "rygel-tracker-search-container.c"
		gchar** _tmp6_;
		gint _tmp6__length1;
		const gchar* _tmp7_;
#line 200 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp6_ = tokens;
#line 200 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp6__length1 = tokens_length1;
#line 200 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp7_ = _tmp6_[1];
#line 200 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp3_ = _tmp7_ != NULL;
#line 1800 "rygel-tracker-search-container.c"
	} else {
#line 200 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp3_ = FALSE;
#line 1804 "rygel-tracker-search-container.c"
	}
#line 200 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp8_ = _tmp3_;
#line 200 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	if (_tmp8_) {
#line 1810 "rygel-tracker-search-container.c"
		gchar** _tmp9_;
		gint _tmp9__length1;
		const gchar* _tmp10_;
		gchar* _tmp11_;
		gchar** _tmp12_;
		gint _tmp12__length1;
		const gchar* _tmp13_;
		gchar* _tmp14_;
#line 201 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp9_ = tokens;
#line 201 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp9__length1 = tokens_length1;
#line 201 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp10_ = _tmp9_[0];
#line 201 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp11_ = g_strdup (_tmp10_);
#line 201 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_g_free0 (_vala_parent_id);
#line 201 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_vala_parent_id = _tmp11_;
#line 203 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp12_ = tokens;
#line 203 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp12__length1 = tokens_length1;
#line 203 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp13_ = _tmp12_[1];
#line 203 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp14_ = g_strdup (_tmp13_);
#line 203 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		result = _tmp14_;
#line 203 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
#line 203 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		if (parent_id) {
#line 203 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			*parent_id = _vala_parent_id;
#line 1847 "rygel-tracker-search-container.c"
		} else {
#line 203 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_g_free0 (_vala_parent_id);
#line 1851 "rygel-tracker-search-container.c"
		}
#line 203 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		return result;
#line 1855 "rygel-tracker-search-container.c"
	} else {
#line 205 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_g_free0 (_vala_parent_id);
#line 205 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_vala_parent_id = NULL;
#line 207 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		result = NULL;
#line 207 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
#line 207 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		if (parent_id) {
#line 207 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			*parent_id = _vala_parent_id;
#line 1869 "rygel-tracker-search-container.c"
		} else {
#line 207 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_g_free0 (_vala_parent_id);
#line 1873 "rygel-tracker-search-container.c"
		}
#line 207 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		return result;
#line 1877 "rygel-tracker-search-container.c"
	}
#line 196 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
#line 196 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	if (parent_id) {
#line 196 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		*parent_id = _vala_parent_id;
#line 1885 "rygel-tracker-search-container.c"
	} else {
#line 196 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_g_free0 (_vala_parent_id);
#line 1889 "rygel-tracker-search-container.c"
	}
}


static void rygel_tracker_search_container_get_children_count_data_free (gpointer _data) {
	RygelTrackerSearchContainerGetChildrenCountData* _data_;
	_data_ = _data;
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_g_object_unref0 (_data_->self);
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	g_slice_free (RygelTrackerSearchContainerGetChildrenCountData, _data_);
#line 1901 "rygel-tracker-search-container.c"
}


void rygel_tracker_search_container_get_children_count (RygelTrackerSearchContainer* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelTrackerSearchContainerGetChildrenCountData* _data_;
	RygelTrackerSearchContainer* _tmp0_;
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_ = g_slice_new0 (RygelTrackerSearchContainerGetChildrenCountData);
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_tracker_search_container_get_children_count);
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_tracker_search_container_get_children_count_data_free);
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->self = _tmp0_;
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	rygel_tracker_search_container_get_children_count_co (_data_);
#line 1920 "rygel-tracker-search-container.c"
}


void rygel_tracker_search_container_get_children_count_finish (RygelTrackerSearchContainer* self, GAsyncResult* _res_) {
	RygelTrackerSearchContainerGetChildrenCountData* _data_;
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 1928 "rygel-tracker-search-container.c"
}


static void rygel_tracker_search_container_get_children_count_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelTrackerSearchContainerGetChildrenCountData* _data_;
#line 220 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_ = _user_data_;
#line 220 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_source_object_ = source_object;
#line 220 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_res_ = _res_;
#line 220 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	rygel_tracker_search_container_get_children_count_co (_data_);
#line 1942 "rygel-tracker-search-container.c"
}


static gboolean rygel_tracker_search_container_get_children_count_co (RygelTrackerSearchContainerGetChildrenCountData* _data_) {
#line 211 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	switch (_data_->_state_) {
#line 211 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		case 0:
#line 1951 "rygel-tracker-search-container.c"
		goto _state_0;
#line 211 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		case 1:
#line 1955 "rygel-tracker-search-container.c"
		goto _state_1;
		default:
#line 211 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		g_assert_not_reached ();
#line 1960 "rygel-tracker-search-container.c"
	}
	_state_0:
	{
#line 213 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_data_->_tmp0_ = _data_->self->query;
#line 213 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_data_->_tmp1_ = rygel_tracker_selection_query_new_clone (_data_->_tmp0_);
#line 213 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_data_->query = _data_->_tmp1_;
#line 215 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_data_->_tmp2_ = _data_->query;
#line 215 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_data_->_tmp3_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
#line 215 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_g_object_unref0 (_data_->_tmp2_->variables);
#line 215 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_data_->_tmp2_->variables = _data_->_tmp3_;
#line 216 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_data_->_tmp4_ = _data_->query;
#line 216 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_data_->_tmp5_ = _data_->_tmp4_->variables;
#line 216 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp5_, "COUNT(" RYGEL_TRACKER_SELECTION_QUERY_ITEM_VARIABLE ") AS x");
#line 220 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_data_->_tmp6_ = _data_->query;
#line 220 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_data_->_tmp7_ = _data_->self->priv->resources;
#line 220 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_data_->_state_ = 1;
#line 220 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		rygel_tracker_query_execute ((RygelTrackerQuery*) _data_->_tmp6_, _data_->_tmp7_, rygel_tracker_search_container_get_children_count_ready, _data_);
#line 220 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		return FALSE;
#line 1994 "rygel-tracker-search-container.c"
		_state_1:
#line 220 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		rygel_tracker_query_execute_finish ((RygelTrackerQuery*) _data_->_tmp6_, _data_->_res_, &_data_->_inner_error_);
#line 220 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		if (_data_->_inner_error_ != NULL) {
#line 220 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_rygel_tracker_query_unref0 (_data_->query);
#line 2002 "rygel-tracker-search-container.c"
			goto __catch5_g_error;
		}
#line 222 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_data_->_tmp8_ = _data_->query;
#line 222 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_data_->_tmp9_ = _data_->_tmp8_->result;
#line 222 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_data_->_tmp10_ = FALSE;
#line 222 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_data_->_tmp10_ = tracker_sparql_cursor_next (_data_->_tmp9_, NULL, &_data_->_inner_error_);
#line 222 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_data_->_tmp11_ = _data_->_tmp10_;
#line 222 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		if (_data_->_inner_error_ != NULL) {
#line 222 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_rygel_tracker_query_unref0 (_data_->query);
#line 2019 "rygel-tracker-search-container.c"
			goto __catch5_g_error;
		}
#line 222 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		if (_data_->_tmp11_) {
#line 223 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_data_->_tmp12_ = _data_->query;
#line 223 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_data_->_tmp13_ = _data_->_tmp12_->result;
#line 223 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_data_->_tmp14_ = NULL;
#line 223 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_data_->_tmp14_ = tracker_sparql_cursor_get_string (_data_->_tmp13_, 0, NULL);
#line 223 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_data_->_tmp15_ = 0;
#line 223 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_data_->_tmp15_ = atoi (_data_->_tmp14_);
#line 223 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			((RygelMediaContainer*) _data_->self)->child_count = _data_->_tmp15_;
#line 224 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			rygel_media_container_updated ((RygelMediaContainer*) _data_->self);
#line 2040 "rygel-tracker-search-container.c"
		}
#line 212 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_rygel_tracker_query_unref0 (_data_->query);
#line 2044 "rygel-tracker-search-container.c"
	}
	goto __finally5;
	__catch5_g_error:
	{
#line 212 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_data_->_error_ = _data_->_inner_error_;
#line 212 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_data_->_inner_error_ = NULL;
#line 228 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_data_->_tmp16_ = NULL;
#line 228 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_data_->_tmp16_ = _ ("Error getting item count under category '%s': %s");
#line 228 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_data_->_tmp17_ = _data_->self->item_factory;
#line 228 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_data_->_tmp18_ = _data_->_tmp17_->category;
#line 228 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_data_->_tmp19_ = _data_->_error_;
#line 228 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_data_->_tmp20_ = _data_->_tmp19_->message;
#line 228 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		g_critical (_data_->_tmp16_, _data_->_tmp18_, _data_->_tmp20_);
#line 232 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_g_error_free0 (_data_->_error_);
#line 232 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		if (_data_->_state_ == 0) {
#line 232 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2073 "rygel-tracker-search-container.c"
		} else {
#line 232 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 2077 "rygel-tracker-search-container.c"
		}
#line 232 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		g_object_unref (_data_->_async_result);
#line 232 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		return FALSE;
#line 2083 "rygel-tracker-search-container.c"
	}
	__finally5:
#line 212 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	if (_data_->_inner_error_ != NULL) {
#line 212 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 212 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		g_clear_error (&_data_->_inner_error_);
#line 212 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		return FALSE;
#line 2094 "rygel-tracker-search-container.c"
	}
#line 211 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	if (_data_->_state_ == 0) {
#line 211 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2100 "rygel-tracker-search-container.c"
	} else {
#line 211 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 2104 "rygel-tracker-search-container.c"
	}
#line 211 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	g_object_unref (_data_->_async_result);
#line 211 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	return FALSE;
#line 2110 "rygel-tracker-search-container.c"
}


static gboolean rygel_tracker_search_container_is_our_child (RygelTrackerSearchContainer* self, const gchar* id) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_;
#line 236 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 236 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	g_return_val_if_fail (id != NULL, FALSE);
#line 237 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp0_ = id;
#line 237 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp1_ = ((RygelMediaObject*) self)->id;
#line 237 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp2_ = g_strconcat (_tmp1_, ",", NULL);
#line 237 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp3_ = _tmp2_;
#line 237 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp4_ = g_str_has_prefix (_tmp0_, _tmp3_);
#line 237 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp5_ = _tmp4_;
#line 237 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_g_free0 (_tmp3_);
#line 237 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	result = _tmp5_;
#line 237 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	return result;
#line 2144 "rygel-tracker-search-container.c"
}


static RygelTrackerSelectionQuery* rygel_tracker_search_container_create_query (RygelTrackerSearchContainer* self, RygelRelationalExpression* expression, gint offset, gint max_count, const gchar* sort_criteria) {
	RygelTrackerSelectionQuery* result = NULL;
	gboolean _tmp0_ = FALSE;
	RygelRelationalExpression* _tmp1_;
	gconstpointer _tmp2_;
	gboolean _tmp8_;
	RygelTrackerSelectionQuery* query = NULL;
	gboolean _tmp9_ = FALSE;
	const gchar* _tmp10_;
	gboolean _tmp12_;
	RygelRelationalExpression* _tmp17_;
	gconstpointer _tmp18_;
	RygelTrackerSelectionQuery* _tmp30_;
	gint _tmp31_;
	RygelTrackerSelectionQuery* _tmp32_;
	gint _tmp33_;
#line 240 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 240 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	g_return_val_if_fail (sort_criteria != NULL, NULL);
#line 244 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp1_ = expression;
#line 244 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp2_ = ((RygelSearchExpression*) _tmp1_)->operand1;
#line 244 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	if (g_strcmp0 ((const gchar*) _tmp2_, "upnp:class") == 0) {
#line 2174 "rygel-tracker-search-container.c"
		RygelTrackerItemFactory* _tmp3_;
		const gchar* _tmp4_;
		RygelRelationalExpression* _tmp5_;
		gconstpointer _tmp6_;
		gboolean _tmp7_ = FALSE;
#line 245 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp3_ = self->item_factory;
#line 245 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp4_ = _tmp3_->upnp_class;
#line 245 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp5_ = expression;
#line 245 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp6_ = ((RygelSearchExpression*) _tmp5_)->operand2;
#line 245 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp7_ = g_str_has_prefix (_tmp4_, (const gchar*) _tmp6_);
#line 245 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp0_ = !_tmp7_;
#line 2192 "rygel-tracker-search-container.c"
	} else {
#line 244 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp0_ = FALSE;
#line 2196 "rygel-tracker-search-container.c"
	}
#line 244 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp8_ = _tmp0_;
#line 244 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	if (_tmp8_) {
#line 246 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		result = NULL;
#line 246 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		return result;
#line 2206 "rygel-tracker-search-container.c"
	}
#line 250 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp10_ = sort_criteria;
#line 250 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	if (_tmp10_ == NULL) {
#line 250 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp9_ = TRUE;
#line 2214 "rygel-tracker-search-container.c"
	} else {
		const gchar* _tmp11_;
#line 250 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp11_ = sort_criteria;
#line 250 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp9_ = g_strcmp0 (_tmp11_, "") == 0;
#line 2221 "rygel-tracker-search-container.c"
	}
#line 250 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp12_ = _tmp9_;
#line 250 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	if (_tmp12_) {
#line 2227 "rygel-tracker-search-container.c"
		RygelTrackerSelectionQuery* _tmp13_;
		RygelTrackerSelectionQuery* _tmp14_;
#line 251 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp13_ = self->query;
#line 251 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp14_ = rygel_tracker_selection_query_new_clone (_tmp13_);
#line 251 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_rygel_tracker_query_unref0 (query);
#line 251 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		query = _tmp14_;
#line 2238 "rygel-tracker-search-container.c"
	} else {
		const gchar* _tmp15_;
		RygelTrackerSelectionQuery* _tmp16_ = NULL;
#line 253 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp15_ = sort_criteria;
#line 253 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp16_ = rygel_tracker_search_container_create_sorted_query (self, _tmp15_);
#line 253 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_rygel_tracker_query_unref0 (query);
#line 253 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		query = _tmp16_;
#line 2250 "rygel-tracker-search-container.c"
	}
#line 256 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp17_ = expression;
#line 256 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp18_ = ((RygelSearchExpression*) _tmp17_)->operand1;
#line 256 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	if (g_strcmp0 ((const gchar*) _tmp18_, "@parentID") == 0) {
#line 2258 "rygel-tracker-search-container.c"
		RygelRelationalExpression* _tmp19_;
		const gchar* _tmp20_;
		gboolean _tmp21_ = FALSE;
#line 257 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp19_ = expression;
#line 257 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp20_ = ((RygelMediaObject*) self)->id;
#line 257 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp21_ = rygel_relational_expression_compare_string (_tmp19_, _tmp20_);
#line 257 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		if (!_tmp21_) {
#line 258 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			result = NULL;
#line 258 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_rygel_tracker_query_unref0 (query);
#line 258 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			return result;
#line 2276 "rygel-tracker-search-container.c"
		}
	} else {
		RygelRelationalExpression* _tmp22_;
		gconstpointer _tmp23_;
#line 260 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp22_ = expression;
#line 260 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp23_ = ((RygelSearchExpression*) _tmp22_)->operand1;
#line 260 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		if (g_strcmp0 ((const gchar*) _tmp23_, "upnp:class") != 0) {
#line 2287 "rygel-tracker-search-container.c"
			RygelRelationalExpression* _tmp24_;
			gchar* _tmp25_ = NULL;
			gchar* filter;
			const gchar* _tmp26_;
#line 261 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_tmp24_ = expression;
#line 261 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_tmp25_ = rygel_tracker_search_container_create_filter_for_child (self, _tmp24_);
#line 261 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			filter = _tmp25_;
#line 262 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_tmp26_ = filter;
#line 262 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			if (_tmp26_ != NULL) {
#line 2302 "rygel-tracker-search-container.c"
				RygelTrackerSelectionQuery* _tmp27_;
				GeeArrayList* _tmp28_;
				const gchar* _tmp29_;
#line 263 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				_tmp27_ = query;
#line 263 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				_tmp28_ = _tmp27_->filters;
#line 263 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				_tmp29_ = filter;
#line 263 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				gee_abstract_list_insert ((GeeAbstractList*) _tmp28_, 0, _tmp29_);
#line 2314 "rygel-tracker-search-container.c"
			} else {
#line 265 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				result = NULL;
#line 265 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				_g_free0 (filter);
#line 265 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				_rygel_tracker_query_unref0 (query);
#line 265 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				return result;
#line 2324 "rygel-tracker-search-container.c"
			}
#line 260 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_g_free0 (filter);
#line 2328 "rygel-tracker-search-container.c"
		}
	}
#line 269 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp30_ = query;
#line 269 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp31_ = offset;
#line 269 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp30_->offset = _tmp31_;
#line 270 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp32_ = query;
#line 270 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp33_ = max_count;
#line 270 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp32_->max_count = _tmp33_;
#line 272 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	result = query;
#line 272 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	return result;
#line 2347 "rygel-tracker-search-container.c"
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* end;
	gchar* _tmp3_;
#line 1338 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
	_tmp0_ = str;
#line 1338 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
	_tmp1_ = maxlen;
#line 1338 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
#line 1338 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
	end = _tmp2_;
#line 1339 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
	_tmp3_ = end;
#line 1339 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
	if (_tmp3_ == NULL) {
#line 2370 "rygel-tracker-search-container.c"
		glong _tmp4_;
#line 1340 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
		_tmp4_ = maxlen;
#line 1340 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
		result = _tmp4_;
#line 1340 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
		return result;
#line 2378 "rygel-tracker-search-container.c"
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
#line 1342 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
		_tmp5_ = end;
#line 1342 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
		_tmp6_ = str;
#line 1342 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
		result = (glong) (_tmp5_ - _tmp6_);
#line 1342 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
		return result;
#line 2390 "rygel-tracker-search-container.c"
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	gboolean _tmp3_;
	glong _tmp9_;
	glong _tmp15_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
#line 1349 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1351 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
	_tmp1_ = offset;
#line 1351 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
	if (_tmp1_ >= ((glong) 0)) {
#line 2415 "rygel-tracker-search-container.c"
		glong _tmp2_;
#line 1351 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
		_tmp2_ = len;
#line 1351 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
		_tmp0_ = _tmp2_ >= ((glong) 0);
#line 2421 "rygel-tracker-search-container.c"
	} else {
#line 1351 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 2425 "rygel-tracker-search-container.c"
	}
#line 1351 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
	_tmp3_ = _tmp0_;
#line 1351 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
	if (_tmp3_) {
#line 2431 "rygel-tracker-search-container.c"
		glong _tmp4_;
		glong _tmp5_;
		glong _tmp6_ = 0L;
#line 1353 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
		_tmp4_ = offset;
#line 1353 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
		_tmp5_ = len;
#line 1353 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
		_tmp6_ = string_strnlen ((gchar*) self, _tmp4_ + _tmp5_);
#line 1353 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
		string_length = _tmp6_;
#line 2443 "rygel-tracker-search-container.c"
	} else {
		gint _tmp7_;
		gint _tmp8_;
#line 1355 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
		_tmp7_ = strlen (self);
#line 1355 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
		_tmp8_ = _tmp7_;
#line 1355 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
		string_length = (glong) _tmp8_;
#line 2453 "rygel-tracker-search-container.c"
	}
#line 1358 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
	_tmp9_ = offset;
#line 1358 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
	if (_tmp9_ < ((glong) 0)) {
#line 2459 "rygel-tracker-search-container.c"
		glong _tmp10_;
		glong _tmp11_;
		glong _tmp12_;
#line 1359 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
		_tmp10_ = string_length;
#line 1359 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
		_tmp11_ = offset;
#line 1359 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
		offset = _tmp10_ + _tmp11_;
#line 1360 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
		_tmp12_ = offset;
#line 1360 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp12_ >= ((glong) 0), NULL);
#line 2473 "rygel-tracker-search-container.c"
	} else {
		glong _tmp13_;
		glong _tmp14_;
#line 1362 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
		_tmp13_ = offset;
#line 1362 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
		_tmp14_ = string_length;
#line 1362 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp13_ <= _tmp14_, NULL);
#line 2483 "rygel-tracker-search-container.c"
	}
#line 1364 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
	_tmp15_ = len;
#line 1364 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
	if (_tmp15_ < ((glong) 0)) {
#line 2489 "rygel-tracker-search-container.c"
		glong _tmp16_;
		glong _tmp17_;
#line 1365 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
		_tmp16_ = string_length;
#line 1365 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
		_tmp17_ = offset;
#line 1365 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
		len = _tmp16_ - _tmp17_;
#line 2498 "rygel-tracker-search-container.c"
	}
#line 1367 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
	_tmp18_ = offset;
#line 1367 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
	_tmp19_ = len;
#line 1367 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
	_tmp20_ = string_length;
#line 1367 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
	g_return_val_if_fail ((_tmp18_ + _tmp19_) <= _tmp20_, NULL);
#line 1368 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
	_tmp21_ = offset;
#line 1368 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
	_tmp22_ = len;
#line 1368 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
	_tmp23_ = g_strndup (((gchar*) self) + _tmp21_, (gsize) _tmp22_);
#line 1368 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
	result = _tmp23_;
#line 1368 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
	return result;
#line 2518 "rygel-tracker-search-container.c"
}


static gint string_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gint _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _result_;
	gchar* _tmp3_;
#line 1092 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 1092 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, 0);
#line 1093 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
	_tmp0_ = start_index;
#line 1093 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
	_tmp1_ = needle;
#line 1093 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
	_tmp2_ = strstr (((gchar*) self) + _tmp0_, (gchar*) _tmp1_);
#line 1093 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
	_result_ = _tmp2_;
#line 1095 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
	_tmp3_ = _result_;
#line 1095 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
	if (_tmp3_ != NULL) {
#line 2545 "rygel-tracker-search-container.c"
		gchar* _tmp4_;
#line 1096 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
		_tmp4_ = _result_;
#line 1096 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
		result = (gint) (_tmp4_ - ((gchar*) self));
#line 1096 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
		return result;
#line 2553 "rygel-tracker-search-container.c"
	} else {
#line 1098 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
		result = -1;
#line 1098 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
		return result;
#line 2559 "rygel-tracker-search-container.c"
	}
}


static RygelTrackerSelectionQuery* rygel_tracker_search_container_create_sorted_query (RygelTrackerSearchContainer* self, const gchar* sort_criteria) {
	RygelTrackerSelectionQuery* result = NULL;
	RygelTrackerUPnPPropertyMap* _tmp0_ = NULL;
	RygelTrackerUPnPPropertyMap* key_chain_map;
	const gchar* _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_ = NULL;
	gchar** sort_props;
	gint sort_props_length1;
	gint _sort_props_size_;
	gchar* _tmp4_;
	gchar* order;
	GeeArrayList* _tmp5_;
	GeeArrayList* variables;
	GeeArrayList* _tmp6_;
	GeeArrayList* filters;
	GeeArrayList* _tmp7_;
	RygelTrackerSelectionQuery* _tmp8_;
	GeeArrayList* _tmp9_;
	GeeArrayList* _tmp10_;
	RygelTrackerSelectionQuery* _tmp11_;
	GeeArrayList* _tmp12_;
	gchar** _tmp13_;
	gint _tmp13__length1;
	const gchar* _tmp37_;
	GeeArrayList* _tmp41_;
	RygelTrackerSelectionQuery* _tmp42_;
	RygelTrackerQueryTriplets* _tmp43_;
	RygelTrackerQueryTriplets* _tmp44_;
	RygelTrackerQueryTriplets* _tmp45_;
	GeeArrayList* _tmp46_;
	const gchar* _tmp47_;
	RygelTrackerSelectionQuery* _tmp48_;
	RygelTrackerSelectionQuery* _tmp49_;
#line 275 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 275 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	g_return_val_if_fail (sort_criteria != NULL, NULL);
#line 276 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp0_ = rygel_tracker_upn_pproperty_map_get_property_map ();
#line 276 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	key_chain_map = _tmp0_;
#line 277 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp1_ = sort_criteria;
#line 277 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp3_ = _tmp2_ = g_strsplit (_tmp1_, ",", 0);
#line 277 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	sort_props = _tmp3_;
#line 277 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	sort_props_length1 = _vala_array_length (_tmp2_);
#line 277 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_sort_props_size_ = sort_props_length1;
#line 278 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp4_ = g_strdup ("");
#line 278 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	order = _tmp4_;
#line 279 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp5_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
#line 279 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	variables = _tmp5_;
#line 280 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp6_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
#line 280 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	filters = _tmp6_;
#line 282 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp7_ = variables;
#line 282 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp8_ = self->query;
#line 282 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp9_ = _tmp8_->variables;
#line 282 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	gee_abstract_collection_add_all ((GeeAbstractCollection*) _tmp7_, (GeeCollection*) _tmp9_);
#line 283 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp10_ = filters;
#line 283 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp11_ = self->query;
#line 283 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp12_ = _tmp11_->filters;
#line 283 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	gee_abstract_collection_add_all ((GeeAbstractCollection*) _tmp10_, (GeeCollection*) _tmp12_);
#line 285 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp13_ = sort_props;
#line 285 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp13__length1 = sort_props_length1;
#line 2648 "rygel-tracker-search-container.c"
	{
		gchar** s_collection = NULL;
		gint s_collection_length1 = 0;
		gint _s_collection_size_ = 0;
		gint s_it = 0;
#line 285 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		s_collection = _tmp13_;
#line 285 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		s_collection_length1 = _tmp13__length1;
#line 285 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		for (s_it = 0; s_it < _tmp13__length1; s_it = s_it + 1) {
#line 2660 "rygel-tracker-search-container.c"
			gchar* _tmp14_;
			gchar* s = NULL;
#line 285 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_tmp14_ = g_strdup (s_collection[s_it]);
#line 285 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			s = _tmp14_;
#line 2667 "rygel-tracker-search-container.c"
			{
				RygelTrackerUPnPPropertyMap* _tmp15_;
				const gchar* _tmp16_;
				gchar* _tmp17_ = NULL;
				gchar* _tmp18_;
				gchar* _tmp19_ = NULL;
				gchar* _tmp20_;
				gchar* key;
				const gchar* _tmp21_;
				gint _tmp22_ = 0;
				const gchar* _tmp23_;
				gboolean _tmp24_ = FALSE;
#line 286 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				_tmp15_ = key_chain_map;
#line 286 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				_tmp16_ = s;
#line 286 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				_tmp17_ = string_substring (_tmp16_, (glong) 1, (glong) (-1));
#line 286 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				_tmp18_ = _tmp17_;
#line 286 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				_tmp19_ = rygel_tracker_upn_pproperty_map_get (_tmp15_, _tmp18_);
#line 286 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				_tmp20_ = _tmp19_;
#line 286 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				_g_free0 (_tmp18_);
#line 286 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				key = _tmp20_;
#line 287 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				_tmp21_ = key;
#line 287 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				_tmp22_ = string_index_of (_tmp21_, RYGEL_TRACKER_SELECTION_QUERY_ITEM_VARIABLE, 0);
#line 287 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				if (_tmp22_ == 0) {
#line 288 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
					_g_free0 (key);
#line 288 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
					_g_free0 (s);
#line 288 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
					continue;
#line 2708 "rygel-tracker-search-container.c"
				}
#line 291 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				_tmp23_ = s;
#line 291 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				_tmp24_ = g_str_has_prefix (_tmp23_, "-");
#line 291 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				if (_tmp24_) {
#line 2716 "rygel-tracker-search-container.c"
					const gchar* _tmp25_;
					const gchar* _tmp26_;
					gchar* _tmp27_;
					gchar* _tmp28_;
					gchar* _tmp29_;
					gchar* _tmp30_;
					gchar* _tmp31_;
#line 292 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
					_tmp25_ = order;
#line 292 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
					_tmp26_ = key;
#line 292 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
					_tmp27_ = g_strconcat ("DESC (", _tmp26_, NULL);
#line 292 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
					_tmp28_ = _tmp27_;
#line 292 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
					_tmp29_ = g_strconcat (_tmp28_, ") ", NULL);
#line 292 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
					_tmp30_ = _tmp29_;
#line 292 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
					_tmp31_ = g_strconcat (_tmp25_, _tmp30_, NULL);
#line 292 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
					_g_free0 (order);
#line 292 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
					order = _tmp31_;
#line 292 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
					_g_free0 (_tmp30_);
#line 292 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
					_g_free0 (_tmp28_);
#line 2746 "rygel-tracker-search-container.c"
				} else {
					const gchar* _tmp32_;
					const gchar* _tmp33_;
					gchar* _tmp34_;
					gchar* _tmp35_;
					gchar* _tmp36_;
#line 295 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
					_tmp32_ = order;
#line 295 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
					_tmp33_ = key;
#line 295 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
					_tmp34_ = g_strconcat (_tmp33_, " ", NULL);
#line 295 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
					_tmp35_ = _tmp34_;
#line 295 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
					_tmp36_ = g_strconcat (_tmp32_, _tmp35_, NULL);
#line 295 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
					_g_free0 (order);
#line 295 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
					order = _tmp36_;
#line 295 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
					_g_free0 (_tmp35_);
#line 2769 "rygel-tracker-search-container.c"
				}
#line 285 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				_g_free0 (key);
#line 285 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				_g_free0 (s);
#line 2775 "rygel-tracker-search-container.c"
			}
		}
	}
#line 299 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp37_ = order;
#line 299 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	if (g_strcmp0 (_tmp37_, "") == 0) {
#line 2783 "rygel-tracker-search-container.c"
		RygelTrackerSelectionQuery* _tmp38_;
		const gchar* _tmp39_;
		gchar* _tmp40_;
#line 300 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp38_ = self->query;
#line 300 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp39_ = _tmp38_->order_by;
#line 300 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp40_ = g_strdup (_tmp39_);
#line 300 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_g_free0 (order);
#line 300 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		order = _tmp40_;
#line 2797 "rygel-tracker-search-container.c"
	}
#line 303 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp41_ = variables;
#line 303 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp42_ = self->query;
#line 303 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp43_ = ((RygelTrackerQuery*) _tmp42_)->triplets;
#line 303 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp44_ = rygel_tracker_query_triplets_new_clone (_tmp43_);
#line 303 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp45_ = _tmp44_;
#line 303 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp46_ = filters;
#line 303 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp47_ = order;
#line 303 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp48_ = rygel_tracker_selection_query_new (_tmp41_, _tmp45_, _tmp46_, _tmp47_, 0, -1);
#line 303 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp49_ = _tmp48_;
#line 303 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_g_object_unref0 (_tmp45_);
#line 303 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	result = _tmp49_;
#line 303 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_g_object_unref0 (filters);
#line 303 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_g_object_unref0 (variables);
#line 303 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_g_free0 (order);
#line 303 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	sort_props = (_vala_array_free (sort_props, sort_props_length1, (GDestroyNotify) g_free), NULL);
#line 303 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_g_object_unref0 (key_chain_map);
#line 303 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	return result;
#line 2833 "rygel-tracker-search-container.c"
}


static gunichar string_get_char (const gchar* self, glong index) {
	gunichar result = 0U;
	glong _tmp0_;
	gunichar _tmp1_ = 0U;
#line 1189 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0U);
#line 1190 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
	_tmp0_ = index;
#line 1190 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
	_tmp1_ = g_utf8_get_char (((gchar*) self) + _tmp0_);
#line 1190 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
	result = _tmp1_;
#line 1190 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
	return result;
#line 2851 "rygel-tracker-search-container.c"
}


static gchar* rygel_tracker_search_container_urn_to_utf8 (RygelTrackerSearchContainer* self, const gchar* urn) {
	gchar* result = NULL;
	GString* _tmp0_;
	GString* urn_builder;
	const gchar* _tmp1_;
	const gchar* s;
	GString* _tmp18_;
	const gchar* _tmp19_;
	gchar* _tmp20_;
#line 310 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 310 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	g_return_val_if_fail (urn != NULL, NULL);
#line 311 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp0_ = g_string_new ("");
#line 311 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	urn_builder = _tmp0_;
#line 312 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp1_ = urn;
#line 312 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	s = _tmp1_;
#line 2876 "rygel-tracker-search-container.c"
	{
		gboolean _tmp2_;
#line 314 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp2_ = TRUE;
#line 314 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		while (TRUE) {
#line 2883 "rygel-tracker-search-container.c"
			gboolean _tmp3_;
			const gchar* _tmp6_;
			gunichar _tmp7_ = 0U;
			const gchar* _tmp8_;
			gunichar _tmp9_ = 0U;
			gunichar character;
			gboolean _tmp10_ = FALSE;
			gunichar _tmp11_;
			gboolean _tmp12_ = FALSE;
			gboolean _tmp15_;
#line 314 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_tmp3_ = _tmp2_;
#line 314 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			if (!_tmp3_) {
#line 2898 "rygel-tracker-search-container.c"
				const gchar* _tmp4_;
				const gchar* _tmp5_ = NULL;
#line 314 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				_tmp4_ = s;
#line 314 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				_tmp5_ = g_utf8_next_char (_tmp4_);
#line 314 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				s = _tmp5_;
#line 2907 "rygel-tracker-search-container.c"
			}
#line 314 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_tmp2_ = FALSE;
#line 314 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_tmp6_ = s;
#line 314 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_tmp7_ = string_get_char (_tmp6_, (glong) 0);
#line 314 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			if (!(_tmp7_ != ((gunichar) 0))) {
#line 314 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				break;
#line 2919 "rygel-tracker-search-container.c"
			}
#line 315 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_tmp8_ = s;
#line 315 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_tmp9_ = string_get_char (_tmp8_, (glong) 0);
#line 315 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			character = _tmp9_;
#line 316 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_tmp11_ = character;
#line 316 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_tmp12_ = g_unichar_iscntrl (_tmp11_);
#line 316 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			if (_tmp12_) {
#line 316 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				_tmp10_ = TRUE;
#line 2935 "rygel-tracker-search-container.c"
			} else {
				gunichar _tmp13_;
				gboolean _tmp14_ = FALSE;
#line 316 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				_tmp13_ = character;
#line 316 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				_tmp14_ = g_unichar_validate (_tmp13_);
#line 316 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				_tmp10_ = !_tmp14_;
#line 2945 "rygel-tracker-search-container.c"
			}
#line 316 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_tmp15_ = _tmp10_;
#line 316 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			if (!_tmp15_) {
#line 2951 "rygel-tracker-search-container.c"
				GString* _tmp16_;
				gunichar _tmp17_;
#line 317 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				_tmp16_ = urn_builder;
#line 317 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				_tmp17_ = character;
#line 317 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				g_string_append_unichar (_tmp16_, _tmp17_);
#line 2960 "rygel-tracker-search-container.c"
			}
		}
	}
#line 321 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp18_ = urn_builder;
#line 321 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp19_ = _tmp18_->str;
#line 321 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp20_ = g_strdup (_tmp19_);
#line 321 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	result = _tmp20_;
#line 321 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_g_string_free0 (urn_builder);
#line 321 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	return result;
#line 2976 "rygel-tracker-search-container.c"
}


static gchar* rygel_tracker_search_container_create_filter_for_child (RygelTrackerSearchContainer* self, RygelRelationalExpression* expression) {
	gchar* result = NULL;
	gchar* filter;
	gchar* variable;
	gchar* value;
	RygelRelationalExpression* _tmp0_;
	gconstpointer _tmp1_;
	gboolean _tmp30_ = FALSE;
	const gchar* _tmp31_;
	gboolean _tmp33_;
	RygelRelationalExpression* _tmp34_;
	gconstpointer _tmp35_;
#line 324 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 324 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	g_return_val_if_fail (expression != NULL, NULL);
#line 325 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	filter = NULL;
#line 326 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	variable = NULL;
#line 327 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	value = NULL;
#line 329 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp0_ = expression;
#line 329 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp1_ = ((RygelSearchExpression*) _tmp0_)->operand1;
#line 329 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	if (g_strcmp0 ((const gchar*) _tmp1_, "@id") == 0) {
#line 3008 "rygel-tracker-search-container.c"
		gchar* _tmp2_;
		gchar* parent_id = NULL;
		RygelRelationalExpression* _tmp3_;
		gconstpointer _tmp4_;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar* urn;
		const gchar* _tmp7_;
		gboolean _tmp8_ = FALSE;
		gboolean _tmp11_ = FALSE;
		gboolean _tmp12_ = FALSE;
		const gchar* _tmp13_;
		gboolean _tmp15_;
		gboolean _tmp18_;
		const gchar* _tmp19_;
		gchar* _tmp20_ = NULL;
		RygelRelationalExpression* _tmp21_;
		gconstpointer _tmp22_;
#line 330 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp2_ = g_strdup (RYGEL_TRACKER_SELECTION_QUERY_ITEM_VARIABLE);
#line 330 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_g_free0 (variable);
#line 330 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		variable = _tmp2_;
#line 334 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp3_ = expression;
#line 334 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp4_ = ((RygelSearchExpression*) _tmp3_)->operand2;
#line 334 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp6_ = rygel_tracker_search_container_get_item_info (self, (const gchar*) _tmp4_, &_tmp5_);
#line 334 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_g_free0 (parent_id);
#line 334 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		parent_id = _tmp5_;
#line 334 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		urn = _tmp6_;
#line 336 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp7_ = urn;
#line 336 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp8_ = g_utf8_validate (_tmp7_, (gssize) (-1), NULL);
#line 336 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		if (!_tmp8_) {
#line 3051 "rygel-tracker-search-container.c"
			const gchar* _tmp9_;
			gchar* _tmp10_ = NULL;
#line 337 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_tmp9_ = urn;
#line 337 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_tmp10_ = rygel_tracker_search_container_urn_to_utf8 (self, _tmp9_);
#line 337 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_g_free0 (urn);
#line 337 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			urn = _tmp10_;
#line 3062 "rygel-tracker-search-container.c"
		}
#line 340 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp13_ = urn;
#line 340 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		if (_tmp13_ == NULL) {
#line 340 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_tmp12_ = TRUE;
#line 3070 "rygel-tracker-search-container.c"
		} else {
			const gchar* _tmp14_;
#line 340 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_tmp14_ = parent_id;
#line 340 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_tmp12_ = _tmp14_ == NULL;
#line 3077 "rygel-tracker-search-container.c"
		}
#line 340 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp15_ = _tmp12_;
#line 340 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		if (_tmp15_) {
#line 340 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_tmp11_ = TRUE;
#line 3085 "rygel-tracker-search-container.c"
		} else {
			const gchar* _tmp16_;
			const gchar* _tmp17_;
#line 340 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_tmp16_ = parent_id;
#line 340 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_tmp17_ = ((RygelMediaObject*) self)->id;
#line 340 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_tmp11_ = g_strcmp0 (_tmp16_, _tmp17_) != 0;
#line 3095 "rygel-tracker-search-container.c"
		}
#line 340 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp18_ = _tmp11_;
#line 340 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		if (_tmp18_) {
#line 341 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			result = NULL;
#line 341 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_g_free0 (urn);
#line 341 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_g_free0 (parent_id);
#line 341 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_g_free0 (value);
#line 341 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_g_free0 (variable);
#line 341 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_g_free0 (filter);
#line 341 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			return result;
#line 3115 "rygel-tracker-search-container.c"
		}
#line 344 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp19_ = urn;
#line 344 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp20_ = rygel_tracker_query_escape_string (_tmp19_);
#line 344 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_g_free0 (urn);
#line 344 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		urn = _tmp20_;
#line 346 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp21_ = expression;
#line 346 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp22_ = ((RygelSearchExpression*) _tmp21_)->op;
#line 346 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		switch (GPOINTER_TO_INT (_tmp22_)) {
#line 346 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			case GUPNP_SEARCH_CRITERIA_OP_EQ:
#line 3133 "rygel-tracker-search-container.c"
			{
				const gchar* _tmp23_;
				gchar* _tmp24_;
				gchar* _tmp25_;
				gchar* _tmp26_;
#line 348 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				_tmp23_ = urn;
#line 348 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				_tmp24_ = g_strconcat ("<", _tmp23_, NULL);
#line 348 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				_tmp25_ = _tmp24_;
#line 348 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				_tmp26_ = g_strconcat (_tmp25_, ">", NULL);
#line 348 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				_g_free0 (value);
#line 348 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				value = _tmp26_;
#line 348 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				_g_free0 (_tmp25_);
#line 349 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				break;
#line 3155 "rygel-tracker-search-container.c"
			}
#line 346 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			case GUPNP_SEARCH_CRITERIA_OP_CONTAINS:
#line 3159 "rygel-tracker-search-container.c"
			{
				RygelRelationalExpression* _tmp27_;
				gconstpointer _tmp28_;
				gchar* _tmp29_;
#line 351 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				_tmp27_ = expression;
#line 351 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				_tmp28_ = ((RygelSearchExpression*) _tmp27_)->operand2;
#line 351 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				_tmp29_ = g_strdup ((const gchar*) _tmp28_);
#line 351 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				_g_free0 (value);
#line 351 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				value = _tmp29_;
#line 352 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				break;
#line 3176 "rygel-tracker-search-container.c"
			}
			default:
#line 346 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			break;
#line 3181 "rygel-tracker-search-container.c"
		}
#line 329 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_g_free0 (urn);
#line 329 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_g_free0 (parent_id);
#line 3187 "rygel-tracker-search-container.c"
	}
#line 356 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp31_ = variable;
#line 356 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	if (_tmp31_ == NULL) {
#line 356 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp30_ = TRUE;
#line 3195 "rygel-tracker-search-container.c"
	} else {
		const gchar* _tmp32_;
#line 356 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp32_ = value;
#line 356 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp30_ = _tmp32_ == NULL;
#line 3202 "rygel-tracker-search-container.c"
	}
#line 356 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp33_ = _tmp30_;
#line 356 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	if (_tmp33_) {
#line 357 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		result = NULL;
#line 357 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_g_free0 (value);
#line 357 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_g_free0 (variable);
#line 357 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_g_free0 (filter);
#line 357 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		return result;
#line 3218 "rygel-tracker-search-container.c"
	}
#line 360 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp34_ = expression;
#line 360 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp35_ = ((RygelSearchExpression*) _tmp34_)->op;
#line 360 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	switch (GPOINTER_TO_INT (_tmp35_)) {
#line 360 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		case GUPNP_SEARCH_CRITERIA_OP_EQ:
#line 3228 "rygel-tracker-search-container.c"
		{
			const gchar* _tmp36_;
			gchar* _tmp37_;
			gchar* _tmp38_;
			const gchar* _tmp39_;
			gchar* _tmp40_;
#line 362 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_tmp36_ = variable;
#line 362 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_tmp37_ = g_strconcat (_tmp36_, " = ", NULL);
#line 362 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_tmp38_ = _tmp37_;
#line 362 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_tmp39_ = value;
#line 362 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_tmp40_ = g_strconcat (_tmp38_, _tmp39_, NULL);
#line 362 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_g_free0 (filter);
#line 362 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			filter = _tmp40_;
#line 362 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_g_free0 (_tmp38_);
#line 363 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			break;
#line 3253 "rygel-tracker-search-container.c"
		}
#line 360 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		case GUPNP_SEARCH_CRITERIA_OP_CONTAINS:
#line 3257 "rygel-tracker-search-container.c"
		{
			const gchar* _tmp41_;
			gchar* _tmp42_ = NULL;
			gchar* regex;
			const gchar* _tmp43_;
			gchar* _tmp44_;
			gchar* _tmp45_;
			gchar* _tmp46_;
			gchar* _tmp47_;
			const gchar* _tmp48_;
			gchar* _tmp49_;
			gchar* _tmp50_;
			gchar* _tmp51_;
#line 366 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_tmp41_ = value;
#line 366 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_tmp42_ = rygel_tracker_query_escape_regex (_tmp41_);
#line 366 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			regex = _tmp42_;
#line 368 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_tmp43_ = variable;
#line 368 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_tmp44_ = g_strconcat ("regex(", _tmp43_, NULL);
#line 368 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_tmp45_ = _tmp44_;
#line 368 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_tmp46_ = g_strconcat (_tmp45_, ", \"", NULL);
#line 368 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_tmp47_ = _tmp46_;
#line 368 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_tmp48_ = regex;
#line 368 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_tmp49_ = g_strconcat (_tmp47_, _tmp48_, NULL);
#line 368 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_tmp50_ = _tmp49_;
#line 368 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_tmp51_ = g_strconcat (_tmp50_, "\", \"i\")", NULL);
#line 368 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_g_free0 (filter);
#line 368 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			filter = _tmp51_;
#line 368 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_g_free0 (_tmp50_);
#line 368 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_g_free0 (_tmp47_);
#line 368 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_g_free0 (_tmp45_);
#line 369 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_g_free0 (regex);
#line 369 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			break;
#line 3309 "rygel-tracker-search-container.c"
		}
		default:
#line 360 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		break;
#line 3314 "rygel-tracker-search-container.c"
	}
#line 372 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	result = filter;
#line 372 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_g_free0 (value);
#line 372 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_g_free0 (variable);
#line 372 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	return result;
#line 3324 "rygel-tracker-search-container.c"
}


static void rygel_tracker_search_container_class_init (RygelTrackerSearchContainerClass * klass) {
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	rygel_tracker_search_container_parent_class = g_type_class_peek_parent (klass);
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	g_type_class_add_private (klass, sizeof (RygelTrackerSearchContainerPrivate));
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->get_children = rygel_tracker_search_container_real_get_children;
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->get_children_finish = rygel_tracker_search_container_real_get_children_finish;
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->find_object = rygel_tracker_search_container_real_find_object;
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->find_object_finish = rygel_tracker_search_container_real_find_object_finish;
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_tracker_search_container_finalize;
#line 3343 "rygel-tracker-search-container.c"
}


static void rygel_tracker_search_container_instance_init (RygelTrackerSearchContainer * self) {
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	self->priv = RYGEL_TRACKER_SEARCH_CONTAINER_GET_PRIVATE (self);
#line 3350 "rygel-tracker-search-container.c"
}


static void rygel_tracker_search_container_finalize (GObject* obj) {
	RygelTrackerSearchContainer * self;
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	self = RYGEL_TRACKER_SEARCH_CONTAINER (obj);
#line 38 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_rygel_tracker_query_unref0 (self->query);
#line 39 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_rygel_tracker_item_factory_unref0 (self->item_factory);
#line 41 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_g_object_unref0 (self->priv->resources);
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	G_OBJECT_CLASS (rygel_tracker_search_container_parent_class)->finalize (obj);
#line 3366 "rygel-tracker-search-container.c"
}


/**
 * A container listing a Tracker search result.
 */
GType rygel_tracker_search_container_get_type (void) {
	static volatile gsize rygel_tracker_search_container_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_tracker_search_container_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelTrackerSearchContainerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_tracker_search_container_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelTrackerSearchContainer), 0, (GInstanceInitFunc) rygel_tracker_search_container_instance_init, NULL };
		GType rygel_tracker_search_container_type_id;
		rygel_tracker_search_container_type_id = g_type_register_static (RYGEL_TYPE_SIMPLE_CONTAINER, "RygelTrackerSearchContainer", &g_define_type_info, 0);
		g_once_init_leave (&rygel_tracker_search_container_type_id__volatile, rygel_tracker_search_container_type_id);
	}
	return rygel_tracker_search_container_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



