/* rygel-writable-container.c generated by valac 0.20.1.2-ca5c2, the Vala compiler
 * generated from rygel-writable-container.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2010-2012 Nokia Corporation.
 * Copyright (C) 2012 Intel Corporation.
 *
 * Author: Jens Georg <jensg@openismus.com>
 *         Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>


#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;

#define RYGEL_TYPE_WRITABLE_CONTAINER (rygel_writable_container_get_type ())
#define RYGEL_WRITABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_WRITABLE_CONTAINER, RygelWritableContainer))
#define RYGEL_IS_WRITABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_WRITABLE_CONTAINER))
#define RYGEL_WRITABLE_CONTAINER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_WRITABLE_CONTAINER, RygelWritableContainerIface))

typedef struct _RygelWritableContainer RygelWritableContainer;
typedef struct _RygelWritableContainerIface RygelWritableContainerIface;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _RygelWritableContainerAddReferenceData RygelWritableContainerAddReferenceData;

typedef enum  {
	RYGEL_WRITABLE_CONTAINER_ERROR_NOT_IMPLEMENTED
} RygelWritableContainerError;
#define RYGEL_WRITABLE_CONTAINER_ERROR rygel_writable_container_error_quark ()
struct _RygelWritableContainerIface {
	GTypeInterface parent_iface;
	void (*add_item) (RygelWritableContainer* self, RygelMediaItem* item, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*add_item_finish) (RygelWritableContainer* self, GAsyncResult* _res_, GError** error);
	void (*add_container) (RygelWritableContainer* self, RygelMediaContainer* container, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*add_container_finish) (RygelWritableContainer* self, GAsyncResult* _res_, GError** error);
	void (*add_reference) (RygelWritableContainer* self, RygelMediaObject* object, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	gchar* (*add_reference_finish) (RygelWritableContainer* self, GAsyncResult* _res_, GError** error);
	void (*remove_item) (RygelWritableContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*remove_item_finish) (RygelWritableContainer* self, GAsyncResult* _res_, GError** error);
	void (*remove_container) (RygelWritableContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*remove_container_finish) (RygelWritableContainer* self, GAsyncResult* _res_, GError** error);
	GeeArrayList* (*get_create_classes) (RygelWritableContainer* self);
	void (*set_create_classes) (RygelWritableContainer* self, GeeArrayList* value);
};

struct _RygelWritableContainerAddReferenceData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelWritableContainer* self;
	RygelMediaObject* object;
	GCancellable* cancellable;
	gchar* result;
	GError* _tmp0_;
	GError * _inner_error_;
};



GQuark rygel_writable_container_error_quark (void);
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
GType rygel_writable_container_get_type (void) G_GNUC_CONST;
gboolean rygel_writable_container_can_create (RygelWritableContainer* self, const gchar* upnp_class);
GeeArrayList* rygel_writable_container_get_create_classes (RygelWritableContainer* self);
void rygel_writable_container_add_item (RygelWritableContainer* self, RygelMediaItem* item, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_writable_container_add_item_finish (RygelWritableContainer* self, GAsyncResult* _res_, GError** error);
void rygel_writable_container_add_container (RygelWritableContainer* self, RygelMediaContainer* container, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_writable_container_add_container_finish (RygelWritableContainer* self, GAsyncResult* _res_, GError** error);
static void rygel_writable_container_real_add_reference_data_free (gpointer _data);
static void rygel_writable_container_real_add_reference (RygelWritableContainer* self, RygelMediaObject* object, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_writable_container_add_reference (RygelWritableContainer* self, RygelMediaObject* object, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
gchar* rygel_writable_container_add_reference_finish (RygelWritableContainer* self, GAsyncResult* _res_, GError** error);
static gboolean rygel_writable_container_real_add_reference_co (RygelWritableContainerAddReferenceData* _data_);
void rygel_writable_container_remove_item (RygelWritableContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_writable_container_remove_item_finish (RygelWritableContainer* self, GAsyncResult* _res_, GError** error);
void rygel_writable_container_remove_container (RygelWritableContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_writable_container_remove_container_finish (RygelWritableContainer* self, GAsyncResult* _res_, GError** error);
#define RYGEL_WRITABLE_CONTAINER_WRITABLE_SCHEME "rygel-writable://"
void rygel_writable_container_set_create_classes (RygelWritableContainer* self, GeeArrayList* value);


GQuark rygel_writable_container_error_quark (void) {
	return g_quark_from_static_string ("rygel_writable_container_error-quark");
}


/**
     * Check if this container can contain an item with the given upnp class,
     * meaning that rygel_writable_container_add_item() should succeed.
     *
     * @param upnp_class The upnp class of an item to check
     *
     * @return true if it can, false, if not.
     */
gboolean rygel_writable_container_can_create (RygelWritableContainer* self, const gchar* upnp_class) {
	gboolean result = FALSE;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	const gchar* _tmp2_;
	gboolean _tmp3_ = FALSE;
	g_return_val_if_fail (upnp_class != NULL, FALSE);
	_tmp0_ = rygel_writable_container_get_create_classes (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = upnp_class;
	_tmp3_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp1_, _tmp2_);
	result = _tmp3_;
	return result;
}


void rygel_writable_container_add_item (RygelWritableContainer* self, RygelMediaItem* item, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RYGEL_WRITABLE_CONTAINER_GET_INTERFACE (self)->add_item (self, item, cancellable, _callback_, _user_data_);
}


void rygel_writable_container_add_item_finish (RygelWritableContainer* self, GAsyncResult* _res_, GError** error) {
	RYGEL_WRITABLE_CONTAINER_GET_INTERFACE (self)->add_item_finish (self, _res_, error);
}


void rygel_writable_container_add_container (RygelWritableContainer* self, RygelMediaContainer* container, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RYGEL_WRITABLE_CONTAINER_GET_INTERFACE (self)->add_container (self, container, cancellable, _callback_, _user_data_);
}


void rygel_writable_container_add_container_finish (RygelWritableContainer* self, GAsyncResult* _res_, GError** error) {
	RYGEL_WRITABLE_CONTAINER_GET_INTERFACE (self)->add_container_finish (self, _res_, error);
}


static void rygel_writable_container_real_add_reference_data_free (gpointer _data) {
	RygelWritableContainerAddReferenceData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->object);
	_g_object_unref0 (_data_->cancellable);
	_g_free0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelWritableContainerAddReferenceData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void rygel_writable_container_real_add_reference (RygelWritableContainer* self, RygelMediaObject* object, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelWritableContainerAddReferenceData* _data_;
	RygelWritableContainer* _tmp0_;
	RygelMediaObject* _tmp1_;
	RygelMediaObject* _tmp2_;
	GCancellable* _tmp3_;
	GCancellable* _tmp4_;
	_data_ = g_slice_new0 (RygelWritableContainerAddReferenceData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_writable_container_real_add_reference);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_writable_container_real_add_reference_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = object;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->object);
	_data_->object = _tmp2_;
	_tmp3_ = cancellable;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp4_;
	rygel_writable_container_real_add_reference_co (_data_);
}


static gchar* rygel_writable_container_real_add_reference_finish (RygelWritableContainer* self, GAsyncResult* _res_, GError** error) {
	gchar* result;
	RygelWritableContainerAddReferenceData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


/**
     * Add a reference to an object.
     * @param object The source object to add a reference to.
     * @param cancellable optional cancellable for this operation
     * @return the id of the newly created reference
     **/
static gboolean rygel_writable_container_real_add_reference_co (RygelWritableContainerAddReferenceData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_error_new_literal (RYGEL_WRITABLE_CONTAINER_ERROR, RYGEL_WRITABLE_CONTAINER_ERROR_NOT_IMPLEMENTED, "Cannot create references here");
	_data_->_inner_error_ = _data_->_tmp0_;
	g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
	g_error_free (_data_->_inner_error_);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


void rygel_writable_container_add_reference (RygelWritableContainer* self, RygelMediaObject* object, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RYGEL_WRITABLE_CONTAINER_GET_INTERFACE (self)->add_reference (self, object, cancellable, _callback_, _user_data_);
}


gchar* rygel_writable_container_add_reference_finish (RygelWritableContainer* self, GAsyncResult* _res_, GError** error) {
	return RYGEL_WRITABLE_CONTAINER_GET_INTERFACE (self)->add_reference_finish (self, _res_, error);
}


void rygel_writable_container_remove_item (RygelWritableContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RYGEL_WRITABLE_CONTAINER_GET_INTERFACE (self)->remove_item (self, id, cancellable, _callback_, _user_data_);
}


void rygel_writable_container_remove_item_finish (RygelWritableContainer* self, GAsyncResult* _res_, GError** error) {
	RYGEL_WRITABLE_CONTAINER_GET_INTERFACE (self)->remove_item_finish (self, _res_, error);
}


void rygel_writable_container_remove_container (RygelWritableContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RYGEL_WRITABLE_CONTAINER_GET_INTERFACE (self)->remove_container (self, id, cancellable, _callback_, _user_data_);
}


void rygel_writable_container_remove_container_finish (RygelWritableContainer* self, GAsyncResult* _res_, GError** error) {
	RYGEL_WRITABLE_CONTAINER_GET_INTERFACE (self)->remove_container_finish (self, _res_, error);
}


GeeArrayList* rygel_writable_container_get_create_classes (RygelWritableContainer* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return RYGEL_WRITABLE_CONTAINER_GET_INTERFACE (self)->get_create_classes (self);
}


void rygel_writable_container_set_create_classes (RygelWritableContainer* self, GeeArrayList* value) {
	g_return_if_fail (self != NULL);
	RYGEL_WRITABLE_CONTAINER_GET_INTERFACE (self)->set_create_classes (self, value);
}


static void rygel_writable_container_base_init (RygelWritableContainerIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		/**
		     * The list of upnp classes that can be added to this container.
		     *
		     * See rygel_writable_container_add_item().
		     *
		     * This corresponds to the UPnP ContentDirectory's createClass properties.
		     */
		g_object_interface_install_property (iface, g_param_spec_object ("create-classes", "create-classes", "create-classes", GEE_TYPE_ARRAY_LIST, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
		iface->add_reference = rygel_writable_container_real_add_reference;
		iface->add_reference_finish = rygel_writable_container_real_add_reference_finish;
	}
}


/**
 * This interface should be implemented by 'writable' containers - ones that allow
 * adding (via upload), removal and editing of items directly under them.
 * Currently, only addition and removal are supported.
 *
 * In addition to implementing this interface, a writable container must also:
 *
 *  # Provide one URI that points to a writable folder on a GIO-supported filesystem.
 *  # Monitor not only its own URI but also that of its child items, though the latter is implied in the former if you use GIO for monitoring.
 */
GType rygel_writable_container_get_type (void) {
	static volatile gsize rygel_writable_container_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_writable_container_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelWritableContainerIface), (GBaseInitFunc) rygel_writable_container_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType rygel_writable_container_type_id;
		rygel_writable_container_type_id = g_type_register_static (G_TYPE_INTERFACE, "RygelWritableContainer", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (rygel_writable_container_type_id, RYGEL_TYPE_MEDIA_CONTAINER);
		g_once_init_leave (&rygel_writable_container_type_id__volatile, rygel_writable_container_type_id);
	}
	return rygel_writable_container_type_id__volatile;
}



