/* rygel-media-export-item-factory.c generated by valac 0.20.1.2-ca5c2, the Vala compiler
 * generated from rygel-media-export-item-factory.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2008 Nokia Corporation.
 * Copyright (C) 2012 Intel Corporation.
 *
 * Author: Zeeshan Ali <zeenix@gmail.com>
 *         Jens Georg <jensg@openismus.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel-server.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp-av/gupnp-av.h>
#include <gst/pbutils/codec-utils.h>
#include <gst/pbutils/descriptions.h>
#include <gst/pbutils/encoding-profile.h>
#include <gst/pbutils/encoding-target.h>
#include <gst/pbutils/gstdiscoverer.h>
#include <gst/pbutils/gstpluginsbaseversion.h>
#include <gst/pbutils/install-plugins.h>
#include <gst/pbutils/missing-plugins.h>
#include <gst/pbutils/pbutils-enumtypes.h>
#include <gst/pbutils/pbutils.h>
#include <libgupnp-dlna/gupnp-dlna.h>
#include <gst/gst.h>
#include <gst/tag/gsttagdemux.h>
#include <gst/tag/gsttagmux.h>
#include <gst/tag/tag.h>
#include <gst/tag/xmpwriter.h>


#define RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM (rygel_media_export_video_item_get_type ())
#define RYGEL_MEDIA_EXPORT_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM, RygelMediaExportVideoItem))
#define RYGEL_MEDIA_EXPORT_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM, RygelMediaExportVideoItemClass))
#define RYGEL_MEDIA_EXPORT_IS_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM))
#define RYGEL_MEDIA_EXPORT_IS_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM))
#define RYGEL_MEDIA_EXPORT_VIDEO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM, RygelMediaExportVideoItemClass))

typedef struct _RygelMediaExportVideoItem RygelMediaExportVideoItem;
typedef struct _RygelMediaExportVideoItemClass RygelMediaExportVideoItemClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_MEDIA_EXPORT_TYPE_PHOTO_ITEM (rygel_media_export_photo_item_get_type ())
#define RYGEL_MEDIA_EXPORT_PHOTO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_PHOTO_ITEM, RygelMediaExportPhotoItem))
#define RYGEL_MEDIA_EXPORT_PHOTO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_PHOTO_ITEM, RygelMediaExportPhotoItemClass))
#define RYGEL_MEDIA_EXPORT_IS_PHOTO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_PHOTO_ITEM))
#define RYGEL_MEDIA_EXPORT_IS_PHOTO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_PHOTO_ITEM))
#define RYGEL_MEDIA_EXPORT_PHOTO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_PHOTO_ITEM, RygelMediaExportPhotoItemClass))

typedef struct _RygelMediaExportPhotoItem RygelMediaExportPhotoItem;
typedef struct _RygelMediaExportPhotoItemClass RygelMediaExportPhotoItemClass;

#define RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM (rygel_media_export_music_item_get_type ())
#define RYGEL_MEDIA_EXPORT_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM, RygelMediaExportMusicItem))
#define RYGEL_MEDIA_EXPORT_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM, RygelMediaExportMusicItemClass))
#define RYGEL_MEDIA_EXPORT_IS_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM))
#define RYGEL_MEDIA_EXPORT_IS_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM))
#define RYGEL_MEDIA_EXPORT_MUSIC_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM, RygelMediaExportMusicItemClass))

typedef struct _RygelMediaExportMusicItem RygelMediaExportMusicItem;
typedef struct _RygelMediaExportMusicItemClass RygelMediaExportMusicItemClass;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))

#define RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ITEM (rygel_media_export_playlist_item_get_type ())
#define RYGEL_MEDIA_EXPORT_PLAYLIST_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ITEM, RygelMediaExportPlaylistItem))
#define RYGEL_MEDIA_EXPORT_PLAYLIST_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ITEM, RygelMediaExportPlaylistItemClass))
#define RYGEL_MEDIA_EXPORT_IS_PLAYLIST_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ITEM))
#define RYGEL_MEDIA_EXPORT_IS_PLAYLIST_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ITEM))
#define RYGEL_MEDIA_EXPORT_PLAYLIST_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ITEM, RygelMediaExportPlaylistItemClass))

typedef struct _RygelMediaExportPlaylistItem RygelMediaExportPlaylistItem;
typedef struct _RygelMediaExportPlaylistItemClass RygelMediaExportPlaylistItemClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _gst_mini_object_unref0(var) ((var == NULL) ? NULL : (var = (gst_mini_object_unref (var), NULL)))

#define RYGEL_MEDIA_EXPORT_TYPE_UPDATABLE_OBJECT (rygel_media_export_updatable_object_get_type ())
#define RYGEL_MEDIA_EXPORT_UPDATABLE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_UPDATABLE_OBJECT, RygelMediaExportUpdatableObject))
#define RYGEL_MEDIA_EXPORT_IS_UPDATABLE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_UPDATABLE_OBJECT))
#define RYGEL_MEDIA_EXPORT_UPDATABLE_OBJECT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_MEDIA_EXPORT_TYPE_UPDATABLE_OBJECT, RygelMediaExportUpdatableObjectIface))

typedef struct _RygelMediaExportUpdatableObject RygelMediaExportUpdatableObject;
typedef struct _RygelMediaExportUpdatableObjectIface RygelMediaExportUpdatableObjectIface;
typedef struct _RygelMediaExportMusicItemPrivate RygelMediaExportMusicItemPrivate;
#define __vala_GstSample_free0(var) ((var == NULL) ? NULL : (var = (_vala_GstSample_free (var), NULL)))

#define RYGEL_MEDIA_EXPORT_TYPE_JPEG_WRITER (rygel_media_export_jpeg_writer_get_type ())
#define RYGEL_MEDIA_EXPORT_JPEG_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_JPEG_WRITER, RygelMediaExportJPEGWriter))
#define RYGEL_MEDIA_EXPORT_JPEG_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_JPEG_WRITER, RygelMediaExportJPEGWriterClass))
#define RYGEL_MEDIA_EXPORT_IS_JPEG_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_JPEG_WRITER))
#define RYGEL_MEDIA_EXPORT_IS_JPEG_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_JPEG_WRITER))
#define RYGEL_MEDIA_EXPORT_JPEG_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_JPEG_WRITER, RygelMediaExportJPEGWriterClass))

typedef struct _RygelMediaExportJPEGWriter RygelMediaExportJPEGWriter;
typedef struct _RygelMediaExportJPEGWriterClass RygelMediaExportJPEGWriterClass;
#define __vala_GstStructure_free0(var) ((var == NULL) ? NULL : (var = (_vala_GstStructure_free (var), NULL)))
#define __vala_GstDateTime_free0(var) ((var == NULL) ? NULL : (var = (_vala_GstDateTime_free (var), NULL)))

struct _RygelMediaExportUpdatableObjectIface {
	GTypeInterface parent_iface;
	void (*commit_custom) (RygelMediaExportUpdatableObject* self, gboolean override_guarded, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*commit_custom_finish) (RygelMediaExportUpdatableObject* self, GAsyncResult* _res_, GError** error);
};

struct _RygelMediaExportMusicItem {
	RygelMusicItem parent_instance;
	RygelMediaExportMusicItemPrivate * priv;
	gint disc;
};

struct _RygelMediaExportMusicItemClass {
	RygelMusicItemClass parent_class;
};



RygelMediaItem* rygel_media_export_item_factory_create_simple (RygelMediaContainer* parent, GFile* file, GFileInfo* info);
gchar* rygel_media_export_media_cache_get_id (GFile* file);
RygelMediaExportVideoItem* rygel_media_export_video_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelMediaExportVideoItem* rygel_media_export_video_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
GType rygel_media_export_video_item_get_type (void) G_GNUC_CONST;
RygelMediaExportPhotoItem* rygel_media_export_photo_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelMediaExportPhotoItem* rygel_media_export_photo_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
GType rygel_media_export_photo_item_get_type (void) G_GNUC_CONST;
RygelMediaExportMusicItem* rygel_media_export_music_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelMediaExportMusicItem* rygel_media_export_music_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
GType rygel_media_export_music_item_get_type (void) G_GNUC_CONST;
RygelMediaItem* rygel_media_export_item_factory_create_playlist_item (GFile* file, RygelMediaContainer* parent, const gchar* fallback_title);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
RygelMediaExportPlaylistItem* rygel_media_export_playlist_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelMediaExportPlaylistItem* rygel_media_export_playlist_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
GType rygel_media_export_playlist_item_get_type (void) G_GNUC_CONST;
RygelMediaItem* rygel_media_export_item_factory_create_from_info (RygelMediaContainer* parent, GFile* file, GstDiscovererInfo* info, GUPnPDLNAProfile* profile, GFileInfo* file_info);
RygelMediaItem* rygel_media_export_item_factory_fill_photo_item (RygelMediaExportPhotoItem* item, GFile* file, GstDiscovererInfo* info, GUPnPDLNAProfile* profile, GstDiscovererVideoInfo* video_info, GFileInfo* file_info);
RygelMediaItem* rygel_media_export_item_factory_fill_video_item (RygelMediaExportVideoItem* item, GFile* file, GstDiscovererInfo* info, GUPnPDLNAProfile* profile, GstDiscovererVideoInfo* video_info, GstDiscovererAudioInfo* audio_info, GFileInfo* file_info);
RygelMediaItem* rygel_media_export_item_factory_fill_music_item (RygelMediaExportMusicItem* item, GFile* file, GstDiscovererInfo* info, GUPnPDLNAProfile* profile, GstDiscovererAudioInfo* audio_info, GFileInfo* file_info);
void rygel_media_export_item_factory_fill_audio_item (RygelAudioItem* item, GstDiscovererInfo* info, GstDiscovererAudioInfo* audio_info);
void rygel_media_export_item_factory_fill_media_item (RygelMediaItem* item, GFile* file, GstDiscovererInfo* info, GUPnPDLNAProfile* profile, GFileInfo* file_info);
GType rygel_media_export_updatable_object_get_type (void) G_GNUC_CONST;
static void _vala_GstSample_free (GstSample* self);
static GstStructure* _vala_GstStructure_copy (GstStructure* self);
RygelMediaExportJPEGWriter* rygel_media_export_jpeg_writer_new (GError** error);
RygelMediaExportJPEGWriter* rygel_media_export_jpeg_writer_construct (GType object_type, GError** error);
GType rygel_media_export_jpeg_writer_get_type (void) G_GNUC_CONST;
void rygel_media_export_jpeg_writer_write (RygelMediaExportJPEGWriter* self, GstBuffer* buffer, GFile* file);
static void _vala_GstStructure_free (GstStructure* self);
static void _vala_GstDateTime_free (GstDateTime* self);


RygelMediaItem* rygel_media_export_item_factory_create_simple (RygelMediaContainer* parent, GFile* file, GFileInfo* info) {
	RygelMediaItem* result = NULL;
	GFileInfo* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* title;
	RygelMediaItem* item = NULL;
	GFileInfo* _tmp3_;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* mime;
	const gchar* _tmp6_;
	gboolean _tmp7_ = FALSE;
	RygelMediaItem* _tmp39_;
	const gchar* _tmp40_;
	RygelMediaItem* _tmp41_;
	GFileInfo* _tmp42_;
	gint64 _tmp43_ = 0LL;
	RygelMediaItem* _tmp44_;
	GFileInfo* _tmp45_;
	guint64 _tmp46_ = 0ULL;
	RygelMediaItem* _tmp47_;
	GFile* _tmp48_;
	gchar* _tmp49_ = NULL;
	gchar* _tmp50_;
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	g_return_val_if_fail (info != NULL, NULL);
	_tmp0_ = info;
	_tmp1_ = g_file_info_get_display_name (_tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	title = _tmp2_;
	_tmp3_ = info;
	_tmp4_ = g_file_info_get_content_type (_tmp3_);
	_tmp5_ = g_content_type_get_mime_type (_tmp4_);
	mime = _tmp5_;
	_tmp6_ = mime;
	_tmp7_ = g_str_has_prefix (_tmp6_, "video/");
	if (_tmp7_) {
		GFile* _tmp8_;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_;
		RygelMediaContainer* _tmp11_;
		const gchar* _tmp12_;
		RygelMediaExportVideoItem* _tmp13_;
		_tmp8_ = file;
		_tmp9_ = rygel_media_export_media_cache_get_id (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = parent;
		_tmp12_ = title;
		_tmp13_ = rygel_media_export_video_item_new (_tmp10_, _tmp11_, _tmp12_, RYGEL_VIDEO_ITEM_UPNP_CLASS);
		_g_object_unref0 (item);
		item = (RygelMediaItem*) _tmp13_;
		_g_free0 (_tmp10_);
	} else {
		const gchar* _tmp14_;
		gboolean _tmp15_ = FALSE;
		_tmp14_ = mime;
		_tmp15_ = g_str_has_prefix (_tmp14_, "image/");
		if (_tmp15_) {
			GFile* _tmp16_;
			gchar* _tmp17_ = NULL;
			gchar* _tmp18_;
			RygelMediaContainer* _tmp19_;
			const gchar* _tmp20_;
			RygelMediaExportPhotoItem* _tmp21_;
			_tmp16_ = file;
			_tmp17_ = rygel_media_export_media_cache_get_id (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = parent;
			_tmp20_ = title;
			_tmp21_ = rygel_media_export_photo_item_new (_tmp18_, _tmp19_, _tmp20_, RYGEL_PHOTO_ITEM_UPNP_CLASS);
			_g_object_unref0 (item);
			item = (RygelMediaItem*) _tmp21_;
			_g_free0 (_tmp18_);
		} else {
			gboolean _tmp22_ = FALSE;
			const gchar* _tmp23_;
			gboolean _tmp24_ = FALSE;
			gboolean _tmp26_;
			_tmp23_ = mime;
			_tmp24_ = g_str_has_prefix (_tmp23_, "audio/");
			if (_tmp24_) {
				_tmp22_ = TRUE;
			} else {
				const gchar* _tmp25_;
				_tmp25_ = mime;
				_tmp22_ = g_strcmp0 (_tmp25_, "application/ogg") == 0;
			}
			_tmp26_ = _tmp22_;
			if (_tmp26_) {
				GFile* _tmp27_;
				gchar* _tmp28_ = NULL;
				gchar* _tmp29_;
				RygelMediaContainer* _tmp30_;
				const gchar* _tmp31_;
				RygelMediaExportMusicItem* _tmp32_;
				_tmp27_ = file;
				_tmp28_ = rygel_media_export_media_cache_get_id (_tmp27_);
				_tmp29_ = _tmp28_;
				_tmp30_ = parent;
				_tmp31_ = title;
				_tmp32_ = rygel_media_export_music_item_new (_tmp29_, _tmp30_, _tmp31_, RYGEL_MUSIC_ITEM_UPNP_CLASS);
				_g_object_unref0 (item);
				item = (RygelMediaItem*) _tmp32_;
				_g_free0 (_tmp29_);
			} else {
				GFile* _tmp33_;
				RygelMediaContainer* _tmp34_;
				const gchar* _tmp35_;
				RygelMediaItem* _tmp36_ = NULL;
				RygelMediaItem* _tmp37_;
				gchar* _tmp38_;
				_tmp33_ = file;
				_tmp34_ = parent;
				_tmp35_ = title;
				_tmp36_ = rygel_media_export_item_factory_create_playlist_item (_tmp33_, _tmp34_, _tmp35_);
				_g_object_unref0 (item);
				item = _tmp36_;
				_tmp37_ = item;
				if (_tmp37_ == NULL) {
					result = NULL;
					_g_free0 (mime);
					_g_object_unref0 (item);
					_g_free0 (title);
					return result;
				}
				_tmp38_ = g_strdup ("text/xml");
				_g_free0 (mime);
				mime = _tmp38_;
			}
		}
	}
	_tmp39_ = item;
	_tmp40_ = mime;
	rygel_media_item_set_mime_type (_tmp39_, _tmp40_);
	_tmp41_ = item;
	_tmp42_ = info;
	_tmp43_ = g_file_info_get_size (_tmp42_);
	rygel_media_item_set_size (_tmp41_, (gint64) _tmp43_);
	_tmp44_ = item;
	_tmp45_ = info;
	_tmp46_ = g_file_info_get_attribute_uint64 (_tmp45_, G_FILE_ATTRIBUTE_TIME_MODIFIED);
	rygel_media_object_set_modified ((RygelMediaObject*) _tmp44_, _tmp46_);
	_tmp47_ = item;
	_tmp48_ = file;
	_tmp49_ = g_file_get_uri (_tmp48_);
	_tmp50_ = _tmp49_;
	rygel_media_item_add_uri (_tmp47_, _tmp50_);
	_g_free0 (_tmp50_);
	result = item;
	_g_free0 (mime);
	_g_free0 (title);
	return result;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


RygelMediaItem* rygel_media_export_item_factory_create_playlist_item (GFile* file, RygelMediaContainer* parent, const gchar* fallback_title) {
	RygelMediaItem* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (file != NULL, NULL);
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (fallback_title != NULL, NULL);
	{
		guint8* contents = NULL;
		gint contents_length1 = 0;
		gint _contents_size_ = 0;
		GFile* _tmp0_;
		guint8* _tmp1_ = NULL;
		gsize _tmp2_;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_;
		gint i;
		guint8* _tmp14_;
		gint _tmp14__length1;
		gint _tmp15_;
		guint8 _tmp16_;
		guint8* _tmp17_;
		gint _tmp17__length1;
		GUPnPMediaCollection* _tmp18_;
		GUPnPMediaCollection* didl_s;
		GUPnPMediaCollection* _tmp19_;
		const gchar* _tmp20_;
		const gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* author;
		GUPnPMediaCollection* _tmp23_;
		const gchar* _tmp24_;
		const gchar* _tmp25_;
		gchar* _tmp26_;
		gchar* title;
		gboolean _tmp27_ = FALSE;
		gboolean _tmp28_ = FALSE;
		const gchar* _tmp29_;
		gboolean _tmp31_;
		gboolean _tmp35_;
		const gchar* _tmp36_;
		GFile* _tmp39_;
		gchar* _tmp40_ = NULL;
		gchar* _tmp41_;
		RygelMediaContainer* _tmp42_;
		const gchar* _tmp43_;
		RygelMediaExportPlaylistItem* _tmp44_;
		RygelMediaExportPlaylistItem* _tmp45_;
		RygelMediaExportPlaylistItem* item;
		const gchar* _tmp46_;
		RygelMediaExportPlaylistItem* _tmp49_;
		_tmp0_ = file;
		_tmp3_ = g_file_load_contents (_tmp0_, NULL, &_tmp1_, &_tmp2_, NULL, &_inner_error_);
		contents = (g_free (contents), NULL);
		contents = _tmp1_;
		contents_length1 = _tmp2_;
		_contents_size_ = contents_length1;
		_tmp4_ = _tmp3_;
		if (_inner_error_ != NULL) {
			contents = (g_free (contents), NULL);
			goto __catch65_g_error;
		}
		if (!_tmp4_) {
			result = NULL;
			contents = (g_free (contents), NULL);
			return result;
		}
		i = 0;
		while (TRUE) {
			gboolean _tmp5_ = FALSE;
			guint8* _tmp6_;
			gint _tmp6__length1;
			gint _tmp7_;
			guint8 _tmp8_;
			gboolean _tmp9_ = FALSE;
			gboolean _tmp12_;
			gint _tmp13_;
			_tmp6_ = contents;
			_tmp6__length1 = contents_length1;
			_tmp7_ = i;
			_tmp8_ = _tmp6_[_tmp7_];
			_tmp9_ = g_ascii_isspace ((gchar) _tmp8_);
			if (_tmp9_) {
				gint _tmp10_;
				guint8* _tmp11_;
				gint _tmp11__length1;
				_tmp10_ = i;
				_tmp11_ = contents;
				_tmp11__length1 = contents_length1;
				_tmp5_ = _tmp10_ < _tmp11__length1;
			} else {
				_tmp5_ = FALSE;
			}
			_tmp12_ = _tmp5_;
			if (!_tmp12_) {
				break;
			}
			_tmp13_ = i;
			i = _tmp13_ + 1;
		}
		_tmp14_ = contents;
		_tmp14__length1 = contents_length1;
		_tmp15_ = i;
		_tmp16_ = _tmp14_[_tmp15_];
		if (_tmp16_ != ((guint8) '<')) {
			result = NULL;
			contents = (g_free (contents), NULL);
			return result;
		}
		_tmp17_ = contents;
		_tmp17__length1 = contents_length1;
		_tmp18_ = gupnp_media_collection_new_from_string ((const gchar*) _tmp17_);
		didl_s = _tmp18_;
		_tmp19_ = didl_s;
		_tmp20_ = gupnp_media_collection_get_author (_tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = g_strdup (_tmp21_);
		author = _tmp22_;
		_tmp23_ = didl_s;
		_tmp24_ = gupnp_media_collection_get_title (_tmp23_);
		_tmp25_ = _tmp24_;
		_tmp26_ = g_strdup (_tmp25_);
		title = _tmp26_;
		_tmp29_ = author;
		if (_tmp29_ == NULL) {
			const gchar* _tmp30_;
			_tmp30_ = title;
			_tmp28_ = _tmp30_ == NULL;
		} else {
			_tmp28_ = FALSE;
		}
		_tmp31_ = _tmp28_;
		if (_tmp31_) {
			GUPnPMediaCollection* _tmp32_;
			GList* _tmp33_ = NULL;
			GList* _tmp34_;
			_tmp32_ = didl_s;
			_tmp33_ = gupnp_media_collection_get_items (_tmp32_);
			_tmp34_ = _tmp33_;
			_tmp27_ = _tmp34_ == NULL;
			__g_list_free__g_object_unref0_0 (_tmp34_);
		} else {
			_tmp27_ = FALSE;
		}
		_tmp35_ = _tmp27_;
		if (_tmp35_) {
			result = NULL;
			_g_free0 (title);
			_g_free0 (author);
			_g_object_unref0 (didl_s);
			contents = (g_free (contents), NULL);
			return result;
		}
		_tmp36_ = title;
		if (_tmp36_ == NULL) {
			const gchar* _tmp37_;
			gchar* _tmp38_;
			_tmp37_ = fallback_title;
			_tmp38_ = g_strdup (_tmp37_);
			_g_free0 (title);
			title = _tmp38_;
		}
		_tmp39_ = file;
		_tmp40_ = rygel_media_export_media_cache_get_id (_tmp39_);
		_tmp41_ = _tmp40_;
		_tmp42_ = parent;
		_tmp43_ = title;
		_tmp44_ = rygel_media_export_playlist_item_new (_tmp41_, _tmp42_, _tmp43_, RYGEL_PLAYLIST_ITEM_UPNP_CLASS);
		_tmp45_ = _tmp44_;
		_g_free0 (_tmp41_);
		item = _tmp45_;
		_tmp46_ = author;
		if (_tmp46_ != NULL) {
			RygelMediaExportPlaylistItem* _tmp47_;
			const gchar* _tmp48_;
			_tmp47_ = item;
			_tmp48_ = author;
			rygel_playlist_item_set_creator ((RygelPlaylistItem*) _tmp47_, _tmp48_);
		}
		_tmp49_ = item;
		rygel_media_item_set_dlna_profile ((RygelMediaItem*) _tmp49_, "DIDL_S");
		result = (RygelMediaItem*) item;
		_g_free0 (title);
		_g_free0 (author);
		_g_object_unref0 (didl_s);
		contents = (g_free (contents), NULL);
		return result;
	}
	goto __finally65;
	__catch65_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		result = NULL;
		_g_error_free0 (e);
		return result;
	}
	__finally65:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return NULL;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


RygelMediaItem* rygel_media_export_item_factory_create_from_info (RygelMediaContainer* parent, GFile* file, GstDiscovererInfo* info, GUPnPDLNAProfile* profile, GFileInfo* file_info) {
	RygelMediaItem* result = NULL;
	RygelMediaItem* item = NULL;
	GFile* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* id;
	GList* audio_streams = NULL;
	GList* video_streams = NULL;
	GstDiscovererInfo* _tmp2_;
	GList* _tmp3_ = NULL;
	GstDiscovererInfo* _tmp4_;
	GList* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	GList* _tmp7_;
	gboolean _tmp9_;
	gboolean _tmp13_ = FALSE;
	GList* _tmp14_;
	gboolean _tmp18_;
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	g_return_val_if_fail (info != NULL, NULL);
	g_return_val_if_fail (file_info != NULL, NULL);
	_tmp0_ = file;
	_tmp1_ = rygel_media_export_media_cache_get_id (_tmp0_);
	id = _tmp1_;
	_tmp2_ = info;
	_tmp3_ = gst_discoverer_info_get_audio_streams (_tmp2_);
	__g_list_free__g_object_unref0_0 (audio_streams);
	audio_streams = (GList*) _tmp3_;
	_tmp4_ = info;
	_tmp5_ = gst_discoverer_info_get_video_streams (_tmp4_);
	__g_list_free__g_object_unref0_0 (video_streams);
	video_streams = (GList*) _tmp5_;
	_tmp7_ = audio_streams;
	if (_tmp7_ == NULL) {
		GList* _tmp8_;
		_tmp8_ = video_streams;
		_tmp6_ = _tmp8_ == NULL;
	} else {
		_tmp6_ = FALSE;
	}
	_tmp9_ = _tmp6_;
	if (_tmp9_) {
		GFile* _tmp10_;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_;
		_tmp10_ = file;
		_tmp11_ = g_file_get_uri (_tmp10_);
		_tmp12_ = _tmp11_;
		g_debug ("%s had neither audio nor video/picture " "streams. Ignoring.", _tmp12_);
		_g_free0 (_tmp12_);
		result = NULL;
		__g_list_free__g_object_unref0_0 (video_streams);
		__g_list_free__g_object_unref0_0 (audio_streams);
		_g_free0 (id);
		_g_object_unref0 (item);
		return result;
	}
	_tmp14_ = audio_streams;
	if (_tmp14_ == NULL) {
		GList* _tmp15_;
		gconstpointer _tmp16_;
		gboolean _tmp17_ = FALSE;
		_tmp15_ = video_streams;
		_tmp16_ = _tmp15_->data;
		_tmp17_ = gst_discoverer_video_info_is_image ((GstDiscovererVideoInfo*) _tmp16_);
		_tmp13_ = _tmp17_;
	} else {
		_tmp13_ = FALSE;
	}
	_tmp18_ = _tmp13_;
	if (_tmp18_) {
		const gchar* _tmp19_;
		RygelMediaContainer* _tmp20_;
		RygelMediaExportPhotoItem* _tmp21_;
		RygelMediaItem* _tmp22_;
		GFile* _tmp23_;
		GstDiscovererInfo* _tmp24_;
		GUPnPDLNAProfile* _tmp25_;
		GList* _tmp26_;
		gconstpointer _tmp27_;
		GFileInfo* _tmp28_;
		RygelMediaItem* _tmp29_ = NULL;
		_tmp19_ = id;
		_tmp20_ = parent;
		_tmp21_ = rygel_media_export_photo_item_new (_tmp19_, _tmp20_, "", RYGEL_PHOTO_ITEM_UPNP_CLASS);
		_g_object_unref0 (item);
		item = (RygelMediaItem*) _tmp21_;
		_tmp22_ = item;
		_tmp23_ = file;
		_tmp24_ = info;
		_tmp25_ = profile;
		_tmp26_ = video_streams;
		_tmp27_ = _tmp26_->data;
		_tmp28_ = file_info;
		_tmp29_ = rygel_media_export_item_factory_fill_photo_item (G_TYPE_CHECK_INSTANCE_TYPE (_tmp22_, RYGEL_MEDIA_EXPORT_TYPE_PHOTO_ITEM) ? ((RygelMediaExportPhotoItem*) _tmp22_) : NULL, _tmp23_, _tmp24_, _tmp25_, (GstDiscovererVideoInfo*) _tmp27_, _tmp28_);
		result = _tmp29_;
		__g_list_free__g_object_unref0_0 (video_streams);
		__g_list_free__g_object_unref0_0 (audio_streams);
		_g_free0 (id);
		_g_object_unref0 (item);
		return result;
	} else {
		GList* _tmp30_;
		_tmp30_ = video_streams;
		if (_tmp30_ != NULL) {
			const gchar* _tmp31_;
			RygelMediaContainer* _tmp32_;
			RygelMediaExportVideoItem* _tmp33_;
			gpointer _tmp34_;
			GstDiscovererAudioInfo* _tmp35_;
			GstDiscovererAudioInfo* audio_info;
			GList* _tmp36_;
			RygelMediaItem* _tmp40_;
			GFile* _tmp41_;
			GstDiscovererInfo* _tmp42_;
			GUPnPDLNAProfile* _tmp43_;
			GList* _tmp44_;
			gconstpointer _tmp45_;
			GstDiscovererAudioInfo* _tmp46_;
			GFileInfo* _tmp47_;
			RygelMediaItem* _tmp48_ = NULL;
			_tmp31_ = id;
			_tmp32_ = parent;
			_tmp33_ = rygel_media_export_video_item_new (_tmp31_, _tmp32_, "", RYGEL_VIDEO_ITEM_UPNP_CLASS);
			_g_object_unref0 (item);
			item = (RygelMediaItem*) _tmp33_;
			_tmp34_ = NULL;
			_tmp35_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp34_, gst_discoverer_audio_info_get_type ()) ? ((GstDiscovererAudioInfo*) _tmp34_) : NULL);
			audio_info = _tmp35_;
			_tmp36_ = audio_streams;
			if (_tmp36_ != NULL) {
				GList* _tmp37_;
				gconstpointer _tmp38_;
				GstDiscovererAudioInfo* _tmp39_;
				_tmp37_ = audio_streams;
				_tmp38_ = _tmp37_->data;
				_tmp39_ = _g_object_ref0 ((GstDiscovererAudioInfo*) _tmp38_);
				_g_object_unref0 (audio_info);
				audio_info = _tmp39_;
			}
			_tmp40_ = item;
			_tmp41_ = file;
			_tmp42_ = info;
			_tmp43_ = profile;
			_tmp44_ = video_streams;
			_tmp45_ = _tmp44_->data;
			_tmp46_ = audio_info;
			_tmp47_ = file_info;
			_tmp48_ = rygel_media_export_item_factory_fill_video_item (G_TYPE_CHECK_INSTANCE_TYPE (_tmp40_, RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM) ? ((RygelMediaExportVideoItem*) _tmp40_) : NULL, _tmp41_, _tmp42_, _tmp43_, (GstDiscovererVideoInfo*) _tmp45_, _tmp46_, _tmp47_);
			result = _tmp48_;
			_g_object_unref0 (audio_info);
			__g_list_free__g_object_unref0_0 (video_streams);
			__g_list_free__g_object_unref0_0 (audio_streams);
			_g_free0 (id);
			_g_object_unref0 (item);
			return result;
		} else {
			GList* _tmp49_;
			_tmp49_ = audio_streams;
			if (_tmp49_ != NULL) {
				const gchar* _tmp50_;
				RygelMediaContainer* _tmp51_;
				RygelMediaExportMusicItem* _tmp52_;
				RygelMediaItem* _tmp53_;
				GFile* _tmp54_;
				GstDiscovererInfo* _tmp55_;
				GUPnPDLNAProfile* _tmp56_;
				GList* _tmp57_;
				gconstpointer _tmp58_;
				GFileInfo* _tmp59_;
				RygelMediaItem* _tmp60_ = NULL;
				_tmp50_ = id;
				_tmp51_ = parent;
				_tmp52_ = rygel_media_export_music_item_new (_tmp50_, _tmp51_, "", RYGEL_MUSIC_ITEM_UPNP_CLASS);
				_g_object_unref0 (item);
				item = (RygelMediaItem*) _tmp52_;
				_tmp53_ = item;
				_tmp54_ = file;
				_tmp55_ = info;
				_tmp56_ = profile;
				_tmp57_ = audio_streams;
				_tmp58_ = _tmp57_->data;
				_tmp59_ = file_info;
				_tmp60_ = rygel_media_export_item_factory_fill_music_item (G_TYPE_CHECK_INSTANCE_TYPE (_tmp53_, RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM) ? ((RygelMediaExportMusicItem*) _tmp53_) : NULL, _tmp54_, _tmp55_, _tmp56_, (GstDiscovererAudioInfo*) _tmp58_, _tmp59_);
				result = _tmp60_;
				__g_list_free__g_object_unref0_0 (video_streams);
				__g_list_free__g_object_unref0_0 (audio_streams);
				_g_free0 (id);
				_g_object_unref0 (item);
				return result;
			} else {
				result = NULL;
				__g_list_free__g_object_unref0_0 (video_streams);
				__g_list_free__g_object_unref0_0 (audio_streams);
				_g_free0 (id);
				_g_object_unref0 (item);
				return result;
			}
		}
	}
	__g_list_free__g_object_unref0_0 (video_streams);
	__g_list_free__g_object_unref0_0 (audio_streams);
	_g_free0 (id);
	_g_object_unref0 (item);
}


static gpointer _gst_mini_object_ref0 (gpointer self) {
	return self ? gst_mini_object_ref (self) : NULL;
}


void rygel_media_export_item_factory_fill_audio_item (RygelAudioItem* item, GstDiscovererInfo* info, GstDiscovererAudioInfo* audio_info) {
	GstDiscovererInfo* _tmp0_;
	GstClockTime _tmp1_ = 0ULL;
	GstDiscovererAudioInfo* _tmp6_;
	GstDiscovererAudioInfo* _tmp7_;
	GstTagList* _tmp8_ = NULL;
	GstTagList* _tmp9_;
	GstTagList* tags;
	GstTagList* _tmp10_;
	RygelAudioItem* _tmp15_;
	GstDiscovererAudioInfo* _tmp16_;
	guint _tmp17_ = 0U;
	RygelAudioItem* _tmp18_;
	GstDiscovererAudioInfo* _tmp19_;
	guint _tmp20_ = 0U;
	g_return_if_fail (item != NULL);
	g_return_if_fail (info != NULL);
	_tmp0_ = info;
	_tmp1_ = gst_discoverer_info_get_duration (_tmp0_);
	if (_tmp1_ > ((GstClockTime) 0)) {
		RygelAudioItem* _tmp2_;
		GstDiscovererInfo* _tmp3_;
		GstClockTime _tmp4_ = 0ULL;
		_tmp2_ = item;
		_tmp3_ = info;
		_tmp4_ = gst_discoverer_info_get_duration (_tmp3_);
		rygel_audio_item_set_duration (_tmp2_, (glong) (_tmp4_ / GST_SECOND));
	} else {
		RygelAudioItem* _tmp5_;
		_tmp5_ = item;
		rygel_audio_item_set_duration (_tmp5_, (glong) (-1));
	}
	_tmp6_ = audio_info;
	if (_tmp6_ == NULL) {
		return;
	}
	_tmp7_ = audio_info;
	_tmp8_ = gst_discoverer_stream_info_get_tags ((GstDiscovererStreamInfo*) _tmp7_);
	_tmp9_ = _gst_mini_object_ref0 (_tmp8_);
	tags = _tmp9_;
	_tmp10_ = tags;
	if (_tmp10_ != NULL) {
		guint tmp = 0U;
		GstTagList* _tmp11_;
		guint _tmp12_ = 0U;
		RygelAudioItem* _tmp13_;
		guint _tmp14_;
		_tmp11_ = tags;
		gst_tag_list_get_uint (_tmp11_, GST_TAG_BITRATE, &_tmp12_);
		tmp = _tmp12_;
		_tmp13_ = item;
		_tmp14_ = tmp;
		rygel_audio_item_set_bitrate (_tmp13_, ((gint) _tmp14_) / 8);
	}
	_tmp15_ = item;
	_tmp16_ = audio_info;
	_tmp17_ = gst_discoverer_audio_info_get_channels (_tmp16_);
	rygel_audio_item_set_channels (_tmp15_, (gint) _tmp17_);
	_tmp18_ = item;
	_tmp19_ = audio_info;
	_tmp20_ = gst_discoverer_audio_info_get_sample_rate (_tmp19_);
	rygel_audio_item_set_sample_freq (_tmp18_, (gint) _tmp20_);
	_gst_mini_object_unref0 (tags);
}


RygelMediaItem* rygel_media_export_item_factory_fill_video_item (RygelMediaExportVideoItem* item, GFile* file, GstDiscovererInfo* info, GUPnPDLNAProfile* profile, GstDiscovererVideoInfo* video_info, GstDiscovererAudioInfo* audio_info, GFileInfo* file_info) {
	RygelMediaItem* result = NULL;
	RygelMediaExportVideoItem* _tmp0_;
	GstDiscovererInfo* _tmp1_;
	GstDiscovererAudioInfo* _tmp2_;
	RygelMediaExportVideoItem* _tmp3_;
	GFile* _tmp4_;
	GstDiscovererInfo* _tmp5_;
	GUPnPDLNAProfile* _tmp6_;
	GFileInfo* _tmp7_;
	RygelMediaExportVideoItem* _tmp8_;
	GstDiscovererVideoInfo* _tmp9_;
	guint _tmp10_ = 0U;
	RygelMediaExportVideoItem* _tmp11_;
	GstDiscovererVideoInfo* _tmp12_;
	guint _tmp13_ = 0U;
	GstDiscovererVideoInfo* _tmp14_;
	guint _tmp15_ = 0U;
	gint color_depth;
	gint _tmp16_ = 0;
	gint _tmp17_;
	RygelMediaExportVideoItem* _tmp19_;
	gint _tmp20_;
	RygelMediaExportVideoItem* _tmp21_;
	RygelMediaItem* _tmp22_;
	g_return_val_if_fail (item != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	g_return_val_if_fail (info != NULL, NULL);
	g_return_val_if_fail (video_info != NULL, NULL);
	g_return_val_if_fail (file_info != NULL, NULL);
	_tmp0_ = item;
	_tmp1_ = info;
	_tmp2_ = audio_info;
	rygel_media_export_item_factory_fill_audio_item (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, RYGEL_TYPE_AUDIO_ITEM) ? ((RygelAudioItem*) _tmp0_) : NULL, _tmp1_, _tmp2_);
	_tmp3_ = item;
	_tmp4_ = file;
	_tmp5_ = info;
	_tmp6_ = profile;
	_tmp7_ = file_info;
	rygel_media_export_item_factory_fill_media_item ((RygelMediaItem*) _tmp3_, _tmp4_, _tmp5_, _tmp6_, _tmp7_);
	_tmp8_ = item;
	_tmp9_ = video_info;
	_tmp10_ = gst_discoverer_video_info_get_width (_tmp9_);
	rygel_visual_item_set_width ((RygelVisualItem*) _tmp8_, (gint) _tmp10_);
	_tmp11_ = item;
	_tmp12_ = video_info;
	_tmp13_ = gst_discoverer_video_info_get_height (_tmp12_);
	rygel_visual_item_set_height ((RygelVisualItem*) _tmp11_, (gint) _tmp13_);
	_tmp14_ = video_info;
	_tmp15_ = gst_discoverer_video_info_get_depth (_tmp14_);
	color_depth = (gint) _tmp15_;
	_tmp17_ = color_depth;
	if (_tmp17_ == 0) {
		_tmp16_ = -1;
	} else {
		gint _tmp18_;
		_tmp18_ = color_depth;
		_tmp16_ = _tmp18_;
	}
	_tmp19_ = item;
	_tmp20_ = _tmp16_;
	rygel_visual_item_set_color_depth ((RygelVisualItem*) _tmp19_, _tmp20_);
	_tmp21_ = item;
	_tmp22_ = _g_object_ref0 ((RygelMediaItem*) _tmp21_);
	result = _tmp22_;
	return result;
}


RygelMediaItem* rygel_media_export_item_factory_fill_photo_item (RygelMediaExportPhotoItem* item, GFile* file, GstDiscovererInfo* info, GUPnPDLNAProfile* profile, GstDiscovererVideoInfo* video_info, GFileInfo* file_info) {
	RygelMediaItem* result = NULL;
	RygelMediaExportPhotoItem* _tmp0_;
	GFile* _tmp1_;
	GstDiscovererInfo* _tmp2_;
	GUPnPDLNAProfile* _tmp3_;
	GFileInfo* _tmp4_;
	RygelMediaExportPhotoItem* _tmp5_;
	GstDiscovererVideoInfo* _tmp6_;
	guint _tmp7_ = 0U;
	RygelMediaExportPhotoItem* _tmp8_;
	GstDiscovererVideoInfo* _tmp9_;
	guint _tmp10_ = 0U;
	GstDiscovererVideoInfo* _tmp11_;
	guint _tmp12_ = 0U;
	gint color_depth;
	gint _tmp13_ = 0;
	gint _tmp14_;
	RygelMediaExportPhotoItem* _tmp16_;
	gint _tmp17_;
	RygelMediaExportPhotoItem* _tmp18_;
	RygelMediaItem* _tmp19_;
	g_return_val_if_fail (item != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	g_return_val_if_fail (info != NULL, NULL);
	g_return_val_if_fail (video_info != NULL, NULL);
	g_return_val_if_fail (file_info != NULL, NULL);
	_tmp0_ = item;
	_tmp1_ = file;
	_tmp2_ = info;
	_tmp3_ = profile;
	_tmp4_ = file_info;
	rygel_media_export_item_factory_fill_media_item ((RygelMediaItem*) _tmp0_, _tmp1_, _tmp2_, _tmp3_, _tmp4_);
	_tmp5_ = item;
	_tmp6_ = video_info;
	_tmp7_ = gst_discoverer_video_info_get_width (_tmp6_);
	rygel_visual_item_set_width ((RygelVisualItem*) _tmp5_, (gint) _tmp7_);
	_tmp8_ = item;
	_tmp9_ = video_info;
	_tmp10_ = gst_discoverer_video_info_get_height (_tmp9_);
	rygel_visual_item_set_height ((RygelVisualItem*) _tmp8_, (gint) _tmp10_);
	_tmp11_ = video_info;
	_tmp12_ = gst_discoverer_video_info_get_depth (_tmp11_);
	color_depth = (gint) _tmp12_;
	_tmp14_ = color_depth;
	if (_tmp14_ == 0) {
		_tmp13_ = -1;
	} else {
		gint _tmp15_;
		_tmp15_ = color_depth;
		_tmp13_ = _tmp15_;
	}
	_tmp16_ = item;
	_tmp17_ = _tmp13_;
	rygel_visual_item_set_color_depth ((RygelVisualItem*) _tmp16_, _tmp17_);
	_tmp18_ = item;
	_tmp19_ = _g_object_ref0 ((RygelMediaItem*) _tmp18_);
	result = _tmp19_;
	return result;
}


static void _vala_GstSample_free (GstSample* self) {
	g_boxed_free (gst_sample_get_type (), self);
}


static GstStructure* _vala_GstStructure_copy (GstStructure* self) {
	return g_boxed_copy (gst_structure_get_type (), self);
}


static gpointer __vala_GstStructure_copy0 (gpointer self) {
	return self ? _vala_GstStructure_copy (self) : NULL;
}


static void _vala_GstStructure_free (GstStructure* self) {
	g_boxed_free (gst_structure_get_type (), self);
}


RygelMediaItem* rygel_media_export_item_factory_fill_music_item (RygelMediaExportMusicItem* item, GFile* file, GstDiscovererInfo* info, GUPnPDLNAProfile* profile, GstDiscovererAudioInfo* audio_info, GFileInfo* file_info) {
	RygelMediaItem* result = NULL;
	RygelMediaExportMusicItem* _tmp0_;
	GstDiscovererInfo* _tmp1_;
	GstDiscovererAudioInfo* _tmp2_;
	RygelMediaExportMusicItem* _tmp3_;
	GFile* _tmp4_;
	GstDiscovererInfo* _tmp5_;
	GUPnPDLNAProfile* _tmp6_;
	GFileInfo* _tmp7_;
	GstDiscovererAudioInfo* _tmp8_;
	GstDiscovererAudioInfo* _tmp11_;
	GstTagList* _tmp12_ = NULL;
	GstTagList* _tmp13_;
	GstTagList* tags;
	GstTagList* _tmp14_;
	gchar* artist = NULL;
	GstTagList* _tmp17_;
	gchar* _tmp18_ = NULL;
	RygelMediaExportMusicItem* _tmp19_;
	const gchar* _tmp20_;
	gchar* album = NULL;
	GstTagList* _tmp21_;
	gchar* _tmp22_ = NULL;
	RygelMediaExportMusicItem* _tmp23_;
	const gchar* _tmp24_;
	gchar* genre = NULL;
	GstTagList* _tmp25_;
	gchar* _tmp26_ = NULL;
	RygelMediaExportMusicItem* _tmp27_;
	const gchar* _tmp28_;
	guint tmp = 0U;
	GstTagList* _tmp29_;
	guint _tmp30_ = 0U;
	RygelMediaExportMusicItem* _tmp31_;
	guint _tmp32_;
	GstTagList* _tmp33_;
	guint _tmp34_ = 0U;
	RygelMediaExportMusicItem* _tmp35_;
	guint _tmp36_;
	GstSample* sample = NULL;
	GstTagList* _tmp37_;
	GstSample* _tmp38_ = NULL;
	GstSample* _tmp39_;
	GstSample* _tmp42_;
	GstCaps* _tmp43_ = NULL;
	GstStructure* _tmp44_ = NULL;
	GstStructure* _tmp45_;
	GstStructure* structure;
	gint image_type = 0;
	GstStructure* _tmp46_;
	gint _tmp47_ = 0;
	gint _tmp48_;
	RygelMediaExportMusicItem* _tmp58_;
	RygelMediaItem* _tmp59_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (item != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	g_return_val_if_fail (info != NULL, NULL);
	g_return_val_if_fail (file_info != NULL, NULL);
	_tmp0_ = item;
	_tmp1_ = info;
	_tmp2_ = audio_info;
	rygel_media_export_item_factory_fill_audio_item (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, RYGEL_TYPE_AUDIO_ITEM) ? ((RygelAudioItem*) _tmp0_) : NULL, _tmp1_, _tmp2_);
	_tmp3_ = item;
	_tmp4_ = file;
	_tmp5_ = info;
	_tmp6_ = profile;
	_tmp7_ = file_info;
	rygel_media_export_item_factory_fill_media_item ((RygelMediaItem*) _tmp3_, _tmp4_, _tmp5_, _tmp6_, _tmp7_);
	_tmp8_ = audio_info;
	if (_tmp8_ == NULL) {
		RygelMediaExportMusicItem* _tmp9_;
		RygelMediaItem* _tmp10_;
		_tmp9_ = item;
		_tmp10_ = _g_object_ref0 ((RygelMediaItem*) _tmp9_);
		result = _tmp10_;
		return result;
	}
	_tmp11_ = audio_info;
	_tmp12_ = gst_discoverer_stream_info_get_tags ((GstDiscovererStreamInfo*) _tmp11_);
	_tmp13_ = _gst_mini_object_ref0 (_tmp12_);
	tags = _tmp13_;
	_tmp14_ = tags;
	if (_tmp14_ == NULL) {
		RygelMediaExportMusicItem* _tmp15_;
		RygelMediaItem* _tmp16_;
		_tmp15_ = item;
		_tmp16_ = _g_object_ref0 ((RygelMediaItem*) _tmp15_);
		result = _tmp16_;
		_gst_mini_object_unref0 (tags);
		return result;
	}
	_tmp17_ = tags;
	gst_tag_list_get_string (_tmp17_, GST_TAG_ARTIST, &_tmp18_);
	_g_free0 (artist);
	artist = _tmp18_;
	_tmp19_ = item;
	_tmp20_ = artist;
	rygel_music_item_set_artist ((RygelMusicItem*) _tmp19_, _tmp20_);
	_tmp21_ = tags;
	gst_tag_list_get_string (_tmp21_, GST_TAG_ALBUM, &_tmp22_);
	_g_free0 (album);
	album = _tmp22_;
	_tmp23_ = item;
	_tmp24_ = album;
	rygel_music_item_set_album ((RygelMusicItem*) _tmp23_, _tmp24_);
	_tmp25_ = tags;
	gst_tag_list_get_string (_tmp25_, GST_TAG_GENRE, &_tmp26_);
	_g_free0 (genre);
	genre = _tmp26_;
	_tmp27_ = item;
	_tmp28_ = genre;
	rygel_music_item_set_genre ((RygelMusicItem*) _tmp27_, _tmp28_);
	_tmp29_ = tags;
	gst_tag_list_get_uint (_tmp29_, GST_TAG_ALBUM_VOLUME_NUMBER, &_tmp30_);
	tmp = _tmp30_;
	_tmp31_ = item;
	_tmp32_ = tmp;
	_tmp31_->disc = (gint) _tmp32_;
	_tmp33_ = tags;
	gst_tag_list_get_uint (_tmp33_, GST_TAG_TRACK_NUMBER, &_tmp34_);
	tmp = _tmp34_;
	_tmp35_ = item;
	_tmp36_ = tmp;
	rygel_music_item_set_track_number ((RygelMusicItem*) _tmp35_, (gint) _tmp36_);
	_tmp37_ = tags;
	gst_tag_list_get_sample (_tmp37_, GST_TAG_IMAGE, &_tmp38_);
	__vala_GstSample_free0 (sample);
	sample = _tmp38_;
	_tmp39_ = sample;
	if (_tmp39_ == NULL) {
		RygelMediaExportMusicItem* _tmp40_;
		RygelMediaItem* _tmp41_;
		_tmp40_ = item;
		_tmp41_ = _g_object_ref0 ((RygelMediaItem*) _tmp40_);
		result = _tmp41_;
		__vala_GstSample_free0 (sample);
		_g_free0 (genre);
		_g_free0 (album);
		_g_free0 (artist);
		_gst_mini_object_unref0 (tags);
		return result;
	}
	_tmp42_ = sample;
	_tmp43_ = gst_sample_get_caps (_tmp42_);
	_tmp44_ = gst_caps_get_structure (_tmp43_, (guint) 0);
	_tmp45_ = __vala_GstStructure_copy0 (_tmp44_);
	structure = _tmp45_;
	_tmp46_ = structure;
	gst_structure_get_enum (_tmp46_, "image-type", gst_tag_image_type_get_type (), &_tmp47_);
	image_type = _tmp47_;
	_tmp48_ = image_type;
	switch (_tmp48_) {
		case GST_TAG_IMAGE_TYPE_UNDEFINED:
		case GST_TAG_IMAGE_TYPE_FRONT_COVER:
		{
			RygelMediaArtStore* _tmp49_ = NULL;
			RygelMediaArtStore* store;
			RygelMediaArtStore* _tmp50_;
			RygelMediaExportMusicItem* _tmp51_;
			GFile* _tmp52_ = NULL;
			GFile* thumb;
			_tmp49_ = rygel_media_art_store_get_default ();
			store = _tmp49_;
			_tmp50_ = store;
			_tmp51_ = item;
			_tmp52_ = rygel_media_art_store_get_media_art_file (_tmp50_, "album", (RygelMusicItem*) _tmp51_, TRUE);
			thumb = _tmp52_;
			{
				RygelMediaExportJPEGWriter* _tmp53_;
				RygelMediaExportJPEGWriter* writer;
				RygelMediaExportJPEGWriter* _tmp54_;
				GstSample* _tmp55_;
				GstBuffer* _tmp56_ = NULL;
				GFile* _tmp57_;
				_tmp53_ = rygel_media_export_jpeg_writer_new (&_inner_error_);
				writer = _tmp53_;
				if (_inner_error_ != NULL) {
					goto __catch66_g_error;
				}
				_tmp54_ = writer;
				_tmp55_ = sample;
				_tmp56_ = gst_sample_get_buffer (_tmp55_);
				_tmp57_ = thumb;
				rygel_media_export_jpeg_writer_write (_tmp54_, _tmp56_, _tmp57_);
				_g_object_unref0 (writer);
			}
			goto __finally66;
			__catch66_g_error:
			{
				GError* _error_ = NULL;
				_error_ = _inner_error_;
				_inner_error_ = NULL;
				_g_error_free0 (_error_);
			}
			__finally66:
			if (_inner_error_ != NULL) {
				_g_object_unref0 (thumb);
				_g_object_unref0 (store);
				__vala_GstStructure_free0 (structure);
				__vala_GstSample_free0 (sample);
				_g_free0 (genre);
				_g_free0 (album);
				_g_free0 (artist);
				_gst_mini_object_unref0 (tags);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
			_g_object_unref0 (thumb);
			_g_object_unref0 (store);
			break;
		}
		default:
		{
			break;
		}
	}
	_tmp58_ = item;
	_tmp59_ = _g_object_ref0 ((RygelMediaItem*) _tmp58_);
	result = _tmp59_;
	__vala_GstStructure_free0 (structure);
	__vala_GstSample_free0 (sample);
	_g_free0 (genre);
	_g_free0 (album);
	_g_free0 (artist);
	_gst_mini_object_unref0 (tags);
	return result;
}


static void _vala_GstDateTime_free (GstDateTime* self) {
	g_boxed_free (gst_date_time_get_type (), self);
}


void rygel_media_export_item_factory_fill_media_item (RygelMediaItem* item, GFile* file, GstDiscovererInfo* info, GUPnPDLNAProfile* profile, GFileInfo* file_info) {
	gchar* title;
	GstDiscovererInfo* _tmp0_;
	GstTagList* _tmp1_ = NULL;
	GstTagList* _tmp2_;
	GstTagList* tags;
	gboolean _tmp3_ = FALSE;
	GstTagList* _tmp4_;
	gboolean _tmp8_;
	GstDateTime* dt;
	gboolean _tmp12_ = FALSE;
	GstTagList* _tmp13_;
	gboolean _tmp17_;
	RygelMediaItem* _tmp22_;
	const gchar* _tmp23_;
	GFileInfo* _tmp24_;
	guint64 _tmp25_ = 0ULL;
	guint64 mtime;
	RygelMediaItem* _tmp26_;
	const gchar* _tmp27_;
	const gchar* _tmp28_;
	RygelMediaItem* _tmp34_;
	GFileInfo* _tmp35_;
	gint64 _tmp36_ = 0LL;
	RygelMediaItem* _tmp37_;
	guint64 _tmp38_;
	gboolean _tmp39_ = FALSE;
	GUPnPDLNAProfile* _tmp40_;
	gboolean _tmp44_;
	RygelMediaItem* _tmp58_;
	GFile* _tmp59_;
	gchar* _tmp60_ = NULL;
	gchar* _tmp61_;
	g_return_if_fail (item != NULL);
	g_return_if_fail (file != NULL);
	g_return_if_fail (info != NULL);
	g_return_if_fail (file_info != NULL);
	title = NULL;
	_tmp0_ = info;
	_tmp1_ = gst_discoverer_info_get_tags (_tmp0_);
	_tmp2_ = _gst_mini_object_ref0 (_tmp1_);
	tags = _tmp2_;
	_tmp4_ = tags;
	if (_tmp4_ == NULL) {
		_tmp3_ = TRUE;
	} else {
		GstTagList* _tmp5_;
		gchar* _tmp6_ = NULL;
		gboolean _tmp7_ = FALSE;
		_tmp5_ = tags;
		_tmp7_ = gst_tag_list_get_string (_tmp5_, GST_TAG_TITLE, &_tmp6_);
		_g_free0 (title);
		title = _tmp6_;
		_tmp3_ = !_tmp7_;
	}
	_tmp8_ = _tmp3_;
	if (_tmp8_) {
		GFileInfo* _tmp9_;
		const gchar* _tmp10_ = NULL;
		gchar* _tmp11_;
		_tmp9_ = file_info;
		_tmp10_ = g_file_info_get_display_name (_tmp9_);
		_tmp11_ = g_strdup (_tmp10_);
		_g_free0 (title);
		title = _tmp11_;
	}
	dt = NULL;
	_tmp13_ = tags;
	if (_tmp13_ != NULL) {
		GstTagList* _tmp14_;
		GstDateTime* _tmp15_ = NULL;
		gboolean _tmp16_ = FALSE;
		_tmp14_ = tags;
		_tmp16_ = gst_tag_list_get_date_time (_tmp14_, GST_TAG_DATE_TIME, &_tmp15_);
		__vala_GstDateTime_free0 (dt);
		dt = _tmp15_;
		_tmp12_ = _tmp16_;
	} else {
		_tmp12_ = FALSE;
	}
	_tmp17_ = _tmp12_;
	if (_tmp17_) {
		RygelMediaItem* _tmp18_;
		GstDateTime* _tmp19_;
		gchar* _tmp20_ = NULL;
		gchar* _tmp21_;
		_tmp18_ = item;
		_tmp19_ = dt;
		_tmp20_ = gst_date_time_to_iso8601_string (_tmp19_);
		_tmp21_ = _tmp20_;
		rygel_media_item_set_date (_tmp18_, _tmp21_);
		_g_free0 (_tmp21_);
	}
	_tmp22_ = item;
	_tmp23_ = title;
	rygel_media_object_set_title ((RygelMediaObject*) _tmp22_, _tmp23_);
	_tmp24_ = file_info;
	_tmp25_ = g_file_info_get_attribute_uint64 (_tmp24_, G_FILE_ATTRIBUTE_TIME_MODIFIED);
	mtime = _tmp25_;
	_tmp26_ = item;
	_tmp27_ = rygel_media_item_get_date (_tmp26_);
	_tmp28_ = _tmp27_;
	if (_tmp28_ == NULL) {
		guint64 _tmp29_;
		GTimeVal _tmp30_ = {0};
		GTimeVal tv;
		RygelMediaItem* _tmp31_;
		gchar* _tmp32_ = NULL;
		gchar* _tmp33_;
		_tmp29_ = mtime;
		_tmp30_.tv_sec = (glong) _tmp29_;
		_tmp30_.tv_usec = (glong) 0;
		tv = _tmp30_;
		_tmp31_ = item;
		_tmp32_ = g_time_val_to_iso8601 (&tv);
		_tmp33_ = _tmp32_;
		rygel_media_item_set_date (_tmp31_, _tmp33_);
		_g_free0 (_tmp33_);
	}
	_tmp34_ = item;
	_tmp35_ = file_info;
	_tmp36_ = g_file_info_get_size (_tmp35_);
	rygel_media_item_set_size (_tmp34_, (gint64) _tmp36_);
	_tmp37_ = item;
	_tmp38_ = mtime;
	rygel_media_object_set_modified ((RygelMediaObject*) _tmp37_, (guint64) ((gint64) _tmp38_));
	_tmp40_ = profile;
	if (_tmp40_ != NULL) {
		GUPnPDLNAProfile* _tmp41_;
		const gchar* _tmp42_;
		const gchar* _tmp43_;
		_tmp41_ = profile;
		_tmp42_ = gupnp_dlna_profile_get_name (_tmp41_);
		_tmp43_ = _tmp42_;
		_tmp39_ = _tmp43_ != NULL;
	} else {
		_tmp39_ = FALSE;
	}
	_tmp44_ = _tmp39_;
	if (_tmp44_) {
		RygelMediaItem* _tmp45_;
		GUPnPDLNAProfile* _tmp46_;
		const gchar* _tmp47_;
		const gchar* _tmp48_;
		RygelMediaItem* _tmp49_;
		GUPnPDLNAProfile* _tmp50_;
		const gchar* _tmp51_;
		const gchar* _tmp52_;
		_tmp45_ = item;
		_tmp46_ = profile;
		_tmp47_ = gupnp_dlna_profile_get_name (_tmp46_);
		_tmp48_ = _tmp47_;
		rygel_media_item_set_dlna_profile (_tmp45_, _tmp48_);
		_tmp49_ = item;
		_tmp50_ = profile;
		_tmp51_ = gupnp_dlna_profile_get_mime (_tmp50_);
		_tmp52_ = _tmp51_;
		rygel_media_item_set_mime_type (_tmp49_, _tmp52_);
	} else {
		RygelMediaItem* _tmp53_;
		GFileInfo* _tmp54_;
		const gchar* _tmp55_ = NULL;
		gchar* _tmp56_ = NULL;
		gchar* _tmp57_;
		_tmp53_ = item;
		_tmp54_ = file_info;
		_tmp55_ = g_file_info_get_content_type (_tmp54_);
		_tmp56_ = g_content_type_get_mime_type (_tmp55_);
		_tmp57_ = _tmp56_;
		rygel_media_item_set_mime_type (_tmp53_, _tmp57_);
		_g_free0 (_tmp57_);
	}
	_tmp58_ = item;
	_tmp59_ = file;
	_tmp60_ = g_file_get_uri (_tmp59_);
	_tmp61_ = _tmp60_;
	rygel_media_item_add_uri (_tmp58_, _tmp61_);
	_g_free0 (_tmp61_);
	__vala_GstDateTime_free0 (dt);
	_gst_mini_object_unref0 (tags);
	_g_free0 (title);
}



