/* rygel-media-device.c generated by valac 0.20.1, the Vala compiler
 * generated from rygel-media-device.vala, do not modify */

/*
 * Copyright (C) 2012 Openismus GmbH.
 *
 * Author: Jens Georg <jensg@openismus.com>
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libgupnp/gupnp.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <libgssdp/gssdp.h>
#include <gobject/gvaluecollector.h>


#define RYGEL_TYPE_DEVICE_CONTEXT (rygel_device_context_get_type ())
#define RYGEL_DEVICE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_DEVICE_CONTEXT, RygelDeviceContext))
#define RYGEL_DEVICE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_DEVICE_CONTEXT, RygelDeviceContextClass))
#define RYGEL_IS_DEVICE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_DEVICE_CONTEXT))
#define RYGEL_IS_DEVICE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_DEVICE_CONTEXT))
#define RYGEL_DEVICE_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_DEVICE_CONTEXT, RygelDeviceContextClass))

typedef struct _RygelDeviceContext RygelDeviceContext;
typedef struct _RygelDeviceContextClass RygelDeviceContextClass;
typedef struct _RygelDeviceContextPrivate RygelDeviceContextPrivate;

#define RYGEL_TYPE_ROOT_DEVICE (rygel_root_device_get_type ())
#define RYGEL_ROOT_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ROOT_DEVICE, RygelRootDevice))
#define RYGEL_ROOT_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ROOT_DEVICE, RygelRootDeviceClass))
#define RYGEL_IS_ROOT_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ROOT_DEVICE))
#define RYGEL_IS_ROOT_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ROOT_DEVICE))
#define RYGEL_ROOT_DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ROOT_DEVICE, RygelRootDeviceClass))

typedef struct _RygelRootDevice RygelRootDevice;
typedef struct _RygelRootDeviceClass RygelRootDeviceClass;

#define RYGEL_TYPE_ROOT_DEVICE_FACTORY (rygel_root_device_factory_get_type ())
#define RYGEL_ROOT_DEVICE_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ROOT_DEVICE_FACTORY, RygelRootDeviceFactory))
#define RYGEL_ROOT_DEVICE_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ROOT_DEVICE_FACTORY, RygelRootDeviceFactoryClass))
#define RYGEL_IS_ROOT_DEVICE_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ROOT_DEVICE_FACTORY))
#define RYGEL_IS_ROOT_DEVICE_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ROOT_DEVICE_FACTORY))
#define RYGEL_ROOT_DEVICE_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ROOT_DEVICE_FACTORY, RygelRootDeviceFactoryClass))

typedef struct _RygelRootDeviceFactory RygelRootDeviceFactory;
typedef struct _RygelRootDeviceFactoryClass RygelRootDeviceFactoryClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_PLUGIN (rygel_plugin_get_type ())
#define RYGEL_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLUGIN, RygelPlugin))
#define RYGEL_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PLUGIN, RygelPluginClass))
#define RYGEL_IS_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLUGIN))
#define RYGEL_IS_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PLUGIN))
#define RYGEL_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PLUGIN, RygelPluginClass))

typedef struct _RygelPlugin RygelPlugin;
typedef struct _RygelPluginClass RygelPluginClass;
#define _rygel_device_context_unref0(var) ((var == NULL) ? NULL : (var = (rygel_device_context_unref (var), NULL)))
typedef struct _RygelParamSpecDeviceContext RygelParamSpecDeviceContext;

#define RYGEL_TYPE_MEDIA_DEVICE (rygel_media_device_get_type ())
#define RYGEL_MEDIA_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_DEVICE, RygelMediaDevice))
#define RYGEL_MEDIA_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_DEVICE, RygelMediaDeviceClass))
#define RYGEL_IS_MEDIA_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_DEVICE))
#define RYGEL_IS_MEDIA_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_DEVICE))
#define RYGEL_MEDIA_DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_DEVICE, RygelMediaDeviceClass))

typedef struct _RygelMediaDevice RygelMediaDevice;
typedef struct _RygelMediaDeviceClass RygelMediaDeviceClass;
typedef struct _RygelMediaDevicePrivate RygelMediaDevicePrivate;

#define RYGEL_TYPE_PLUGIN_CAPABILITIES (rygel_plugin_capabilities_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define __g_list_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_free0_ (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _RygelDeviceContext {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelDeviceContextPrivate * priv;
	RygelRootDevice* device;
	RygelRootDeviceFactory* factory;
	GUPnPContext* context;
};

struct _RygelDeviceContextClass {
	GTypeClass parent_class;
	void (*finalize) (RygelDeviceContext *self);
};

struct _RygelParamSpecDeviceContext {
	GParamSpec parent_instance;
};

struct _RygelMediaDevice {
	GObject parent_instance;
	RygelMediaDevicePrivate * priv;
};

struct _RygelMediaDeviceClass {
	GObjectClass parent_class;
};

typedef enum  {
	RYGEL_PLUGIN_CAPABILITIES_NONE = 0,
	RYGEL_PLUGIN_CAPABILITIES_IMAGE_UPLOAD = 1 << 0,
	RYGEL_PLUGIN_CAPABILITIES_VIDEO_UPLOAD = 1 << 1,
	RYGEL_PLUGIN_CAPABILITIES_AUDIO_UPLOAD = 1 << 2,
	RYGEL_PLUGIN_CAPABILITIES_UPLOAD = (RYGEL_PLUGIN_CAPABILITIES_IMAGE_UPLOAD | RYGEL_PLUGIN_CAPABILITIES_VIDEO_UPLOAD) | RYGEL_PLUGIN_CAPABILITIES_AUDIO_UPLOAD,
	RYGEL_PLUGIN_CAPABILITIES_TRACK_CHANGES = 1 << 3,
	RYGEL_PLUGIN_CAPABILITIES_CREATE_CONTAINERS = 1 << 4
} RygelPluginCapabilities;

struct _RygelMediaDevicePrivate {
	GeeArrayList* interfaces;
	GeeHashMap* contexts;
	GeeHashMap* devices;
	GUPnPContextManager* manager;
	RygelPlugin* _plugin;
	gchar* _title;
	RygelPluginCapabilities _capabilities;
};


static gpointer rygel_device_context_parent_class = NULL;
static gpointer rygel_media_device_parent_class = NULL;

gpointer rygel_device_context_ref (gpointer instance);
void rygel_device_context_unref (gpointer instance);
GParamSpec* rygel_param_spec_device_context (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_device_context (GValue* value, gpointer v_object);
void rygel_value_take_device_context (GValue* value, gpointer v_object);
gpointer rygel_value_get_device_context (const GValue* value);
GType rygel_device_context_get_type (void) G_GNUC_CONST;
GType rygel_root_device_get_type (void) G_GNUC_CONST;
GType rygel_root_device_factory_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_DEVICE_CONTEXT_DUMMY_PROPERTY
};
GType rygel_plugin_get_type (void) G_GNUC_CONST;
RygelDeviceContext* rygel_device_context_new (GUPnPContext* context, RygelPlugin* plugin, GError** error);
RygelDeviceContext* rygel_device_context_construct (GType object_type, GUPnPContext* context, RygelPlugin* plugin, GError** error);
RygelRootDeviceFactory* rygel_root_device_factory_new (GUPnPContext* context, GError** error);
RygelRootDeviceFactory* rygel_root_device_factory_construct (GType object_type, GUPnPContext* context, GError** error);
RygelRootDevice* rygel_root_device_factory_create (RygelRootDeviceFactory* self, RygelPlugin* plugin, GError** error);
static void rygel_device_context_finalize (RygelDeviceContext* obj);
GType rygel_media_device_get_type (void) G_GNUC_CONST;
GType rygel_plugin_capabilities_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIA_DEVICE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_MEDIA_DEVICE, RygelMediaDevicePrivate))
enum  {
	RYGEL_MEDIA_DEVICE_DUMMY_PROPERTY,
	RYGEL_MEDIA_DEVICE_PLUGIN,
	RYGEL_MEDIA_DEVICE_TITLE,
	RYGEL_MEDIA_DEVICE_CAPABILITIES
};
static void rygel_media_device_real_constructed (GObject* base);
static void rygel_media_device_on_context_available (RygelMediaDevice* self, GUPnPContext* context);
static void _rygel_media_device_on_context_available_gupnp_context_manager_context_available (GUPnPContextManager* _sender, GUPnPContext* context, gpointer self);
static void rygel_media_device_on_context_unavailable (RygelMediaDevice* self, GUPnPContext* context);
static void _rygel_media_device_on_context_unavailable_gupnp_context_manager_context_unavailable (GUPnPContextManager* _sender, GUPnPContext* context, gpointer self);
void rygel_media_device_add_interface (RygelMediaDevice* self, const gchar* iface);
void rygel_media_device_remove_interface (RygelMediaDevice* self, const gchar* iface);
GList* rygel_media_device_get_interfaces (RygelMediaDevice* self);
static void _g_free0_ (gpointer var);
static void _g_list_free__g_free0_ (GList* self);
RygelPlugin* rygel_media_device_get_plugin (RygelMediaDevice* self);
RygelMediaDevice* rygel_media_device_construct (GType object_type);
void rygel_media_device_set_plugin (RygelMediaDevice* self, RygelPlugin* value);
const gchar* rygel_media_device_get_title (RygelMediaDevice* self);
static void rygel_media_device_set_title (RygelMediaDevice* self, const gchar* value);
RygelPluginCapabilities rygel_media_device_get_capabilities (RygelMediaDevice* self);
static void rygel_media_device_set_capabilities (RygelMediaDevice* self, RygelPluginCapabilities value);
static void rygel_media_device_finalize (GObject* obj);
static void _vala_rygel_media_device_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_media_device_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static gpointer _g_object_ref0 (gpointer self) {
#line 30 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	return self ? g_object_ref (self) : NULL;
#line 199 "rygel-media-device.c"
}


RygelDeviceContext* rygel_device_context_construct (GType object_type, GUPnPContext* context, RygelPlugin* plugin, GError** error) {
	RygelDeviceContext* self = NULL;
	GUPnPContext* _tmp0_;
	GUPnPContext* _tmp1_;
	GUPnPContext* _tmp2_;
	RygelRootDeviceFactory* _tmp3_;
	RygelRootDeviceFactory* _tmp4_;
	RygelRootDeviceFactory* _tmp5_;
	RygelPlugin* _tmp6_;
	RygelRootDevice* _tmp7_ = NULL;
	RygelRootDevice* _tmp8_;
	RygelRootDevice* _tmp9_;
	GError * _inner_error_ = NULL;
#line 29 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	g_return_val_if_fail (context != NULL, NULL);
#line 29 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	g_return_val_if_fail (plugin != NULL, NULL);
#line 29 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	self = (RygelDeviceContext*) g_type_create_instance (object_type);
#line 30 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp0_ = context;
#line 30 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 30 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_g_object_unref0 (self->context);
#line 30 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	self->context = _tmp1_;
#line 31 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp2_ = context;
#line 31 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp3_ = rygel_root_device_factory_new (_tmp2_, &_inner_error_);
#line 31 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp4_ = _tmp3_;
#line 31 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	if (_inner_error_ != NULL) {
#line 31 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		g_propagate_error (error, _inner_error_);
#line 31 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_rygel_device_context_unref0 (self);
#line 31 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		return NULL;
#line 244 "rygel-media-device.c"
	}
#line 31 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_g_object_unref0 (self->factory);
#line 31 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	self->factory = _tmp4_;
#line 32 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp5_ = self->factory;
#line 32 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp6_ = plugin;
#line 32 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp7_ = rygel_root_device_factory_create (_tmp5_, _tmp6_, &_inner_error_);
#line 32 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp8_ = _tmp7_;
#line 32 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	if (_inner_error_ != NULL) {
#line 32 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		g_propagate_error (error, _inner_error_);
#line 32 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_rygel_device_context_unref0 (self);
#line 32 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		return NULL;
#line 266 "rygel-media-device.c"
	}
#line 32 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_g_object_unref0 (self->device);
#line 32 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	self->device = _tmp8_;
#line 33 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp9_ = self->device;
#line 33 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	gupnp_root_device_set_available ((GUPnPRootDevice*) _tmp9_, TRUE);
#line 29 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	return self;
#line 278 "rygel-media-device.c"
}


RygelDeviceContext* rygel_device_context_new (GUPnPContext* context, RygelPlugin* plugin, GError** error) {
#line 29 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	return rygel_device_context_construct (RYGEL_TYPE_DEVICE_CONTEXT, context, plugin, error);
#line 285 "rygel-media-device.c"
}


static void rygel_value_device_context_init (GValue* value) {
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	value->data[0].v_pointer = NULL;
#line 292 "rygel-media-device.c"
}


static void rygel_value_device_context_free_value (GValue* value) {
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	if (value->data[0].v_pointer) {
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		rygel_device_context_unref (value->data[0].v_pointer);
#line 301 "rygel-media-device.c"
	}
}


static void rygel_value_device_context_copy_value (const GValue* src_value, GValue* dest_value) {
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	if (src_value->data[0].v_pointer) {
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		dest_value->data[0].v_pointer = rygel_device_context_ref (src_value->data[0].v_pointer);
#line 311 "rygel-media-device.c"
	} else {
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		dest_value->data[0].v_pointer = NULL;
#line 315 "rygel-media-device.c"
	}
}


static gpointer rygel_value_device_context_peek_pointer (const GValue* value) {
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	return value->data[0].v_pointer;
#line 323 "rygel-media-device.c"
}


static gchar* rygel_value_device_context_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	if (collect_values[0].v_pointer) {
#line 330 "rygel-media-device.c"
		RygelDeviceContext* object;
		object = collect_values[0].v_pointer;
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		if (object->parent_instance.g_class == NULL) {
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 337 "rygel-media-device.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 341 "rygel-media-device.c"
		}
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		value->data[0].v_pointer = rygel_device_context_ref (object);
#line 345 "rygel-media-device.c"
	} else {
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		value->data[0].v_pointer = NULL;
#line 349 "rygel-media-device.c"
	}
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	return NULL;
#line 353 "rygel-media-device.c"
}


static gchar* rygel_value_device_context_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	RygelDeviceContext** object_p;
	object_p = collect_values[0].v_pointer;
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	if (!object_p) {
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 364 "rygel-media-device.c"
	}
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	if (!value->data[0].v_pointer) {
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		*object_p = NULL;
#line 370 "rygel-media-device.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		*object_p = value->data[0].v_pointer;
#line 374 "rygel-media-device.c"
	} else {
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		*object_p = rygel_device_context_ref (value->data[0].v_pointer);
#line 378 "rygel-media-device.c"
	}
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	return NULL;
#line 382 "rygel-media-device.c"
}


GParamSpec* rygel_param_spec_device_context (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	RygelParamSpecDeviceContext* spec;
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	g_return_val_if_fail (g_type_is_a (object_type, RYGEL_TYPE_DEVICE_CONTEXT), NULL);
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	return G_PARAM_SPEC (spec);
#line 396 "rygel-media-device.c"
}


gpointer rygel_value_get_device_context (const GValue* value) {
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_DEVICE_CONTEXT), NULL);
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	return value->data[0].v_pointer;
#line 405 "rygel-media-device.c"
}


void rygel_value_set_device_context (GValue* value, gpointer v_object) {
	RygelDeviceContext* old;
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_DEVICE_CONTEXT));
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	old = value->data[0].v_pointer;
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	if (v_object) {
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_DEVICE_CONTEXT));
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		value->data[0].v_pointer = v_object;
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		rygel_device_context_ref (value->data[0].v_pointer);
#line 425 "rygel-media-device.c"
	} else {
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		value->data[0].v_pointer = NULL;
#line 429 "rygel-media-device.c"
	}
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	if (old) {
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		rygel_device_context_unref (old);
#line 435 "rygel-media-device.c"
	}
}


void rygel_value_take_device_context (GValue* value, gpointer v_object) {
	RygelDeviceContext* old;
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_DEVICE_CONTEXT));
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	old = value->data[0].v_pointer;
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	if (v_object) {
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_DEVICE_CONTEXT));
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		value->data[0].v_pointer = v_object;
#line 454 "rygel-media-device.c"
	} else {
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		value->data[0].v_pointer = NULL;
#line 458 "rygel-media-device.c"
	}
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	if (old) {
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		rygel_device_context_unref (old);
#line 464 "rygel-media-device.c"
	}
}


static void rygel_device_context_class_init (RygelDeviceContextClass * klass) {
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	rygel_device_context_parent_class = g_type_class_peek_parent (klass);
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	RYGEL_DEVICE_CONTEXT_CLASS (klass)->finalize = rygel_device_context_finalize;
#line 474 "rygel-media-device.c"
}


static void rygel_device_context_instance_init (RygelDeviceContext * self) {
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	self->ref_count = 1;
#line 481 "rygel-media-device.c"
}


static void rygel_device_context_finalize (RygelDeviceContext* obj) {
	RygelDeviceContext * self;
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_DEVICE_CONTEXT, RygelDeviceContext);
#line 25 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_g_object_unref0 (self->device);
#line 26 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_g_object_unref0 (self->factory);
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_g_object_unref0 (self->context);
#line 495 "rygel-media-device.c"
}


GType rygel_device_context_get_type (void) {
	static volatile gsize rygel_device_context_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_device_context_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { rygel_value_device_context_init, rygel_value_device_context_free_value, rygel_value_device_context_copy_value, rygel_value_device_context_peek_pointer, "p", rygel_value_device_context_collect_value, "p", rygel_value_device_context_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (RygelDeviceContextClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_device_context_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelDeviceContext), 0, (GInstanceInitFunc) rygel_device_context_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType rygel_device_context_type_id;
		rygel_device_context_type_id = g_type_register_fundamental (g_type_fundamental_next (), "RygelDeviceContext", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&rygel_device_context_type_id__volatile, rygel_device_context_type_id);
	}
	return rygel_device_context_type_id__volatile;
}


gpointer rygel_device_context_ref (gpointer instance) {
	RygelDeviceContext* self;
	self = instance;
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	g_atomic_int_inc (&self->ref_count);
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	return instance;
#line 520 "rygel-media-device.c"
}


void rygel_device_context_unref (gpointer instance) {
	RygelDeviceContext* self;
	self = instance;
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		RYGEL_DEVICE_CONTEXT_GET_CLASS (self)->finalize (self);
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 533 "rygel-media-device.c"
	}
}


static void _rygel_media_device_on_context_available_gupnp_context_manager_context_available (GUPnPContextManager* _sender, GUPnPContext* context, gpointer self) {
#line 62 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	rygel_media_device_on_context_available (self, context);
#line 541 "rygel-media-device.c"
}


static void _rygel_media_device_on_context_unavailable_gupnp_context_manager_context_unavailable (GUPnPContextManager* _sender, GUPnPContext* context, gpointer self) {
#line 63 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	rygel_media_device_on_context_unavailable (self, context);
#line 548 "rygel-media-device.c"
}


static void rygel_media_device_real_constructed (GObject* base) {
	RygelMediaDevice * self;
	GUPnPContextManager* _tmp0_ = NULL;
	GUPnPContextManager* _tmp1_;
	GUPnPContextManager* _tmp2_;
	GeeArrayList* _tmp3_;
	GeeHashMap* _tmp4_;
	GeeHashMap* _tmp5_;
#line 58 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	self = (RygelMediaDevice*) base;
#line 59 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	G_OBJECT_CLASS (rygel_media_device_parent_class)->constructed (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject));
#line 61 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp0_ = gupnp_context_manager_create ((guint) 0);
#line 61 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_g_object_unref0 (self->priv->manager);
#line 61 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	self->priv->manager = _tmp0_;
#line 62 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp1_ = self->priv->manager;
#line 62 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	g_signal_connect_object (_tmp1_, "context-available", (GCallback) _rygel_media_device_on_context_available_gupnp_context_manager_context_available, self, 0);
#line 63 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp2_ = self->priv->manager;
#line 63 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	g_signal_connect_object (_tmp2_, "context-unavailable", (GCallback) _rygel_media_device_on_context_unavailable_gupnp_context_manager_context_unavailable, self, 0);
#line 64 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp3_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
#line 64 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_g_object_unref0 (self->priv->interfaces);
#line 64 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	self->priv->interfaces = _tmp3_;
#line 65 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp4_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, gupnp_context_get_type (), (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 65 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_g_object_unref0 (self->priv->contexts);
#line 65 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	self->priv->contexts = _tmp4_;
#line 66 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp5_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, RYGEL_TYPE_DEVICE_CONTEXT, (GBoxedCopyFunc) rygel_device_context_ref, rygel_device_context_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 66 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_g_object_unref0 (self->priv->devices);
#line 66 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	self->priv->devices = _tmp5_;
#line 596 "rygel-media-device.c"
}


/**
     * Add a network interface the device should listen on.
     *
     * If the network interface is not already up, it will be used as soon as
     * it's ready. Otherwise it's used right away.
     *
     * @param iface Name of the network interface, e.g. eth0
     */
void rygel_media_device_add_interface (RygelMediaDevice* self, const gchar* iface) {
	GeeArrayList* _tmp0_;
	const gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
#line 77 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	g_return_if_fail (self != NULL);
#line 77 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	g_return_if_fail (iface != NULL);
#line 78 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp0_ = self->priv->interfaces;
#line 78 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp1_ = iface;
#line 78 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp2_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp0_, _tmp1_);
#line 78 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	if (!_tmp2_) {
#line 624 "rygel-media-device.c"
		GeeArrayList* _tmp3_;
		const gchar* _tmp4_;
		GeeHashMap* _tmp5_;
		GeeSet* _tmp6_;
		GeeSet* _tmp7_;
		GeeSet* _tmp8_;
		const gchar* _tmp9_;
		gboolean _tmp10_ = FALSE;
		gboolean _tmp11_;
#line 79 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_tmp3_ = self->priv->interfaces;
#line 79 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_tmp4_ = iface;
#line 79 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp3_, _tmp4_);
#line 83 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_tmp5_ = self->priv->contexts;
#line 83 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_tmp6_ = gee_abstract_map_get_keys ((GeeMap*) _tmp5_);
#line 83 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_tmp7_ = _tmp6_;
#line 83 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_tmp8_ = _tmp7_;
#line 83 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_tmp9_ = iface;
#line 83 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_tmp10_ = gee_collection_contains ((GeeCollection*) _tmp8_, _tmp9_);
#line 83 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_tmp11_ = _tmp10_;
#line 83 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_g_object_unref0 (_tmp8_);
#line 83 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		if (_tmp11_) {
#line 658 "rygel-media-device.c"
			GeeHashMap* _tmp12_;
			const gchar* _tmp13_;
			gpointer _tmp14_ = NULL;
			GUPnPContext* _tmp15_;
#line 84 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			_tmp12_ = self->priv->contexts;
#line 84 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			_tmp13_ = iface;
#line 84 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			_tmp14_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp12_, _tmp13_);
#line 84 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			_tmp15_ = (GUPnPContext*) _tmp14_;
#line 84 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			rygel_media_device_on_context_available (self, _tmp15_);
#line 84 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			_g_object_unref0 (_tmp15_);
#line 675 "rygel-media-device.c"
		}
	}
}


/**
     * Remove a previously added network interface from the device.
     *
     * @param iface Name of the network interface, e.g. eth0
     */
void rygel_media_device_remove_interface (RygelMediaDevice* self, const gchar* iface) {
	GeeArrayList* _tmp0_;
	const gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	GeeArrayList* _tmp3_;
	const gchar* _tmp4_;
	GeeHashMap* _tmp5_;
	GeeSet* _tmp6_;
	GeeSet* _tmp7_;
	GeeSet* _tmp8_;
	const gchar* _tmp9_;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_;
#line 94 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	g_return_if_fail (self != NULL);
#line 94 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	g_return_if_fail (iface != NULL);
#line 95 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp0_ = self->priv->interfaces;
#line 95 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp1_ = iface;
#line 95 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp2_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp0_, _tmp1_);
#line 95 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	if (!_tmp2_) {
#line 96 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		return;
#line 713 "rygel-media-device.c"
	}
#line 99 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp3_ = self->priv->interfaces;
#line 99 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp4_ = iface;
#line 99 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp3_, _tmp4_);
#line 101 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp5_ = self->priv->devices;
#line 101 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp6_ = gee_abstract_map_get_keys ((GeeMap*) _tmp5_);
#line 101 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp7_ = _tmp6_;
#line 101 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp8_ = _tmp7_;
#line 101 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp9_ = iface;
#line 101 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp10_ = gee_collection_contains ((GeeCollection*) _tmp8_, _tmp9_);
#line 101 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp11_ = _tmp10_;
#line 101 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_g_object_unref0 (_tmp8_);
#line 101 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	if (_tmp11_) {
#line 739 "rygel-media-device.c"
		GeeHashMap* _tmp12_;
		const gchar* _tmp13_;
		GeeHashMap* _tmp14_;
		const gchar* _tmp15_;
		gpointer _tmp16_ = NULL;
		RygelDeviceContext* _tmp17_;
		GUPnPContext* _tmp18_;
		GeeHashMap* _tmp19_;
		const gchar* _tmp20_;
#line 102 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_tmp12_ = self->priv->contexts;
#line 102 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_tmp13_ = iface;
#line 102 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_tmp14_ = self->priv->devices;
#line 102 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_tmp15_ = iface;
#line 102 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_tmp16_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp14_, _tmp15_);
#line 102 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_tmp17_ = (RygelDeviceContext*) _tmp16_;
#line 102 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_tmp18_ = _tmp17_->context;
#line 102 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		gee_abstract_map_set ((GeeAbstractMap*) _tmp12_, _tmp13_, _tmp18_);
#line 102 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_rygel_device_context_unref0 (_tmp17_);
#line 103 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_tmp19_ = self->priv->devices;
#line 103 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_tmp20_ = iface;
#line 103 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		gee_abstract_map_unset ((GeeAbstractMap*) _tmp19_, _tmp20_, NULL);
#line 773 "rygel-media-device.c"
	}
}


/**
     * Get a list of the network interfaces the device is currently allowed
     * to use.
     *
     * @return list of interface names.
     */
static void _g_free0_ (gpointer var) {
#line 113 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	var = (g_free (var), NULL);
#line 787 "rygel-media-device.c"
}


static void _g_list_free__g_free0_ (GList* self) {
#line 113 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	g_list_foreach (self, (GFunc) _g_free0_, NULL);
#line 113 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	g_list_free (self);
#line 796 "rygel-media-device.c"
}


GList* rygel_media_device_get_interfaces (RygelMediaDevice* self) {
	GList* result = NULL;
	GList* _result_;
#line 113 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 114 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_result_ = NULL;
#line 807 "rygel-media-device.c"
	{
		GeeArrayList* _tmp0_;
		GeeArrayList* _tmp1_;
		GeeArrayList* _iface_list;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _iface_size;
		gint _iface_index;
#line 116 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_tmp0_ = self->priv->interfaces;
#line 116 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_tmp1_ = _g_object_ref0 (_tmp0_);
#line 116 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_iface_list = _tmp1_;
#line 116 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_tmp2_ = _iface_list;
#line 116 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_tmp3_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp2_);
#line 116 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_tmp4_ = _tmp3_;
#line 116 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_iface_size = _tmp4_;
#line 116 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_iface_index = -1;
#line 116 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		while (TRUE) {
#line 835 "rygel-media-device.c"
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			GeeArrayList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_ = NULL;
			gchar* iface;
			const gchar* _tmp11_;
			gchar* _tmp12_;
#line 116 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			_tmp5_ = _iface_index;
#line 116 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			_iface_index = _tmp5_ + 1;
#line 116 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			_tmp6_ = _iface_index;
#line 116 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			_tmp7_ = _iface_size;
#line 116 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			if (!(_tmp6_ < _tmp7_)) {
#line 116 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
				break;
#line 857 "rygel-media-device.c"
			}
#line 116 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			_tmp8_ = _iface_list;
#line 116 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			_tmp9_ = _iface_index;
#line 116 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
#line 116 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			iface = (gchar*) _tmp10_;
#line 117 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			_tmp11_ = iface;
#line 117 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			_tmp12_ = g_strdup (_tmp11_);
#line 117 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			_result_ = g_list_prepend (_result_, _tmp12_);
#line 116 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			_g_free0 (iface);
#line 875 "rygel-media-device.c"
		}
#line 116 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_g_object_unref0 (_iface_list);
#line 879 "rygel-media-device.c"
	}
#line 120 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_result_ = g_list_reverse (_result_);
#line 122 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	result = _result_;
#line 122 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	return result;
#line 887 "rygel-media-device.c"
}


static void rygel_media_device_on_context_available (RygelMediaDevice* self, GUPnPContext* context) {
	GeeArrayList* _tmp0_;
	GUPnPContext* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gboolean _tmp4_ = FALSE;
	GError * _inner_error_ = NULL;
#line 125 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	g_return_if_fail (self != NULL);
#line 125 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	g_return_if_fail (context != NULL);
#line 126 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp0_ = self->priv->interfaces;
#line 126 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp1_ = context;
#line 126 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp2_ = gssdp_client_get_interface ((GSSDPClient*) _tmp1_);
#line 126 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp3_ = _tmp2_;
#line 126 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp4_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp0_, _tmp3_);
#line 126 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	if (_tmp4_) {
#line 914 "rygel-media-device.c"
		{
			GUPnPContext* _tmp5_;
			RygelPlugin* _tmp6_;
			RygelDeviceContext* _tmp7_;
			RygelDeviceContext* ctx;
			GeeHashMap* _tmp8_;
			GUPnPContext* _tmp9_;
			const gchar* _tmp10_;
			const gchar* _tmp11_;
			RygelDeviceContext* _tmp12_;
#line 128 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			_tmp5_ = context;
#line 128 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			_tmp6_ = self->priv->_plugin;
#line 128 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			_tmp7_ = rygel_device_context_new (_tmp5_, _tmp6_, &_inner_error_);
#line 128 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			ctx = _tmp7_;
#line 128 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			if (_inner_error_ != NULL) {
#line 935 "rygel-media-device.c"
				goto __catch36_g_error;
			}
#line 129 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			_tmp8_ = self->priv->devices;
#line 129 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			_tmp9_ = context;
#line 129 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			_tmp10_ = gssdp_client_get_interface ((GSSDPClient*) _tmp9_);
#line 129 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			_tmp11_ = _tmp10_;
#line 129 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			_tmp12_ = ctx;
#line 129 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			gee_abstract_map_set ((GeeAbstractMap*) _tmp8_, _tmp11_, _tmp12_);
#line 127 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			_rygel_device_context_unref0 (ctx);
#line 952 "rygel-media-device.c"
		}
		goto __finally36;
		__catch36_g_error:
		{
			GError* _error_ = NULL;
			GError* _tmp13_;
			const gchar* _tmp14_;
#line 127 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			_error_ = _inner_error_;
#line 127 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			_inner_error_ = NULL;
#line 131 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			_tmp13_ = _error_;
#line 131 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			_tmp14_ = _tmp13_->message;
#line 131 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			g_warning ("rygel-media-device.vala:131: Failed to create device context: %s", _tmp14_);
#line 127 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			_g_error_free0 (_error_);
#line 972 "rygel-media-device.c"
		}
		__finally36:
#line 127 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		if (_inner_error_ != NULL) {
#line 127 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 127 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			g_clear_error (&_inner_error_);
#line 127 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			return;
#line 983 "rygel-media-device.c"
		}
	} else {
		GeeHashMap* _tmp15_;
		GUPnPContext* _tmp16_;
		const gchar* _tmp17_;
		const gchar* _tmp18_;
		GUPnPContext* _tmp19_;
#line 135 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_tmp15_ = self->priv->contexts;
#line 135 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_tmp16_ = context;
#line 135 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_tmp17_ = gssdp_client_get_interface ((GSSDPClient*) _tmp16_);
#line 135 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_tmp18_ = _tmp17_;
#line 135 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_tmp19_ = context;
#line 135 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		gee_abstract_map_set ((GeeAbstractMap*) _tmp15_, _tmp18_, _tmp19_);
#line 1003 "rygel-media-device.c"
	}
}


static void rygel_media_device_on_context_unavailable (RygelMediaDevice* self, GUPnPContext* context) {
	GeeHashMap* _tmp0_;
	GeeSet* _tmp1_;
	GeeSet* _tmp2_;
	GeeSet* _tmp3_;
	GUPnPContext* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_;
#line 139 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	g_return_if_fail (self != NULL);
#line 139 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	g_return_if_fail (context != NULL);
#line 140 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp0_ = self->priv->devices;
#line 140 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp1_ = gee_abstract_map_get_keys ((GeeMap*) _tmp0_);
#line 140 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp2_ = _tmp1_;
#line 140 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp3_ = _tmp2_;
#line 140 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp4_ = context;
#line 140 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp5_ = gssdp_client_get_interface ((GSSDPClient*) _tmp4_);
#line 140 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp6_ = _tmp5_;
#line 140 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp7_ = gee_collection_contains ((GeeCollection*) _tmp3_, _tmp6_);
#line 140 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp8_ = _tmp7_;
#line 140 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_g_object_unref0 (_tmp3_);
#line 140 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	if (_tmp8_) {
#line 1044 "rygel-media-device.c"
		GeeHashMap* _tmp9_;
		GUPnPContext* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
#line 141 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_tmp9_ = self->priv->devices;
#line 141 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_tmp10_ = context;
#line 141 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_tmp11_ = gssdp_client_get_interface ((GSSDPClient*) _tmp10_);
#line 141 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_tmp12_ = _tmp11_;
#line 141 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		gee_abstract_map_unset ((GeeAbstractMap*) _tmp9_, _tmp12_, NULL);
#line 1059 "rygel-media-device.c"
	} else {
		GeeHashMap* _tmp13_;
		GUPnPContext* _tmp14_;
		const gchar* _tmp15_;
		const gchar* _tmp16_;
#line 143 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_tmp13_ = self->priv->contexts;
#line 143 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_tmp14_ = context;
#line 143 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_tmp15_ = gssdp_client_get_interface ((GSSDPClient*) _tmp14_);
#line 143 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_tmp16_ = _tmp15_;
#line 143 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		gee_abstract_map_unset ((GeeAbstractMap*) _tmp13_, _tmp16_, NULL);
#line 1075 "rygel-media-device.c"
	}
}


RygelMediaDevice* rygel_media_device_construct (GType object_type) {
	RygelMediaDevice * self = NULL;
#line 44 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	self = (RygelMediaDevice*) g_object_new (object_type, NULL);
#line 44 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	return self;
#line 1086 "rygel-media-device.c"
}


RygelPlugin* rygel_media_device_get_plugin (RygelMediaDevice* self) {
	RygelPlugin* result;
	RygelPlugin* _tmp0_;
#line 50 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 50 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp0_ = self->priv->_plugin;
#line 50 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	result = _tmp0_;
#line 50 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	return result;
#line 1101 "rygel-media-device.c"
}


void rygel_media_device_set_plugin (RygelMediaDevice* self, RygelPlugin* value) {
	RygelPlugin* _tmp0_;
	RygelPlugin* _tmp1_;
#line 50 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	g_return_if_fail (self != NULL);
#line 50 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp0_ = value;
#line 50 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 50 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_g_object_unref0 (self->priv->_plugin);
#line 50 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	self->priv->_plugin = _tmp1_;
#line 50 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	g_object_notify ((GObject *) self, "plugin");
#line 1120 "rygel-media-device.c"
}


const gchar* rygel_media_device_get_title (RygelMediaDevice* self) {
	const gchar* result;
	const gchar* _tmp0_;
#line 51 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 51 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp0_ = self->priv->_title;
#line 51 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	result = _tmp0_;
#line 51 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	return result;
#line 1135 "rygel-media-device.c"
}


static void rygel_media_device_set_title (RygelMediaDevice* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
#line 51 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	g_return_if_fail (self != NULL);
#line 51 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp0_ = value;
#line 51 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 51 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_g_free0 (self->priv->_title);
#line 51 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	self->priv->_title = _tmp1_;
#line 51 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	g_object_notify ((GObject *) self, "title");
#line 1154 "rygel-media-device.c"
}


RygelPluginCapabilities rygel_media_device_get_capabilities (RygelMediaDevice* self) {
	RygelPluginCapabilities result;
	RygelPluginCapabilities _tmp0_;
#line 54 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 54 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp0_ = self->priv->_capabilities;
#line 54 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	result = _tmp0_;
#line 54 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	return result;
#line 1169 "rygel-media-device.c"
}


static void rygel_media_device_set_capabilities (RygelMediaDevice* self, RygelPluginCapabilities value) {
	RygelPluginCapabilities _tmp0_;
#line 53 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	g_return_if_fail (self != NULL);
#line 53 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp0_ = value;
#line 53 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	self->priv->_capabilities = _tmp0_;
#line 53 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	g_object_notify ((GObject *) self, "capabilities");
#line 1183 "rygel-media-device.c"
}


static void rygel_media_device_class_init (RygelMediaDeviceClass * klass) {
#line 44 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	rygel_media_device_parent_class = g_type_class_peek_parent (klass);
#line 44 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	g_type_class_add_private (klass, sizeof (RygelMediaDevicePrivate));
#line 44 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	G_OBJECT_CLASS (klass)->constructed = rygel_media_device_real_constructed;
#line 44 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_media_device_get_property;
#line 44 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_media_device_set_property;
#line 44 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_media_device_finalize;
#line 44 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_DEVICE_PLUGIN, g_param_spec_object ("plugin", "plugin", "plugin", RYGEL_TYPE_PLUGIN, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 44 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_DEVICE_TITLE, g_param_spec_string ("title", "title", "title", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 44 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_DEVICE_CAPABILITIES, g_param_spec_flags ("capabilities", "capabilities", "capabilities", RYGEL_TYPE_PLUGIN_CAPABILITIES, RYGEL_PLUGIN_CAPABILITIES_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 1206 "rygel-media-device.c"
}


static void rygel_media_device_instance_init (RygelMediaDevice * self) {
#line 44 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	self->priv = RYGEL_MEDIA_DEVICE_GET_PRIVATE (self);
#line 52 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	self->priv->_capabilities = RYGEL_PLUGIN_CAPABILITIES_NONE;
#line 1215 "rygel-media-device.c"
}


static void rygel_media_device_finalize (GObject* obj) {
	RygelMediaDevice * self;
#line 44 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_MEDIA_DEVICE, RygelMediaDevice);
#line 45 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_g_object_unref0 (self->priv->interfaces);
#line 46 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_g_object_unref0 (self->priv->contexts);
#line 47 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_g_object_unref0 (self->priv->devices);
#line 48 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_g_object_unref0 (self->priv->manager);
#line 50 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_g_object_unref0 (self->priv->_plugin);
#line 51 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_g_free0 (self->priv->_title);
#line 44 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	G_OBJECT_CLASS (rygel_media_device_parent_class)->finalize (obj);
#line 1237 "rygel-media-device.c"
}


/**
 * This is a base class for implementations of UPnP devices,
 * such as RygelMediaServer and RygelMediaRenderer.
 *
 * Use rygel_media_device_add_interface() to allow this
 * device to respond to UPnP messages on a network interface.
 */
GType rygel_media_device_get_type (void) {
	static volatile gsize rygel_media_device_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_device_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaDeviceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_device_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaDevice), 0, (GInstanceInitFunc) rygel_media_device_instance_init, NULL };
		GType rygel_media_device_type_id;
		rygel_media_device_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMediaDevice", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&rygel_media_device_type_id__volatile, rygel_media_device_type_id);
	}
	return rygel_media_device_type_id__volatile;
}


static void _vala_rygel_media_device_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelMediaDevice * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_MEDIA_DEVICE, RygelMediaDevice);
#line 44 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	switch (property_id) {
#line 44 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		case RYGEL_MEDIA_DEVICE_PLUGIN:
#line 44 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		g_value_set_object (value, rygel_media_device_get_plugin (self));
#line 44 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		break;
#line 44 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		case RYGEL_MEDIA_DEVICE_TITLE:
#line 44 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		g_value_set_string (value, rygel_media_device_get_title (self));
#line 44 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		break;
#line 44 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		case RYGEL_MEDIA_DEVICE_CAPABILITIES:
#line 44 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		g_value_set_flags (value, rygel_media_device_get_capabilities (self));
#line 44 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		break;
#line 1283 "rygel-media-device.c"
		default:
#line 44 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 44 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		break;
#line 1289 "rygel-media-device.c"
	}
}


static void _vala_rygel_media_device_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelMediaDevice * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_MEDIA_DEVICE, RygelMediaDevice);
#line 44 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	switch (property_id) {
#line 44 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		case RYGEL_MEDIA_DEVICE_PLUGIN:
#line 44 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		rygel_media_device_set_plugin (self, g_value_get_object (value));
#line 44 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		break;
#line 44 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		case RYGEL_MEDIA_DEVICE_TITLE:
#line 44 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		rygel_media_device_set_title (self, g_value_get_string (value));
#line 44 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		break;
#line 44 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		case RYGEL_MEDIA_DEVICE_CAPABILITIES:
#line 44 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		rygel_media_device_set_capabilities (self, g_value_get_flags (value));
#line 44 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		break;
#line 1317 "rygel-media-device.c"
		default:
#line 44 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 44 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		break;
#line 1323 "rygel-media-device.c"
	}
}



