/* rygel-playbin-player.c generated by valac 0.22.0, the Vala compiler
 * generated from rygel-playbin-player.vala, do not modify */

/*
 * Copyright (C) 2008 OpenedHand Ltd.
 * Copyright (C) 2009,2010,2011,2012 Nokia Corporation.
 * Copyright (C) 2012 Openismus GmbH
 * Copyright (C) 2012,2013 Intel Corporation.
 *
 * Author: Jorn Baayen <jorn@openedhand.com>
 *         Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *         Jens Georg <jensg@openismus.com>
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel-renderer.h>
#include <gst/gst.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp-av/gupnp-av.h>
#include <gio/gio.h>


#define RYGEL_PLAYBIN_TYPE_PLAYER (rygel_playbin_player_get_type ())
#define RYGEL_PLAYBIN_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_PLAYBIN_TYPE_PLAYER, RygelPlaybinPlayer))
#define RYGEL_PLAYBIN_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_PLAYBIN_TYPE_PLAYER, RygelPlaybinPlayerClass))
#define RYGEL_PLAYBIN_IS_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_PLAYBIN_TYPE_PLAYER))
#define RYGEL_PLAYBIN_IS_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_PLAYBIN_TYPE_PLAYER))
#define RYGEL_PLAYBIN_PLAYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_PLAYBIN_TYPE_PLAYER, RygelPlaybinPlayerClass))

typedef struct _RygelPlaybinPlayer RygelPlaybinPlayer;
typedef struct _RygelPlaybinPlayerClass RygelPlaybinPlayerClass;
typedef struct _RygelPlaybinPlayerPrivate RygelPlaybinPlayerPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __g_list_free__rygel_renderer_dlna_profile_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__rygel_renderer_dlna_profile_unref0_ (var), NULL)))
#define _gst_caps_unref0(var) ((var == NULL) ? NULL : (var = (gst_caps_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _gst_structure_free0(var) ((var == NULL) ? NULL : (var = (gst_structure_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _RygelPlaybinPlayer {
	GObject parent_instance;
	RygelPlaybinPlayerPrivate * priv;
};

struct _RygelPlaybinPlayerClass {
	GObjectClass parent_class;
};

struct _RygelPlaybinPlayerPrivate {
	gboolean is_live;
	gboolean foreign;
	gboolean buffering;
	GstElement* _playbin;
	gchar* _playback_state;
	gchar** _allowed_playback_speeds;
	gint _allowed_playback_speeds_length1;
	gint __allowed_playback_speeds_size_;
	gchar* _playback_speed;
	gchar* transfer_mode;
	gboolean uri_update_hint;
	gchar* _uri;
	gchar* _mime_type;
	gchar* _metadata;
	gchar* _content_features;
	GUPnPProtocolInfo* protocol_info;
	GList* _supported_profiles;
};


static gpointer rygel_playbin_player_parent_class = NULL;
static RygelPlaybinPlayer* rygel_playbin_player_player;
static RygelPlaybinPlayer* rygel_playbin_player_player = NULL;
static RygelMediaPlayerIface* rygel_playbin_player_rygel_media_player_parent_iface = NULL;

GType rygel_playbin_player_get_type (void) G_GNUC_CONST;
#define RYGEL_PLAYBIN_PLAYER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_PLAYBIN_TYPE_PLAYER, RygelPlaybinPlayerPrivate))
enum  {
	RYGEL_PLAYBIN_PLAYER_DUMMY_PROPERTY,
	RYGEL_PLAYBIN_PLAYER_PLAYBIN,
	RYGEL_PLAYBIN_PLAYER_PLAYBACK_STATE,
	RYGEL_PLAYBIN_PLAYER_ALLOWED_PLAYBACK_SPEEDS,
	RYGEL_PLAYBIN_PLAYER_PLAYBACK_SPEED,
	RYGEL_PLAYBIN_PLAYER_URI,
	RYGEL_PLAYBIN_PLAYER_MIME_TYPE,
	RYGEL_PLAYBIN_PLAYER_METADATA,
	RYGEL_PLAYBIN_PLAYER_CAN_SEEK,
	RYGEL_PLAYBIN_PLAYER_CONTENT_FEATURES,
	RYGEL_PLAYBIN_PLAYER_VOLUME,
	RYGEL_PLAYBIN_PLAYER_DURATION,
	RYGEL_PLAYBIN_PLAYER_POSITION,
	RYGEL_PLAYBIN_PLAYER_SUPPORTED_PROFILES
};
static void _rygel_renderer_dlna_profile_unref0_ (gpointer var);
static void _g_list_free__rygel_renderer_dlna_profile_unref0_ (GList* self);
#define RYGEL_PLAYBIN_PLAYER_TRANSFER_MODE_STREAMING "Streaming"
#define RYGEL_PLAYBIN_PLAYER_TRANSFER_MODE_INTERACTIVE "Interactive"
#define RYGEL_PLAYBIN_PLAYER_PROTOCOL_INFO_TEMPLATE "http-get:%s:*:%s"
static RygelPlaybinPlayer* rygel_playbin_player_new (void);
static RygelPlaybinPlayer* rygel_playbin_player_construct (GType object_type);
static void rygel_playbin_player_set_playbin (RygelPlaybinPlayer* self, GstElement* value);
static void rygel_playbin_player_setup_playbin (RygelPlaybinPlayer* self);
RygelPlaybinPlayer* rygel_playbin_player_new_wrap (GstElement* playbin);
RygelPlaybinPlayer* rygel_playbin_player_construct_wrap (GType object_type, GstElement* playbin);
RygelPlaybinPlayer* rygel_playbin_player_get_default (void);
static gboolean rygel_playbin_player_real_seek (RygelMediaPlayer* base, gint64 time);
GstElement* rygel_playbin_player_get_playbin (RygelPlaybinPlayer* self);
static gchar** rygel_playbin_player_real_get_protocols (RygelMediaPlayer* base, int* result_length1);
static gchar** _vala_array_dup1 (gchar** self, int length);
static gchar** rygel_playbin_player_real_get_mime_types (RygelMediaPlayer* base, int* result_length1);
static gchar** _vala_array_dup2 (gchar** self, int length);
static gboolean rygel_playbin_player_is_rendering_image (RygelPlaybinPlayer* self);
static inline GstCaps* _dynamic_get_caps0 (GstElement* obj);
static void rygel_playbin_player_bus_handler (RygelPlaybinPlayer* self, GstBus* bus, GstMessage* message);
static inline gchar* _dynamic_get_current_uri1 (GstElement* obj);
static inline gchar* _dynamic_get_uri2 (GstElement* obj);
static gchar* rygel_playbin_player_generate_basic_didl (RygelPlaybinPlayer* self);
static void rygel_playbin_player_on_source_setup (RygelPlaybinPlayer* self, GstElement* pipeline, GstElement* source);
static inline void _dynamic_set_extra_headers3 (GstElement* obj, GstStructure* value);
static void rygel_playbin_player_on_uri_notify (RygelPlaybinPlayer* self, GParamSpec* pspec);
static inline void _dynamic_set_auto_flush_bus4 (GstElement* obj, gboolean value);
static void _rygel_playbin_player_on_source_setup_dynamic_source_setup0_ (GstElement* _sender, GstElement* source, gpointer self);
gulong _dynamic_source_setup1_connect (gpointer obj, const char * signal_name, GCallback handler, gpointer data);
static void _rygel_playbin_player_on_uri_notify_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _rygel_playbin_player_bus_handler_gst_bus_message (GstBus* _sender, GstMessage* message, gpointer self);
static gchar** _vala_array_dup3 (gchar** self, int length);
static inline void _dynamic_set_uri5 (GstElement* obj, const gchar* value);
static inline gdouble _dynamic_get_volume6 (GstElement* obj);
static inline void _dynamic_set_volume7 (GstElement* obj, gdouble value);
GList* rygel_playbin_player_get_supported_profiles (RygelPlaybinPlayer* self);
static void rygel_playbin_player_finalize (GObject* obj);
static void _vala_rygel_playbin_player_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_playbin_player_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const gchar* RYGEL_PLAYBIN_PLAYER_protocols[2] = {"http-get", "rtsp"};
static const gchar* RYGEL_PLAYBIN_PLAYER_mime_types[42] = {"audio/mpeg", "application/ogg", "audio/x-vorbis", "audio/x-vorbis+ogg", "audio/ogg", "audio/x-ms-wma", "audio/x-ms-asf", "audio/x-flac", "audio/x-flac+ogg", "audio/flac", "audio/mp4", "audio/3gpp", "audio/vnd.dlna.adts", "audio/x-mod", "audio/x-wav", "audio/x-ac3", "audio/x-m4a", "audio/l16;rate=44100;channels=2", "audio/l16;rate=44100;channels=1", "audio/l16;channels=2;rate=44100", "audio/l16;channels=1;rate=44100", "audio/l16;rate=44100", "image/jpeg", "image/png", "video/x-theora", "video/x-theora+ogg", "video/x-oggm", "video/ogg", "video/x-dirac", "video/x-wmv", "video/x-wma", "video/x-msvideo", "video/x-3ivx", "video/x-3ivx", "video/x-matroska", "video/x-mkv", "video/mpeg", "video/mp4", "application/x-shockwave-flash", "video/x-ms-asf", "video/x-xvid", "video/x-ms-wmv"};

static void _rygel_renderer_dlna_profile_unref0_ (gpointer var) {
#line 341 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	(var == NULL) ? NULL : (var = (rygel_renderer_dlna_profile_unref (var), NULL));
#line 161 "rygel-playbin-player.c"
}


static void _g_list_free__rygel_renderer_dlna_profile_unref0_ (GList* self) {
#line 341 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_list_foreach (self, (GFunc) _rygel_renderer_dlna_profile_unref0_, NULL);
#line 341 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_list_free (self);
#line 170 "rygel-playbin-player.c"
}


static RygelPlaybinPlayer* rygel_playbin_player_construct (GType object_type) {
	RygelPlaybinPlayer * self = NULL;
	GstElement* _tmp0_ = NULL;
#line 299 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	self = (RygelPlaybinPlayer*) g_object_new (object_type, NULL);
#line 300 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp0_ = gst_element_factory_make ("playbin", NULL);
#line 300 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	rygel_playbin_player_set_playbin (self, _tmp0_);
#line 301 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	self->priv->foreign = FALSE;
#line 302 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	rygel_playbin_player_setup_playbin (self);
#line 299 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	return self;
#line 189 "rygel-playbin-player.c"
}


static RygelPlaybinPlayer* rygel_playbin_player_new (void) {
#line 299 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	return rygel_playbin_player_construct (RYGEL_PLAYBIN_TYPE_PLAYER);
#line 196 "rygel-playbin-player.c"
}


RygelPlaybinPlayer* rygel_playbin_player_construct_wrap (GType object_type, GstElement* playbin) {
	RygelPlaybinPlayer * self = NULL;
	GstElement* _tmp0_ = NULL;
	GstElement* _tmp1_ = NULL;
	GType _tmp2_ = 0UL;
	const gchar* _tmp3_ = NULL;
	GstElement* _tmp4_ = NULL;
#line 305 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_return_val_if_fail (playbin != NULL, NULL);
#line 305 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	self = (RygelPlaybinPlayer*) g_object_new (object_type, NULL);
#line 307 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp0_ = playbin;
#line 307 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_return_if_fail (_tmp0_ != NULL);
#line 308 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp1_ = playbin;
#line 308 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp2_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp1_);
#line 308 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp3_ = g_type_name (_tmp2_);
#line 308 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_return_if_fail (g_strcmp0 (_tmp3_, "GstPlayBin") == 0);
#line 310 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp4_ = playbin;
#line 310 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	rygel_playbin_player_set_playbin (self, _tmp4_);
#line 311 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	self->priv->foreign = TRUE;
#line 312 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	rygel_playbin_player_setup_playbin (self);
#line 305 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	return self;
#line 233 "rygel-playbin-player.c"
}


RygelPlaybinPlayer* rygel_playbin_player_new_wrap (GstElement* playbin) {
#line 305 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	return rygel_playbin_player_construct_wrap (RYGEL_PLAYBIN_TYPE_PLAYER, playbin);
#line 240 "rygel-playbin-player.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 320 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	return self ? g_object_ref (self) : NULL;
#line 247 "rygel-playbin-player.c"
}


RygelPlaybinPlayer* rygel_playbin_player_get_default (void) {
	RygelPlaybinPlayer* result = NULL;
	RygelPlaybinPlayer* _tmp0_ = NULL;
	RygelPlaybinPlayer* _tmp2_ = NULL;
	RygelPlaybinPlayer* _tmp3_ = NULL;
#line 316 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp0_ = rygel_playbin_player_player;
#line 316 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	if (_tmp0_ == NULL) {
#line 260 "rygel-playbin-player.c"
		RygelPlaybinPlayer* _tmp1_ = NULL;
#line 317 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp1_ = rygel_playbin_player_new ();
#line 317 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_g_object_unref0 (rygel_playbin_player_player);
#line 317 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		rygel_playbin_player_player = _tmp1_;
#line 268 "rygel-playbin-player.c"
	}
#line 320 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp2_ = rygel_playbin_player_player;
#line 320 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 320 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	result = _tmp3_;
#line 320 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	return result;
#line 278 "rygel-playbin-player.c"
}


static gboolean rygel_playbin_player_real_seek (RygelMediaPlayer* base, gint64 time) {
	RygelPlaybinPlayer * self;
	gboolean result = FALSE;
	GstElement* _tmp0_ = NULL;
	gint64 _tmp1_ = 0LL;
	gboolean _tmp2_ = FALSE;
#line 323 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	self = (RygelPlaybinPlayer*) base;
#line 324 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp0_ = self->priv->_playbin;
#line 324 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp1_ = time;
#line 324 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp2_ = gst_element_seek (_tmp0_, 1.0, GST_FORMAT_TIME, GST_SEEK_FLAG_FLUSH, GST_SEEK_TYPE_SET, _tmp1_ * GST_USECOND, GST_SEEK_TYPE_NONE, (gint64) (-1));
#line 324 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	result = _tmp2_;
#line 324 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	return result;
#line 300 "rygel-playbin-player.c"
}


static gchar** _vala_array_dup1 (gchar** self, int length) {
	gchar** result;
	int i;
#line 334 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	result = g_new0 (gchar*, length + 1);
#line 334 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	for (i = 0; i < length; i++) {
#line 311 "rygel-playbin-player.c"
		gchar* _tmp0_ = NULL;
#line 334 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp0_ = g_strdup (self[i]);
#line 334 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		result[i] = _tmp0_;
#line 317 "rygel-playbin-player.c"
	}
#line 334 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	return result;
#line 321 "rygel-playbin-player.c"
}


static gchar** rygel_playbin_player_real_get_protocols (RygelMediaPlayer* base, int* result_length1) {
	RygelPlaybinPlayer * self;
	gchar** result = NULL;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
#line 333 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	self = (RygelPlaybinPlayer*) base;
#line 334 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp0_ = (RYGEL_PLAYBIN_PLAYER_protocols != NULL) ? _vala_array_dup1 (RYGEL_PLAYBIN_PLAYER_protocols, G_N_ELEMENTS (RYGEL_PLAYBIN_PLAYER_protocols)) : ((gpointer) RYGEL_PLAYBIN_PLAYER_protocols);
#line 334 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp0__length1 = G_N_ELEMENTS (RYGEL_PLAYBIN_PLAYER_protocols);
#line 334 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp1_ = _tmp0_;
#line 334 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp1__length1 = _tmp0__length1;
#line 334 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	if (result_length1) {
#line 334 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		*result_length1 = _tmp1__length1;
#line 346 "rygel-playbin-player.c"
	}
#line 334 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	result = _tmp1_;
#line 334 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	return result;
#line 352 "rygel-playbin-player.c"
}


static gchar** _vala_array_dup2 (gchar** self, int length) {
	gchar** result;
	int i;
#line 338 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	result = g_new0 (gchar*, length + 1);
#line 338 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	for (i = 0; i < length; i++) {
#line 363 "rygel-playbin-player.c"
		gchar* _tmp0_ = NULL;
#line 338 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp0_ = g_strdup (self[i]);
#line 338 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		result[i] = _tmp0_;
#line 369 "rygel-playbin-player.c"
	}
#line 338 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	return result;
#line 373 "rygel-playbin-player.c"
}


static gchar** rygel_playbin_player_real_get_mime_types (RygelMediaPlayer* base, int* result_length1) {
	RygelPlaybinPlayer * self;
	gchar** result = NULL;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
#line 337 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	self = (RygelPlaybinPlayer*) base;
#line 338 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp0_ = (RYGEL_PLAYBIN_PLAYER_mime_types != NULL) ? _vala_array_dup2 (RYGEL_PLAYBIN_PLAYER_mime_types, G_N_ELEMENTS (RYGEL_PLAYBIN_PLAYER_mime_types)) : ((gpointer) RYGEL_PLAYBIN_PLAYER_mime_types);
#line 338 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp0__length1 = G_N_ELEMENTS (RYGEL_PLAYBIN_PLAYER_mime_types);
#line 338 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp1_ = _tmp0_;
#line 338 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp1__length1 = _tmp0__length1;
#line 338 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	if (result_length1) {
#line 338 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		*result_length1 = _tmp1__length1;
#line 398 "rygel-playbin-player.c"
	}
#line 338 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	result = _tmp1_;
#line 338 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	return result;
#line 404 "rygel-playbin-player.c"
}


static inline GstCaps* _dynamic_get_caps0 (GstElement* obj) {
	GstCaps* result;
#line 410 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_object_get (obj, "caps", &result, NULL);
#line 410 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	return result;
#line 414 "rygel-playbin-player.c"
}


static gboolean rygel_playbin_player_is_rendering_image (RygelPlaybinPlayer* self) {
	gboolean result = FALSE;
	GstElement* typefind = NULL;
	GstElement* _tmp0_ = NULL;
	GstElement* _tmp1_ = NULL;
	GstCaps* caps = NULL;
	GstElement* _tmp2_ = NULL;
	GstCaps* _tmp3_ = NULL;
	GstCaps* _tmp4_ = NULL;
	GstStructure* structure = NULL;
	GstCaps* _tmp5_ = NULL;
	GstStructure* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	GstStructure* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	gboolean _tmp12_ = FALSE;
#line 406 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 409 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp0_ = self->priv->_playbin;
#line 409 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp1_ = gst_bin_get_by_name (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, gst_bin_get_type ()) ? ((GstBin*) _tmp0_) : NULL, "typefind");
#line 409 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_g_object_unref0 (typefind);
#line 409 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	typefind = _tmp1_;
#line 410 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp2_ = typefind;
#line 410 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp3_ = _dynamic_get_caps0 (_tmp2_);
#line 410 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp4_ = _tmp3_;
#line 410 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	caps = _tmp4_;
#line 411 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp5_ = caps;
#line 411 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp6_ = gst_caps_get_structure (_tmp5_, (guint) 0);
#line 411 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	structure = _tmp6_;
#line 413 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp8_ = structure;
#line 413 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp9_ = gst_structure_get_name (_tmp8_);
#line 413 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	if (g_strcmp0 (_tmp9_, "image/jpeg") == 0) {
#line 413 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp7_ = TRUE;
#line 466 "rygel-playbin-player.c"
	} else {
		GstStructure* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
#line 414 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp10_ = structure;
#line 414 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp11_ = gst_structure_get_name (_tmp10_);
#line 414 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp7_ = g_strcmp0 (_tmp11_, "image/png") == 0;
#line 476 "rygel-playbin-player.c"
	}
#line 413 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp12_ = _tmp7_;
#line 413 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	result = _tmp12_;
#line 413 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_gst_caps_unref0 (caps);
#line 413 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_g_object_unref0 (typefind);
#line 413 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	return result;
#line 488 "rygel-playbin-player.c"
}


static inline gchar* _dynamic_get_current_uri1 (GstElement* obj) {
	gchar* result;
#line 435 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_object_get (obj, "current-uri", &result, NULL);
#line 435 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	return result;
#line 498 "rygel-playbin-player.c"
}


static inline gchar* _dynamic_get_uri2 (GstElement* obj) {
	gchar* result;
#line 438 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_object_get (obj, "uri", &result, NULL);
#line 438 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	return result;
#line 508 "rygel-playbin-player.c"
}


static void rygel_playbin_player_bus_handler (RygelPlaybinPlayer* self, GstBus* bus, GstMessage* message) {
	GstMessage* _tmp0_ = NULL;
	GstMessageType _tmp1_ = 0;
#line 417 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_return_if_fail (self != NULL);
#line 417 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_return_if_fail (bus != NULL);
#line 417 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_return_if_fail (message != NULL);
#line 419 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp0_ = message;
#line 419 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp1_ = _tmp0_->type;
#line 419 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	switch (_tmp1_) {
#line 419 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		case GST_MESSAGE_DURATION_CHANGED:
#line 529 "rygel-playbin-player.c"
		{
			GstElement* _tmp2_ = NULL;
			gboolean _tmp3_ = FALSE;
#line 421 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
			_tmp2_ = self->priv->_playbin;
#line 421 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
			_tmp3_ = gst_element_query_duration (_tmp2_, GST_FORMAT_TIME, NULL);
#line 421 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
			if (_tmp3_) {
#line 422 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
				g_object_notify ((GObject*) self, "duration");
#line 541 "rygel-playbin-player.c"
			}
#line 424 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
			break;
#line 545 "rygel-playbin-player.c"
		}
#line 419 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		case GST_MESSAGE_STATE_CHANGED:
#line 549 "rygel-playbin-player.c"
		{
			GstMessage* _tmp4_ = NULL;
			GstObject* _tmp5_ = NULL;
			GstElement* _tmp6_ = NULL;
#line 426 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
			_tmp4_ = message;
#line 426 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
			_tmp5_ = _tmp4_->src;
#line 426 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
			_tmp6_ = self->priv->_playbin;
#line 426 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
			if (_tmp5_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gst_object_get_type (), GstObject)) {
#line 562 "rygel-playbin-player.c"
				GstState old_state = 0;
				GstState new_state = 0;
				GstState pending = 0;
				GstMessage* _tmp7_ = NULL;
				GstState _tmp8_ = 0;
				GstState _tmp9_ = 0;
				GstState _tmp10_ = 0;
				gboolean _tmp11_ = FALSE;
				GstState _tmp12_ = 0;
				gboolean _tmp14_ = FALSE;
				gboolean _tmp29_ = FALSE;
				GstState _tmp30_ = 0;
				gboolean _tmp32_ = FALSE;
				gboolean _tmp34_ = FALSE;
				GstState _tmp35_ = 0;
				gboolean _tmp37_ = FALSE;
#line 429 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
				_tmp7_ = message;
#line 429 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
				gst_message_parse_state_changed (_tmp7_, &_tmp8_, &_tmp9_, &_tmp10_);
#line 429 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
				old_state = _tmp8_;
#line 429 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
				new_state = _tmp9_;
#line 429 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
				pending = _tmp10_;
#line 432 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
				_tmp12_ = old_state;
#line 432 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
				if (_tmp12_ == GST_STATE_READY) {
#line 593 "rygel-playbin-player.c"
					GstState _tmp13_ = 0;
#line 432 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					_tmp13_ = new_state;
#line 432 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					_tmp11_ = _tmp13_ == GST_STATE_PAUSED;
#line 599 "rygel-playbin-player.c"
				} else {
#line 432 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					_tmp11_ = FALSE;
#line 603 "rygel-playbin-player.c"
				}
#line 432 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
				_tmp14_ = _tmp11_;
#line 432 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
				if (_tmp14_) {
#line 609 "rygel-playbin-player.c"
					gboolean _tmp15_ = FALSE;
#line 433 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					_tmp15_ = self->priv->uri_update_hint;
#line 433 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					if (_tmp15_) {
#line 615 "rygel-playbin-player.c"
						gchar* uri = NULL;
						GstElement* _tmp16_ = NULL;
						gchar* _tmp17_ = NULL;
						gchar* _tmp18_ = NULL;
						gboolean _tmp19_ = FALSE;
						const gchar* _tmp20_ = NULL;
						const gchar* _tmp21_ = NULL;
						gboolean _tmp23_ = FALSE;
#line 434 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
						self->priv->uri_update_hint = FALSE;
#line 435 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
						_tmp16_ = self->priv->_playbin;
#line 435 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
						_tmp17_ = _dynamic_get_current_uri1 (_tmp16_);
#line 435 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
						_tmp18_ = _tmp17_;
#line 435 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
						uri = _tmp18_;
#line 436 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
						_tmp20_ = self->priv->_uri;
#line 436 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
						_tmp21_ = uri;
#line 436 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
						if (g_strcmp0 (_tmp20_, _tmp21_) != 0) {
#line 640 "rygel-playbin-player.c"
							const gchar* _tmp22_ = NULL;
#line 436 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
							_tmp22_ = uri;
#line 436 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
							_tmp19_ = g_strcmp0 (_tmp22_, "") != 0;
#line 646 "rygel-playbin-player.c"
						} else {
#line 436 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
							_tmp19_ = FALSE;
#line 650 "rygel-playbin-player.c"
						}
#line 436 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
						_tmp23_ = _tmp19_;
#line 436 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
						if (_tmp23_) {
#line 656 "rygel-playbin-player.c"
							GstElement* _tmp24_ = NULL;
							gchar* _tmp25_ = NULL;
							gchar* _tmp26_ = NULL;
							gchar* _tmp27_ = NULL;
							gchar* _tmp28_ = NULL;
#line 438 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
							_tmp24_ = self->priv->_playbin;
#line 438 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
							_tmp25_ = _dynamic_get_uri2 (_tmp24_);
#line 438 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
							_tmp26_ = _tmp25_;
#line 438 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
							_g_free0 (self->priv->_uri);
#line 438 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
							self->priv->_uri = _tmp26_;
#line 439 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
							g_object_notify ((GObject*) self, "uri");
#line 440 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
							_tmp27_ = rygel_playbin_player_generate_basic_didl (self);
#line 440 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
							_tmp28_ = _tmp27_;
#line 440 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
							rygel_media_player_set_metadata ((RygelMediaPlayer*) self, _tmp28_);
#line 440 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
							_g_free0 (_tmp28_);
#line 682 "rygel-playbin-player.c"
						}
#line 433 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
						_g_free0 (uri);
#line 686 "rygel-playbin-player.c"
					}
				}
#line 445 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
				_tmp30_ = pending;
#line 445 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
				if (_tmp30_ == GST_STATE_VOID_PENDING) {
#line 693 "rygel-playbin-player.c"
					gboolean _tmp31_ = FALSE;
#line 445 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					_tmp31_ = self->priv->buffering;
#line 445 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					_tmp29_ = !_tmp31_;
#line 699 "rygel-playbin-player.c"
				} else {
#line 445 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					_tmp29_ = FALSE;
#line 703 "rygel-playbin-player.c"
				}
#line 445 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
				_tmp32_ = _tmp29_;
#line 445 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
				if (_tmp32_) {
#line 709 "rygel-playbin-player.c"
					GstState _tmp33_ = 0;
#line 446 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					_tmp33_ = new_state;
#line 446 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					switch (_tmp33_) {
#line 446 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
						case GST_STATE_PAUSED:
#line 717 "rygel-playbin-player.c"
						{
#line 448 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
							rygel_media_player_set_playback_state ((RygelMediaPlayer*) self, "PAUSED_PLAYBACK");
#line 449 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
							break;
#line 723 "rygel-playbin-player.c"
						}
#line 446 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
						case GST_STATE_NULL:
#line 727 "rygel-playbin-player.c"
						{
#line 451 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
							rygel_media_player_set_playback_state ((RygelMediaPlayer*) self, "STOPPED");
#line 452 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
							break;
#line 733 "rygel-playbin-player.c"
						}
#line 446 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
						case GST_STATE_PLAYING:
#line 737 "rygel-playbin-player.c"
						{
#line 454 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
							rygel_media_player_set_playback_state ((RygelMediaPlayer*) self, "PLAYING");
#line 455 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
							break;
#line 743 "rygel-playbin-player.c"
						}
						default:
						{
#line 457 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
							break;
#line 749 "rygel-playbin-player.c"
						}
					}
				}
#line 461 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
				_tmp35_ = old_state;
#line 461 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
				if (_tmp35_ == GST_STATE_PAUSED) {
#line 757 "rygel-playbin-player.c"
					GstState _tmp36_ = 0;
#line 461 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					_tmp36_ = new_state;
#line 461 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					_tmp34_ = _tmp36_ == GST_STATE_PLAYING;
#line 763 "rygel-playbin-player.c"
				} else {
#line 461 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					_tmp34_ = FALSE;
#line 767 "rygel-playbin-player.c"
				}
#line 461 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
				_tmp37_ = _tmp34_;
#line 461 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
				if (_tmp37_) {
#line 462 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					self->priv->buffering = FALSE;
#line 463 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					rygel_media_player_set_playback_state ((RygelMediaPlayer*) self, "PLAYING");
#line 777 "rygel-playbin-player.c"
				}
			}
#line 466 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
			break;
#line 782 "rygel-playbin-player.c"
		}
#line 419 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		case GST_MESSAGE_BUFFERING:
#line 786 "rygel-playbin-player.c"
		{
			gboolean _tmp38_ = FALSE;
			gboolean _tmp39_ = FALSE;
			gboolean _tmp41_ = FALSE;
#line 469 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
			_tmp39_ = self->priv->is_live;
#line 469 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
			if (_tmp39_) {
#line 469 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
				_tmp38_ = TRUE;
#line 797 "rygel-playbin-player.c"
			} else {
				gboolean _tmp40_ = FALSE;
#line 469 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
				_tmp40_ = self->priv->foreign;
#line 469 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
				_tmp38_ = _tmp40_;
#line 804 "rygel-playbin-player.c"
			}
#line 469 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
			_tmp41_ = _tmp38_;
#line 469 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
			if (!_tmp41_) {
#line 810 "rygel-playbin-player.c"
				gint percent = 0;
				GstMessage* _tmp42_ = NULL;
				gint _tmp43_ = 0;
				gint _tmp44_ = 0;
#line 472 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
				_tmp42_ = message;
#line 472 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
				gst_message_parse_buffering (_tmp42_, &_tmp43_);
#line 472 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
				percent = _tmp43_;
#line 474 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
				_tmp44_ = percent;
#line 474 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
				if (_tmp44_ < 100) {
#line 825 "rygel-playbin-player.c"
					GstElement* _tmp45_ = NULL;
#line 475 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					self->priv->buffering = TRUE;
#line 476 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					_tmp45_ = self->priv->_playbin;
#line 476 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					gst_element_set_state (_tmp45_, GST_STATE_PAUSED);
#line 833 "rygel-playbin-player.c"
				} else {
					GstElement* _tmp46_ = NULL;
#line 478 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					_tmp46_ = self->priv->_playbin;
#line 478 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					gst_element_set_state (_tmp46_, GST_STATE_PLAYING);
#line 840 "rygel-playbin-player.c"
				}
			}
#line 481 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
			break;
#line 845 "rygel-playbin-player.c"
		}
#line 419 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		case GST_MESSAGE_CLOCK_LOST:
#line 849 "rygel-playbin-player.c"
		{
			gboolean _tmp47_ = FALSE;
#line 484 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
			_tmp47_ = self->priv->foreign;
#line 484 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
			if (!_tmp47_) {
#line 856 "rygel-playbin-player.c"
				GstElement* _tmp48_ = NULL;
				GstElement* _tmp49_ = NULL;
#line 485 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
				_tmp48_ = self->priv->_playbin;
#line 485 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
				gst_element_set_state (_tmp48_, GST_STATE_PAUSED);
#line 486 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
				_tmp49_ = self->priv->_playbin;
#line 486 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
				gst_element_set_state (_tmp49_, GST_STATE_PLAYING);
#line 867 "rygel-playbin-player.c"
			}
#line 488 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
			break;
#line 871 "rygel-playbin-player.c"
		}
#line 419 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		case GST_MESSAGE_EOS:
#line 875 "rygel-playbin-player.c"
		{
			gboolean _tmp50_ = FALSE;
#line 490 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
			_tmp50_ = rygel_playbin_player_is_rendering_image (self);
#line 490 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
			if (!_tmp50_) {
#line 491 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
				g_debug ("rygel-playbin-player.vala:491: EOS");
#line 492 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
				rygel_media_player_set_playback_state ((RygelMediaPlayer*) self, "EOS");
#line 886 "rygel-playbin-player.c"
			} else {
#line 494 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
				g_debug ("rygel-playbin-player.vala:494: Content is image, ignoring EOS");
#line 890 "rygel-playbin-player.c"
			}
#line 497 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
			break;
#line 894 "rygel-playbin-player.c"
		}
#line 419 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		case GST_MESSAGE_ERROR:
#line 898 "rygel-playbin-player.c"
		{
			GError* _error_ = NULL;
			gchar* debug_message = NULL;
			GstMessage* _tmp51_ = NULL;
			GError* _tmp52_ = NULL;
			gchar* _tmp53_ = NULL;
			GstElement* _tmp54_ = NULL;
			gchar* _tmp55_ = NULL;
			gchar* _tmp56_ = NULL;
			gchar* _tmp57_ = NULL;
			GError* _tmp58_ = NULL;
			const gchar* _tmp59_ = NULL;
			const gchar* _tmp60_ = NULL;
#line 502 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
			_tmp51_ = message;
#line 502 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
			gst_message_parse_error (_tmp51_, &_tmp52_, &_tmp53_);
#line 502 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
			_g_error_free0 (_error_);
#line 502 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
			_error_ = _tmp52_;
#line 502 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
			_g_free0 (debug_message);
#line 502 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
			debug_message = _tmp53_;
#line 504 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
			_tmp54_ = self->priv->_playbin;
#line 504 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
			g_object_get ((GstObject*) _tmp54_, "name", &_tmp55_, NULL);
#line 504 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
			_tmp56_ = _tmp55_;
#line 504 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
			_tmp57_ = _tmp56_;
#line 504 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
			_tmp58_ = _error_;
#line 504 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
			_tmp59_ = _tmp58_->message;
#line 504 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
			_tmp60_ = debug_message;
#line 504 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
			g_warning ("rygel-playbin-player.vala:504: Error from GStreamer element %s: %s (%s" \
")", _tmp57_, _tmp59_, _tmp60_);
#line 504 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
			_g_free0 (_tmp57_);
#line 508 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
			g_warning ("rygel-playbin-player.vala:508: Going to STOPPED state");
#line 510 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
			rygel_media_player_set_playback_state ((RygelMediaPlayer*) self, "STOPPED");
#line 512 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
			_g_free0 (debug_message);
#line 512 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
			_g_error_free0 (_error_);
#line 512 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
			break;
#line 952 "rygel-playbin-player.c"
		}
		default:
#line 419 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		break;
#line 957 "rygel-playbin-player.c"
	}
}


static inline void _dynamic_set_extra_headers3 (GstElement* obj, GstStructure* value) {
#line 524 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_object_set (obj, "extra-headers", value, NULL);
#line 965 "rygel-playbin-player.c"
}


static void rygel_playbin_player_on_source_setup (RygelPlaybinPlayer* self, GstElement* pipeline, GstElement* source) {
	gboolean _tmp0_ = FALSE;
	GstElement* _tmp1_ = NULL;
	GType _tmp2_ = 0UL;
	const gchar* _tmp3_ = NULL;
	gboolean _tmp5_ = FALSE;
#line 516 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_return_if_fail (self != NULL);
#line 516 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_return_if_fail (pipeline != NULL);
#line 516 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_return_if_fail (source != NULL);
#line 517 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp1_ = source;
#line 517 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp2_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp1_);
#line 517 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp3_ = g_type_name (_tmp2_);
#line 517 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	if (g_strcmp0 (_tmp3_, "GstSoupHTTPSrc") == 0) {
#line 989 "rygel-playbin-player.c"
		const gchar* _tmp4_ = NULL;
#line 518 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp4_ = self->priv->transfer_mode;
#line 518 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp0_ = _tmp4_ != NULL;
#line 995 "rygel-playbin-player.c"
	} else {
#line 517 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp0_ = FALSE;
#line 999 "rygel-playbin-player.c"
	}
#line 517 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp5_ = _tmp0_;
#line 517 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	if (_tmp5_) {
#line 1005 "rygel-playbin-player.c"
		const gchar* _tmp6_ = NULL;
		GstStructure* structure = NULL;
		GstStructure* _tmp7_ = NULL;
		GstStructure* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		GValue _tmp10_ = {0};
		GstElement* _tmp11_ = NULL;
		GstStructure* _tmp12_ = NULL;
#line 519 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp6_ = self->priv->transfer_mode;
#line 519 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		g_debug ("rygel-playbin-player.vala:519: Setting transfer mode to %s", _tmp6_);
#line 521 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp7_ = gst_structure_new_empty ("HTTPHeaders");
#line 521 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		structure = _tmp7_;
#line 522 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp8_ = structure;
#line 522 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp9_ = self->priv->transfer_mode;
#line 522 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		g_value_init (&_tmp10_, G_TYPE_STRING);
#line 522 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		g_value_set_string (&_tmp10_, _tmp9_);
#line 522 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		gst_structure_set_value (_tmp8_, "transferMode.dlna.org", &_tmp10_);
#line 522 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		G_IS_VALUE (&_tmp10_) ? (g_value_unset (&_tmp10_), NULL) : NULL;
#line 524 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp11_ = source;
#line 524 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp12_ = structure;
#line 524 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_dynamic_set_extra_headers3 (_tmp11_, _tmp12_);
#line 517 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_gst_structure_free0 (structure);
#line 1042 "rygel-playbin-player.c"
	}
}


static void rygel_playbin_player_on_uri_notify (RygelPlaybinPlayer* self, GParamSpec* pspec) {
#line 528 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_return_if_fail (self != NULL);
#line 528 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_return_if_fail (pspec != NULL);
#line 529 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	self->priv->uri_update_hint = TRUE;
#line 1054 "rygel-playbin-player.c"
}


/**
     * Generate basic DIDLLite information.
     *
     * This is used when the URI gets changed externally. DLNA requires that a
     * minimum DIDLLite is always present if the URI is not empty.
     */
static gchar* rygel_playbin_player_generate_basic_didl (RygelPlaybinPlayer* self) {
	gchar* result = NULL;
	GUPnPDIDLLiteWriter* writer = NULL;
	GUPnPDIDLLiteWriter* _tmp0_ = NULL;
	GUPnPDIDLLiteItem* item = NULL;
	GUPnPDIDLLiteItem* _tmp1_ = NULL;
	GUPnPDIDLLiteResource* resource = NULL;
	GUPnPDIDLLiteResource* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	GFile* file = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	GFile* _tmp7_ = NULL;
	GFile* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
#line 538 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 539 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp0_ = gupnp_didl_lite_writer_new (NULL);
#line 539 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	writer = _tmp0_;
#line 540 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp1_ = gupnp_didl_lite_writer_add_item (writer);
#line 540 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	item = _tmp1_;
#line 541 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	gupnp_didl_lite_object_set_id ((GUPnPDIDLLiteObject*) item, "1");
#line 542 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	gupnp_didl_lite_object_set_parent_id ((GUPnPDIDLLiteObject*) item, "-1");
#line 543 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	gupnp_didl_lite_object_set_upnp_class ((GUPnPDIDLLiteObject*) item, "object.item");
#line 544 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp2_ = gupnp_didl_lite_object_add_resource ((GUPnPDIDLLiteObject*) item);
#line 544 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	resource = _tmp2_;
#line 545 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp3_ = self->priv->_uri;
#line 545 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	gupnp_didl_lite_resource_set_uri (resource, _tmp3_);
#line 546 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp4_ = rygel_media_player_get_uri ((RygelMediaPlayer*) self);
#line 546 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp5_ = _tmp4_;
#line 546 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp6_ = _tmp5_;
#line 546 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp7_ = g_file_new_for_uri (_tmp6_);
#line 546 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp8_ = _tmp7_;
#line 546 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_g_free0 (_tmp6_);
#line 546 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	file = _tmp8_;
#line 547 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp9_ = g_file_get_basename (file);
#line 547 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp10_ = _tmp9_;
#line 547 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	gupnp_didl_lite_object_set_title ((GUPnPDIDLLiteObject*) item, _tmp10_);
#line 547 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_g_free0 (_tmp10_);
#line 549 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp11_ = gupnp_didl_lite_writer_get_string (writer);
#line 549 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	result = _tmp11_;
#line 549 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_g_object_unref0 (file);
#line 549 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_g_object_unref0 (resource);
#line 549 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_g_object_unref0 (item);
#line 549 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_g_object_unref0 (writer);
#line 549 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	return result;
#line 1142 "rygel-playbin-player.c"
}


static inline void _dynamic_set_auto_flush_bus4 (GstElement* obj, gboolean value) {
#line 557 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_object_set (obj, "auto-flush-bus", value, NULL);
#line 1149 "rygel-playbin-player.c"
}


static void _rygel_playbin_player_on_source_setup_dynamic_source_setup0_ (GstElement* _sender, GstElement* source, gpointer self) {
#line 560 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	rygel_playbin_player_on_source_setup (self, _sender, source);
#line 1156 "rygel-playbin-player.c"
}


gulong _dynamic_source_setup1_connect (gpointer obj, const char * signal_name, GCallback handler, gpointer data) {
#line 560 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	return g_signal_connect_object (obj, signal_name, handler, data, 0);
#line 1163 "rygel-playbin-player.c"
}


static void _rygel_playbin_player_on_uri_notify_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 561 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	rygel_playbin_player_on_uri_notify (self, pspec);
#line 1170 "rygel-playbin-player.c"
}


static void _rygel_playbin_player_bus_handler_gst_bus_message (GstBus* _sender, GstMessage* message, gpointer self) {
#line 566 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	rygel_playbin_player_bus_handler (self, _sender, message);
#line 1177 "rygel-playbin-player.c"
}


static void rygel_playbin_player_setup_playbin (RygelPlaybinPlayer* self) {
	GstElement* _tmp0_ = NULL;
	GstElement* _tmp1_ = NULL;
	GstElement* _tmp2_ = NULL;
	GstElement* _tmp3_ = NULL;
	GstBus* bus = NULL;
	GstElement* _tmp4_ = NULL;
	GstBus* _tmp5_ = NULL;
#line 552 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_return_if_fail (self != NULL);
#line 555 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	self->priv->is_live = FALSE;
#line 557 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp0_ = self->priv->_playbin;
#line 557 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_dynamic_set_auto_flush_bus4 (_tmp0_, FALSE);
#line 558 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp1_ = self->priv->_playbin;
#line 558 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_vala_assert (_tmp1_ != NULL, "this.playbin != null");
#line 560 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp2_ = self->priv->_playbin;
#line 560 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_dynamic_source_setup1_connect (_tmp2_, "source_setup", (GCallback) _rygel_playbin_player_on_source_setup_dynamic_source_setup0_, self);
#line 561 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp3_ = self->priv->_playbin;
#line 561 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_signal_connect_object ((GObject*) _tmp3_, "notify::uri", (GCallback) _rygel_playbin_player_on_uri_notify_g_object_notify, self, 0);
#line 564 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp4_ = self->priv->_playbin;
#line 564 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp5_ = gst_element_get_bus (_tmp4_);
#line 564 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	bus = _tmp5_;
#line 565 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	gst_bus_add_signal_watch_full (bus, G_PRIORITY_DEFAULT);
#line 566 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_signal_connect_object (bus, "message", (GCallback) _rygel_playbin_player_bus_handler_gst_bus_message, self, 0);
#line 552 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_g_object_unref0 (bus);
#line 1221 "rygel-playbin-player.c"
}


GstElement* rygel_playbin_player_get_playbin (RygelPlaybinPlayer* self) {
	GstElement* result;
	GstElement* _tmp0_ = NULL;
#line 91 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 91 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp0_ = self->priv->_playbin;
#line 91 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	result = _tmp0_;
#line 91 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	return result;
#line 1236 "rygel-playbin-player.c"
}


static void rygel_playbin_player_set_playbin (RygelPlaybinPlayer* self, GstElement* value) {
	GstElement* _tmp0_ = NULL;
	GstElement* _tmp1_ = NULL;
#line 91 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_return_if_fail (self != NULL);
#line 91 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp0_ = value;
#line 91 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 91 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_g_object_unref0 (self->priv->_playbin);
#line 91 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	self->priv->_playbin = _tmp1_;
#line 91 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_object_notify ((GObject *) self, "playbin");
#line 1255 "rygel-playbin-player.c"
}


static gchar* rygel_playbin_player_real_get_playback_state (RygelMediaPlayer* base) {
	gchar* result;
	RygelPlaybinPlayer* self;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 95 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	self = (RygelPlaybinPlayer*) base;
#line 96 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp0_ = self->priv->_playback_state;
#line 96 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 96 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	result = _tmp1_;
#line 96 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	return result;
#line 1274 "rygel-playbin-player.c"
}


static void rygel_playbin_player_real_set_playback_state (RygelMediaPlayer* base, const gchar* value) {
	RygelPlaybinPlayer* self;
	GstState state = 0;
	GstState pending = 0;
	GstElement* _tmp0_ = NULL;
	GstState _tmp1_ = 0;
	GstState _tmp2_ = 0;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	GQuark _tmp7_ = 0U;
#line 106 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	static GQuark _tmp6_label0 = 0;
#line 106 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	static GQuark _tmp6_label1 = 0;
#line 106 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	static GQuark _tmp6_label2 = 0;
#line 106 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	static GQuark _tmp6_label3 = 0;
#line 99 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	self = (RygelPlaybinPlayer*) base;
#line 102 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp0_ = self->priv->_playbin;
#line 102 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	gst_element_get_state (_tmp0_, &_tmp1_, &_tmp2_, (GstClockTime) GST_MSECOND);
#line 102 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	state = _tmp1_;
#line 102 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	pending = _tmp2_;
#line 104 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp3_ = value;
#line 104 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_debug ("rygel-playbin-player.vala:104: Changing playback state to %s.", _tmp3_);
#line 106 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp4_ = value;
#line 106 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp5_ = _tmp4_;
#line 106 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp7_ = (NULL == _tmp5_) ? 0 : g_quark_from_string (_tmp5_);
#line 106 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	if (_tmp7_ == ((0 != _tmp6_label0) ? _tmp6_label0 : (_tmp6_label0 = g_quark_from_static_string ("STOPPED")))) {
#line 106 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		switch (0) {
#line 1321 "rygel-playbin-player.c"
			default:
			{
				gboolean _tmp8_ = FALSE;
				GstState _tmp9_ = 0;
				gboolean _tmp11_ = FALSE;
#line 108 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
				_tmp9_ = state;
#line 108 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
				if (_tmp9_ != GST_STATE_NULL) {
#line 108 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					_tmp8_ = TRUE;
#line 1333 "rygel-playbin-player.c"
				} else {
					GstState _tmp10_ = 0;
#line 108 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					_tmp10_ = pending;
#line 108 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					_tmp8_ = _tmp10_ != GST_STATE_VOID_PENDING;
#line 1340 "rygel-playbin-player.c"
				}
#line 108 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
				_tmp11_ = _tmp8_;
#line 108 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
				if (_tmp11_) {
#line 1346 "rygel-playbin-player.c"
					gchar* _tmp12_ = NULL;
					GstElement* _tmp13_ = NULL;
#line 109 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					_tmp12_ = g_strdup ("TRANSITIONING");
#line 109 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					_g_free0 (self->priv->_playback_state);
#line 109 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					self->priv->_playback_state = _tmp12_;
#line 110 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					_tmp13_ = self->priv->_playbin;
#line 110 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					gst_element_set_state (_tmp13_, GST_STATE_NULL);
#line 1359 "rygel-playbin-player.c"
				} else {
					const gchar* _tmp14_ = NULL;
					gchar* _tmp15_ = NULL;
#line 112 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					_tmp14_ = value;
#line 112 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					_tmp15_ = g_strdup (_tmp14_);
#line 112 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					_g_free0 (self->priv->_playback_state);
#line 112 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					self->priv->_playback_state = _tmp15_;
#line 1371 "rygel-playbin-player.c"
				}
#line 114 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
				break;
#line 1375 "rygel-playbin-player.c"
			}
		}
	} else if (_tmp7_ == ((0 != _tmp6_label1) ? _tmp6_label1 : (_tmp6_label1 = g_quark_from_static_string ("PAUSED_PLAYBACK")))) {
#line 106 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		switch (0) {
#line 1381 "rygel-playbin-player.c"
			default:
			{
				gboolean _tmp16_ = FALSE;
				GstState _tmp17_ = 0;
				gboolean _tmp19_ = FALSE;
#line 116 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
				_tmp17_ = state;
#line 116 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
				if (_tmp17_ != GST_STATE_PAUSED) {
#line 116 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					_tmp16_ = TRUE;
#line 1393 "rygel-playbin-player.c"
				} else {
					GstState _tmp18_ = 0;
#line 116 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					_tmp18_ = pending;
#line 116 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					_tmp16_ = _tmp18_ != GST_STATE_VOID_PENDING;
#line 1400 "rygel-playbin-player.c"
				}
#line 116 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
				_tmp19_ = _tmp16_;
#line 116 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
				if (_tmp19_) {
#line 1406 "rygel-playbin-player.c"
					gchar* _tmp20_ = NULL;
					GstElement* _tmp21_ = NULL;
#line 117 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					_tmp20_ = g_strdup ("TRANSITIONING");
#line 117 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					_g_free0 (self->priv->_playback_state);
#line 117 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					self->priv->_playback_state = _tmp20_;
#line 118 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					_tmp21_ = self->priv->_playbin;
#line 118 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					gst_element_set_state (_tmp21_, GST_STATE_PAUSED);
#line 1419 "rygel-playbin-player.c"
				} else {
					const gchar* _tmp22_ = NULL;
					gchar* _tmp23_ = NULL;
#line 120 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					_tmp22_ = value;
#line 120 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					_tmp23_ = g_strdup (_tmp22_);
#line 120 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					_g_free0 (self->priv->_playback_state);
#line 120 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					self->priv->_playback_state = _tmp23_;
#line 1431 "rygel-playbin-player.c"
				}
#line 122 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
				break;
#line 1435 "rygel-playbin-player.c"
			}
		}
	} else if (_tmp7_ == ((0 != _tmp6_label2) ? _tmp6_label2 : (_tmp6_label2 = g_quark_from_static_string ("PLAYING")))) {
#line 106 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		switch (0) {
#line 1441 "rygel-playbin-player.c"
			default:
			{
				gboolean _tmp24_ = FALSE;
				GstState _tmp25_ = 0;
				gboolean _tmp27_ = FALSE;
#line 124 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
				_tmp25_ = state;
#line 124 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
				if (_tmp25_ != GST_STATE_PLAYING) {
#line 124 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					_tmp24_ = TRUE;
#line 1453 "rygel-playbin-player.c"
				} else {
					GstState _tmp26_ = 0;
#line 125 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					_tmp26_ = pending;
#line 125 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					_tmp24_ = _tmp26_ != GST_STATE_VOID_PENDING;
#line 1460 "rygel-playbin-player.c"
				}
#line 124 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
				_tmp27_ = _tmp24_;
#line 124 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
				if (_tmp27_) {
#line 1466 "rygel-playbin-player.c"
					gchar* _tmp28_ = NULL;
					GstElement* _tmp29_ = NULL;
					GstStateChangeReturn _tmp30_ = 0;
#line 126 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					_tmp28_ = g_strdup ("TRANSITIONING");
#line 126 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					_g_free0 (self->priv->_playback_state);
#line 126 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					self->priv->_playback_state = _tmp28_;
#line 130 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					_tmp29_ = self->priv->_playbin;
#line 130 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					_tmp30_ = gst_element_set_state (_tmp29_, GST_STATE_PLAYING);
#line 130 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					self->priv->is_live = _tmp30_ == GST_STATE_CHANGE_NO_PREROLL;
#line 1482 "rygel-playbin-player.c"
				} else {
					const gchar* _tmp31_ = NULL;
					gchar* _tmp32_ = NULL;
#line 133 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					_tmp31_ = value;
#line 133 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					_tmp32_ = g_strdup (_tmp31_);
#line 133 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					_g_free0 (self->priv->_playback_state);
#line 133 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					self->priv->_playback_state = _tmp32_;
#line 1494 "rygel-playbin-player.c"
				}
#line 135 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
				break;
#line 1498 "rygel-playbin-player.c"
			}
		}
	} else if (_tmp7_ == ((0 != _tmp6_label3) ? _tmp6_label3 : (_tmp6_label3 = g_quark_from_static_string ("EOS")))) {
#line 106 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		switch (0) {
#line 1504 "rygel-playbin-player.c"
			default:
			{
				const gchar* _tmp33_ = NULL;
				gchar* _tmp34_ = NULL;
#line 137 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
				_tmp33_ = value;
#line 137 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
				_tmp34_ = g_strdup (_tmp33_);
#line 137 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
				_g_free0 (self->priv->_playback_state);
#line 137 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
				self->priv->_playback_state = _tmp34_;
#line 138 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
				break;
#line 1519 "rygel-playbin-player.c"
			}
		}
	} else {
#line 106 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		switch (0) {
#line 1525 "rygel-playbin-player.c"
			default:
			{
#line 140 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
				break;
#line 1530 "rygel-playbin-player.c"
			}
		}
	}
#line 99 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_object_notify ((GObject *) self, "playback-state");
#line 1536 "rygel-playbin-player.c"
}


static gchar** _vala_array_dup3 (gchar** self, int length) {
	gchar** result;
	int i;
#line 148 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	result = g_new0 (gchar*, length + 1);
#line 148 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	for (i = 0; i < length; i++) {
#line 1547 "rygel-playbin-player.c"
		gchar* _tmp0_ = NULL;
#line 148 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp0_ = g_strdup (self[i]);
#line 148 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		result[i] = _tmp0_;
#line 1553 "rygel-playbin-player.c"
	}
#line 148 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	return result;
#line 1557 "rygel-playbin-player.c"
}


static gchar** rygel_playbin_player_real_get_allowed_playback_speeds (RygelMediaPlayer* base, int* result_length1) {
	gchar** result;
	RygelPlaybinPlayer* self;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	gchar** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
#line 147 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	self = (RygelPlaybinPlayer*) base;
#line 148 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp0_ = self->priv->_allowed_playback_speeds;
#line 148 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp0__length1 = self->priv->_allowed_playback_speeds_length1;
#line 148 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup3 (_tmp0_, _tmp0__length1) : ((gpointer) _tmp0_);
#line 148 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp1__length1 = _tmp0__length1;
#line 148 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp2_ = _tmp1_;
#line 148 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp2__length1 = _tmp1__length1;
#line 148 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	if (result_length1) {
#line 148 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		*result_length1 = _tmp2__length1;
#line 1588 "rygel-playbin-player.c"
	}
#line 148 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	result = _tmp2_;
#line 148 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	return result;
#line 1594 "rygel-playbin-player.c"
}


static gchar* rygel_playbin_player_real_get_playback_speed (RygelMediaPlayer* base) {
	gchar* result;
	RygelPlaybinPlayer* self;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 154 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	self = (RygelPlaybinPlayer*) base;
#line 155 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp0_ = self->priv->_playback_speed;
#line 155 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 155 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	result = _tmp1_;
#line 155 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	return result;
#line 1613 "rygel-playbin-player.c"
}


static void rygel_playbin_player_real_set_playback_speed (RygelMediaPlayer* base, const gchar* value) {
	RygelPlaybinPlayer* self;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 158 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	self = (RygelPlaybinPlayer*) base;
#line 159 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp0_ = value;
#line 159 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 159 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_g_free0 (self->priv->_playback_speed);
#line 159 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	self->priv->_playback_speed = _tmp1_;
#line 158 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_object_notify ((GObject *) self, "playback-speed");
#line 1633 "rygel-playbin-player.c"
}


static gchar* rygel_playbin_player_real_get_uri (RygelMediaPlayer* base) {
	gchar* result;
	RygelPlaybinPlayer* self;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 168 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	self = (RygelPlaybinPlayer*) base;
#line 169 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp0_ = self->priv->_uri;
#line 169 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 169 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	result = _tmp1_;
#line 169 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	return result;
#line 1652 "rygel-playbin-player.c"
}


static inline void _dynamic_set_uri5 (GstElement* obj, const gchar* value) {
#line 175 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_object_set (obj, "uri", value, NULL);
#line 1659 "rygel-playbin-player.c"
}


static void rygel_playbin_player_real_set_uri (RygelMediaPlayer* base, const gchar* value) {
	RygelPlaybinPlayer* self;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	GstElement* _tmp2_ = NULL;
	GstElement* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp16_ = NULL;
#line 172 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	self = (RygelPlaybinPlayer*) base;
#line 173 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp0_ = value;
#line 173 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 173 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_g_free0 (self->priv->_uri);
#line 173 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	self->priv->_uri = _tmp1_;
#line 174 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp2_ = self->priv->_playbin;
#line 174 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	gst_element_set_state (_tmp2_, GST_STATE_READY);
#line 175 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp3_ = self->priv->_playbin;
#line 175 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp4_ = value;
#line 175 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_dynamic_set_uri5 (_tmp3_, _tmp4_);
#line 176 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp5_ = value;
#line 176 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	if (g_strcmp0 (_tmp5_, "") != 0) {
#line 1696 "rygel-playbin-player.c"
		const gchar* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		GQuark _tmp9_ = 0U;
#line 177 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		static GQuark _tmp8_label0 = 0;
#line 177 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		static GQuark _tmp8_label1 = 0;
#line 177 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		static GQuark _tmp8_label2 = 0;
#line 177 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		static GQuark _tmp8_label3 = 0;
#line 177 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		static GQuark _tmp8_label4 = 0;
#line 177 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp6_ = self->priv->_playback_state;
#line 177 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp7_ = _tmp6_;
#line 177 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp9_ = (NULL == _tmp7_) ? 0 : g_quark_from_string (_tmp7_);
#line 177 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		if (_tmp9_ == ((0 != _tmp8_label0) ? _tmp8_label0 : (_tmp8_label0 = g_quark_from_static_string ("NO_MEDIA_PRESENT")))) {
#line 177 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
			switch (0) {
#line 1720 "rygel-playbin-player.c"
				default:
				{
					gchar* _tmp10_ = NULL;
#line 179 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					_tmp10_ = g_strdup ("STOPPED");
#line 179 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					_g_free0 (self->priv->_playback_state);
#line 179 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					self->priv->_playback_state = _tmp10_;
#line 180 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					g_object_notify ((GObject*) self, "playback-state");
#line 181 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					break;
#line 1734 "rygel-playbin-player.c"
				}
			}
		} else if (_tmp9_ == ((0 != _tmp8_label1) ? _tmp8_label1 : (_tmp8_label1 = g_quark_from_static_string ("STOPPED")))) {
#line 177 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
			switch (0) {
#line 1740 "rygel-playbin-player.c"
				default:
				{
#line 183 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					break;
#line 1745 "rygel-playbin-player.c"
				}
			}
		} else if (_tmp9_ == ((0 != _tmp8_label2) ? _tmp8_label2 : (_tmp8_label2 = g_quark_from_static_string ("PAUSED_PLAYBACK")))) {
#line 177 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
			switch (0) {
#line 1751 "rygel-playbin-player.c"
				default:
				{
					GstElement* _tmp11_ = NULL;
					GstStateChangeReturn _tmp12_ = 0;
#line 185 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					_tmp11_ = self->priv->_playbin;
#line 185 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					_tmp12_ = gst_element_set_state (_tmp11_, GST_STATE_PAUSED);
#line 185 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					self->priv->is_live = _tmp12_ == GST_STATE_CHANGE_NO_PREROLL;
#line 187 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					break;
#line 1764 "rygel-playbin-player.c"
				}
			}
		} else if ((_tmp9_ == ((0 != _tmp8_label3) ? _tmp8_label3 : (_tmp8_label3 = g_quark_from_static_string ("EOS")))) || (_tmp9_ == ((0 != _tmp8_label4) ? _tmp8_label4 : (_tmp8_label4 = g_quark_from_static_string ("PLAYING"))))) {
#line 177 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
			switch (0) {
#line 1770 "rygel-playbin-player.c"
				default:
				{
					GstElement* _tmp13_ = NULL;
					GstStateChangeReturn _tmp14_ = 0;
#line 193 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					_tmp13_ = self->priv->_playbin;
#line 193 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					_tmp14_ = gst_element_set_state (_tmp13_, GST_STATE_PLAYING);
#line 193 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					self->priv->is_live = _tmp14_ == GST_STATE_CHANGE_NO_PREROLL;
#line 195 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					break;
#line 1783 "rygel-playbin-player.c"
				}
			}
		} else {
#line 177 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
			switch (0) {
#line 1789 "rygel-playbin-player.c"
				default:
				{
#line 197 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					break;
#line 1794 "rygel-playbin-player.c"
				}
			}
		}
	} else {
		gchar* _tmp15_ = NULL;
#line 200 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp15_ = g_strdup ("NO_MEDIA_PRESENT");
#line 200 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_g_free0 (self->priv->_playback_state);
#line 200 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		self->priv->_playback_state = _tmp15_;
#line 201 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		g_object_notify ((GObject*) self, "playback-state");
#line 1808 "rygel-playbin-player.c"
	}
#line 203 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp16_ = value;
#line 203 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_debug ("rygel-playbin-player.vala:203: URI set to %s.", _tmp16_);
#line 172 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_object_notify ((GObject *) self, "uri");
#line 1816 "rygel-playbin-player.c"
}


static gchar* rygel_playbin_player_real_get_mime_type (RygelMediaPlayer* base) {
	gchar* result;
	RygelPlaybinPlayer* self;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 209 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	self = (RygelPlaybinPlayer*) base;
#line 210 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp0_ = self->priv->_mime_type;
#line 210 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 210 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	result = _tmp1_;
#line 210 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	return result;
#line 1835 "rygel-playbin-player.c"
}


static void rygel_playbin_player_real_set_mime_type (RygelMediaPlayer* base, const gchar* value) {
	RygelPlaybinPlayer* self;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 213 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	self = (RygelPlaybinPlayer*) base;
#line 214 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp0_ = value;
#line 214 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 214 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_g_free0 (self->priv->_mime_type);
#line 214 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	self->priv->_mime_type = _tmp1_;
#line 213 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_object_notify ((GObject *) self, "mime-type");
#line 1855 "rygel-playbin-player.c"
}


static gchar* rygel_playbin_player_real_get_metadata (RygelMediaPlayer* base) {
	gchar* result;
	RygelPlaybinPlayer* self;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 220 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	self = (RygelPlaybinPlayer*) base;
#line 221 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp0_ = self->priv->_metadata;
#line 221 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 221 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	result = _tmp1_;
#line 221 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	return result;
#line 1874 "rygel-playbin-player.c"
}


static void rygel_playbin_player_real_set_metadata (RygelMediaPlayer* base, const gchar* value) {
	RygelPlaybinPlayer* self;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 224 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	self = (RygelPlaybinPlayer*) base;
#line 225 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp0_ = value;
#line 225 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 225 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_g_free0 (self->priv->_metadata);
#line 225 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	self->priv->_metadata = _tmp1_;
#line 224 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_object_notify ((GObject *) self, "metadata");
#line 1894 "rygel-playbin-player.c"
}


static gboolean rygel_playbin_player_real_get_can_seek (RygelMediaPlayer* base) {
	gboolean result;
	RygelPlaybinPlayer* self;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp6_ = FALSE;
#line 230 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	self = (RygelPlaybinPlayer*) base;
#line 231 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp1_ = self->priv->transfer_mode;
#line 231 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	if (g_strcmp0 (_tmp1_, RYGEL_PLAYBIN_PLAYER_TRANSFER_MODE_INTERACTIVE) != 0) {
#line 1910 "rygel-playbin-player.c"
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gboolean _tmp5_ = FALSE;
#line 232 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp2_ = rygel_media_player_get_mime_type ((RygelMediaPlayer*) self);
#line 232 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp3_ = _tmp2_;
#line 232 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp4_ = _tmp3_;
#line 232 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp5_ = g_str_has_prefix (_tmp4_, "image/");
#line 232 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp0_ = !_tmp5_;
#line 232 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_g_free0 (_tmp4_);
#line 1927 "rygel-playbin-player.c"
	} else {
#line 231 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp0_ = FALSE;
#line 1931 "rygel-playbin-player.c"
	}
#line 231 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp6_ = _tmp0_;
#line 231 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	result = _tmp6_;
#line 231 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	return result;
#line 1939 "rygel-playbin-player.c"
}


static gchar* rygel_playbin_player_real_get_content_features (RygelMediaPlayer* base) {
	gchar* result;
	RygelPlaybinPlayer* self;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 239 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	self = (RygelPlaybinPlayer*) base;
#line 240 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp0_ = self->priv->_content_features;
#line 240 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 240 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	result = _tmp1_;
#line 240 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	return result;
#line 1958 "rygel-playbin-player.c"
}


static void rygel_playbin_player_real_set_content_features (RygelMediaPlayer* base, const gchar* value) {
	RygelPlaybinPlayer* self;
	gchar* pi_string = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	const gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	GError * _inner_error_ = NULL;
#line 243 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	self = (RygelPlaybinPlayer*) base;
#line 244 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp0_ = rygel_media_player_get_mime_type ((RygelMediaPlayer*) self);
#line 244 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp1_ = _tmp0_;
#line 244 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp2_ = _tmp1_;
#line 244 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp3_ = value;
#line 244 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp4_ = g_strdup_printf (RYGEL_PLAYBIN_PLAYER_PROTOCOL_INFO_TEMPLATE, _tmp2_, _tmp3_);
#line 244 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp5_ = _tmp4_;
#line 244 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_g_free0 (_tmp2_);
#line 244 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	pi_string = _tmp5_;
#line 1992 "rygel-playbin-player.c"
	{
		GUPnPProtocolInfo* _tmp6_ = NULL;
		GUPnPProtocolInfo* _tmp7_ = NULL;
		GUPnPDLNAFlags flags = 0;
		GUPnPProtocolInfo* _tmp8_ = NULL;
		GUPnPDLNAFlags _tmp9_ = 0;
		GUPnPDLNAFlags _tmp10_ = 0;
		GUPnPDLNAFlags _tmp11_ = 0;
#line 247 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp7_ = gupnp_protocol_info_new_from_string (pi_string, &_inner_error_);
#line 247 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp6_ = _tmp7_;
#line 247 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		if (_inner_error_ != NULL) {
#line 2007 "rygel-playbin-player.c"
			goto __catch0_g_error;
		}
#line 247 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_g_object_unref0 (self->priv->protocol_info);
#line 247 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		self->priv->protocol_info = _tmp6_;
#line 248 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp8_ = self->priv->protocol_info;
#line 248 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp9_ = gupnp_protocol_info_get_dlna_flags (_tmp8_);
#line 248 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp10_ = _tmp9_;
#line 248 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		flags = _tmp10_;
#line 249 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp11_ = flags;
#line 249 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		if ((_tmp11_ & GUPNP_DLNA_FLAGS_INTERACTIVE_TRANSFER_MODE) == GUPNP_DLNA_FLAGS_INTERACTIVE_TRANSFER_MODE) {
#line 2026 "rygel-playbin-player.c"
			gchar* _tmp12_ = NULL;
#line 250 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
			_tmp12_ = g_strdup (RYGEL_PLAYBIN_PLAYER_TRANSFER_MODE_INTERACTIVE);
#line 250 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
			_g_free0 (self->priv->transfer_mode);
#line 250 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
			self->priv->transfer_mode = _tmp12_;
#line 2034 "rygel-playbin-player.c"
		} else {
			GUPnPDLNAFlags _tmp13_ = 0;
#line 251 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
			_tmp13_ = flags;
#line 251 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
			if ((_tmp13_ & GUPNP_DLNA_FLAGS_STREAMING_TRANSFER_MODE) == GUPNP_DLNA_FLAGS_STREAMING_TRANSFER_MODE) {
#line 2041 "rygel-playbin-player.c"
				gchar* _tmp14_ = NULL;
#line 252 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
				_tmp14_ = g_strdup (RYGEL_PLAYBIN_PLAYER_TRANSFER_MODE_STREAMING);
#line 252 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
				_g_free0 (self->priv->transfer_mode);
#line 252 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
				self->priv->transfer_mode = _tmp14_;
#line 2049 "rygel-playbin-player.c"
			} else {
#line 254 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
				_g_free0 (self->priv->transfer_mode);
#line 254 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
				self->priv->transfer_mode = NULL;
#line 2055 "rygel-playbin-player.c"
			}
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
#line 246 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_error_ = _inner_error_;
#line 246 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_inner_error_ = NULL;
#line 257 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_g_object_unref0 (self->priv->protocol_info);
#line 257 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		self->priv->protocol_info = NULL;
#line 258 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_g_free0 (self->priv->transfer_mode);
#line 258 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		self->priv->transfer_mode = NULL;
#line 246 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_g_error_free0 (_error_);
#line 2077 "rygel-playbin-player.c"
	}
	__finally0:
#line 246 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	if (_inner_error_ != NULL) {
#line 246 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_g_free0 (pi_string);
#line 246 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 246 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		g_clear_error (&_inner_error_);
#line 246 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		return;
#line 2090 "rygel-playbin-player.c"
	}
#line 260 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp15_ = value;
#line 260 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp16_ = g_strdup (_tmp15_);
#line 260 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_g_free0 (self->priv->_content_features);
#line 260 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	self->priv->_content_features = _tmp16_;
#line 243 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_g_free0 (pi_string);
#line 243 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_object_notify ((GObject *) self, "content-features");
#line 2104 "rygel-playbin-player.c"
}


static inline gdouble _dynamic_get_volume6 (GstElement* obj) {
	gdouble result;
#line 266 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_object_get (obj, "volume", &result, NULL);
#line 266 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	return result;
#line 2114 "rygel-playbin-player.c"
}


static gdouble rygel_playbin_player_real_get_volume (RygelMediaPlayer* base) {
	gdouble result;
	RygelPlaybinPlayer* self;
	GstElement* _tmp0_ = NULL;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
#line 265 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	self = (RygelPlaybinPlayer*) base;
#line 266 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp0_ = self->priv->_playbin;
#line 266 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp1_ = _dynamic_get_volume6 (_tmp0_);
#line 266 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp2_ = _tmp1_;
#line 266 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	result = _tmp2_;
#line 266 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	return result;
#line 2136 "rygel-playbin-player.c"
}


static inline void _dynamic_set_volume7 (GstElement* obj, gdouble value) {
#line 270 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_object_set (obj, "volume", value, NULL);
#line 2143 "rygel-playbin-player.c"
}


static void rygel_playbin_player_real_set_volume (RygelMediaPlayer* base, gdouble value) {
	RygelPlaybinPlayer* self;
	GstElement* _tmp0_ = NULL;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
#line 269 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	self = (RygelPlaybinPlayer*) base;
#line 270 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp0_ = self->priv->_playbin;
#line 270 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp1_ = value;
#line 270 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_dynamic_set_volume7 (_tmp0_, _tmp1_);
#line 271 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp2_ = value;
#line 271 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_debug ("rygel-playbin-player.vala:271: volume set to %f.", _tmp2_);
#line 269 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_object_notify ((GObject *) self, "volume");
#line 2166 "rygel-playbin-player.c"
}


static gint64 rygel_playbin_player_real_get_duration (RygelMediaPlayer* base) {
	gint64 result;
	RygelPlaybinPlayer* self;
	gint64 dur = 0LL;
	GstElement* _tmp0_ = NULL;
	gint64 _tmp1_ = 0LL;
	gboolean _tmp2_ = FALSE;
#line 276 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	self = (RygelPlaybinPlayer*) base;
#line 279 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp0_ = self->priv->_playbin;
#line 279 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp2_ = gst_element_query_duration (_tmp0_, GST_FORMAT_TIME, &_tmp1_);
#line 279 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	dur = _tmp1_;
#line 279 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	if (_tmp2_) {
#line 2187 "rygel-playbin-player.c"
		gint64 _tmp3_ = 0LL;
#line 280 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp3_ = dur;
#line 280 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		result = _tmp3_ / GST_USECOND;
#line 280 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		return result;
#line 2195 "rygel-playbin-player.c"
	} else {
#line 282 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		result = (gint64) 0;
#line 282 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		return result;
#line 2201 "rygel-playbin-player.c"
	}
}


static gint64 rygel_playbin_player_real_get_position (RygelMediaPlayer* base) {
	gint64 result;
	RygelPlaybinPlayer* self;
	gint64 pos = 0LL;
	GstElement* _tmp0_ = NULL;
	gint64 _tmp1_ = 0LL;
	gboolean _tmp2_ = FALSE;
#line 288 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	self = (RygelPlaybinPlayer*) base;
#line 291 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp0_ = self->priv->_playbin;
#line 291 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp2_ = gst_element_query_position (_tmp0_, GST_FORMAT_TIME, &_tmp1_);
#line 291 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	pos = _tmp1_;
#line 291 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	if (_tmp2_) {
#line 2223 "rygel-playbin-player.c"
		gint64 _tmp3_ = 0LL;
#line 292 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp3_ = pos;
#line 292 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		result = _tmp3_ / GST_USECOND;
#line 292 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		return result;
#line 2231 "rygel-playbin-player.c"
	} else {
#line 294 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		result = (gint64) 0;
#line 294 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		return result;
#line 2237 "rygel-playbin-player.c"
	}
}


GList* rygel_playbin_player_get_supported_profiles (RygelPlaybinPlayer* self) {
	GList* result;
	GList* _tmp0_ = NULL;
	GList* _tmp20_ = NULL;
#line 343 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 344 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp0_ = self->priv->_supported_profiles;
#line 344 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	if (_tmp0_ == NULL) {
#line 2252 "rygel-playbin-player.c"
		RygelRendererDLNAProfile* _tmp1_ = NULL;
		RygelRendererDLNAProfile* _tmp2_ = NULL;
		RygelRendererDLNAProfile* _tmp3_ = NULL;
		RygelRendererDLNAProfile* _tmp4_ = NULL;
		RygelRendererDLNAProfile* _tmp5_ = NULL;
		RygelRendererDLNAProfile* _tmp6_ = NULL;
		RygelRendererDLNAProfile* _tmp7_ = NULL;
		RygelRendererDLNAProfile* _tmp8_ = NULL;
		RygelRendererDLNAProfile* _tmp9_ = NULL;
		RygelRendererDLNAProfile* _tmp10_ = NULL;
		RygelRendererDLNAProfile* _tmp11_ = NULL;
		RygelRendererDLNAProfile* _tmp12_ = NULL;
		RygelRendererDLNAProfile* _tmp13_ = NULL;
		RygelRendererDLNAProfile* _tmp14_ = NULL;
		RygelRendererDLNAProfile* _tmp15_ = NULL;
		RygelRendererDLNAProfile* _tmp16_ = NULL;
		RygelRendererDLNAProfile* _tmp17_ = NULL;
		RygelRendererDLNAProfile* _tmp18_ = NULL;
		RygelRendererDLNAProfile* _tmp19_ = NULL;
#line 347 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		__g_list_free__rygel_renderer_dlna_profile_unref0_0 (self->priv->_supported_profiles);
#line 347 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		self->priv->_supported_profiles = NULL;
#line 350 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp1_ = rygel_renderer_dlna_profile_new ("JPEG_SM", "image/jpeg");
#line 350 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		self->priv->_supported_profiles = g_list_prepend (self->priv->_supported_profiles, _tmp1_);
#line 352 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp2_ = rygel_renderer_dlna_profile_new ("JPEG_MED", "image/jpeg");
#line 352 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		self->priv->_supported_profiles = g_list_prepend (self->priv->_supported_profiles, _tmp2_);
#line 354 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp3_ = rygel_renderer_dlna_profile_new ("JPEG_LRG", "image/jpeg");
#line 354 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		self->priv->_supported_profiles = g_list_prepend (self->priv->_supported_profiles, _tmp3_);
#line 356 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp4_ = rygel_renderer_dlna_profile_new ("PNG_LRG", "image/png");
#line 356 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		self->priv->_supported_profiles = g_list_prepend (self->priv->_supported_profiles, _tmp4_);
#line 360 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp5_ = rygel_renderer_dlna_profile_new ("MP3", "audio/mpeg");
#line 360 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		self->priv->_supported_profiles = g_list_prepend (self->priv->_supported_profiles, _tmp5_);
#line 362 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp6_ = rygel_renderer_dlna_profile_new ("MP3X", "audio/mpeg");
#line 362 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		self->priv->_supported_profiles = g_list_prepend (self->priv->_supported_profiles, _tmp6_);
#line 364 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp7_ = rygel_renderer_dlna_profile_new ("AAC_ADTS_320", "audio/vnd.dlna.adts");
#line 364 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		self->priv->_supported_profiles = g_list_prepend (self->priv->_supported_profiles, _tmp7_);
#line 367 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp8_ = rygel_renderer_dlna_profile_new ("AAC_ISO_320", "audio/mp4");
#line 367 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		self->priv->_supported_profiles = g_list_prepend (self->priv->_supported_profiles, _tmp8_);
#line 369 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp9_ = rygel_renderer_dlna_profile_new ("AAC_ISO_320", "audio/3gpp");
#line 369 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		self->priv->_supported_profiles = g_list_prepend (self->priv->_supported_profiles, _tmp9_);
#line 371 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp10_ = rygel_renderer_dlna_profile_new ("LPCM", "audio/l16;rate=44100;channels=2");
#line 371 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		self->priv->_supported_profiles = g_list_prepend (self->priv->_supported_profiles, _tmp10_);
#line 374 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp11_ = rygel_renderer_dlna_profile_new ("LPCM", "audio/l16;rate=44100;channels=1");
#line 374 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		self->priv->_supported_profiles = g_list_prepend (self->priv->_supported_profiles, _tmp11_);
#line 377 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp12_ = rygel_renderer_dlna_profile_new ("WMABASE", "audio/x-ms-wma");
#line 377 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		self->priv->_supported_profiles = g_list_prepend (self->priv->_supported_profiles, _tmp12_);
#line 379 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp13_ = rygel_renderer_dlna_profile_new ("WMAFULL", "audio/x-ms-wma");
#line 379 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		self->priv->_supported_profiles = g_list_prepend (self->priv->_supported_profiles, _tmp13_);
#line 381 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp14_ = rygel_renderer_dlna_profile_new ("WMAPRO", "audio/x-ms-wma");
#line 381 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		self->priv->_supported_profiles = g_list_prepend (self->priv->_supported_profiles, _tmp14_);
#line 385 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp15_ = rygel_renderer_dlna_profile_new ("MPEG_TS_SD_EU_ISO", "video/mpeg");
#line 385 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		self->priv->_supported_profiles = g_list_prepend (self->priv->_supported_profiles, _tmp15_);
#line 388 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp16_ = rygel_renderer_dlna_profile_new ("MPEG_TS_HD_EU_ISO", "video/mpeg");
#line 388 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		self->priv->_supported_profiles = g_list_prepend (self->priv->_supported_profiles, _tmp16_);
#line 391 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp17_ = rygel_renderer_dlna_profile_new ("MPEG_TS_SD_NA_ISO", "video/mpeg");
#line 391 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		self->priv->_supported_profiles = g_list_prepend (self->priv->_supported_profiles, _tmp17_);
#line 394 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp18_ = rygel_renderer_dlna_profile_new ("MPEG_TS_HD_NA_ISO", "video/mpeg");
#line 394 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		self->priv->_supported_profiles = g_list_prepend (self->priv->_supported_profiles, _tmp18_);
#line 397 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp19_ = rygel_renderer_dlna_profile_new ("AVC_MP4_BL_CIF15_AAC_520", "video/mp4");
#line 397 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		self->priv->_supported_profiles = g_list_prepend (self->priv->_supported_profiles, _tmp19_);
#line 2352 "rygel-playbin-player.c"
	}
#line 402 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp20_ = self->priv->_supported_profiles;
#line 402 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	result = _tmp20_;
#line 402 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	return result;
#line 2360 "rygel-playbin-player.c"
}


static void rygel_playbin_player_class_init (RygelPlaybinPlayerClass * klass) {
#line 36 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	rygel_playbin_player_parent_class = g_type_class_peek_parent (klass);
#line 36 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_type_class_add_private (klass, sizeof (RygelPlaybinPlayerPrivate));
#line 36 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_playbin_player_get_property;
#line 36 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_playbin_player_set_property;
#line 36 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_playbin_player_finalize;
#line 36 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLAYBIN_PLAYER_PLAYBIN, g_param_spec_object ("playbin", "playbin", "playbin", gst_element_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 36 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLAYBIN_PLAYER_PLAYBACK_STATE, g_param_spec_string ("playback-state", "playback-state", "playback-state", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 36 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLAYBIN_PLAYER_ALLOWED_PLAYBACK_SPEEDS, g_param_spec_boxed ("allowed-playback-speeds", "allowed-playback-speeds", "allowed-playback-speeds", G_TYPE_STRV, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 36 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLAYBIN_PLAYER_PLAYBACK_SPEED, g_param_spec_string ("playback-speed", "playback-speed", "playback-speed", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 36 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLAYBIN_PLAYER_URI, g_param_spec_string ("uri", "uri", "uri", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 36 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLAYBIN_PLAYER_MIME_TYPE, g_param_spec_string ("mime-type", "mime-type", "mime-type", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 36 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLAYBIN_PLAYER_METADATA, g_param_spec_string ("metadata", "metadata", "metadata", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 36 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLAYBIN_PLAYER_CAN_SEEK, g_param_spec_boolean ("can-seek", "can-seek", "can-seek", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 36 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLAYBIN_PLAYER_CONTENT_FEATURES, g_param_spec_string ("content-features", "content-features", "content-features", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 36 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLAYBIN_PLAYER_VOLUME, g_param_spec_double ("volume", "volume", "volume", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 36 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLAYBIN_PLAYER_DURATION, g_param_spec_int64 ("duration", "duration", "duration", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 36 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLAYBIN_PLAYER_POSITION, g_param_spec_int64 ("position", "position", "position", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 36 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLAYBIN_PLAYER_SUPPORTED_PROFILES, g_param_spec_pointer ("supported-profiles", "supported-profiles", "supported-profiles", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 2401 "rygel-playbin-player.c"
}


static void rygel_playbin_player_rygel_media_player_interface_init (RygelMediaPlayerIface * iface) {
#line 36 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	rygel_playbin_player_rygel_media_player_parent_iface = g_type_interface_peek_parent (iface);
#line 36 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	iface->seek = (gboolean (*)(RygelMediaPlayer*, gint64)) rygel_playbin_player_real_seek;
#line 36 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	iface->get_protocols = (gchar** (*)(RygelMediaPlayer*, int*)) rygel_playbin_player_real_get_protocols;
#line 36 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	iface->get_mime_types = (gchar** (*)(RygelMediaPlayer*, int*)) rygel_playbin_player_real_get_mime_types;
#line 36 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	iface->get_playback_state = rygel_playbin_player_real_get_playback_state;
#line 36 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	iface->set_playback_state = rygel_playbin_player_real_set_playback_state;
#line 36 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	iface->get_allowed_playback_speeds = rygel_playbin_player_real_get_allowed_playback_speeds;
#line 36 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	iface->get_playback_speed = rygel_playbin_player_real_get_playback_speed;
#line 36 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	iface->set_playback_speed = rygel_playbin_player_real_set_playback_speed;
#line 36 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	iface->get_uri = rygel_playbin_player_real_get_uri;
#line 36 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	iface->set_uri = rygel_playbin_player_real_set_uri;
#line 36 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	iface->get_mime_type = rygel_playbin_player_real_get_mime_type;
#line 36 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	iface->set_mime_type = rygel_playbin_player_real_set_mime_type;
#line 36 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	iface->get_metadata = rygel_playbin_player_real_get_metadata;
#line 36 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	iface->set_metadata = rygel_playbin_player_real_set_metadata;
#line 36 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	iface->get_can_seek = rygel_playbin_player_real_get_can_seek;
#line 36 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	iface->get_content_features = rygel_playbin_player_real_get_content_features;
#line 36 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	iface->set_content_features = rygel_playbin_player_real_set_content_features;
#line 36 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	iface->get_volume = rygel_playbin_player_real_get_volume;
#line 36 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	iface->set_volume = rygel_playbin_player_real_set_volume;
#line 36 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	iface->get_duration = rygel_playbin_player_real_get_duration;
#line 36 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	iface->get_position = rygel_playbin_player_real_get_position;
#line 2450 "rygel-playbin-player.c"
}


static void rygel_playbin_player_instance_init (RygelPlaybinPlayer * self) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
#line 36 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	self->priv = RYGEL_PLAYBIN_PLAYER_GET_PRIVATE (self);
#line 93 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp0_ = g_strdup ("NO_MEDIA_PRESENT");
#line 93 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	self->priv->_playback_state = _tmp0_;
#line 145 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp1_ = g_strdup ("1");
#line 145 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp2_ = g_new0 (gchar*, 1 + 1);
#line 145 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp2_[0] = _tmp1_;
#line 145 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	self->priv->_allowed_playback_speeds = _tmp2_;
#line 145 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	self->priv->_allowed_playback_speeds_length1 = 1;
#line 145 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	self->priv->__allowed_playback_speeds_size_ = self->priv->_allowed_playback_speeds_length1;
#line 152 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp3_ = g_strdup ("1");
#line 152 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	self->priv->_playback_speed = _tmp3_;
#line 163 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	self->priv->transfer_mode = NULL;
#line 165 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	self->priv->uri_update_hint = FALSE;
#line 166 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	self->priv->_uri = NULL;
#line 207 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp4_ = g_strdup ("");
#line 207 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	self->priv->_mime_type = _tmp4_;
#line 218 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp5_ = g_strdup ("");
#line 218 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	self->priv->_metadata = _tmp5_;
#line 236 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp6_ = g_strdup ("");
#line 236 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	self->priv->_content_features = _tmp6_;
#line 2502 "rygel-playbin-player.c"
}


static void rygel_playbin_player_finalize (GObject* obj) {
	RygelPlaybinPlayer * self;
#line 36 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_PLAYBIN_TYPE_PLAYER, RygelPlaybinPlayer);
#line 91 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_g_object_unref0 (self->priv->_playbin);
#line 93 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_g_free0 (self->priv->_playback_state);
#line 145 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	self->priv->_allowed_playback_speeds = (_vala_array_free (self->priv->_allowed_playback_speeds, self->priv->_allowed_playback_speeds_length1, (GDestroyNotify) g_free), NULL);
#line 152 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_g_free0 (self->priv->_playback_speed);
#line 163 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_g_free0 (self->priv->transfer_mode);
#line 166 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_g_free0 (self->priv->_uri);
#line 207 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_g_free0 (self->priv->_mime_type);
#line 218 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_g_free0 (self->priv->_metadata);
#line 236 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_g_free0 (self->priv->_content_features);
#line 237 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_g_object_unref0 (self->priv->protocol_info);
#line 341 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	__g_list_free__rygel_renderer_dlna_profile_unref0_0 (self->priv->_supported_profiles);
#line 36 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	G_OBJECT_CLASS (rygel_playbin_player_parent_class)->finalize (obj);
#line 2534 "rygel-playbin-player.c"
}


/**
 * Implementation of RygelMediaPlayer for GStreamer.
 *
 * This class is useful only when implementing Rygel plugins.
 */
GType rygel_playbin_player_get_type (void) {
	static volatile gsize rygel_playbin_player_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_playbin_player_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelPlaybinPlayerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_playbin_player_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelPlaybinPlayer), 0, (GInstanceInitFunc) rygel_playbin_player_instance_init, NULL };
		static const GInterfaceInfo rygel_media_player_info = { (GInterfaceInitFunc) rygel_playbin_player_rygel_media_player_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_playbin_player_type_id;
		rygel_playbin_player_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelPlaybinPlayer", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_playbin_player_type_id, RYGEL_TYPE_MEDIA_PLAYER, &rygel_media_player_info);
		g_once_init_leave (&rygel_playbin_player_type_id__volatile, rygel_playbin_player_type_id);
	}
	return rygel_playbin_player_type_id__volatile;
}


static void _vala_rygel_playbin_player_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelPlaybinPlayer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_PLAYBIN_TYPE_PLAYER, RygelPlaybinPlayer);
#line 36 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	switch (property_id) {
#line 36 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		case RYGEL_PLAYBIN_PLAYER_PLAYBIN:
#line 36 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		g_value_set_object (value, rygel_playbin_player_get_playbin (self));
#line 36 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		break;
#line 36 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		case RYGEL_PLAYBIN_PLAYER_PLAYBACK_STATE:
#line 36 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		g_value_take_string (value, rygel_media_player_get_playback_state ((RygelMediaPlayer*) self));
#line 36 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		break;
#line 36 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		case RYGEL_PLAYBIN_PLAYER_ALLOWED_PLAYBACK_SPEEDS:
#line 2576 "rygel-playbin-player.c"
		{
			int length;
#line 36 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
			g_value_take_boxed (value, rygel_media_player_get_allowed_playback_speeds ((RygelMediaPlayer*) self, &length));
#line 2581 "rygel-playbin-player.c"
		}
#line 36 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		break;
#line 36 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		case RYGEL_PLAYBIN_PLAYER_PLAYBACK_SPEED:
#line 36 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		g_value_take_string (value, rygel_media_player_get_playback_speed ((RygelMediaPlayer*) self));
#line 36 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		break;
#line 36 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		case RYGEL_PLAYBIN_PLAYER_URI:
#line 36 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		g_value_take_string (value, rygel_media_player_get_uri ((RygelMediaPlayer*) self));
#line 36 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		break;
#line 36 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		case RYGEL_PLAYBIN_PLAYER_MIME_TYPE:
#line 36 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		g_value_take_string (value, rygel_media_player_get_mime_type ((RygelMediaPlayer*) self));
#line 36 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		break;
#line 36 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		case RYGEL_PLAYBIN_PLAYER_METADATA:
#line 36 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		g_value_take_string (value, rygel_media_player_get_metadata ((RygelMediaPlayer*) self));
#line 36 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		break;
#line 36 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		case RYGEL_PLAYBIN_PLAYER_CAN_SEEK:
#line 36 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		g_value_set_boolean (value, rygel_media_player_get_can_seek ((RygelMediaPlayer*) self));
#line 36 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		break;
#line 36 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		case RYGEL_PLAYBIN_PLAYER_CONTENT_FEATURES:
#line 36 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		g_value_take_string (value, rygel_media_player_get_content_features ((RygelMediaPlayer*) self));
#line 36 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		break;
#line 36 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		case RYGEL_PLAYBIN_PLAYER_VOLUME:
#line 36 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		g_value_set_double (value, rygel_media_player_get_volume ((RygelMediaPlayer*) self));
#line 36 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		break;
#line 36 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		case RYGEL_PLAYBIN_PLAYER_DURATION:
#line 36 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		g_value_set_int64 (value, rygel_media_player_get_duration ((RygelMediaPlayer*) self));
#line 36 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		break;
#line 36 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		case RYGEL_PLAYBIN_PLAYER_POSITION:
#line 36 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		g_value_set_int64 (value, rygel_media_player_get_position ((RygelMediaPlayer*) self));
#line 36 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		break;
#line 36 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		case RYGEL_PLAYBIN_PLAYER_SUPPORTED_PROFILES:
#line 36 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		g_value_set_pointer (value, rygel_playbin_player_get_supported_profiles (self));
#line 36 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		break;
#line 2645 "rygel-playbin-player.c"
		default:
#line 36 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 36 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		break;
#line 2651 "rygel-playbin-player.c"
	}
}


static void _vala_rygel_playbin_player_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelPlaybinPlayer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_PLAYBIN_TYPE_PLAYER, RygelPlaybinPlayer);
#line 36 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	switch (property_id) {
#line 36 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		case RYGEL_PLAYBIN_PLAYER_PLAYBIN:
#line 36 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		rygel_playbin_player_set_playbin (self, g_value_get_object (value));
#line 36 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		break;
#line 36 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		case RYGEL_PLAYBIN_PLAYER_PLAYBACK_STATE:
#line 36 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		rygel_media_player_set_playback_state ((RygelMediaPlayer*) self, g_value_get_string (value));
#line 36 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		break;
#line 36 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		case RYGEL_PLAYBIN_PLAYER_PLAYBACK_SPEED:
#line 36 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		rygel_media_player_set_playback_speed ((RygelMediaPlayer*) self, g_value_get_string (value));
#line 36 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		break;
#line 36 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		case RYGEL_PLAYBIN_PLAYER_URI:
#line 36 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		rygel_media_player_set_uri ((RygelMediaPlayer*) self, g_value_get_string (value));
#line 36 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		break;
#line 36 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		case RYGEL_PLAYBIN_PLAYER_MIME_TYPE:
#line 36 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		rygel_media_player_set_mime_type ((RygelMediaPlayer*) self, g_value_get_string (value));
#line 36 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		break;
#line 36 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		case RYGEL_PLAYBIN_PLAYER_METADATA:
#line 36 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		rygel_media_player_set_metadata ((RygelMediaPlayer*) self, g_value_get_string (value));
#line 36 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		break;
#line 36 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		case RYGEL_PLAYBIN_PLAYER_CONTENT_FEATURES:
#line 36 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		rygel_media_player_set_content_features ((RygelMediaPlayer*) self, g_value_get_string (value));
#line 36 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		break;
#line 36 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		case RYGEL_PLAYBIN_PLAYER_VOLUME:
#line 36 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		rygel_media_player_set_volume ((RygelMediaPlayer*) self, g_value_get_double (value));
#line 36 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		break;
#line 2709 "rygel-playbin-player.c"
		default:
#line 36 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 36 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		break;
#line 2715 "rygel-playbin-player.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



