/* rygel-media-player.c generated by valac 0.20.1, the Vala compiler
 * generated from rygel-media-player.vala, do not modify */

/*
 * Copyright (C) 2008 OpenedHand Ltd.
 * Copyright (C) 2009,2010 Nokia Corporation.
 * Copyright (C) 2012 Intel Corporation.
 *
 * Author: Jorn Baayen <jorn@openedhand.com>
 *         Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>


#define RYGEL_TYPE_MEDIA_PLAYER (rygel_media_player_get_type ())
#define RYGEL_MEDIA_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_PLAYER, RygelMediaPlayer))
#define RYGEL_IS_MEDIA_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_PLAYER))
#define RYGEL_MEDIA_PLAYER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_MEDIA_PLAYER, RygelMediaPlayerIface))

typedef struct _RygelMediaPlayer RygelMediaPlayer;
typedef struct _RygelMediaPlayerIface RygelMediaPlayerIface;

struct _RygelMediaPlayerIface {
	GTypeInterface parent_iface;
	gboolean (*seek) (RygelMediaPlayer* self, gint64 time);
	gchar** (*get_protocols) (RygelMediaPlayer* self, int* result_length1);
	gchar** (*get_mime_types) (RygelMediaPlayer* self, int* result_length1);
	gchar* (*get_playback_state) (RygelMediaPlayer* self);
	void (*set_playback_state) (RygelMediaPlayer* self, const gchar* value);
	gchar** (*get_allowed_playback_speeds) (RygelMediaPlayer* self, int* result_length1);
	gchar* (*get_playback_speed) (RygelMediaPlayer* self);
	void (*set_playback_speed) (RygelMediaPlayer* self, const gchar* value);
	gchar* (*get_uri) (RygelMediaPlayer* self);
	void (*set_uri) (RygelMediaPlayer* self, const gchar* value);
	gdouble (*get_volume) (RygelMediaPlayer* self);
	void (*set_volume) (RygelMediaPlayer* self, gdouble value);
	gint64 (*get_duration) (RygelMediaPlayer* self);
	gchar* (*get_metadata) (RygelMediaPlayer* self);
	void (*set_metadata) (RygelMediaPlayer* self, const gchar* value);
	gchar* (*get_mime_type) (RygelMediaPlayer* self);
	void (*set_mime_type) (RygelMediaPlayer* self, const gchar* value);
	gboolean (*get_can_seek) (RygelMediaPlayer* self);
	gchar* (*get_content_features) (RygelMediaPlayer* self);
	void (*set_content_features) (RygelMediaPlayer* self, const gchar* value);
	gint64 (*get_position) (RygelMediaPlayer* self);
};



GType rygel_media_player_get_type (void) G_GNUC_CONST;
gboolean rygel_media_player_seek (RygelMediaPlayer* self, gint64 time);
gchar** rygel_media_player_get_protocols (RygelMediaPlayer* self, int* result_length1);
gchar** rygel_media_player_get_mime_types (RygelMediaPlayer* self, int* result_length1);
gchar* rygel_media_player_get_playback_state (RygelMediaPlayer* self);
void rygel_media_player_set_playback_state (RygelMediaPlayer* self, const gchar* value);
gchar** rygel_media_player_get_allowed_playback_speeds (RygelMediaPlayer* self, int* result_length1);
gchar* rygel_media_player_get_playback_speed (RygelMediaPlayer* self);
void rygel_media_player_set_playback_speed (RygelMediaPlayer* self, const gchar* value);
gchar* rygel_media_player_get_uri (RygelMediaPlayer* self);
void rygel_media_player_set_uri (RygelMediaPlayer* self, const gchar* value);
gdouble rygel_media_player_get_volume (RygelMediaPlayer* self);
void rygel_media_player_set_volume (RygelMediaPlayer* self, gdouble value);
gint64 rygel_media_player_get_duration (RygelMediaPlayer* self);
gchar* rygel_media_player_get_metadata (RygelMediaPlayer* self);
void rygel_media_player_set_metadata (RygelMediaPlayer* self, const gchar* value);
gchar* rygel_media_player_get_mime_type (RygelMediaPlayer* self);
void rygel_media_player_set_mime_type (RygelMediaPlayer* self, const gchar* value);
gboolean rygel_media_player_get_can_seek (RygelMediaPlayer* self);
gchar* rygel_media_player_get_content_features (RygelMediaPlayer* self);
void rygel_media_player_set_content_features (RygelMediaPlayer* self, const gchar* value);
gchar* rygel_media_player_get_duration_as_str (RygelMediaPlayer* self);
gchar* rygel_time_utils_time_to_string (gint64 time);
gint64 rygel_media_player_get_position (RygelMediaPlayer* self);
gchar* rygel_media_player_get_position_as_str (RygelMediaPlayer* self);


/**
     * Seek to a point in the current media that is
     * this many microseconds after the start.
     */
gboolean rygel_media_player_seek (RygelMediaPlayer* self, gint64 time) {
#line 95 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 95 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	return RYGEL_MEDIA_PLAYER_GET_INTERFACE (self)->seek (self, time);
#line 108 "rygel-media-player.c"
}


/**
     * Return the protocols supported by this renderer,
     * such as "http-get" and "rtsp".
     */
gchar** rygel_media_player_get_protocols (RygelMediaPlayer* self, int* result_length1) {
#line 101 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 101 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	return RYGEL_MEDIA_PLAYER_GET_INTERFACE (self)->get_protocols (self, result_length1);
#line 121 "rygel-media-player.c"
}


gchar** rygel_media_player_get_mime_types (RygelMediaPlayer* self, int* result_length1) {
#line 105 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 105 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	return RYGEL_MEDIA_PLAYER_GET_INTERFACE (self)->get_mime_types (self, result_length1);
#line 130 "rygel-media-player.c"
}


gchar* rygel_media_player_get_playback_state (RygelMediaPlayer* self) {
#line 36 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 36 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	return RYGEL_MEDIA_PLAYER_GET_INTERFACE (self)->get_playback_state (self);
#line 139 "rygel-media-player.c"
}


void rygel_media_player_set_playback_state (RygelMediaPlayer* self, const gchar* value) {
#line 36 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	g_return_if_fail (self != NULL);
#line 36 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	RYGEL_MEDIA_PLAYER_GET_INTERFACE (self)->set_playback_state (self, value);
#line 148 "rygel-media-player.c"
}


gchar** rygel_media_player_get_allowed_playback_speeds (RygelMediaPlayer* self, int* result_length1) {
#line 39 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 39 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	return RYGEL_MEDIA_PLAYER_GET_INTERFACE (self)->get_allowed_playback_speeds (self, result_length1);
#line 157 "rygel-media-player.c"
}


gchar* rygel_media_player_get_playback_speed (RygelMediaPlayer* self) {
#line 42 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 42 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	return RYGEL_MEDIA_PLAYER_GET_INTERFACE (self)->get_playback_speed (self);
#line 166 "rygel-media-player.c"
}


void rygel_media_player_set_playback_speed (RygelMediaPlayer* self, const gchar* value) {
#line 42 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	g_return_if_fail (self != NULL);
#line 42 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	RYGEL_MEDIA_PLAYER_GET_INTERFACE (self)->set_playback_speed (self, value);
#line 175 "rygel-media-player.c"
}


gchar* rygel_media_player_get_uri (RygelMediaPlayer* self) {
#line 45 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 45 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	return RYGEL_MEDIA_PLAYER_GET_INTERFACE (self)->get_uri (self);
#line 184 "rygel-media-player.c"
}


void rygel_media_player_set_uri (RygelMediaPlayer* self, const gchar* value) {
#line 45 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	g_return_if_fail (self != NULL);
#line 45 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	RYGEL_MEDIA_PLAYER_GET_INTERFACE (self)->set_uri (self, value);
#line 193 "rygel-media-player.c"
}


gdouble rygel_media_player_get_volume (RygelMediaPlayer* self) {
#line 48 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	g_return_val_if_fail (self != NULL, 0.0);
#line 48 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	return RYGEL_MEDIA_PLAYER_GET_INTERFACE (self)->get_volume (self);
#line 202 "rygel-media-player.c"
}


void rygel_media_player_set_volume (RygelMediaPlayer* self, gdouble value) {
#line 48 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	g_return_if_fail (self != NULL);
#line 48 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	RYGEL_MEDIA_PLAYER_GET_INTERFACE (self)->set_volume (self, value);
#line 211 "rygel-media-player.c"
}


gint64 rygel_media_player_get_duration (RygelMediaPlayer* self) {
#line 51 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	g_return_val_if_fail (self != NULL, 0LL);
#line 51 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	return RYGEL_MEDIA_PLAYER_GET_INTERFACE (self)->get_duration (self);
#line 220 "rygel-media-player.c"
}


gchar* rygel_media_player_get_metadata (RygelMediaPlayer* self) {
#line 58 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 58 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	return RYGEL_MEDIA_PLAYER_GET_INTERFACE (self)->get_metadata (self);
#line 229 "rygel-media-player.c"
}


void rygel_media_player_set_metadata (RygelMediaPlayer* self, const gchar* value) {
#line 58 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	g_return_if_fail (self != NULL);
#line 58 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	RYGEL_MEDIA_PLAYER_GET_INTERFACE (self)->set_metadata (self, value);
#line 238 "rygel-media-player.c"
}


gchar* rygel_media_player_get_mime_type (RygelMediaPlayer* self) {
#line 61 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 61 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	return RYGEL_MEDIA_PLAYER_GET_INTERFACE (self)->get_mime_type (self);
#line 247 "rygel-media-player.c"
}


void rygel_media_player_set_mime_type (RygelMediaPlayer* self, const gchar* value) {
#line 61 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	g_return_if_fail (self != NULL);
#line 61 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	RYGEL_MEDIA_PLAYER_GET_INTERFACE (self)->set_mime_type (self, value);
#line 256 "rygel-media-player.c"
}


gboolean rygel_media_player_get_can_seek (RygelMediaPlayer* self) {
#line 64 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 64 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	return RYGEL_MEDIA_PLAYER_GET_INTERFACE (self)->get_can_seek (self);
#line 265 "rygel-media-player.c"
}


gchar* rygel_media_player_get_content_features (RygelMediaPlayer* self) {
#line 72 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 72 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	return RYGEL_MEDIA_PLAYER_GET_INTERFACE (self)->get_content_features (self);
#line 274 "rygel-media-player.c"
}


void rygel_media_player_set_content_features (RygelMediaPlayer* self, const gchar* value) {
#line 72 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	g_return_if_fail (self != NULL);
#line 72 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	RYGEL_MEDIA_PLAYER_GET_INTERFACE (self)->set_content_features (self, value);
#line 283 "rygel-media-player.c"
}


gchar* rygel_media_player_get_duration_as_str (RygelMediaPlayer* self) {
	gchar* result;
	gint64 _tmp0_;
	gint64 _tmp1_;
	gchar* _tmp2_ = NULL;
#line 76 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 77 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	_tmp0_ = rygel_media_player_get_duration (self);
#line 77 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	_tmp1_ = _tmp0_;
#line 77 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	_tmp2_ = rygel_time_utils_time_to_string (_tmp1_);
#line 77 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	result = _tmp2_;
#line 77 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	return result;
#line 304 "rygel-media-player.c"
}


gint64 rygel_media_player_get_position (RygelMediaPlayer* self) {
#line 82 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	g_return_val_if_fail (self != NULL, 0LL);
#line 82 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	return RYGEL_MEDIA_PLAYER_GET_INTERFACE (self)->get_position (self);
#line 313 "rygel-media-player.c"
}


gchar* rygel_media_player_get_position_as_str (RygelMediaPlayer* self) {
	gchar* result;
	gint64 _tmp0_;
	gint64 _tmp1_;
	gchar* _tmp2_ = NULL;
#line 86 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 87 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	_tmp0_ = rygel_media_player_get_position (self);
#line 87 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	_tmp1_ = _tmp0_;
#line 87 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	_tmp2_ = rygel_time_utils_time_to_string (_tmp1_);
#line 87 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	result = _tmp2_;
#line 87 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	return result;
#line 334 "rygel-media-player.c"
}


static void rygel_media_player_base_init (RygelMediaPlayerIface * iface) {
#line 32 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	static gboolean initialized = FALSE;
#line 32 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	if (!initialized) {
#line 32 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
		initialized = TRUE;
#line 32 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
		g_object_interface_install_property (iface, g_param_spec_string ("playback-state", "playback-state", "playback-state", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 32 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
		g_object_interface_install_property (iface, g_param_spec_boxed ("allowed-playback-speeds", "allowed-playback-speeds", "allowed-playback-speeds", G_TYPE_STRV, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 32 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
		g_object_interface_install_property (iface, g_param_spec_string ("playback-speed", "playback-speed", "playback-speed", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 32 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
		g_object_interface_install_property (iface, g_param_spec_string ("uri", "uri", "uri", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 32 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
		g_object_interface_install_property (iface, g_param_spec_double ("volume", "volume", "volume", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 32 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
		g_object_interface_install_property (iface, g_param_spec_int64 ("duration", "duration", "duration", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 357 "rygel-media-player.c"
		/**
		     * A DIDLLite document describing the current media URI or null.
		     * The document is either the one received from a UPnP control point or
		     * one generated by the implementing class.
		     */
#line 32 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
		g_object_interface_install_property (iface, g_param_spec_string ("metadata", "metadata", "metadata", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 32 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
		g_object_interface_install_property (iface, g_param_spec_string ("mime-type", "mime-type", "mime-type", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 32 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
		g_object_interface_install_property (iface, g_param_spec_boolean ("can-seek", "can-seek", "can-seek", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 369 "rygel-media-player.c"
		/**
		     * The contents of the contentFeatures.dlna.org HTTP header,
		     * containing the 4th field of the protocol info for the current
		     * media URI. Or null if the header does not exist or the media
		     * does not have DLNA information attached.
		     */
#line 32 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
		g_object_interface_install_property (iface, g_param_spec_string ("content-features", "content-features", "content-features", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 32 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
		g_object_interface_install_property (iface, g_param_spec_int64 ("position", "position", "position", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 380 "rygel-media-player.c"
	}
}


/**
 * This interface maps UPnP AVTransport:2 methods to the plugin's specific implementation.
 *
 * This interface is useful only when implementing Rygel renderer plugins.
 * Instances of this interface are retrieved from
 * rygel_media_renderer_plugin_get_player().
 */
GType rygel_media_player_get_type (void) {
	static volatile gsize rygel_media_player_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_player_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaPlayerIface), (GBaseInitFunc) rygel_media_player_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType rygel_media_player_type_id;
		rygel_media_player_type_id = g_type_register_static (G_TYPE_INTERFACE, "RygelMediaPlayer", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (rygel_media_player_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&rygel_media_player_type_id__volatile, rygel_media_player_type_id);
	}
	return rygel_media_player_type_id__volatile;
}



