/* rygel-media-renderer-plugin.c generated by valac 0.20.1, the Vala compiler
 * generated from rygel-media-renderer-plugin.vala, do not modify */

/*
 * Copyright (C) 2008,2010 Nokia Corporation.
 * Copyright (C) 2012 Intel Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel-core.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <config.h>
#include <libgupnp/gupnp.h>


#define RYGEL_TYPE_MEDIA_RENDERER_PLUGIN (rygel_media_renderer_plugin_get_type ())
#define RYGEL_MEDIA_RENDERER_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_RENDERER_PLUGIN, RygelMediaRendererPlugin))
#define RYGEL_MEDIA_RENDERER_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_RENDERER_PLUGIN, RygelMediaRendererPluginClass))
#define RYGEL_IS_MEDIA_RENDERER_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_RENDERER_PLUGIN))
#define RYGEL_IS_MEDIA_RENDERER_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_RENDERER_PLUGIN))
#define RYGEL_MEDIA_RENDERER_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_RENDERER_PLUGIN, RygelMediaRendererPluginClass))

typedef struct _RygelMediaRendererPlugin RygelMediaRendererPlugin;
typedef struct _RygelMediaRendererPluginClass RygelMediaRendererPluginClass;
typedef struct _RygelMediaRendererPluginPrivate RygelMediaRendererPluginPrivate;

#define RYGEL_TYPE_MEDIA_PLAYER (rygel_media_player_get_type ())
#define RYGEL_MEDIA_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_PLAYER, RygelMediaPlayer))
#define RYGEL_IS_MEDIA_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_PLAYER))
#define RYGEL_MEDIA_PLAYER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_MEDIA_PLAYER, RygelMediaPlayerIface))

typedef struct _RygelMediaPlayer RygelMediaPlayer;
typedef struct _RygelMediaPlayerIface RygelMediaPlayerIface;

#define RYGEL_TYPE_PLAYER_CONTROLLER (rygel_player_controller_get_type ())
#define RYGEL_PLAYER_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLAYER_CONTROLLER, RygelPlayerController))
#define RYGEL_PLAYER_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PLAYER_CONTROLLER, RygelPlayerControllerClass))
#define RYGEL_IS_PLAYER_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLAYER_CONTROLLER))
#define RYGEL_IS_PLAYER_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PLAYER_CONTROLLER))
#define RYGEL_PLAYER_CONTROLLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PLAYER_CONTROLLER, RygelPlayerControllerClass))

typedef struct _RygelPlayerController RygelPlayerController;
typedef struct _RygelPlayerControllerClass RygelPlayerControllerClass;

#define RYGEL_RENDERER_TYPE_DLNA_PROFILE (rygel_renderer_dlna_profile_get_type ())
#define RYGEL_RENDERER_DLNA_PROFILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_RENDERER_TYPE_DLNA_PROFILE, RygelRendererDLNAProfile))
#define RYGEL_RENDERER_DLNA_PROFILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_RENDERER_TYPE_DLNA_PROFILE, RygelRendererDLNAProfileClass))
#define RYGEL_RENDERER_IS_DLNA_PROFILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_RENDERER_TYPE_DLNA_PROFILE))
#define RYGEL_RENDERER_IS_DLNA_PROFILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_RENDERER_TYPE_DLNA_PROFILE))
#define RYGEL_RENDERER_DLNA_PROFILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_RENDERER_TYPE_DLNA_PROFILE, RygelRendererDLNAProfileClass))

typedef struct _RygelRendererDLNAProfile RygelRendererDLNAProfile;
typedef struct _RygelRendererDLNAProfileClass RygelRendererDLNAProfileClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __g_list_free__rygel_renderer_dlna_profile_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__rygel_renderer_dlna_profile_unref0_ (var), NULL)))

#define RYGEL_TYPE_SINK_CONNECTION_MANAGER (rygel_sink_connection_manager_get_type ())
#define RYGEL_SINK_CONNECTION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SINK_CONNECTION_MANAGER, RygelSinkConnectionManager))
#define RYGEL_SINK_CONNECTION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SINK_CONNECTION_MANAGER, RygelSinkConnectionManagerClass))
#define RYGEL_IS_SINK_CONNECTION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SINK_CONNECTION_MANAGER))
#define RYGEL_IS_SINK_CONNECTION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SINK_CONNECTION_MANAGER))
#define RYGEL_SINK_CONNECTION_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SINK_CONNECTION_MANAGER, RygelSinkConnectionManagerClass))

typedef struct _RygelSinkConnectionManager RygelSinkConnectionManager;
typedef struct _RygelSinkConnectionManagerClass RygelSinkConnectionManagerClass;

#define RYGEL_TYPE_AV_TRANSPORT (rygel_av_transport_get_type ())
#define RYGEL_AV_TRANSPORT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_AV_TRANSPORT, RygelAVTransport))
#define RYGEL_AV_TRANSPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_AV_TRANSPORT, RygelAVTransportClass))
#define RYGEL_IS_AV_TRANSPORT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_AV_TRANSPORT))
#define RYGEL_IS_AV_TRANSPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_AV_TRANSPORT))
#define RYGEL_AV_TRANSPORT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_AV_TRANSPORT, RygelAVTransportClass))

typedef struct _RygelAVTransport RygelAVTransport;
typedef struct _RygelAVTransportClass RygelAVTransportClass;
#define _rygel_resource_info_unref0(var) ((var == NULL) ? NULL : (var = (rygel_resource_info_unref (var), NULL)))

#define RYGEL_TYPE_RENDERING_CONTROL (rygel_rendering_control_get_type ())
#define RYGEL_RENDERING_CONTROL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_RENDERING_CONTROL, RygelRenderingControl))
#define RYGEL_RENDERING_CONTROL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_RENDERING_CONTROL, RygelRenderingControlClass))
#define RYGEL_IS_RENDERING_CONTROL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_RENDERING_CONTROL))
#define RYGEL_IS_RENDERING_CONTROL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_RENDERING_CONTROL))
#define RYGEL_RENDERING_CONTROL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_RENDERING_CONTROL, RygelRenderingControlClass))

typedef struct _RygelRenderingControl RygelRenderingControl;
typedef struct _RygelRenderingControlClass RygelRenderingControlClass;
typedef struct _RygelRendererDLNAProfilePrivate RygelRendererDLNAProfilePrivate;

struct _RygelMediaPlayerIface {
	GTypeInterface parent_iface;
	gboolean (*seek) (RygelMediaPlayer* self, gint64 time);
	gchar** (*get_protocols) (RygelMediaPlayer* self, int* result_length1);
	gchar** (*get_mime_types) (RygelMediaPlayer* self, int* result_length1);
	gchar* (*get_playback_state) (RygelMediaPlayer* self);
	void (*set_playback_state) (RygelMediaPlayer* self, const gchar* value);
	gchar** (*get_allowed_playback_speeds) (RygelMediaPlayer* self, int* result_length1);
	gchar* (*get_playback_speed) (RygelMediaPlayer* self);
	void (*set_playback_speed) (RygelMediaPlayer* self, const gchar* value);
	gchar* (*get_uri) (RygelMediaPlayer* self);
	void (*set_uri) (RygelMediaPlayer* self, const gchar* value);
	gdouble (*get_volume) (RygelMediaPlayer* self);
	void (*set_volume) (RygelMediaPlayer* self, gdouble value);
	gint64 (*get_duration) (RygelMediaPlayer* self);
	gchar* (*get_metadata) (RygelMediaPlayer* self);
	void (*set_metadata) (RygelMediaPlayer* self, const gchar* value);
	gchar* (*get_mime_type) (RygelMediaPlayer* self);
	void (*set_mime_type) (RygelMediaPlayer* self, const gchar* value);
	gboolean (*get_can_seek) (RygelMediaPlayer* self);
	gchar* (*get_content_features) (RygelMediaPlayer* self);
	void (*set_content_features) (RygelMediaPlayer* self, const gchar* value);
	gint64 (*get_position) (RygelMediaPlayer* self);
};

struct _RygelMediaRendererPlugin {
	RygelPlugin parent_instance;
	RygelMediaRendererPluginPrivate * priv;
};

struct _RygelMediaRendererPluginClass {
	RygelPluginClass parent_class;
	RygelMediaPlayer* (*get_player) (RygelMediaRendererPlugin* self);
};

struct _RygelMediaRendererPluginPrivate {
	gchar* sink_protocol_info;
	RygelPlayerController* controller;
	GList* _supported_profiles;
};

struct _RygelRendererDLNAProfile {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelRendererDLNAProfilePrivate * priv;
	gchar* mime;
	gchar* name;
};

struct _RygelRendererDLNAProfileClass {
	GTypeClass parent_class;
	void (*finalize) (RygelRendererDLNAProfile *self);
};


static gpointer rygel_media_renderer_plugin_parent_class = NULL;

GType rygel_media_renderer_plugin_get_type (void) G_GNUC_CONST;
GType rygel_media_player_get_type (void) G_GNUC_CONST;
GType rygel_player_controller_get_type (void) G_GNUC_CONST;
gpointer rygel_renderer_dlna_profile_ref (gpointer instance);
void rygel_renderer_dlna_profile_unref (gpointer instance);
GParamSpec* rygel_renderer_param_spec_dlna_profile (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_renderer_value_set_dlna_profile (GValue* value, gpointer v_object);
void rygel_renderer_value_take_dlna_profile (GValue* value, gpointer v_object);
gpointer rygel_renderer_value_get_dlna_profile (const GValue* value);
GType rygel_renderer_dlna_profile_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIA_RENDERER_PLUGIN_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_MEDIA_RENDERER_PLUGIN, RygelMediaRendererPluginPrivate))
enum  {
	RYGEL_MEDIA_RENDERER_PLUGIN_DUMMY_PROPERTY,
	RYGEL_MEDIA_RENDERER_PLUGIN_SUPPORTED_PROFILES
};
static void _rygel_renderer_dlna_profile_unref0_ (gpointer var);
static void _g_list_free__rygel_renderer_dlna_profile_unref0_ (GList* self);
#define RYGEL_MEDIA_RENDERER_PLUGIN_MEDIA_RENDERER_DESC_PATH DATA_DIR "/xml/MediaRenderer2.xml"
#define RYGEL_MEDIA_RENDERER_PLUGIN_DMR "urn:schemas-upnp-org:device:MediaRenderer"
RygelMediaRendererPlugin* rygel_media_renderer_plugin_new (const gchar* name, const gchar* title, const gchar* description, RygelPluginCapabilities capabilities);
RygelMediaRendererPlugin* rygel_media_renderer_plugin_construct (GType object_type, const gchar* name, const gchar* title, const gchar* description, RygelPluginCapabilities capabilities);
static void rygel_media_renderer_plugin_real_constructed (GObject* base);
GType rygel_sink_connection_manager_get_type (void) G_GNUC_CONST;
#define RYGEL_AV_TRANSPORT_UPNP_ID "urn:upnp-org:serviceId:AVTransport"
#define RYGEL_AV_TRANSPORT_UPNP_TYPE "urn:schemas-upnp-org:service:AVTransport:2"
#define RYGEL_AV_TRANSPORT_DESCRIPTION_PATH "xml/AVTransport2.xml"
GType rygel_av_transport_get_type (void) G_GNUC_CONST;
#define RYGEL_RENDERING_CONTROL_UPNP_ID "urn:upnp-org:serviceId:RenderingControl"
#define RYGEL_RENDERING_CONTROL_UPNP_TYPE "urn:schemas-upnp-org:service:RenderingControl:2"
#define RYGEL_RENDERING_CONTROL_DESCRIPTION_PATH "xml/RenderingControl2.xml"
GType rygel_rendering_control_get_type (void) G_GNUC_CONST;
RygelMediaPlayer* rygel_media_renderer_plugin_get_player (RygelMediaRendererPlugin* self);
static RygelMediaPlayer* rygel_media_renderer_plugin_real_get_player (RygelMediaRendererPlugin* self);
RygelPlayerController* rygel_media_renderer_plugin_get_controller (RygelMediaRendererPlugin* self);
gchar* rygel_media_renderer_plugin_get_protocol_info (RygelMediaRendererPlugin* self);
RygelPlayerController* rygel_player_controller_new (RygelMediaPlayer* player, const gchar* protocol_info);
RygelPlayerController* rygel_player_controller_construct (GType object_type, RygelMediaPlayer* player, const gchar* protocol_info);
static void rygel_media_renderer_plugin_real_apply_hacks (RygelPlugin* base, RygelRootDevice* device, const gchar* description_path, GError** error);
gchar** rygel_media_player_get_protocols (RygelMediaPlayer* self, int* result_length1);
GList* rygel_media_renderer_plugin_get_supported_profiles (RygelMediaRendererPlugin* self);
gchar** rygel_media_player_get_mime_types (RygelMediaPlayer* self, int* result_length1);
void rygel_media_renderer_plugin_set_supported_profiles (RygelMediaRendererPlugin* self, GList* value);
RygelRendererDLNAProfile* rygel_renderer_dlna_profile_new (const gchar* name, const gchar* mime);
RygelRendererDLNAProfile* rygel_renderer_dlna_profile_construct (GType object_type, const gchar* name, const gchar* mime);
static void rygel_media_renderer_plugin_finalize (GObject* obj);
static void _vala_rygel_media_renderer_plugin_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_media_renderer_plugin_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static void _rygel_renderer_dlna_profile_unref0_ (gpointer var) {
#line 44 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	(var == NULL) ? NULL : (var = (rygel_renderer_dlna_profile_unref (var), NULL));
#line 225 "rygel-media-renderer-plugin.c"
}


static void _g_list_free__rygel_renderer_dlna_profile_unref0_ (GList* self) {
#line 44 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	g_list_foreach (self, (GFunc) _rygel_renderer_dlna_profile_unref0_, NULL);
#line 44 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	g_list_free (self);
#line 234 "rygel-media-renderer-plugin.c"
}


/**
     * Create an instance of the plugin.
     *
     * @param name The non-human-readable name for the plugin and its renderer, used in UPnP messages and in the Rygel configuration file.
     * @param title An optional human-readable name (friendlyName) of the UPnP renderer provided by the plugin. If the title is empty then the name will be used.
     * @param description An optional human-readable description (modelDescription) of the UPnP renderer provided by the plugin.
     */
RygelMediaRendererPlugin* rygel_media_renderer_plugin_construct (GType object_type, const gchar* name, const gchar* title, const gchar* description, RygelPluginCapabilities capabilities) {
	RygelMediaRendererPlugin * self = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	RygelPluginCapabilities _tmp3_;
#line 74 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 79 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	_tmp0_ = name;
#line 79 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	_tmp1_ = title;
#line 79 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	_tmp2_ = description;
#line 79 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	_tmp3_ = capabilities;
#line 79 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	self = (RygelMediaRendererPlugin*) g_object_new (object_type, "desc-path", RYGEL_MEDIA_RENDERER_PLUGIN_MEDIA_RENDERER_DESC_PATH, "name", _tmp0_, "title", _tmp1_, "description", _tmp2_, "capabilities", _tmp3_, NULL);
#line 74 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	return self;
#line 265 "rygel-media-renderer-plugin.c"
}


RygelMediaRendererPlugin* rygel_media_renderer_plugin_new (const gchar* name, const gchar* title, const gchar* description, RygelPluginCapabilities capabilities) {
#line 74 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	return rygel_media_renderer_plugin_construct (RYGEL_TYPE_MEDIA_RENDERER_PLUGIN, name, title, description, capabilities);
#line 272 "rygel-media-renderer-plugin.c"
}


static void rygel_media_renderer_plugin_real_constructed (GObject* base) {
	RygelMediaRendererPlugin * self;
	RygelResourceInfo* _tmp0_;
	RygelResourceInfo* resource;
	RygelResourceInfo* _tmp1_;
	RygelResourceInfo* _tmp2_;
	RygelResourceInfo* _tmp3_;
	RygelResourceInfo* _tmp4_;
	RygelResourceInfo* _tmp5_;
#line 86 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	self = (RygelMediaRendererPlugin*) base;
#line 87 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	G_OBJECT_CLASS (rygel_media_renderer_plugin_parent_class)->constructed ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_PLUGIN, RygelPlugin));
#line 89 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	_tmp0_ = rygel_resource_info_new (RYGEL_CONNECTION_MANAGER_UPNP_ID, RYGEL_CONNECTION_MANAGER_UPNP_TYPE, RYGEL_CONNECTION_MANAGER_DESCRIPTION_PATH, RYGEL_TYPE_SINK_CONNECTION_MANAGER);
#line 89 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	resource = _tmp0_;
#line 93 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	_tmp1_ = resource;
#line 93 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	rygel_plugin_add_resource ((RygelPlugin*) self, _tmp1_);
#line 95 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	_tmp2_ = rygel_resource_info_new (RYGEL_AV_TRANSPORT_UPNP_ID, RYGEL_AV_TRANSPORT_UPNP_TYPE, RYGEL_AV_TRANSPORT_DESCRIPTION_PATH, RYGEL_TYPE_AV_TRANSPORT);
#line 95 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	_rygel_resource_info_unref0 (resource);
#line 95 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	resource = _tmp2_;
#line 99 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	_tmp3_ = resource;
#line 99 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	rygel_plugin_add_resource ((RygelPlugin*) self, _tmp3_);
#line 101 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	_tmp4_ = rygel_resource_info_new (RYGEL_RENDERING_CONTROL_UPNP_ID, RYGEL_RENDERING_CONTROL_UPNP_TYPE, RYGEL_RENDERING_CONTROL_DESCRIPTION_PATH, RYGEL_TYPE_RENDERING_CONTROL);
#line 101 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	_rygel_resource_info_unref0 (resource);
#line 101 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	resource = _tmp4_;
#line 105 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	_tmp5_ = resource;
#line 105 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	rygel_plugin_add_resource ((RygelPlugin*) self, _tmp5_);
#line 86 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	_rygel_resource_info_unref0 (resource);
#line 319 "rygel-media-renderer-plugin.c"
}


static RygelMediaPlayer* rygel_media_renderer_plugin_real_get_player (RygelMediaRendererPlugin* self) {
	RygelMediaPlayer* result = NULL;
#line 109 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	result = NULL;
#line 109 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	return result;
#line 329 "rygel-media-renderer-plugin.c"
}


RygelMediaPlayer* rygel_media_renderer_plugin_get_player (RygelMediaRendererPlugin* self) {
#line 108 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 108 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	return RYGEL_MEDIA_RENDERER_PLUGIN_GET_CLASS (self)->get_player (self);
#line 338 "rygel-media-renderer-plugin.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 118 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	return self ? g_object_ref (self) : NULL;
#line 345 "rygel-media-renderer-plugin.c"
}


RygelPlayerController* rygel_media_renderer_plugin_get_controller (RygelMediaRendererPlugin* self) {
	RygelPlayerController* result = NULL;
	RygelPlayerController* _tmp0_;
	RygelPlayerController* _tmp6_;
	RygelPlayerController* _tmp7_;
#line 112 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 113 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	_tmp0_ = self->priv->controller;
#line 113 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	if (_tmp0_ == NULL) {
#line 360 "rygel-media-renderer-plugin.c"
		RygelMediaPlayer* _tmp1_ = NULL;
		RygelMediaPlayer* _tmp2_;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_;
		RygelPlayerController* _tmp5_;
#line 114 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		_tmp1_ = rygel_media_renderer_plugin_get_player (self);
#line 114 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		_tmp2_ = _tmp1_;
#line 114 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		_tmp3_ = rygel_media_renderer_plugin_get_protocol_info (self);
#line 114 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		_tmp4_ = _tmp3_;
#line 114 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		_tmp5_ = rygel_player_controller_new (_tmp2_, _tmp4_);
#line 114 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		_g_object_unref0 (self->priv->controller);
#line 114 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		self->priv->controller = _tmp5_;
#line 114 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		_g_free0 (_tmp4_);
#line 114 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		_g_object_unref0 (_tmp2_);
#line 384 "rygel-media-renderer-plugin.c"
	}
#line 118 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	_tmp6_ = self->priv->controller;
#line 118 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	_tmp7_ = _g_object_ref0 (_tmp6_);
#line 118 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	result = _tmp7_;
#line 118 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	return result;
#line 394 "rygel-media-renderer-plugin.c"
}


static void rygel_media_renderer_plugin_real_apply_hacks (RygelPlugin* base, RygelRootDevice* device, const gchar* description_path, GError** error) {
	RygelMediaRendererPlugin * self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar** _tmp3_ = NULL;
	gchar** services;
	gint services_length1;
	gint _services_size_;
	RygelV1Hacks* _tmp4_;
	RygelV1Hacks* v1_hacks;
	RygelRootDevice* _tmp5_;
	const gchar* _tmp6_;
	GError * _inner_error_ = NULL;
#line 121 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	self = (RygelMediaRendererPlugin*) base;
#line 121 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	g_return_if_fail (device != NULL);
#line 121 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	g_return_if_fail (description_path != NULL);
#line 124 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	_tmp0_ = g_strdup (RYGEL_AV_TRANSPORT_UPNP_TYPE);
#line 124 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	_tmp1_ = g_strdup (RYGEL_RENDERING_CONTROL_UPNP_TYPE);
#line 124 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	_tmp2_ = g_strdup (RYGEL_CONNECTION_MANAGER_UPNP_TYPE);
#line 124 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	_tmp3_ = g_new0 (gchar*, 3 + 1);
#line 124 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	_tmp3_[0] = _tmp0_;
#line 124 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	_tmp3_[1] = _tmp1_;
#line 124 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	_tmp3_[2] = _tmp2_;
#line 124 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	services = _tmp3_;
#line 124 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	services_length1 = 3;
#line 124 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	_services_size_ = services_length1;
#line 127 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	_tmp4_ = rygel_v1_hacks_new (RYGEL_MEDIA_RENDERER_PLUGIN_DMR, services, services_length1);
#line 127 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	v1_hacks = _tmp4_;
#line 128 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	_tmp5_ = device;
#line 128 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	_tmp6_ = description_path;
#line 128 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	rygel_v1_hacks_apply_on_device (v1_hacks, _tmp5_, _tmp6_, &_inner_error_);
#line 128 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	if (_inner_error_ != NULL) {
#line 128 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		g_propagate_error (error, _inner_error_);
#line 128 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		_g_object_unref0 (v1_hacks);
#line 128 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		services = (_vala_array_free (services, services_length1, (GDestroyNotify) g_free), NULL);
#line 128 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		return;
#line 458 "rygel-media-renderer-plugin.c"
	}
#line 121 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	_g_object_unref0 (v1_hacks);
#line 121 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	services = (_vala_array_free (services, services_length1, (GDestroyNotify) g_free), NULL);
#line 464 "rygel-media-renderer-plugin.c"
}


gchar* rygel_media_renderer_plugin_get_protocol_info (RygelMediaRendererPlugin* self) {
	gchar* result = NULL;
	RygelMediaPlayer* _tmp0_ = NULL;
	RygelMediaPlayer* player;
	RygelMediaPlayer* _tmp1_;
	const gchar* _tmp3_;
	const gchar* _tmp70_;
	gchar* _tmp71_;
#line 132 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 133 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	_tmp0_ = rygel_media_renderer_plugin_get_player (self);
#line 133 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	player = _tmp0_;
#line 134 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	_tmp1_ = player;
#line 134 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	if (_tmp1_ == NULL) {
#line 486 "rygel-media-renderer-plugin.c"
		gchar* _tmp2_;
#line 135 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		_tmp2_ = g_strdup ("");
#line 135 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		result = _tmp2_;
#line 135 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		_g_object_unref0 (player);
#line 135 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		return result;
#line 496 "rygel-media-renderer-plugin.c"
	}
#line 138 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	_tmp3_ = self->priv->sink_protocol_info;
#line 138 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	if (_tmp3_ == NULL) {
#line 502 "rygel-media-renderer-plugin.c"
		gchar* _tmp4_;
		RygelMediaPlayer* _tmp5_;
		gint _tmp6_ = 0;
		gchar** _tmp7_ = NULL;
		gchar** protocols;
		gint protocols_length1;
		gint _protocols_size_;
		gchar** _tmp8_;
		gint _tmp8__length1;
		RygelMediaPlayer* _tmp40_;
		gint _tmp41_ = 0;
		gchar** _tmp42_ = NULL;
		gchar** mime_types;
		gint mime_types_length1;
		gint _mime_types_size_;
		gchar** _tmp43_;
		gint _tmp43__length1;
#line 139 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		_tmp4_ = g_strdup ("");
#line 139 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		_g_free0 (self->priv->sink_protocol_info);
#line 139 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		self->priv->sink_protocol_info = _tmp4_;
#line 141 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		_tmp5_ = player;
#line 141 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		_tmp7_ = rygel_media_player_get_protocols (_tmp5_, &_tmp6_);
#line 141 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		protocols = _tmp7_;
#line 141 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		protocols_length1 = _tmp6_;
#line 141 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		_protocols_size_ = protocols_length1;
#line 143 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		_tmp8_ = protocols;
#line 143 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		_tmp8__length1 = protocols_length1;
#line 540 "rygel-media-renderer-plugin.c"
		{
			gchar** protocol_collection = NULL;
			gint protocol_collection_length1 = 0;
			gint _protocol_collection_size_ = 0;
			gint protocol_it = 0;
#line 143 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
			protocol_collection = _tmp8_;
#line 143 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
			protocol_collection_length1 = _tmp8__length1;
#line 143 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
			for (protocol_it = 0; protocol_it < _tmp8__length1; protocol_it = protocol_it + 1) {
#line 552 "rygel-media-renderer-plugin.c"
				gchar* _tmp9_;
				gchar* protocol = NULL;
#line 143 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
				_tmp9_ = g_strdup (protocol_collection[protocol_it]);
#line 143 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
				protocol = _tmp9_;
#line 559 "rygel-media-renderer-plugin.c"
				{
					gchar** _tmp10_;
					gint _tmp10__length1;
					const gchar* _tmp11_;
					const gchar* _tmp12_;
					GList* _tmp15_;
					GList* _tmp16_;
#line 144 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
					_tmp10_ = protocols;
#line 144 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
					_tmp10__length1 = protocols_length1;
#line 144 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
					_tmp11_ = _tmp10_[0];
#line 144 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
					_tmp12_ = protocol;
#line 144 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
					if (g_strcmp0 (_tmp11_, _tmp12_) != 0) {
#line 577 "rygel-media-renderer-plugin.c"
						const gchar* _tmp13_;
						gchar* _tmp14_;
#line 145 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
						_tmp13_ = self->priv->sink_protocol_info;
#line 145 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
						_tmp14_ = g_strconcat (_tmp13_, ",", NULL);
#line 145 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
						_g_free0 (self->priv->sink_protocol_info);
#line 145 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
						self->priv->sink_protocol_info = _tmp14_;
#line 588 "rygel-media-renderer-plugin.c"
					}
#line 148 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
					_tmp15_ = rygel_media_renderer_plugin_get_supported_profiles (self);
#line 148 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
					_tmp16_ = _tmp15_;
#line 594 "rygel-media-renderer-plugin.c"
					{
						GList* profile_collection = NULL;
						GList* profile_it = NULL;
#line 148 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
						profile_collection = _tmp16_;
#line 148 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
						for (profile_it = profile_collection; profile_it != NULL; profile_it = profile_it->next) {
#line 602 "rygel-media-renderer-plugin.c"
							RygelRendererDLNAProfile* profile = NULL;
#line 148 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
							profile = (RygelRendererDLNAProfile*) profile_it->data;
#line 606 "rygel-media-renderer-plugin.c"
							{
								GList* _tmp17_;
								GList* _tmp18_;
								gconstpointer _tmp19_;
								const gchar* _tmp20_;
								RygelRendererDLNAProfile* _tmp21_;
								const gchar* _tmp22_;
								const gchar* _tmp25_;
								const gchar* _tmp26_;
								gchar* _tmp27_;
								gchar* _tmp28_;
								RygelRendererDLNAProfile* _tmp29_;
								const gchar* _tmp30_;
								gchar* _tmp31_;
								gchar* _tmp32_;
								gchar* _tmp33_;
								gchar* _tmp34_;
								RygelRendererDLNAProfile* _tmp35_;
								const gchar* _tmp36_;
								gchar* _tmp37_;
								gchar* _tmp38_;
								gchar* _tmp39_;
#line 149 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
								_tmp17_ = rygel_media_renderer_plugin_get_supported_profiles (self);
#line 149 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
								_tmp18_ = _tmp17_;
#line 149 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
								_tmp19_ = _tmp18_->data;
#line 149 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
								_tmp20_ = ((RygelRendererDLNAProfile*) _tmp19_)->name;
#line 149 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
								_tmp21_ = profile;
#line 149 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
								_tmp22_ = _tmp21_->name;
#line 149 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
								if (g_strcmp0 (_tmp20_, _tmp22_) != 0) {
#line 643 "rygel-media-renderer-plugin.c"
									const gchar* _tmp23_;
									gchar* _tmp24_;
#line 150 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
									_tmp23_ = self->priv->sink_protocol_info;
#line 150 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
									_tmp24_ = g_strconcat (_tmp23_, ",", NULL);
#line 150 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
									_g_free0 (self->priv->sink_protocol_info);
#line 150 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
									self->priv->sink_protocol_info = _tmp24_;
#line 654 "rygel-media-renderer-plugin.c"
								}
#line 152 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
								_tmp25_ = self->priv->sink_protocol_info;
#line 152 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
								_tmp26_ = protocol;
#line 152 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
								_tmp27_ = g_strconcat (_tmp26_, ":*:", NULL);
#line 152 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
								_tmp28_ = _tmp27_;
#line 152 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
								_tmp29_ = profile;
#line 152 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
								_tmp30_ = _tmp29_->mime;
#line 152 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
								_tmp31_ = g_strconcat (_tmp28_, _tmp30_, NULL);
#line 152 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
								_tmp32_ = _tmp31_;
#line 152 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
								_tmp33_ = g_strconcat (_tmp32_, ":DLNA.ORG_PN=", NULL);
#line 152 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
								_tmp34_ = _tmp33_;
#line 152 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
								_tmp35_ = profile;
#line 152 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
								_tmp36_ = _tmp35_->name;
#line 152 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
								_tmp37_ = g_strconcat (_tmp34_, _tmp36_, NULL);
#line 152 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
								_tmp38_ = _tmp37_;
#line 152 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
								_tmp39_ = g_strconcat (_tmp25_, _tmp38_, NULL);
#line 152 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
								_g_free0 (self->priv->sink_protocol_info);
#line 152 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
								self->priv->sink_protocol_info = _tmp39_;
#line 152 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
								_g_free0 (_tmp38_);
#line 152 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
								_g_free0 (_tmp34_);
#line 152 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
								_g_free0 (_tmp32_);
#line 152 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
								_g_free0 (_tmp28_);
#line 698 "rygel-media-renderer-plugin.c"
							}
						}
					}
#line 143 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
					_g_free0 (protocol);
#line 704 "rygel-media-renderer-plugin.c"
				}
			}
		}
#line 158 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		_tmp40_ = player;
#line 158 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		_tmp42_ = rygel_media_player_get_mime_types (_tmp40_, &_tmp41_);
#line 158 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		mime_types = _tmp42_;
#line 158 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		mime_types_length1 = _tmp41_;
#line 158 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		_mime_types_size_ = mime_types_length1;
#line 160 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		_tmp43_ = protocols;
#line 160 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		_tmp43__length1 = protocols_length1;
#line 722 "rygel-media-renderer-plugin.c"
		{
			gchar** protocol_collection = NULL;
			gint protocol_collection_length1 = 0;
			gint _protocol_collection_size_ = 0;
			gint protocol_it = 0;
#line 160 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
			protocol_collection = _tmp43_;
#line 160 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
			protocol_collection_length1 = _tmp43__length1;
#line 160 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
			for (protocol_it = 0; protocol_it < _tmp43__length1; protocol_it = protocol_it + 1) {
#line 734 "rygel-media-renderer-plugin.c"
				gchar* _tmp44_;
				gchar* protocol = NULL;
#line 160 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
				_tmp44_ = g_strdup (protocol_collection[protocol_it]);
#line 160 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
				protocol = _tmp44_;
#line 741 "rygel-media-renderer-plugin.c"
				{
					gboolean _tmp45_ = FALSE;
					gchar** _tmp46_;
					gint _tmp46__length1;
					const gchar* _tmp47_;
					const gchar* _tmp48_;
					gboolean _tmp50_;
					gchar** _tmp53_;
					gint _tmp53__length1;
#line 161 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
					_tmp46_ = protocols;
#line 161 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
					_tmp46__length1 = protocols_length1;
#line 161 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
					_tmp47_ = _tmp46_[0];
#line 161 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
					_tmp48_ = protocol;
#line 161 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
					if (g_strcmp0 (_tmp47_, _tmp48_) != 0) {
#line 161 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
						_tmp45_ = TRUE;
#line 763 "rygel-media-renderer-plugin.c"
					} else {
						const gchar* _tmp49_;
#line 162 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
						_tmp49_ = self->priv->sink_protocol_info;
#line 162 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
						_tmp45_ = g_strcmp0 (_tmp49_, "") != 0;
#line 770 "rygel-media-renderer-plugin.c"
					}
#line 161 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
					_tmp50_ = _tmp45_;
#line 161 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
					if (_tmp50_) {
#line 776 "rygel-media-renderer-plugin.c"
						const gchar* _tmp51_;
						gchar* _tmp52_;
#line 163 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
						_tmp51_ = self->priv->sink_protocol_info;
#line 163 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
						_tmp52_ = g_strconcat (_tmp51_, ",", NULL);
#line 163 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
						_g_free0 (self->priv->sink_protocol_info);
#line 163 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
						self->priv->sink_protocol_info = _tmp52_;
#line 787 "rygel-media-renderer-plugin.c"
					}
#line 166 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
					_tmp53_ = mime_types;
#line 166 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
					_tmp53__length1 = mime_types_length1;
#line 793 "rygel-media-renderer-plugin.c"
					{
						gchar** mime_type_collection = NULL;
						gint mime_type_collection_length1 = 0;
						gint _mime_type_collection_size_ = 0;
						gint mime_type_it = 0;
#line 166 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
						mime_type_collection = _tmp53_;
#line 166 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
						mime_type_collection_length1 = _tmp53__length1;
#line 166 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
						for (mime_type_it = 0; mime_type_it < _tmp53__length1; mime_type_it = mime_type_it + 1) {
#line 805 "rygel-media-renderer-plugin.c"
							gchar* _tmp54_;
							gchar* mime_type = NULL;
#line 166 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
							_tmp54_ = g_strdup (mime_type_collection[mime_type_it]);
#line 166 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
							mime_type = _tmp54_;
#line 812 "rygel-media-renderer-plugin.c"
							{
								gchar** _tmp55_;
								gint _tmp55__length1;
								const gchar* _tmp56_;
								const gchar* _tmp57_;
								const gchar* _tmp60_;
								const gchar* _tmp61_;
								gchar* _tmp62_;
								gchar* _tmp63_;
								const gchar* _tmp64_;
								gchar* _tmp65_;
								gchar* _tmp66_;
								gchar* _tmp67_;
								gchar* _tmp68_;
								gchar* _tmp69_;
#line 167 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
								_tmp55_ = mime_types;
#line 167 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
								_tmp55__length1 = mime_types_length1;
#line 167 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
								_tmp56_ = _tmp55_[0];
#line 167 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
								_tmp57_ = mime_type;
#line 167 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
								if (g_strcmp0 (_tmp56_, _tmp57_) != 0) {
#line 838 "rygel-media-renderer-plugin.c"
									const gchar* _tmp58_;
									gchar* _tmp59_;
#line 168 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
									_tmp58_ = self->priv->sink_protocol_info;
#line 168 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
									_tmp59_ = g_strconcat (_tmp58_, ",", NULL);
#line 168 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
									_g_free0 (self->priv->sink_protocol_info);
#line 168 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
									self->priv->sink_protocol_info = _tmp59_;
#line 849 "rygel-media-renderer-plugin.c"
								}
#line 171 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
								_tmp60_ = self->priv->sink_protocol_info;
#line 171 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
								_tmp61_ = protocol;
#line 171 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
								_tmp62_ = g_strconcat (_tmp61_, ":*:", NULL);
#line 171 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
								_tmp63_ = _tmp62_;
#line 171 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
								_tmp64_ = mime_type;
#line 171 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
								_tmp65_ = g_strconcat (_tmp63_, _tmp64_, NULL);
#line 171 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
								_tmp66_ = _tmp65_;
#line 171 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
								_tmp67_ = g_strconcat (_tmp66_, ":*", NULL);
#line 171 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
								_tmp68_ = _tmp67_;
#line 171 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
								_tmp69_ = g_strconcat (_tmp60_, _tmp68_, NULL);
#line 171 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
								_g_free0 (self->priv->sink_protocol_info);
#line 171 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
								self->priv->sink_protocol_info = _tmp69_;
#line 171 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
								_g_free0 (_tmp68_);
#line 171 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
								_g_free0 (_tmp66_);
#line 171 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
								_g_free0 (_tmp63_);
#line 166 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
								_g_free0 (mime_type);
#line 883 "rygel-media-renderer-plugin.c"
							}
						}
					}
#line 160 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
					_g_free0 (protocol);
#line 889 "rygel-media-renderer-plugin.c"
				}
			}
		}
#line 138 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		mime_types = (_vala_array_free (mime_types, mime_types_length1, (GDestroyNotify) g_free), NULL);
#line 138 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		protocols = (_vala_array_free (protocols, protocols_length1, (GDestroyNotify) g_free), NULL);
#line 897 "rygel-media-renderer-plugin.c"
	}
#line 176 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	_tmp70_ = self->priv->sink_protocol_info;
#line 176 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	_tmp71_ = g_strdup (_tmp70_);
#line 176 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	result = _tmp71_;
#line 176 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	_g_object_unref0 (player);
#line 176 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	return result;
#line 909 "rygel-media-renderer-plugin.c"
}


GList* rygel_media_renderer_plugin_get_supported_profiles (RygelMediaRendererPlugin* self) {
	GList* result;
	GList* _tmp0_;
#line 49 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 50 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	_tmp0_ = self->priv->_supported_profiles;
#line 50 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	result = _tmp0_;
#line 50 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	return result;
#line 924 "rygel-media-renderer-plugin.c"
}


static gpointer _rygel_renderer_dlna_profile_ref0 (gpointer self) {
#line 57 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	return self ? rygel_renderer_dlna_profile_ref (self) : NULL;
#line 931 "rygel-media-renderer-plugin.c"
}


void rygel_media_renderer_plugin_set_supported_profiles (RygelMediaRendererPlugin* self, GList* value) {
	GList* _tmp0_;
#line 53 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	g_return_if_fail (self != NULL);
#line 54 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	__g_list_free__rygel_renderer_dlna_profile_unref0_0 (self->priv->_supported_profiles);
#line 54 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	self->priv->_supported_profiles = NULL;
#line 55 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	_tmp0_ = value;
#line 55 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	if (_tmp0_ != NULL) {
#line 947 "rygel-media-renderer-plugin.c"
		GList* _tmp1_;
		RygelRendererDLNAProfile* _tmp4_;
#line 56 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		_tmp1_ = value;
#line 952 "rygel-media-renderer-plugin.c"
		{
			GList* profile_collection = NULL;
			GList* profile_it = NULL;
#line 56 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
			profile_collection = _tmp1_;
#line 56 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
			for (profile_it = profile_collection; profile_it != NULL; profile_it = profile_it->next) {
#line 960 "rygel-media-renderer-plugin.c"
				RygelRendererDLNAProfile* profile = NULL;
#line 56 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
				profile = (RygelRendererDLNAProfile*) profile_it->data;
#line 964 "rygel-media-renderer-plugin.c"
				{
					RygelRendererDLNAProfile* _tmp2_;
					RygelRendererDLNAProfile* _tmp3_;
#line 57 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
					_tmp2_ = profile;
#line 57 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
					_tmp3_ = _rygel_renderer_dlna_profile_ref0 (_tmp2_);
#line 57 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
					self->priv->_supported_profiles = g_list_prepend (self->priv->_supported_profiles, _tmp3_);
#line 974 "rygel-media-renderer-plugin.c"
				}
			}
		}
#line 60 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		_tmp4_ = rygel_renderer_dlna_profile_new ("DIDL_S", "text/xml");
#line 60 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		self->priv->_supported_profiles = g_list_prepend (self->priv->_supported_profiles, _tmp4_);
#line 62 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		self->priv->_supported_profiles = g_list_reverse (self->priv->_supported_profiles);
#line 984 "rygel-media-renderer-plugin.c"
	}
#line 53 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	g_object_notify ((GObject *) self, "supported-profiles");
#line 988 "rygel-media-renderer-plugin.c"
}


static void rygel_media_renderer_plugin_class_init (RygelMediaRendererPluginClass * klass) {
#line 35 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	rygel_media_renderer_plugin_parent_class = g_type_class_peek_parent (klass);
#line 35 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	g_type_class_add_private (klass, sizeof (RygelMediaRendererPluginPrivate));
#line 35 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	G_OBJECT_CLASS (klass)->constructed = rygel_media_renderer_plugin_real_constructed;
#line 35 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	RYGEL_MEDIA_RENDERER_PLUGIN_CLASS (klass)->get_player = rygel_media_renderer_plugin_real_get_player;
#line 35 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	RYGEL_PLUGIN_CLASS (klass)->apply_hacks = rygel_media_renderer_plugin_real_apply_hacks;
#line 35 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_media_renderer_plugin_get_property;
#line 35 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_media_renderer_plugin_set_property;
#line 35 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_media_renderer_plugin_finalize;
#line 35 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_RENDERER_PLUGIN_SUPPORTED_PROFILES, g_param_spec_pointer ("supported-profiles", "supported-profiles", "supported-profiles", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 1011 "rygel-media-renderer-plugin.c"
}


static void rygel_media_renderer_plugin_instance_init (RygelMediaRendererPlugin * self) {
#line 35 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	self->priv = RYGEL_MEDIA_RENDERER_PLUGIN_GET_PRIVATE (self);
#line 1018 "rygel-media-renderer-plugin.c"
}


static void rygel_media_renderer_plugin_finalize (GObject* obj) {
	RygelMediaRendererPlugin * self;
#line 35 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_MEDIA_RENDERER_PLUGIN, RygelMediaRendererPlugin);
#line 41 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	_g_free0 (self->priv->sink_protocol_info);
#line 42 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	_g_object_unref0 (self->priv->controller);
#line 44 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	__g_list_free__rygel_renderer_dlna_profile_unref0_0 (self->priv->_supported_profiles);
#line 35 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	G_OBJECT_CLASS (rygel_media_renderer_plugin_parent_class)->finalize (obj);
#line 1034 "rygel-media-renderer-plugin.c"
}


/**
 * This is the base class for every Rygel UPnP renderer plugin.
 *
 * This class is useful when implementing Rygel renderer plugins.
 *
 * Renderer plugins should also implement their own #RygelMediaPlayer
 * and return an instance of it from their get_player() implementation.
 */
GType rygel_media_renderer_plugin_get_type (void) {
	static volatile gsize rygel_media_renderer_plugin_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_renderer_plugin_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaRendererPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_renderer_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaRendererPlugin), 0, (GInstanceInitFunc) rygel_media_renderer_plugin_instance_init, NULL };
		GType rygel_media_renderer_plugin_type_id;
		rygel_media_renderer_plugin_type_id = g_type_register_static (RYGEL_TYPE_PLUGIN, "RygelMediaRendererPlugin", &g_define_type_info, 0);
		g_once_init_leave (&rygel_media_renderer_plugin_type_id__volatile, rygel_media_renderer_plugin_type_id);
	}
	return rygel_media_renderer_plugin_type_id__volatile;
}


static void _vala_rygel_media_renderer_plugin_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelMediaRendererPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_MEDIA_RENDERER_PLUGIN, RygelMediaRendererPlugin);
#line 35 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	switch (property_id) {
#line 35 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		case RYGEL_MEDIA_RENDERER_PLUGIN_SUPPORTED_PROFILES:
#line 35 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		g_value_set_pointer (value, rygel_media_renderer_plugin_get_supported_profiles (self));
#line 35 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		break;
#line 1069 "rygel-media-renderer-plugin.c"
		default:
#line 35 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 35 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		break;
#line 1075 "rygel-media-renderer-plugin.c"
	}
}


static void _vala_rygel_media_renderer_plugin_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelMediaRendererPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_MEDIA_RENDERER_PLUGIN, RygelMediaRendererPlugin);
#line 35 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	switch (property_id) {
#line 35 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		case RYGEL_MEDIA_RENDERER_PLUGIN_SUPPORTED_PROFILES:
#line 35 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		rygel_media_renderer_plugin_set_supported_profiles (self, g_value_get_pointer (value));
#line 35 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		break;
#line 1091 "rygel-media-renderer-plugin.c"
		default:
#line 35 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 35 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		break;
#line 1097 "rygel-media-renderer-plugin.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



